/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import xtc.tree.GNode;
import xtc.tree.Printer;
import xtc.tree.Visitor;

public class TypedLambdaPrinter
extends Visitor {
    protected final Printer printer;

    public TypedLambdaPrinter(Printer printer) {
        this.printer = printer;
        printer.register(this);
    }

    public void visitApplication(GNode gNode) {
        boolean bl = gNode.getGeneric(0).hasName("Abstraction");
        if (bl) {
            this.printer.p('(');
        }
        this.printer.p(gNode.getNode(0));
        if (bl) {
            this.printer.p(')');
        }
        this.printer.p(' ');
        bl = gNode.getGeneric(1).hasName("Application");
        if (bl) {
            this.printer.p('(');
        }
        this.printer.p(gNode.getNode(1));
        if (bl) {
            this.printer.p(')');
        }
    }

    public void visitAbstraction(GNode gNode) {
        this.printer.p("\\ ").p(gNode.getNode(0)).p(" : ").p(gNode.getNode(1)).p(" . ").p(gNode.getNode(2));
    }

    public void visitIdentifier(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitIntegerConstant(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitStringConstant(GNode gNode) {
        String string = gNode.getString(0);
        string = string.substring(1, string.length() - 1);
        this.printer.p('\"').escape(string, 9).p('\"');
    }

    public void visitFunctionType(GNode gNode) {
        boolean bl = gNode.getGeneric(0).hasName("FunctionType");
        if (bl) {
            this.printer.p('(');
        }
        this.printer.p(gNode.getNode(0));
        if (bl) {
            this.printer.p(')');
        }
        this.printer.p(" -> ");
        this.printer.p(gNode.getNode(1));
    }

    public void visitIntegerType(GNode gNode) {
        this.printer.p("int");
    }

    public void visitStringType(GNode gNode) {
        this.printer.p("string");
    }
}

