/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import xtc.lang.CParser;
import xtc.lang.CPrinter;
import xtc.lang.JavaAnalyzer;
import xtc.lang.JavaEntities;
import xtc.lang.JavaExternalAnalyzer;
import xtc.parser.ParseException;
import xtc.parser.Result;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.type.AliasT;
import xtc.type.AnnotatedT;
import xtc.type.ClassT;
import xtc.type.InterfaceT;
import xtc.type.PackageT;
import xtc.type.Type;
import xtc.util.Runtime;
import xtc.util.SymbolTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaUnitTests
extends TestCase {
    public static final boolean IGNORE_MEANS_SKIP = true;

    public static String cAstToString(Node node) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        CPrinter cPrinter = new CPrinter(new Printer(charArrayWriter));
        cPrinter.dispatch(node);
        return charArrayWriter.toString();
    }

    public static String contractSpace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char c = '-';
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (Character.isWhitespace(c2)) {
                bl = true;
                continue;
            }
            if (bl) {
                if (Character.isJavaIdentifierPart(c) && Character.isJavaIdentifierPart(c2)) {
                    stringBuffer.append(' ');
                }
                bl = false;
            }
            stringBuffer.append(c2);
            c = c2;
        }
        return stringBuffer.toString();
    }

    private static void cParserRoundTrip(String string, String string2) throws Exception {
        GNode gNode = JavaUnitTests.cStringToAst(string, string2, null);
        String string3 = JavaUnitTests.cAstToString(gNode);
        JavaUnitTests.assertEquals((String)JavaUnitTests.contractSpace(string2), (String)JavaUnitTests.contractSpace(string3));
    }

    static File createTempFile(File file, String string, String string2) throws IOException {
        File file2 = new File(file, string);
        file2.getParentFile().mkdirs();
        if (file2.exists()) {
            file2.delete();
        }
        JavaUnitTests.assertTrue((boolean)file2.createNewFile());
        FileWriter fileWriter = new FileWriter(file2);
        fileWriter.write(string2);
        ((Writer)fileWriter).flush();
        ((Writer)fileWriter).close();
        return file2;
    }

    public static GNode cStringToAst(String string, String string2, Set<String> set) throws Exception {
        Class[] classArray = new Class[]{Integer.TYPE};
        Method method = CParser.class.getDeclaredMethod("p" + string, classArray);
        method.setAccessible(true);
        CParser cParser = new CParser(new StringReader(string2), "<input>", string2.length());
        cParser.yyState.start();
        if (null != set) {
            cParser.yyState.start();
            for (String object2 : set) {
                cParser.yyState.bind(object2, true);
            }
            cParser.yyState.commit();
        }
        Object[] objectArray = new Object[]{new Integer(0)};
        Result result2 = (Result)method.invoke((Object)cParser, objectArray);
        return (GNode)cParser.value(result2);
    }

    public static void dumpSymbolTable(SymbolTable symbolTable) {
        Printer printer = new Printer(System.out);
        symbolTable.root().dump(printer);
        printer.flush();
    }

    public static void enterPackageFile(SymbolTable symbolTable, String string, String string2) {
        JavaEntities.canonicalNameToPackage(symbolTable, string);
        symbolTable.enter(JavaEntities.packageNameToScopeName(string));
        symbolTable.enter(JavaEntities.fileNameToScopeName(string2));
    }

    static void javaAnalyzerTestConstant(String string, Object object, JavaAnalyzer javaAnalyzer) throws Exception {
        GNode gNode = JavaEntities.javaStringToAst("Expression", string, true);
        Type type2 = javaAnalyzer.dispatchRValue(gNode);
        JavaUnitTests.assertEquals((Object)object, (Object)type2.getConstant().getValue());
    }

    static void javaAnalyzerTestError(String string, String string2, String string3) throws Exception {
        JavaAnalyzer javaAnalyzer = new JavaAnalyzer(JavaUnitTests.newRuntime(), new SymbolTable());
        if (!"CompilationUnit".equals(string)) {
            JavaUnitTests.enterPackageFile(javaAnalyzer._table, "", "<input>");
        }
        JavaUnitTests.javaAnalyzerTestError(string, string2, string3, javaAnalyzer);
    }

    private static void javaAnalyzerTestError(String string, String string2, String string3, JavaAnalyzer javaAnalyzer) throws Exception {
        StringWriter stringWriter = new StringWriter();
        javaAnalyzer._runtime.setErrConsole(new Printer(stringWriter));
        GNode gNode = null;
        try {
            gNode = JavaEntities.javaStringToAst(string, string2, true);
        }
        catch (ParseException parseException) {
            javaAnalyzer._runtime.errConsole().pln(parseException.toString());
        }
        if (null != gNode) {
            javaAnalyzer.dispatch(gNode);
        }
        String string4 = stringWriter.toString();
        string4 = JavaUnitTests.stripPrefix(string4, "error:");
        string4 = JavaUnitTests.stripPrefix(string4, "Exception:");
        string4 = JavaUnitTests.stripSuffix(string4, "\n");
        string4 = string4.trim();
        JavaUnitTests.assertEquals((String)string3, (String)string4);
    }

    private static void javaAnalyzerTestUseDef(JavaAnalyzer javaAnalyzer, String string, String string2) throws Exception {
        Object object;
        GNode gNode = JavaEntities.javaStringToAst("Expression", string, true);
        javaAnalyzer.dispatch(gNode);
        Object object2 = gNode.hasName("CallExpression") ? (Type)gNode.getGeneric(3).getProperty("xtc.Constants.Type") : (JavaEntities.isConstantT((Type)(object = (Type)gNode.getProperty("xtc.Constants.Type"))) ? ((AnnotatedT)object).getType() : object);
        int n = string2.indexOf(91);
        object = -1 == n ? string2 : string2.substring(0, n);
        int n2 = -1 == n ? 0 : (string2.length() - n) / 2;
        Type type2 = (Type)javaAnalyzer._table.lookup((String)object);
        Type type3 = null != type2 ? JavaEntities.typeWithDimensions(type2, n2) : null;
        if (null == type3) {
            System.out.println("can't find \"" + string2 + "\" in ");
            JavaUnitTests.dumpSymbolTable(javaAnalyzer._table);
            System.out.println("u(" + JavaEntities.typeDeclString(javaAnalyzer._table, object2) + ")");
        }
        JavaUnitTests.assertNotNull((Object)type3);
        JavaUnitTests.assertEquals((Object)type3, (Object)object2);
    }

    static void javaParserTestRoundTrip(String string, String string2, String string3, boolean bl) throws Exception {
        String string4 = JavaEntities.unicodeUnescape(string2);
        GNode gNode = JavaEntities.javaStringToAst(string, string4, bl);
        String string5 = JavaEntities.javaAstToString(gNode);
        JavaUnitTests.assertEquals((String)JavaUnitTests.contractSpace(JavaEntities.unicodeUnescape(string3)), (String)JavaUnitTests.contractSpace(string5));
    }

    private static TestSuite makeSuiteJavaAnalyzerConstant() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "!true", BigInteger.ZERO));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "'\\100'", new Character('@')));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "'\\n'", new Character('\n')));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "'\\u0040'", new Character('@')));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "'a'!='b'", BigInteger.ONE));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "'a'=='b'", BigInteger.ZERO));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "'a'==97L", BigInteger.ONE));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "'b'", new Character('b')));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "(String)\"abc\"", "abc"));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "(boolean)true", BigInteger.ONE));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "(byte)'Y'", new Byte(89)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "(byte)72==72.0", BigInteger.ONE));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "(double)'\u789a'", new Double(30874.0)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "(float)12", new Float(12.0f)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "(int)'\\u789a'", new Integer(30874)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "(int)'\\uffff'", new Integer(65535)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "(long)12.34e5", new Long(1234000L)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "+12.34e5", new Double(1234000.0)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "-12345", new Integer(-12345)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, ".12", new Double(0.12)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "0123", new Integer(83)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "0==1?'T':'F'", new Character('F')));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "0l", new Long(0L)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "0x00f & 0x0ff", new Integer(15)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "0x00f ^ 0x0ff", new Integer(240)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "0x00f | 0x0ff", new Integer(255)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "0x0123456789abcdefL", new Long(81985529216486895L)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "0xCafeBabe", new Integer(-889275714)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "0xff==255", BigInteger.ONE));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "1+2+\" fiddlers\"", "3 fiddlers"));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "1-2", new Integer(-1)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "1-2-3", new Integer(-4)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "1.2/2", new Double(0.6)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "12 + 34", new Integer(46)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "12 + \"cd\"", "12cd"));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "12*3", new Integer(36)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "123", new Integer(123)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "2<2", BigInteger.ZERO));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "2<<4", new Integer(32)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "2<<4L", new Integer(32)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "2<=2", BigInteger.ONE));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "2==2.0", BigInteger.ONE));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "2L<'2'", BigInteger.ONE));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "2L<<4", new Long(32L)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "6.022137e+23D", new Double(6.022137E23)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "6.022137e+23f", new Float(6.022137E23f)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "97L-'a'", new Long(0L)));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "\"\\40\\100\"", " @"));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "\"a\\\"b\\nc\"", "a\"b\nc"));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "\"ab\"==\"ab\"", BigInteger.ONE));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "\"ab\" + \"cd\"", "abcd"));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "\"fiddlers \"+1+2", "fiddlers 12"));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "\"hello\"", "hello"));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "false", BigInteger.ZERO));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "false|true", BigInteger.ONE));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "true && false", BigInteger.ZERO));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "true ^ false", BigInteger.ONE));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "true || false", BigInteger.ONE));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "true", BigInteger.ONE));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "true&true", BigInteger.ONE));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "true?'T':'F'", new Character('T')));
        testSuite.addTest((Test)new JavaAnalyzerTestConstant(false, "true^false", BigInteger.ONE));
        return testSuite;
    }

    private static TestSuite makeSuiteJavaAnalyzerError() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "final class B extends p.A implements p.A.B{void f(){new B(){};}}", "", TempFile.cons("package p;public class A{public interface B{}}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "import p2.B;class C extends p1.A{void f(){new B(){};}}", "", TempFile.cons("package p1;public class A{public interface B{}}", "p1", "A", TempFile.cons("package p2;public final class B{}", "p2", "B", null))));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{static class B{interface C{}}void f(){class C{}new B(){class D implements C{}};}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{static void f(){class B{B(Object o){}void g(){Class c=Boolean.class;}}new B(new Object(){Class c=Byte.class;});}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{static void f(){class B{static final int i=1;}new Object(){class B{static final int i=2;}void g(int j){switch(j){case 0:case 1:case B.i:}}};}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{Object f(){abstract class D{}return new D(){};}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{static Object f(){abstract class D{}return new D(){};}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Expression", "new Cloneable(){}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Statement", "test: new Object(){void f(){int i;test:i=1;}};", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class A{int _a;A(int a){this._a=a;}}class B extends A{int _b;B(int a){this(a,0);}B(int a,int b){super(a);_b=b;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class C{C(String s){}private C(Integer i){}}class D extends C{D(){super(null);}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{C(int i){}}class D extends C{D(int i){super(i);}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{}class D extends C{D(){super();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class C{static class D{class E{}}static class F extends D.E{F(){(new D()).super();}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{A a=new A();static class A{private A(){}A(String s){}A(int i){this(null);}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{int _i;C(int i){_i=i;}C(){this(0);}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{void f(){return; int i;}}", "unreachable code"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{void f(){{return;};}}", "unreachable code"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Statement", "for(;false;);", "unreachable code"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class A{class B{}} class C{ A.B b=new A().new B();}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{class B{private B(){}}static class C extends B{}}", "no enclosing instance"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{class B{private B(){}}static{class C extends B{}}}", "no enclosing instance"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class C{int i;}class D extends C{Object o=int.super.i;}", "super doesn't work on primitive types"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class C{int i;}class D extends C{Object o=int[].super.i;}", "super doesn't work on array types"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class C{int i;}class D extends C{Object o=null.super.i;}", "super doesn't work on null"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{public static int v=0;class I{I(int i){}}static class D extends I{D(A a, int i){a.super(v=++i);}}public static void main(String[]args){try{new D(null,5);}catch(NullPointerException e){if(v==0)System.out.print(\"OK\");else System.out.print(\"bad\");return;}System.out.print(\"bad\");}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{int i;static class B extends A{private int i;}static class C extends B{int j=i;}}", "static reference to non-static field"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{private int f(){return 1;}static class B extends A{int i=f();}}", "static use of non-static method"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{int i=1; static class D{int j=i;}}", "static use of non-static field"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{private int i;static class D extends C{int j=i;}}", "static reference to non-static field"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{final int i;}", "uninitialized blank final"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{static final int i;}", "uninitialized blank final"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{final int x; class D{{x=1;}}}", "a blank final field of a lexically enclosing class can not be assigned"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{final int x; {x=1;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{int f(){}}", "missing return"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{int i=(i=1)+i;}", "use before def"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{int i=i;}", "use of uninitialized variable"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{int i=j;int j=1;}", "use before def"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{int j=i=1;final int i;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{static{int i=j;}static int j=1;}", "use before def"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "interface A{int i;}", "uninitialized field"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class B{final static int i;static{i=1;}}", "", TempFile.cons("interface A{int i=B.i;}", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class A{int b=C.d.length;}class C{static D[]d;private static class D{}}", "unknown or ambiguous name"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class B extends p.A implements p.A.B{void f(){new B();}}", "the inherited type shadows the current enclosing type", TempFile.cons("package p;public class A{public interface B{}}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class B extends p.A{Object i;int j=((p.A)this).i;}", "unknown or ambiguous name", TempFile.cons("package p;public class A{protected int i;}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class BB extends p.AA{interface B{void m()throws E2;}static abstract class C extends A implements B{}static abstract class D extends C{{m();try{((C)this).m();}catch(E2 e){}}}}", "", TempFile.cons("package p;public class AA{public static class E1 extends Exception{}public static class E2 extends Exception{}public static abstract class A{protected abstract void m()throws E1;}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class B{int j=p.A.i++;}", "not accessible", TempFile.cons("package p;public class A{protected static int i;}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class C{private C(){}}class D extends C{}", "super constructor not visible"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "interface B{int i=2;}class C extends p1.A implements B{}class D extends C{static int j=new D().i;}", "ambiguous name i", TempFile.cons("package p1;public class A{protected int i=1;}", "p1", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "interface B{void m(String s,Object o);}abstract class C extends p.A implements B{}abstract class D extends C{void f(){super.m(\"\",\"\");}}", "ambiguous", TempFile.cons("package p;public class A{protected void m(Object o,String s);}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "interface B{void m(String s,Object o);}abstract class C extends p.A implements B{}abstract class D extends C{void f(D d){d.m(\"\",\"\");}}", "ambiguous", TempFile.cons("package p;public class A{protected void m(Object o,String s){}}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "package A;import A.B.C;class B{private class C{}}", "not visible"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "package p2;public abstract class B extends p1.A{protected in m(){return 1;}}", "", TempFile.cons("package p1;public abstract class A{abstract int m();}abstract class C extends p2.B{int i=m();}", "p1", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{private int i;class D extends C{int j=this.i;}}", "unknown or ambiguous name"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class A{}class B{}", "duplicate package members", TempFile.cons("class A{}", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "package a;class b{}", "duplicate package members", TempFile.cons("package a.b;class C{}", "a", "b", "C", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "package p;class A{}class B{}", "duplicate package members", TempFile.cons("package p;class A{}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class C{C()throws Exception{}}class D extends C{}", "unhandled exception in default constructor"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class C{private C(){}}class D extends C{}", "can not access super constructor from default constructor"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class D{int i=p.C.i;}", "", TempFile.cons("package p;class A{int i;}interface B{int i=1;}public class C extends A implements B{}", "C", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class D{void m(p.C t){try{t.m();}catch(Exception e){}}}", "", TempFile.cons("package p;abstract class A}abstract void m();}interface B{void m()throws Exception;}public abstract class C extends A implements B{}", "p", "C", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "import p.A.C.*;class B extends D{}", "", TempFile.cons("package p;public class A{public int C;public int C(){return 0;}public static class C{public static class D{}}}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "import p1.*;import p2.*;class B extends A{}", "", TempFile.cons("package p1;class A{}", "p1", "A", TempFile.cons("package p2;public class A{}", "p2", "A", null))));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "interface B{int m();}abstract class C extends p1.A implements B{}", "", TempFile.cons("package p1;public abstract class A{abstract void m();}", "p1", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "package p;import p.A.*;class B implements I{}", "", TempFile.cons("package p;class A{interface I{}}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class A{class B{}}interface C{class B{}}class D extends A implements C{static Object o=new D.B();}", "ambiguous type"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class A{class C{}}interface B{class C{}}class D extends A implements B{D.C t;}", "ambiguous type"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class A{public void m(){}}interface B{void m();}class C extends A implements B{{m();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class A{static void f(int i){}}class B extends A{static void f(long l){}{f(0);}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class A{void f(String s){}}abstract class B extends A{void f(Object o){}{f(\"\");}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class E1 extends Exception{}class E2 extends Exception{}class E3 extends Exception{}abstract class A{public abstract void m()throws E1,E2;}interface B{void m()throws E2,E3;}abstract class C extends A implements B{{try{m();}catch(E1 e1){}catch(E2 e2){}}}", "jacks says it should fail, but it's no problem in eclipse"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "class E1 extends Exception{}class E2 extends Exception{}class E3 extends Exception{}abstract class A{public abstract void m()throws E1,E2;}interface B{void m()throws E2,E3;}abstract class C extends A implements B{{try{m();}catch(E2 e2){}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "import A.*;class A{class B{}}", "unresolved import"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "import foo.inexistsentclass;class A{}", "unknown import"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "import nonExistentPackage.*;class A{}", "package doesn't exist"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "interface A{Object clone()throws java.io.IOException;}abstract class B implements A{}", "incompatible exceptions"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "interface A{String toString();}class B implements A{}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "interface A{int clone();}abstract class B implements A{}", "conflicting return types"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "interface A{int i=1;}class B{int i=2;}class C extends B implements A{static int j=new C().i;}", "ambiguous"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "interface A{void f(String s);}abstract class B implements A{void f(Object o){}{f(\"\");}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "interface I{int f();}class C{void f(){}}abstract class D extends C implements I{}", "conflicting methods"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "interface I{void f();}class C{static void f(){}}abstract class D extends C implements I{}", "conflicting methods"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "CompilationUnit", "package A;import A.B;class B{}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{class B{int i;}class C extends B{class D{{i++;}}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{int i;class B{Object i;}class C extends B{void f(){i=null;}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{interface B{class C{}}class D{class C{}}class E extends D implements B{C c;}}", "ambiguous"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{interface B{void f();}class C{public void f(){}}class D extends C implements B{{f();}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{interface B{void f()throws Exception;}class C{public void f(){}}class D extends C implements B{}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{private static void f(){}static class B{B(){f();}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{static class B{static B t,u;}static class C extends B{static class t{static int u;}}void f(){C.t.u=null;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{static class B{static int i;}A t;int i=t.B.i;}", "not a field"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class A{static void f(){}static class B{B(){f();}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{Cloneable[][]s=(Cloneable[][])(Object)(Integer[])(Cloneable)(int[])null;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{int f()throws ClassNotFoundException{return 1;}int i=f();C()throws ClassNotFoundException{}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{int f()throws ClassNotFoundException{return 1;}{f();}C()throws ClassNotFoundException{}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{int i=1;{try{i++;throw new Exception();}catch(Exception i){}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{interface I1{void f();}interface I2{int f();}interface I3 extends I1,I2{}}", "return type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{interface I{}void f(I i){i.getClass();i.toString();i.equals(null);i.hashCode();try{i.wait();i.wait(1);i.wait(1,0);i.notifyAll();i.notify();}catch(Throwable t){}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{static class A{static class B{static int i=1;}}int j=new A().B.i;}", "B cannot be resolved"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{static final String[] a={\"b\",\"c\"};}", "initializer must be compile-time constant"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{void f(){int x=2;class D{int j=x;}}}", "non-local use of non-final local"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{void f(){try{throw new Exception();}finally{return;}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{void f(byte b)throws Exception{}void f(char c)throws Exception{}void f(int i){}void g(byte b){f(true?b:'0');f(false?b:'0');f(true?'0':b);f(false?'0':b);}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{void f(int x){class D{int j=x;}}}", "non-local use of non-final local"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{{if(true)throw new ClassNotFoundException();}C()throws ClassNotFoundException{}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{{if(true)throw new ClassNotFoundException();}C()throws Throwable{}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{{int i;for(int i;;);}}", "duplicate variable"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class D{static class A{interface B{}}static class B extends A{{new B();}}}", "cannot instantiate interface"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class E{class A{int i;}interface B{Object i=null;}class C extends A implements B{}class D extends C{int j=super.i;}}", "ambiguous"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "interface B{Class getClass();}", "cannot override final method"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "interface I{public int toString();}", "JLS 9.2: interface implicitly declares all methods of java.lang.Object"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Statement", "switch(123){case 0:class C{}break;case 1:new C();}", "unknown class"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", ";", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "abstract class B extends p1.A{protected int m(){return 1;}}", "", TempFile.cons("package p1;public abstract class A{abstract void m();}", "p1", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "abstract class D extends p.C{{m();}}", "", TempFile.cons("package p;interface B{void m();}public abstract class C implements B{}", "p", "C", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "abstract class D extends p.C{{try{m();}catch(Exception e){}}}", "", TempFile.cons("package p;abstract class A{abstract void m();}interface B{void m()throws Exception;}public abstract class C extends A implements B{}", "p", "C", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A extends B{}", "", TempFile.cons("class B{}", "B", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A extends p.B{}", "", TempFile.cons("package p;public class B{}", "p", "B", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A implements B{}", "unknown class or interface B"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{Object b=B.B_CONST;Object c=C.C_CONST;}", "", TempFile.cons("class B{static final Object B_CONST=B.class;}class C extends B{static final Object C_CONST=C.class;}", "B", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{class B{}}class C extends A{B b=null;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{class B{}}class C extends A{class D extends B{}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{private class B{}}class C extends A{A.B t;}", "unknown type A.B"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{private int x;}class B extends A{void f(){x=0;}}", "unknown or ambiguous name"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{private void f(){}}class B extends A{B(){super();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{private void f(){}}class B extends A{{f();}}", "no such method"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{protected class B{};}class C{Class d=A.B.class;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{public A(String s){}private A(Integer i){}}class B{Object o=new A(null);}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{public A(String x, String y){}private A(String x,char[] y){}}class B{Object o=new A(\"hi\", null);}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{public int f(String s){return 0;}private int f(Integer i){return 0;}}class B extends A{int i=new A().f(null);}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{static class B{void f(){g();}void g(){}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{static final String s=\"a\";}class B{void f(){class C extends A{void f(){s.toString();s.valueOf(1);}}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{static void f(){}static class B{static void g(){f();}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{static{String b=\"x\";b=\"y\";}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{void f()throws IOException{}}", "unknown class or interface IOException"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{void f()throws Throwable{finalize();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{void f(){Object o=new B();}}", "", TempFile.cons("class B{void f(){Object o=new A();}}", "B", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{void f(){new B();}private static class B{}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{void f(String s){s.getClass();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{void f(p.C x){x.m();}}", "", TempFile.cons("package p;interface B{void m();}public abstract class C implements B{}", "p", "C", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{{\"\".getClass();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class A{}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class B extends A{}", "", TempFile.cons("class A{C c;}class C extends B{}", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class B extends A{}", "", TempFile.cons("class A{}", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class B extends A{}", "", TempFile.cons("class \\u0041{}", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class B extends p.A{abstract class D extends C1{public void m(){}}}", "", TempFile.cons("package p;public class A{abstract class C{abstract void m();}interface I{void m();}protected abstract class C1 extends C implements I{}}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class B extends p.A{class D extends C{}}", "", TempFile.cons("package p;public class A{protected class C{}}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class B extends p.A{class D extends C{}}", "", TempFile.cons("package p;public class A{public class C{}}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class B extends p.A{class D implements C{}}", "", TempFile.cons("package p;public class A{protected interface C{}}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class B extends p.A{interface D extends C{}}", "", TempFile.cons("package p;public class A{protected interface C{}}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class B extends p.A{void m()throws Exception{}}", "", TempFile.cons("package p;public class A{static int m(){return 1;}}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class B extends p.A{void m(){}}", "must be abstract", TempFile.cons("package p;public abstract class A{abstract void m();}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class B extends p1.A{abstract class D extends C implements I{public void m()throws Exception{}}}", "", TempFile.cons("package p1;public class A{public abstract class C{abstract void m();}public interface I{void m()throws Exception;}}", "p1", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class B extends p1.A{abstract class D extends C implements I{public void m(){}}class E extends D{}}", "must be abstract", TempFile.cons("package p1;public class A{public abstract class C{abstract void m();}public interface I{void m();}}", "p1", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class B extends p1.A{class D extends C implements I{public void m(){}}}", "must be abstract", TempFile.cons("package p1;public class A{public abstract class C{abstract void m();}public interface I{void m();}}", "p1", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class B{Class c=p.A.class;}", "", TempFile.cons("package p;class A{}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C extends p2.B{class D implements p1.A{}}", "", TempFile.cons("package p1;public class A{}", "p1", "A", TempFile.cons("package p2;public class B{public static class p1{public interface A{}}}", "p2", "B", null))));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C extends p2.B{void f(){p1.A++;}}", "", TempFile.cons("package p1;public class A{}", "p1", "A", TempFile.cons("package p2;public class B{public static class p1{public static int A;}}", "p2", "B", null))));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{C(){}C(int x){}}class D extends C{C c=new D(3);}", "could not find constructor"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{C(){}}class D{C c=new C();}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{D d;}", "unknown type D"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{Integer i;}class D extends C{Object o=super.i;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{String i;}class D extends C{int i;{i=2;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{final void f(){}}class D extends C{void f(){}}", "cannot override final method"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{int i;}class D extends C{Object o=1.super.i;}", "symbol characters expected"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{int i;}class D extends C{Object o=super.i;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{int i;}class D extends C{String i;{D d=null;int j=((C)d).i;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{private C(){}}class D{C c=new C();}", "could not find constructor"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{private int i;}class D extends C{Object o=super.i;}", "unknown or ambiguous name"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{private int i;}class D extends C{{i=2;}}", "unknown or ambiguous name"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{private static class D{}}class E extends C.D{}", "unknown class or interface C.D"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{private static void f(){}}class D{{C.f();}}", "no such method"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{private void f(){}}class D extends C{int f(){return -1;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{protected C(){}}class D extends C{}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{public int x;}class D extends C{void f(){x=2;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{static class D{}}class E extends C{}class F extends E.D{}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{static void f(){}}class D extends C{void f(){}}", "instance method cannot override static method"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{void f()throws Exception{}}class D extends C{void f()throws NullPointerException{}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{void f()throws Exception{}}class D extends C{void f()throws Throwable{}}", "incompatible throws clause in overriding method"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{void f(){}}class D extends C{int f(){return -1;}}", "incompatible return type"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{void f(){}}class D extends C{private void f(){}}", "cannot reduce visibility"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class C{void f(){}}class D extends C{static void f(){}}", "static method cannot hide instance method"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class D extends p.C{int j=i;}", "", TempFile.cons("package p;class A{int i;}interface B{int i=1;}public class C extends A implements B{}", "p", "C", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class D extends p.C{void m(int i){switch(i){case 1:case C.i:}}}", "", TempFile.cons("package p;class A{class C{public static final int i=1;}}interface B{class C{public static final int i=2;}}public class C extends A implements B{}", "p", "C", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "class D extends p.E{int x=C.i;}", "", TempFile.cons("package p;class A{class C{public static final int i=1;}}interface B{class C{public static final int i=2;}}public class E extends A implements B{}", "p", "E", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "import java.lang.*;import java.lang.Object;import java.lang.Integer;class A extends Object{Integer i;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "import java.util.Vector;import Vector.Mosquito;class A{public static void main(String[]a){System.out.println(new Vector().getClass());System.out.println(new Mosquito().getClass());}}", "", TempFile.cons("package Vector;public class Mosquito{}", "Vector", "Mosquito", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "import p.*;class A extends B{}", "", TempFile.cons("package p;public class B{}", "p", "B", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "import p.A.C;class B extends C{}", "", TempFile.cons("package p;public class A{public int C;public int C(){return 0;}public static class C{}}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "import p.A;class B implements A{}", "", TempFile.cons("package p;public interface A{}", "p", "A", TempFile.cons("class A{}", "A", null))));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "import p.A;import p.A;class B extends A{}", "", TempFile.cons("package p;public class A{}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "import p.B;class A extends B{}", "", TempFile.cons("package p;public class B{}", "p", "B", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "import p1.*;import p2.*;class B extends A{}", "", TempFile.cons("package p1;public class A{}", "p1", "A", TempFile.cons("package p2;public class A{}", "p2", "A", null))));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "interface A{int x=2;}interface B{int x=3;}class C implements A,B{int y=x;}", "unknown or ambiguous name"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "interface A{int x=2;}interface B{int x=3;}class C implements A,B{}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "interface A{interface B{}}interface C extends A{interface D extends B{}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "interface A{void f();}abstract class B implements A{}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "interface A{void f();}interface B{void f();}class C implements A,B{public void f(){}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "interface B{Class BUG=Inner.class;class Inner{}}", "", TempFile.cons("class A{Class c=B.BUG;}", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "interface B{void m();}abstract class C extends p1.A implements B{}", "", TempFile.cons("package p1;public abstract class A{abstract void m();}", "p1", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "interface I{int V=1;}interface J extends I{}class C implements I,J{int i=V;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "interface I{int V=1;}interface J{int V=2;}class C implements I,J{int i=V;}", "unknown or ambiguous name"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package A;import A.B.*;class B{static class C{}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package A;import A.B.C;public class A extends C{}", "", TempFile.cons("package A.B;public class C{}", "A", "B", "C", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package bazoa;class Gabriel{static int n=org.rpgpoet.Music.wizards.length;}", "", TempFile.cons("package org.rpgpoet;import java.util.Random;public interface Music{Random[]wizards=new Random[4];}", "org", "rpgpoet", "Music", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package java.lang;class Object extends Object{}", "Object can not have an extends clause"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package java.lang;interface I{}class Object implements I{}", "Object can not have an implements clause"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package p1;public abstract class C extends p2.B{void m(){}}", "", TempFile.cons("package p1;public abstract class A{abstract void m();}", "p1", "A", TempFile.cons("package p2;public abstract class B extends p1.A{}", "p2", "B", null))));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package p2;import p1.*;interface I{class B{}}class C extends A implements I{static Object o=new C.B();}", "", TempFile.cons("package p1;public class A{static class B{}}", "p1", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package p2;import p1.A;class B extends A{}", "", TempFile.cons("package p1;public class A{}", "p1", "A", TempFile.cons("package p2;interface A{}", "p2", "A", null))));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package p2;public abstract class B extends p1.A{}", "", TempFile.cons("package p1;public abstract class A{abstract void m();}class C extends p2.B{void m(){}}", "p1", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package p2;public class B extends p1.A{private class p1{}}", "", TempFile.cons("package p1;public class A{public class p1{}}class C extends p2.B{p1.C p;}", "p1", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package p2;public class B extends p1.A{protected static int m(){return 1;}}", "", TempFile.cons("package p1;public class A{int m(){return 1;}}class C extends p2.B{int i=m();}", "p1", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package p2;public class B extends p1.A{public abstract class D extends C implements I{public void m()throws Exception{}}}", "", TempFile.cons("package p1;public class A{public abstract class C{abstract void m();}public interface I{void m()throws Exception;}}", "p1", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package p2;public class B extends p1.A{}", "", TempFile.cons("package p1;public class A{class p1{}}class C extends p2.B{p1.C p;}", "p1", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package p3;import p2.*;import p1.A;class B extends A{}", "", TempFile.cons("package p1;public class A{}", "p1", "A", TempFile.cons("package p2;interface A{}", "p2", "A", null))));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package p;import p.A.C;class B implements C{}", "", TempFile.cons("package p;class A{interface C{}}", "p", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package p;public class B{public static A[]array;public static class A{}}", "", TempFile.cons("class A{int i=p.B.array.length;}", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package p;public class B{}", "", TempFile.cons("class A{p.B x;}", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package p;public class B{}", "", TempFile.cons("class A{p.B[]ref;}", "A", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package p;public class C{public static A[]a;public static class A{}}", "", TempFile.cons("class B{Object o=p.C.array.toString();}", "B", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package q;class A extends p.B{}", "", TempFile.cons("package p;public class B{void f(){}}", "p", "B", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "CompilationUnit", "package q;class A extends p.B{}", "", TempFile.cons("package p;public class B{}", "p", "B", null)));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "abstract class C{abstract private void f(){}}", "conflicting modifiers"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "abstract class C{abstract void f();abstract int f();}", "duplicate method"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "abstract class C{public abstract String toString();}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A extends B{}", "unknown class or interface B"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{String[] s=new String[]{};}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{boolean b=new String[]{}instanceof String[];}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{byte b='\\u0080';}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{byte b=(byte)1;char c=b;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{byte b=(short)128;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{byte b=1L;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{byte n1=1;byte n2=+n1;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{byte n1=1;byte n2=-n1;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{byte n1=1;byte n2=~n1;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{char b='\\u000d';}", "single character must not be line terminator"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{char b='\\u0027';}", "character constant expected"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{char b='\\u005c';}", "symbol characters expected"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{char c='1';byte b=c;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{char c=(byte)-1;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{class B{interface C{}}}", "illegal context for static member"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{class B{static class C{}}}", "illegal context for static member"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{class B{static void c(){}}}", "illegal context for static member"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{class B{}static class C extends A{private class B{}}static class D extends C{D.B b;}}", "unknown type D.B"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{double d=-1e-326;}", "literal out of range"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{final int i=1;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{float f=(float)1/1.0;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{int A;Class a=A.class;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{int A;{A.class.toString();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{int f(){return x;}}", "unknown or ambiguous name"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{int f(long i){return 0;}long f(int i){return 0;}int i=f(0);}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{int i=-100;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{int i=-2147483648;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{int i=1*2L;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{int i=1,i2=(-i)++;}", "operand of ++ must be variable"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{int i=1,i2=(-i)--;}", "operand of -- must be variable"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{int i=1,i2=++(-i);}", "operand of ++ must be variable"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{int i=1,i2=--(-i);}", "operand of -- must be variable"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{int i=123;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{int i=1L;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{interface B{int i=1;}interface C extends B{}interface D extends B{}class E implements C,D{int j=i;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{long l=0-2147483648;}", "literal out of range"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{long l=0-9223372036854775808L;}", "literal out of range"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{long l=1.0D;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{long l=1L%0L;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{long l=1L/0L;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{private class B{}class C{C(){new B();}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{private class B{}static class C extends A{{new B();}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{private int f(){return 1;}class B extends A{int i=this.f();}}", "no such method"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{static int a=3;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{void f(){(\"1\"+2).toString();(\"1\"+2).valueOf(1);}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{void f(){class B{}class B{}}}", "conflicting classes"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{void f(){interface B{}}}", "interface cannot be local"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{void f(){try{Object.class.forName(\"java.lang.Object\");}catch(Exception e){}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{void f(){x=2;}}", "unknown or ambiguous name"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{void f(String[]a){int i=a.length;Class c=a.getClass();String s=a.toString();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{void f(int i){switch(i){case 0:case((\"\\u0080\"==\"\"+'\\u0080')?1:0):case((\"\\u0080,\\u0080\"=='\\u0080'+\",\"+'\\u0080')?3:0):}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{void f(int[]a){int i=a.length;Class c=a.getClass();String s=a.toString();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{{A.class.toString();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{{\"\".toString();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class A{{if(new String[]{}instanceof String[]);}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C extends ClassLoader{}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C extends C{}", "circular class"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C extends String{}", "can't subclass final class"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C implements Cloneable, Cloneable{}", "duplicate superinterfaces"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C implements Runnable{abstract void run();}", "must be abstract"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C implements Runnable{public void run(){}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C implements Runnable{}", "must be abstract"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C { // \n } oops", "input not fully consumed"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C { int i; C c; int j = c.i; }", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C { int i; int j = C.i; }", "static access to non-static field"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C { int i; int j = new C().i; }", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C { static int i; int j = C.i; }", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{A a=new A();static class A{private A(){}A(String s){}}{new A(null);}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{C() throws Exception{}C(int i)throws Exception{}{throw new java.io.IOException();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{C() throws Exception{}C(int i){}{throw new Exception();}}", "uncaught exception"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{C() throws Exception{}{throw new Exception();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{C(){return null;}}", "'return' with a value, in method returning void"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{C(){}C(){}}", "duplicate method"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{Class c=Object[].class;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{Class c=Runnable[][][][].class;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{Class c=UnknownType.class;}", "unknown class or interface UnknownType"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{Object f(){class D{}return new D();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{Object f(){return new Object();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{Object x=new java.util.AbstractCollection();}", "cannot instantiate abstract type"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{Object[]a={new Object()};}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{String s1=(String)\"\";String s2=(String)null;String s3=(String)s1;String s4=(String)s2;String s5=(String)(\"1\"+\"2\");String s6=\"1\".concat(\"2\");}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{String s=new Object();}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{String toString(){return null;}}", "cannot reduce visibility"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{abstract void f();}", "must be abstract"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{boolean b=\"null\"==null;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{boolean b=null==\"1\";}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{class D{static final int i=0;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{class D{static int i=0;}}", "static variables of inner classes must be compile-time constants"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{class D{static{}}}", "inner classes may not declare static initializers"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{d(){}}", "missing return type"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{final Object[]a={new Object(),new Object()};void swap(){Object t=a[0];a[0]=a[1];a[1]=t;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{final StringBuffer s=new StringBuffer();void append(){s.append(\"nuggy\");}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{final int i=1;{switch (123){case 0:case (i==1)?1:0:}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{final volatile int i=0;}", "conflicting modifiers final and volatile"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int f(){return 0;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int f(){return 3.1;}}", "return type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int f(){return;}}", "'return' with no value, in method returning non-void"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int foo;Class c=foo.class;}", "unknown class or interface foo"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int i;static int f(){return i;}}", "static use of instance field"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int i;void f(int i){}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int i=0;static int j=i;}", "static use of instance field"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int i=1/0;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int i=1;byte b=i;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int i=i=2;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int x;int x;}", "duplicate field declaration x"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int x=2;void f(){class D{int j=x;}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int[] a = {123L};}", "array initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int[] a = {123};}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int[][]ia={{1,2},null};}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int[]a={new Object()};}", "array initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int[]f(){return g();}int g()[]{return f();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{int[]ia={{1,2},null};}", "array initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{native strictfp void f();}", "conflicting modifiers"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{private class D{}class E extends C{E.D d;}}", "unknown type E.D"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{public static int f(){return 5;}interface I{int CONSTANT=f();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{short s='\u8000';}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{short s=(short)1;char c=s;}", "initializer type mismatch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{static C f(){return this;}}", "static use of this"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{static String s=\"1\";void f(int j){switch(j){case 0:case((C.s==\"1\")?1:0):}}}", "case expression must be constant"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{static class D{interface I{}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{static class D{static{}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{static final String a=\"b\";}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{static int c=super.hashCode();}", "static use of super"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{static int f()throws Exception{return 0;}int i=C.f();}", "uncaught exception"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{static int f()throws Exception{return 0;}static int i=C.f();}", "uncaught exception"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{static int m() throws Exception {return 1;}static int i=m();}", "uncaught exception"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{static void f(){class D{{new D();}}new D();{new D();}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{static{throw new Exception();}}", "uncaught exception"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f();}", "missing method body"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f()throws ClassNotFoundException{throw new Exception();}}", "uncaught exception"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f()throws Exception{throw new Exception();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){12--;}}", "operand of -- must be variable"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){Comparable x;Comparable: x=\"c\";}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){String i;i++;}}", "operand of ++ must be number"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){String s=new Integer();}}", "could not find constructor"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){boolean b;b--;}}", "operand of -- must be number"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){final int i;i++;}}", "operand of ++ must not be final"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){final int x=2;class D{int j=x;}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){for (int i=0;i<10;++i) continue;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){int i;i++++;}}", "operand of ++ must be variable"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){int i;i++;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){int i;j++;}}", "operand of ++ must be variable"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){int i;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){int true;}}", "illegal identifier"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){return 0;}}", "'return' with a value, in method returning void"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){return;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){throw null;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){x:y:{for(;;)break x;}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){x:y:{for(;;)continue x;}}}", "x is not a loop label"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){x:{ for (;;) break x;}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){x:{ for (int i=0;i<10;++i) continue x;}}}", "x is not a loop label"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(){}void f(){}}", "duplicate method"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(byte b){switch(b){case 0x1ff:}}}", "invalid case clause"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(char c)throws Exception{}void f(int i){}void g(){f(true?'0':-1);f(false?'0':-1);f(true?-1:'0');f(false?-1:'0');}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(char c){switch(c){case 123:}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(final int i){i=1;}}", "left operand of assignment is final"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(final int x){class D{int j=x;}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(int i){for(int i=2;;);}}", "duplicate variable declaration i"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(int i){for(int j=2,k=3;;);}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(int i){int i;}}", "duplicate variable declaration i"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(int i){switch(i){case 0:case(('\\u0061'=='a')?1:0):}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(int i){switch(i){case 0:case(('\\uABcD'=='\\uabCd')?1:0):}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(int i){switch(i){}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(int i){{int i;}}}", "duplicate variable declaration i"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(int i){for(int i=2;;);}}", "duplicate variable declaration i"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(int i,int i);}", "duplicate parameter declaration i"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void f(int[]a){int b;b=a.length;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void m(){break;}}", "break without label can only be used in loop or switch"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void m(){continue;}}", "continue cannot be used outside of a loop"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void m(){i:{i:{}}}}", "duplicate label i"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{void m(){i:{}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{{int i=1;switch(123){case i++:;}}}", "case expression must be constant"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{{new C();}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{{try{throw new ClassNotFoundException();}catch(Exception e){}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{{try{throw new Exception();}catch(ClassNotFoundException e){}}}", "uncaught exception"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{{try{throw new Exception();}catch(Exception e){}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{{try{try{throw new Exception();}catch(ClassNotFoundException e){}}catch(ClassNotFoundException e){}}}", "uncaught exception"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{{try{try{throw new Exception();}catch(ClassNotFoundException e){}}catch(Exception e){}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{{try{}catch(Exception e){}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{{try{}catch(String e){}}}", "illegal type for exception parameter"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class C{{try{}catch(int e){}}}", "illegal type for exception parameter"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class H { static void i() { } static H k() { } }", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "class TestString { char[] value; int offset, count; int indexOf(TestString str, int fromIndex) { char[] v1 = value, v2 = str.value; int max = offset + (count - str.count); int start = offset + ((fromIndex < 0) ? 0 : fromIndex); i: for (int i = start; i <= max; i++) { int n = str.count, j = i, k = str.offset; while (n-- != 0) { if (v1[j++] != v2[k++]) continue i; } return i - offset; } return -1; } }", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "final abstract class C {}", "can not be both abstract and final"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "interface A{;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "interface A{A a=null;int i=1;int j=a.i;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "public class C{void f(){Object[]o=null;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Declaration", "public public class C{}", "duplicate modifier public"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "'\\u000a'", "single character must not be line terminator"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "'\\u001a'", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "'\\u03a9'", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "'\\uFFFF'", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "'\\uuuuuuuuuuabcd'", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "'\n'", "single character must not be line terminator"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "'\r'", "single character must not be line terminator"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "(Object).class", "input not fully consumed"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "-100", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "-1e-326", "literal out of range"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "-1e310", "literal out of range"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "-2147483648", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "-Float.NaN", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "02000000000000000000000L", "literal out of range"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "040000000000", "literal out of range"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "0x123456789", "literal out of range"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "0x123456789abcdef01L", "literal out of range"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "0xCafeBabe", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "1.class", "input not fully consumed"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "1// This is a comment\n", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "123 instanceof String", "reference type expected"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "12345678901", "literal out of range"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "12345678901234567890L", "literal out of range"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "1234?1:0", "condition must be boolean"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "1\\u002f\\u002f This is a comment\\u000a", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "1e-47f", "literal out of range"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "1e39f", "literal out of range"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "2147483648", "literal out of range"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "9223372036854775808L", "literal out of range"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "Object.noSuchMethod()", "no such method"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "String.class", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "System.gc()", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "System.out instanceof String", "not castable"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "System.out.println()", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "\"\".class", "input not fully consumed"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "\"\\u001a\"", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "\"\\u005c\\u005a\"", "symbol characters expected"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "\"\\u03a9\"", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "\"\\uFFFF\"", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "\"\n\"", "string must not contain line terminator"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "\"\r\"", "string must not contain line terminator"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "\"hello\" instanceof Object", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "\"hello\" instanceof String", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "\"hi\" instanceof int", "reference type expected"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "false?-1:'0'", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "int.class", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "int[][].class", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "java.io.PrintStream.println()", "static call to non-static method"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "new Object()", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "new String().class", "input not fully consumed"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "new String(123)", "could not find constructor"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "new String[]{}instanceof String[]", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "new int['3']", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "new int[0]", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "new int[3.0]", "dimension must be integer"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "new int[3L]", "dimension must be integer"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "new int[3]", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "new int[3][3]", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "new int[3][]", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "new int[null]", "dimension must be integer"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "null instanceof int[]", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "null.class", "input not fully consumed"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "null==\"\"", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "this.class", "input not fully consumed"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "true?'0':-1", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Expression", "true?1:0", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "i:for(;;){break i;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "switch('a'){}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "switch(12){case 0:case(((double)'\u789a'==30874.0)?1:0):}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "switch(12){case 1:case 1:}", "duplicate case clause"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "switch(12){case 1:case 2:}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "switch(12){default:default:}", "duplicate default clause"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "switch(12){}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "switch(12.3){}", "switch expression must be char, byte, short, or int"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "switch(123){case 0.0D:}", "invalid case clause"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "switch(123){case 0:class C{}break;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "switch(123){case 0:class C{}break;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "switch(123){case true:}", "invalid case clause"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "synchronized(12.5) {}", "invalid type for synchronized statement"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "synchronized(null) {}", "invalid type for synchronized statement"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "throw new ClassNotFoundException();", "uncaught exception"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "throw new Error();", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "throw new Exception();", "uncaught exception"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "throw new NullPointerException();", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "throw new RuntimeException();", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "while(1);", "condition must be boolean"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "while(true);", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "while(true){break;}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "{class C{final int i=1;}class D extends C{{switch (123){case 0:case (i==1)?1:0:}}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "{class C{int i=1; class D{int j=i;}}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "{class C{}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "{i:while(true){continue i;}}", ""));
        testSuite.addTest((Test)new JavaAnalyzerTestError(false, "Statement", "{i:{continue j;}}", "the label j is missing"));
        return testSuite;
    }

    private static TestSuite makeSuiteJavaExternalAnalyzer() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", false, "class A extends B implements D,C{}", "class A extends B implements D,C{A()->void;}"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", false, "class A{class C{}class B{}}", "class A{A()->void;class A.B{B()->void;};class A.C{C()->void;};}"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", false, "class A{int b;}", "class A{field(int,b);A()->void;}"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", false, "class A{void b();C[]d;}", "class A{field(C[],d);A()->void;b()->void;}"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", false, "class A{}", "class A{A()->void;}"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", false, "interface A extends B,D,C{}", "abstract interface A extends B,D,C{}"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", false, "public final class A{}", "public final class A{public A()->void;}"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", true, "A b,c;", "field(A,b);field(A,c);"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", true, "A b;", "field(A,b);"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", true, "A b=1;", "field(A,b);"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", true, "A[]b;", "field(A[],b);"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", true, "A[]b[];", "field(A[][],b);"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", true, "a.b.C[]d,e[];", "field(a.b.C[],d); field(a.b.C[][],e);"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", true, "char a;", "field(char,a);"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", true, "int a();", "a()->int"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", true, "int b(){}", "b()->int"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", true, "int b(C d);", "b(param(C,d))->int"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", true, "int b(C d,E[]f,G[][]h);", "b(param(C,d),param(E[],f),param(G[][],h))->int"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", true, "public static final String s;", "public static final field(String,s);"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", true, "public strictfp float b();", "public strictfp b()->float"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Declaration", true, "void a();", "a()->void"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Type", "A"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Type", "A[]"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Type", "A[][]"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Type", "a.B"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Type", "a.b.C[][]"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Type", "byte"));
        testSuite.addTest((Test)new JavaExternalAnalyzerTest(false, "Type", "char[]"));
        return testSuite;
    }

    private static TestSuite makeSuiteJavaParser() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{int i;C t;void f(){t.(i)=1;}}", "invalid syntax"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{static void f(){int i;(i=1);}}", "invalid expression statement"));
        testSuite.addTest((Test)new JavaAnalyzerTestError(true, "Declaration", "class C{void f(){}void g(){(f());}}", "invalid expression statement"));
        testSuite.addTest((Test)new JavaParserTest(true, "Expression", "class C{int i = new int[]{1}[0];}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "(a+b)*c"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a&b==c&&d"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a+1"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a+b*c"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a-(b-c)"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a-b-c"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a.f(0)"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a.f(a,b,c)"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "f()"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "f().g()"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "f(0)"));
        testSuite.addTest((Test)new JavaParserTest(false, "Statement", "switch (i) { case 'a': case 2: break; case 0x1: { } default: }"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "(A)b"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "(A[][])b"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "(char[])a"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "(int)'a'"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "(int)a"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "Integer[].class"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "int.class"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "int[].class"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "void.class"));
        testSuite.addTest((Test)new JavaParserTest(false, "CompilationUnit", "class A{class B{}} class C{ A.B b=new A().new B();}"));
        testSuite.addTest((Test)new JavaParserTest(false, "CompilationUnit", "class Main { public static void main(String[] args) { System.class.println(\"Hello world!\"); } }"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "(a==++b.c(1)[d.e()][2].f&g)-h"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "A a=0;"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "A b,c;"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "A b;"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "A b[],c,d[][];"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "A[]b;"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "A[]b[];"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "int a;"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "public A b;"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "public final A b;"));
        testSuite.addTest((Test)new JavaParserTest(false, "Statement", "for(0,1;;);"));
        testSuite.addTest((Test)new JavaParserTest(false, "Statement", "for(;;);"));
        testSuite.addTest((Test)new JavaParserTest(false, "Statement", "for(A b=c,d=e;;);"));
        testSuite.addTest((Test)new JavaParserTest(false, "Statement", "for(A[]b[];;);"));
        testSuite.addTest((Test)new JavaParserTest(false, "Statement", "for(int a=0,b=c;a<b;a++)d*=2;"));
        testSuite.addTest((Test)new JavaParserTest(false, "Statement", "for(int a=0;;);"));
        testSuite.addTest((Test)new JavaParserTest(false, "FormalParameter", "A b"));
        testSuite.addTest((Test)new JavaParserTest(false, "FormalParameter", "a[][] b"));
        testSuite.addTest((Test)new JavaParserTest(false, "FormalParameter", "final int i"));
        testSuite.addTest((Test)new JavaParserTest(false, "Statement", "if(a)b;"));
        testSuite.addTest((Test)new JavaParserTest(false, "Statement", "if(a)b;else c;"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "A b();"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "A b(C d);"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "A b(C d,E[]f){}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "X A()throws B{}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "X A(){}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "char a()throws B,C;"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "public final int[]a(){}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "void a();"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a.new B()"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a.new B().new C()"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a.new B(c,d)"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "new A()"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "new A(){}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "new A[2]"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "new A[2][]"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "new A[][]{{b,c},{d,e}}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "new A[]{b,c}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a.b"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a.b.c"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a.class"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a.class.b"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a.class.b.c"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a[0]"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a[0][1]"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a[b][c][d]"));
        testSuite.addTest((Test)new JavaParserTest(false, "Statement", "switch(123){case 0:}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Statement", "try{}catch(A b){}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Statement", "try{}catch(A b){}catch(C d){}finally{}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Statement", "try{}catch(A b){}finally{}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Statement", "try{}finally{}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "!a++"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "++a"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "+-!~--a++--"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "-a"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a++"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "a--"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "class C{int[] a = {,};}", "class C{int[] a = {};}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Declaration", "class C{int[] a = {1,};}", "class C{int[] a = {1};}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "'\\u005c\\u0030'"));
        testSuite.addTest((Test)new JavaParserTest(false, "CompilationUnit", "class c{ { this(); super(); } }"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "super()"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "this()"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "this(1, 2, null)"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "z.super()"));
        testSuite.addTest((Test)new JavaParserTest(false, "CompilationUnit", "class A{}//", "class A{}"));
        testSuite.addTest((Test)new JavaParserTest(false, "Statement", "\\u0062:;"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "B"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "\\u0062"));
        testSuite.addTest((Test)new JavaParserTest(false, "Expression", "b"));
        return testSuite;
    }

    static JavaExternalAnalyzer newJavaExternalAnalyzer() {
        return new JavaExternalAnalyzer(new Runtime(), new SymbolTable());
    }

    public static Runtime newRuntime() {
        Runtime runtime = new Runtime();
        runtime.dir("in", "inputDirectory", true, "").setValue("inputDirectory", JavaEntities.TEMP_DIR);
        return runtime;
    }

    public static String stripPrefix(String string, String string2) {
        int n = string.indexOf(string2);
        return -1 == n ? string : string.substring(string2.length() + n);
    }

    public static String stripSuffix(String string, String string2) {
        int n = string.indexOf(string2);
        return -1 == n ? string : string.substring(0, n);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)JavaUnitTests.makeSuiteJavaParser());
        testSuite.addTest((Test)JavaUnitTests.makeSuiteJavaExternalAnalyzer());
        testSuite.addTest((Test)JavaUnitTests.makeSuiteJavaAnalyzerError());
        testSuite.addTest((Test)JavaUnitTests.makeSuiteJavaAnalyzerConstant());
        testSuite.addTestSuite(JavaUnitTests.class);
        return testSuite;
    }

    public final void testAssertEnabled() {
        boolean bl = false;
        try {
            assert (false);
        }
        catch (AssertionError assertionError) {
            bl = true;
        }
        JavaUnitTests.assertTrue((boolean)bl);
    }

    public final void testCParser_pTranslationUnit() throws Exception {
        String[] stringArray = new String[]{"int main(int argc, char** argv) { printf(\"Hello world!\\n\"); }", "int x;"};
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            JavaUnitTests.cParserRoundTrip("TranslationUnit", stringArray[i]);
        }
    }

    public final void testJavaAnalyzer_visitAssignmentExpression() throws Exception {
        GNode gNode = JavaEntities.javaStringToAst("CompilationUnit", "package a.b;class F {             public int i1;      void g(char c1) {     int[] a1;           final int[] a2;     int[][] a3;         boolean b1;         char c2;            float f1;           int i2, i3;         final int i4;       String s1;        }                 }                   ", true);
        JavaAnalyzer javaAnalyzer = new JavaAnalyzer(JavaUnitTests.newRuntime(), new SymbolTable());
        javaAnalyzer.dispatch(gNode);
        JavaEntities.enterScopeByQualifiedName(javaAnalyzer._table, ".package(a.b).file(<input>).F.method(g)(char c1)");
        JavaUnitTests.javaAnalyzerTestError("Expression", "i2=40", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "40=i2", "left operand of assignment not l-value", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i2=true", "illegal assignment", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i2=i3", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i2=i4", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i4=40", "left operand of assignment is final", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i2=f1", "illegal assignment", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i2=b1", "illegal assignment", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i2=s1", "illegal assignment", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i2='x'", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i2=c1", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i2=c2", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "c1='x'", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "c1=i2", "illegal assignment", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i1=40", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i1=i2", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i1=c1", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i1=i4", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i1=b1", "illegal assignment", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "a1[3]=40", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "a1[3]=true", "illegal assignment", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i2=a1[3]", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "a1=a2", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "a2=a1", "left operand of assignment is final", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "a2[1]='a'", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "a3[2]=a2", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "a3[2][1]=2", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "s1=99", "illegal assignment", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i1+=99", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "s1+=99", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i1-=99", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "s1-=99", "illegal assignment", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "b1^=true", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i1|=0xff", "", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "b1&=i1", "illegal assignment", javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestError("Expression", "i1^=true", "illegal assignment", javaAnalyzer);
    }

    public final void testJavaAnalyzer_visitCallExpression() throws Exception {
        GNode gNode = JavaEntities.javaStringToAst("CompilationUnit", "package a.b;class F {                static void i() {        G g;                   H h;                 }                      static void j(G z) {}  static void j(H z) {}}                      class G extends F    { }                      class H extends F    {   static void i() { }    static H k() { }     }                      ", true);
        SymbolTable symbolTable = new SymbolTable();
        JavaAnalyzer javaAnalyzer = new JavaAnalyzer(JavaUnitTests.newRuntime(), symbolTable);
        javaAnalyzer.dispatch(gNode);
        JavaEntities.enterScopeByQualifiedName(symbolTable, ".package(a.b).file(<input>).F.method(i)()");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "i()", ".package(a.b).file(<input>).F.method(i)()");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "j(g)", ".package(a.b).file(<input>).F.method(j)(G z)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "j(h)", ".package(a.b).file(<input>).F.method(j)(H z)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "F.j(g)", ".package(a.b).file(<input>).F.method(j)(G z)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "g.i()", ".package(a.b).file(<input>).F.method(i)()");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "h.i()", ".package(a.b).file(<input>).H.method(i)()");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "H.k().i()", ".package(a.b).file(<input>).H.method(i)()");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "hashCode()", ".package(java.lang).file().Object.method(hashCode)()");
    }

    public final strictfp void testJavaAnalyzer_visitConstantExpression() throws Exception {
        GNode gNode = JavaEntities.javaStringToAst("CompilationUnit", "package a.b;class F {                            final static int x=123;            void g() {                           final int y=456;                   final String z=2+\" fiddlers\";  }                                }                                  ", true);
        JavaAnalyzer javaAnalyzer = new JavaAnalyzer(JavaUnitTests.newRuntime(), new SymbolTable());
        javaAnalyzer.dispatch(gNode);
        JavaEntities.enterScopeByQualifiedName(javaAnalyzer._table, ".package(a.b).file(<input>).F.method(g)()");
        JavaUnitTests.javaAnalyzerTestConstant("x", new Integer(123), javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestConstant("y", new Integer(456), javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestConstant("a.b.F.x", new Integer(123), javaAnalyzer);
        JavaUnitTests.javaAnalyzerTestConstant("1+z", "12 fiddlers", javaAnalyzer);
    }

    public final void testJavaAnalyzer_visitExpression() throws Exception {
        GNode gNode = JavaEntities.javaStringToAst("CompilationUnit", "package a.b;class F {           void g() {          boolean b1;       int i1, i2;       double d1;      }               }                 ", true);
        SymbolTable symbolTable = new SymbolTable();
        JavaAnalyzer javaAnalyzer = new JavaAnalyzer(JavaUnitTests.newRuntime(), symbolTable);
        javaAnalyzer.dispatch(gNode);
        JavaEntities.enterScopeByQualifiedName(symbolTable, ".package(a.b).file(<input>).F.method(g)()");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "i1", ".package(a.b).file(<input>).F.method(g)().i1");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "i1+i2", "int");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "\"a\"+i2", ".package(java.lang).file().tag(String)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "i1<i2", "boolean");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "false", "boolean");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "i1+d1", "double");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "i1++", "int");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "d1--", "double");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "(byte)d1", "byte");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "b1 ? i1 : d1", "double");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "this instanceof F", "boolean");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "new F()", ".package(a.b).file(<input>).tag(F)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "d1++", "d1");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "this", ".package(a.b).file(<input>).tag(F)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "super", ".package(java.lang).file().tag(Object)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "F.this", ".package(a.b).file(<input>).tag(F)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "a.b.F.this", ".package(a.b).file(<input>).tag(F)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "F.super", ".package(java.lang).file().tag(Object)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "a.b.F.super", ".package(java.lang).file().tag(Object)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "this instanceof Object", "boolean");
    }

    public final void testJavaAnalyzer_visitPrimaryIdentifier() throws Exception {
        File file = JavaUnitTests.createTempFile(JavaEntities.TEMP_DIR, "a/b/Q.java", "package a.b;class Q{}");
        File file2 = JavaUnitTests.createTempFile(JavaEntities.TEMP_DIR, "n/o/P.java", "package n.o;class P{}");
        File file3 = JavaUnitTests.createTempFile(JavaEntities.TEMP_DIR, "r/s/T.java", "package r.s;class T{}");
        GNode gNode = JavaEntities.javaStringToAst("CompilationUnit", "package a.b;import n.o.P;       import r.s.*;       class F {             int h, i, j;        void g(int h) {       int i, j;           class L { }         { int j; }          for (int q=0;;);  }                   int k;              final int l=2;    }                   class M { }         ", true);
        SymbolTable symbolTable = new SymbolTable();
        Runtime runtime = new Runtime();
        runtime.dir("in", "inputDirectory", true, "").setValue("inputDirectory", JavaEntities.TEMP_DIR);
        JavaAnalyzer javaAnalyzer = new JavaAnalyzer(runtime, symbolTable);
        javaAnalyzer.dispatch(gNode);
        JavaEntities.enterScopeByQualifiedName(symbolTable, ".package(a.b).file(<input>).F.method(g)(int h).block(0)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "h", ".package(a.b).file(<input>).F.method(g)(int h).h");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "i", ".package(a.b).file(<input>).F.method(g)(int h).i");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "j", ".package(a.b).file(<input>).F.method(g)(int h).block(0).j");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "k", ".package(a.b).file(<input>).F.k");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "L", ".package(a.b).file(<input>).F.method(g)(int h).tag(L)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "F", ".package(a.b).file(<input>).tag(F)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "M", ".package(a.b).file(<input>).tag(M)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "P", ".package(n.o)." + JavaEntities.fileNameToScopeName(file2.getAbsolutePath()) + ".tag(P)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "Q", ".package(a.b)." + JavaEntities.fileNameToScopeName(file.getAbsolutePath()) + ".tag(Q)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "T", ".package(r.s)." + JavaEntities.fileNameToScopeName(file3.getAbsolutePath()) + ".tag(T)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "Object", ".package(java.lang).file().tag(Object)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "Runnable", ".package(java.lang).file().tag(Runnable)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "l", ".package(a.b).file(<input>).F.l");
        JavaEntities.enterScopeByQualifiedName(symbolTable, ".package(a.b).file(<input>).F.method(g)(int h).forStatement(1)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "q", ".package(a.b).file(<input>).F.method(g)(int h).forStatement(1).q");
    }

    public final void testJavaAnalyzer_visitSelectionExpression() throws Exception {
        GNode gNode = JavaEntities.javaStringToAst("CompilationUnit", "package a.b;class F {            static int g;      void h() {           F i;               J l;             }                }                  class J extends F {  static int k;      J m;             }                  ", true);
        SymbolTable symbolTable = new SymbolTable();
        JavaAnalyzer javaAnalyzer = new JavaAnalyzer(JavaUnitTests.newRuntime(), symbolTable);
        javaAnalyzer.dispatch(gNode);
        JavaEntities.enterScopeByQualifiedName(symbolTable, ".package(a.b).file(<input>).F.method(h)()");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "i.g", ".package(a.b).file(<input>).F.g");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "F.g", ".package(a.b).file(<input>).F.g");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "l.k", ".package(a.b).file(<input>).J.k");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "l.g", ".package(a.b).file(<input>).F.g");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "l.g", ".package(a.b).file(<input>).F.g");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "l.m", ".package(a.b).file(<input>).J.m");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "l.m.g", ".package(a.b).file(<input>).F.g");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "l.m.m", ".package(a.b).file(<input>).J.m");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "l.m.m.g", ".package(a.b).file(<input>).F.g");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "a.b", ".package(a).tag(b)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "a.b.F", ".package(a.b).file(<input>).tag(F)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "a.b.F.g", ".package(a.b).file(<input>).F.g");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "a.b.J.g", ".package(a.b).file(<input>).F.g");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "System.out", ".package(java.lang).file().System.out");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "Character.Subset", ".package(java.lang).file().Character.tag(Subset)");
    }

    public final void testJavaAnalyzer_visitSubscriptExpression() throws Exception {
        GNode gNode = JavaEntities.javaStringToAst("CompilationUnit", "package a.b;class C {            void d() {           int[] e;           int[][] f;         float[][][] g;     final int[] h;     C[] i;             String[] j;      }                }                  ", true);
        SymbolTable symbolTable = new SymbolTable();
        JavaAnalyzer javaAnalyzer = new JavaAnalyzer(JavaUnitTests.newRuntime(), symbolTable);
        javaAnalyzer.dispatch(gNode);
        JavaEntities.enterScopeByQualifiedName(symbolTable, ".package(a.b).file(<input>).C.method(d)()");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "e[0]", "int");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "f[0][0]", "int");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "f[0]", "int[]");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "g[100]", "float[][]");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "h[100]", "int");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "i[2]", ".package(a.b).file(<input>).tag(C)");
        JavaUnitTests.javaAnalyzerTestUseDef(javaAnalyzer, "j[12]", ".package(java.lang).file().tag(String)");
    }

    public final void testJavaEntities_nestingClassification() throws Exception {
        JavaUnitTests.assertTrue((boolean)JavaEntities.isScopeTopLevel(".package(a.b).file()"));
        JavaUnitTests.assertTrue((boolean)JavaEntities.isScopeTopLevel(".package(a.b).file(<input>)"));
        JavaUnitTests.assertFalse((boolean)JavaEntities.isScopeTopLevel(".package(a.b)"));
        JavaUnitTests.assertFalse((boolean)JavaEntities.isScopeTopLevel(".package(a.b).file().x"));
        JavaUnitTests.assertFalse((boolean)JavaEntities.isScopeTopLevel(".package(a.b).file(<input>).y"));
        JavaUnitTests.assertFalse((boolean)JavaEntities.isScopeTopLevel(".package(a.b).file().c.d.e"));
        JavaUnitTests.assertFalse((boolean)JavaEntities.isScopeNested(".package(a.b)"));
        JavaUnitTests.assertFalse((boolean)JavaEntities.isScopeNested(".package(a.b).file()"));
        JavaUnitTests.assertTrue((boolean)JavaEntities.isScopeNested(".package(a.b).file().a"));
        JavaUnitTests.assertTrue((boolean)JavaEntities.isScopeNested(".package(a.b).file().a.b"));
        JavaUnitTests.assertFalse((boolean)JavaEntities.isScopeNested(".package(a.b).file(Foo)"));
        JavaUnitTests.assertTrue((boolean)JavaEntities.isScopeLocal(".package(a.b).file(Foo).A.method(f())"));
        JavaUnitTests.assertFalse((boolean)JavaEntities.isScopeLocal(".package(a.b).file(Foo).A.F"));
        JavaUnitTests.assertTrue((boolean)JavaEntities.isScopeForMember(".package(a.b).file(Foo).A.F"));
        JavaUnitTests.assertFalse((boolean)JavaEntities.isScopeForMember(".package(a.b).file(Foo).A.method(f())"));
        GNode gNode = JavaEntities.javaStringToAst("CompilationUnit", "package a.b;class C {            class D {}         static class E {}  void f() {           class G {            class H {}       }                }                  interface I {}   }                  ", true);
        SymbolTable symbolTable = new SymbolTable();
        JavaAnalyzer javaAnalyzer = new JavaAnalyzer(JavaUnitTests.newRuntime(), symbolTable);
        javaAnalyzer.dispatch(gNode);
        JavaEntities.enterScopeByQualifiedName(symbolTable, ".package(a.b).file(<input>)");
        ClassT classT = (ClassT)symbolTable.lookup(".package(a.b).file(<input>).tag(C)");
        JavaUnitTests.assertTrue((boolean)JavaEntities.isTypeTopLevel(classT));
        ClassT classT2 = (ClassT)symbolTable.lookup(".package(a.b).file(<input>).C.tag(D)");
        JavaUnitTests.assertTrue((boolean)JavaEntities.isTypeMember(classT2));
        JavaUnitTests.assertFalse((boolean)JavaEntities.isTypeLocal(classT2));
        JavaUnitTests.assertTrue((boolean)JavaEntities.isTypeInner(classT2));
        ClassT classT3 = (ClassT)symbolTable.lookup(".package(a.b).file(<input>).C.tag(E)");
        JavaUnitTests.assertTrue((boolean)JavaEntities.isTypeMember(classT3));
        JavaUnitTests.assertFalse((boolean)JavaEntities.isTypeInner(classT3));
        ClassT classT4 = (ClassT)symbolTable.lookup(".package(a.b).file(<input>).C.method(f)().tag(G)");
        JavaUnitTests.assertTrue((boolean)JavaEntities.isTypeLocal(classT4));
        JavaUnitTests.assertTrue((boolean)JavaEntities.isTypeInner(classT4));
        JavaUnitTests.assertTrue((boolean)JavaEntities.isTypeNested(classT4));
        JavaUnitTests.assertTrue((boolean)JavaEntities.isTypeNamed(classT4));
        JavaUnitTests.assertFalse((boolean)JavaEntities.isTypeMember(classT4));
        ClassT classT5 = (ClassT)symbolTable.lookup(".package(a.b).file(<input>).C.method(f)().G.tag(H)");
        JavaUnitTests.assertTrue((boolean)JavaEntities.isTypeMember(classT5));
        JavaUnitTests.assertTrue((boolean)JavaEntities.isTypeInner(classT5));
        InterfaceT interfaceT = (InterfaceT)symbolTable.lookup(".package(a.b).file(<input>).C.tag(I)");
        JavaUnitTests.assertTrue((boolean)JavaEntities.isTypeMember(interfaceT));
        JavaUnitTests.assertTrue((boolean)JavaEntities.isTypeNested(interfaceT));
        JavaUnitTests.assertFalse((boolean)JavaEntities.isTypeInner(interfaceT));
    }

    public final void testJavaExternalAnalyzer_visitCompilationUnit() throws Exception {
        JavaExternalAnalyzer javaExternalAnalyzer = JavaUnitTests.newJavaExternalAnalyzer();
        javaExternalAnalyzer.dispatch(JavaEntities.javaStringToAst("CompilationUnit", "package a.b;class C{class D{E f;}}", true));
        SymbolTable symbolTable = javaExternalAnalyzer._table;
        PackageT packageT = (PackageT)symbolTable.lookup(".package(a).tag(b)");
        JavaUnitTests.assertEquals((String)"a.b", (String)packageT.getName());
        ClassT classT = (ClassT)symbolTable.lookup(".package(a.b).file(<input>).tag(C)");
        JavaEntities.enterScopeByQualifiedName(symbolTable, ".package(a.b).file(<input>)");
        JavaUnitTests.assertEquals((String)JavaUnitTests.contractSpace("class a.b.C{C()->void; class a.b.C.D{field(E,f); D()->void;};}"), (String)JavaUnitTests.contractSpace(JavaEntities.typeDeclString(javaExternalAnalyzer._table, classT)));
        ClassT classT2 = (ClassT)symbolTable.lookup(".package(a.b).file(<input>).C.tag(D)");
        JavaUnitTests.assertEquals((String)JavaUnitTests.contractSpace("class a.b.C.D{field(E,f);D()->void;}"), (String)JavaUnitTests.contractSpace(JavaEntities.typeDeclString(javaExternalAnalyzer._table, classT2)));
    }

    public final void testJavaExternalAnalyzer_visitImportDeclaration() throws Exception {
        JavaExternalAnalyzer javaExternalAnalyzer = JavaUnitTests.newJavaExternalAnalyzer();
        javaExternalAnalyzer.dispatch(JavaEntities.javaStringToAst("CompilationUnit", "package a.b;import c.*;import d.e;import f.g.*;", true));
        SymbolTable symbolTable = javaExternalAnalyzer._table;
        List list = (List)symbolTable.lookup(".package(a.b).file(<input>).imports(*)");
        JavaUnitTests.assertEquals((int)list.size(), (int)2);
        JavaUnitTests.assertEquals((String)((PackageT)list.get(0)).getName(), (String)"c");
        JavaUnitTests.assertEquals((String)((PackageT)list.get(1)).getName(), (String)"f.g");
        AliasT aliasT = (AliasT)symbolTable.lookup(".package(a.b).file(<input>).tag(e)");
        JavaUnitTests.assertEquals((String)aliasT.getName(), (String)"d.e");
    }

    public static class WriterOutputStream
    extends OutputStream {
        final Writer _writer;

        public WriterOutputStream(Writer writer) {
            this._writer = writer;
        }

        public final void write(int n) throws IOException {
            this._writer.write(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TempFile {
        private final String _contents;
        private final String _path;

        static List<TempFile> cons(String string, String string2, List<TempFile> arrayList) {
            Assert.assertFalse((boolean)string2.contains("."));
            ArrayList<TempFile> arrayList2 = null == arrayList ? new ArrayList<TempFile>() : arrayList;
            arrayList2.add(new TempFile(string, string2 + ".java"));
            return arrayList2;
        }

        static List<TempFile> cons(String string, String string2, String string3, List<TempFile> list) {
            return TempFile.cons(string, string2 + File.separator + string3, list);
        }

        static List<TempFile> cons(String string, String string2, String string3, String string4, List<TempFile> list) {
            return TempFile.cons(string, string2 + File.separator + string3 + File.separator + string4, list);
        }

        static void create(List<TempFile> list, File file) throws IOException {
            for (TempFile tempFile : list) {
                JavaUnitTests.createTempFile(file, tempFile._path, tempFile._contents);
            }
        }

        static void delete(List<TempFile> list, File file) {
            for (TempFile tempFile : list) {
                new File(file, tempFile._path).delete();
            }
        }

        TempFile(String string, String string2) {
            this._contents = string;
            this._path = string2;
        }
    }

    static class JavaParserTest
    extends IgnorableTest {
        private final String _expected;
        private final String _input;
        private final String _production;

        JavaParserTest(boolean bl, String string, String string2) {
            super(bl);
            this._expected = this._input = string2;
            this._production = string;
        }

        JavaParserTest(boolean bl, String string, String string2, String string3) {
            super(bl);
            this._expected = string3;
            this._input = string2;
            this._production = string;
        }

        public void runTestIgnorable() throws Exception {
            JavaUnitTests.javaParserTestRoundTrip(this._production, this._input, this._expected, false);
            JavaUnitTests.javaParserTestRoundTrip(this._production, this._input, this._expected, true);
        }
    }

    static class JavaExternalAnalyzerTest
    extends IgnorableTest {
        private final String _expected;
        private final String _input;
        private final String _production;
        private final boolean _withType;

        JavaExternalAnalyzerTest(boolean bl, String string, boolean bl2, String string2, String string3) {
            super(bl);
            this._expected = string3;
            this._input = string2;
            this._production = string;
            this._withType = bl2;
        }

        JavaExternalAnalyzerTest(boolean bl, String string, String string2) {
            this(bl, string, false, string2, string2);
        }

        public void runTestIgnorable() throws Throwable {
            Node node;
            JavaExternalAnalyzer javaExternalAnalyzer = JavaUnitTests.newJavaExternalAnalyzer();
            JavaUnitTests.enterPackageFile(javaExternalAnalyzer._table, "", "<input>");
            if (this._withType) {
                node = new ClassT("Z", JavaEntities.tObjectAlias(javaExternalAnalyzer._table), new ArrayList<Type>(), new ArrayList<Type>(), new ArrayList<Type>());
                javaExternalAnalyzer._table.current().define("tag(Z)", node);
                javaExternalAnalyzer._table.enter("Z");
            }
            node = JavaEntities.javaStringToAst(this._production, this._input, true);
            Object object = javaExternalAnalyzer.dispatch(node);
            String string = JavaEntities.typeDeclString(javaExternalAnalyzer._table, object);
            JavaExternalAnalyzerTest.assertEquals((String)JavaUnitTests.contractSpace(this._expected), (String)JavaUnitTests.contractSpace(string));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JavaAnalyzerTestError
    extends IgnorableTest {
        private final String _expected;
        private final String _input;
        private final String _production;
        private final List<TempFile> _tempFiles;

        JavaAnalyzerTestError(boolean bl, String string, String string2, String string3) {
            super(bl);
            this._production = string;
            this._input = string2;
            this._expected = string3;
            this._tempFiles = new ArrayList<TempFile>();
        }

        JavaAnalyzerTestError(boolean bl, String string, String string2, String string3, List<TempFile> list) {
            super(bl);
            this._production = string;
            this._input = string2;
            this._expected = string3;
            this._tempFiles = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runTestIgnorable() throws Throwable {
            try {
                TempFile.create(this._tempFiles, JavaEntities.TEMP_DIR);
                JavaUnitTests.javaAnalyzerTestError(this._production, this._input, this._expected);
            }
            finally {
                TempFile.delete(this._tempFiles, JavaEntities.TEMP_DIR);
            }
        }
    }

    static class JavaAnalyzerTestConstant
    extends IgnorableTest {
        private final Object _expected;
        private final String _input;

        JavaAnalyzerTestConstant(boolean bl, String string, Object object) {
            super(bl);
            this._expected = object;
            this._input = string;
        }

        public void runTestIgnorable() throws Throwable {
            JavaAnalyzer javaAnalyzer = new JavaAnalyzer(JavaUnitTests.newRuntime(), new SymbolTable());
            JavaUnitTests.enterPackageFile(javaAnalyzer._table, "", "<input>");
            JavaUnitTests.javaAnalyzerTestConstant(this._input, this._expected, javaAnalyzer);
        }
    }

    public static abstract class IgnorableTest
    extends TestCase {
        private final boolean _ignore;
        private final StackTraceElement _location;

        public IgnorableTest(boolean bl) {
            this._ignore = bl;
            this._location = bl ? null : new Throwable().getStackTrace()[2];
        }

        public final void runTest() throws Throwable {
            if (this._ignore) {
                return;
            }
            try {
                this.runTestIgnorable();
            }
            catch (Throwable throwable) {
                if (this._ignore) {
                    return;
                }
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[1 + stackTraceElementArray.length];
                stackTraceElementArray2[0] = this._location;
                System.arraycopy(stackTraceElementArray, 0, stackTraceElementArray2, 1, stackTraceElementArray.length);
                throwable.setStackTrace(stackTraceElementArray2);
                throw throwable;
            }
        }

        public abstract void runTestIgnorable() throws Throwable;
    }
}

