/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.util.Iterator;
import xtc.tree.Comment;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Token;
import xtc.tree.Visitor;

public class JavaPrinter
extends Visitor {
    public static final int PREC_BASE = 0;
    public static final int PREC_LIST = 10;
    public static final int PREC_CONSTANT = 1;
    public static final int STMT_ANY = 0;
    public static final int STMT_IF = 1;
    public static final int STMT_IF_ELSE = 2;
    protected final Printer printer;
    protected String packageName;
    protected boolean isDeclaration;
    protected boolean isStatement;
    protected boolean isOpenLine;
    protected boolean isNested;
    protected boolean isIfElse;
    protected int precedence;
    private static final Visitor containsLongExprVisitor = new Visitor(){

        public Boolean visitBlock(GNode gNode) {
            return Boolean.TRUE;
        }

        public Boolean visitArrayInitializer(GNode gNode) {
            return Boolean.TRUE;
        }

        public Boolean visit(GNode gNode) {
            for (Object object : gNode) {
                if (!(object instanceof Node) || !((Boolean)this.dispatch((Node)object)).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    };

    public JavaPrinter(Printer printer) {
        this.printer = printer;
        printer.register(this);
    }

    protected String fold(GNode gNode, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(gNode.getString(i));
            if (i >= n - 1) continue;
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    protected String getPackage(GNode gNode) {
        assert (gNode.hasName("ImportDeclaration"));
        GNode gNode2 = gNode.getGeneric(1);
        int n = gNode2.size();
        if (null == gNode.get(2)) {
            --n;
        }
        return 0 >= n ? "" : this.fold(gNode2, n);
    }

    protected boolean containsLongExpression(GNode gNode) {
        return (Boolean)containsLongExprVisitor.dispatch(gNode);
    }

    protected boolean isLongDeclaration(GNode gNode) {
        return gNode.hasName("ConstructorDeclaration") || gNode.hasName("ClassDeclaration") || gNode.hasName("InterfaceDeclaration") || gNode.hasName("AnnotationDeclaration") || gNode.hasName("EnumDeclaration") || gNode.hasName("BlockDeclaration") || gNode.hasName("MethodDeclaration") && null != gNode.get(7) || gNode.hasName("FieldDeclaration") && this.containsLongExpression(gNode) || gNode.hasName("AnnotationMethod") && this.containsLongExpression(gNode);
    }

    protected void printDeclsAndStmts(GNode gNode) {
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
        this.isDeclaration = false;
        this.isStatement = false;
        GNode gNode2 = null;
        for (Object object : gNode) {
            Node node = (Node)object;
            if (null == node) continue;
            GNode gNode3 = GNode.cast(node);
            if (null != gNode2 && (gNode2.hasName("Block") || this.isLongDeclaration(gNode2) && gNode3.getName().endsWith("Declaration") || gNode3.hasName("Block") || this.isLongDeclaration(gNode3) || !gNode2.getName().endsWith("Declaration") && gNode3.getName().endsWith("Declaration"))) {
                this.printer.pln();
            }
            this.printer.p(node);
            if (this.isOpenLine) {
                this.printer.pln();
            }
            this.isOpenLine = false;
            gNode2 = gNode3;
        }
    }

    protected void formatAsTruthValue(Node node) {
        if (GNode.cast(node).hasName("AssignmentExpression")) {
            this.printer.p('(').p(node).p(')');
        } else {
            this.printer.p(node);
        }
    }

    protected void formatDimensions(int n) {
        for (int i = 0; i < n; ++i) {
            this.printer.p("[]");
        }
    }

    protected boolean startStatement(int n) {
        if (this.isIfElse && (1 == n || 2 == n)) {
            this.isNested = false;
        } else {
            if (this.isOpenLine) {
                this.printer.pln();
            }
            if (this.isDeclaration) {
                this.printer.pln();
            }
            if (this.isNested) {
                this.printer.incr();
            }
        }
        this.isOpenLine = false;
        boolean bl = this.isNested;
        this.isNested = false;
        return bl;
    }

    protected void prepareNested() {
        this.isDeclaration = false;
        this.isStatement = false;
        this.isOpenLine = true;
        this.isNested = true;
    }

    protected void endStatement(boolean bl) {
        if (bl) {
            this.printer.decr();
        }
        this.isDeclaration = false;
        this.isStatement = true;
    }

    protected int enterContext(int n) {
        int n2 = this.precedence;
        this.precedence = n;
        return n2;
    }

    protected int enterContext() {
        int n = this.precedence++;
        return n;
    }

    protected void exitContext(int n) {
        this.precedence = n;
    }

    protected int startExpression(int n) {
        if (n < this.precedence) {
            this.printer.p('(');
        }
        int n2 = this.precedence;
        this.precedence = n;
        return n2;
    }

    protected void endExpression(int n) {
        if (this.precedence < n) {
            this.printer.p(')');
        }
        this.precedence = n;
    }

    public void visit(Comment comment) {
        this.printer.indent().p(comment).p(comment.getNode());
    }

    public void visitCompilationUnit(GNode gNode) {
        this.packageName = null;
        this.isDeclaration = false;
        this.isStatement = false;
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
        this.precedence = 0;
        this.printDeclsAndStmts(gNode);
    }

    public void visitPackageDeclaration(GNode gNode) {
        GNode gNode2 = gNode.getGeneric(1);
        this.packageName = this.fold(gNode2, gNode2.size());
        this.printer.indent().p(gNode.getNode(0)).p("package ").p(gNode.getNode(1)).pln(';');
        this.isOpenLine = false;
    }

    public void visitImportDeclaration(GNode gNode) {
        String string = this.getPackage(gNode);
        if (null != this.packageName && !string.equals(this.packageName)) {
            this.printer.pln();
        }
        this.packageName = string;
        this.printer.indent().p("import ");
        if (null != gNode.get(0)) {
            this.printer.p("static ");
        }
        this.printer.p(gNode.getNode(1));
        if (null != gNode.get(2)) {
            this.printer.p(".*");
        }
        this.printer.pln(';');
        this.isOpenLine = false;
    }

    public void visitModifiers(GNode gNode) {
        for (Object object : gNode) {
            this.printer.p((Node)object).p(' ');
        }
    }

    public void visitModifier(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitFormalParameter(GNode gNode) {
        this.printer.p(gNode.getNode(0)).p(gNode.getNode(1));
        if (null != gNode.get(2)) {
            this.printer.p(gNode.getString(2));
        }
        this.printer.p(' ').p(gNode.getString(3)).p(gNode.getNode(4));
    }

    public void visitFinalClause(GNode gNode) {
        this.printer.p("final");
    }

    public void visitFormalParameters(GNode gNode) {
        this.printer.p('(');
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p(')');
    }

    public void visitDeclarator(GNode gNode) {
        this.printer.p(gNode.getString(0));
        if (null != gNode.get(1)) {
            this.printer.p(' ');
            if (Token.test(gNode.get(1))) {
                this.formatDimensions(gNode.getString(1).length());
            } else {
                this.printer.p(gNode.getNode(1));
            }
        }
        if (null != gNode.get(2)) {
            this.printer.p(" = ").p(gNode.getNode(2));
        }
    }

    public void visitDeclarators(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitAnnotations(GNode gNode) {
        for (Object object : gNode) {
            this.printer.p((Node)object).p(' ');
        }
    }

    public void visitAnnotation(GNode gNode) {
        this.printer.p('@').p(gNode.getNode(0));
        if (null != gNode.get(1)) {
            this.printer.p('(').p(gNode.getNode(1)).p(')');
        }
    }

    public void visitElementValuePairs(GNode gNode) {
        boolean bl = true;
        for (Object object : gNode) {
            if (bl) {
                bl = false;
            } else {
                this.printer.p(", ");
            }
            this.printer.p((Node)object);
        }
    }

    public void visitElementValuePair(GNode gNode) {
        this.printer.p(gNode.getNode(0)).p(" = ").p(gNode.getNode(1));
    }

    public void visitDefaultValue(GNode gNode) {
        this.printer.p("default ").p(gNode.getNode(0));
    }

    public void visitClassBody(GNode gNode) {
        if (this.isOpenLine) {
            this.printer.p(' ');
        }
        this.printer.pln('{').incr();
        this.printDeclsAndStmts(gNode);
        this.printer.decr().indent().p('}');
        this.isOpenLine = true;
        this.isNested = false;
        this.isIfElse = false;
    }

    public void visitFieldDeclaration(GNode gNode) {
        this.printer.indent().p(gNode.getNode(0)).p(gNode.getNode(1)).p(' ').p(gNode.getNode(2)).p(';').pln();
        this.isDeclaration = true;
        this.isOpenLine = false;
    }

    public void visitMethodDeclaration(GNode gNode) {
        this.printer.indent().p(gNode.getNode(0));
        if (null != gNode.get(1)) {
            this.printer.p(gNode.getNode(1)).p(' ');
        }
        this.printer.p(gNode.getNode(2));
        if (!"<init>".equals(gNode.get(3))) {
            this.printer.p(' ').p(gNode.getString(3));
        }
        this.printer.p(gNode.getNode(4));
        if (null != gNode.get(5)) {
            this.printer.p(' ').p(gNode.getNode(5));
        }
        if (null != gNode.get(6)) {
            this.printer.p(' ').p(gNode.getNode(6));
        }
        if (null != gNode.get(7)) {
            this.isOpenLine = true;
            this.printer.p(gNode.getNode(7)).pln();
        } else {
            this.printer.pln(';');
        }
        this.isOpenLine = false;
    }

    public void visitConstructorDeclaration(GNode gNode) {
        this.printer.indent().p(gNode.getNode(0));
        if (null != gNode.get(1)) {
            this.printer.p(gNode.getNode(1));
        }
        this.printer.p(gNode.getString(2)).p(gNode.getNode(3));
        if (null != gNode.get(4)) {
            this.printer.p(gNode.getNode(4));
        }
        this.isOpenLine = true;
        this.printer.p(gNode.getNode(5));
    }

    public void visitClassDeclaration(GNode gNode) {
        this.printer.indent().p(gNode.getNode(0)).p("class ").p(gNode.getString(1)).p(gNode.getNode(2));
        if (null != gNode.get(3)) {
            this.printer.p(' ').p(gNode.getNode(3));
        }
        if (null != gNode.get(4)) {
            this.printer.p(' ').p(gNode.getNode(4));
        }
        this.isOpenLine = true;
        this.printer.p(gNode.getNode(5)).pln();
        this.isDeclaration = true;
        this.isOpenLine = false;
    }

    public void visitInterfaceDeclaration(GNode gNode) {
        this.printer.indent().p(gNode.getNode(0)).p("interface ").p(gNode.getString(1)).p(gNode.getNode(2));
        if (null != gNode.get(3)) {
            this.printer.p(' ').p(gNode.getNode(3));
        }
        this.isOpenLine = true;
        this.printer.p(gNode.getNode(4)).pln();
        this.isDeclaration = true;
        this.isOpenLine = false;
    }

    public void visitAnnotationDeclaration(GNode gNode) {
        this.printer.indent().p(gNode.getNode(0)).p("@interface ").p(gNode.getString(1));
        this.isOpenLine = true;
        this.printer.p(gNode.getNode(2)).pln();
        this.isDeclaration = true;
        this.isOpenLine = false;
    }

    public void visitAnnotationMethod(GNode gNode) {
        this.printer.indent().p(gNode.getNode(0)).p(gNode.getNode(1)).p(' ').p(gNode.getString(2)).p("()");
        if (null != gNode.get(3)) {
            this.printer.p(" default ").p(gNode.getNode(3));
        }
        this.printer.pln(';');
        this.isOpenLine = false;
    }

    public void visitEnumDeclaration(GNode gNode) {
        this.printer.indent().p(gNode.getNode(0)).p("enum ").p(gNode.getString(1));
        if (null != gNode.get(2)) {
            this.printer.p(' ').p(gNode.getNode(2));
        }
        this.printer.pln(" {").incr();
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
        this.printer.p(gNode.getNode(3));
        if (null != gNode.get(4)) {
            this.printer.pln(';').pln();
            this.isOpenLine = false;
            this.isNested = false;
            this.isIfElse = false;
            this.printer.p(gNode.getNode(4));
        }
        if (this.isOpenLine) {
            this.printer.pln();
        }
        this.printer.decr().indent().pln('}');
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
        this.isDeclaration = true;
    }

    public void visitEnumConstants(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.isDeclaration = false;
            this.printer.indent().p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.pln(',');
            if (!this.isDeclaration) continue;
            this.printer.pln();
        }
        this.isOpenLine = true;
    }

    public void visitEnumConstant(GNode gNode) {
        this.printer.p(gNode.getNode(0)).p(gNode.getString(1)).p(gNode.getNode(2));
        if (null != gNode.get(3)) {
            this.isOpenLine = true;
            this.printer.p(gNode.getNode(3));
            this.isDeclaration = true;
        } else {
            this.isDeclaration = false;
        }
    }

    public void visitEnumMembers(GNode gNode) {
        this.printDeclsAndStmts(gNode);
    }

    public void visitBlockDeclaration(GNode gNode) {
        this.printer.indent();
        if (null != gNode.get(0)) {
            this.printer.p(gNode.getString(0));
            this.isOpenLine = true;
        }
        this.printer.p(gNode.getNode(1)).pln();
        this.isOpenLine = false;
    }

    public void visitEmptyDeclaration(GNode gNode) {
    }

    public void visitThrowsClause(GNode gNode) {
        this.printer.p("throws ");
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitExtension(GNode gNode) {
        this.printer.p("extends ");
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitImplementation(GNode gNode) {
        this.printer.p("implements ");
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitBlock(GNode gNode) {
        if (this.isOpenLine) {
            this.printer.p(' ');
        } else {
            this.printer.indent();
        }
        this.printer.pln('{').incr();
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
        this.isDeclaration = false;
        this.isStatement = false;
        this.printDeclsAndStmts(gNode);
        this.printer.decr().indent().p('}');
        this.isOpenLine = true;
        this.isNested = false;
        this.isIfElse = false;
    }

    public void visitConditionalStatement(GNode gNode) {
        int n = null == gNode.get(2) ? 1 : 2;
        boolean bl = this.startStatement(n);
        if (this.isIfElse) {
            this.printer.p(' ');
        } else {
            this.printer.indent();
        }
        this.printer.p("if (").p(gNode.getNode(0)).p(')');
        this.prepareNested();
        this.printer.p(gNode.getNode(1));
        if (null != gNode.get(2)) {
            if (this.isOpenLine) {
                this.printer.p(" else");
            } else {
                this.printer.indent().p("else");
            }
            this.prepareNested();
            boolean bl2 = this.isIfElse;
            this.isIfElse = true;
            this.printer.p(gNode.getNode(2));
            this.isIfElse = bl2;
        }
        this.endStatement(bl);
    }

    public void visitForStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("for (").p(gNode.getNode(0)).p(')');
        this.prepareNested();
        this.printer.p(gNode.getNode(1));
        this.endStatement(bl);
    }

    public void visitBasicForControl(GNode gNode) {
        int n;
        this.printer.p(gNode.getNode(0));
        if (null != gNode.get(1)) {
            this.printer.p(gNode.getNode(1)).p(' ');
        }
        int n2 = this.enterContext(0);
        this.printer.p(gNode.getNode(2)).p("; ");
        this.exitContext(n2);
        if (null != gNode.get(3)) {
            n = this.enterContext(0);
            this.formatAsTruthValue(gNode.getNode(3));
            this.exitContext(n);
        }
        this.printer.p("; ");
        n = this.enterContext(0);
        this.printer.p(gNode.getNode(4));
        this.exitContext(n);
    }

    public void visitEnhancedForControl(GNode gNode) {
        this.printer.p(gNode.getNode(0)).p(gNode.getNode(1)).p(' ').p(gNode.getString(2)).p(" : ");
        int n = this.enterContext(0);
        this.printer.p(gNode.getNode(3));
        this.exitContext(n);
    }

    public void visitWhileStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("while (").p(gNode.getNode(0)).p(')');
        this.prepareNested();
        this.printer.p(gNode.getNode(1));
        this.endStatement(bl);
    }

    public void visitDoWhileStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("do");
        this.prepareNested();
        this.printer.p(gNode.getNode(0));
        if (this.isOpenLine) {
            this.printer.p(' ');
        } else {
            this.printer.indent();
        }
        this.printer.p("while (").p(gNode.getNode(1)).pln(");");
        this.endStatement(bl);
        this.isOpenLine = false;
    }

    public void visitTryCatchFinallyStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.isOpenLine = true;
        this.printer.indent().p("try").p(gNode.getNode(0)).p(' ');
        Iterator<Object> iterator = gNode.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            GNode gNode2 = GNode.cast(iterator.next());
            this.isOpenLine = true;
            if (iterator.hasNext()) {
                this.printer.p(gNode2).p(' ');
                continue;
            }
            if (null == gNode2) continue;
            this.printer.p("finally").p(gNode2);
        }
        this.endStatement(bl);
    }

    public void visitCatchClause(GNode gNode) {
        this.printer.p("catch (").p(gNode.getNode(0)).p(")").p(gNode.getNode(1));
    }

    public void visitSwitchStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        int n = this.enterContext(1);
        this.printer.indent().p("switch (").p(gNode.getNode(0)).pln(") {").incr();
        this.exitContext(n);
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
        Iterator<Object> iterator = gNode.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
        }
        if (this.isOpenLine) {
            this.printer.pln();
        }
        this.printer.decr().indent().p('}');
        this.isOpenLine = true;
        this.isNested = false;
        this.isIfElse = false;
        this.endStatement(bl);
    }

    public void visitCaseClause(GNode gNode) {
        boolean bl = this.startStatement(0);
        int n = this.enterContext(1);
        this.printer.indentLess().p("case ").p(gNode.getNode(0)).pln(':');
        this.exitContext(n);
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
        Iterator<Object> iterator = gNode.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
        }
        this.endStatement(bl);
    }

    public void visitDefaultClause(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indentLess().pln("default:");
        this.isOpenLine = false;
        this.isNested = false;
        this.isIfElse = false;
        for (Object object : gNode) {
            this.printer.p((Node)object);
        }
        this.endStatement(bl);
    }

    public void visitSynchronizedStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("synchronized (").p(gNode.getNode(0)).p(')');
        this.prepareNested();
        this.printer.p(gNode.getNode(1));
        this.endStatement(bl);
    }

    public void visitReturnStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("return");
        if (null != gNode.get(0)) {
            this.printer.p(' ').p(gNode.getNode(0));
        }
        this.printer.pln(';');
        this.endStatement(bl);
        this.isOpenLine = false;
    }

    public void visitThrowStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("throw").p(' ').p(gNode.getNode(0));
        this.printer.pln(';');
        this.endStatement(bl);
        this.isOpenLine = false;
    }

    public void visitBreakStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("break");
        if (gNode.getString(0) != null) {
            this.printer.p(' ').p(gNode.getString(0));
        }
        this.printer.pln(';');
        this.endStatement(bl);
        this.isOpenLine = false;
    }

    public void visitContinueStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("continue");
        if (null != gNode.getString(0)) {
            this.printer.p(' ').p(gNode.getString(0));
        }
        this.printer.p(';').pln();
        this.endStatement(bl);
        this.isOpenLine = false;
    }

    public void visitLabeledStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p(gNode.getString(0)).p(": ").p(gNode.getNode(1)).pln();
        this.endStatement(bl);
        this.isOpenLine = false;
    }

    public void visitExpressionStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        int n = this.enterContext(0);
        this.printer.indent().p(gNode.getNode(0)).pln(';');
        this.exitContext(n);
        this.endStatement(bl);
        this.isOpenLine = false;
    }

    public void visitAssertStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().p("assert ").p(gNode.getNode(0));
        if (null != gNode.get(1)) {
            this.printer.p(" : ").p(gNode.getNode(1));
        }
        this.printer.pln(';');
        this.endStatement(bl);
        this.isOpenLine = false;
    }

    public void visitEmptyStatement(GNode gNode) {
        boolean bl = this.startStatement(0);
        this.printer.indent().pln(';');
        this.endStatement(bl);
        this.isOpenLine = false;
    }

    public void visitExpressionList(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            int n = this.enterContext(10);
            this.printer.p((Node)iterator.next());
            this.exitContext(n);
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
    }

    public void visitExpression(GNode gNode) {
        int n = this.startExpression(10);
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(0));
        this.exitContext(n2);
        this.printer.p(' ').p(gNode.getString(1)).p(' ').p(gNode.getNode(2));
        this.endExpression(n);
    }

    public void visitConditionalExpression(GNode gNode) {
        int n = this.startExpression(20);
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(0)).p(" ? ");
        this.exitContext(n2);
        int n3 = this.enterContext();
        if (null != gNode.get(1)) {
            this.printer.p(gNode.getNode(1)).p(" : ");
        } else {
            this.printer.p(" /* Empty */ : ");
        }
        this.exitContext(n3);
        this.printer.p(gNode.getNode(2));
        this.endExpression(n);
    }

    public void visitLogicalOrExpression(GNode gNode) {
        int n = this.startExpression(30);
        this.printer.p(gNode.getNode(0));
        this.printer.p(" || ");
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(1));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitLogicalAndExpression(GNode gNode) {
        int n = this.startExpression(40);
        this.printer.p(gNode.getNode(0));
        this.printer.p(" && ");
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(1));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitBitwiseOrExpression(GNode gNode) {
        int n = this.startExpression(50);
        this.printer.p(gNode.getNode(0));
        this.printer.p(" | ");
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(1));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitBitwiseXorExpression(GNode gNode) {
        int n = this.startExpression(60);
        this.printer.p(gNode.getNode(0));
        this.printer.p(" ^ ");
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(1));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitBitwiseAndExpression(GNode gNode) {
        int n = this.startExpression(70);
        this.printer.p(gNode.getNode(0)).p(" & ");
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(1));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitEqualityExpression(GNode gNode) {
        int n = this.startExpression(80);
        this.printer.p(gNode.getNode(0)).p(' ').p(gNode.getString(1)).p(' ');
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(2));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitInstanceOfExpression(GNode gNode) {
        int n = this.startExpression(90);
        this.printer.p(gNode.getNode(0)).p(' ').p("instanceof").p(' ');
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(1));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitRelationalExpression(GNode gNode) {
        int n = this.startExpression(100);
        this.printer.p(gNode.getNode(0)).p(' ').p(gNode.getString(1)).p(' ');
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(2));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitShiftExpression(GNode gNode) {
        int n = this.startExpression(110);
        this.printer.p(gNode.getNode(0));
        this.printer.p(' ').p(gNode.getString(1)).p(' ');
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(2));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitAdditiveExpression(GNode gNode) {
        int n = this.startExpression(120);
        this.printer.p(gNode.getNode(0)).p(' ').p(gNode.getString(1)).p(' ');
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(2));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitMultiplicativeExpression(GNode gNode) {
        int n = this.startExpression(130);
        this.printer.p(gNode.getNode(0)).p(' ').p(gNode.getString(1)).p(' ');
        int n2 = this.enterContext();
        this.printer.p(gNode.getNode(2));
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitUnaryExpression(GNode gNode) {
        int n = this.startExpression(150);
        this.printer.p(gNode.getString(0)).p(gNode.getNode(1));
        this.endExpression(n);
    }

    public void visitBitwiseNegationExpression(GNode gNode) {
        int n = this.startExpression(150);
        this.printer.p('~').p(gNode.getNode(0));
        this.endExpression(n);
    }

    public void visitLogicalNegationExpression(GNode gNode) {
        int n = this.startExpression(150);
        this.printer.p('!').p(gNode.getNode(0));
        this.endExpression(n);
    }

    public void visitBasicCastExpression(GNode gNode) {
        int n = this.startExpression(140);
        this.printer.p('(').p(gNode.getNode(0));
        if (null != gNode.get(1)) {
            this.printer.p(gNode.getNode(1));
        }
        this.printer.p(')').p(gNode.getNode(2));
        this.endExpression(n);
    }

    public void visitCastExpression(GNode gNode) {
        int n = this.startExpression(140);
        this.printer.p('(').p(gNode.getNode(0)).p(')').p(gNode.getNode(1));
        this.endExpression(n);
    }

    public void visitCallExpression(GNode gNode) {
        int n = this.startExpression(160);
        if (null != gNode.get(0)) {
            this.printer.p(gNode.getNode(0)).p('.');
        }
        this.printer.p(gNode.getNode(1)).p(gNode.getString(2)).p(gNode.getNode(3));
        this.endExpression(n);
    }

    public void visitSelectionExpression(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getNode(0)).p('.').p(gNode.getString(1));
        this.endExpression(n);
    }

    public void visitSubscriptExpression(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getNode(0)).p('[');
        int n2 = this.enterContext(0);
        this.printer.p(gNode.getNode(1)).p(']');
        this.exitContext(n2);
        this.endExpression(n);
    }

    public void visitPostfixExpression(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getNode(0)).p(gNode.getString(1));
        this.endExpression(n);
    }

    public void visitClassLiteralExpression(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getNode(0)).p(".class");
        this.endExpression(n);
    }

    public void visitThisExpression(GNode gNode) {
        int n = this.startExpression(160);
        if (null != gNode.get(0)) {
            this.printer.p(gNode.getNode(0)).p('.');
        }
        this.printer.p("this");
        this.endExpression(n);
    }

    public void visitSuperExpression(GNode gNode) {
        int n = this.startExpression(160);
        if (null != gNode.get(0)) {
            this.printer.p(gNode.getNode(0)).p('.');
        }
        this.printer.p("super");
        this.endExpression(n);
    }

    public void visitPrimaryIdentifier(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitNewClassExpression(GNode gNode) {
        int n = this.startExpression(160);
        if (null != gNode.get(0)) {
            this.printer.p(gNode.getNode(0)).p('.');
        }
        this.printer.p("new ");
        if (null != gNode.get(1)) {
            this.printer.p(gNode.getNode(1)).p(' ');
        }
        this.printer.p(gNode.getNode(2)).p(gNode.getNode(3));
        if (null != gNode.get(4)) {
            this.prepareNested();
            this.printer.p(gNode.getNode(4));
        }
        this.endExpression(n);
    }

    public void visitNewArrayExpression(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p("new ").p(gNode.getNode(0)).p(gNode.getNode(1)).p(gNode.getNode(2));
        if (null != gNode.get(3)) {
            this.printer.p(' ').p(gNode.getNode(3));
        }
        this.endExpression(n);
    }

    public void visitConcreteDimensions(GNode gNode) {
        for (Object object : gNode) {
            this.printer.p('[').p((Node)object).p(']');
        }
    }

    public void visitArrayInitializer(GNode gNode) {
        if (!gNode.isEmpty()) {
            this.printer.pln('{').incr().indent();
            Iterator<Object> iterator = gNode.iterator();
            while (iterator.hasNext()) {
                this.printer.buffer().p((Node)iterator.next());
                if (iterator.hasNext()) {
                    this.printer.p(", ");
                }
                this.printer.fit();
            }
            this.printer.pln().decr().indent().p('}');
        } else {
            this.printer.p("{ }");
        }
    }

    public void visitArguments(GNode gNode) {
        this.printer.p('(');
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            int n = this.enterContext(10);
            this.printer.p((Node)iterator.next());
            this.exitContext(n);
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p(')');
    }

    public void visitVoidType(GNode gNode) {
        this.printer.p("void");
    }

    public void visitType(GNode gNode) {
        this.printer.p(gNode.getNode(0));
        if (null != gNode.get(1)) {
            if (Token.test(gNode.get(1))) {
                this.formatDimensions(gNode.getString(1).length());
            } else {
                this.printer.p(' ').p(gNode.getNode(1)).p(' ');
            }
        }
    }

    public void visitPrimitiveType(GNode gNode) {
        this.printer.p(gNode.getString(0));
    }

    public void visitInstantiatedType(GNode gNode) {
        boolean bl = true;
        for (Object object : gNode) {
            if (bl) {
                bl = false;
            } else {
                this.printer.p('.');
            }
            this.printer.p((Node)object);
        }
    }

    public void visitTypeInstantiation(GNode gNode) {
        this.printer.p(gNode.getString(0)).p(gNode.getNode(1));
    }

    public void visitDimensions(GNode gNode) {
        for (int i = 0; i < gNode.size(); ++i) {
            this.printer.p("[]");
        }
    }

    public void visitTypeParameters(GNode gNode) {
        this.printer.p('<');
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p('>');
    }

    public void visitTypeParameter(GNode gNode) {
        this.printer.p(gNode.getString(0));
        if (null != gNode.get(1)) {
            this.printer.p(" extends ").p(gNode.getNode(1));
        }
    }

    public void visitBound(GNode gNode) {
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(" & ");
        }
    }

    public void visitTypeArguments(GNode gNode) {
        this.printer.p('<');
        Iterator<Object> iterator = gNode.iterator();
        while (iterator.hasNext()) {
            this.printer.p((Node)iterator.next());
            if (!iterator.hasNext()) continue;
            this.printer.p(", ");
        }
        this.printer.p('>');
    }

    public void visitWildcard(GNode gNode) {
        this.printer.p('?').p(gNode.getNode(0));
    }

    public void visitWildcardBound(GNode gNode) {
        this.printer.p(' ').p(gNode.getString(0)).p(' ').p(gNode.getNode(1));
    }

    public void visitIntegerLiteral(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitFloatingPointLiteral(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitCharacterLiteral(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitStringLiteral(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitBooleanLiteral(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p(gNode.getString(0));
        this.endExpression(n);
    }

    public void visitNullLiteral(GNode gNode) {
        int n = this.startExpression(160);
        this.printer.p("null");
        this.endExpression(n);
    }

    public void visitQualifiedIdentifier(GNode gNode) {
        int n = this.startExpression(160);
        if (1 == gNode.size()) {
            this.printer.p(gNode.getString(0));
        } else {
            Iterator<Object> iterator = gNode.iterator();
            while (iterator.hasNext()) {
                this.printer.p(Token.cast(iterator.next()));
                if (!iterator.hasNext()) continue;
                this.printer.p('.');
            }
        }
        this.endExpression(n);
    }
}

