/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.lang.JavaEntities;
import xtc.tree.Attribute;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.type.AliasT;
import xtc.type.ClassOrInterfaceT;
import xtc.type.ClassT;
import xtc.type.InterfaceT;
import xtc.type.Language;
import xtc.type.MethodT;
import xtc.type.PackageT;
import xtc.type.Type;
import xtc.type.VariableT;
import xtc.util.Runtime;
import xtc.util.SymbolTable;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaExternalAnalyzer
extends Visitor {
    protected static List<Attribute> MODIFIERS_CLASS = new ArrayList<Attribute>();
    protected static List<Attribute> MODIFIERS_CONSTRUCTOR = new ArrayList<Attribute>();
    protected static List<Attribute> MODIFIERS_FIELD = new ArrayList<Attribute>();
    protected static List<Attribute> MODIFIERS_INTERFACE = new ArrayList<Attribute>();
    protected static List<Attribute> MODIFIERS_INTERFACE_FIELD = new ArrayList<Attribute>();
    protected static List<Attribute> MODIFIERS_INTERFACE_MEMBERTYPE = new ArrayList<Attribute>();
    protected static List<Attribute> MODIFIERS_INTERFACE_METHOD = new ArrayList<Attribute>();
    protected static List<Attribute> MODIFIERS_METHOD = new ArrayList<Attribute>();
    protected final Runtime _runtime;
    public final SymbolTable _table;

    protected static void addModifier(List<Attribute> list, String string) {
        if (!JavaExternalAnalyzer.hasModifier(list, string)) {
            list.add(JavaEntities.nameToModifier(string));
        }
    }

    protected static void addModifiers(List<Attribute> list, List<Attribute> list2) {
        for (Attribute attribute : list2) {
            if (list.contains(attribute)) continue;
            list.add(attribute);
        }
    }

    public static int countDimensions(GNode gNode) {
        return null == gNode ? 0 : gNode.size();
    }

    protected static boolean hasModifier(List<Attribute> list, String string) {
        return list.contains(JavaEntities.nameToModifier(string));
    }

    public JavaExternalAnalyzer(Runtime runtime, SymbolTable symbolTable) {
        this._runtime = runtime;
        this._table = symbolTable;
    }

    protected boolean assrt(GNode gNode, boolean bl, String string, Object ... objectArray) {
        return JavaEntities.runtimeAssrt(this._runtime, gNode, bl, string, objectArray);
    }

    protected void assrtDiffersFromEnclosing(GNode gNode, String string) {
        String string2 = Utilities.getName(string);
        String string3 = JavaEntities.currentPackage(this._table).getName();
        String string4 = 0 == string3.length() ? string : string.substring(string3.length() + 1);
        String string5 = Utilities.getQualifier(string4);
        if (null != string5) {
            String[] stringArray = Utilities.toComponents(string5);
            for (int i = 0; i < stringArray.length; ++i) {
                this.assrt(gNode, !stringArray[i].equals(string2), "name must not match enclosing type", new Object[0]);
            }
        }
    }

    protected void assrtLegalModifiers(GNode gNode, List<Attribute> list, List<Attribute> list2, String string) {
        boolean bl = JavaExternalAnalyzer.hasModifier(list2, "private");
        boolean bl2 = JavaExternalAnalyzer.hasModifier(list2, "protected");
        boolean bl3 = JavaExternalAnalyzer.hasModifier(list2, "public");
        this.assrt(gNode, !bl || !bl2, "conflicting modifiers private and protected", new Object[0]);
        this.assrt(gNode, !bl || !bl3, "conflicting modifiers private and public", new Object[0]);
        this.assrt(gNode, !bl2 || !bl3, "conflicting modifiers protected and public", new Object[0]);
        for (Attribute attribute : list2) {
            this.assrt(gNode, list.contains(attribute), "illegal %s modifier %s", string, attribute);
        }
        boolean bl4 = JavaExternalAnalyzer.hasModifier(list2, "final");
        boolean bl5 = JavaExternalAnalyzer.hasModifier(list2, "volatile");
        this.assrt(gNode, !bl4 || !bl5, "conflicting modifiers final and volatile", new Object[0]);
    }

    protected final String currentScopeName() {
        return this._table.current().getQualifiedName();
    }

    protected final Type declareDefaultConstructorIfNecessary() {
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.currentType(this._table);
        ClassOrInterfaceT classOrInterfaceT2 = JavaEntities.resolveToRawClassOrInterfaceT(classOrInterfaceT);
        for (Type iterable2 : classOrInterfaceT2.getMethods()) {
            if (!JavaEntities.isConstructor(classOrInterfaceT2, iterable2.toMethod())) continue;
            return null;
        }
        MethodT methodT = JavaEntities.newRawConstructor(classOrInterfaceT2, new ArrayList<Type>(), new ArrayList<Type>());
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        if (JavaEntities.hasModifier(classOrInterfaceT, "private")) {
            arrayList.add(JavaEntities.nameToModifier("private"));
        } else if (JavaEntities.hasModifier(classOrInterfaceT, "protected")) {
            arrayList.add(JavaEntities.nameToModifier("protected"));
        } else if (JavaEntities.hasModifier(classOrInterfaceT, "public")) {
            arrayList.add(JavaEntities.nameToModifier("public"));
        }
        for (Attribute attribute : arrayList) {
            methodT.addAttribute(attribute);
        }
        this._table.current().define("method(<init>)()", methodT);
        this._table.enter("method(<init>)()");
        methodT.scope(this._table.current().getQualifiedName());
        this._table.exit();
        assert (JavaEntities.isConstructor(classOrInterfaceT2, methodT));
        JavaEntities.currentType(this._table).getMethods().add(methodT);
        return methodT;
    }

    protected final List<Type> makeList(GNode gNode) {
        ArrayList<Type> arrayList = new ArrayList<Type>(gNode.size());
        for (Object object : gNode) {
            arrayList.add((Type)this.dispatch((Node)object));
        }
        return arrayList;
    }

    protected final boolean memberOfInterface() {
        if (!JavaEntities.isScopeForMember(this.currentScopeName())) {
            return false;
        }
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.currentType(this._table);
        return null != classOrInterfaceT && JavaEntities.isWrappedInterfaceT(classOrInterfaceT);
    }

    public final List<Type> processDeclarators(List<Attribute> list, Type type2, GNode gNode) {
        assert (JavaEntities.isRValueT(type2));
        ArrayList<Type> arrayList = new ArrayList<Type>();
        boolean bl = JavaEntities.isScopeLocal(this.currentScopeName());
        for (Object object : gNode) {
            GNode gNode2 = (GNode)object;
            String string = gNode2.getString(0);
            Type type3 = JavaEntities.typeWithDimensions(type2, JavaExternalAnalyzer.countDimensions(gNode2.getGeneric(1)));
            VariableT variableT = bl ? VariableT.newLocal(type3, string) : VariableT.newField(type3, string);
            for (Attribute attribute : list) {
                variableT.addAttribute(attribute);
            }
            variableT.language(Language.JAVA);
            assert (!bl ? JavaEntities.isFieldT(variableT) : JavaEntities.isLocalT(variableT));
            if (null == this._table.current().lookupLocally(string)) {
                arrayList.add(variableT);
                this._table.current().define(string, variableT);
                variableT.scope(this._table.current().getQualifiedName());
                if (!bl) {
                    JavaEntities.currentType(this._table).getFields().add(variableT);
                }
            } else if (bl) {
                this._runtime.error("duplicate variable declaration " + string, gNode2);
            } else {
                this._runtime.error("duplicate field declaration " + string, gNode2);
            }
            gNode2.setProperty("xtc.Constants.Type", variableT);
        }
        return arrayList;
    }

    public final void visitBlockDeclaration(GNode gNode) {
        assert (2 == gNode.size());
    }

    public final void visitClassBody(GNode gNode) {
        for (Object object : gNode) {
            this.dispatch((Node)object);
        }
    }

    public final ClassT visitClassDeclaration(GNode gNode) {
        ArrayList<Type> arrayList;
        Type type2;
        Object object2;
        List list = (List)this.dispatch(gNode.getNode(0));
        boolean bl = JavaEntities.isScopeForMember(this.currentScopeName());
        if (bl) {
            object2 = JavaEntities.currentType(this._table);
            if (JavaEntities.isWrappedInterfaceT((Type)object2)) {
                JavaExternalAnalyzer.addModifiers(list, MODIFIERS_INTERFACE_MEMBERTYPE);
            }
            if (JavaEntities.hasModifier((Type)object2, "strictfp")) {
                JavaExternalAnalyzer.addModifier(list, "strictfp");
            }
            if (JavaExternalAnalyzer.hasModifier(list, "static")) {
                this.assrt(gNode, JavaEntities.hasModifier((Type)object2, "static") || JavaEntities.isTypeTopLevel((ClassOrInterfaceT)object2), "illegal context for static member", new Object[0]);
            }
        }
        this.assrtLegalModifiers(gNode.getGeneric(0), MODIFIERS_CLASS, list, "class");
        if (JavaExternalAnalyzer.hasModifier(list, "public")) {
            this.assrt(gNode, bl || JavaEntities.isScopeTopLevel(this.currentScopeName()), "public class must be member or top-level", new Object[0]);
        }
        if (JavaExternalAnalyzer.hasModifier(list, "protected") || JavaExternalAnalyzer.hasModifier(list, "private")) {
            this.assrt(gNode, bl && !this.memberOfInterface(), "private or protected class must be member of class", new Object[0]);
        }
        if (JavaExternalAnalyzer.hasModifier(list, "static")) {
            this.assrt(gNode, bl, "static class must be member", new Object[0]);
        }
        this.assrt(gNode, !JavaExternalAnalyzer.hasModifier(list, "final") || !JavaExternalAnalyzer.hasModifier(list, "abstract"), "can not be both abstract and final", new Object[0]);
        object2 = gNode.getString(1);
        String string = JavaEntities.canonicalName(this._table, (String)object2);
        this.assrtDiffersFromEnclosing(gNode, string);
        List<Type> list2 = JavaEntities.typeList((List)this.dispatch(gNode.getNode(3)));
        if (null == list2) {
            type2 = JavaEntities.tObjectAlias(this._table);
        } else {
            this.assrt(gNode, 1 == list2.size(), "can only extend one class", new Object[0]);
            this.assrt(gNode, !"java.lang.Object".equals(string), "Object can not have an extends clause", new Object[0]);
            type2 = list2.get(0);
        }
        this.assrt(gNode.getGeneric(0), JavaEntities.isWrappedClassT(type2), "class can only extend class", new Object[0]);
        List<Type> list3 = arrayList = gNode.get(4) == null ? new ArrayList<Type>() : JavaEntities.typeList((List)this.dispatch(gNode.getNode(4)));
        if ("java.lang.Object".equals(string)) {
            this.assrt(gNode, 0 == arrayList.size(), "Object can not have an implements clause", new Object[0]);
        }
        for (Type object3 : arrayList) {
            this.assrt(gNode.getGeneric(4), JavaEntities.isWrappedInterfaceT(object3), "class can only implement interface", new Object[0]);
        }
        ClassT classT = new ClassT(string, type2, arrayList, new ArrayList<Type>(), new ArrayList<Type>());
        for (Attribute attribute : list) {
            classT.addAttribute(attribute);
        }
        String string2 = SymbolTable.toTagName((String)object2);
        assert (null == this._table.current().lookupLocally(string2));
        this._table.current().define(string2, classT);
        this._table.enter((String)object2);
        classT.scope(this._table.current().getQualifiedName());
        this.dispatch(gNode.getNode(5));
        this.declareDefaultConstructorIfNecessary();
        this._table.exit();
        assert (classT.isClass());
        return classT;
    }

    public final void visitCompilationUnit(GNode gNode) {
        if (null == gNode.get(0)) {
            this.visitPackageDeclaration(null);
        } else {
            this.dispatch(gNode.getNode(0));
        }
        this._table.enter(JavaEntities.fileNameToScopeName(gNode.getLocation().file));
        for (int i = 1; i < gNode.size(); ++i) {
            GNode gNode2 = gNode.getGeneric(i);
            this.assrt(gNode, gNode2.hasName("ImportDeclaration") || gNode2.hasName("ClassDeclaration") || gNode2.hasName("InterfaceDeclaration") || gNode2.hasName("EmptyDeclaration"), "unexpected top-level %s", gNode2.getName());
            this.dispatch(gNode2);
        }
        this._table.setScope(this._table.root());
    }

    public final void visitEmptyDeclaration(GNode gNode) {
        assert (0 == gNode.size());
    }

    public final List<Type> visitExtension(GNode gNode) {
        List<Type> list = this.makeList(gNode);
        for (Type type2 : list) {
            this.assrt(gNode, JavaEntities.isWrappedClassT(type2) || JavaEntities.isWrappedInterfaceT(type2), "supertype must be class or interface", new Object[0]);
        }
        return list;
    }

    public final List<Type> visitFieldDeclaration(GNode gNode) {
        List list = (List)this.dispatch(gNode.getNode(0));
        if (this.memberOfInterface()) {
            JavaExternalAnalyzer.addModifiers(list, MODIFIERS_INTERFACE_FIELD);
            this.assrtLegalModifiers(gNode, MODIFIERS_INTERFACE_FIELD, list, "interface field");
        } else {
            this.assrtLegalModifiers(gNode, MODIFIERS_FIELD, list, "field");
        }
        Type type2 = (Type)this.dispatch(gNode.getNode(1));
        this.assrt(gNode.getGeneric(1), JavaEntities.isRValueT(type2), "illegal type for field", new Object[0]);
        return this.processDeclarators(list, type2, gNode.getGeneric(2));
    }

    public final Type visitFormalParameter(GNode gNode) {
        assert (null == gNode.get(4)) : "must run JavaAstSimplifier first";
        String string = gNode.getString(3);
        VariableT variableT = VariableT.newParam((Type)this.dispatch(gNode.getNode(1)), string);
        variableT.language(Language.JAVA);
        if (gNode.getGeneric(0).size() != 0) {
            variableT.addAttribute(JavaEntities.nameToModifier("final"));
        }
        if (null == this._table.current().lookupLocally(string)) {
            this._table.current().define(string, variableT);
            variableT.scope(this._table.current().getQualifiedName());
        } else {
            this._runtime.error("duplicate parameter declaration " + string, gNode);
        }
        assert (JavaEntities.isParameterT(variableT));
        return variableT;
    }

    public final List<Type> visitFormalParameters(GNode gNode) {
        return this.makeList(gNode);
    }

    public final List<Type> visitImplementation(GNode gNode) {
        List<Type> list = this.makeList(gNode);
        Iterator<Object> iterator = gNode.iterator();
        Iterator<Type> iterator2 = list.iterator();
        while (iterator2.hasNext()) {
            this.assrt((GNode)iterator.next(), JavaEntities.isWrappedInterfaceT(iterator2.next()), "supertype must be class or interface", new Object[0]);
        }
        return list;
    }

    public final void visitImportDeclaration(GNode gNode) {
        String string = (String)this.dispatch(gNode.getNode(1));
        if (gNode.get(2) == null) {
            AliasT aliasT = new AliasT(string);
            String string2 = Utilities.unqualify(string);
            this.assrt(gNode, JavaEntities.isWrappedClassT(aliasT) || JavaEntities.isWrappedInterfaceT(aliasT), "import must be class or interface", new Object[0]);
            this._table.current().define(SymbolTable.toTagName(string2), aliasT);
        } else {
            PackageT packageT = JavaEntities.canonicalNameToPackage(this._table, string);
            this._table.current().addDefinition("imports(*)", packageT);
        }
    }

    public final InterfaceT visitInterfaceDeclaration(GNode gNode) {
        Object object;
        List list = (List)this.dispatch(gNode.getNode(0));
        JavaExternalAnalyzer.addModifier(list, "abstract");
        boolean bl = JavaEntities.isScopeForMember(this.currentScopeName());
        if (bl) {
            object = JavaEntities.currentType(this._table);
            if (((Type)object).isInterface()) {
                JavaExternalAnalyzer.addModifiers(list, MODIFIERS_INTERFACE_MEMBERTYPE);
            }
            if (JavaEntities.hasModifier((Type)object, "strictfp")) {
                JavaExternalAnalyzer.addModifier(list, "strictfp");
            }
            JavaExternalAnalyzer.addModifier(list, "static");
            this.assrt(gNode, JavaEntities.hasModifier((Type)object, "static") || JavaEntities.isTypeTopLevel((ClassOrInterfaceT)object), "illegal context for static member", new Object[0]);
        }
        if (JavaExternalAnalyzer.hasModifier(list, "protected") || JavaExternalAnalyzer.hasModifier(list, "private")) {
            this.assrt(gNode, bl, "private or protected interface must be member", new Object[0]);
        }
        if (JavaExternalAnalyzer.hasModifier(list, "static")) {
            this.assrt(gNode, bl, "static interface must be member", new Object[0]);
        }
        this.assrtLegalModifiers(gNode, MODIFIERS_INTERFACE, list, "interface");
        object = gNode.getString(1);
        String string = JavaEntities.canonicalName(this._table, (String)object);
        this.assrtDiffersFromEnclosing(gNode, string);
        ArrayList<Type> arrayList = null == gNode.get(3) ? new ArrayList<Type>() : JavaEntities.typeList((List)this.dispatch(gNode.getNode(3)));
        InterfaceT interfaceT = new InterfaceT(string, arrayList, new ArrayList<Type>(), new ArrayList<Type>());
        for (Node node : list) {
            interfaceT.addAttribute((Attribute)node);
        }
        String string2 = SymbolTable.toTagName((String)object);
        if (null == this._table.current().lookupLocally(string2)) {
            Node node;
            this._table.current().define(string2, interfaceT);
            this._table.enter((String)object);
            interfaceT.scope(this._table.current().getQualifiedName());
            node = gNode.getGeneric(4);
            for (int i = 0; i < node.size(); ++i) {
                GNode gNode2 = node.getGeneric(i);
                this.assrt(gNode, gNode2.hasName("EmptyDeclaration") || gNode2.hasName("FieldDeclaration") || gNode2.hasName("MethodDeclaration") || gNode2.hasName("ClassDeclaration") || gNode2.hasName("InterfaceDeclaration"), "illegal interface member", new Object[0]);
                this.dispatch(gNode2);
            }
            this._table.exit();
            if (JavaEntities.isTypeNested(interfaceT)) {
                this.assrt(gNode, !JavaEntities.isTypeInner(JavaEntities.declaringType(this._table, interfaceT)), "inner classes may not declare member interfaces", new Object[0]);
            }
        } else {
            this._runtime.error("duplicate declaration " + string, gNode);
        }
        assert (interfaceT.isInterface());
        return interfaceT;
    }

    public final Type visitMethodDeclaration(GNode gNode) {
        Type type2;
        assert (null == gNode.get(5)) : "must run JavaAstSimplifier first";
        List list = (List)this.dispatch(gNode.getNode(0));
        String string = gNode.getString(3);
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.currentType(this._table);
        boolean bl = JavaEntities.typeToSimpleName(classOrInterfaceT).equals(string);
        Type type3 = bl ? (JavaEntities.constructorsReturnVoid() ? JavaEntities.nameToBaseType("void") : classOrInterfaceT) : (type2 = (Type)this.dispatch(gNode.getNode(2)));
        if (!bl) {
            this.assrt(gNode, null != gNode.get(2), "missing return type", new Object[0]);
            if (JavaEntities.hasModifier(classOrInterfaceT, "strictfp")) {
                JavaExternalAnalyzer.addModifier(list, "strictfp");
            }
            if (JavaEntities.hasModifier(classOrInterfaceT, "final")) {
                JavaExternalAnalyzer.addModifier(list, "final");
            }
            if (JavaExternalAnalyzer.hasModifier(list, "private")) {
                JavaExternalAnalyzer.addModifier(list, "final");
            }
        }
        if (this.memberOfInterface()) {
            this.assrt(gNode, !bl, "interface can not have constructor", new Object[0]);
            JavaExternalAnalyzer.addModifiers(list, MODIFIERS_INTERFACE_METHOD);
            this.assrtLegalModifiers(gNode, MODIFIERS_INTERFACE_METHOD, list, "interface method");
        } else if (bl) {
            this.assrtLegalModifiers(gNode, MODIFIERS_CONSTRUCTOR, list, "constructor");
        } else {
            this.assrtLegalModifiers(gNode, MODIFIERS_METHOD, list, "method");
        }
        if (JavaExternalAnalyzer.hasModifier(list, "static")) {
            this.assrt(gNode, JavaEntities.hasModifier(classOrInterfaceT, "static") || JavaEntities.isTypeTopLevel(classOrInterfaceT), "illegal context for static member", new Object[0]);
        }
        ArrayList<Type> arrayList = null == gNode.get(6) ? new ArrayList<Type>() : JavaEntities.typeList((List)this.dispatch(gNode.getNode(6)));
        String string2 = JavaEntities.methodSymbolFromAst(gNode);
        this._table.enter(string2);
        List<Type> list2 = JavaEntities.typeList((List)this.dispatch(gNode.getNode(4)));
        MethodT methodT = new MethodT(type2, string, list2, false, arrayList);
        for (Attribute attribute : list) {
            methodT.addAttribute(attribute);
        }
        if (JavaEntities.hasModifier(methodT, "abstract")) {
            this.assrt(gNode, !JavaEntities.hasModifier(methodT, "private") && !JavaEntities.hasModifier(methodT, "static") && !JavaEntities.hasModifier(methodT, "final") && !JavaEntities.hasModifier(methodT, "native") && !JavaEntities.hasModifier(methodT, "strictfp") && !JavaEntities.hasModifier(methodT, "synchronized"), "conflicting modifiers", new Object[0]);
        }
        this.assrt(gNode, !JavaEntities.hasModifier(methodT, "strictfp") || !JavaEntities.hasModifier(methodT, "native"), "conflicting modifiers", new Object[0]);
        methodT.scope(this._table.current().getQualifiedName());
        this._table.exit();
        this._table.current().define(string2, methodT);
        JavaEntities.currentType(this._table).getMethods().add(methodT);
        assert (((Type)methodT).isMethod());
        return methodT;
    }

    public final List<Attribute> visitModifiers(GNode gNode) {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        for (int i = 0; i < gNode.size(); ++i) {
            String string = gNode.getGeneric(i).getString(0);
            Attribute attribute = JavaEntities.nameToModifier(string);
            if (null == attribute) {
                this._runtime.error("unexpected modifier " + string, gNode);
                continue;
            }
            if (arrayList.contains(attribute)) {
                this._runtime.error("duplicate modifier " + string, gNode);
                continue;
            }
            arrayList.add(attribute);
        }
        return arrayList;
    }

    public final PackageT visitPackageDeclaration(GNode gNode) {
        String string = null == gNode ? "" : (String)this.dispatch(gNode.getNode(1));
        PackageT packageT = JavaEntities.canonicalNameToPackage(this._table, string);
        this._table.enter(JavaEntities.packageNameToScopeName(packageT.getName()));
        return packageT;
    }

    public final Type visitPrimitiveType(GNode gNode) {
        Type type2 = JavaEntities.nameToBaseType(gNode.getString(0));
        this.assrt(gNode, null != type2 && (JavaEntities.isPrimitiveT(type2) || type2.isVoid()), "unknown base type %s", gNode.getString(0));
        return type2;
    }

    public final String visitQualifiedIdentifier(GNode gNode) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < gNode.size(); ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(gNode.getString(i));
        }
        return stringBuffer.toString();
    }

    public final List<Type> visitThrowsClause(GNode gNode) {
        ArrayList<Type> arrayList = new ArrayList<Type>(gNode.size());
        for (int i = 0; i < gNode.size(); ++i) {
            String string = (String)this.dispatch(gNode.getNode(i));
            arrayList.add(new AliasT(string));
        }
        return arrayList;
    }

    public final Type visitType(GNode gNode) {
        boolean bl = gNode.getGeneric(0).hasName("QualifiedIdentifier");
        Object object = this.dispatch(gNode.getNode(0));
        Type type2 = bl ? new AliasT((String)object) : (Type)object;
        int n = JavaExternalAnalyzer.countDimensions(gNode.getGeneric(1));
        Type type3 = JavaEntities.typeWithDimensions(type2, n);
        this.assrt(gNode, JavaEntities.isReturnT(type3), "unexpected type reference", new Object[0]);
        return type3;
    }

    public final Type visitVoidType(GNode gNode) {
        return JavaEntities.nameToBaseType("void");
    }

    static {
        MODIFIERS_CLASS.add(JavaEntities.nameToModifier("public"));
        MODIFIERS_CLASS.add(JavaEntities.nameToModifier("protected"));
        MODIFIERS_CLASS.add(JavaEntities.nameToModifier("private"));
        MODIFIERS_CLASS.add(JavaEntities.nameToModifier("abstract"));
        MODIFIERS_CLASS.add(JavaEntities.nameToModifier("static"));
        MODIFIERS_CLASS.add(JavaEntities.nameToModifier("final"));
        MODIFIERS_CLASS.add(JavaEntities.nameToModifier("strictfp"));
        MODIFIERS_FIELD.add(JavaEntities.nameToModifier("public"));
        MODIFIERS_FIELD.add(JavaEntities.nameToModifier("protected"));
        MODIFIERS_FIELD.add(JavaEntities.nameToModifier("private"));
        MODIFIERS_FIELD.add(JavaEntities.nameToModifier("static"));
        MODIFIERS_FIELD.add(JavaEntities.nameToModifier("final"));
        MODIFIERS_FIELD.add(JavaEntities.nameToModifier("transient"));
        MODIFIERS_FIELD.add(JavaEntities.nameToModifier("volatile"));
        MODIFIERS_CONSTRUCTOR.add(JavaEntities.nameToModifier("public"));
        MODIFIERS_CONSTRUCTOR.add(JavaEntities.nameToModifier("protected"));
        MODIFIERS_CONSTRUCTOR.add(JavaEntities.nameToModifier("private"));
        MODIFIERS_INTERFACE.add(JavaEntities.nameToModifier("public"));
        MODIFIERS_INTERFACE.add(JavaEntities.nameToModifier("protected"));
        MODIFIERS_INTERFACE.add(JavaEntities.nameToModifier("private"));
        MODIFIERS_INTERFACE.add(JavaEntities.nameToModifier("abstract"));
        MODIFIERS_INTERFACE.add(JavaEntities.nameToModifier("static"));
        MODIFIERS_INTERFACE.add(JavaEntities.nameToModifier("strictfp"));
        MODIFIERS_INTERFACE_FIELD.add(JavaEntities.nameToModifier("public"));
        MODIFIERS_INTERFACE_FIELD.add(JavaEntities.nameToModifier("static"));
        MODIFIERS_INTERFACE_FIELD.add(JavaEntities.nameToModifier("final"));
        MODIFIERS_INTERFACE_MEMBERTYPE.add(JavaEntities.nameToModifier("static"));
        MODIFIERS_INTERFACE_MEMBERTYPE.add(JavaEntities.nameToModifier("public"));
        MODIFIERS_INTERFACE_METHOD.add(JavaEntities.nameToModifier("public"));
        MODIFIERS_INTERFACE_METHOD.add(JavaEntities.nameToModifier("abstract"));
        MODIFIERS_METHOD.add(JavaEntities.nameToModifier("public"));
        MODIFIERS_METHOD.add(JavaEntities.nameToModifier("protected"));
        MODIFIERS_METHOD.add(JavaEntities.nameToModifier("private"));
        MODIFIERS_METHOD.add(JavaEntities.nameToModifier("abstract"));
        MODIFIERS_METHOD.add(JavaEntities.nameToModifier("static"));
        MODIFIERS_METHOD.add(JavaEntities.nameToModifier("final"));
        MODIFIERS_METHOD.add(JavaEntities.nameToModifier("synchronized"));
        MODIFIERS_METHOD.add(JavaEntities.nameToModifier("native"));
        MODIFIERS_METHOD.add(JavaEntities.nameToModifier("strictfp"));
    }
}

