/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import xtc.Constants;
import xtc.lang.JavaEntities;
import xtc.lang.JavaExternalAnalyzer;
import xtc.lang.JavaTypeConverter;
import xtc.tree.Attribute;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.type.AliasT;
import xtc.type.AnnotatedT;
import xtc.type.ArrayT;
import xtc.type.ClassOrInterfaceT;
import xtc.type.ClassT;
import xtc.type.ErrorT;
import xtc.type.FunctionOrMethodT;
import xtc.type.IntegerT;
import xtc.type.InterfaceT;
import xtc.type.LabelT;
import xtc.type.MethodT;
import xtc.type.NumberT;
import xtc.type.PackageT;
import xtc.type.Type;
import xtc.type.VoidT;
import xtc.type.WrappedT;
import xtc.util.Runtime;
import xtc.util.SymbolTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAnalyzer
extends Visitor {
    protected final JavaExternalAnalyzer _externalAnalyzer;
    public final JavaContext _context = new JavaContext();
    protected final Runtime _runtime;
    protected final SymbolTable _table;

    public static Type getRValueNoError(Type type2) {
        assert (null != type2);
        if (type2.isVoid()) {
            return type2;
        }
        if (JavaEntities.isExpressionT(type2)) {
            Type type3;
            boolean bl = JavaEntities.isGeneralLValueT(type2);
            Type type4 = type3 = bl ? JavaEntities.dereference(type2) : type2;
            assert (JavaEntities.isGeneralRValueT(type3));
            return type3;
        }
        return null;
    }

    protected static boolean hasModifier(Type type2, String string) {
        return JavaEntities.hasModifier(type2, string);
    }

    public static Type setType(Node node, Type type2) {
        if (type2.isMethod()) assert (node.hasName("Arguments") || node.hasName("MethodDeclaration") || node.hasName("DeconstructorDeclaration"));
        node.setProperty("xtc.Constants.Type", type2);
        return type2;
    }

    public JavaAnalyzer(Runtime runtime, SymbolTable symbolTable) {
        this._externalAnalyzer = this.newExternalAnalyzer(runtime, symbolTable);
        this._runtime = runtime;
        this._table = symbolTable;
        JavaEntities.addBaseTypes(this._table);
    }

    public JavaExternalAnalyzer newExternalAnalyzer(Runtime runtime, SymbolTable symbolTable) {
        return new JavaExternalAnalyzer(runtime, symbolTable);
    }

    protected boolean assrt(Node node, boolean bl, String string, Object ... objectArray) {
        return JavaEntities.runtimeAssrt(this._runtime, node, bl, string, objectArray);
    }

    protected void assrtLegalHandledExceptions(GNode gNode) {
        assert (null == gNode || gNode.hasName("ThrowsClause")) : gNode.getName();
        ClassT classT = JavaEntities.tThrowable(this._table);
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (int i = 0; i < this._context._handledExceptions.size(); ++i) {
            boolean bl;
            Type type2 = this.resolveIfAlias(this._context._handledExceptions.get(i), gNode.getNode(i));
            boolean bl2 = bl = type2.isError() || JavaTypeConverter.isAssignable(this._table, this.classpath(), classT, type2);
            if (!this.assrt(gNode.getNode(i), bl, "throwable expected", new Object[0])) continue;
            arrayList.add(type2);
        }
        this._context._handledExceptions = arrayList;
    }

    protected void assrtLegalIdentifier(GNode gNode, String string) {
        this.assrt(gNode, !"true".equals(string), "illegal identifier", new Object[0]);
        this.assrt(gNode, !"false".equals(string), "illegal identifier", new Object[0]);
        this.assrt(gNode, !"null".equals(string), "illegal identifier", new Object[0]);
    }

    protected void assrtLegalMethod(GNode gNode, MethodT methodT) {
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.declaringType(this._table, methodT);
        for (MethodT object : JavaEntities.methodsOwn(classOrInterfaceT)) {
            this.assrt(gNode, object == methodT || !JavaEntities.sameMethodSignature(methodT, object), "duplicate method", new Object[0]);
        }
        if (!JavaEntities.isConstructor(JavaEntities.resolveToRawClassOrInterfaceT(classOrInterfaceT), methodT)) {
            List<MethodT> list = JavaEntities.methodsInherited(this._table, this.classpath(), classOrInterfaceT, true);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MethodT methodT2 = (MethodT)iterator.next();
                if (!JavaEntities.isSuperMethod(this._table, this.classpath(), methodT2, methodT)) continue;
                this.assrtLegalOverride(gNode, methodT2, methodT);
            }
        }
    }

    protected void assrtLegalMethodBody(GNode gNode, Type type2) {
        if (null == gNode.get(7)) {
            this.assrt(gNode, JavaAnalyzer.hasModifier(type2, "abstract") || JavaAnalyzer.hasModifier(type2, "native"), "missing method body", new Object[0]);
        } else {
            this.assrt(gNode, !JavaAnalyzer.hasModifier(type2, "abstract") && !JavaAnalyzer.hasModifier(type2, "native"), "unexpected method body", new Object[0]);
        }
    }

    private void assrtLegalOverride(GNode gNode, MethodT methodT, MethodT methodT2) {
        this.assrt(gNode, !JavaAnalyzer.hasModifier(methodT, "final"), "cannot override final method", new Object[0]);
        if (JavaAnalyzer.hasModifier(methodT, "static")) {
            this.assrt(gNode, JavaAnalyzer.hasModifier(methodT2, "static"), "instance method cannot override static method", new Object[0]);
        } else if (JavaEntities.sameMethodSignature(methodT, methodT2)) {
            this.assrt(gNode, !JavaAnalyzer.hasModifier(methodT2, "static"), "static method cannot hide instance method", new Object[0]);
        }
        if (JavaAnalyzer.hasModifier(methodT, "public")) {
            this.assrt(gNode, JavaAnalyzer.hasModifier(methodT2, "public"), "cannot reduce visibility", new Object[0]);
        } else if (JavaAnalyzer.hasModifier(methodT, "protected")) {
            this.assrt(gNode, JavaAnalyzer.hasModifier(methodT2, "public") || JavaAnalyzer.hasModifier(methodT2, "protected"), "cannot reduce visibility", new Object[0]);
        } else {
            this.assrt(gNode, !JavaAnalyzer.hasModifier(methodT2, "private"), "cannot reduce visibility", new Object[0]);
        }
        this.resolveIfAlias(methodT.getResult());
        this.assrt(gNode, JavaEntities.sameMethodReturnType(methodT, methodT2), "incompatible return type", new Object[0]);
        for (Type type2 : methodT2.getExceptions()) {
            boolean bl = false;
            for (Type type3 : methodT.getExceptions()) {
                if (!JavaEntities.isSuperClass(this._table, this.classpath(), type3, type2)) continue;
                bl = true;
                break;
            }
            this.assrt(gNode, bl, "incompatible throws clause in overriding method", new Object[0]);
        }
    }

    public final List<File> classpath() {
        return JavaEntities.classpath(this._runtime);
    }

    public Type dispatchRValue(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode);
        if (null == type2 || type2.isPackage()) {
            this._runtime.error("unknown or ambiguous name", gNode);
            return JavaEntities.nameToBaseType("int");
        }
        return this.getRValue(type2, gNode);
    }

    private static char escapeSequenceChar(String string, int n) {
        int n2;
        int n3 = string.length();
        assert (n + 1 <= n3 && '\\' == string.charAt(n));
        switch (string.charAt(n + 1)) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '\\': {
                return '\\';
            }
        }
        int n4 = 0;
        for (n2 = n + 1; n2 < n3 && '0' <= string.charAt(n2) && string.charAt(n2) < '8'; ++n2) {
            n4 = 8 * n4 + string.charAt(n2) - 48;
        }
        assert (n2 != n + 1);
        return (char)n4;
    }

    private final int escapeSequenceEnd(String string, int n) {
        int n2;
        int n3 = string.length();
        assert (n + 1 <= n3 && '\\' == string.charAt(n));
        switch (string.charAt(n + 1)) {
            case '\"': 
            case '\'': 
            case '\\': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': {
                return n + 2;
            }
        }
        int n4 = 0;
        for (n2 = n + 1; n2 < n3 && '0' <= string.charAt(n2) && string.charAt(n2) < '8'; ++n2) {
            n4 = 8 * n4 + string.charAt(n2) - 48;
        }
        return n2;
    }

    private Type getRValue(Type type2, GNode gNode) {
        Type type3 = JavaAnalyzer.getRValueNoError(type2);
        if (null == type3) {
            this._runtime.error("unknown or ambiguous name", gNode);
            return ErrorT.TYPE;
        }
        return type3;
    }

    private final boolean isAssignable(int n, Type type2) {
        if (JavaEntities.nameToBaseType("byte") == type2) {
            return (byte)n == n;
        }
        if (JavaEntities.nameToBaseType("char") == type2) {
            return (char)n == n;
        }
        if (JavaEntities.nameToBaseType("short") == type2) {
            return (short)n == n;
        }
        return true;
    }

    public boolean isHandled(Type type2) {
        List<File> list = this.classpath();
        for (Type type3 : this._context._handledExceptions) {
            if (!JavaTypeConverter.isAssignable(this._table, list, type3, type2)) continue;
            return true;
        }
        return false;
    }

    private boolean isStringConstant(Type type2) {
        return type2.hasConstant() && JavaEntities.isReferenceT(type2) && JavaTypeConverter.isIdentical(type2, JavaEntities.tString(this._table));
    }

    private Type processBitwiseBinaryExpression(GNode gNode, String string) {
        Type type2;
        Type type3 = (Type)this.dispatch(gNode.getGeneric(0));
        Type type4 = this.getRValue(type3, gNode.getGeneric(0));
        Type type5 = this.dispatchRValue(gNode.getGeneric(1));
        if (type4.isError() || type5.isError()) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        Type type6 = JavaEntities.nameToBaseType("boolean");
        boolean bl = JavaTypeConverter.isIdentical(type4, type6);
        boolean bl2 = JavaTypeConverter.isIdentical(type5, type6);
        assert ("&".equals(string) || "|".equals(string) || "^".equals(string));
        if (bl || bl2) {
            if (!this.assrt(gNode, bl && bl2, "operator type mismatch", new Object[0])) {
                return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
            }
            if (type4.hasConstant() && type5.hasConstant()) {
                boolean bl3 = type4.getConstant().isTrue();
                boolean bl4 = type5.getConstant().isTrue();
                type2 = "&".equals(string) ? type6.annotate().constant(bl3 & bl4) : ("|".equals(string) ? type6.annotate().constant(bl3 | bl4) : type6.annotate().constant(bl3 ^ bl4));
            } else {
                type2 = type6;
            }
        } else {
            Type type7 = JavaTypeConverter.promoteBinaryNumeric(type5, type4);
            Type type8 = JavaTypeConverter.promoteBinaryNumeric(type4, type5);
            if (null == type7 || !JavaEntities.resolveToRawRValue(type7).isInteger()) {
                this._runtime.error("integral operator expected", gNode.getNode(0));
                type2 = type4;
            } else if (null == type8 || !JavaEntities.resolveToRawRValue(type8).isInteger()) {
                this._runtime.error("integral operator expected", gNode.getNode(2));
                type2 = type4;
            } else if (!type4.hasConstant() || !type5.hasConstant()) {
                type2 = type7;
            } else {
                NumberT numberT = (NumberT)JavaEntities.resolveToRawRValue(type7);
                Number number = (Number)type7.getConstant().getValue();
                Number number2 = (Number)type8.getConstant().getValue();
                switch (numberT.getKind()) {
                    case INT: {
                        int n = number.intValue();
                        int n2 = number2.intValue();
                        if ("&".equals(string)) {
                            type2 = numberT.annotate().constant(new Integer(n & n2));
                            break;
                        }
                        if ("|".equals(string)) {
                            type2 = numberT.annotate().constant(new Integer(n | n2));
                            break;
                        }
                        type2 = numberT.annotate().constant(new Integer(n ^ n2));
                        break;
                    }
                    case LONG: {
                        long l = number.longValue();
                        long l2 = number2.longValue();
                        if ("&".equals(string)) {
                            type2 = numberT.annotate().constant(new Long(l & l2));
                            break;
                        }
                        if ("|".equals(string)) {
                            type2 = numberT.annotate().constant(new Long(l | l2));
                            break;
                        }
                        type2 = numberT.annotate().constant(new Long(l ^ l2));
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
        }
        return JavaAnalyzer.setType(gNode, type2);
    }

    private Type processTypeName(GNode gNode) {
        if (gNode.hasName("PrimitiveType")) {
            return (Type)this.dispatch(gNode);
        }
        assert (gNode.hasName("QualifiedIdentifier"));
        String string = (String)this.dispatch(gNode);
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.qualifiedNameToType(this._table, this.classpath(), this._table.current().getQualifiedName(), string);
        return classOrInterfaceT;
    }

    protected final Type resolveIfAlias(Type type2) {
        return this.resolveIfAlias(type2, null);
    }

    protected final Type resolveIfAlias(Type type2, Node node) {
        Type type3 = JavaEntities.resolveIfAlias(this._table, this.classpath(), this._table.current().getQualifiedName(), type2);
        if (null == type3 || type3.isAlias() && null == type3.toAlias().getType()) {
            if (null != node) {
                this._runtime.error("unknown class or interface " + type2.toAlias().getName(), node);
            }
            return ErrorT.TYPE;
        }
        return type3;
    }

    public final Type visitAdditiveExpression(GNode gNode) {
        Type type2;
        Type type3 = (Type)this.dispatch(gNode.getGeneric(0));
        Type type4 = this.getRValue(type3, gNode.getGeneric(0));
        Type type5 = this.dispatchRValue(gNode.getGeneric(2));
        if (type4.isError() || type5.isError()) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        if ("+".equals(gNode.getString(1))) {
            ClassT classT = JavaEntities.tString(this._table);
            if (JavaTypeConverter.isIdentical(classT, type4) || JavaTypeConverter.isIdentical(classT, type5)) {
                if (type4.hasConstant() && type5.hasConstant()) {
                    Type type6 = JavaTypeConverter.convertString(this._table, type4);
                    Type type7 = JavaTypeConverter.convertString(this._table, type5);
                    String string = (String)type6.getConstant().getValue();
                    String string2 = (String)type7.getConstant().getValue();
                    type2 = classT.annotate().constant(string + string2);
                } else {
                    type2 = classT;
                }
            } else {
                Type type8 = JavaTypeConverter.promoteBinaryNumeric(type5, type4);
                Type type9 = JavaTypeConverter.promoteBinaryNumeric(type4, type5);
                if (null == type8 || null == type9) {
                    this._runtime.error("String or numeric operands expected", gNode);
                    type2 = JavaEntities.nameToBaseType("double");
                } else if (!type8.hasConstant() || !type9.hasConstant()) {
                    type2 = JavaEntities.resolveToRawRValue(type8);
                } else {
                    NumberT numberT = (NumberT)JavaEntities.resolveToRawRValue(type8);
                    Number number = (Number)type8.getConstant().getValue();
                    Number number2 = (Number)type9.getConstant().getValue();
                    switch (numberT.getKind()) {
                        case INT: {
                            int n = number.intValue();
                            int n2 = number2.intValue();
                            type2 = numberT.annotate().constant(new Integer(n + n2));
                            break;
                        }
                        case LONG: {
                            long l = number.longValue();
                            long l2 = number2.longValue();
                            type2 = numberT.annotate().constant(new Long(l + l2));
                            break;
                        }
                        case FLOAT: {
                            float f = number.floatValue();
                            float f2 = number2.floatValue();
                            type2 = numberT.annotate().constant(new Float(f + f2));
                            break;
                        }
                        case DOUBLE: {
                            double d = number.doubleValue();
                            double d2 = number2.doubleValue();
                            type2 = numberT.annotate().constant(new Double(d + d2));
                            break;
                        }
                        default: {
                            throw new Error();
                        }
                    }
                }
            }
        } else {
            assert ("-".equals(gNode.getString(1)));
            Type type10 = JavaTypeConverter.promoteBinaryNumeric(type5, type4);
            Type type11 = JavaTypeConverter.promoteBinaryNumeric(type4, type5);
            if (null == type10 || null == type11) {
                this._runtime.error("numeric operands expected", gNode);
                type2 = JavaEntities.nameToBaseType("double");
            } else if (!type10.hasConstant() || !type11.hasConstant()) {
                type2 = JavaEntities.resolveToRawRValue(type10);
            } else {
                NumberT numberT = (NumberT)JavaEntities.resolveToRawRValue(type10);
                Number number = (Number)type10.getConstant().getValue();
                Number number3 = (Number)type11.getConstant().getValue();
                switch (numberT.getKind()) {
                    case INT: {
                        int n = number.intValue();
                        int n3 = number3.intValue();
                        type2 = numberT.annotate().constant(new Integer(n - n3));
                        break;
                    }
                    case LONG: {
                        long l = number.longValue();
                        long l3 = number3.longValue();
                        type2 = numberT.annotate().constant(new Long(l - l3));
                        break;
                    }
                    case FLOAT: {
                        float f = number.floatValue();
                        float f3 = number3.floatValue();
                        type2 = numberT.annotate().constant(new Float(f - f3));
                        break;
                    }
                    case DOUBLE: {
                        double d = number.doubleValue();
                        double d3 = number3.doubleValue();
                        type2 = numberT.annotate().constant(new Double(d - d3));
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
        }
        return JavaAnalyzer.setType(gNode, type2);
    }

    public final List<Type> visitArguments(GNode gNode) {
        ArrayList<Type> arrayList = new ArrayList<Type>(gNode.size());
        for (int i = 0; i < gNode.size(); ++i) {
            arrayList.add(this.dispatchRValue(gNode.getGeneric(i)));
        }
        return arrayList;
    }

    public final Type visitArrayInitializer(GNode gNode) {
        if (this.assrt(gNode, this._context._initializing.isArray(), "array initializer type mismatch", new Object[0])) {
            JavaContext javaContext = this._context.save();
            this._context._initializing = JavaEntities.arrayElementType(this._context._initializing.toArray());
            for (int i = 0; i < gNode.size(); ++i) {
                Type type2 = this.dispatchRValue(gNode.getGeneric(i));
                this.assrt(gNode.getGeneric(i), JavaTypeConverter.isAssignable(this._table, this.classpath(), this._context._initializing, type2), "array initializer type mismatch", new Object[0]);
            }
            this._context.restore(javaContext);
        }
        return JavaAnalyzer.setType(gNode, this._context._initializing);
    }

    public final void visitBasicCastExpression(GNode gNode) {
        assert (false) : "must run JavaAstSimplifier first";
    }

    public final void visitBasicForControl(GNode gNode) {
        Iterable iterable;
        if (null == gNode.get(1)) {
            assert (null == gNode.get(0));
        } else {
            iterable = (List)this.dispatch(gNode.getNode(0));
            Type type2 = (Type)this.dispatch(gNode.getGeneric(1));
            this._externalAnalyzer.processDeclarators((List<Attribute>)iterable, type2, gNode.getGeneric(2));
        }
        this.dispatch(gNode.getGeneric(2));
        if (null != gNode.get(3)) {
            iterable = (Type)this.dispatch(gNode.getGeneric(3));
            this.assrt(gNode.getGeneric(3), JavaEntities.resolveToRawRValue((Type)iterable).isBoolean(), "condition must be boolean", new Object[0]);
        }
        this.dispatch(gNode.getGeneric(4));
    }

    public final Type visitBitwiseAndExpression(GNode gNode) {
        return this.processBitwiseBinaryExpression(gNode, "&");
    }

    public final Type visitBitwiseNegationExpression(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getGeneric(0));
        if (type2.isError()) {
            return JavaAnalyzer.setType(gNode, type2);
        }
        Type type3 = JavaTypeConverter.promoteUnaryNumeric(this.getRValue(type2, gNode.getGeneric(0)));
        if (!this.assrt(gNode, null != type3, "operand must be numeric", new Object[0])) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        if (type3.hasConstant()) {
            NumberT numberT = (NumberT)JavaEntities.resolveToRawRValue(type3);
            Number number = (Number)type3.getConstant().getValue();
            switch (numberT.getKind()) {
                case INT: {
                    int n = number.intValue();
                    return numberT.annotate().constant(new Integer(~n));
                }
                case LONG: {
                    long l = number.longValue();
                    return numberT.annotate().constant(new Long(l ^ 0xFFFFFFFFFFFFFFFFL));
                }
            }
            this.assrt(gNode, false, "operand must be an integral type", new Object[0]);
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        return JavaAnalyzer.setType(gNode, type3);
    }

    public final Type visitBitwiseOrExpression(GNode gNode) {
        return this.processBitwiseBinaryExpression(gNode, "|");
    }

    public final Type visitBitwiseXorExpression(GNode gNode) {
        return this.processBitwiseBinaryExpression(gNode, "^");
    }

    public final Type visitBlock(GNode gNode) {
        JavaContext javaContext = this._context.save();
        this._context._hasScope = true;
        if (javaContext._hasScope) {
            this._table.enter(this._table.freshName("block"));
            this._table.mark(gNode);
        }
        for (int i = 0; i < gNode.size(); ++i) {
            this.dispatch(gNode.getNode(i));
        }
        if (javaContext._hasScope) {
            this._table.exit();
        }
        this._context.restore(javaContext);
        return JavaEntities.nameToBaseType("void");
    }

    public final void visitBlockDeclaration(GNode gNode) {
        JavaContext javaContext = this._context.save();
        assert (JavaEntities.isScopeForMember(this._table.current().getQualifiedName()));
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.currentType(this._table);
        assert (JavaEntities.isWrappedClassT(classOrInterfaceT));
        boolean bl = this._context._static = null != gNode.get(0);
        if (JavaEntities.isTypeInner(classOrInterfaceT)) {
            this.assrt(gNode, !this._context._static, "inner classes may not declare static initializers", new Object[0]);
        }
        this._context._handledExceptions = new ArrayList<Type>();
        ClassT classT = (ClassT)JavaEntities.resolveToRawRValue(classOrInterfaceT);
        boolean bl2 = JavaEntities.isTypeAnonymous(classT);
        if (bl2) {
            this._context._handledExceptions.add(JavaEntities.tThrowable(this._table));
        } else if (!this._context._static) {
            boolean bl3 = true;
            for (Type type2 : classT.getMethods()) {
                MethodT methodT = type2.toMethod();
                if (!JavaEntities.isConstructor(classT, methodT)) continue;
                List<Type> list = methodT.getExceptions();
                if (bl3) {
                    this._context._handledExceptions.addAll(list);
                    bl3 = false;
                    continue;
                }
                HashSet<String> hashSet = new HashSet<String>();
                for (Type type3 : this._context._handledExceptions) {
                    hashSet.add(((ClassT)JavaEntities.resolveToRawRValue(type3)).getQName());
                }
                this._context._handledExceptions.clear();
                for (Type type3 : list) {
                    String string = ((ClassT)JavaEntities.resolveToRawRValue(type3)).getQName();
                    if (!hashSet.contains(string)) continue;
                    this._context._handledExceptions.add(type3);
                }
            }
        }
        this.dispatch(gNode.getGeneric(1));
        this._context.restore(javaContext);
    }

    public final Type visitBooleanLiteral(GNode gNode) {
        Type type2 = JavaEntities.nameToBaseType("boolean");
        boolean bl = "true".equals(gNode.getString(0));
        return JavaAnalyzer.setType(gNode, type2.annotate().constant(bl));
    }

    public final void visitBreakStatement(GNode gNode) {
        if (null == gNode.get(0)) {
            this.assrt(gNode, this._context._loop || this._context._switch, "break without label can only be used in loop or switch", new Object[0]);
        } else {
            String string = gNode.getString(0);
            String string2 = SymbolTable.toLabelName(string);
            LabelT labelT = (LabelT)this._table.current().lookup(string2);
            this.assrt(gNode, null != labelT, "the label " + string + " is missing", new Object[0]);
        }
    }

    public final Type visitCallExpression(GNode gNode) {
        Iterable<Type> iterable;
        List<Type> list;
        boolean bl;
        Iterable<Object> iterable2;
        String string = gNode.getString(2);
        if ("super".equals(string) && gNode.get(0) == null) {
            iterable2 = JavaEntities.currentType(this._table).toClass().getParent();
            string = this.resolveIfAlias((Type)iterable2).toClass().getName();
            bl = false;
        } else if (gNode.get(0) == null) {
            list = this._table.current();
            block0: while (true) {
                iterable = JavaEntities.currentType(this._table);
                JavaEntities.enterScopeByQualifiedName(this._table, JavaEntities.typeToScopeName((Type)iterable));
                for (MethodT methodT : JavaEntities.methodsOwnAndInherited(this._table, this.classpath(), (Type)iterable)) {
                    if (!methodT.getName().equals(string)) continue;
                    iterable2 = iterable;
                    break block0;
                }
                if (JavaEntities.isTypeTopLevel((ClassOrInterfaceT)iterable)) {
                    iterable2 = iterable;
                    break;
                }
                this._table.exit();
            }
            this._table.setScope((SymbolTable.Scope)((Object)list));
            bl = this._context._static;
        } else {
            list = (Type)this.dispatch(gNode.getGeneric(0));
            if (!this.assrt(gNode.getGeneric(0), !((Type)((Object)list)).isPackage(), "unknown idenfifier", new Object[0])) {
                return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
            }
            bl = JavaEntities.isNotAValueT((Type)((Object)list));
            iterable = bl ? JavaEntities.resolveToValue(((Type)((Object)list)).toAnnotated()) : list;
            Type type2 = this.getRValue((Type)iterable, gNode.getGeneric(0));
            Type type3 = JavaEntities.isConstantT(type2) ? ((AnnotatedT)type2).getType() : type2;
            iterable2 = this.resolveIfAlias(type3);
        }
        list = JavaEntities.typeList((List)this.dispatch(gNode.getNode(3)));
        for (Type type4 : list) {
            if (!type4.isError()) continue;
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        iterable = JavaEntities.typeDotMethod(this._table, this.classpath(), iterable2, true, string, list);
        if (!this.assrt(gNode, null != iterable && ((MethodT)iterable).isMethod(), "no such method", new Object[0])) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        this.assrt(gNode, JavaAnalyzer.hasModifier(iterable, "static") || !bl, "static call to non-static method", new Object[0]);
        JavaEntities.resolveIfAliasMethod(this._table, this.classpath(), iterable);
        for (Type type5 : ((FunctionOrMethodT)iterable).getExceptions()) {
            if (!JavaEntities.isCheckedException(this._table, this.classpath(), type5)) continue;
            this.assrt(gNode, this.isHandled(type5), "uncaught exception", new Object[0]);
        }
        JavaAnalyzer.setType(gNode.getGeneric(3), iterable);
        return JavaAnalyzer.setType(gNode, ((FunctionOrMethodT)iterable).getResult());
    }

    public final Type visitCaseClause(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getGeneric(0));
        for (int i = 1; i < gNode.size(); ++i) {
            this.dispatch(gNode.getGeneric(i));
        }
        return type2;
    }

    public final Type visitCastExpression(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getGeneric(0));
        if (type2.isError()) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        Type type3 = this.dispatchRValue(gNode.getGeneric(1));
        Type type4 = JavaTypeConverter.convertCasting(this._table, this.classpath(), type2, type3);
        if (!this.assrt(gNode, null != type4, "illegal cast", new Object[0])) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        return JavaAnalyzer.setType(gNode, type4);
    }

    public final Type visitCatchClause(GNode gNode) {
        JavaContext javaContext = this._context.save();
        this._context._hasScope = false;
        this._table.enter(this._table.freshName("catchClause"));
        this._table.mark(gNode);
        GNode gNode2 = gNode.getGeneric(0);
        Type type2 = this.dispatchRValue(gNode2);
        ClassT classT = JavaEntities.tThrowable(this._table);
        this.assrt(gNode2, JavaEntities.isSuperClass(this._table, this.classpath(), classT, type2), "illegal type for exception parameter", new Object[0]);
        this.dispatch(gNode.getGeneric(1));
        this._table.exit();
        this._context.restore(javaContext);
        return JavaAnalyzer.setType(gNode, type2);
    }

    public final Type visitCharacterLiteral(GNode gNode) {
        String string = gNode.getString(0);
        int n = string.length();
        assert (2 < n && '\'' == string.charAt(0) && '\'' == string.charAt(n - 1));
        Character c = null;
        if (3 == n) {
            c = new Character(string.charAt(1));
        } else {
            try {
                c = new Character(JavaAnalyzer.escapeSequenceChar(string, 1));
                if (!this.assrt(gNode, n == 1 + this.escapeSequenceEnd(string, 1), "illegal escape sequence", new Object[0])) {
                    return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._runtime.error("illegal escape sequence", gNode);
                return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
            }
        }
        if (!this.assrt(gNode, 3 < n || '\r' != c.charValue() && '\n' != c.charValue(), "single character must not be line terminator", new Object[0])) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        Type type2 = JavaEntities.nameToBaseType("char");
        return JavaAnalyzer.setType(gNode, type2.annotate().constant(c));
    }

    public final void visitClassBody(GNode gNode) {
        for (int i = 0; i < gNode.size(); ++i) {
            this.dispatch(gNode.getNode(i));
        }
    }

    public final void visitClassDeclaration(GNode gNode) {
        int n;
        JavaContext javaContext = this._context.save();
        this._context._handledExceptions = new ArrayList<Type>();
        this._context._hasScope = true;
        this._context._switch = false;
        this._context._loop = false;
        String string = gNode.getString(1);
        this.assrtLegalIdentifier(gNode, string);
        ClassT classT = (ClassT)this._table.current().lookupLocally(SymbolTable.toTagName(string));
        if (null == classT) {
            classT = this._externalAnalyzer.visitClassDeclaration(gNode);
        } else {
            this.assrt(gNode, !JavaEntities.isScopeLocal(this._table.current().getQualifiedName()), "conflicting classes", new Object[0]);
        }
        Iterable<Object> iterable = classT.getParent();
        if (((Type)iterable).isAlias()) {
            AliasT aliasT = ((Type)iterable).toAlias();
            this.resolveIfAlias(aliasT, gNode.getGeneric(3));
            if (null == aliasT.getType()) {
                aliasT.setType(JavaEntities.tObject(this._table));
            }
        }
        this.assrt(gNode.getGeneric(3), JavaEntities.isWrappedClassT((Type)iterable), "class expected", new Object[0]);
        this.assrt(gNode.getGeneric(3), !JavaAnalyzer.hasModifier((Type)iterable, "final"), "can't subclass final class", new Object[0]);
        this.assrt(gNode.getGeneric(3), JavaEntities.isAccessible(this._table, this.classpath(), (Type)iterable), "inner class not visible", new Object[0]);
        iterable = new HashSet();
        for (n = 0; n < classT.getInterfaces().size(); n += 1) {
            Type type2 = this.resolveIfAlias(classT.getInterfaces().get(n), gNode.getGeneric(4).getNode(n));
            if (type2.isError() || !this.assrt(gNode.getGeneric(4), type2.isInterface(), "interface expected", new Object[0])) continue;
            String string2 = type2.toInterface().getQName();
            this.assrt(gNode.getGeneric(4), !iterable.contains(string2), "duplicate superinterfaces", new Object[0]);
            iterable.add((String)string2);
            this.assrt(gNode.getGeneric(4), JavaEntities.isAccessible(this._table, this.classpath(), type2), "superinterface not accessible", new Object[0]);
        }
        n = JavaAnalyzer.hasModifier(classT, "abstract") ? 1 : 0;
        if (JavaEntities.hasAbstractMethods(this._table, this.classpath(), classT)) {
            this.assrt(gNode, n != 0, "must be abstract", new Object[0]);
        }
        this.assrt(gNode, !JavaEntities.hasCircularDependency(this._table, this.classpath(), classT), "circular class", new Object[0]);
        this._table.enter(string);
        this._table.mark(gNode.getNode(5));
        this.dispatch(gNode.getNode(5));
        this._table.exit();
        if (n) {
            this.assrt(gNode, JavaEntities.couldCreateConcreteSubclass(this._table, this.classpath(), classT), "conflicting abstract methods", new Object[0]);
        }
        this._context.restore(javaContext);
    }

    public final Type visitClassLiteralExpression(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getNode(0));
        assert (type2.isError() || JavaEntities.isWrappedClassT(type2) || JavaEntities.isWrappedInterfaceT(type2) || type2.isArray() || JavaEntities.isPrimitiveT(type2));
        return JavaAnalyzer.setType(gNode, JavaEntities.tClass(this._table));
    }

    public void visitCompilationUnit(GNode gNode) {
        this._externalAnalyzer.dispatch(gNode);
        if (null == gNode.get(0)) {
            this.visitPackageDeclaration(null);
        } else {
            this.dispatch(gNode.getNode(0));
        }
        this._table.enter(JavaEntities.fileNameToScopeName(gNode.getLocation().file));
        this._table.mark(gNode);
        for (int i = 1; i < gNode.size(); ++i) {
            this.dispatch(gNode.getNode(i));
        }
        this._table.setScope(this._table.root());
    }

    public final List<Type> visitConcreteDimensions(GNode gNode) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (int i = 0; i < gNode.size(); ++i) {
            Type type2 = this.dispatchRValue(gNode.getGeneric(i));
            arrayList.add(type2);
            Type type3 = null == type2 ? null : JavaTypeConverter.promoteUnaryNumeric(type2);
            Type type4 = null == type3 ? null : JavaEntities.resolveToRawRValue(type3);
            this.assrt(gNode, null != type4 && type4 instanceof IntegerT && NumberT.Kind.INT == ((IntegerT)type4).getKind(), "dimension must be integer", new Object[0]);
        }
        return arrayList;
    }

    public final Type visitConditionalExpression(GNode gNode) {
        Type type2;
        Object object;
        BigInteger bigInteger;
        Type type3 = this.dispatchRValue(gNode.getGeneric(0));
        Type type4 = JavaEntities.resolveToRawRValue(type3);
        if (type4.isBoolean()) {
            bigInteger = type3.hasConstant() ? type3.getConstant().bigIntValue() : null;
        } else {
            this.assrt(gNode, type4.isError(), "condition must be boolean", new Object[0]);
            bigInteger = null;
        }
        Type type5 = this.dispatchRValue(gNode.getGeneric(1));
        Type type6 = JavaEntities.resolveToRawRValue(type5);
        Object object2 = type5.hasConstant() ? type5.getConstant().getValue() : null;
        Type type7 = this.dispatchRValue(gNode.getGeneric(2));
        Type type8 = JavaEntities.resolveToRawRValue(type7);
        Object object3 = object = type7.hasConstant() ? type7.getConstant().getValue() : null;
        if (JavaTypeConverter.isIdentical(type5, type7)) {
            type2 = null == bigInteger ? type6 : (BigInteger.ONE == bigInteger ? type5 : type7);
        } else if (type6.isNumber() && type8.isNumber()) {
            Object object4;
            Object object5;
            Object object6;
            NumberT numberT = (NumberT)JavaEntities.nameToBaseType("byte");
            NumberT numberT2 = (NumberT)JavaEntities.nameToBaseType("short");
            NumberT numberT3 = (NumberT)JavaEntities.nameToBaseType("char");
            NumberT numberT4 = (NumberT)JavaEntities.nameToBaseType("int");
            if (numberT == type6 && numberT2 == type8 || numberT2 == type6 && numberT == type8) {
                object6 = numberT2;
            } else if (numberT == type6 && numberT4 == type8 && null != object && (byte)((Integer)object).intValue() == (Integer)object) {
                object6 = numberT;
            } else if (numberT2 == type6 && numberT4 == type8 && null != object && (short)((Integer)object).intValue() == (Integer)object) {
                object6 = numberT2;
            } else if (numberT3 == type6 && numberT4 == type8 && null != object && (char)((Integer)object).intValue() == (Integer)object) {
                object6 = numberT3;
            } else if (numberT == type8 && numberT4 == type6 && null != object2 && (byte)((Integer)object2).intValue() == (Integer)object2) {
                object6 = numberT;
            } else if (numberT2 == type8 && numberT4 == type6 && null != object2 && (short)((Integer)object2).intValue() == (Integer)object2) {
                object6 = numberT2;
            } else if (numberT3 == type8 && numberT4 == type6 && null != object2 && (char)((Integer)object2).intValue() == (Integer)object2) {
                object6 = numberT3;
            } else {
                object5 = (NumberT)JavaTypeConverter.promoteBinaryNumeric(type8, type6);
                object4 = (NumberT)JavaTypeConverter.promoteBinaryNumeric(type6, type8);
                if (!this.assrt(gNode, null != object5 && null != object4, "type mismatch", new Object[0])) {
                    return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
                }
                object6 = object5;
            }
            if (BigInteger.ONE == bigInteger && null != object2) {
                if (object2 instanceof Number) {
                    object4 = (Number)object2;
                    switch (((NumberT)object6).getKind()) {
                        case BYTE: {
                            object5 = new Byte(((Number)object4).byteValue());
                            break;
                        }
                        case SHORT: {
                            object5 = new Short(((Number)object4).shortValue());
                            break;
                        }
                        case CHAR: {
                            object5 = new Character((char)((Number)object4).intValue());
                            break;
                        }
                        case INT: {
                            object5 = new Integer(((Number)object4).intValue());
                            break;
                        }
                        case LONG: {
                            object5 = new Long(((Number)object4).longValue());
                            break;
                        }
                        case FLOAT: {
                            object5 = new Float(((Number)object4).floatValue());
                            break;
                        }
                        case DOUBLE: {
                            object5 = new Double(((Number)object4).doubleValue());
                            break;
                        }
                        default: {
                            throw new Error();
                        }
                    }
                } else {
                    char c = ((Character)object2).charValue();
                    switch (((NumberT)object6).getKind()) {
                        case BYTE: {
                            object5 = new Byte((byte)c);
                            break;
                        }
                        case SHORT: {
                            object5 = new Short((short)c);
                            break;
                        }
                        case CHAR: {
                            object5 = new Character(c);
                            break;
                        }
                        case INT: {
                            object5 = new Integer(c);
                            break;
                        }
                        case LONG: {
                            object5 = new Long(c);
                            break;
                        }
                        case FLOAT: {
                            object5 = new Float(c);
                            break;
                        }
                        case DOUBLE: {
                            object5 = new Double(c);
                            break;
                        }
                        default: {
                            throw new Error();
                        }
                    }
                }
                type2 = ((Type)object6).annotate().constant(object5);
            } else if (BigInteger.ONE == bigInteger && null != object) {
                object5 = (Number)object;
                switch (((NumberT)object6).getKind()) {
                    case BYTE: {
                        object4 = new Byte(((Number)object5).byteValue());
                        break;
                    }
                    case SHORT: {
                        object4 = new Short(((Number)object5).shortValue());
                        break;
                    }
                    case CHAR: {
                        object4 = new Character((char)((Number)object5).intValue());
                        break;
                    }
                    case INT: {
                        object4 = new Integer(((Number)object5).intValue());
                        break;
                    }
                    case LONG: {
                        object4 = new Long(((Number)object5).longValue());
                        break;
                    }
                    case FLOAT: {
                        object4 = new Float(((Number)object5).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        object4 = new Double(((Number)object5).doubleValue());
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
                type2 = ((Type)object6).annotate().constant(object4);
            } else {
                type2 = object6;
            }
        } else if (!JavaEntities.isPrimitiveT(type6) && !JavaEntities.isPrimitiveT(type8)) {
            if (JavaEntities.isNullT(type6)) {
                type2 = BigInteger.ZERO == bigInteger ? type7 : type8;
            } else if (JavaEntities.isNullT(type8)) {
                type2 = BigInteger.ONE == bigInteger ? type7 : type8;
            } else {
                Type type9 = JavaTypeConverter.convertAssigning(this._table, this.classpath(), type8, type6);
                Type type10 = JavaTypeConverter.convertAssigning(this._table, this.classpath(), type6, type8);
                if (!this.assrt(gNode, null != type9 || null != type10, "mismatched types", new Object[0])) {
                    return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
                }
                type2 = null != type9 ? type9 : type10;
            }
        } else {
            throw new Error();
        }
        return JavaAnalyzer.setType(gNode, type2);
    }

    public final void visitConditionalStatement(GNode gNode) {
        Type type2 = this.dispatchRValue(gNode.getGeneric(0));
        if (!JavaEntities.resolveToRawRValue(type2).isBoolean()) {
            this._runtime.error("condition must be boolean", gNode.getGeneric(0));
        }
        this.dispatch(gNode.getNode(1));
        this.dispatch(gNode.getNode(2));
    }

    public final void visitConstructorDeclaration(GNode gNode) {
        assert (false) : "must run JavaAstSimplifier first";
    }

    public final void visitContinueStatement(GNode gNode) {
        if (null == gNode.get(0)) {
            this.assrt(gNode, this._context._loop, "continue cannot be used outside of a loop", new Object[0]);
        } else {
            String string = gNode.getString(0);
            String string2 = SymbolTable.toLabelName(string);
            LabelT labelT = (LabelT)this._table.current().lookup(string2);
            if (null == labelT) {
                this._runtime.error("the label " + string + " is missing", gNode);
            } else {
                this.assrt(gNode, labelT.hasAttribute(Constants.ATT_LOOP), "%s is not a loop label", labelT.getName());
            }
        }
    }

    public final Type visitDeclarator(GNode gNode) {
        WrappedT wrappedT;
        Type type2;
        JavaContext javaContext = this._context.save();
        Type type3 = this.resolveIfAlias((Type)gNode.getProperty("xtc.Constants.Type"), gNode);
        this._context._static = JavaAnalyzer.hasModifier(type3, "static");
        Object object = JavaEntities.dereference(type3);
        Type type4 = type2 = JavaEntities.isConstantT((Type)object) ? ((AnnotatedT)object).getType() : object;
        if (type2.isAlias() && null == (wrappedT = (AliasT)type2).getType()) {
            this._runtime.error("unknown type " + ((AliasT)wrappedT).getName(), gNode);
            wrappedT.setType(JavaEntities.tObject(this._table));
            return type3;
        }
        object = gNode.getString(0);
        this.assrtLegalIdentifier(gNode, (String)object);
        if (JavaEntities.isParameterT(type3)) {
            this._runtime.error("duplicate parameter declaration " + (String)object, gNode);
        } else {
            assert (JavaEntities.isFieldT(type3) || JavaEntities.isLocalT(type3));
            if (JavaEntities.isScopeLocal(this._table.current().getQualifiedName()) && !SymbolTable.isInNameSpace(this._table.current().getName(), "method")) {
                type2 = (Type)this._table.current().getParent().lookup((String)object);
                this.assrt(gNode, null == type2 || !JavaEntities.isParameterT(type2), "duplicate variable declaration " + (String)object, new Object[0]);
            }
        }
        if (null != gNode.get(2)) {
            this._context._initializing = this.getRValue(type3, gNode);
            type2 = this.dispatchRValue((GNode)gNode.getNode(2));
            if (!type2.isError()) {
                assert (JavaEntities.isGeneralRValueT(type2));
                this.assrt(gNode, JavaTypeConverter.isAssignable(this._table, this.classpath(), this._context._initializing, type2), "initializer type mismatch", new Object[0]);
                if (type2.hasConstant() && !JavaEntities.isNullT(type2) && JavaAnalyzer.hasModifier(type3, "final")) {
                    wrappedT = JavaEntities.resolveToRawLValue(type3);
                    wrappedT.setType(type2);
                }
            }
        }
        if (this._context._static && JavaEntities.isFieldT(type3) && JavaEntities.isTypeInner(JavaEntities.currentType(this._table))) {
            this.assrt(gNode, JavaAnalyzer.hasModifier(type3, "final"), "static variables of inner classes must be compile-time constants", new Object[0]);
        }
        this._context.restore(javaContext);
        return type3;
    }

    public final List<Type> visitDeclarators(GNode gNode) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (Object object : gNode) {
            arrayList.add((Type)this.dispatch((GNode)object));
        }
        return arrayList;
    }

    public final void visitDefaultClause(GNode gNode) {
        for (int i = 0; i < gNode.size(); ++i) {
            this.dispatch(gNode.getGeneric(i));
        }
    }

    public final void visitDoWhileStatement(GNode gNode) {
        JavaContext javaContext = this._context.save();
        this._context._loop = true;
        this.dispatch(gNode.getNode(0));
        Type type2 = this.dispatchRValue(gNode.getGeneric(1));
        if (!JavaEntities.resolveToRawRValue(type2).isBoolean()) {
            this._runtime.error("condition must be boolean", gNode.getGeneric(0));
        }
        this._context.restore(javaContext);
    }

    public final void visitEmptyDeclaration(GNode gNode) {
        assert (0 == gNode.size());
    }

    public final void visitEmptyStatement(GNode gNode) {
        assert (0 == gNode.size());
    }

    public final Type visitEqualityExpression(GNode gNode) {
        Type type2;
        Type type3 = (Type)this.dispatch(gNode.getGeneric(0));
        Type type4 = this.getRValue(type3, gNode.getGeneric(0));
        Type type5 = this.dispatchRValue(gNode.getGeneric(2));
        if (type4.isError() || type5.isError()) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        String string = gNode.getString(1);
        Type type6 = JavaEntities.nameToBaseType("boolean");
        boolean bl = JavaTypeConverter.isIdentical(type4, type6);
        boolean bl2 = JavaTypeConverter.isIdentical(type5, type6);
        assert ("==".equals(string) || "!=".equals(string));
        Type type7 = JavaTypeConverter.promoteBinaryNumeric(type5, type4);
        Type type8 = JavaTypeConverter.promoteBinaryNumeric(type4, type5);
        if (null == type7 || null == type8) {
            if (bl) {
                if (bl2) {
                    if (type4.hasConstant() && type5.hasConstant()) {
                        boolean bl3 = type4.getConstant().isTrue();
                        boolean bl4 = type5.getConstant().isTrue();
                        type2 = "==".equals(string) ? type6.annotate().constant(bl3 == bl4) : type6.annotate().constant(bl3 != bl4);
                    } else {
                        type2 = type6;
                    }
                } else {
                    this._runtime.error("boolean expected", gNode.getNode(gNode.size() - 1));
                    type2 = type6;
                }
            } else if (JavaEntities.isNullT(type4) || JavaEntities.isNullT(type5)) {
                this.assrt(gNode, !(!JavaEntities.isReferenceT(type4) && !JavaEntities.isNullT(type4) || !JavaEntities.isReferenceT(type5) && !JavaEntities.isNullT(type5)), "incompatible types", new Object[0]);
                type2 = type6;
            } else if (this.isStringConstant(type4) && this.isStringConstant(type5)) {
                String string2 = (String)type4.getConstant().getValue();
                String string3 = (String)type5.getConstant().getValue();
                type2 = type6.annotate().constant("==".equals(string) ? string2.equals(string3) : !string2.equals(string3));
            } else {
                boolean bl5 = JavaTypeConverter.isCastable(this._table, this.classpath(), type5, type4);
                boolean bl6 = JavaTypeConverter.isCastable(this._table, this.classpath(), type4, type5);
                this.assrt(gNode, bl5 || bl6, "incompatible types", new Object[0]);
                type2 = type6;
            }
        } else if (!type7.hasConstant() || !type8.hasConstant()) {
            type2 = type6;
        } else {
            NumberT numberT = (NumberT)JavaEntities.resolveToRawRValue(type7);
            Number number = (Number)type7.getConstant().getValue();
            Number number2 = (Number)type8.getConstant().getValue();
            switch (numberT.getKind()) {
                case INT: {
                    int n = number.intValue();
                    int n2 = number2.intValue();
                    if ("==".equals(string)) {
                        type2 = type6.annotate().constant(n == n2);
                        break;
                    }
                    type2 = type6.annotate().constant(n != n2);
                    break;
                }
                case LONG: {
                    long l = number.longValue();
                    long l2 = number2.longValue();
                    if ("==".equals(string)) {
                        type2 = type6.annotate().constant(l == l2);
                        break;
                    }
                    type2 = type6.annotate().constant(l != l2);
                    break;
                }
                case FLOAT: {
                    float f = number.floatValue();
                    float f2 = number2.floatValue();
                    if ("==".equals(string)) {
                        type2 = type6.annotate().constant(f == f2);
                        break;
                    }
                    type2 = type6.annotate().constant(f != f2);
                    break;
                }
                case DOUBLE: {
                    double d = number.doubleValue();
                    double d2 = number2.doubleValue();
                    if ("==".equals(string)) {
                        type2 = type6.annotate().constant(d == d2);
                        break;
                    }
                    type2 = type6.annotate().constant(d != d2);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        return JavaAnalyzer.setType(gNode, type2);
    }

    public final Type visitExpression(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getGeneric(0));
        Type type3 = this.getRValue(type2, gNode.getGeneric(0));
        Type type4 = this.dispatchRValue(gNode.getGeneric(2));
        if (type3.isError() || type4.isError()) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        String string = gNode.getString(1);
        assert ("=".equals(string) || "+=".equals(string) || "-=".equals(string) || "*=".equals(string) || "/=".equals(string) || "%=".equals(string) || "&=".equals(string) || "|=".equals(string) || "^=".equals(string) || "<<=".equals(string) || ">>=".equals(string) || ">>>=".equals(string));
        if (!JavaEntities.isGeneralLValueT(type2)) {
            this._runtime.error("left operand of assignment not l-value", gNode);
        } else if (JavaAnalyzer.hasModifier(type2, "final")) {
            this._runtime.error("left operand of assignment is final", gNode);
        } else if ("=".equals(string)) {
            this.assrt(gNode.getGeneric(2), JavaTypeConverter.isAssignable(this._table, this.classpath(), type3, type4), "illegal assignment", new Object[0]);
        } else {
            boolean bl;
            Type type5;
            char c = string.charAt(0);
            if ('+' == c) {
                type5 = JavaEntities.tString(this._table);
                bl = JavaTypeConverter.isIdentical(type3, type5);
            } else {
                bl = false;
            }
            if (!bl) {
                type5 = JavaEntities.resolveToRawRValue(type3);
                Type type6 = JavaEntities.resolveToRawRValue(type4);
                switch (c) {
                    case '%': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': {
                        this.assrt(gNode, type5.isNumber() && type6.isNumber(), "illegal assignment", new Object[0]);
                        break;
                    }
                    case '&': 
                    case '^': 
                    case '|': {
                        this.assrt(gNode, type5.isBoolean() && type6.isBoolean() || type5.isInteger() && type6.isInteger(), "illegal assignment", new Object[0]);
                        break;
                    }
                    case '<': 
                    case '>': {
                        this.assrt(gNode, type5.isInteger() && type6.isInteger(), "illegal assignment", new Object[0]);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
        }
        return JavaAnalyzer.setType(gNode, type3);
    }

    public final List<Type> visitExpressionList(GNode gNode) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (int i = 0; i < gNode.size(); ++i) {
            arrayList.add(this.dispatchRValue(gNode.getGeneric(i)));
        }
        return arrayList;
    }

    public final void visitExpressionStatement(GNode gNode) {
        this.dispatch(gNode.getNode(0));
    }

    public final List<Type> visitFieldDeclaration(GNode gNode) {
        if (null == gNode.getGeneric(2).getGeneric(0).getProperty("xtc.Constants.Type")) {
            this._externalAnalyzer.dispatch(gNode);
        }
        return JavaEntities.typeList((List)this.dispatch(gNode.getNode(2)));
    }

    public final Type visitFloatingPointLiteral(GNode gNode) {
        Number number;
        String string = gNode.getString(0);
        boolean bl = 'f' == Character.toLowerCase(string.charAt(string.length() - 1));
        Number number2 = number = bl ? (Number)new Float(string) : (Number)new Double(string);
        if (!this.assrt(gNode, bl ? !((Float)number).isInfinite() : !((Double)number).isInfinite(), "literal out of range", new Object[0]) || !this.assrt(gNode, 0.0 == number.doubleValue() == JavaEntities.zeroLiteral(string), "literal out of range", new Object[0])) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        Type type2 = JavaEntities.nameToBaseType(bl ? "float" : "double");
        return JavaAnalyzer.setType(gNode, type2.annotate().constant(number));
    }

    public final Type visitFormalParameter(GNode gNode) {
        Type type2;
        boolean bl = SymbolTable.isInNameSpace(this._table.current().getName(), "catchClause");
        String string = gNode.getString(3);
        Type type3 = (Type)this._table.lookup(string);
        if (bl) {
            this.assrt(gNode, null == type3, "duplicate parameter " + string, new Object[0]);
            type2 = null == type3 ? this._externalAnalyzer.visitFormalParameter(gNode) : type3;
        } else {
            type2 = type3;
        }
        this.resolveIfAlias(JavaEntities.dereference(type2), gNode.getNode(1));
        return JavaAnalyzer.setType(gNode, type2);
    }

    public final List<Type> visitFormalParameters(GNode gNode) {
        ArrayList<Type> arrayList = new ArrayList<Type>(gNode.size());
        for (int i = 0; i < gNode.size(); ++i) {
            arrayList.add((Type)this.dispatch(gNode.getNode(i)));
        }
        return arrayList;
    }

    public final void visitForStatement(GNode gNode) {
        JavaContext javaContext = this._context.save();
        this._context._loop = true;
        this._context._hasScope = false;
        this._table.enter(this._table.freshName("forStatement"));
        this._table.mark(gNode);
        this.dispatch(gNode.getGeneric(0));
        this.dispatch(gNode.getGeneric(1));
        this._table.exit();
        this._context.restore(javaContext);
    }

    public final void visitImportDeclaration(GNode gNode) {
        this._externalAnalyzer.visitImportDeclaration(gNode);
    }

    public final Type visitInstanceOfExpression(GNode gNode) {
        GNode gNode2 = gNode.getGeneric(0);
        Type type2 = this.dispatchRValue(gNode2);
        if (!type2.isError()) {
            if (JavaEntities.isReferenceT(type2) || JavaEntities.isNullT(type2)) {
                GNode gNode3 = gNode.getGeneric(1);
                Type type3 = (Type)this.dispatch(gNode3);
                if (!type3.isError()) {
                    if (JavaEntities.isReferenceT(type3)) {
                        this.assrt(gNode, JavaTypeConverter.isCastable(this._table, this.classpath(), type3, type2), "not castable", new Object[0]);
                    } else {
                        this._runtime.error("reference type expected", gNode3);
                    }
                }
            } else {
                this._runtime.error("reference type expected", gNode2);
            }
        }
        return JavaAnalyzer.setType(gNode, JavaEntities.nameToBaseType("boolean"));
    }

    public final Type visitIntegerLiteral(GNode gNode) {
        Number number;
        int n;
        int n2;
        int n3;
        String string = gNode.getString(0);
        int n4 = string.length();
        boolean bl = '-' == string.charAt(0);
        boolean bl2 = 'L' == Character.toUpperCase(string.charAt(n4 - 1));
        int n5 = n3 = bl2 ? n4 - 1 : n4;
        if (string.startsWith("0x") || string.startsWith("0X")) {
            n2 = 16;
            n = bl ? 3 : 2;
        } else if (1 < n3 && '0' == string.charAt(0)) {
            n2 = 8;
            n = bl ? 2 : 1;
        } else {
            n2 = 10;
            n = bl ? 1 : 0;
        }
        String string2 = string.substring(n, n3);
        BigInteger bigInteger = new BigInteger(string2, n2);
        assert (bigInteger.compareTo(BigInteger.ZERO) >= 0);
        BigInteger bigInteger2 = new BigInteger("8000000000000000", 16);
        BigInteger bigInteger3 = new BigInteger("80000000", 16);
        BigInteger bigInteger4 = bigInteger2.add(bigInteger2);
        BigInteger bigInteger5 = bigInteger3.add(bigInteger3);
        BigInteger bigInteger6 = 10 == n2 ? (bl2 ? (bl ? bigInteger2 : bigInteger2.subtract(BigInteger.ONE)) : (bl ? bigInteger3 : bigInteger3.subtract(BigInteger.ONE))) : (bl2 ? bigInteger4 : bigInteger5).subtract(BigInteger.ONE);
        if (!this.assrt(gNode, bigInteger.compareTo(bigInteger6) <= 0, "literal out of range", new Object[0])) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        if (10 != n2 && bl2 && bigInteger.compareTo(bigInteger2) >= 0) {
            bigInteger = bigInteger.subtract(bigInteger4);
        }
        if (10 != n2 && !bl2 && bigInteger.compareTo(bigInteger3) >= 0) {
            bigInteger = bigInteger.subtract(bigInteger5);
        }
        if (bl) {
            bigInteger = BigInteger.ZERO.subtract(bigInteger);
        }
        Type type2 = JavaEntities.nameToBaseType(bl2 ? "long" : "int");
        Number number2 = number = bl2 ? (Number)new Long(bigInteger.longValue()) : (Number)new Integer(bigInteger.intValue());
        if (!this.assrt(gNode, bigInteger.equals(BigInteger.valueOf(number.longValue())), "literal out of range", new Object[0])) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        return JavaAnalyzer.setType(gNode, type2.annotate().constant(number));
    }

    public final void visitInterfaceDeclaration(GNode gNode) {
        if (JavaEntities.isScopeLocal(this._table.current().getQualifiedName())) {
            this._runtime.error("interface cannot be local", gNode);
            return;
        }
        JavaContext javaContext = this._context.save();
        this._context._handledExceptions = new ArrayList<Type>();
        this._context._hasScope = true;
        this._context._switch = false;
        this._context._loop = false;
        String string = gNode.getString(1);
        this.assrtLegalIdentifier(gNode, string);
        InterfaceT interfaceT = (InterfaceT)this._table.current().lookupLocally(SymbolTable.toTagName(string));
        if (null == interfaceT) {
            interfaceT = this._externalAnalyzer.visitInterfaceDeclaration(gNode);
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < interfaceT.getInterfaces().size(); ++i) {
            Type type2 = this.resolveIfAlias(interfaceT.getInterfaces().get(i), gNode.getGeneric(3).getNode(i));
            if (type2.isError() || !this.assrt(gNode.getGeneric(3), type2.isInterface(), "interface expected", new Object[0])) continue;
            String string2 = type2.toInterface().getQName();
            this.assrt(gNode.getGeneric(3), !hashSet.contains(string2), "duplicate superinterfaces", new Object[0]);
            hashSet.add(string2);
            this.assrt(gNode.getGeneric(3), JavaEntities.isAccessible(this._table, this.classpath(), type2), "superinterface not accessible", new Object[0]);
        }
        this.assrt(gNode, !JavaEntities.hasCircularDependency(this._table, this.classpath(), interfaceT), "circular class", new Object[0]);
        this._table.enter(string);
        this._table.mark(gNode.getNode(4));
        this.dispatch(gNode.getNode(4));
        this._table.exit();
        this._context.restore(javaContext);
    }

    public final void visitLabeledStatement(GNode gNode) {
        Object object;
        SymbolTable.Scope scope;
        this._table.enter(this._table.freshName("labeledStatement"));
        this._table.mark(gNode);
        String string = gNode.getString(0);
        String string2 = SymbolTable.toLabelName(string);
        SymbolTable.Scope scope2 = scope = this._table.current();
        while (!JavaEntities.isScopeTopLevel((String)(object = scope2.getQualifiedName())) && !JavaEntities.isScopeForMember((String)object)) {
            this.assrt(gNode, null == scope2.lookupLocally(string2), "duplicate label " + string, new Object[0]);
            scope2 = scope2.getParent();
        }
        object = new LabelT(string);
        scope.define(string2, object);
        String string3 = gNode.getNode(1).getName();
        if ("ForStatement".equals(string3) || "WhileStatement".equals(string3) || "DoWhileStatement".equals(string3)) {
            ((Type)object).addAttribute(Constants.ATT_LOOP);
        }
        this.dispatch(gNode.getNode(1));
        this._table.exit();
    }

    public final Type visitLogicalAndExpression(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getGeneric(0));
        Type type3 = this.getRValue(type2, gNode.getGeneric(0));
        Type type4 = this.dispatchRValue(gNode.getGeneric(1));
        if (type3.isError() || type4.isError()) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        Type type5 = JavaEntities.nameToBaseType("boolean");
        boolean bl = JavaTypeConverter.isIdentical(type3, type5);
        boolean bl2 = JavaTypeConverter.isIdentical(type4, type5);
        this.assrt(gNode.getGeneric(0), bl, "operand must be boolean", new Object[0]);
        this.assrt(gNode.getGeneric(1), bl2, "operand must be boolean", new Object[0]);
        Type type6 = bl && type3.hasConstant() && bl2 && type4.hasConstant() ? type5.annotate().constant(type3.getConstant().isTrue() && type4.getConstant().isTrue()) : type5;
        return JavaAnalyzer.setType(gNode, type6);
    }

    public final Type visitLogicalNegationExpression(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getGeneric(0));
        if (type2.isError()) {
            return JavaAnalyzer.setType(gNode, type2);
        }
        Type type3 = JavaEntities.nameToBaseType("boolean");
        if (!this.assrt(gNode, JavaTypeConverter.isIdentical(this.getRValue(type2, gNode), type3), "operand must be boolean", new Object[0])) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        if (type2.hasConstant()) {
            return JavaAnalyzer.setType(gNode, type3.annotate().constant(!type2.getConstant().isTrue()));
        }
        return JavaAnalyzer.setType(gNode, type2);
    }

    public final Type visitLogicalOrExpression(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getGeneric(0));
        Type type3 = this.getRValue(type2, gNode.getGeneric(0));
        Type type4 = this.dispatchRValue(gNode.getGeneric(1));
        if (type3.isError() || type4.isError()) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        Type type5 = JavaEntities.nameToBaseType("boolean");
        boolean bl = JavaTypeConverter.isIdentical(type3, type5);
        boolean bl2 = JavaTypeConverter.isIdentical(type4, type5);
        this.assrt(gNode.getGeneric(0), bl, "operand must be boolean", new Object[0]);
        this.assrt(gNode.getGeneric(1), bl2, "operand must be boolean", new Object[0]);
        Type type6 = bl && type3.hasConstant() && bl2 && type4.hasConstant() ? type5.annotate().constant(type3.getConstant().isTrue() || type4.getConstant().isTrue()) : type5;
        return JavaAnalyzer.setType(gNode, type6);
    }

    public Type visitMethodDeclaration(GNode gNode) {
        this.assrtLegalIdentifier(gNode, gNode.getString(3));
        this._table.enter(JavaEntities.methodSymbolFromAst(gNode));
        this._table.mark(gNode);
        JavaContext javaContext = this._context.save();
        this._context._hasScope = false;
        MethodT methodT = JavaEntities.currentMethod(this._table);
        this._context._static = JavaAnalyzer.hasModifier(methodT, "static");
        this.resolveIfAlias(methodT.getResult(), gNode.getNode(2));
        this._context._handledExceptions = null == gNode.get(6) ? new ArrayList() : methodT.getExceptions();
        this.assrtLegalHandledExceptions(gNode.getGeneric(6));
        this.assrtLegalMethodBody(gNode, methodT);
        this.assrtLegalMethod(gNode, methodT);
        this.dispatch(gNode.getNode(4));
        this.dispatch(gNode.getNode(7));
        this._context.restore(javaContext);
        this._table.exit();
        return JavaAnalyzer.setType(gNode, methodT);
    }

    public final List<Attribute> visitModifiers(GNode gNode) {
        return this._externalAnalyzer.visitModifiers(gNode);
    }

    public final Type visitMultiplicativeExpression(GNode gNode) {
        Type type2;
        Type type3 = (Type)this.dispatch(gNode.getGeneric(0));
        Type type4 = this.getRValue(type3, gNode.getGeneric(0));
        Type type5 = this.dispatchRValue(gNode.getGeneric(2));
        if (type4.isError() || type5.isError()) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        String string = gNode.getString(1);
        assert ("*".equals(string) || "/".equals(string) || "%".equals(string));
        Type type6 = JavaTypeConverter.promoteBinaryNumeric(type5, type4);
        Type type7 = JavaTypeConverter.promoteBinaryNumeric(type4, type5);
        if (null == type6 || null == type7) {
            this._runtime.error("numeric operands expected", gNode);
            type2 = JavaEntities.nameToBaseType("double");
        } else if (!type6.hasConstant() || !type7.hasConstant()) {
            type2 = JavaEntities.resolveToRawRValue(type6);
        } else {
            NumberT numberT = (NumberT)JavaEntities.resolveToRawRValue(type6);
            Number number = (Number)type6.getConstant().getValue();
            Number number2 = (Number)type7.getConstant().getValue();
            switch (numberT.getKind()) {
                case INT: {
                    int n = number.intValue();
                    int n2 = number2.intValue();
                    if ("*".equals(string)) {
                        type2 = numberT.annotate().constant(new Integer(n * n2));
                        break;
                    }
                    if (0 == n2) {
                        type2 = numberT;
                        break;
                    }
                    if ("/".equals(string)) {
                        type2 = numberT.annotate().constant(new Integer(n / n2));
                        break;
                    }
                    type2 = numberT.annotate().constant(new Integer(n % n2));
                    break;
                }
                case LONG: {
                    long l = number.longValue();
                    long l2 = number2.longValue();
                    if ("*".equals(string)) {
                        type2 = numberT.annotate().constant(new Long(l * l2));
                        break;
                    }
                    if (0L == l2) {
                        type2 = numberT;
                        break;
                    }
                    if ("/".equals(string)) {
                        type2 = numberT.annotate().constant(new Long(l / l2));
                        break;
                    }
                    type2 = numberT.annotate().constant(new Long(l % l2));
                    break;
                }
                case FLOAT: {
                    float f = number.floatValue();
                    float f2 = number2.floatValue();
                    if ("*".equals(string)) {
                        type2 = numberT.annotate().constant(new Float(f * f2));
                        break;
                    }
                    if ("/".equals(string)) {
                        type2 = numberT.annotate().constant(new Float(f / f2));
                        break;
                    }
                    type2 = numberT.annotate().constant(new Float(f % f2));
                    break;
                }
                case DOUBLE: {
                    double d = number.doubleValue();
                    double d2 = number2.doubleValue();
                    if ("*".equals(string)) {
                        type2 = numberT.annotate().constant(new Double(d * d2));
                        break;
                    }
                    if ("/".equals(string)) {
                        type2 = numberT.annotate().constant(new Double(d / d2));
                        break;
                    }
                    type2 = numberT.annotate().constant(new Double(d % d2));
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        return JavaAnalyzer.setType(gNode, type2);
    }

    public final Type visitNewArrayExpression(GNode gNode) {
        Type type2 = this.processTypeName(gNode.getGeneric(0));
        if (type2.isError()) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        this.dispatch(gNode.getNode(1));
        int n = JavaExternalAnalyzer.countDimensions(gNode.getGeneric(2));
        int n2 = n + (null == gNode.get(1) ? 0 : gNode.getGeneric(1).size());
        Type type3 = JavaEntities.typeWithDimensions(type2, n2);
        if (null != gNode.get(3)) {
            JavaContext javaContext = this._context.save();
            this._context._initializing = this.getRValue(type3, gNode.getGeneric(0));
            Type type4 = this.dispatchRValue(gNode.getGeneric(3));
            if (!type3.isError() && !type4.isError()) {
                this.assrt(gNode, JavaTypeConverter.isAssignable(this._table, this.classpath(), this._context._initializing, type4), "initializer type mismatch", new Object[0]);
            }
            this._context.restore(javaContext);
        }
        return JavaAnalyzer.setType(gNode, type3);
    }

    public final Type visitNewClassExpression(GNode gNode) {
        this.assrt(gNode, null == gNode.get(4), "anonymous classes not yet implemented", new Object[0]);
        this.dispatch(gNode.getNode(0));
        Type type2 = this.processTypeName(gNode.getGeneric(2));
        if (type2.isError() || !this.assrt(gNode.getGeneric(2), type2.isClass(), "can only instantiate class types", new Object[0]) || !this.assrt(gNode.getGeneric(2), !JavaAnalyzer.hasModifier(type2, "abstract"), "cannot instantiate abstract type", new Object[0])) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        List<Type> list = JavaEntities.typeList((List)this.dispatch(gNode.getNode(3)));
        MethodT methodT = JavaEntities.typeDotMethod(this._table, this.classpath(), type2, false, JavaEntities.typeToSimpleName(type2), list);
        if (null == methodT) {
            this._runtime.error("could not find constructor", gNode);
            JavaAnalyzer.setType(gNode.getGeneric(3), ErrorT.TYPE);
        } else {
            JavaAnalyzer.setType(gNode.getGeneric(3), methodT);
        }
        return JavaAnalyzer.setType(gNode, type2);
    }

    public final Type visitNullLiteral(GNode gNode) {
        return JavaAnalyzer.setType(gNode, JavaEntities.nameToBaseType("null"));
    }

    public final void visitPackageDeclaration(GNode gNode) {
        this._externalAnalyzer.visitPackageDeclaration(gNode);
    }

    public final Type visitPostfixExpression(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getGeneric(0));
        if (type2.isError()) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        if (!this.assrt(gNode, JavaEntities.isGeneralLValueT(type2), "operand of %s must be variable", gNode.getString(1))) {
            return JavaAnalyzer.setType(gNode, type2);
        }
        this.assrt(gNode, !JavaAnalyzer.hasModifier(type2, "final"), "operand of %s must not be final", gNode.getString(1));
        Type type3 = JavaEntities.dereference(type2);
        Type type4 = JavaEntities.resolveToRawRValue(type3);
        this.assrt(gNode, type4.isNumber(), "operand of %s must be number", gNode.getString(1));
        return JavaAnalyzer.setType(gNode, type3);
    }

    public Type visitPrimaryIdentifier(GNode gNode) {
        String string = gNode.getString(0);
        Type type2 = JavaEntities.simpleNameToPackageOrTypeOrExpression(this._table, this.classpath(), this._table.current().getQualifiedName(), string);
        assert (type2.isPackage() || JavaEntities.isWrappedClassT(type2) || JavaEntities.isWrappedInterfaceT(type2) || JavaEntities.isLocalT(type2) || JavaEntities.isFieldT(type2) || JavaEntities.isParameterT(type2));
        if (JavaEntities.isFieldT(type2)) {
            this.assrt(gNode, JavaAnalyzer.hasModifier(type2, "static") || !this._context._static, "static use of instance field", new Object[0]);
        }
        Type type3 = JavaEntities.notAValueIfClassOrInterface(type2);
        return JavaAnalyzer.setType(gNode, type3);
    }

    public final Type visitPrimitiveType(GNode gNode) {
        return JavaEntities.nameToBaseType(gNode.getString(0));
    }

    public final String visitQualifiedIdentifier(GNode gNode) {
        return this._externalAnalyzer.visitQualifiedIdentifier(gNode);
    }

    public final Type visitRelationalExpression(GNode gNode) {
        Type type2;
        Type type3 = (Type)this.dispatch(gNode.getGeneric(0));
        Type type4 = this.getRValue(type3, gNode.getGeneric(0));
        Type type5 = this.dispatchRValue(gNode.getGeneric(2));
        if (type4.isError() || type5.isError()) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        String string = gNode.getString(1);
        Type type6 = JavaEntities.nameToBaseType("boolean");
        assert ("<".equals(string) || ">".equals(string) || "<=".equals(string) || ">=".equals(string));
        Type type7 = JavaTypeConverter.promoteBinaryNumeric(type5, type4);
        Type type8 = JavaTypeConverter.promoteBinaryNumeric(type4, type5);
        if (null == type7 || null == type8) {
            this._runtime.error("numeric operands expected", gNode);
            type2 = type6;
        } else if (!type7.hasConstant() || !type8.hasConstant()) {
            type2 = type6;
        } else {
            NumberT numberT = (NumberT)JavaEntities.resolveToRawRValue(type7);
            Number number = (Number)type7.getConstant().getValue();
            Number number2 = (Number)type8.getConstant().getValue();
            switch (numberT.getKind()) {
                case INT: {
                    int n = number.intValue();
                    int n2 = number2.intValue();
                    if ("<".equals(string)) {
                        type2 = type6.annotate().constant(n < n2);
                        break;
                    }
                    if ("<=".equals(string)) {
                        type2 = type6.annotate().constant(n <= n2);
                        break;
                    }
                    if (">".equals(string)) {
                        type2 = type6.annotate().constant(n > n2);
                        break;
                    }
                    type2 = type6.annotate().constant(n >= n2);
                    break;
                }
                case LONG: {
                    long l = number.longValue();
                    long l2 = number2.longValue();
                    if ("<".equals(string)) {
                        type2 = type6.annotate().constant(l < l2);
                        break;
                    }
                    if ("<=".equals(string)) {
                        type2 = type6.annotate().constant(l <= l2);
                        break;
                    }
                    if (">".equals(string)) {
                        type2 = type6.annotate().constant(l > l2);
                        break;
                    }
                    type2 = type6.annotate().constant(l >= l2);
                    break;
                }
                case FLOAT: {
                    float f = number.floatValue();
                    float f2 = number2.floatValue();
                    if ("<".equals(string)) {
                        type2 = type6.annotate().constant(f < f2);
                        break;
                    }
                    if ("<=".equals(string)) {
                        type2 = type6.annotate().constant(f <= f2);
                        break;
                    }
                    if (">".equals(string)) {
                        type2 = type6.annotate().constant(f > f2);
                        break;
                    }
                    type2 = type6.annotate().constant(f >= f2);
                    break;
                }
                case DOUBLE: {
                    double d = number.doubleValue();
                    double d2 = number2.doubleValue();
                    if ("<".equals(string)) {
                        type2 = type6.annotate().constant(d < d2);
                        break;
                    }
                    if ("<=".equals(string)) {
                        type2 = type6.annotate().constant(d <= d2);
                        break;
                    }
                    if (">".equals(string)) {
                        type2 = type6.annotate().constant(d > d2);
                        break;
                    }
                    type2 = type6.annotate().constant(d >= d2);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        return JavaAnalyzer.setType(gNode, type2);
    }

    public void visitReturnStatement(GNode gNode) {
        MethodT methodT = JavaEntities.currentMethod(this._table);
        if (null == methodT) {
            this._runtime.error("return statement outside method", gNode);
            return;
        }
        VoidT voidT = null == gNode.get(0) ? VoidT.TYPE : this.dispatchRValue(gNode.getGeneric(0));
        Type type2 = methodT.getResult();
        if (voidT.isError() || type2.isError()) {
            return;
        }
        if (type2.isVoid()) {
            this.assrt(gNode, ((Type)voidT).isVoid(), "'return' with a value, in method returning void", new Object[0]);
        } else if (((Type)voidT).isVoid()) {
            this._runtime.error("'return' with no value, in method returning non-void", gNode);
        } else {
            this.assrt(gNode, JavaTypeConverter.isAssignable(this._table, this.classpath(), type2, voidT), "return type mismatch", new Object[0]);
        }
    }

    public final Type visitSelectionExpression(GNode gNode) {
        Type type2;
        Type type3;
        Type type4 = (Type)this.dispatch(gNode.getGeneric(0));
        Type type5 = JavaAnalyzer.getRValueNoError(type4);
        String string = gNode.getString(1);
        if (null != type5) {
            type3 = JavaEntities.typeDotTypeOrField(this._table, this.classpath(), type5, true, string);
        } else if (type4.isPackage()) {
            type3 = JavaEntities.packageDotPackageOrType(this._table, this.classpath(), (PackageT)type4, string);
        } else if (JavaEntities.isNotAValueT(type4)) {
            type2 = JavaEntities.resolveToValue(type4.toAnnotated());
            type3 = JavaEntities.typeDotTypeOrField(this._table, this.classpath(), type2, true, string);
            if (!this.assrt(gNode, null != type3, "unknown or ambiguous type or field %s", string) || !this.assrt(gNode, null == type3 || JavaEntities.hasModifier(type3, "static"), "static access to non-static field", new Object[0])) {
                return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
            }
        } else if (JavaEntities.isWrappedClassT(type4) || JavaEntities.isWrappedInterfaceT(type4)) {
            type3 = JavaEntities.typeDotTypeOrField(this._table, this.classpath(), type4, true, string);
        } else {
            throw new Error(type4.getClass().getName());
        }
        if (null == type3) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        type2 = JavaEntities.notAValueIfClassOrInterface(type3);
        return JavaAnalyzer.setType(gNode, type2);
    }

    public final Type visitShiftExpression(GNode gNode) {
        Type type2;
        Type type3 = (Type)this.dispatch(gNode.getGeneric(0));
        Type type4 = this.getRValue(type3, gNode.getGeneric(0));
        Type type5 = this.dispatchRValue(gNode.getGeneric(2));
        if (type4.isError() || type5.isError()) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        String string = gNode.getString(1);
        assert ("<<".equals(string) || ">>".equals(string) || ">>>".equals(string));
        Type type6 = JavaTypeConverter.promoteUnaryNumeric(type4);
        Type type7 = JavaTypeConverter.promoteUnaryNumeric(type5);
        if (null == type6) {
            this._runtime.error("integral operand expected", gNode.getNode(0));
            type2 = JavaEntities.nameToBaseType("long");
        } else if (null == type7) {
            this._runtime.error("integral operand expected", gNode.getNode(2));
            type2 = type6;
        } else {
            NumberT numberT = (NumberT)JavaEntities.resolveToRawRValue(type6);
            NumberT numberT2 = (NumberT)JavaEntities.resolveToRawRValue(type7);
            if (!numberT.isInteger()) {
                this._runtime.error("integral operand expected", gNode.getNode(0));
                type2 = JavaEntities.nameToBaseType("int");
            } else if (!numberT2.isInteger()) {
                this._runtime.error("integral operand expected", gNode.getNode(2));
                type2 = type6;
            } else if (!type6.hasConstant() || !type7.hasConstant()) {
                type2 = type6;
            } else {
                Number number = (Number)type6.getConstant().getValue();
                Number number2 = (Number)type7.getConstant().getValue();
                long l = number2.longValue();
                switch (numberT.getKind()) {
                    case INT: {
                        int n = number.intValue();
                        if ("<<".equals(string)) {
                            type2 = numberT.annotate().constant(new Integer(n << (int)l));
                            break;
                        }
                        if (">>".equals(string)) {
                            type2 = numberT.annotate().constant(new Integer(n >> (int)l));
                            break;
                        }
                        type2 = numberT.annotate().constant(new Integer(n >>> (int)l));
                        break;
                    }
                    case LONG: {
                        long l2 = number.longValue();
                        if ("<<".equals(string)) {
                            type2 = numberT.annotate().constant(new Long(l2 << (int)l));
                            break;
                        }
                        if (">>".equals(string)) {
                            type2 = numberT.annotate().constant(new Long(l2 >> (int)l));
                            break;
                        }
                        type2 = numberT.annotate().constant(new Long(l2 >>> (int)l));
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
        }
        return JavaAnalyzer.setType(gNode, type2);
    }

    public final Type visitStringLiteral(GNode gNode) {
        ClassT classT = JavaEntities.tString(this._table);
        String string = gNode.getString(0);
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length() - 1;
        int n2 = 1;
        try {
            while (n2 < n) {
                char c = string.charAt(n2);
                if (c == '\\') {
                    stringBuffer.append(JavaAnalyzer.escapeSequenceChar(string, n2));
                    n2 = this.escapeSequenceEnd(string, n2);
                    continue;
                }
                if (!this.assrt(gNode, '\r' != c && '\n' != c, "string must not contain line terminator", new Object[0])) {
                    return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
                }
                stringBuffer.append(c);
                ++n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._runtime.error("illegal escape sequence", gNode);
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        return JavaAnalyzer.setType(gNode, classT.annotate().constant(stringBuffer.toString()));
    }

    public final Type visitSubscriptExpression(GNode gNode) {
        Type type2 = this.dispatchRValue(gNode.getGeneric(0));
        if (!this.assrt(gNode, type2.isArray(), "array reference expression expected", new Object[0])) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        Type type3 = this.dispatchRValue(gNode.getGeneric(1));
        this.assrt(gNode, JavaEntities.isInt(type3), "integer expression expected", new Object[0]);
        AnnotatedT annotatedT = (AnnotatedT)((ArrayT)type2).getType();
        this.resolveIfAlias(JavaEntities.dereference(annotatedT));
        return JavaAnalyzer.setType(gNode, annotatedT);
    }

    public final Type visitSuperExpression(GNode gNode) {
        this.assrt(gNode, !this._context._static, "static use of super", new Object[0]);
        ClassOrInterfaceT classOrInterfaceT = JavaEntities.currentType(this._table);
        ClassT classT = (ClassT)JavaEntities.resolveToRawClassOrInterfaceT(classOrInterfaceT);
        Type type2 = JavaEntities.resolveIfAlias(this._table, this.classpath(), JavaEntities.typeToScopeName(classOrInterfaceT), classT.getParent());
        return JavaAnalyzer.setType(gNode, type2);
    }

    public final void visitSwitchStatement(GNode gNode) {
        JavaContext javaContext = this._context.save();
        this._context._switch = true;
        Type type2 = (Type)this.dispatch(gNode.getGeneric(0));
        Type type3 = JavaEntities.isGeneralLValueT(type2) ? JavaEntities.dereference(type2) : type2;
        Type type4 = JavaEntities.resolveToRawRValue(type3);
        this.assrt(gNode.getGeneric(0), JavaEntities.nameToBaseType("char") == type4 || JavaEntities.nameToBaseType("byte") == type4 || JavaEntities.nameToBaseType("short") == type4 || JavaEntities.nameToBaseType("int") == type4, "switch expression must be char, byte, short, or int", new Object[0]);
        boolean bl = false;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 1; i < gNode.size(); ++i) {
            GNode gNode2 = gNode.getGeneric(i);
            if (gNode2.hasName("DefaultClause")) {
                this.dispatch(gNode2);
                if (bl) {
                    this._runtime.error("duplicate default clause", gNode2);
                }
                bl = true;
                continue;
            }
            Type type5 = (Type)this.dispatch(gNode2);
            Type type6 = this.getRValue(type5, gNode2);
            if (JavaTypeConverter.isAssignable(this._table, this.classpath(), type4, type6)) {
                if (null == type6) {
                    throw new Error();
                }
                if (JavaEntities.isConstantT(type6)) {
                    int n;
                    Object object = type6.getConstant().getValue();
                    if (null == object) {
                        throw new Error();
                    }
                    int n2 = n = object instanceof Character ? ((Character)object).charValue() : ((Number)object).intValue();
                    if (hashSet.contains(new Integer(n))) {
                        this._runtime.error("duplicate case clause", gNode2);
                    } else {
                        hashSet.add(new Integer(n));
                    }
                    this.assrt(gNode2, this.isAssignable(n, type4), "invalid case clause", new Object[0]);
                    continue;
                }
                this.assrt(gNode, JavaEntities.isGeneralLValueT(type5) && JavaAnalyzer.hasModifier(type5, "final"), "case expression must be constant", new Object[0]);
                continue;
            }
            this._runtime.error("invalid case clause", gNode2);
        }
        this._context.restore(javaContext);
    }

    public final void visitSynchronizedStatement(GNode gNode) {
        GNode gNode2;
        Type type2 = this.dispatchRValue(gNode2 = gNode.getGeneric(0));
        this.assrt(gNode2, !JavaEntities.isNullT(type2) && JavaEntities.isReferenceT(type2), "invalid type for synchronized statement", new Object[0]);
        this.dispatch(gNode.getNode(1));
    }

    public final Type visitThisExpression(GNode gNode) {
        this.assrt(gNode, !this._context._static, "static use of this", new Object[0]);
        return JavaAnalyzer.setType(gNode, JavaEntities.currentType(this._table));
    }

    public final void visitThrowStatement(GNode gNode) {
        Type type2 = this.dispatchRValue(gNode.getGeneric(0));
        ClassT classT = JavaEntities.tThrowable(this._table);
        if (!JavaTypeConverter.isAssignable(this._table, this.classpath(), classT, type2)) {
            this._runtime.error("exception must be throwable", gNode.getNode(0));
        } else if (JavaEntities.isCheckedException(this._table, this.classpath(), type2)) {
            this.assrt(gNode, this.isHandled(type2), "uncaught exception", new Object[0]);
        }
    }

    public final List<Type> visitTryCatchFinallyStatement(GNode gNode) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        for (int i = 1; i < gNode.size() - 1; ++i) {
            arrayList.add((Type)this.dispatch(gNode.getNode(i)));
        }
        JavaContext javaContext = this._context.save();
        this._context._handledExceptions = new ArrayList<Type>();
        this._context._handledExceptions.addAll(javaContext._handledExceptions);
        this._context._handledExceptions.addAll(arrayList);
        this.dispatch(gNode.getNode(0));
        this._context.restore(javaContext);
        this.dispatch(gNode.getNode(gNode.size() - 1));
        return arrayList;
    }

    public final Type visitType(GNode gNode) {
        Type type2 = this._externalAnalyzer.visitType(gNode);
        Type type3 = this.resolveIfAlias(type2, gNode);
        return JavaAnalyzer.setType(gNode, type3);
    }

    public final Type visitUnaryExpression(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getGeneric(1));
        if (type2.isError()) {
            return JavaAnalyzer.setType(gNode, type2);
        }
        String string = gNode.getString(0);
        if ("++".equals(string) || "--".equals(string)) {
            if (JavaEntities.isGeneralLValueT(type2)) {
                this.assrt(gNode, !JavaAnalyzer.hasModifier(type2, "final"), "operand of %s must not be final", string);
                Type type3 = JavaEntities.dereference(type2);
                Type type4 = JavaEntities.resolveToRawRValue(type3);
                if (!this.assrt(gNode, type4.isNumber(), "operand of %s must be number", string)) {
                    return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
                }
                return JavaAnalyzer.setType(gNode, type3);
            }
            this._runtime.error("operand of " + string + " must be variable", gNode);
            return JavaAnalyzer.setType(gNode, type2);
        }
        assert ("+".equals(string) || "-".equals(string));
        Type type5 = JavaTypeConverter.promoteUnaryNumeric(this.getRValue(type2, gNode.getGeneric(1)));
        if (!this.assrt(gNode, null != type5, "operand must be numeric", new Object[0])) {
            return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
        }
        if (type5.hasConstant()) {
            if ("+".equals(string)) {
                return JavaAnalyzer.setType(gNode, type5);
            }
            NumberT numberT = (NumberT)JavaEntities.resolveToRawRValue(type5);
            Number number = (Number)type5.getConstant().getValue();
            switch (numberT.getKind()) {
                case INT: {
                    int n = number.intValue();
                    return numberT.annotate().constant(new Integer("-".equals(string) ? -n : ~n));
                }
                case LONG: {
                    long l = number.longValue();
                    return numberT.annotate().constant(new Long("-".equals(string) ? -l : l ^ 0xFFFFFFFFFFFFFFFFL));
                }
                case FLOAT: {
                    if (!this.assrt(gNode, "-".equals(string), "operand must be an integral type", new Object[0])) {
                        return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
                    }
                    return numberT.annotate().constant(new Float(-number.floatValue()));
                }
                case DOUBLE: {
                    if (!this.assrt(gNode, "-".equals(string), "operand must be an integral type", new Object[0])) {
                        return JavaAnalyzer.setType(gNode, ErrorT.TYPE);
                    }
                    return numberT.annotate().constant(new Double(-number.doubleValue()));
                }
            }
            throw new Error();
        }
        return JavaAnalyzer.setType(gNode, type5);
    }

    public final void visitWhileStatement(GNode gNode) {
        JavaContext javaContext = this._context.save();
        this._context._loop = true;
        Type type2 = this.dispatchRValue(gNode.getGeneric(0));
        if (!JavaEntities.resolveToRawRValue(type2).isBoolean()) {
            this._runtime.error("condition must be boolean", gNode.getGeneric(0));
        }
        this.dispatch(gNode.getNode(1));
        this._context.restore(javaContext);
    }

    public static final class JavaContext {
        public List<Type> _handledExceptions = new ArrayList<Type>();
        public boolean _hasScope = true;
        Type _initializing = null;
        public boolean _loop = false;
        public boolean _static = false;
        public boolean _switch = false;

        public final void restore(JavaContext javaContext) {
            this._handledExceptions = javaContext._handledExceptions;
            this._hasScope = javaContext._hasScope;
            this._initializing = javaContext._initializing;
            this._loop = javaContext._loop;
            this._static = javaContext._static;
            this._switch = javaContext._switch;
        }

        public final JavaContext save() {
            JavaContext javaContext = new JavaContext();
            javaContext.restore(this);
            return javaContext;
        }
    }
}

