/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import xtc.lang.CFactoryParser;
import xtc.lang.JavaAstSimplifier;
import xtc.lang.JavaFactoryParser;
import xtc.parser.ParseException;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Transducer;
import xtc.util.Tool;
import xtc.util.Utilities;

public class FactoryFactory
extends Tool {
    public String getName() {
        return "xtc Factory Factory";
    }

    public String getCopy() {
        return "(C) 2004-2008 Robert Grimm";
    }

    public String getExplanation() {
        return "This tool translates factory declarations into the corresponding Java classes.  Each declaration contains one or more snippets of literal Java or C code, which are then translated into methods that create the corresponding AST.  Snippets may be declarations, statements, or expressions; they may also contain pattern variables. The default language for snippets is Java; use the -C option for C.";
    }

    public void init() {
        super.init();
        this.runtime.bool("C", "createCFactory", false, "Create a factory for C ASTs.").bool("simplify", "simplifyAST", false, "Simplify the Java AST.");
    }

    public void prepare() {
        super.prepare();
        if (this.runtime.test("createCFactory") && this.runtime.test("simplifyAST")) {
            this.runtime.error("simplify option only valid for Java ASTs");
        }
    }

    public File locate(String string) throws IOException {
        File file = super.locate(string);
        if (Integer.MAX_VALUE < file.length()) {
            throw new IllegalArgumentException(file + ": file too large");
        }
        return file;
    }

    public Node parse(Reader reader, File file) throws IOException, ParseException {
        if (this.runtime.test("createCFactory")) {
            CFactoryParser cFactoryParser = new CFactoryParser(reader, file.toString(), (int)file.length());
            return (Node)cFactoryParser.value(cFactoryParser.pFactory(0));
        }
        JavaFactoryParser javaFactoryParser = new JavaFactoryParser(reader, file.toString(), (int)file.length());
        return (Node)javaFactoryParser.value(javaFactoryParser.pFactory(0));
    }

    public void process(Node node) {
        Printer printer;
        Object object2;
        GNode gNode = GNode.cast(node);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Object object2 : GNode.cast(gNode.get(0))) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append('.');
            }
            stringBuilder.append((String)object2);
        }
        String string = stringBuilder.toString();
        object2 = new File(this.runtime.getOutputDirectory(), Utilities.getName(string) + ".java");
        try {
            printer = new Printer(new PrintWriter(this.runtime.getWriter((File)object2)));
        }
        catch (IOException iOException) {
            if (null == iOException.getMessage()) {
                this.runtime.error(((File)object2).toString() + ": I/O error");
            } else {
                this.runtime.error(((File)object2).toString() + ": " + iOException.getMessage());
            }
            return;
        }
        String string2 = Utilities.getQualifier(string);
        this.printHeader(printer);
        if (null != string2) {
            printer.indent().p("package ").p(string2).pln(';');
            printer.pln();
        }
        printer.indent().pln("import java.util.List;").pln();
        if (!"xtc.tree".equals(string2)) {
            printer.indent().pln("import xtc.tree.Node;");
            printer.indent().pln("import xtc.tree.GNode;");
            printer.pln();
        }
        printer.indent().pln("/**");
        printer.indent().p(" * Node factory <code>").p(string).pln("</code>.");
        printer.indent().pln(" *");
        printer.indent().pln(" * <p />This class has been generated by");
        printer.indent().p(" * the xtc Factory Factory, version ").p(this.getVersion()).pln(',');
        printer.indent().p(" * ").p(this.getCopy()).pln('.');
        printer.indent().pln(" */");
        printer.indent().p("public class ").p(Utilities.getName(string)).pln(" {").incr();
        printer.pln();
        printer.indent().pln("/** Create a new node factory. */");
        printer.indent().p("public ").p(Utilities.getName(string)).pln("() {").incr();
        printer.indent().pln("// Nothing to do.");
        printer.decr().indent().pln('}');
        printer.pln();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("NodeVariable", "Node");
        hashMap.put("NodeListVariable", "List<Node>");
        hashMap.put("StringVariable", "String");
        Transducer transducer = new Transducer(printer, hashMap);
        JavaAstSimplifier javaAstSimplifier = null;
        if (this.runtime.test("simplifyAST")) {
            javaAstSimplifier = new JavaAstSimplifier();
        }
        for (Object object3 : GNode.cast(gNode.get(1))) {
            GNode gNode2 = GNode.cast(object3);
            Node node2 = gNode2.getNode(1);
            if (this.runtime.test("simplifyAST")) {
                node2 = (Node)javaAstSimplifier.dispatch(node2);
            }
            transducer.process(gNode2.getString(0), node2);
            printer.pln();
        }
        printer.decr().indent().pln('}');
        printer.flush().close();
    }

    public static void main(String[] stringArray) {
        new FactoryFactory().run(stringArray);
    }
}

