/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import xtc.lang.SourceMapExtractor;

public class ClassfileSourceRemapper {
    private static final String ANAME_SMAP = "SourceDebugExtension";
    private static final String ANAME_LINENUMBERTABLE = "LineNumberTable";
    private static final String ANAME_CODE = "Code";
    private static final String ANAME_SOURCEFILE = "SourceFile";
    public static final int CP_Class = 7;
    public static final int CP_Fieldref = 9;
    public static final int CP_Methodref = 10;
    public static final int CP_InterfaceMethodref = 11;
    public static final int CP_String = 8;
    public static final int CP_Integer = 3;
    public static final int CP_Float = 4;
    public static final int CP_Long = 5;
    public static final int CP_Double = 6;
    public static final int CP_NameAndType = 12;
    public static final int CP_Utf8 = 1;
    private final boolean bRemapLineNumberTable;
    private final boolean bInsertSMAPTable;
    private final String inputClassFile;
    private final String outputClassFile;
    private final SourceMapExtractor smap;
    private DataInputStream is;
    private DataOutputStream os;
    private ByteArrayOutputStream bos;
    private int constantPoolEntryIndexForInputSourceFileName = -1;
    private int constantPoolEntryIndexForSMAP = -1;
    private String[] UTF8ConstantPoolEntries;

    private static void usage(String string) {
        String string2 = "usage: ClassfileSourceRemapper {-stratify|-flatten} [java source file] [class file]";
        System.err.println(string2 + "\n" + string);
        System.exit(-1);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        boolean bl2 = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (string3.equals("-stratify")) {
                bl2 = false;
                bl = true;
                continue;
            }
            if (string3.equals("-flatten")) {
                bl2 = true;
                bl = false;
                continue;
            }
            if (string == null) {
                if (new File(string3).canRead()) {
                    string = string3;
                    continue;
                }
                ClassfileSourceRemapper.usage("can not read " + string3);
                continue;
            }
            if (string2 != null) continue;
            if (new File(string3).canRead()) {
                string2 = string3;
                continue;
            }
            ClassfileSourceRemapper.usage("can not write " + string3);
        }
        if (bl && bl2) {
            ClassfileSourceRemapper.usage("specify only one of the -stratify and -flatten");
        }
        if (string == null) {
            ClassfileSourceRemapper.usage("specify [java source file]");
        }
        if (string2 == null) {
            ClassfileSourceRemapper.usage("spcify [class file]");
        }
        try {
            boolean bl3;
            SourceMapExtractor sourceMapExtractor = new SourceMapExtractor(string);
            sourceMapExtractor.genSMAP();
            if (sourceMapExtractor.getNumberOfInputSourceFiles() < 1) {
                System.err.println("no source-to-source mapping found in the " + string);
                System.exit(-1);
            }
            if (!(bl3 = bl) && sourceMapExtractor.getNumberOfInputSourceFiles() >= 2) {
                System.err.println("more than one input source files in the " + string);
                System.err.println("This tool can not process class file with -flatten option");
                System.err.println("Please consider using -stratify option");
                System.exit(-1);
            }
            ClassfileSourceRemapper classfileSourceRemapper = new ClassfileSourceRemapper(sourceMapExtractor, string2, string2, bl3);
            classfileSourceRemapper.doRemapping();
        }
        catch (IOException iOException) {
            System.err.println("failed in remapping line number information");
            iOException.printStackTrace();
        }
    }

    public ClassfileSourceRemapper(SourceMapExtractor sourceMapExtractor, String string, String string2, boolean bl) {
        this.smap = sourceMapExtractor;
        this.inputClassFile = string;
        this.outputClassFile = string2;
        if (bl) {
            this.bRemapLineNumberTable = false;
            this.bInsertSMAPTable = true;
        } else {
            this.bRemapLineNumberTable = true;
            this.bInsertSMAPTable = false;
        }
    }

    private LineNumberTableEntry[] adjustLineNumberTable(LineNumberTableEntry[] lineNumberTableEntryArray, String string, String string2) {
        assert (lineNumberTableEntryArray != null);
        LineNumberTableEntry[] lineNumberTableEntryArray2 = new LineNumberTableEntry[lineNumberTableEntryArray.length];
        for (int i = 0; i < lineNumberTableEntryArray2.length; ++i) {
            LineNumberTableEntry lineNumberTableEntry = lineNumberTableEntryArray[i];
            int n = lineNumberTableEntry.getStartPC();
            int n2 = lineNumberTableEntry.getLineNumber();
            int n3 = this.smap.getSingleSourceLine(n2);
            lineNumberTableEntryArray2[i] = new LineNumberTableEntry(n, n3);
        }
        return lineNumberTableEntryArray2;
    }

    public void doRemapping() throws IOException {
        assert (this.smap != null && this.is == null && this.os == null && this.bos == null);
        try {
            this.is = new DataInputStream(new FileInputStream(this.inputClassFile));
            this.bos = new ByteArrayOutputStream();
            this.os = new DataOutputStream(this.bos);
            this.processClass();
            this.is.close();
        }
        catch (IOException iOException) {
            System.err.println("error while reading:" + this.inputClassFile);
            throw iOException;
        }
        try {
            byte[] byArray = this.bos.toByteArray();
            this.bos.close();
            this.os.close();
            assert (byArray != null && byArray.length > 0);
            FileOutputStream fileOutputStream = new FileOutputStream(this.outputClassFile);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("error while writing to: " + this.outputClassFile);
            throw iOException;
        }
        this.is = null;
        this.os = null;
        this.bos = null;
        this.constantPoolEntryIndexForInputSourceFileName = -1;
        this.constantPoolEntryIndexForSMAP = -1;
        this.UTF8ConstantPoolEntries = null;
    }

    private void processClass() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.processInt();
        assert (n5 == -889275714);
        this.processUnsignedShort();
        this.processUnsignedShort();
        int n6 = this.is.readUnsignedShort();
        assert (n6 >= 1);
        this.UTF8ConstantPoolEntries = new String[n6];
        this.os.writeShort(n6 + 1);
        for (n4 = 1; n4 < n6; ++n4) {
            int n7 = this.processCP(n4);
            if (n7 != 6 && n7 != 5) continue;
            ++n4;
        }
        n4 = n6;
        if (this.bRemapLineNumberTable) {
            String string = this.smap.getSingleSourceFileName();
            byte[] byArray = string.getBytes("UTF8");
            this.constantPoolEntryIndexForInputSourceFileName = n4++;
            this.os.writeByte(1);
            this.os.writeShort(byArray.length);
            this.os.write(byArray);
        }
        if (this.bInsertSMAPTable) {
            this.constantPoolEntryIndexForSMAP = n4++;
            byte[] byArray = ANAME_SMAP.getBytes("UTF8");
            this.os.writeByte(1);
            this.os.writeShort(byArray.length);
            this.os.write(byArray);
        }
        short s = this.processShort();
        int n8 = this.processUnsignedShort();
        int n9 = this.processUnsignedShort();
        int n10 = this.processUnsignedShort();
        if (n10 > 0) {
            this.processBytes(n10 * 2);
        }
        int n11 = this.processUnsignedShort();
        for (n3 = 0; n3 < n11; ++n3) {
            this.processBytes(6);
            n2 = this.processUnsignedShort();
            for (n = 0; n < n2; ++n) {
                this.processAttribute();
            }
        }
        n3 = this.processUnsignedShort();
        for (n2 = 0; n2 < n3; ++n2) {
            this.processMethodInfo(n2);
        }
        n2 = this.is.readUnsignedShort();
        if (this.bInsertSMAPTable) {
            this.os.writeShort(n2 + 1);
        } else {
            this.os.writeShort(n2);
        }
        for (n = 0; n < n2; ++n) {
            int n12 = this.processUnsignedShort();
            String string = this.UTF8ConstantPoolEntries[n12];
            assert (string != null);
            if (this.bRemapLineNumberTable && string.equals(ANAME_SOURCEFILE)) {
                this.processSourceFile();
                continue;
            }
            this.processBytes(this.processInt());
        }
        if (this.bInsertSMAPTable) {
            byte[] byArray = this.smap.toStringInSMAPFormat().getBytes("UTF8");
            this.os.writeShort(this.constantPoolEntryIndexForSMAP);
            this.os.writeInt(byArray.length);
            this.os.write(byArray);
        }
        assert (this.is.read() == -1);
    }

    private int processCP(int n) throws IOException {
        byte by = this.processByte();
        switch (by) {
            case 7: {
                this.processBytes(2);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.processBytes(2);
                this.processBytes(2);
                break;
            }
            case 8: {
                this.processBytes(2);
                break;
            }
            case 3: 
            case 4: {
                this.processBytes(4);
                break;
            }
            case 5: 
            case 6: {
                this.processBytes(8);
                break;
            }
            case 12: {
                this.processBytes(4);
                break;
            }
            case 1: {
                int n2 = this.processUnsignedShort();
                byte[] byArray = this.processBytes(n2);
                this.UTF8ConstantPoolEntries[n] = new String(byArray, "UTF8");
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return by;
    }

    private void processMethodInfo(int n) throws IOException {
        int n2 = this.processUnsignedShort();
        int n3 = this.processUnsignedShort();
        String string = this.UTF8ConstantPoolEntries[n3];
        int n4 = this.processUnsignedShort();
        String string2 = this.UTF8ConstantPoolEntries[n4];
        int n5 = this.processUnsignedShort();
        if (this.bRemapLineNumberTable) {
            for (int i = 0; i < n5; ++i) {
                int n6 = this.processUnsignedShort();
                String string3 = this.UTF8ConstantPoolEntries[n6];
                if (string3.equals(ANAME_CODE)) {
                    this.processMethodCodeAttribute(n6, string, string2);
                    continue;
                }
                this.processBytes(this.processInt());
            }
        } else {
            for (int i = 0; i < n5; ++i) {
                this.processAttribute();
            }
        }
    }

    private void processLineNumberTable(String string, String string2) throws IOException {
        int n;
        int n2;
        int n3 = this.is.readInt();
        int n4 = this.is.readUnsignedShort();
        LineNumberTableEntry[] lineNumberTableEntryArray = new LineNumberTableEntry[n4];
        for (int i = 0; i < n4; ++i) {
            n2 = this.is.readUnsignedShort();
            n = this.is.readUnsignedShort();
            lineNumberTableEntryArray[i] = new LineNumberTableEntry(n2, n);
        }
        LineNumberTableEntry[] lineNumberTableEntryArray2 = this.adjustLineNumberTable(lineNumberTableEntryArray, string, string2);
        assert (lineNumberTableEntryArray2.length == lineNumberTableEntryArray.length);
        n2 = lineNumberTableEntryArray2.length;
        n = 2 + n2 * 4;
        this.os.writeInt(n);
        this.os.writeShort(n2);
        for (int i = 0; i < n2; ++i) {
            int n5 = lineNumberTableEntryArray2[i].getStartPC();
            int n6 = lineNumberTableEntryArray2[i].getLineNumber();
            this.os.writeShort(n5);
            this.os.writeShort(n6);
        }
    }

    private void processSourceFile() throws IOException {
        int n = this.is.readInt();
        int n2 = this.is.readUnsignedShort();
        String string = this.UTF8ConstantPoolEntries[n2];
        assert (n == 2 && this.constantPoolEntryIndexForInputSourceFileName >= 1);
        this.os.writeInt(2);
        this.os.writeShort(this.constantPoolEntryIndexForInputSourceFileName);
    }

    private void processMethodCodeAttribute(int n, String string, String string2) throws IOException {
        assert (this.UTF8ConstantPoolEntries[n].equals(ANAME_CODE));
        int n2 = this.processInt();
        int n3 = this.processUnsignedShort();
        int n4 = this.processUnsignedShort();
        int n5 = this.processInt();
        this.processBytes(n5);
        int n6 = this.processUnsignedShort();
        this.processBytes(8 * n6);
        int n7 = this.processUnsignedShort();
        for (int i = 0; i < n7; ++i) {
            int n8 = this.processUnsignedShort();
            String string3 = this.UTF8ConstantPoolEntries[n8];
            if (string3.equals(ANAME_LINENUMBERTABLE)) {
                this.processLineNumberTable(string, string2);
                continue;
            }
            this.processBytes(this.processInt());
        }
    }

    private void processAttribute() throws IOException {
        this.processBytes(2);
        int n = this.processInt();
        this.processBytes(n);
    }

    private byte[] processBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = this.is.read(byArray);
        assert (n2 == n);
        this.os.write(byArray);
        return byArray;
    }

    private int processInt() throws IOException {
        int n = this.is.readInt();
        this.os.writeInt(n);
        return n;
    }

    private short processShort() throws IOException {
        short s = this.is.readShort();
        this.os.writeShort(s);
        return s;
    }

    private int processUnsignedShort() throws IOException {
        int n = this.is.readUnsignedShort();
        this.os.writeShort(n);
        return n;
    }

    private byte processByte() throws IOException {
        byte by = this.is.readByte();
        this.os.writeByte(by);
        return by;
    }

    private static class LineNumberTableEntry {
        int start_pc;
        int line_number;

        LineNumberTableEntry(int n, int n2) {
            assert (n <= 65535 & n2 <= 65535);
            this.start_pc = n;
            this.line_number = n2;
        }

        int getStartPC() {
            return this.start_pc;
        }

        int getLineNumber() {
            return this.line_number;
        }
    }
}

