/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import xtc.Constants;
import xtc.Limits;
import xtc.tree.Attribute;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Token;
import xtc.tree.Visitor;
import xtc.type.AliasT;
import xtc.type.ArrayT;
import xtc.type.BooleanT;
import xtc.type.C;
import xtc.type.CastReference;
import xtc.type.Constant;
import xtc.type.DynamicReference;
import xtc.type.EnumT;
import xtc.type.EnumeratorT;
import xtc.type.ErrorT;
import xtc.type.FieldReference;
import xtc.type.FunctionOrMethodT;
import xtc.type.FunctionT;
import xtc.type.InternalT;
import xtc.type.LabelT;
import xtc.type.NullReference;
import xtc.type.NumberT;
import xtc.type.PointerT;
import xtc.type.Reference;
import xtc.type.StaticReference;
import xtc.type.StringReference;
import xtc.type.StructT;
import xtc.type.Tagged;
import xtc.type.Type;
import xtc.type.UnionT;
import xtc.type.VariableT;
import xtc.type.VoidT;
import xtc.util.Runtime;
import xtc.util.SingletonIterator;
import xtc.util.SymbolTable;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CAnalyzer
extends Visitor {
    protected static final String MARKED = "marked";
    protected static final String EXTERN_SCOPE = "extern";
    protected static final String TMP_SCOPE = "tmp";
    protected static final String EXTERN_PATH = ".extern";
    protected final C cops;
    protected final Runtime runtime;
    protected final boolean pedantic;
    protected SymbolTable table;
    protected boolean isTopLevel;
    protected boolean hasScope;
    protected List<Boolean> loops;
    protected List<Boolean> switches;
    protected boolean isStmtAsExpr;
    protected List<CompletenessCheck> checks;
    private Visitor checkUsedLabelsVisitor = new Visitor(){

        private void check(String string, GNode gNode) {
            Type type2;
            String string2 = SymbolTable.toLabelName(string);
            SymbolTable.Scope scope = CAnalyzer.this.table.current();
            while (!CAnalyzer.isFunctionScope(scope.getName())) {
                type2 = (Type)scope.lookupLocally(string2);
                if (null != type2) {
                    assert (type2.resolve().isLabel()) : "Malformed label type";
                    if (type2.hasAttribute(Constants.ATT_UNINITIALIZED)) {
                        CAnalyzer.this.runtime.error("label '" + string + "' used but not defined", gNode);
                    }
                    type2.addAttribute(Constants.ATT_USED);
                    return;
                }
                scope = scope.getParent();
            }
            type2 = (Type)scope.lookupLocally(string2);
            if (null == type2) {
                CAnalyzer.this.runtime.error("label '" + string + "' used but not defined", gNode);
            } else {
                if (type2.hasAttribute(Constants.ATT_UNINITIALIZED)) {
                    CAnalyzer.this.runtime.error("label '" + string + "' used but not defined", gNode);
                }
                type2.addAttribute(Constants.ATT_USED);
            }
        }

        public void visitGotoStatement(GNode gNode) {
            if (null == gNode.get(0)) {
                this.check(gNode.getGeneric(1).getString(0), gNode);
            }
        }

        public void visitLabelAddressExpression(GNode gNode) {
            this.check(gNode.getString(0), gNode);
        }

        public void visit(GNode gNode) {
            CAnalyzer.this.table.enter(gNode);
            for (Object object : gNode) {
                if (!(object instanceof Node)) continue;
                this.dispatch((Node)object);
            }
            CAnalyzer.this.table.exit(gNode);
        }
    };
    private static final Visitor getDeclaredIdVisitor = new Visitor(){

        public Object visitAttributedDeclarator(GNode gNode) {
            return this.dispatch(gNode.getGeneric(1));
        }

        public Object visitPointerDeclarator(GNode gNode) {
            return this.dispatch(gNode.getGeneric(1));
        }

        public Object visitFunctionDeclarator(GNode gNode) {
            return this.dispatch(gNode.getGeneric(0));
        }

        public Object visitArrayDeclarator(GNode gNode) {
            return this.dispatch(gNode.getGeneric(0));
        }

        public Object visitSimpleDeclarator(GNode gNode) {
            return gNode;
        }

        public Object visitAttributedAbstractDeclarator(GNode gNode) {
            return null;
        }

        public Object visitAbstractDeclarator(GNode gNode) {
            return null;
        }

        public Object visitDirectAbstractDeclarator(GNode gNode) {
            return null;
        }
    };
    private static final Visitor getFunctionDeclaratorVisitor = new Visitor(){

        public Object visitAttributedDeclarator(GNode gNode) {
            return this.dispatch(gNode.getGeneric(1));
        }

        public Object visitPointerDeclarator(GNode gNode) {
            return this.dispatch(gNode.getGeneric(1));
        }

        public Object visitFunctionDeclarator(GNode gNode) {
            Object object = this.dispatch(gNode.getGeneric(0));
            return null == object ? gNode : object;
        }

        public Object visitArrayDeclarator(GNode gNode) {
            return this.dispatch(gNode.getGeneric(0));
        }

        public Object visitSimpleDeclarator(GNode gNode) {
            return null;
        }
    };

    public CAnalyzer(Runtime runtime) {
        this(new C(), runtime);
    }

    public CAnalyzer(C c, Runtime runtime) {
        this.cops = c;
        this.runtime = runtime;
        this.pedantic = runtime.test("optionPedantic");
        this.loops = new ArrayList<Boolean>();
        this.switches = new ArrayList<Boolean>();
        this.checks = new ArrayList<CompletenessCheck>();
    }

    public SymbolTable analyze(Node node) {
        return this.analyze(node, new SymbolTable());
    }

    public SymbolTable analyze(Node node, SymbolTable symbolTable) {
        this.table = symbolTable;
        this.isTopLevel = true;
        this.isStmtAsExpr = false;
        this.loops.clear();
        this.switches.clear();
        this.checks.clear();
        this.dispatch(node);
        return symbolTable;
    }

    public C c() {
        return this.cops;
    }

    public void visitTranslationUnit(GNode gNode) {
        for (Object object : gNode) {
            this.dispatch((Node)object);
        }
        for (CompletenessCheck completenessCheck : this.checks) {
            if (!this.c().isIncomplete(completenessCheck.type)) continue;
            this.runtime.error("storage size of '" + completenessCheck.name + "' isn't known", completenessCheck.node);
        }
    }

    public void visitDeclaration(GNode gNode) {
        GNode gNode2 = gNode.getGeneric(1);
        Specifiers specifiers = this.newSpecifiers(gNode2, null == gNode.get(2));
        GNode gNode3 = gNode.getGeneric(2);
        if (null == gNode3) {
            if (specifiers.contains(Constants.ATT_INLINE)) {
                this.runtime.error("'inline' in empty declaration", gNode);
            }
            if (null != specifiers.getStorageClass()) {
                this.runtime.warning("useless storage class specifier in empty declaration", gNode);
            }
            if (specifiers.contains(Constants.ATT_VOLATILE) || specifiers.contains(Constants.ATT_CONSTANT) || specifiers.contains(Constants.ATT_RESTRICT)) {
                this.runtime.warning("useless type qualifier in empty declaration", gNode);
            }
            if (!specifiers.getBaseType().hasError() && !specifiers.getBaseType().hasTagged()) {
                this.runtime.warning("empty declaration", gNode);
            }
        } else {
            for (Object object : gNode3) {
                Type type2;
                Type type3;
                Type type4;
                GNode gNode4 = GNode.cast(object);
                GNode gNode5 = gNode4.getGeneric(1);
                GNode gNode6 = CAnalyzer.getDeclaredId(gNode5);
                String string = gNode6.getString(0);
                Type type5 = this.getDeclaredType(specifiers.getBaseType(), gNode5);
                GNode gNode7 = gNode4.getGeneric(4);
                if (specifiers.contains(Constants.ATT_STORAGE_TYPEDEF)) {
                    if (specifiers.contains(Constants.ATT_INLINE)) {
                        this.runtime.error("typedef '" + string + "' is declared 'inline'", CAnalyzer.getSpecifier("FunctionSpecifier", gNode2));
                    }
                    if (null != gNode7) {
                        this.runtime.error("typedef '" + string + "' is initialized", gNode4);
                    }
                    this.checkType(gNode4, string, type5);
                    if (this.table.current().isDefinedLocally(string)) {
                        Type type6 = (Type)this.table.current().lookupLocally(string);
                        if (type6.isAlias()) {
                            this.runtime.error("redefinition of typedef '" + string + "'", gNode4);
                        } else {
                            this.runtime.error("'" + string + "' redeclared as different kind of symbol", gNode4);
                        }
                        this.reportPrevious(string, type6);
                        continue;
                    }
                    this.table.current().define(string, new AliasT(string, type5).locate(gNode).seal());
                    continue;
                }
                boolean bl = true;
                boolean bl2 = false;
                boolean bl3 = false;
                type5 = specifiers.annotateFull(type5.annotate());
                type5 = type5.attribute(this.toAttributeList(gNode4.getGeneric(0)));
                type5 = type5.attribute(this.toAttributeList(gNode4.getGeneric(3)));
                this.checkType(gNode4, string, type5);
                Type type7 = type5.resolve();
                if (type7.isFunction()) {
                    type4 = type7.toFunction();
                    if (type4.hasAttribute(Constants.ATT_STORAGE_AUTO) || type4.hasAttribute(Constants.ATT_STORAGE_REGISTER)) {
                        this.runtime.error("invalid storage class for function '" + string + "'", gNode4);
                    }
                    if (type5.hasAttribute(Constants.ATT_STYLE_OLD) && !((FunctionOrMethodT)type4).getParameters().isEmpty()) {
                        this.runtime.warning("parameter names (without types) in function declaration", gNode4);
                        ((FunctionOrMethodT)type4).getParameters().clear();
                    }
                    if (null != gNode7) {
                        this.runtime.error("function '" + string + "' is initialized like a " + "variable", gNode4);
                    }
                } else if (type5.hasAttribute(Constants.ATT_INLINE)) {
                    this.runtime.warning("variable '" + string + "' declared 'inline'", CAnalyzer.getSpecifier("FunctionSpecifier", gNode2));
                    type5.removeAttribute(Constants.ATT_INLINE);
                }
                if (this.isTopLevel) {
                    if (!type7.isFunction()) {
                        if (type5.hasAttribute(Constants.ATT_STORAGE_AUTO)) {
                            this.runtime.error("file-scope declaration of '" + string + "' specifies 'auto'", CAnalyzer.getSpecifier("AutoSpecifier", gNode2));
                        } else if (type5.hasAttribute(Constants.ATT_STORAGE_REGISTER) && (this.pedantic || null == gNode4.get(2))) {
                            this.runtime.error("file-scope declaration of '" + string + "' specifies 'register'", CAnalyzer.getSpecifier("RegisterSpecifier", gNode2));
                        }
                    }
                    type4 = this.lookupExtern(string);
                    boolean bl4 = this.table.current().isDefinedLocally(string);
                    if (null != type4 || bl4) {
                        type3 = bl4 ? (Type)this.table.current().lookupLocally(string) : type4;
                        type2 = this.compose(gNode4, string, type5, type3, false);
                        if (type2.isError()) {
                            bl = null != type4;
                        } else if (null != gNode7 && type3.hasAttribute(Constants.ATT_DEFINED)) {
                            this.runtime.error("redefinition of '" + string + "'", gNode4);
                            this.reportPrevious(string, type3);
                            bl = null != type4;
                        } else if (!type7.isFunction() && type3.hasAttribute(Constants.ATT_STORAGE_STATIC) && !type5.hasAttribute(Constants.ATT_STORAGE_STATIC) && !type5.hasAttribute(Constants.ATT_STORAGE_EXTERN)) {
                            this.runtime.error("non-static declaration of '" + string + "' follows static declaration", gNode4);
                            this.reportPrevious(string, type3);
                            bl = null != type4;
                        } else if (!type3.hasAttribute(Constants.ATT_MACRO) && !type3.hasAttribute(Constants.ATT_STORAGE_STATIC) && type5.hasAttribute(Constants.ATT_STORAGE_STATIC)) {
                            this.runtime.error("static declaration of '" + string + "' follows non-static declaration", gNode4);
                            this.reportPrevious(string, type3);
                            bl = null != type4;
                        } else if (type3.hasAttribute(Constants.ATT_MACRO) || type3.hasAttribute(Constants.ATT_DEFINED)) {
                            bl = null != type4;
                        } else {
                            type2 = type2.annotate();
                            if (type7.isFunction()) {
                                if ((type3.hasAttribute(Constants.ATT_INLINE) || type5.hasAttribute(Constants.ATT_INLINE)) && !type2.hasAttribute(Constants.ATT_INLINE)) {
                                    type2 = type2.attribute(Constants.ATT_INLINE);
                                }
                                if ((type3.hasAttribute(Constants.ATT_STORAGE_STATIC) || type5.hasAttribute(Constants.ATT_STORAGE_STATIC)) && !type2.hasAttribute(Constants.ATT_STORAGE_STATIC)) {
                                    type2 = type2.attribute(Constants.ATT_STORAGE_STATIC);
                                }
                            }
                            if (!type2.hasShape()) {
                                type2 = type2.shape(type3.getShape());
                            }
                            type5 = type2 = type2.locate(gNode);
                            type7 = type5.resolve();
                        }
                    } else {
                        type5 = type5.shape(true, string);
                        type5 = type5.locate(gNode);
                    }
                } else if (type5.hasAttribute(Constants.ATT_STORAGE_EXTERN) || type7.isFunction()) {
                    if (type7.isFunction()) {
                        if (type5.hasAttribute(Constants.ATT_STORAGE_AUTO) || type5.hasAttribute(Constants.ATT_STORAGE_REGISTER) || type5.hasAttribute(Constants.ATT_STORAGE_STATIC)) {
                            this.runtime.error("invalid storage class for function '" + string + "'", gNode4);
                            type5.removeAttribute(type5.getAttribute("storage"));
                        }
                        type5 = type5.attribute(Constants.ATT_STORAGE_EXTERN);
                    }
                    type4 = (Type)this.table.current().lookupLocally(string);
                    Type type8 = (Type)this.table.root().lookupLocally(string);
                    type3 = this.lookupExtern(string);
                    if (null != type4 || null != type8 || null != type3) {
                        type2 = null != type4 ? type4 : (null != type8 ? type8 : type3);
                        Type type9 = this.compose(gNode4, string, type5, type2, false);
                        if (type9.isError()) {
                            bl = false;
                        } else if (null != type4 && !type2.resolve().isFunction() && !type2.hasAttribute(Constants.ATT_STORAGE_EXTERN)) {
                            this.runtime.error("extern declaration of '" + string + "' follows " + "declaration with no linkage", gNode4);
                            this.reportPrevious(string, type2);
                            bl = false;
                        } else if (type2.hasAttribute(Constants.ATT_STORAGE_STATIC) && type2 != this.table.current().getParent().lookup(string)) {
                            this.runtime.error("variable previously declared 'static' redeclared 'extern'", gNode4);
                            this.reportPrevious(string, type2);
                        } else if (type2.hasAttribute(Constants.ATT_MACRO) || type2.hasAttribute(Constants.ATT_DEFINED)) {
                            type5 = type2;
                            type7 = type5.resolve();
                            bl = null == type4;
                        } else {
                            type9 = type9.annotate();
                            if (type7.isFunction()) {
                                if ((type2.hasAttribute(Constants.ATT_INLINE) || type5.hasAttribute(Constants.ATT_INLINE)) && !type9.hasAttribute(Constants.ATT_INLINE)) {
                                    type9 = type9.attribute(Constants.ATT_INLINE);
                                }
                                if ((type2.hasAttribute(Constants.ATT_STORAGE_STATIC) || type5.hasAttribute(Constants.ATT_STORAGE_STATIC)) && !type9.hasAttribute(Constants.ATT_STORAGE_STATIC)) {
                                    type9 = type9.attribute(Constants.ATT_STORAGE_STATIC);
                                }
                            }
                            if (!type9.hasShape()) {
                                type9 = type9.shape(type2.getShape());
                            }
                            type5 = type9 = type9.locate(gNode);
                            type7 = type5.resolve();
                            bl2 = null != type8;
                            bl3 = null != type3;
                        }
                    } else {
                        type5 = type5.shape(true, string);
                        type5 = type5.locate(gNode);
                        bl3 = true;
                    }
                } else if (this.table.current().isDefinedLocally(string)) {
                    type4 = (Type)this.table.current().lookupLocally(string);
                    Type type10 = this.compose(gNode4, string, type5, type4, false);
                    if (type10.isError()) {
                        bl = false;
                    } else if (type4.hasAttribute(Constants.ATT_STORAGE_EXTERN)) {
                        this.runtime.error("declaration of '" + string + "' with no " + "linkage follows extern declaration", gNode4);
                        this.reportPrevious(string, type4);
                        bl = false;
                    } else {
                        this.runtime.error("redeclaration of '" + string + "' with no linkage", gNode4);
                        this.reportPrevious(string, type4);
                        bl = false;
                    }
                } else {
                    if (!type5.hasAttribute("storage")) {
                        type5 = type5.attribute(Constants.ATT_STORAGE_AUTO);
                    }
                    type5 = type5.shape(type5.hasAttribute(Constants.ATT_STORAGE_STATIC), string);
                    type5 = type5.locate(gNode);
                }
                boolean bl5 = false;
                if (!type5.hasAttribute(Constants.ATT_STORAGE_EXTERN) || null != gNode7) {
                    if (type7.isArray()) {
                        Type type11 = type7.toArray().getType();
                        if (this.c().isIncomplete(type11) || this.pedantic && this.c().hasTrailingArray(type11)) {
                            this.runtime.error("array type has incomplete element type", gNode4);
                            bl5 = true;
                        }
                    } else if (this.c().isIncomplete(type5)) {
                        if (null == gNode7) {
                            if (this.isTopLevel && type5.hasTagged() && null == type5.toTagged().getMembers()) {
                                this.checks.add(new CompletenessCheck(type5, string, gNode4));
                            } else if (type7.isVoid()) {
                                this.runtime.error("variable '" + string + "' declared void", gNode4);
                            } else {
                                this.runtime.error("storage size of '" + string + "' isn't known", gNode4);
                            }
                        } else {
                            this.runtime.error("variable '" + string + "' has initializer but " + "incomplete type", gNode4);
                        }
                        bl5 = true;
                    }
                }
                if (null != gNode7 && !type7.isFunction()) {
                    if (type5.hasAttribute(Constants.ATT_STORAGE_EXTERN)) {
                        if (this.isTopLevel) {
                            this.runtime.warning("'" + string + "' initialized and declared 'extern'", gNode4);
                            type5 = type5.attribute(Constants.ATT_DEFINED);
                        } else {
                            this.runtime.error("'" + string + "' has both 'extern' and initializer", gNode4);
                        }
                    } else {
                        type5 = type5.attribute(Constants.ATT_DEFINED);
                    }
                    if (!bl5) {
                        if (bl) {
                            this.table.current().define(string, type5);
                        }
                        type5 = this.processInitializer(gNode4, string, type5, gNode7);
                    }
                }
                if (bl) {
                    this.table.current().define(string, type5);
                }
                if (bl2) {
                    this.table.root().define(string, type5);
                }
                if (!bl3) continue;
                this.defineExtern(string, type5);
            }
        }
    }

    protected Type processInitializer(GNode gNode, String string, Type type2, GNode gNode2) {
        boolean bl;
        if (type2.hasError()) {
            return type2;
        }
        string = null == string ? "initializer" : "initializer for '" + string + "'";
        boolean bl2 = bl = type2.hasAttribute(Constants.ATT_STORAGE_AUTO) || type2.hasAttribute(Constants.ATT_STORAGE_REGISTER);
        if (gNode2.hasName("InitializerList")) {
            if ((this.c().isString(type2) || this.c().isWideString(type2)) && 0 < gNode2.size() && null == gNode2.getGeneric(0).get(0) && !gNode2.getGeneric(0).getGeneric(1).hasName("InitializerList")) {
                Type type3 = (Type)this.dispatch(gNode2.getGeneric(0).getGeneric(1));
                if (this.c().isStringLiteral(type3)) {
                    if (1 < gNode2.size()) {
                        if (this.c().isString(type2)) {
                            this.runtime.error("excess elements in char array initializer", gNode2);
                        } else {
                            this.runtime.error("excess elements in wchar_t array initializer", gNode2);
                        }
                        return type2;
                    }
                    this.processAssignment(true, string, gNode2, type2, type3);
                    return this.processStringSize(gNode2, string, false, type2, type3);
                }
                if (this.runtime.test("optionMarkAST")) {
                    gNode2.getGeneric(0).getGeneric(1).setProperty(MARKED, Boolean.TRUE);
                }
            }
            return new Initializer(gNode2, type2, bl).process();
        }
        Type type4 = (Type)this.dispatch(gNode2);
        if (!(bl || type4.hasConstant() || this.c().hasConstRef(type4))) {
            this.runtime.error(string + " is not constant", gNode);
        }
        this.processAssignment(true, string, gNode2, type2, type4);
        return this.processStringSize(gNode2, string, false, type2, type4);
    }

    protected Type processStringSize(GNode gNode, String string, boolean bl, Type type2, Type type3) {
        if ((this.c().isString(type2) && this.c().isString(type3) || this.c().isWideString(type2) && this.c().isWideString(type3)) && type3.hasConstant()) {
            ArrayT arrayT = type2.resolve().toArray();
            if (!(arrayT.isVarLength() || arrayT.hasLength() || bl)) {
                type2 = type2.copy();
                type2.resolve().toArray().setLength(type3.resolve().toArray().getLength());
            } else if (arrayT.hasLength() && arrayT.getLength() < type3.resolve().toArray().getLength()) {
                this.runtime.warning("string literal in " + string + " is too long", gNode);
            }
        }
        return type2;
    }

    public void visitFunctionDefinition(GNode gNode) {
        Object object;
        GNode gNode2 = gNode.getGeneric(1);
        GNode gNode3 = gNode.getGeneric(2);
        GNode gNode4 = CAnalyzer.getDeclaredId(gNode3);
        String string = gNode4.getString(0);
        Specifiers specifiers = this.newSpecifiers(gNode2, false);
        Type type2 = this.getDeclaredType(specifiers.getBaseType(), gNode3);
        if (!(type2 = specifiers.annotateFull(type2)).resolve().isFunction()) {
            this.runtime.error("function definition without function declarator", gNode3);
            return;
        }
        if (type2.hasAttribute(Constants.ATT_STORAGE_AUTO)) {
            this.runtime.error("function definition declared 'auto'", gNode);
        } else if (type2.hasAttribute(Constants.ATT_STORAGE_REGISTER)) {
            this.runtime.error("function definition declared 'register'", gNode);
        } else if (type2.hasAttribute(Constants.ATT_STORAGE_TYPEDEF)) {
            this.runtime.error("function definition declared 'typedef'", gNode);
        }
        this.checkType(gNode, string, type2);
        boolean bl = !this.pedantic && type2.hasAttribute(Constants.ATT_STORAGE_EXTERN) && type2.hasAttribute(Constants.ATT_INLINE);
        boolean bl2 = true;
        Type type3 = this.lookupExtern(string);
        boolean bl3 = this.table.current().isDefinedLocally(string);
        if (null != type3 || bl3) {
            object = bl3 ? (Type)this.table.current().lookupLocally(string) : type3;
            Type type4 = this.compose(gNode, string, type2, (Type)object, true);
            if (type4.isError()) {
                bl2 = null != type3;
            } else if (((Type)object).hasAttribute(Constants.ATT_DEFINED) || bl && ((Type)object).hasAttribute(Constants.ATT_MACRO)) {
                this.runtime.error("redefinition of '" + string + "'", gNode);
                this.reportPrevious(string, (Type)object);
                bl2 = null != type3;
            } else if (!((Type)object).hasAttribute(Constants.ATT_MACRO) && !((Type)object).hasAttribute(Constants.ATT_STORAGE_STATIC) && type2.hasAttribute(Constants.ATT_STORAGE_STATIC)) {
                this.runtime.error("static declaration of '" + string + "' follows non-static declaration", gNode);
                this.reportPrevious(string, (Type)object);
                bl2 = null != type3;
            } else {
                type2 = type4;
                if (!((Type)object).hasAttribute(Constants.ATT_MACRO) && ((Type)object).hasAttribute(Constants.ATT_INLINE) && !type2.hasAttribute(Constants.ATT_INLINE)) {
                    type2 = type2.annotate().attribute(Constants.ATT_INLINE);
                }
                if (((Type)object).hasAttribute(Constants.ATT_STORAGE_STATIC) && !type2.hasAttribute(Constants.ATT_STORAGE_STATIC)) {
                    type2 = type2.annotate().attribute(Constants.ATT_STORAGE_STATIC);
                }
            }
            type2 = type2.annotate();
            if (type2.resolve().isSealed()) {
                type2 = bl ? type2.attribute(Constants.ATT_MACRO) : type2.attribute(Constants.ATT_DEFINED);
            } else if (bl) {
                type2.resolve().addAttribute(Constants.ATT_MACRO);
            } else {
                type2.resolve().addAttribute(Constants.ATT_DEFINED);
            }
            if (!type2.hasShape()) {
                type2 = type2.shape(true, string);
            }
            type2 = type2.locate(gNode);
        } else {
            if (bl) {
                type2.resolve().addAttribute(Constants.ATT_MACRO);
            } else {
                type2.resolve().addAttribute(Constants.ATT_DEFINED);
            }
            type2 = type2.annotate().shape(true, string).locate(gNode);
        }
        if (bl2) {
            this.table.current().define(string, type2);
        }
        if ("main".equals(string) && type2.resolve().isFunction() && !NumberT.INT.equals(type2.resolve().toFunction().getResult())) {
            this.runtime.warning("return type of 'main' is not 'int'", gNode);
        }
        object = bl ? SymbolTable.toMacroScopeName(string) : SymbolTable.toFunctionScopeName(string);
        this.table.enter((String)object);
        this.table.mark(gNode);
        this.table.current().define("__func__", CAnalyzer.toFuncType(string));
        this.processParameters(gNode, type2.resolve().toFunction());
        boolean bl4 = this.isTopLevel;
        this.isTopLevel = false;
        boolean bl5 = this.hasScope;
        this.hasScope = false;
        this.dispatch(gNode.getNode(4));
        this.isTopLevel = bl4;
        this.hasScope = bl5;
        this.table.exit();
        if (this.isTopLevel) {
            this.checkUsedLabels(gNode);
            this.checkDefinedLabels(gNode);
        }
    }

    public static Type toFuncType(String string) {
        Type type2 = NumberT.CHAR.annotate().attribute(Constants.ATT_CONSTANT);
        Type type3 = new ArrayT(type2, string.length()).annotate().attribute(Constants.ATT_STORAGE_STATIC).shape(true, "__func__").seal();
        return type3;
    }

    /*
     * WARNING - void declaration
     */
    protected void processParameters(GNode gNode, FunctionT functionT) {
        block38: {
            GNode gNode2;
            block37: {
                Object object;
                Node node;
                Node node2;
                Object object2;
                Object object3;
                gNode2 = CAnalyzer.getFunctionDeclarator(gNode.getGeneric(2)).getGeneric(1);
                if (null != gNode2 && !gNode2.hasName("IdentifierList")) break block37;
                HashSet<String> hashSet = new HashSet<String>();
                if (null != gNode2) {
                    object3 = gNode2.iterator();
                    while (object3.hasNext()) {
                        object2 = object3.next();
                        hashSet.add((String)object2);
                    }
                }
                if (null != (object3 = gNode.getGeneric(3))) {
                    object2 = ((Node)object3).iterator();
                    while (object2.hasNext()) {
                        Object object4 = object2.next();
                        node2 = GNode.cast(object4);
                        node = node2.getGeneric(1);
                        object = this.newSpecifiers((GNode)node, null == node2.get(2));
                        if (null == node2.get(2)) {
                            this.runtime.warning("empty declaration", node2);
                            continue;
                        }
                        for (Object object5 : node2.getGeneric(2)) {
                            GNode gNode3 = GNode.cast(object5);
                            GNode gNode4 = gNode3.getGeneric(1);
                            GNode gNode5 = CAnalyzer.getDeclaredId(gNode4);
                            String string = gNode5.getString(0);
                            Type type2 = this.getDeclaredType(true, ((Specifiers)object).getBaseType(), gNode4);
                            this.checkType((GNode)node2, string, type2);
                            switch (type2.tag()) {
                                case ARRAY: {
                                    type2 = this.c().qualify(new PointerT(type2.resolve().toArray().getType()), type2);
                                    break;
                                }
                                case FUNCTION: {
                                    type2 = this.c().qualify(new PointerT(type2.resolve()), type2);
                                }
                            }
                            type2 = ((Specifiers)object).annotateFull(VariableT.newParam(type2, string)).attribute(this.toAttributeList(gNode3.getGeneric(0))).attribute(this.toAttributeList(gNode3.getGeneric(3))).shape(false, string);
                            if (type2.hasAttribute("storage") && !type2.hasAttribute(Constants.ATT_STORAGE_REGISTER)) {
                                this.runtime.error("storage class specified for parameter '" + string + "'", node2);
                            } else if (!type2.hasAttribute("storage")) {
                                type2 = type2.attribute(Constants.ATT_STORAGE_AUTO);
                            }
                            if (null != gNode3.get(4)) {
                                this.runtime.error("parameter '" + string + "' is initialized", gNode3.getNode(4));
                            }
                            if (this.c().isIncomplete(type2)) {
                                if (type2.resolve().isVoid()) {
                                    this.runtime.error("parameter '" + string + "' declared void", node2);
                                } else {
                                    this.runtime.error("parameter '" + string + "' has incomplete type", node2);
                                }
                            }
                            if (!hashSet.contains(string)) {
                                this.runtime.error("declaration for parameter '" + string + "' but no such parameter", node2);
                                continue;
                            }
                            if (this.table.current().isDefinedLocally(string)) {
                                this.runtime.error("redefinition of parameter '" + string + "'", node2);
                                continue;
                            }
                            this.table.current().define(string, type2);
                        }
                    }
                }
                for (String i : hashSet) {
                    if (this.table.current().isDefinedLocally(i)) continue;
                    node2 = VariableT.newParam(C.IMPLICIT, i).attribute(Constants.ATT_STORAGE_AUTO).shape(false, i);
                    this.table.current().define(i, node2);
                    if (!this.pedantic) continue;
                    this.runtime.warning("type of '" + i + "' defaults to 'int'", gNode);
                }
                if (functionT.hasAttribute(Constants.ATT_STYLE_OLD)) {
                    object2 = functionT.getParameters();
                    int type3 = object2.size();
                    for (int i = 0; i < type3; ++i) {
                        node = (Type)object2.get(i);
                        if (((Type)node).hasError()) continue;
                        object = ((Type)node).toVariable().getName();
                        if (!this.table.current().isDefinedLocally((String)object)) continue;
                        object2.set(i, (Type)this.table.current().lookupLocally((String)object));
                    }
                } else {
                    if (null == gNode2) {
                        gNode2 = GNode.create("IdentifierList", false);
                    }
                    if (gNode2.size() != functionT.getParameters().size()) {
                        this.runtime.error("number of arguments doesn't match prototype", gNode);
                    } else {
                        void var7_16;
                        int n = gNode2.size();
                        boolean bl = false;
                        while (var7_16 < n) {
                            node2 = (Type)this.table.current().lookupLocally((String)gNode2.get((int)var7_16));
                            node = functionT.getParameters().get((int)var7_16);
                            if (!((Type)node2).hasError() && !((Type)node).hasError()) {
                                if (this.c().compose((Type)node, this.c().promoteArgument((Type)node2), this.pedantic).isError()) {
                                    this.runtime.error("argument '" + ((Type)node2).toVariable().getName() + "' doesn't match prototype", gNode);
                                } else if (this.pedantic && !this.c().hasSameQualifiers((Type)node, (Type)node2)) {
                                    this.runtime.error("type qualifiers of argument '" + ((Type)node2).toVariable().getName() + "' don't match prototype", gNode);
                                }
                            }
                            ++var7_16;
                        }
                    }
                }
                break block38;
            }
            if (null != gNode.get(3)) {
                this.runtime.error("old-style parameter declarations in prototyped function definition", gNode.getNode(3));
            }
            if (this.isVoidParameterTypeList(gNode2)) break block38;
            gNode2 = gNode2.getGeneric(0);
            Iterator<Object> iterator = gNode2.iterator();
            Iterator<Type> iterator2 = functionT.getParameters().iterator();
            while (iterator.hasNext()) {
                String string;
                GNode gNode6 = GNode.cast(iterator.next());
                Type type3 = iterator2.next();
                String string2 = string = type3.hasVariable() ? type3.toVariable().getName() : null;
                if (this.c().isIncomplete(type3)) {
                    if (null == string) {
                        this.runtime.error("unnamed parameter has incomplete type", gNode6);
                    } else {
                        this.runtime.error("parameter '" + string + "' has incomplete type", gNode6);
                    }
                }
                if (null == string) {
                    if (type3.hasError()) continue;
                    this.runtime.error("parameter name omitted", gNode6);
                    continue;
                }
                if (this.table.current().isDefinedLocally(string)) continue;
                this.table.current().define(string, type3);
            }
        }
    }

    protected void checkUsedLabels(GNode gNode) {
        this.checkUsedLabelsVisitor.dispatch(gNode);
    }

    protected void checkDefinedLabels(GNode gNode) {
        Visitor visitor = new Visitor(){
            final Map<Type, Type> checkedDefined = new IdentityHashMap<Type, Type>();
            final Map<Type, Type> checkedUsed = new IdentityHashMap<Type, Type>();

            public void visitNamedLabel(GNode gNode) {
                String string = gNode.getString(0);
                String string2 = SymbolTable.toLabelName(string);
                Type type2 = (Type)CAnalyzer.this.table.current().lookup(string2);
                if (null != type2 && !this.checkedUsed.containsKey(type2)) {
                    this.checkedUsed.put(type2, type2);
                    if (!type2.hasAttribute(Constants.ATT_USED)) {
                        CAnalyzer.this.runtime.warning("label '" + string + "' defined but not used", gNode);
                    }
                }
            }

            public void visitLocalLabelDeclaration(GNode gNode) {
                for (Object object : gNode) {
                    String string = Token.cast(object);
                    String string2 = SymbolTable.toLabelName(string);
                    Type type2 = (Type)CAnalyzer.this.table.current().lookup(string2);
                    if (null == type2 || this.checkedDefined.containsKey(type2)) continue;
                    this.checkedDefined.put(type2, type2);
                    if (!type2.hasAttribute(Constants.ATT_UNINITIALIZED) || type2.hasAttribute(Constants.ATT_USED)) continue;
                    CAnalyzer.this.runtime.warning("label '" + string + "' declared but not defined", gNode);
                }
            }

            public void visit(GNode gNode) {
                CAnalyzer.this.table.enter(gNode);
                for (Object object : gNode) {
                    if (!(object instanceof Node)) continue;
                    this.dispatch((Node)object);
                }
                CAnalyzer.this.table.exit(gNode);
            }
        };
        visitor.dispatch(gNode);
    }

    public Type visitLabeledStatement(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        Object object = this.dispatch(gNode.getNode(1));
        Type type2 = object instanceof Type ? (Type)object : VoidT.TYPE;
        this.mark(gNode, type2);
        return type2;
    }

    public void visitNamedLabel(GNode gNode) {
        Type type2;
        String string = gNode.getString(0);
        String string2 = SymbolTable.toLabelName(string);
        List<Attribute> list = this.toAttributeList(gNode.getGeneric(1));
        SymbolTable.Scope scope = this.table.current();
        while (!CAnalyzer.isFunctionScope(scope.getName())) {
            type2 = (Type)scope.lookupLocally(string2);
            if (null != type2) {
                assert (type2.isLabel()) : "Malformed label type";
                if (type2.hasAttribute(Constants.ATT_UNINITIALIZED)) {
                    scope.define(string2, new LabelT(string).locate(gNode).attribute(Constants.ATT_DEFINED).attribute(list));
                } else {
                    this.runtime.error("duplicate label '" + string + "'", gNode);
                    this.reportPrevious(string, type2);
                }
                return;
            }
            scope = scope.getParent();
        }
        type2 = (Type)scope.lookupLocally(string2);
        if (null != type2 && !type2.hasAttribute(Constants.ATT_UNINITIALIZED)) {
            this.runtime.error("duplicate label '" + string + "'", gNode);
            this.reportPrevious(string, (Type)scope.lookupLocally(string2));
        } else {
            scope.define(string2, new LabelT(string).locate(gNode).attribute(Constants.ATT_DEFINED).attribute(list));
        }
    }

    public void visitCaseLabel(GNode gNode) {
        if (0 == this.switches.size()) {
            this.runtime.error("case label not within a switch statement", gNode);
            return;
        }
        Node node = gNode.getNode(0);
        Type type2 = (Type)this.dispatch(node);
        Node node2 = 2 == gNode.size() ? gNode.getNode(1) : null;
        Type type3 = (Type)this.dispatch(node2);
        if (type2.isError() || null != type3 && type3.isError()) {
            return;
        }
        if (!this.c().isIntegral(type2) || null != type3 && !this.c().isIntegral(type3)) {
            this.runtime.error("case label not of integer type", gNode);
            return;
        }
        if (!type2.hasConstant() || null != type3 && !type3.hasConstant()) {
            this.runtime.error("case label not constant", gNode);
            return;
        }
        if (null != type3) {
            try {
                if (type3.getConstant().bigIntValue().compareTo(type3.getConstant().bigIntValue()) < 0) {
                    this.runtime.error("empty range in case label", gNode);
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.runtime.warning("can't compute range in case label", gNode);
            }
        }
    }

    public void visitDefaultLabel(GNode gNode) {
        if (0 == this.switches.size()) {
            this.runtime.error("'default' label not within a switch statement", gNode);
        } else if (this.switches.get(this.switches.size() - 1).booleanValue()) {
            this.runtime.error("multiple default labels in one switch", gNode);
        } else {
            this.switches.set(this.switches.size() - 1, Boolean.TRUE);
        }
    }

    public void visitLocalLabelDeclaration(GNode gNode) {
        for (Object object : gNode) {
            String string = Token.cast(object);
            String string2 = SymbolTable.toLabelName(string);
            if (this.table.current().isDefinedLocally(string2)) {
                this.runtime.error("duplicate label declaration '" + string + "'", gNode);
                this.reportPrevious(string, (Type)this.table.current().lookupLocally(string2));
                continue;
            }
            this.table.current().define(string2, new LabelT(string).locate(gNode).attribute(Constants.ATT_UNINITIALIZED));
        }
    }

    public Type visitCompoundStatement(GNode gNode) {
        Object object;
        boolean bl = this.hasScope;
        this.hasScope = true;
        boolean bl2 = this.isStmtAsExpr;
        this.isStmtAsExpr = false;
        if (bl || bl2) {
            object = this.table.freshName("block");
            this.table.enter((String)object);
            this.table.mark(gNode);
        }
        object = VoidT.TYPE;
        int n = gNode.size();
        for (int i = 0; i < n; ++i) {
            Object object2 = this.dispatch((Node)gNode.get(i));
            if (n - 2 != i || !(object2 instanceof Type)) continue;
            object = (Type)object2;
        }
        if (bl || bl2) {
            this.table.exit();
        }
        this.hasScope = bl;
        return bl2 ? object : VoidT.TYPE;
    }

    public void visitIfElseStatement(GNode gNode) {
        Node node = gNode.getNode(0);
        this.ensureScalar(node, this.c().pointerize((Type)this.dispatch(node)));
        this.dispatch(gNode.getNode(1));
        this.dispatch(gNode.getNode(2));
    }

    public void visitIfStatement(GNode gNode) {
        Node node = gNode.getNode(0);
        this.ensureScalar(node, this.c().pointerize((Type)this.dispatch(node)));
        this.dispatch(gNode.getNode(1));
    }

    public void visitWhileStatement(GNode gNode) {
        Node node = gNode.getNode(0);
        this.ensureScalar(node, this.c().pointerize((Type)this.dispatch(node)));
        this.loops.add(Boolean.TRUE);
        this.dispatch(gNode.getNode(1));
        this.loops.remove(this.loops.size() - 1);
    }

    public void visitDoStatement(GNode gNode) {
        this.loops.add(Boolean.TRUE);
        this.dispatch(gNode.getNode(0));
        this.loops.remove(this.loops.size() - 1);
        Node node = gNode.getNode(1);
        this.ensureScalar(node, this.c().pointerize((Type)this.dispatch(node)));
    }

    public void visitForStatement(GNode gNode) {
        boolean bl = this.hasScope;
        this.hasScope = false;
        String string = this.table.freshName("forloop");
        this.table.enter(string);
        this.table.mark(gNode);
        this.dispatch(gNode.getNode(0));
        if (null != gNode.get(1)) {
            Node node = gNode.getNode(1);
            this.ensureScalar(node, this.c().pointerize((Type)this.dispatch(node)));
        }
        this.dispatch(gNode.getNode(2));
        this.loops.add(Boolean.TRUE);
        this.dispatch(gNode.getNode(3));
        this.loops.remove(this.loops.size() - 1);
        this.table.exit();
        this.hasScope = bl;
    }

    public void visitSwitchStatement(GNode gNode) {
        Node node = gNode.getNode(0);
        this.ensureInteger(node, this.c().pointerize((Type)this.dispatch(node)));
        this.switches.add(Boolean.FALSE);
        this.dispatch(gNode.getNode(1));
        this.switches.remove(this.switches.size() - 1);
    }

    public void visitBreakStatement(GNode gNode) {
        if (0 == this.switches.size() && 0 == this.loops.size()) {
            this.runtime.error("break statement not within loop or switch", gNode);
        }
    }

    public void visitContinueStatement(GNode gNode) {
        if (0 == this.loops.size()) {
            this.runtime.error("continue statement not within a loop", gNode);
        }
    }

    public Type visitReturnStatement(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getNode(0));
        SymbolTable.Scope scope = this.table.current();
        while (!CAnalyzer.isFunctionScope(scope.getName())) {
            scope = scope.getParent();
        }
        String string = SymbolTable.fromNameSpace(scope.getName());
        Type type3 = (Type)scope.getParent().lookupLocally(string);
        Type type4 = type3.resolve().toFunction().getResult();
        if (type4.hasTag(Type.Tag.VOID)) {
            if (null != type2 && !type2.hasTag(Type.Tag.VOID)) {
                this.runtime.warning("'return' with a value, in function returning void", gNode);
            }
        } else if (null != type2) {
            this.processAssignment(false, "return", gNode, type4, type2);
        } else if (this.pedantic) {
            this.runtime.warning("'return' with no value, in function returning non-void", gNode);
        }
        this.mark(gNode, type4);
        return type4;
    }

    public void visitGotoStatement(GNode gNode) {
        Type type2;
        if (null == gNode.get(0)) {
            return;
        }
        Node node = gNode.getNode(1);
        if (this.ensureScalar(node, type2 = (Type)this.dispatch(node)) && type2.resolve().isFloat()) {
            this.runtime.error("cannot convert to pointer type", gNode);
        }
    }

    public Type visitExpressionStatement(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getNode(0));
        Type type3 = this.c().toRValue(type2);
        this.mark(gNode, type3);
        return type3;
    }

    public List visitExpressionList(GNode gNode) {
        ArrayList<Type> arrayList = new ArrayList<Type>(gNode.size());
        for (Object object : gNode) {
            arrayList.add((Type)this.dispatch((Node)object));
        }
        return arrayList;
    }

    public Type processExpression(Node node) {
        return (Type)this.dispatch(node);
    }

    public Type visitCommaExpression(GNode gNode) {
        this.dispatch(gNode.getNode(0));
        Type type2 = (Type)this.dispatch(gNode.getNode(1));
        Type type3 = this.c().pointerize(type2);
        Type type4 = this.c().toRValue(type3);
        this.mark(gNode, type4);
        return type4;
    }

    public Type visitAssignmentExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        String string = gNode.getString(1);
        Node node2 = gNode.getNode(2);
        Type type3 = (Type)this.dispatch(node);
        Type type4 = (Type)this.dispatch(node2);
        if (type3.hasError() || type4.hasError()) {
            type2 = ErrorT.TYPE;
        } else if ("=".equals(string)) {
            boolean bl = this.ensureLValue(node, type3);
            type2 = this.processAssignment(false, "assignment", gNode, type3, type4);
            if (!bl) {
                type2 = ErrorT.TYPE;
            }
        } else if ("+=".equals(string) || "-=".equals(string)) {
            Type type5 = type3.resolve();
            switch (type5.tag()) {
                case BOOLEAN: 
                case INTEGER: 
                case FLOAT: {
                    boolean bl = this.ensureLValue(node, type3);
                    boolean bl2 = this.ensureArithmetic(node2, type4);
                    type2 = bl && bl2 ? type5 : ErrorT.TYPE;
                    break;
                }
                case POINTER: {
                    boolean bl = this.ensureLValue(node, type3);
                    boolean bl3 = this.ensureInteger(node2, type4);
                    type2 = bl && bl3 ? type5 : ErrorT.TYPE;
                    break;
                }
                default: {
                    this.runtime.error("invalid " + CAnalyzer.toDescription(node) + " where scalar required", node);
                    type2 = ErrorT.TYPE;
                    break;
                }
            }
        } else if ("*=".equals(string) || "/=".equals(string)) {
            boolean bl = this.ensureArithmetic(node, type3) && this.ensureLValue(node, type3);
            boolean bl4 = this.ensureArithmetic(node2, type4);
            type2 = bl && bl4 ? type3.resolve() : ErrorT.TYPE;
        } else {
            boolean bl = this.ensureInteger(node, type3) && this.ensureLValue(node, type3);
            boolean bl5 = this.ensureInteger(node2, type4);
            type2 = bl && bl5 ? type3.resolve() : ErrorT.TYPE;
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitConditionalExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        Node node2 = gNode.getNode(1);
        Node node3 = gNode.getNode(2);
        Type type3 = (Type)this.dispatch(node);
        Type type4 = (Type)this.dispatch(node2);
        Type type5 = (Type)this.dispatch(node3);
        if (null == type4) {
            type4 = type3;
        }
        Type type6 = this.c().pointerize(type4);
        Type type7 = this.c().pointerize(type5);
        boolean bl = this.ensureScalar(node, this.c().pointerize(type3));
        if (type6.isError() || type7.isError()) {
            type2 = ErrorT.TYPE;
        } else if (this.c().isArithmetic(type4) && this.c().isArithmetic(type5)) {
            type2 = bl ? this.c().convert(type4, type5) : ErrorT.TYPE;
            type2 = this.valueConditional(type2, type3, type4, type5);
        } else if (type6.isStruct() && type7.isStruct() && this.c().equal(type4, type5) || type6.isUnion() && type7.isUnion() && this.c().equal(type4, type5)) {
            type2 = bl ? this.c().qualify(type6, type4) : ErrorT.TYPE;
        } else if (type6.isVoid() && type7.isVoid()) {
            type2 = bl ? VoidT.TYPE : ErrorT.TYPE;
        } else if (type6.isPointer() && type5.hasConstant() && type5.getConstant().isNull()) {
            type2 = bl ? this.c().qualify(type6, type4) : ErrorT.TYPE;
            type2 = this.valueConditional(type2, type3, type4, type5);
        } else if (type4.hasConstant() && type4.getConstant().isNull() && type7.isPointer()) {
            type2 = bl ? this.c().qualify(type7, type5) : ErrorT.TYPE;
            type2 = this.valueConditional(type2, type3, type4, type5);
        } else if (type6.isPointer() && type7.isPointer()) {
            Type type8 = type6.toPointer().getType();
            Type type9 = type7.toPointer().getType();
            Type type10 = type8.resolve();
            Type type11 = type9.resolve();
            if (type10.isError() || type11.isError()) {
                type2 = ErrorT.TYPE;
            } else if (this.c().equal(type10, type11)) {
                if (bl) {
                    type2 = new PointerT(this.c().qualify(this.c().qualify(type10, type8), type9));
                    type2 = this.c().qualify(this.c().qualify(type2, type4), type5);
                    type2 = this.valueConditional(type2, type3, type4, type5);
                } else {
                    type2 = ErrorT.TYPE;
                }
            } else if (type10.isVoid() || type11.isVoid()) {
                if (bl) {
                    type2 = new PointerT(this.c().qualify(this.c().qualify(VoidT.TYPE, type8), type9));
                    type2 = this.c().qualify(this.c().qualify(type2, type4), type5);
                    type2 = this.valueConditional(type2, type3, type4, type5);
                } else {
                    type2 = ErrorT.TYPE;
                }
            } else {
                this.runtime.error("pointer type mismatch in conditional expression", gNode);
                type2 = ErrorT.TYPE;
            }
        } else if (this.c().isIntegral(type4) && type7.isPointer() || type6.isPointer() && this.c().isIntegral(type5)) {
            this.runtime.error("pointer/integer type mismatch in conditional expression", gNode);
            type2 = ErrorT.TYPE;
        } else {
            this.runtime.error("type mismatch in conditional expression", gNode);
            type2 = ErrorT.TYPE;
        }
        this.mark(gNode, type2);
        return type2;
    }

    protected Type valueConditional(Type type2, Type type3, Type type4, Type type5) {
        if (type2.isError()) {
            return type2;
        }
        if (type3.hasConstant()) {
            Type type6;
            Type type7 = type6 = type3.getConstant().isTrue() ? type4 : type5;
            if (type6.hasConstant()) {
                type2 = type2.annotate().constant(type6.getConstant().getValue());
            }
        }
        return type2;
    }

    public Type visitLogicalOrExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        Node node2 = gNode.getNode(1);
        Type type3 = (Type)this.dispatch(node);
        Type type4 = (Type)this.dispatch(node2);
        boolean bl = this.ensureScalar(node, this.c().pointerize(type3));
        boolean bl2 = this.ensureScalar(node2, this.c().pointerize(type4));
        if (bl && bl2) {
            type2 = NumberT.INT;
            if (type3.hasConstant()) {
                if (type3.getConstant().isTrue()) {
                    type2 = type2.annotate().constant(true);
                } else if (type4.hasConstant()) {
                    type2 = type2.annotate().constant(type4.getConstant().isTrue());
                }
            }
        } else {
            type2 = ErrorT.TYPE;
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitLogicalAndExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        Node node2 = gNode.getNode(1);
        Type type3 = (Type)this.dispatch(node);
        Type type4 = (Type)this.dispatch(node2);
        boolean bl = this.ensureScalar(node, this.c().pointerize(type3));
        boolean bl2 = this.ensureScalar(node2, this.c().pointerize(type4));
        if (bl && bl2) {
            type2 = NumberT.INT;
            if (type3.hasConstant()) {
                if (!type3.getConstant().isTrue()) {
                    type2 = type2.annotate().constant(false);
                } else if (type4.hasConstant()) {
                    type2 = type2.annotate().constant(type4.getConstant().isTrue());
                }
            }
        } else {
            type2 = ErrorT.TYPE;
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitBitwiseOrExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        Node node2 = gNode.getNode(1);
        Type type3 = (Type)this.dispatch(node);
        Type type4 = (Type)this.dispatch(node2);
        boolean bl = this.ensureInteger(node, type3);
        boolean bl2 = this.ensureInteger(node2, type4);
        if (bl && bl2) {
            type2 = this.c().convert(type3, type4);
            if (type3.hasConstant() && type4.hasConstant()) {
                type2 = type2.annotate();
                try {
                    type2 = type2.constant(this.c().mask(type3.getConstant().bigIntValue(), type2).or(this.c().mask(type4.getConstant().bigIntValue(), type2)));
                }
                catch (IllegalStateException illegalStateException) {
                    type2 = type2.constant(new StaticReference(type2));
                }
            }
        } else {
            type2 = ErrorT.TYPE;
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitBitwiseXorExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        Node node2 = gNode.getNode(1);
        Type type3 = (Type)this.dispatch(node);
        Type type4 = (Type)this.dispatch(node2);
        boolean bl = this.ensureInteger(node, type3);
        boolean bl2 = this.ensureInteger(node2, type4);
        if (bl && bl2) {
            type2 = this.c().convert(type3, type4);
            if (type3.hasConstant() && type4.hasConstant()) {
                type2 = type2.annotate();
                try {
                    type2 = type2.constant(this.c().mask(type3.getConstant().bigIntValue(), type2).xor(this.c().mask(type4.getConstant().bigIntValue(), type2)));
                }
                catch (IllegalStateException illegalStateException) {
                    type2 = type2.constant(new StaticReference(type2));
                }
            }
        } else {
            type2 = ErrorT.TYPE;
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitBitwiseAndExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        Node node2 = gNode.getNode(1);
        Type type3 = (Type)this.dispatch(node);
        Type type4 = (Type)this.dispatch(node2);
        boolean bl = this.ensureInteger(node, type3);
        boolean bl2 = this.ensureInteger(node2, type4);
        if (bl && bl2) {
            type2 = this.c().convert(type3, type4);
            if (type3.hasConstant() && type4.hasConstant()) {
                type2 = type2.annotate();
                try {
                    type2 = type2.constant(this.c().mask(type3.getConstant().bigIntValue(), type2).and(this.c().mask(type4.getConstant().bigIntValue(), type2)));
                }
                catch (IllegalStateException illegalStateException) {
                    type2 = type2.constant(new StaticReference(type2));
                }
            }
        } else {
            type2 = ErrorT.TYPE;
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitEqualityExpression(GNode gNode) {
        Type type2;
        block24: {
            Node node = gNode.getNode(0);
            String string = gNode.getString(1);
            Node node2 = gNode.getNode(2);
            Type type3 = (Type)this.dispatch(node);
            Type type4 = (Type)this.dispatch(node2);
            Type type5 = this.c().pointerize(type3);
            Type type6 = this.c().pointerize(type4);
            if (type5.isError() || type6.isError()) {
                type2 = ErrorT.TYPE;
            } else if (this.c().isArithmetic(type3) && this.c().isArithmetic(type4)) {
                type2 = NumberT.INT;
                if (type3.hasConstant() && type4.hasConstant()) {
                    type2 = type2.annotate();
                    try {
                        if (this.c().isIntegral(type5) && this.c().isIntegral(type6)) {
                            BigInteger bigInteger = type3.getConstant().bigIntValue();
                            BigInteger bigInteger2 = type4.getConstant().bigIntValue();
                            type2 = type2.constant("==".equals(string) ? bigInteger.compareTo(bigInteger2) == 0 : bigInteger.compareTo(bigInteger2) != 0);
                            break block24;
                        }
                        double d = type3.getConstant().doubleValue();
                        double d2 = type4.getConstant().doubleValue();
                        type2 = type2.constant("==".equals(string) ? d == d2 : d != d2);
                    }
                    catch (IllegalStateException illegalStateException) {
                        type2 = type2.constant(new StaticReference(type2));
                    }
                }
            } else if (type5.isPointer() && type4.hasConstant() && type4.getConstant().isNull()) {
                type2 = NumberT.INT;
                if (type3.hasConstant()) {
                    type2 = type2.annotate().constant(!type3.getConstant().isTrue());
                }
            } else if (type3.hasConstant() && type3.getConstant().isNull() && type6.isPointer()) {
                type2 = NumberT.INT;
                if (type4.hasConstant()) {
                    type2 = type2.annotate().constant(!type4.getConstant().isTrue());
                }
            } else if (!this.pedantic && (type5.isPointer() && this.c().isIntegral(type6) || this.c().isIntegral(type5) && type6.isPointer())) {
                this.runtime.warning("comparison between pointer and integer", gNode);
                type2 = NumberT.INT;
                if (type3.hasConstant() && type4.hasConstant()) {
                    boolean bl = type3.getConstant().getValue().equals(type4.getConstant().getValue());
                    type2 = type2.annotate().constant("==".equals(string) ? bl : !bl);
                }
            } else if (type5.isPointer() && type6.isPointer()) {
                Type type7 = type5.toPointer().getType().resolve();
                Type type8 = type6.toPointer().getType().resolve();
                if (type7.isError() || type8.isError()) {
                    type2 = ErrorT.TYPE;
                } else if (this.c().equal(type7, type8) || type7.isVoid() || type8.isVoid()) {
                    type2 = NumberT.INT;
                    if (type3.hasConstant() && type4.hasConstant()) {
                        boolean bl = type3.getConstant().getValue().equals(type4.getConstant().getValue());
                        type2 = type2.annotate().constant("==".equals(string) ? bl : !bl);
                    }
                } else {
                    this.runtime.error("comparison of distinct pointer types lacks a cast", gNode);
                    type2 = ErrorT.TYPE;
                }
            } else {
                this.runtime.error("invalid operands to 'binary " + string + "'", gNode);
                type2 = ErrorT.TYPE;
            }
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitRelationalExpression(GNode gNode) {
        Type type2;
        block18: {
            Node node = gNode.getNode(0);
            String string = gNode.getString(1);
            Node node2 = gNode.getNode(2);
            Type type3 = (Type)this.dispatch(node);
            Type type4 = (Type)this.dispatch(node2);
            Type type5 = this.c().pointerize(type3);
            Type type6 = this.c().pointerize(type4);
            if (type5.isError() || type6.isError()) {
                type2 = ErrorT.TYPE;
            } else if (this.c().isReal(type3) && this.c().isReal(type4)) {
                type2 = NumberT.INT;
                if (type3.hasConstant() && type4.hasConstant()) {
                    type2 = type2.annotate();
                    try {
                        if (this.c().isIntegral(type5) && this.c().isIntegral(type6)) {
                            BigInteger bigInteger = type3.getConstant().bigIntValue();
                            BigInteger bigInteger2 = type4.getConstant().bigIntValue();
                            type2 = "<".equals(string) ? type2.constant(bigInteger.compareTo(bigInteger2) < 0) : (">".equals(string) ? type2.constant(bigInteger.compareTo(bigInteger2) > 0) : ("<=".equals(string) ? type2.constant(bigInteger.compareTo(bigInteger2) <= 0) : type2.constant(bigInteger.compareTo(bigInteger2) >= 0)));
                            break block18;
                        }
                        double d = type3.getConstant().doubleValue();
                        double d2 = type4.getConstant().doubleValue();
                        if ("<".equals(string)) {
                            type2 = type2.constant(d < d2);
                            break block18;
                        }
                        if (">".equals(string)) {
                            type2 = type2.constant(d > d2);
                            break block18;
                        }
                        if ("<=".equals(string)) {
                            type2 = type2.constant(d <= d2);
                            break block18;
                        }
                        type2 = type2.constant(d >= d2);
                    }
                    catch (IllegalStateException illegalStateException) {
                        type2 = type2.constant(new StaticReference(type2));
                    }
                }
            } else if (type5.isPointer() && type6.isPointer()) {
                Type type7 = type5.toPointer().getType().resolve();
                Type type8 = type6.toPointer().getType().resolve();
                if (type7.isError() || type8.isError()) {
                    type2 = ErrorT.TYPE;
                } else if (this.c().equal(type7, type8)) {
                    type2 = NumberT.INT;
                    if (type3.hasConstant() && type4.hasConstant()) {
                        type2 = type2.annotate().constant(new StaticReference(type2));
                    }
                } else {
                    this.runtime.error("comparison of distinct pointer types lacks a cast", gNode);
                    type2 = ErrorT.TYPE;
                }
            } else {
                this.runtime.error("invalid operands to 'binary " + string + "'", gNode);
                type2 = ErrorT.TYPE;
            }
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitShiftExpression(GNode gNode) {
        Type type2;
        block19: {
            Node node = gNode.getNode(0);
            String string = gNode.getString(1);
            Node node2 = gNode.getNode(2);
            Type type3 = (Type)this.dispatch(node);
            Type type4 = (Type)this.dispatch(node2);
            boolean bl = this.ensureInteger(node, type3);
            boolean bl2 = this.ensureInteger(node2, type4);
            if (bl && bl2) {
                type2 = this.c().promote(type3);
                if (type4.hasConstant()) {
                    BigInteger bigInteger;
                    try {
                        bigInteger = type4.getConstant().bigIntValue();
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.runtime.warning("can't compute shift count", node2);
                        bigInteger = BigInteger.ZERO;
                    }
                    BigInteger bigInteger2 = BigInteger.valueOf(this.c().getWidth(type2));
                    if (bigInteger.compareTo(bigInteger2) >= 0) {
                        if ("<<".equals(string)) {
                            this.runtime.warning("left shift count >= width of type", node2);
                        } else {
                            this.runtime.warning("right shift count >= width of type", node2);
                        }
                    } else if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
                        if ("<<".equals(string)) {
                            this.runtime.warning("left shift count is negative", node2);
                        } else {
                            this.runtime.warning("right shift count is negative", node2);
                        }
                    } else if (type3.hasConstant()) {
                        type2 = type2.annotate();
                        try {
                            BigInteger bigInteger3 = type3.getConstant().bigIntValue();
                            if ("<<".equals(string)) {
                                type2 = type2.constant(bigInteger3.shiftLeft(bigInteger.intValue()));
                                type2 = this.c().qualify(type2, type3);
                                break block19;
                            }
                            type2 = type2.constant(bigInteger3.shiftRight(bigInteger.intValue()));
                            type2 = this.c().qualify(type2, type3);
                        }
                        catch (IllegalStateException illegalStateException) {
                            type2 = type2.constant(new StaticReference(type2));
                            type2 = this.c().qualify(type2, type3);
                        }
                    } else {
                        type2 = this.c().qualify(type2, type3);
                    }
                } else {
                    type2 = this.c().qualify(type2, type3);
                }
            } else {
                type2 = ErrorT.TYPE;
            }
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitAdditiveExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        String string = gNode.getString(1);
        Node node2 = gNode.getNode(2);
        Type type3 = (Type)this.dispatch(node);
        Type type4 = (Type)this.dispatch(node2);
        Type type5 = this.c().pointerize(type3);
        Type type6 = this.c().pointerize(type4);
        if (type5.isError() || type6.isError()) {
            type2 = ErrorT.TYPE;
        } else if (this.c().isArithmetic(type3) && this.c().isArithmetic(type4)) {
            type2 = this.c().convert(type3, type4);
            if (type3.hasConstant() && type4.hasConstant()) {
                type2 = type2.annotate();
                if (this.c().isIntegral(type2)) {
                    if (type3.getConstant().isReference() && !type4.getConstant().isReference()) {
                        type2 = "+".equals(string) ? type2.constant(type3.getConstant().refValue().add(type4.getConstant().bigIntValue())) : type2.constant(type3.getConstant().refValue().subtract(type4.getConstant().bigIntValue()));
                    } else if (!type3.getConstant().isReference() && "+".equals(string) && type4.getConstant().isReference()) {
                        type2 = type2.constant(type4.getConstant().refValue().add(type3.getConstant().bigIntValue()));
                    } else if (type3.getConstant().isReference() && "-".equals(string) && type4.getConstant().isReference()) {
                        BigInteger bigInteger = type3.getConstant().refValue().difference(type4.getConstant().refValue());
                        type2 = null != bigInteger ? type2.constant(bigInteger) : type2.constant(new StaticReference(type2));
                    } else {
                        try {
                            BigInteger bigInteger = type3.getConstant().bigIntValue();
                            BigInteger bigInteger2 = type4.getConstant().bigIntValue();
                            type2 = type2.constant("+".equals(string) ? bigInteger.add(bigInteger2) : bigInteger.subtract(bigInteger2));
                        }
                        catch (IllegalStateException illegalStateException) {
                            type2 = type2.constant(new StaticReference(type2));
                        }
                    }
                } else {
                    try {
                        double d = type3.getConstant().doubleValue();
                        double d2 = type4.getConstant().doubleValue();
                        type2 = type2.constant("+".equals(string) ? d + d2 : d - d2);
                    }
                    catch (IllegalStateException illegalStateException) {
                        type2 = type2.constant(new StaticReference(type2));
                    }
                }
            }
        } else if ("+".equals(string)) {
            if (type5.isPointer() && this.c().isIntegral(type6)) {
                if (this.ensurePointerArithmetic(gNode, type5)) {
                    type2 = type5;
                    if (this.c().hasConstRef(type3) && type4.hasConstant()) {
                        type2 = type2.annotate();
                        try {
                            type2 = type2.constant(this.c().getConstRef(type3).add(type4.getConstant().bigIntValue()));
                        }
                        catch (IllegalStateException illegalStateException) {
                            type2 = type2.constant(new StaticReference(type2));
                        }
                    }
                } else {
                    type2 = ErrorT.TYPE;
                }
            } else if (this.c().isIntegral(type5) && type6.isPointer()) {
                if (this.ensurePointerArithmetic(gNode, type6)) {
                    type2 = type6;
                    if (type3.hasConstant() && this.c().hasConstRef(type4)) {
                        type2 = type2.annotate();
                        try {
                            type2 = type2.constant(this.c().getConstRef(type4).add(type3.getConstant().bigIntValue()));
                        }
                        catch (IllegalStateException illegalStateException) {
                            type2 = type2.constant(new StaticReference(type2));
                        }
                    }
                } else {
                    type2 = ErrorT.TYPE;
                }
            } else {
                this.runtime.error("invalid operands to 'binary +'", gNode);
                type2 = ErrorT.TYPE;
            }
        } else if (type5.isPointer() && type6.isPointer()) {
            Type type7 = type5.toPointer().getType().resolve();
            Type type8 = type6.toPointer().getType().resolve();
            if (type7.isError() || type8.isError()) {
                type2 = ErrorT.TYPE;
            } else if (this.c().equal(type7, type8)) {
                type2 = C.PTR_DIFF;
                if (this.c().hasConstRef(type3) && this.c().hasConstRef(type4)) {
                    BigInteger bigInteger = this.c().getConstRef(type3).difference(this.c().getConstRef(type4));
                    type2 = type2.annotate();
                    type2 = null == bigInteger ? type2.constant(new StaticReference(type2)) : type2.constant(bigInteger);
                }
            } else {
                this.runtime.error("invalid operands to 'binary -'", gNode);
                type2 = ErrorT.TYPE;
            }
        } else if (type5.isPointer() && this.c().isIntegral(type6)) {
            if (this.ensurePointerArithmetic(gNode, type5)) {
                type2 = type5;
                if (this.c().hasConstRef(type3) && type4.hasConstant()) {
                    type2 = type2.annotate();
                    try {
                        type2 = type2.constant(this.c().getConstRef(type3).subtract(type4.getConstant().bigIntValue()));
                    }
                    catch (IllegalStateException illegalStateException) {
                        type2 = type2.constant(new StaticReference(type2));
                    }
                }
            } else {
                type2 = ErrorT.TYPE;
            }
        } else {
            this.runtime.error("invalid operands to 'binary -'", gNode);
            type2 = ErrorT.TYPE;
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitMultiplicativeExpression(GNode gNode) {
        Type type2;
        block9: {
            boolean bl;
            Node node = gNode.getNode(0);
            String string = gNode.getString(1);
            Node node2 = gNode.getNode(2);
            Type type3 = (Type)this.dispatch(node);
            Type type4 = (Type)this.dispatch(node2);
            boolean bl2 = "%".equals(string) && this.ensureInteger(node, type3) || !"%".equals(string) && this.ensureArithmetic(node, type3);
            boolean bl3 = bl = "%".equals(string) && this.ensureInteger(node2, type4) || !"%".equals(string) && this.ensureArithmetic(node2, type4);
            if (bl2 && bl) {
                type2 = this.c().convert(type3, type4);
                if (type4.hasConstant()) {
                    Constant constant = type4.getConstant();
                    if (!"*".equals(string) && !constant.isTrue()) {
                        this.runtime.warning("division by zero", node2);
                    } else if (type3.hasConstant()) {
                        Constant constant2 = type3.getConstant();
                        type2 = type2.annotate();
                        try {
                            if (this.c().isIntegral(type2)) {
                                BigInteger bigInteger = constant2.bigIntValue();
                                BigInteger bigInteger2 = constant.bigIntValue();
                                type2 = "*".equals(string) ? type2.constant(bigInteger.multiply(bigInteger2)) : ("/".equals(string) ? type2.constant(bigInteger.divide(bigInteger2)) : type2.constant(bigInteger.remainder(bigInteger2)));
                                break block9;
                            }
                            double d = constant2.doubleValue();
                            double d2 = constant.doubleValue();
                            type2 = type2.constant("*".equals(string) ? d * d2 : d / d2);
                        }
                        catch (IllegalStateException illegalStateException) {
                            type2 = type2.constant(new StaticReference(type2));
                        }
                    }
                }
            } else {
                type2 = ErrorT.TYPE;
            }
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitCastExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        Node node2 = gNode.getNode(1);
        Type type3 = (Type)this.dispatch(node);
        Type type4 = (Type)this.dispatch(node2);
        Type type5 = type3.resolve();
        Type type6 = this.c().pointerize(type4);
        boolean bl = !this.pedantic && type5.hasStructOrUnion() && type6.hasStructOrUnion() && this.c().equal(type5, type6);
        boolean bl2 = type5.isVoid() || bl || this.ensureScalar(node2, type6);
        switch (type5.tag()) {
            case ERROR: {
                type2 = ErrorT.TYPE;
                break;
            }
            case VOID: {
                type2 = type3;
                break;
            }
            case POINTER: {
                if (!bl2) {
                    type2 = ErrorT.TYPE;
                    break;
                }
                if (type6.isFloat()) {
                    this.runtime.error("cannot convert to pointer type", gNode);
                    type2 = ErrorT.TYPE;
                    break;
                }
                if (this.c().isIntegral(type6)) {
                    Reference reference;
                    type2 = type3;
                    if (!type4.hasConstant()) break;
                    Type type7 = type5.toPointer().getType();
                    try {
                        reference = NullReference.NULL.add(type4.getConstant().bigIntValue());
                    }
                    catch (IllegalStateException illegalStateException) {
                        reference = new StaticReference(type7);
                    }
                    type2 = type2.annotate();
                    if (type7.hasTag(Type.Tag.VOID) || this.c().isChar(type7) || reference.isStatic()) {
                        type2 = type2.constant(reference);
                        break;
                    }
                    type2 = type2.constant(new CastReference(type7, reference));
                    break;
                }
                type2 = type5;
                if (!this.c().hasConstRef(type4)) break;
                Type type8 = type5.toPointer().getType();
                Type type9 = type6.toPointer().getType();
                type2 = type2.annotate();
                if (type8.equals(type9)) {
                    type2 = type2.constant(this.c().getConstRef(type4));
                    break;
                }
                type2 = type2.constant(new CastReference(type8, this.c().getConstRef(type4)));
                break;
            }
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: {
                if (!bl2) {
                    type2 = ErrorT.TYPE;
                    break;
                }
                if (this.c().isArithmetic(type6)) {
                    type2 = type3;
                    if (!type4.hasConstant()) break;
                    type2 = type2.annotate();
                    if (this.c().isIntegral(type5)) {
                        if (this.c().isIntegral(type6)) {
                            type2 = type2.constant(type4.getConstant().getValue());
                            break;
                        }
                        try {
                            type2 = type2.constant(type4.getConstant().bigIntValue());
                        }
                        catch (IllegalStateException illegalStateException) {
                            type2 = type2.constant(new StaticReference(type2));
                        }
                        break;
                    }
                    try {
                        type2 = type2.constant(type4.getConstant().doubleValue());
                    }
                    catch (IllegalStateException illegalStateException) {
                        type2 = type2.constant(new StaticReference(type2));
                    }
                    break;
                }
                if (type5.isFloat()) {
                    this.runtime.error("cannot convert from pointer type", gNode);
                    type2 = ErrorT.TYPE;
                    break;
                }
                type2 = type3;
                if (!this.c().hasConstRef(type4)) break;
                Reference reference = this.c().getConstRef(type4);
                Type type10 = type6.toPointer().getType();
                type2 = type2.annotate();
                if (reference.hasLocation()) {
                    type2 = type2.constant(reference.getLocation(this.c()));
                    break;
                }
                type2 = type2.constant(reference);
                break;
            }
            case ARRAY: {
                this.runtime.error("cast specifies array type", gNode);
                type2 = ErrorT.TYPE;
                break;
            }
            case FUNCTION: {
                this.runtime.error("cast specifies function type", gNode);
                type2 = ErrorT.TYPE;
                break;
            }
            case STRUCT: 
            case UNION: {
                if (bl) {
                    type2 = type3;
                    break;
                }
            }
            default: {
                this.runtime.error("conversion to non-scalar type requested", gNode);
                type2 = ErrorT.TYPE;
            }
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitSizeofExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        Type type3 = (Type)this.dispatch(node);
        Type type4 = type3.resolve();
        if (type4.isError()) {
            type2 = ErrorT.TYPE;
        } else if (this.c().isIncomplete(type3) && !type4.isVoid()) {
            this.runtime.error("invalid application of 'sizeof' to incomplete type", gNode);
            type2 = ErrorT.TYPE;
        } else if (type3.hasVariable() && type3.toVariable().hasWidth()) {
            this.runtime.error("'sizeof' applied to a bit-field", gNode);
            type2 = ErrorT.TYPE;
        } else if (this.pedantic && type4.isFunction()) {
            this.runtime.error("'sizeof' applied to funcion", gNode);
            type2 = ErrorT.TYPE;
        } else {
            type2 = C.SIZEOF;
            if (!this.c().isVariablyModified(type4)) {
                type2 = type2.annotate().constant(BigInteger.valueOf(this.c().getSize(type4)));
            }
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitAlignofExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        Type type3 = (Type)this.dispatch(node);
        Type type4 = type3.resolve();
        if (type3.hasError()) {
            type2 = ErrorT.TYPE;
        } else if (this.c().isIncomplete(type3) && !type4.isVoid() && !type4.isArray()) {
            this.runtime.error("invalid application of '__alignof' to incomplete type", gNode);
            type2 = ErrorT.TYPE;
        } else if (type3.hasVariable() && type3.toVariable().hasWidth()) {
            this.runtime.error("'__alignof' applied to a bit-field", gNode);
            type2 = ErrorT.TYPE;
        } else if (this.pedantic && type4.isFunction()) {
            this.runtime.error("'__alignof' applied to function", gNode);
            type2 = ErrorT.TYPE;
        } else {
            type2 = C.SIZEOF.annotate().constant(BigInteger.valueOf(this.c().getAlignment(type3)));
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitOffsetofExpression(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getNode(0));
        Type type3 = this.processOffset(type2, gNode.getGeneric(1));
        Type type4 = type3.isError() ? ErrorT.TYPE : (type3.hasConstant() ? C.SIZEOF.annotate().constant(type3.getConstant().getValue()) : C.SIZEOF);
        this.mark(gNode, type4);
        return type4;
    }

    protected Type processOffset(Type type2, GNode gNode) {
        if (gNode.hasName("PrimaryIdentifier")) {
            String string = gNode.getString(0);
            Type type3 = this.processSelection(gNode, type2, string, false);
            if (type3.isError()) {
                return ErrorT.TYPE;
            }
            long l = this.c().getOffset(type2.toStructOrUnion(), string);
            return type3.annotate().constant(BigInteger.valueOf(l));
        }
        if (gNode.hasName("DirectComponentSelection")) {
            if ((type2 = this.processOffset(type2, gNode.getGeneric(0))).isError()) {
                return ErrorT.TYPE;
            }
            String string = gNode.getString(1);
            Type type4 = this.processSelection(gNode, type2, string, false);
            if (type4.isError()) {
                return ErrorT.TYPE;
            }
            if (!type2.hasConstant()) {
                return type4;
            }
            long l = type2.getConstant().longValue() + this.c().getOffset(type2.toStructOrUnion(), string);
            return type4.annotate().constant(BigInteger.valueOf(l));
        }
        if (gNode.hasName("SubscriptExpression")) {
            if ((type2 = this.processOffset(type2, gNode.getGeneric(0))).isError()) {
                return ErrorT.TYPE;
            }
            Type type5 = (Type)this.dispatch(gNode.getNode(1));
            if (type5.isError()) {
                return ErrorT.TYPE;
            }
            Type type6 = this.processSubscript(gNode, type2, type5);
            if (type6.isError()) {
                return ErrorT.TYPE;
            }
            if (!type2.hasConstant() || !type5.hasConstant()) {
                return type6;
            }
            long l = type2.getConstant().longValue() + this.c().getSize(type6) * type5.getConstant().longValue();
            return type6.annotate().constant(BigInteger.valueOf(l));
        }
        this.runtime.error("second argument to 'offsetof' neither a selection nor a subscript", gNode);
        return ErrorT.TYPE;
    }

    public Type visitTypeCompatibilityExpression(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getNode(0));
        Type type3 = (Type)this.dispatch(gNode.getNode(1));
        Type type4 = NumberT.INT.annotate().constant(this.c().compose(type2, type3, this.pedantic).isError() ? BigInteger.ZERO : BigInteger.ONE);
        this.mark(gNode, type4);
        return type4;
    }

    public Type visitUnaryMinusExpression(GNode gNode) {
        Type type2;
        block6: {
            Type type3;
            Node node = gNode.getNode(0);
            if (this.ensureArithmetic(node, type3 = (Type)this.dispatch(node))) {
                type2 = this.c().promote(type3);
                if (type3.hasConstant()) {
                    type2 = type2.annotate();
                    try {
                        if (this.c().isIntegral(type2)) {
                            type2 = type2.constant(this.c().mask(type3.getConstant().bigIntValue().negate(), type2));
                            break block6;
                        }
                        type2 = type2.constant(-type3.getConstant().doubleValue());
                    }
                    catch (IllegalStateException illegalStateException) {
                        type2 = type2.constant(new StaticReference(type2));
                    }
                }
            } else {
                type2 = ErrorT.TYPE;
            }
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitUnaryPlusExpression(GNode gNode) {
        Type type2;
        Type type3;
        Node node = gNode.getNode(0);
        if (this.ensureArithmetic(node, type3 = (Type)this.dispatch(node))) {
            type2 = this.c().promote(type3);
            if (type3.hasConstant()) {
                type2 = type2.annotate().constant(type3.getConstant().getValue());
            }
        } else {
            type2 = ErrorT.TYPE;
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitLogicalNegationExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        Type type3 = (Type)this.dispatch(node);
        Type type4 = this.c().pointerize(type3);
        if (this.ensureScalar(node, type4)) {
            type2 = NumberT.INT;
            if (type3.hasConstant()) {
                type2 = type2.annotate().constant(!type3.getConstant().isTrue());
            }
        } else {
            type2 = ErrorT.TYPE;
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitBitwiseNegationExpression(GNode gNode) {
        Type type2;
        Type type3;
        Node node = gNode.getNode(0);
        if (this.ensureInteger(node, type3 = (Type)this.dispatch(node))) {
            type2 = this.c().promote(type3);
            if (type3.hasConstant()) {
                try {
                    type2 = type2.annotate().constant(this.c().mask(type3.getConstant().bigIntValue().not(), type2));
                }
                catch (IllegalStateException illegalStateException) {
                    type2 = type2.constant(new StaticReference(type2));
                }
            }
        } else {
            type2 = ErrorT.TYPE;
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitAddressExpression(GNode gNode) {
        GNode gNode2 = gNode.getGeneric(0);
        if (gNode2.hasName("IndirectionExpression")) {
            Type type2;
            Type type3 = (Type)this.dispatch(gNode2.getGeneric(0));
            Type type4 = this.processIndirection(gNode2, type3, false);
            if ((type4 = this.processAddress(gNode, type4)).isError()) {
                type2 = ErrorT.TYPE;
            } else {
                type2 = this.c().toRValue(this.c().pointerize(type3));
                Type type5 = type3.resolve();
                if (type5.isArray() || type5.isFunction()) {
                    if (type3.hasShape() && type3.getShape().isConstant()) {
                        type2 = type2.annotate().constant(type3.getShape());
                    }
                } else if (type3.hasConstant()) {
                    type2 = type2.annotate().constant(type3.getConstant().getValue());
                }
            }
            this.mark(gNode, type2);
            return type2;
        }
        if (gNode2.hasName("SubscriptExpression")) {
            Type type6;
            Type type7;
            Type type8 = (Type)this.dispatch(gNode2.getGeneric(0));
            Type type9 = this.processSubscript(gNode2, type8, type7 = (Type)this.dispatch(gNode2.getGeneric(1)));
            if (type9.isError()) {
                type6 = ErrorT.TYPE;
            } else {
                type6 = this.c().pointerize(type8);
                Reference reference = null;
                if (type8.resolve().isArray() && type8.hasShape() && type8.getShape().isConstant()) {
                    reference = type8.getShape();
                } else if (type8.hasConstant()) {
                    assert (type8.getConstant().isReference());
                    reference = (Reference)type8.getConstant().getValue();
                }
                if (null != reference && type7.hasConstant()) {
                    type6 = type6.annotate();
                    try {
                        type6 = type6.constant(reference.add(type7.getConstant().bigIntValue()));
                    }
                    catch (IllegalStateException illegalStateException) {
                        type6 = type6.constant(new StaticReference(type6));
                    }
                }
            }
            this.mark(gNode, type6);
            return type6;
        }
        Type type10 = (Type)this.dispatch(gNode2);
        Type type11 = this.processAddress(gNode, type10);
        if (type10.hasShape() && type10.getShape().isConstant()) {
            type11 = type11.annotate().constant(type10.getShape());
        }
        this.mark(gNode, type11);
        return type11;
    }

    protected Type processAddress(GNode gNode, Type type2) {
        Type type3 = type2.resolve();
        if (type3.isError()) {
            return ErrorT.TYPE;
        }
        if (type2.hasShape()) {
            if (type2.hasVariable() && type2.toVariable().hasWidth()) {
                this.runtime.error("cannot take address of bit-field '" + type2.toVariable().getName() + "'", gNode);
                return ErrorT.TYPE;
            }
            if (type2.hasAttribute(Constants.ATT_STORAGE_REGISTER)) {
                this.runtime.error("address of register " + CAnalyzer.toDescription(gNode.getNode(0)) + " requested", gNode);
                return ErrorT.TYPE;
            }
            Type type4 = new PointerT(this.c().qualify(type3, type2));
            if (type2.getShape().isConstant()) {
                type4 = type4.annotate().constant(type2.getShape());
            }
            return type4;
        }
        this.runtime.error("invalid lvalue in unary '&'", gNode.getNode(0));
        return ErrorT.TYPE;
    }

    public Type visitLabelAddressExpression(GNode gNode) {
        Type type2 = PointerT.TO_VOID.annotate().constant(new StaticReference(gNode.getString(0), VoidT.TYPE));
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitIndirectionExpression(GNode gNode) {
        Node node = gNode.getNode(0);
        Type type2 = (Type)this.dispatch(node);
        Type type3 = this.processIndirection(gNode, type2, true);
        this.mark(gNode, type3);
        return type3;
    }

    protected Type processIndirection(Node node, Type type2, boolean bl) {
        Type type3 = this.c().pointerize(type2);
        if (type3.isError()) {
            return ErrorT.TYPE;
        }
        if (type3.isPointer()) {
            Type type4;
            Type type5 = type3.toPointer().getType();
            Type type6 = type5.resolve();
            if (type6.isError()) {
                type4 = ErrorT.TYPE;
            } else if (this.c().isIncomplete(type5)) {
                this.runtime.error("dereferencing pointer to incomplete type", node);
                type4 = ErrorT.TYPE;
            } else {
                Reference reference = type2.hasShape() ? type2.getShape().indirect(type2) : (type2.hasConstant() ? type2.getConstant().refValue() : new DynamicReference(type6));
                type4 = this.c().qualify(type6, type5).annotate().shape(reference);
            }
            if (type6.isVoid() && bl) {
                this.runtime.warning("dereferencing 'void *' pointer", node);
            }
            return type4;
        }
        this.runtime.error("operand to 'unary *' not a pointer type", node);
        return ErrorT.TYPE;
    }

    public Type visitPreincrementExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        Type type3 = this.ensureScalar(node, type2 = (Type)this.dispatch(node)) && this.ensurePointerArithmetic(gNode, type2) && this.ensureLValue(node, type2) ? type2.resolve() : ErrorT.TYPE;
        this.mark(gNode, type3);
        return type3;
    }

    public Type visitPredecrementExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        Type type3 = this.ensureScalar(node, type2 = (Type)this.dispatch(node)) && this.ensurePointerArithmetic(gNode, type2) && this.ensureLValue(node, type2) ? type2.resolve() : ErrorT.TYPE;
        this.mark(gNode, type3);
        return type3;
    }

    public Type visitExtensionExpression(GNode gNode) {
        return (Type)this.dispatch(gNode.getNode(0));
    }

    public Type visitSubscriptExpression(GNode gNode) {
        Node node = gNode.getNode(0);
        Node node2 = gNode.getNode(1);
        Type type2 = (Type)this.dispatch(node);
        Type type3 = (Type)this.dispatch(node2);
        Type type4 = this.processSubscript(gNode, type2, type3);
        this.mark(gNode, type4);
        return type4;
    }

    protected Type processSubscript(Node node, Type type2, Type type3) {
        boolean bl;
        Type type4 = this.c().pointerize(type2);
        if (type3.hasError()) {
            bl = false;
        } else if (this.c().isIntegral(type3)) {
            bl = true;
        } else {
            this.runtime.error("array subscript is not an integer", node);
            bl = false;
        }
        if (type2.hasError()) {
            return ErrorT.TYPE;
        }
        if (type4.isPointer()) {
            Type type5 = type4.toPointer().getType();
            Type type6 = type5.resolve();
            if (type6.isError()) {
                return ErrorT.TYPE;
            }
            if (type6.isFunction()) {
                this.runtime.error("subscripted value is pointer to function", node);
                return ErrorT.TYPE;
            }
            if (this.c().isIncomplete(type5)) {
                this.runtime.error("dereferencing pointer to incomplete type", node);
                return ErrorT.TYPE;
            }
            if (bl) {
                Reference reference;
                if (type2.hasShape() && type3.hasConstant()) {
                    try {
                        reference = type2.getShape().indirect(type2).add(type3.getConstant().bigIntValue());
                    }
                    catch (IllegalStateException illegalStateException) {
                        reference = new StaticReference(type6);
                    }
                } else {
                    reference = new DynamicReference(type6);
                }
                return this.c().qualify(type6, type5).annotate().shape(reference);
            }
            return ErrorT.TYPE;
        }
        this.runtime.error("subscripted value is neither array nor pointer", node);
        return ErrorT.TYPE;
    }

    public Type visitDirectComponentSelection(GNode gNode) {
        Node node = gNode.getNode(0);
        String string = gNode.getString(1);
        Type type2 = (Type)this.dispatch(node);
        Type type3 = this.processSelection(node, type2, string, false);
        this.mark(gNode, type3);
        return type3;
    }

    public Type visitIndirectComponentSelection(GNode gNode) {
        Node node = gNode.getNode(0);
        String string = gNode.getString(1);
        Type type2 = (Type)this.dispatch(node);
        Type type3 = this.processSelection(node, type2, string, true);
        this.mark(gNode, type3);
        return type3;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Type processSelection(Node node, Type type2, String string, boolean bl) {
        Type type3;
        Object object;
        if (type2.hasError()) {
            return ErrorT.TYPE;
        }
        if (bl) {
            object = this.c().pointerize(type2);
            if (!((Type)object).isPointer()) {
                this.runtime.error("invalid type argument of '->'", node);
                return ErrorT.TYPE;
            }
            type3 = ((Type)object).toPointer().getType();
            if (this.c().isIncomplete(type3)) {
                this.runtime.error("dereferencing pointer to incomplete type", node);
                return ErrorT.TYPE;
            }
        } else {
            type3 = type2;
        }
        if (type3.hasError()) {
            return ErrorT.TYPE;
        }
        if (!type3.hasStructOrUnion()) {
            this.runtime.error("request for member '" + string + "' in something not a struct or union", node);
            return ErrorT.TYPE;
        }
        object = type3.toTagged();
        Type type4 = object.lookup(string);
        if (type4.isError()) {
            this.runtime.error("'" + (object.isStruct() ? "struct " : "union ") + object.getName() + "' has no member named '" + string + "'", node);
            return ErrorT.TYPE;
        }
        type4 = this.c().qualify(type4, type3);
        if (!bl) {
            if (!type2.hasShape()) return type4;
        }
        Reference reference = type2.hasShape() ? (bl ? type2.getShape().indirect(type2) : type2.getShape()) : (type2.hasConstant() ? type2.getConstant().refValue() : new DynamicReference(type3));
        return type4.annotate().shape(new FieldReference(reference, string));
    }

    public Type visitFunctionCall(GNode gNode) {
        Type type2;
        Iterable iterable;
        Type type3;
        Object object;
        Node node = gNode.getNode(0);
        Node node2 = gNode.getNode(1);
        if (GNode.cast(node).hasName("PrimaryIdentifier")) {
            object = GNode.cast(node).getString(0);
            if ("__xtc_trace".equals(object)) {
                List list = (List)this.dispatch(node2);
                boolean bl = true;
                Type type4 = null;
                for (Type type5 : list) {
                    if (bl) {
                        bl = false;
                        type4 = type5;
                    }
                    this.runtime.console().loc(gNode).p(": ");
                    type5.trace(this.runtime);
                }
                if (null == type4) {
                    type4 = VoidT.TYPE;
                }
                this.mark(gNode, type4);
                return type4;
            }
            type3 = (Type)this.table.lookup((String)object);
            if (null == type3) {
                if (this.pedantic) {
                    this.runtime.error("'" + (String)object + "' undeclared", node);
                    type3 = ErrorT.TYPE;
                } else {
                    type3 = new FunctionT(NumberT.INT, new ArrayList<Type>(0), false).attribute(Constants.ATT_STYLE_OLD).attribute(Constants.ATT_IMPLICIT).annotate().attribute(Constants.ATT_STORAGE_EXTERN);
                    this.table.current().define((String)object, type3.shape(true, (String)object).locate(gNode));
                    iterable = this.lookupExtern((String)object);
                    if (null == iterable) {
                        this.defineExtern((String)object, type3.shape(true, (String)object).locate(gNode));
                    } else if (!((Type)iterable).hasAttribute(Constants.ATT_IMPLICIT)) {
                        this.compose(gNode, (String)object, type3, (Type)iterable, false);
                    }
                }
            }
        } else {
            type3 = (Type)this.dispatch(node);
        }
        object = this.c().pointerize(type3);
        iterable = (List)this.dispatch(node2);
        if (((Type)object).isError()) {
            type2 = ErrorT.TYPE;
        } else if (((Type)object).isPointer() && ((Type)object).toPointer().getType().hasTag(Type.Tag.FUNCTION)) {
            FunctionT functionT = ((Type)object).toPointer().getType().resolve().toFunction();
            List<Type> list = functionT.getParameters();
            if (!functionT.hasAttribute(Constants.ATT_STYLE_OLD)) {
                int n = list.size();
                int n2 = null == iterable ? 0 : iterable.size();
                int n3 = Math.min(n, n2);
                String string = CAnalyzer.toFunctionName(node);
                for (int i = 0; i < n3; ++i) {
                    String string2 = "passing argument " + (i + 1);
                    if (null != string) {
                        string2 = string2 + " to '" + string + "'";
                    }
                    this.processAssignment(false, string2, gNode, list.get(i), (Type)iterable.get(i));
                }
                if (n > n2) {
                    if (null == string) {
                        this.runtime.error("too few arguments to function", gNode);
                    } else {
                        this.runtime.error("too few arguments to function '" + string + "'", gNode);
                    }
                } else if (!functionT.isVarArgs() && n < n2) {
                    if (null == string) {
                        this.runtime.error("too many arguments to function", gNode);
                    } else {
                        this.runtime.error("too many arguments to function '" + string + "'", gNode);
                    }
                }
            }
            type2 = functionT.getResult();
        } else {
            this.runtime.error("called " + CAnalyzer.toDescription(node) + " is not a function", gNode);
            type2 = ErrorT.TYPE;
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitPostincrementExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        Type type3 = this.ensureScalar(node, type2 = (Type)this.dispatch(node)) && this.ensurePointerArithmetic(gNode, type2) && this.ensureLValue(node, type2) ? type2.resolve() : ErrorT.TYPE;
        this.mark(gNode, type3);
        return type3;
    }

    public Type visitPostdecrementExpression(GNode gNode) {
        Type type2;
        Node node = gNode.getNode(0);
        Type type3 = this.ensureScalar(node, type2 = (Type)this.dispatch(node)) && this.ensurePointerArithmetic(gNode, type2) && this.ensureLValue(node, type2) ? type2.resolve() : ErrorT.TYPE;
        this.mark(gNode, type3);
        return type3;
    }

    public Type visitCompoundLiteral(GNode gNode) {
        Type type2;
        Type type3 = (Type)this.dispatch(gNode.getNode(0));
        StaticReference staticReference = new StaticReference("<literal>", type3.resolve());
        type3 = type3.annotate().shape(staticReference).constant(staticReference);
        type3 = this.isTopLevel ? type3.attribute(Constants.ATT_STORAGE_STATIC) : type3.attribute(Constants.ATT_STORAGE_AUTO);
        if (type3.hasStructOrUnion() && this.c().isIncomplete(type3)) {
            String string;
            String string2 = string = type3.hasTag(Type.Tag.STRUCT) ? "struct" : "union";
            if (type3.toTagged().isUnnamed()) {
                this.runtime.error("unnamed " + string + " has incomplete type", gNode);
            } else {
                this.runtime.error("'" + string + " " + type3.toTagged().getName() + "' has incomplete type", gNode);
            }
            type2 = ErrorT.TYPE;
        } else {
            type2 = this.processInitializer(gNode, null, type3, gNode.getGeneric(1));
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitPrimaryIdentifier(GNode gNode) {
        Type type2 = (Type)this.table.lookup(gNode.getString(0));
        if (null == type2) {
            this.runtime.error("'" + gNode.getString(0) + "' undeclared", gNode);
            type2 = ErrorT.TYPE;
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitFloatingConstant(GNode gNode) {
        Type type2 = this.c().typeFloat(gNode.getString(0));
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitIntegerConstant(GNode gNode) {
        Type type2 = this.c().typeInteger(gNode.getString(0));
        if (!this.c().fits(type2.getConstant().bigIntValue(), type2)) {
            this.runtime.warning("integer constant is too large for its type");
            type2 = type2.resolve().annotate().constant(this.c().mask(type2.getConstant().bigIntValue(), type2));
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitCharacterConstant(GNode gNode) {
        Type type2 = this.c().typeCharacter(gNode.getString(0));
        if (!this.c().fits(type2.getConstant().bigIntValue(), type2)) {
            this.runtime.warning("character constant too large for its type", gNode);
            type2 = type2.resolve().annotate().constant(this.c().mask(type2.getConstant().bigIntValue(), type2));
        }
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitStringConstant(GNode gNode) {
        Object object;
        Object object22;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (Object object22 : gNode) {
            object = Token.cast(object22);
            if (((String)object).startsWith("L")) {
                try {
                    stringBuilder.append(Utilities.unescape(((String)object).substring(2, ((String)object).length() - 1)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.runtime.error(illegalArgumentException.getMessage(), gNode);
                }
                bl = true;
                continue;
            }
            try {
                stringBuilder.append(Utilities.unescape(((String)object).substring(1, ((String)object).length() - 1)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.runtime.error(illegalArgumentException.getMessage(), gNode);
            }
        }
        String string = stringBuilder.toString();
        object22 = bl ? C.WCHAR : NumberT.CHAR;
        object22 = ((Type)object22).annotate().attribute(Constants.ATT_CONSTANT);
        object = new ArrayT((Type)object22, string.length());
        object = ((Type)object).annotate().shape(new StringReference(string, (Type)object));
        object = ((Type)object).constant(((Type)object).getShape());
        this.mark(gNode, (Type)object);
        return object;
    }

    public Type visitStatementAsExpression(GNode gNode) {
        this.isStmtAsExpr = true;
        Type type2 = (Type)this.dispatch(gNode.getNode(0));
        this.mark(gNode, type2);
        return type2;
    }

    public Type visitVariableArgumentAccess(GNode gNode) {
        Type type2 = (Type)this.dispatch(gNode.getNode(0));
        if (!this.c().equal(InternalT.VA_LIST, type2.resolve())) {
            this.runtime.error("first argument to 'va_arg' not of type 'va_list'");
        }
        Type type3 = (Type)this.dispatch(gNode.getNode(1));
        this.mark(gNode, type3);
        return type3;
    }

    public Type visitTypeName(GNode gNode) {
        Specifiers specifiers = this.newSpecifiers(gNode.getGeneric(0), false);
        Type type2 = this.getDeclaredType(specifiers.getBaseType(), gNode.getGeneric(1));
        type2 = specifiers.annotateFull(type2);
        this.mark(gNode, type2);
        return type2;
    }

    public void visit(GNode gNode) {
        boolean bl = this.hasScope;
        this.hasScope = true;
        for (Object object : gNode) {
            if (!(object instanceof Node)) continue;
            this.dispatch((Node)object);
        }
        this.hasScope = bl;
    }

    public boolean checkType(GNode gNode, String string, Type type2) {
        type2 = type2.resolve();
        while (type2.isPointer()) {
            type2 = type2.toPointer().getType().resolve();
        }
        if (type2.isArray()) {
            Type type3 = type2;
            while ((type3 = type3.toArray().getType().resolve()).isArray()) {
            }
            if (type3.isFunction()) {
                if (null == string) {
                    this.runtime.error("declaration of array of functions", gNode);
                } else {
                    this.runtime.error("'" + string + "' declared as array of functions", gNode);
                }
                return false;
            }
            return this.checkType(gNode, string, type3);
        }
        if (type2.isFunction()) {
            Type type4 = type2.toFunction().getResult().resolve();
            if (type4.isArray()) {
                if (null == string) {
                    this.runtime.error("declaration of function returning an array", gNode);
                } else {
                    this.runtime.error("'" + string + "' declared as function returning " + "an array", gNode);
                }
                return false;
            }
            if (type4.isFunction()) {
                if (null == string) {
                    this.runtime.error("declaration of function returning a function", gNode);
                } else {
                    this.runtime.error("'" + string + "' declared as function returning " + "a function", gNode);
                }
                return false;
            }
            return this.checkType(gNode, string, type4);
        }
        return true;
    }

    public Type compose(GNode gNode, String string, Type type2, Type type3, boolean bl) {
        if (type3.isAlias() || type2.resolve().isFunction() != type3.resolve().isFunction()) {
            this.runtime.error("'" + string + "' redeclared as different kind of symbol", gNode);
            this.reportPrevious(string, type3);
            return ErrorT.TYPE;
        }
        Type type4 = type3.hasAttribute(Constants.ATT_STORAGE_EXTERN) || !type2.hasAttribute(Constants.ATT_STORAGE_EXTERN) || bl ? this.c().compose(type2, type3, this.pedantic) : this.c().compose(type3, type2, this.pedantic);
        if (type4.isError()) {
            if (type3.hasAttribute(Constants.ATT_BUILTIN) && type3.resolve().isFunction()) {
                this.runtime.error("conflicting types for built-in function '" + string + "'", gNode);
            } else {
                this.runtime.error("conflicting types for '" + string + "'", gNode);
                this.reportPrevious(string, type3);
            }
            return ErrorT.TYPE;
        }
        if (!this.c().hasSameQualifiers(type2, type3)) {
            this.runtime.error("conflicting type qualifiers for '" + string + "'", gNode);
            this.reportPrevious(string, type3);
            return ErrorT.TYPE;
        }
        return type4;
    }

    public static GNode getSpecifier(String string, GNode gNode) {
        for (Object object : gNode) {
            GNode gNode2 = GNode.cast(object);
            if (!gNode2.hasName(string)) continue;
            return gNode2;
        }
        return null;
    }

    public Specifiers newSpecifiers(GNode gNode, boolean bl) {
        return new Specifiers(gNode, bl);
    }

    public List<Attribute> toAttributeList(GNode gNode) {
        if (null == gNode) {
            return Collections.emptyList();
        }
        return this.toAttributeList(gNode, new ArrayList<Attribute>());
    }

    private List<Attribute> toAttributeList(GNode gNode, List<Attribute> list) {
        if (gNode.hasName("AttributeSpecifier")) {
            if (null != gNode.get(0)) {
                for (Object object : gNode.getGeneric(0)) {
                    GNode gNode2 = GNode.cast(object);
                    String string = this.toAttributeName(gNode2.getString(0));
                    Object object2 = this.toAttributeValue(gNode2.getGeneric(1));
                    boolean bl = false;
                    if ("packed".equals(string)) {
                        if (null != object2) {
                            this.runtime.error("wrong number of arguments specified for 'packed' attribute", gNode2);
                            bl = true;
                        }
                    } else if ("aligned".equals(string) && null != object2) {
                        if (object2 instanceof List) {
                            this.runtime.error("wrong number of arguments specified for 'aligned' attribute", gNode2);
                            bl = true;
                        } else if (object2 instanceof Node) {
                            this.runtime.error("requested alignment is not a constant", gNode2);
                            bl = true;
                        } else if (!(object2 instanceof BigInteger)) {
                            this.runtime.error("requested alignment is not an integer constant", gNode2);
                            bl = true;
                        } else {
                            BigInteger bigInteger = (BigInteger)object2;
                            if (1 != bigInteger.signum() || 1 != bigInteger.bitCount()) {
                                this.runtime.error("requested alignment is not a power of 2", gNode2);
                                bl = true;
                            } else if (Limits.INT_MAX.compareTo(bigInteger) < 0) {
                                this.runtime.error("requested alignment is too large", gNode2);
                                bl = true;
                            }
                        }
                    }
                    if (bl) continue;
                    list.add(new Attribute("gcc", new Attribute(string, object2)));
                }
            }
            return list;
        }
        if (gNode.hasName("AttributeSpecifierList")) {
            for (Object object : gNode) {
                this.toAttributeList(GNode.cast(object), list);
            }
            return list;
        }
        throw new AssertionError((Object)("Not an attribute specifier (list): " + gNode));
    }

    public String toAttributeName(String string) {
        if (string.startsWith("__")) {
            string = string.substring(2);
        }
        if (string.endsWith("__")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public Object toAttributeValue(GNode gNode) {
        if (null == gNode) {
            return null;
        }
        if (gNode.hasName("ExpressionList")) {
            if (0 == gNode.size()) {
                return null;
            }
            if (1 == gNode.size()) {
                return this.toAttributeValue(gNode.getGeneric(0));
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(gNode.size());
            for (Object object : gNode) {
                arrayList.add(this.toAttributeValue(GNode.cast(object)));
            }
            return arrayList;
        }
        if (gNode.hasName("PrimaryIdentifier")) {
            return gNode.getString(0);
        }
        Type type2 = (Type)this.dispatch(gNode);
        return type2.hasConstant() ? type2.getConstant().getValue() : gNode;
    }

    public FunctionT getParameterTypes(GNode gNode) {
        if (null == gNode) {
            FunctionT functionT = new FunctionT(null, new ArrayList<Type>(0), false);
            functionT.addAttribute(Constants.ATT_STYLE_OLD);
            return functionT;
        }
        if (gNode.hasName("ParameterTypeList")) {
            Object object;
            ArrayList<Type> arrayList;
            boolean bl;
            this.table.enter(TMP_SCOPE);
            if (this.isVoidParameterTypeList(gNode)) {
                bl = false;
                arrayList = new ArrayList<Type>(0);
                object = gNode.getGeneric(0).getGeneric(0);
                Specifiers specifiers = new Specifiers(((Node)object).getGeneric(0), false);
                Type type2 = specifiers.annotateFull(specifiers.getBaseType());
                if (type2.hasAttribute("storage")) {
                    this.runtime.error("'void' as only parameter may not have storage class", gNode);
                }
                if (this.c().hasQualifiers(type2)) {
                    this.runtime.error("'void' as only parameter may not be qualified", gNode);
                }
                if (type2.hasAttribute(Constants.ATT_INLINE)) {
                    this.runtime.error("'void' as only parameter may not be declared 'inline'", gNode);
                }
            } else {
                bl = null != gNode.get(1);
                gNode = gNode.getGeneric(0);
                arrayList = new ArrayList(gNode.size());
                for (Object e : gNode) {
                    GNode gNode2 = GNode.cast(e);
                    GNode gNode3 = gNode2.getGeneric(1);
                    GNode gNode4 = CAnalyzer.getDeclaredId(gNode3);
                    String string = null != gNode4 ? gNode4.getString(0) : null;
                    Specifiers specifiers = new Specifiers(gNode2.getGeneric(0), false);
                    Type type3 = this.getDeclaredType(true, specifiers.getBaseType(), gNode3);
                    this.checkType(gNode2, string, type3);
                    switch (type3.tag()) {
                        case ARRAY: {
                            type3 = this.c().qualify(new PointerT(type3.resolve().toArray().getType()), type3);
                            break;
                        }
                        case FUNCTION: {
                            type3 = this.c().qualify(new PointerT(type3.resolve()), type3);
                        }
                    }
                    type3 = null == string ? type3.annotate().shape(false, "<param>") : VariableT.newParam(type3, string).shape(false, string);
                    type3 = specifiers.annotateFull(type3).attribute(this.toAttributeList(gNode2.getGeneric(2)));
                    if (type3.hasAttribute("storage") && !type3.hasAttribute(Constants.ATT_STORAGE_REGISTER)) {
                        if (null == string) {
                            this.runtime.error("storage class specified for parameter", gNode2);
                        } else {
                            this.runtime.error("storage class specified for parameter '" + string + "'", gNode2);
                        }
                    }
                    if (specifiers.contains(Constants.ATT_INLINE)) {
                        if (null == string) {
                            this.runtime.error("parameter declared 'inline'", gNode2);
                        } else {
                            this.runtime.error("parameter '" + string + "' declared 'inline'", gNode2);
                        }
                    }
                    if (null == string) {
                        arrayList.add(type3);
                        continue;
                    }
                    if (this.table.current().isDefinedLocally(string)) {
                        this.runtime.error("redefinition of parameter '" + string + "'", gNode2);
                        arrayList.add(VariableT.newParam(ErrorT.TYPE, string));
                        continue;
                    }
                    this.table.current().define(string, type3);
                    arrayList.add(type3);
                }
            }
            this.table.exit();
            this.table.delete(TMP_SCOPE);
            object = new FunctionT(null, arrayList, bl);
            ((Type)object).addAttribute(Constants.ATT_STYLE_NEW);
            return object;
        }
        if (gNode.hasName("IdentifierList")) {
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList<Type> arrayList = new ArrayList<Type>(gNode.size());
            for (Object object : gNode) {
                String string = Token.cast(object);
                if (hashSet.contains(string)) {
                    this.runtime.error("multiple parameters named '" + string + "'", gNode);
                    arrayList.add(VariableT.newParam(ErrorT.TYPE, string));
                    continue;
                }
                hashSet.add(string);
                arrayList.add(VariableT.newParam(C.IMPLICIT, string).shape(false, string));
            }
            FunctionT functionT = new FunctionT(null, arrayList, false);
            functionT.addAttribute(Constants.ATT_STYLE_OLD);
            return functionT;
        }
        throw new AssertionError((Object)("Unrecognized parameter representation: " + gNode));
    }

    public Type getDeclaredType(Type type2, GNode gNode) {
        return this.getDeclaredType(false, type2, gNode);
    }

    public Type getDeclaredType(final boolean bl, final Type type2, GNode gNode) {
        return null == gNode ? type2 : (Type)new Visitor(){
            private Type result;
            private List<Attribute> list1;
            private List<Attribute> list2;
            {
                this.result = type2;
                this.list1 = null;
                this.list2 = null;
            }

            private void annotate() {
                if (null != this.list1 && 0 < this.list1.size()) {
                    this.result = this.result.annotate().attribute(this.list1);
                    this.list1 = null;
                }
                if (null != this.list2 && 0 < this.list2.size()) {
                    this.result = this.result.annotate().attribute(this.list2);
                    this.list2 = null;
                }
            }

            private void processPointer(GNode gNode) {
                while (null != gNode) {
                    Specifiers specifiers = CAnalyzer.this.newSpecifiers(gNode.getGeneric(0), false);
                    this.result = specifiers.hasBaseAttributes() ? specifiers.annotateBase(new PointerT(this.result).annotate()) : new PointerT(this.result);
                    gNode = gNode.getGeneric(1);
                }
            }

            private Type processArray(Type type22, GNode gNode, GNode gNode2) {
                if (null != gNode && gNode.hasName("VariableLength")) {
                    if (!bl) {
                        CAnalyzer.this.runtime.error("'[*]' in non-parameter array declarator", gNode2);
                    }
                    return new ArrayT(type22, true);
                }
                if (null == gNode) {
                    return new ArrayT(type22);
                }
                Type type3 = CAnalyzer.this.processExpression(gNode);
                if (type3.hasError()) {
                    return new ArrayT(type22);
                }
                if (!CAnalyzer.this.c().isIntegral(type3)) {
                    GNode gNode3 = CAnalyzer.getDeclaredId(gNode2);
                    if (null == gNode3) {
                        CAnalyzer.this.runtime.error("size of array has non-integer type", GNode.cast(gNode));
                    } else {
                        CAnalyzer.this.runtime.error("size of array '" + gNode3.getString(0) + "' has non-integer type", GNode.cast(gNode));
                    }
                    return new ArrayT(type22);
                }
                if (type3.hasConstant()) {
                    BigInteger bigInteger;
                    try {
                        bigInteger = type3.getConstant().bigIntValue();
                    }
                    catch (IllegalStateException illegalStateException) {
                        GNode gNode4 = CAnalyzer.getDeclaredId(gNode2);
                        if (null == gNode4) {
                            CAnalyzer.this.runtime.warning("can't compute size of array", GNode.cast(gNode));
                        } else {
                            CAnalyzer.this.runtime.warning("can't compute size of array '" + gNode4.getString(0) + "'", GNode.cast(gNode));
                        }
                        bigInteger = BigInteger.ONE;
                    }
                    if (bigInteger.compareTo(BigInteger.ZERO) == 0) {
                        if (CAnalyzer.this.pedantic) {
                            GNode gNode5 = CAnalyzer.getDeclaredId(gNode2);
                            if (null == gNode5) {
                                CAnalyzer.this.runtime.error("ISO C forbids zero-size array", GNode.cast(gNode));
                            } else {
                                CAnalyzer.this.runtime.error("ISO C forbids zero-size array '" + gNode5.getString(0) + "'", GNode.cast(gNode));
                            }
                        }
                        return new ArrayT(type22, 0L);
                    }
                    if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
                        GNode gNode6 = CAnalyzer.getDeclaredId(gNode2);
                        if (null == gNode6) {
                            CAnalyzer.this.runtime.error("size of array is negative", GNode.cast(gNode));
                        } else {
                            CAnalyzer.this.runtime.error("size of array '" + gNode6.getString(0) + "' is negative", GNode.cast(gNode));
                        }
                        return new ArrayT(type22, 0L);
                    }
                    if (bigInteger.compareTo(Limits.ARRAY_MAX) > 0) {
                        GNode gNode7 = CAnalyzer.getDeclaredId(gNode2);
                        if (null == gNode7) {
                            CAnalyzer.this.runtime.error("size of array is too large", GNode.cast(gNode));
                        } else {
                            CAnalyzer.this.runtime.error("size of array '" + gNode7.getString(0) + "' is too large", GNode.cast(gNode));
                        }
                        return new ArrayT(type22, 0L);
                    }
                    return new ArrayT(type22, bigInteger.longValue());
                }
                return new ArrayT(type22, true);
            }

            public Object visitAttributedDeclarator(GNode gNode) {
                if (null != gNode.get(0)) {
                    this.list1 = CAnalyzer.this.toAttributeList(gNode.getGeneric(0));
                }
                if (null != gNode.get(2)) {
                    this.list2 = CAnalyzer.this.toAttributeList(gNode.getGeneric(2));
                }
                return this.dispatch(gNode.getGeneric(1));
            }

            public Object visitPointerDeclarator(GNode gNode) {
                this.processPointer(gNode.getGeneric(0));
                this.annotate();
                return this.dispatch(gNode.getGeneric(1));
            }

            public Object visitArrayDeclarator(GNode gNode) {
                this.result = this.processArray(this.result, gNode.getGeneric(2), gNode);
                if (bl) {
                    if (gNode.getGeneric(0).hasName("SimpleDeclarator")) {
                        Specifiers specifiers = CAnalyzer.this.newSpecifiers(gNode.getGeneric(1), false);
                        if (specifiers.hasBaseAttributes()) {
                            this.result = specifiers.annotateBase(this.result.annotate());
                        }
                        if (specifiers.hasInline() || null != specifiers.getStorageClass()) {
                            this.result = specifiers.annotateFull(this.result.annotate());
                        }
                    } else if (0 < gNode.getGeneric(1).size()) {
                        CAnalyzer.this.runtime.error("static or type qualifiers not in outermost array type derivation", gNode);
                    }
                } else if (0 < gNode.getGeneric(1).size()) {
                    CAnalyzer.this.runtime.error("static or type qualifiers in non-parameter array declarator", gNode);
                }
                this.annotate();
                return this.dispatch(gNode.getGeneric(0));
            }

            public Object visitFunctionDeclarator(GNode gNode) {
                FunctionT functionT = CAnalyzer.this.getParameterTypes(gNode.getGeneric(1));
                functionT.setResult(this.result);
                this.result = functionT;
                this.annotate();
                return this.dispatch(gNode.getGeneric(0));
            }

            public Object visitSimpleDeclarator(GNode gNode) {
                this.annotate();
                return this.result;
            }

            public Object visitAttributedAbstractDeclarator(GNode gNode) {
                if (null != gNode.get(0)) {
                    this.list1 = CAnalyzer.this.toAttributeList(gNode.getGeneric(0));
                }
                return this.dispatch(gNode.getGeneric(1));
            }

            public Object visitAbstractDeclarator(GNode gNode) {
                this.processPointer(gNode.getGeneric(0));
                this.annotate();
                return null == gNode.get(1) ? this.result : this.dispatch(gNode.getGeneric(1));
            }

            public Object visitDirectAbstractDeclarator(GNode gNode) {
                if (3 == gNode.size()) {
                    if ("[".equals(gNode.getString(1))) {
                        this.result = this.processArray(this.result, gNode.getGeneric(2), gNode);
                    } else {
                        FunctionT functionT = CAnalyzer.this.getParameterTypes(gNode.getGeneric(2));
                        functionT.setResult(this.result);
                        this.result = functionT;
                    }
                    if (null == gNode.get(0)) {
                        this.annotate();
                        return this.result;
                    }
                    this.annotate();
                    return this.dispatch(gNode.getGeneric(0));
                }
                if (null == gNode.get(0)) {
                    this.annotate();
                    return this.result;
                }
                this.annotate();
                return this.dispatch(gNode.getGeneric(0));
            }
        }.dispatch(gNode);
    }

    public static GNode getDeclaredId(GNode gNode) {
        return GNode.cast(getDeclaredIdVisitor.dispatch(gNode));
    }

    public static GNode getFunctionDeclarator(GNode gNode) {
        return GNode.cast(getFunctionDeclaratorVisitor.dispatch(gNode));
    }

    public boolean isVoidParameterTypeList(GNode gNode) {
        assert (gNode.hasName("ParameterTypeList"));
        if (null != gNode.get(1)) {
            return false;
        }
        if (1 != (gNode = gNode.getGeneric(0)).size()) {
            return false;
        }
        GNode gNode2 = gNode.getGeneric(0);
        if (null != gNode2.get(1)) {
            return false;
        }
        GNode gNode3 = gNode2.getGeneric(0);
        for (Object object : gNode3) {
            Type type2;
            GNode gNode4 = GNode.cast(object);
            if (gNode4.hasName("VoidTypeSpecifier")) {
                return true;
            }
            if (!gNode4.hasName("TypedefName") || null == (type2 = (Type)this.table.current().lookup(gNode4.getString(0))) || !type2.isAlias() || !type2.resolve().isVoid()) continue;
            return true;
        }
        return false;
    }

    protected boolean isInitializable(Type type2, Type type3) {
        if (type2.hasError() || type3.hasError()) {
            return true;
        }
        Type type4 = type2.resolve();
        Type type5 = this.c().pointerize(type3);
        switch (type4.tag()) {
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: {
                if (type4.isBoolean()) {
                    return this.c().isScalar(type5);
                }
                return this.c().isArithmetic(type5) || type5.isPointer() && !this.pedantic;
            }
            case STRUCT: 
            case UNION: {
                return this.c().equal(type4, type5);
            }
            case ARRAY: {
                return type3.hasConstant() && (this.c().isString(type4) && this.c().isString(type3) || this.c().isWideString(type4) && this.c().isWideString(type3));
            }
            case POINTER: {
                if (type5.isPointer()) {
                    Type type6 = type4.toPointer().getType();
                    Type type7 = type5.toPointer().getType();
                    Type type8 = type6.resolve();
                    Type type9 = type7.resolve();
                    if (this.c().hasQualifiers(type6, type7) && (this.c().equal(type8, type9) || type8.isVoid() || type9.isVoid())) {
                        return true;
                    }
                    return !this.pedantic;
                }
                if (type3.hasConstant() && type3.getConstant().isNull()) {
                    return true;
                }
                if (this.c().isIntegral(type3)) {
                    return !this.pedantic;
                }
                return false;
            }
        }
        return type4.isInternal() && type5.isInternal() && type4.toInternal().getName().equals(type5.toInternal().getName());
    }

    protected Type processAssignment(boolean bl, String string, Node node, Type type2, Type type3) {
        if (type2.hasError() || type3.hasError()) {
            return ErrorT.TYPE;
        }
        Type type4 = type2.resolve();
        Type type5 = this.c().pointerize(type3);
        Type type6 = null;
        if (type5.isVoid()) {
            this.runtime.error("void value not ignored as it ought to be", node);
            return ErrorT.TYPE;
        }
        switch (type4.tag()) {
            case BOOLEAN: {
                if (!this.c().isScalar(type5)) break;
                type6 = type4;
                break;
            }
            case INTEGER: {
                if (this.c().isArithmetic(type5)) {
                    type6 = type4;
                    break;
                }
                if (!type5.isPointer()) break;
                if (this.pedantic) {
                    this.runtime.error(string + " makes integer from pointer without a cast", node);
                    type6 = ErrorT.TYPE;
                    break;
                }
                this.runtime.warning(string + " makes integer from pointer without a cast", node);
                type6 = type4;
                break;
            }
            case FLOAT: {
                if (!this.c().isArithmetic(type5)) break;
                type6 = type4;
                break;
            }
            case STRUCT: 
            case UNION: {
                if (!this.c().equal(type4, type5)) break;
                type6 = type4;
                break;
            }
            case ARRAY: {
                if (!bl) break;
                if (this.c().isString(type4) && type3.hasConstant()) {
                    if (this.c().isString(type3)) {
                        type6 = type4;
                        break;
                    }
                    if (!this.c().isWideString(type3)) break;
                    this.runtime.error("char-array initialized from wide string", node);
                    type6 = ErrorT.TYPE;
                    break;
                }
                if (!this.c().isWideString(type4) || !type3.hasConstant()) break;
                if (this.c().isString(type3)) {
                    this.runtime.error("wchar_t-array initialized from non-wide string", node);
                    type6 = ErrorT.TYPE;
                    break;
                }
                if (!this.c().isWideString(type3)) break;
                type6 = type4;
                break;
            }
            case POINTER: {
                if (type5.isPointer()) {
                    Type type7 = type4.toPointer().getType();
                    Type type8 = type5.toPointer().getType();
                    Type type9 = type7.resolve();
                    Type type10 = type8.resolve();
                    if (this.c().equal(type9, type10) || type9.isVoid() || type10.isVoid()) {
                        if (this.c().hasQualifiers(type7, type8) || this.c().isStringLiteral(type3)) {
                            type6 = type4;
                            break;
                        }
                        if (this.pedantic) {
                            this.runtime.error(string + " discards qualifiers from pointer target " + "type", node);
                            type6 = ErrorT.TYPE;
                            break;
                        }
                        this.runtime.warning(string + " discards qualifiers from pointer target " + "type", node);
                        type6 = type4;
                        break;
                    }
                    if (type9.isNumber() && type10.isNumber() && NumberT.equalIgnoringSign(type9.toNumber().getKind(), type10.toNumber().getKind())) {
                        if (this.pedantic) {
                            this.runtime.error("pointer targets in " + string + " differ in signedness", node);
                            type6 = ErrorT.TYPE;
                            break;
                        }
                        this.runtime.warning("pointer targets in " + string + " differ in signedness", node);
                        type6 = type4;
                        break;
                    }
                    if (this.pedantic) {
                        this.runtime.error("incompatible pointer types in " + string, node);
                        type6 = ErrorT.TYPE;
                        break;
                    }
                    this.runtime.warning("incompatible pointer types in " + string, node);
                    type6 = type4;
                    break;
                }
                if (type3.hasConstant() && type3.getConstant().isNull()) {
                    type6 = type4;
                    break;
                }
                if (!this.c().isIntegral(type3)) break;
                if (this.pedantic) {
                    this.runtime.error(string + " makes pointer from integer without a cast", node);
                    type6 = ErrorT.TYPE;
                    break;
                }
                this.runtime.warning(string + " makes pointer from integer without a cast", node);
                type6 = type4;
                break;
            }
            default: {
                if (!type4.isInternal() || !type5.isInternal() || !type4.toInternal().getName().equals(type5.toInternal().getName())) break;
                type6 = type4;
            }
        }
        if (null == type6) {
            this.runtime.error("incompatible types in " + string, node);
            type6 = ErrorT.TYPE;
        }
        return type6;
    }

    public void mark(Node node, Type type2) {
        if (this.runtime.test("optionMarkAST")) {
            type2.mark(node);
        }
    }

    public boolean ensureLValue(Node node, Type type2) {
        if (type2.hasError()) {
            return false;
        }
        if (!type2.hasShape()) {
            this.runtime.error("invalid operand where lvalue required", node);
            return false;
        }
        if (this.c().isIncomplete(type2)) {
            this.runtime.error("assignment of incomplete " + CAnalyzer.toDescription(node), node);
            return false;
        }
        if (!this.c().isModifiable(type2)) {
            this.runtime.error("assignment of read-only " + CAnalyzer.toDescription(node), node);
            return false;
        }
        return true;
    }

    public boolean ensureScalar(Node node, Type type2) {
        if (type2.hasError()) {
            return false;
        }
        if (!this.c().isScalar(type2)) {
            this.runtime.error("invalid " + CAnalyzer.toDescription(node) + " where scalar required", node);
            return false;
        }
        return true;
    }

    public boolean ensurePointerArithmetic(Node node, Type type2) {
        if (type2.hasError()) {
            return false;
        }
        if (type2.resolve().isPointer()) {
            Type type3 = type2.resolve().toPointer().getType();
            if (!type3.resolve().isVoid() && this.c().isIncomplete(type3)) {
                this.runtime.error("arithmetic on pointer to an incomplete type", node);
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean ensureArithmetic(Node node, Type type2) {
        if (type2.hasError()) {
            return false;
        }
        if (!this.c().isArithmetic(type2)) {
            this.runtime.error("invalid " + CAnalyzer.toDescription(node) + " where arithmetic value required", node);
            return false;
        }
        return true;
    }

    public boolean ensureInteger(Node node, Type type2) {
        if (type2.hasError()) {
            return false;
        }
        if (!this.c().isIntegral(type2)) {
            this.runtime.error("invalid " + CAnalyzer.toDescription(node) + " where integer required", node);
            return false;
        }
        return true;
    }

    public static String toDescription(Node node) {
        GNode gNode = GNode.cast(node);
        if (gNode.hasName("PrimaryIdentifier")) {
            return "variable '" + gNode.getString(0) + "'";
        }
        if (gNode.hasName("DirectComponentSelection") || gNode.hasName("IndirectComponentSelection")) {
            return "field '" + gNode.getString(1) + "'";
        }
        if (gNode.hasName("IndirectionExpression")) {
            GNode gNode2 = gNode.getGeneric(0);
            if (gNode2.hasName("PrimaryIdentifier")) {
                return "object '*" + gNode2.getString(0) + "'";
            }
            return "location";
        }
        if (gNode.hasName("TypeName")) {
            return "type name";
        }
        return "operand";
    }

    public static String toFunctionName(Node node) {
        GNode gNode = GNode.cast(node);
        if (gNode.hasName("PrimaryIdentifier")) {
            return gNode.getString(0);
        }
        if (gNode.hasName("DirectComponentSelection") || gNode.hasName("IndirectComponentSelection")) {
            return gNode.getString(1);
        }
        if (gNode.hasName("indirectionExpressiion")) {
            GNode gNode2 = gNode.getGeneric(0);
            if (gNode2.hasName("PrimaryIdentifier")) {
                return gNode2.getString(0);
            }
            return null;
        }
        return null;
    }

    public static boolean isFunctionScope(String string) {
        return SymbolTable.isFunctionScopeName(string) || SymbolTable.isMacroScopeName(string);
    }

    public Type lookupExtern(String string) {
        SymbolTable.Scope scope = this.table.getScope(EXTERN_PATH);
        return null == scope ? null : (Type)scope.lookupLocally(string);
    }

    public void defineExtern(String string, Type type2) {
        SymbolTable.Scope scope = this.table.getScope(EXTERN_PATH);
        if (null == scope) {
            SymbolTable.Scope scope2 = this.table.current();
            this.table.setScope(this.table.root());
            this.table.enter(EXTERN_SCOPE);
            scope = this.table.current();
            this.table.setScope(scope2);
        }
        scope.define(string, type2);
    }

    public void reportPrevious(String string, Type type2) {
        if (type2.hasLocation()) {
            this.runtime.errConsole().loc(type2).p(": error: previous ");
            if (type2.hasAttribute(Constants.ATT_MACRO) || type2.hasAttribute(Constants.ATT_DEFINED)) {
                this.runtime.errConsole().p("definition");
            } else {
                this.runtime.errConsole().p("declaration");
            }
            this.runtime.errConsole().p(" of '").p(string).pln("' was here").flush();
        }
    }

    public void reportPreviousTag(Type type2) {
        Tagged tagged = type2.toTagged();
        if (type2.hasLocation()) {
            this.runtime.errConsole().loc(type2).p(": error: previous ");
            if (null != tagged.getMembers()) {
                this.runtime.errConsole().p("definition");
            } else {
                this.runtime.errConsole().p("declaration");
            }
            this.runtime.errConsole().p(" of '").p(tagged.getName()).p("' was here").flush();
        }
    }

    public static class CompletenessCheck {
        public Type type;
        public String name;
        public Node node;

        public CompletenessCheck(Type type2, String string, Node node) {
            this.type = type2;
            this.name = string;
            this.node = node;
        }
    }

    public class Initializer {
        private static final int DEBUG = 0;
        private GNode node;
        private Type type;
        private boolean auto;
        private Type base;
        private Type element;
        private boolean top;
        private long index;
        private long size;
        private long count;
        private List<State> states;

        public Initializer(GNode gNode, Type type2, boolean bl) {
            this.node = gNode;
            this.type = type2;
            this.auto = bl;
            this.base = type2.resolve();
            switch (this.base.tag()) {
                case ARRAY: {
                    this.element = this.base.toArray().getType().resolve();
                    this.top = true;
                    this.size = this.getSize(this.base);
                    break;
                }
                case STRUCT: 
                case UNION: {
                    this.element = null;
                    this.top = false;
                    this.size = this.getSize(this.base);
                    break;
                }
                default: {
                    this.element = this.base;
                    this.top = true;
                    this.size = 1L;
                }
            }
            this.index = -1L;
            this.count = 0L;
            this.states = new ArrayList<State>();
        }

        Initializer(GNode gNode, Type type2, Type type3, boolean bl) {
            this.node = gNode;
            this.type = type2;
            this.auto = bl;
            this.base = type2;
            this.element = type3;
            this.top = false;
            this.size = type2 == type3 ? 1L : this.getSize(type2);
            this.index = -1L;
            this.count = 0L;
            this.states = new ArrayList<State>();
        }

        public Type process() {
            int n = this.node.size();
            block8: for (int i = 0; i < n; ++i) {
                GNode gNode = this.node.getGeneric(i);
                GNode gNode2 = gNode.getGeneric(0);
                GNode gNode3 = gNode.getGeneric(1);
                if (!this.designation(gNode2)) {
                    return this.getResult();
                }
                if (gNode3.hasName("InitializerList")) {
                    switch (this.element.tag()) {
                        case BOOLEAN: 
                        case INTEGER: 
                        case FLOAT: 
                        case POINTER: {
                            CAnalyzer.this.runtime.warning("braces around scalar initializer", gNode3);
                            new Initializer(gNode3, this.element, this.element, this.auto).process();
                            break;
                        }
                        case ARRAY: {
                            new Initializer(gNode3, this.element, this.element.toArray().getType().resolve(), this.auto).process();
                            break;
                        }
                        default: {
                            new Initializer(gNode3, this.element, null, this.auto).process();
                            break;
                        }
                    }
                    continue;
                }
                Type type2 = CAnalyzer.this.runtime.test("optionMarkAST") && gNode3.getBooleanProperty(CAnalyzer.MARKED) ? (Type)gNode3.getProperty("xtc.Constants.Type") : CAnalyzer.this.processExpression(gNode3);
                if (!(this.auto || type2.hasConstant() || CAnalyzer.this.c().hasConstRef(type2))) {
                    CAnalyzer.this.runtime.error("initializer element is not constant", gNode3);
                }
                block9: while (true) {
                    if (CAnalyzer.this.isInitializable(this.element, type2)) {
                        CAnalyzer.this.processAssignment(true, "initializer", gNode3, this.element, type2);
                        CAnalyzer.this.processStringSize(gNode3, "initializer", true, this.element, type2);
                        continue block8;
                    }
                    switch (this.element.tag()) {
                        case ARRAY: {
                            this.push(this.element);
                            continue block9;
                        }
                        case STRUCT: 
                        case UNION: {
                            if (0 == this.element.toTagged().getMemberCount()) {
                                if (this.designation(null)) continue block9;
                                return this.getResult();
                            }
                            this.push(this.element);
                            continue block9;
                        }
                    }
                    break;
                }
                CAnalyzer.this.processAssignment(true, "initializer", gNode3, this.element, type2);
            }
            if (0 == n && CAnalyzer.this.c().isScalar(this.type)) {
                CAnalyzer.this.runtime.error("empty scalar initializer", this.node);
            }
            return this.getResult();
        }

        private boolean designation(GNode gNode) {
            Iterator<Object> iterator;
            if (null == gNode) {
                while (true) {
                    ++this.index;
                    if (-1L == this.size || this.index < this.size) {
                        if (this.base.hasStructOrUnion()) {
                            this.element = this.base.toTagged().getMember((int)this.index).resolve();
                        } else if (!this.hasSize(this.type) && 0 == this.states.size() && this.top) {
                            this.count = Math.max(this.count, this.index + 1L);
                        }
                        return true;
                    }
                    if (0 == this.states.size()) {
                        GNode gNode2 = this.node.getGeneric((int)this.index);
                        if (CAnalyzer.this.pedantic) {
                            CAnalyzer.this.runtime.error("excess elements in " + CAnalyzer.this.c().toDesignation(this.base) + " initializer", gNode2);
                        } else {
                            CAnalyzer.this.runtime.warning("excess elements in " + CAnalyzer.this.c().toDesignation(this.base) + " initializer", gNode2);
                        }
                        for (int i = (int)this.index; i < this.node.size(); ++i) {
                            GNode gNode3 = this.node.getGeneric(i);
                            if (!gNode3.getGeneric(1).hasName("InitializerList")) continue;
                            CAnalyzer.this.runtime.error("extra brace group at end of initializer", gNode3);
                        }
                        return false;
                    }
                    this.pop();
                }
            }
            if (0 != this.states.size()) {
                iterator = this.states.get(0);
                this.base = ((State)((Object)iterator)).base;
                this.element = ((State)((Object)iterator)).element;
                this.top = ((State)((Object)iterator)).top;
                this.index = ((State)((Object)iterator)).index;
                this.size = ((State)((Object)iterator)).size;
                this.states.clear();
            }
            if (this.base.isArray()) {
                this.push(this.base);
            }
            iterator = gNode.hasName("Designation") ? gNode.iterator() : new SingletonIterator<GNode>(gNode);
            while (iterator.hasNext()) {
                Object object;
                GNode gNode4 = GNode.cast(iterator.next());
                if (gNode4.hasName("ObsoleteFieldDesignation") || ".".equals(gNode4.getString(0))) {
                    if (!this.base.hasStructOrUnion()) {
                        CAnalyzer.this.runtime.error("field name not in struct or union initializer", gNode4);
                        return false;
                    }
                    Object object2 = object = gNode4.hasName("ObsoleteFieldDesignation") ? gNode4.getString(0) : gNode4.getGeneric(1).getString(0);
                    if (!this.lookup((String)object)) {
                        CAnalyzer.this.runtime.error("unknown field '" + (String)object + "' in initializer", gNode4);
                        return false;
                    }
                } else {
                    long l;
                    BigInteger bigInteger;
                    Type type2;
                    if (!this.base.isArray()) {
                        CAnalyzer.this.runtime.error("array index in non-array initializer", gNode4);
                        return false;
                    }
                    object = CAnalyzer.this.processExpression(gNode4.getNode(1));
                    Type type3 = type2 = 3 == gNode4.size() ? CAnalyzer.this.processExpression(gNode4.getNode(2)) : null;
                    if (!CAnalyzer.this.c().isIntegral((Type)object) || null != type2 && !CAnalyzer.this.c().isIntegral(type2)) {
                        CAnalyzer.this.runtime.error("array index in initializer not of integer type", gNode4);
                        return false;
                    }
                    if (!((Type)object).hasConstant() || null != type2 && !type2.hasConstant()) {
                        CAnalyzer.this.runtime.error("nonconstant array index in initializer", gNode4);
                        return false;
                    }
                    BigInteger bigInteger2 = ((Type)object).getConstant().bigIntValue();
                    BigInteger bigInteger3 = bigInteger = null == type2 ? null : type2.getConstant().bigIntValue();
                    if (bigInteger2.compareTo(BigInteger.ZERO) < 0 || null != bigInteger && bigInteger.compareTo(BigInteger.ZERO) < 0) {
                        CAnalyzer.this.runtime.error("negative array index in initializer", gNode4);
                        return false;
                    }
                    if (bigInteger2.compareTo(Limits.ARRAY_MAX) > 0 || null != bigInteger && bigInteger.compareTo(Limits.ARRAY_MAX) > 0) {
                        CAnalyzer.this.runtime.error("array index in initializer is too large", gNode4);
                        return false;
                    }
                    if (null != bigInteger && bigInteger.compareTo(bigInteger2) < 0) {
                        CAnalyzer.this.runtime.error("empty index range in initializer", gNode4);
                        return false;
                    }
                    long l2 = l = null == bigInteger ? bigInteger2.longValue() : bigInteger.longValue();
                    if (-1L < this.size && l >= this.size) {
                        CAnalyzer.this.runtime.error("array index in initializer exceeds array bounds", gNode4);
                        return false;
                    }
                    if (!this.hasSize(this.type) && 0 == this.states.size() && this.top) {
                        this.count = Math.max(this.count, l + 1L);
                    }
                    this.index = l;
                }
                if (!iterator.hasNext()) continue;
                this.push(this.element);
            }
            return true;
        }

        private boolean lookup(String string) {
            this.index = -1L;
            for (VariableT variableT : this.base.toStructOrUnion().getMembers()) {
                if (variableT.hasName()) {
                    ++this.index;
                    if (!variableT.hasName(string)) continue;
                    this.element = variableT.resolve();
                    return true;
                }
                if (variableT.hasWidth()) continue;
                ++this.index;
                this.element = variableT.resolve();
                this.push(this.element);
                if (this.lookup(string)) {
                    return true;
                }
                this.pop();
            }
            return false;
        }

        private void push(Type type2) {
            State state = new State(this.base, this.element, this.top, this.index, this.size);
            this.states.add(state);
            this.base = type2;
            switch (type2.tag()) {
                case ARRAY: {
                    this.element = type2.toArray().getType().resolve();
                    break;
                }
                case STRUCT: 
                case UNION: {
                    this.element = type2.toTagged().getMember(0).resolve();
                    break;
                }
                default: {
                    this.element = type2;
                }
            }
            this.top = false;
            this.index = 0L;
            this.size = this.getSize(type2);
        }

        private void pop() {
            assert (0 != this.states.size()) : "Empty initializer type stack";
            State state = this.states.remove(this.states.size() - 1);
            this.base = state.base;
            this.element = state.element;
            this.top = state.top;
            this.index = state.index;
            this.size = state.size;
        }

        private Type getResult() {
            if (!this.hasSize(this.type) && (0 == this.states.size() && this.top || 0 < this.states.size() && this.states.get((int)0).top)) {
                this.type = this.type.copy();
                this.type.resolve().toArray().setLength(this.count);
            }
            return this.type;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (State state : this.states) {
                if (state.base == state.element) continue;
                if (state.base.isArray()) {
                    stringBuilder.append('[');
                    stringBuilder.append(state.index);
                    stringBuilder.append(']');
                    continue;
                }
                if (!state.base.hasStructOrUnion()) continue;
                VariableT variableT = state.base.toTagged().getMember((int)state.index).toVariable();
                if (variableT.hasName()) {
                    stringBuilder.append('.');
                    stringBuilder.append(variableT.getName());
                    continue;
                }
                stringBuilder.append(".<anon>");
            }
            if (this.base != this.element && -1L != this.index) {
                if (this.base.isArray()) {
                    stringBuilder.append('[');
                    stringBuilder.append(this.index);
                    stringBuilder.append(']');
                } else if (this.base.hasStructOrUnion()) {
                    VariableT variableT = this.base.toTagged().getMember((int)this.index).toVariable();
                    if (variableT.hasName()) {
                        stringBuilder.append('.');
                        stringBuilder.append(variableT.getName());
                    } else {
                        stringBuilder.append(".<anon>");
                    }
                }
            }
            if (this.base == this.element && 0 == this.states.size()) {
                stringBuilder.append("<obj>");
            }
            return stringBuilder.toString();
        }

        private boolean hasSize(Type type2) {
            return !type2.hasTag(Type.Tag.ARRAY) || type2.resolve().toArray().hasLength();
        }

        private long getSize(Type type2) {
            switch (type2.tag()) {
                case ARRAY: {
                    return type2.toArray().getLength();
                }
                case STRUCT: {
                    return type2.toTagged().getMemberCount();
                }
                case UNION: {
                    return 0 < type2.toTagged().getMemberCount() ? 1L : 0L;
                }
            }
            return 1L;
        }
    }

    static class State {
        public Type base;
        public Type element;
        public boolean top;
        public long index;
        public long size;

        public State(Type type2, Type type3, boolean bl, long l, long l2) {
            this.base = type2;
            this.element = type3;
            this.top = bl;
            this.index = l;
            this.size = l2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Specifiers
    extends Visitor {
        protected GNode specifiers;
        protected boolean refIsDecl;
        protected Type type;
        private Attribute storage;
        private Attribute function;
        private List<Attribute> attributes;
        private boolean seenSigned;
        private boolean seenUnsigned;
        private boolean seenBool;
        private boolean seenChar;
        private boolean seenShort;
        private boolean seenInt;
        private int longCount;
        private boolean seenFloat;
        private boolean seenDouble;
        private boolean seenComplex;

        public Specifiers(GNode gNode, boolean bl) {
            this.specifiers = gNode;
            this.refIsDecl = bl;
            if (null != gNode) {
                for (Object object : gNode) {
                    this.dispatch((Node)object);
                }
            }
            if (null == this.type) {
                this.type = this.seenBool ? BooleanT.TYPE : (this.seenChar ? (this.seenUnsigned ? NumberT.U_CHAR : (this.seenSigned ? NumberT.S_CHAR : NumberT.CHAR)) : (this.seenShort ? (this.seenUnsigned ? NumberT.U_SHORT : NumberT.SHORT) : (this.seenFloat ? (this.seenComplex ? NumberT.FLOAT_COMPLEX : NumberT.FLOAT) : (this.seenDouble ? (0 < this.longCount ? (this.seenComplex ? NumberT.LONG_DOUBLE_COMPLEX : NumberT.LONG_DOUBLE) : (this.seenComplex ? NumberT.DOUBLE_COMPLEX : NumberT.DOUBLE)) : (1 == this.longCount ? (this.seenUnsigned ? NumberT.U_LONG : NumberT.LONG) : (1 < this.longCount ? (this.seenUnsigned ? NumberT.U_LONG_LONG : NumberT.LONG_LONG) : (this.seenUnsigned ? NumberT.U_INT : (this.seenSigned ? NumberT.S_INT : (this.seenInt ? NumberT.INT : C.IMPLICIT)))))))));
            }
            if (!this.type.hasError() && null != this.attributes) {
                this.type = this.type.annotate().attribute(this.attributes);
            }
            this.type.seal();
        }

        public Type getBaseType() {
            return this.type;
        }

        public boolean isDefault() {
            return this.type.hasTag(Type.Tag.INTEGER) && this.type.resolve().hasAttribute(Constants.ATT_IMPLICIT);
        }

        public boolean contains(Attribute attribute) {
            if (null != this.attributes && this.attributes.contains(attribute)) {
                return true;
            }
            if (attribute.equals(this.storage)) {
                return true;
            }
            return attribute.equals(this.function);
        }

        public boolean hasBaseAttributes() {
            return null != this.attributes;
        }

        public boolean hasInline() {
            return null != this.function;
        }

        public Attribute getStorageClass() {
            return this.storage;
        }

        public Type annotateBase(Type type2) {
            return null != this.attributes ? type2.attribute(this.attributes) : type2;
        }

        public Type annotateFull(Type type2) {
            if (null != this.storage || null != this.function) {
                if (this.type == type2) {
                    type2 = type2.annotate();
                }
                if (null != this.storage) {
                    type2 = type2.attribute(this.storage);
                }
                if (null != this.function) {
                    type2 = type2.attribute(this.function);
                }
            }
            return type2;
        }

        protected void add(Attribute attribute) {
            if (null == this.attributes) {
                this.attributes = new ArrayList<Attribute>();
                this.attributes.add(attribute);
            } else if (!this.attributes.contains(attribute)) {
                this.attributes.add(attribute);
            }
        }

        protected boolean testStorageClass() {
            if (null == this.storage) {
                return false;
            }
            CAnalyzer.this.runtime.error("multiple storage classes in declaration specifiers", this.specifiers);
            return true;
        }

        protected boolean hasType() {
            return this.seenBool || this.seenChar || this.seenShort || this.seenInt || 0 < this.longCount || this.seenFloat || this.seenDouble || this.seenComplex || null != this.type;
        }

        protected void multipleTypes() {
            CAnalyzer.this.runtime.error("multiple data types in declaration specifiers", this.specifiers);
            this.type = ErrorT.TYPE;
        }

        public void visitAutoSpecifier(GNode gNode) {
            if (Constants.ATT_STORAGE_AUTO.equals(this.storage)) {
                CAnalyzer.this.runtime.error("duplicate 'auto'", gNode);
            } else if (!this.testStorageClass()) {
                this.storage = Constants.ATT_STORAGE_AUTO;
            }
        }

        public void visitExternSpecifier(GNode gNode) {
            if (Constants.ATT_STORAGE_EXTERN.equals(this.storage)) {
                CAnalyzer.this.runtime.error("duplicate 'extern'", gNode);
            } else if (!this.testStorageClass()) {
                this.storage = Constants.ATT_STORAGE_EXTERN;
            }
        }

        public void visitRegisterSpecifier(GNode gNode) {
            if (Constants.ATT_STORAGE_REGISTER.equals(this.storage)) {
                CAnalyzer.this.runtime.error("duplicate 'register'", gNode);
            } else if (!this.testStorageClass()) {
                this.storage = Constants.ATT_STORAGE_REGISTER;
            }
        }

        public void visitStaticSpecifier(GNode gNode) {
            if (Constants.ATT_STORAGE_STATIC.equals(this.storage)) {
                CAnalyzer.this.runtime.error("duplicate 'static'", gNode);
            } else if (!this.testStorageClass()) {
                this.storage = Constants.ATT_STORAGE_STATIC;
            }
        }

        public void visitTypedefSpecifier(GNode gNode) {
            if (Constants.ATT_STORAGE_TYPEDEF.equals(this.storage)) {
                CAnalyzer.this.runtime.error("duplicate 'typedef'", gNode);
            } else if (!this.testStorageClass()) {
                this.storage = Constants.ATT_STORAGE_TYPEDEF;
            }
        }

        public void visitTypeofSpecifier(GNode gNode) {
            if (this.hasType()) {
                this.multipleTypes();
            } else {
                this.type = CAnalyzer.this.processExpression(gNode.getNode(0));
                this.type = this.type.hasEnum() ? CAnalyzer.this.c().qualify(this.type.toEnum(), this.type) : CAnalyzer.this.c().qualify(this.type.resolve(), this.type);
            }
        }

        public void visitVolatileQualifier(GNode gNode) {
            this.add(Constants.ATT_VOLATILE);
        }

        public void visitConstantQualifier(GNode gNode) {
            this.add(Constants.ATT_CONSTANT);
        }

        public void visitRestrictQualifier(GNode gNode) {
            this.add(Constants.ATT_RESTRICT);
        }

        public void visitFunctionSpecifier(GNode gNode) {
            if (null == this.function) {
                this.function = Constants.ATT_INLINE;
            }
        }

        public void visitSigned(GNode gNode) {
            if (this.seenUnsigned) {
                this.seenSigned = true;
                CAnalyzer.this.runtime.error("both 'signed' and 'unsigned' in declaration specifiers", this.specifiers);
            } else if (this.seenSigned) {
                CAnalyzer.this.runtime.error("duplicate 'signed'", gNode);
            } else {
                this.seenSigned = true;
            }
        }

        public void visitUnsigned(GNode gNode) {
            if (this.seenSigned) {
                this.seenUnsigned = true;
                CAnalyzer.this.runtime.error("both 'signed' and 'unsigned' in declaration specifiers", this.specifiers);
            } else if (this.seenUnsigned) {
                CAnalyzer.this.runtime.error("duplicate 'unsigned'", gNode);
            } else {
                this.seenUnsigned = true;
            }
        }

        public void visitBool(GNode gNode) {
            if (this.hasType()) {
                this.multipleTypes();
            } else {
                this.seenBool = true;
            }
        }

        public void visitChar(GNode gNode) {
            if (this.hasType()) {
                this.multipleTypes();
            } else {
                this.seenChar = true;
            }
        }

        public void visitShort(GNode gNode) {
            if (this.seenBool || this.seenChar || this.seenShort || 0 < this.longCount || this.seenFloat || this.seenDouble || this.seenComplex || null != this.type) {
                this.multipleTypes();
            } else {
                this.seenShort = true;
            }
        }

        public void visitInt(GNode gNode) {
            if (this.seenBool || this.seenChar || this.seenInt || this.seenFloat || this.seenDouble || this.seenComplex || null != this.type) {
                this.multipleTypes();
            } else {
                this.seenInt = true;
            }
        }

        public void visitLong(GNode gNode) {
            if (this.seenBool || this.seenChar || this.seenShort || 1 < this.longCount || this.seenFloat || (this.seenDouble || this.seenComplex) && 0 < this.longCount || null != this.type) {
                this.multipleTypes();
            } else {
                ++this.longCount;
            }
        }

        public void visitFloat(GNode gNode) {
            if (this.seenBool || this.seenChar || this.seenShort || this.seenInt || 0 < this.longCount || this.seenDouble || null != this.type) {
                this.multipleTypes();
            } else {
                this.seenFloat = true;
            }
        }

        public void visitDouble(GNode gNode) {
            if (this.seenBool || this.seenChar || this.seenShort || this.seenInt || 1 < this.longCount || this.seenFloat || null != this.type) {
                this.multipleTypes();
            } else {
                this.seenDouble = true;
            }
        }

        public void visitComplex(GNode gNode) {
            if (this.seenBool || this.seenChar || this.seenShort || this.seenInt || 1 < this.longCount || null != this.type) {
                this.multipleTypes();
            } else {
                this.seenComplex = true;
            }
        }

        private void checkNotParameter(Node node, String string) {
            if (CAnalyzer.TMP_SCOPE.equals(CAnalyzer.this.table.current().getName())) {
                String string2 = node.getString(1);
                String string3 = null == string2 ? "anonymous " + string + " declared inside parameter list" : "'" + string + " " + string2 + "' declared inside parameter list";
                CAnalyzer.this.runtime.warning(string3, node);
            }
        }

        private List<VariableT> processMembers(GNode gNode, boolean bl) {
            int n = gNode.size() - 1;
            ArrayList<VariableT> arrayList = new ArrayList<VariableT>(n);
            HashSet<String> hashSet = new HashSet<String>();
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                Object object;
                Object object2;
                GNode gNode2 = gNode.getGeneric(i);
                GNode gNode3 = gNode2.getGeneric(1);
                Specifiers specifiers = CAnalyzer.this.newSpecifiers(gNode3, false);
                if (null == gNode2.get(2)) {
                    object2 = specifiers.annotateFull(specifiers.getBaseType());
                    if (((Type)object2).hasStructOrUnion() && ((Type)object2).toTagged().isUnnamed() && !CAnalyzer.this.pedantic) {
                        if (CAnalyzer.this.c().isIncomplete((Type)object2)) {
                            object = ((Type)object2).hasTag(Type.Tag.STRUCT) ? "struct" : "union";
                            CAnalyzer.this.runtime.error("unnamed " + (String)object + " has incomplete type", gNode2);
                        } else if (CAnalyzer.this.c().hasTrailingArray((Type)object2)) {
                            CAnalyzer.this.runtime.error("unnamed struct ends with flexible array member", gNode2);
                        }
                        arrayList.add(VariableT.newField((Type)object2, null));
                        continue;
                    }
                    CAnalyzer.this.runtime.warning("declaration does not declare anything", gNode2);
                    continue;
                }
                object2 = gNode2.getGeneric(2).iterator();
                while (object2.hasNext()) {
                    Object object3;
                    Type type2;
                    object = GNode.cast(object2.next());
                    GNode gNode4 = object;
                    boolean bl2 = ((GNode)object).hasName("BitField");
                    GNode gNode5 = null;
                    int n3 = -1;
                    if (bl2) {
                        gNode5 = ((Node)object).getGeneric(2);
                        object = ((Node)object).getGeneric(1);
                    }
                    GNode gNode6 = CAnalyzer.getDeclaredId((GNode)object);
                    String string = null;
                    if (null != gNode6) {
                        ++n2;
                        string = gNode6.getString(0);
                    }
                    Type type3 = CAnalyzer.this.getDeclaredType(specifiers.getBaseType(), (GNode)object);
                    type3 = specifiers.annotateFull(type3);
                    if (bl2) {
                        Type type4;
                        type2 = type3.resolve();
                        Object object4 = object3 = type2.isInteger() ? type2.toInteger().getKind() : null;
                        if (!type2.isBoolean() && (!type2.isInteger() || type2.isInteger() && CAnalyzer.this.pedantic && !NumberT.equal(NumberT.Kind.INT, (NumberT.Kind)((Object)object3)) && !NumberT.equal(NumberT.Kind.U_INT, (NumberT.Kind)((Object)object3)))) {
                            if (null == gNode6) {
                                CAnalyzer.this.runtime.error("bit-field has invalid type", gNode4);
                            } else {
                                CAnalyzer.this.runtime.error("bit-field '" + string + "' has invalid type", gNode4);
                            }
                        }
                        if ((type4 = CAnalyzer.this.processExpression(gNode5)).hasError()) {
                            n3 = 0;
                        } else if (!type4.hasConstant() || !CAnalyzer.this.c().isIntegral(type4)) {
                            if (null == gNode6) {
                                CAnalyzer.this.runtime.error("bit-field width not an integer constant", gNode5);
                            } else {
                                CAnalyzer.this.runtime.error("bit-field '" + string + "' width not an integer constant", gNode5);
                            }
                            n3 = 0;
                        } else if (CAnalyzer.this.c().isIntegral(type2)) {
                            BigInteger bigInteger;
                            int n4 = (int)CAnalyzer.this.c().getWidth(type2);
                            try {
                                bigInteger = type4.getConstant().bigIntValue();
                            }
                            catch (IllegalStateException illegalStateException) {
                                if (null == gNode6) {
                                    CAnalyzer.this.runtime.error("can't compute width in bit-field", gNode5);
                                } else {
                                    CAnalyzer.this.runtime.error("can't compute width in bit-field '" + string + "'", gNode5);
                                }
                                bigInteger = BigInteger.ZERO;
                            }
                            if (bigInteger.compareTo(BigInteger.valueOf(n4)) > 0) {
                                if (null == gNode6) {
                                    CAnalyzer.this.runtime.error("bit-field width exceeds its type", gNode5);
                                } else {
                                    CAnalyzer.this.runtime.error("bit-field '" + string + "' width exceeds its type", gNode5);
                                }
                                n3 = n4;
                            } else if (bigInteger.compareTo(BigInteger.ZERO) < 0) {
                                if (null == gNode6) {
                                    CAnalyzer.this.runtime.error("negative width in bit-field", gNode5);
                                } else {
                                    CAnalyzer.this.runtime.error("negative width in bit-field '" + string + "'", gNode5);
                                }
                                n3 = 0;
                            } else if (bigInteger.compareTo(BigInteger.ZERO) == 0) {
                                if (null != gNode6) {
                                    CAnalyzer.this.runtime.error("zero width for bit-field '" + string + "'", gNode5);
                                }
                                n3 = 0;
                            } else {
                                n3 = bigInteger.intValue();
                            }
                        } else {
                            n3 = 0;
                        }
                    } else {
                        type2 = type3.resolve();
                        if (CAnalyzer.this.checkType(gNode2, string, type3)) {
                            if (type2.isFunction()) {
                                CAnalyzer.this.runtime.error("field '" + string + "' declared as a function", gNode2);
                            } else if (type2.isArray()) {
                                object3 = type2.toArray();
                                if (CAnalyzer.this.c().isIncomplete(((ArrayT)object3).getType()) || CAnalyzer.this.c().hasTrailingArray(((ArrayT)object3).getType())) {
                                    CAnalyzer.this.runtime.error("field '" + string + "' has array with incomplete element type", gNode2);
                                } else if (((ArrayT)object3).isVarLength()) {
                                    if (CAnalyzer.this.pedantic) {
                                        CAnalyzer.this.runtime.error("field '" + string + "' has variable length " + "array type", gNode2);
                                    } else if (CAnalyzer.this.isTopLevel && !CAnalyzer.TMP_SCOPE.equals(CAnalyzer.this.table.current().getName())) {
                                        CAnalyzer.this.runtime.error("variable length array type declared outside of any function", gNode2);
                                    }
                                } else if (!((ArrayT)object3).hasLength()) {
                                    if (!bl) {
                                        CAnalyzer.this.runtime.error("flexible array member '" + string + "' in union", gNode2);
                                    } else if (i < n - 1 || object2.hasNext()) {
                                        CAnalyzer.this.runtime.error("flexible array member '" + string + "' not at end of struct", gNode2);
                                    } else if (1 >= n2) {
                                        CAnalyzer.this.runtime.error("flexible array member '" + string + "' in otherwise empty struct", gNode2);
                                    }
                                }
                            } else if (CAnalyzer.this.c().isIncomplete(type3)) {
                                if (type2.isVoid()) {
                                    CAnalyzer.this.runtime.error("field '" + string + "' declared void", gNode2);
                                } else {
                                    CAnalyzer.this.runtime.error("field '" + string + "' has incomplete type", gNode2);
                                }
                            } else if (CAnalyzer.this.c().hasTrailingArray(type3)) {
                                if (CAnalyzer.this.pedantic) {
                                    CAnalyzer.this.runtime.error("field '" + string + "' has struct with flexible array member", gNode2);
                                }
                            } else if (CAnalyzer.this.c().isVariablyModified(type3)) {
                                if (CAnalyzer.this.pedantic) {
                                    CAnalyzer.this.runtime.error("field '" + string + "' has variably modified " + "type", gNode2);
                                } else if (CAnalyzer.this.isTopLevel && !CAnalyzer.TMP_SCOPE.equals(CAnalyzer.this.table.current().getName())) {
                                    CAnalyzer.this.runtime.error("variably modified type declared outside of any function", gNode2);
                                }
                            }
                        }
                    }
                    if (hashSet.contains(string)) {
                        CAnalyzer.this.runtime.error("duplicate member '" + string + "'", gNode4);
                        continue;
                    }
                    if (null != string) {
                        hashSet.add(string);
                    }
                    if (-1 == n3) {
                        arrayList.add(VariableT.newField(type3, string));
                        continue;
                    }
                    arrayList.add(VariableT.newBitfield(type3, string, n3));
                }
            }
            return arrayList;
        }

        public void visitStructureTypeDefinition(GNode gNode) {
            if (this.hasType()) {
                this.multipleTypes();
            } else {
                Object object;
                String string = gNode.getString(1);
                String string2 = null == string ? (string = CAnalyzer.this.table.freshName("tag")) : SymbolTable.toTagName(string);
                if (CAnalyzer.this.table.current().isDefinedLocally(string2)) {
                    object = (Type)CAnalyzer.this.table.current().lookupLocally(string2);
                    if (!((Type)object).isStruct()) {
                        CAnalyzer.this.runtime.error("'" + string + "' defined as wrong kind of tag", gNode);
                        CAnalyzer.this.reportPreviousTag((Type)object);
                        this.type = ErrorT.TYPE;
                        return;
                    }
                    if (null != ((Type)object).toTagged().getMembers()) {
                        CAnalyzer.this.runtime.error("redefinition of 'struct " + string + "'", gNode);
                        CAnalyzer.this.reportPreviousTag((Type)object);
                        this.type = ErrorT.TYPE;
                        return;
                    }
                    if (((Type)object).hasAttribute(Constants.ATT_DEFINED)) {
                        CAnalyzer.this.runtime.error("nested redefinition of 'struct " + string + "'", gNode);
                        this.type = ErrorT.TYPE;
                        return;
                    }
                    this.type = object;
                } else {
                    this.checkNotParameter(gNode, "struct");
                    this.type = new StructT(string);
                    CAnalyzer.this.table.current().define(string2, this.type);
                }
                this.type.setLocation(gNode);
                for (Attribute attribute : CAnalyzer.this.toAttributeList(gNode.getGeneric(0))) {
                    this.type.addAttribute(attribute);
                }
                for (Attribute attribute : CAnalyzer.this.toAttributeList(gNode.getGeneric(3))) {
                    this.type.addAttribute(attribute);
                }
                this.type.addAttribute(Constants.ATT_DEFINED);
                object = this.processMembers(gNode.getGeneric(2), true);
                this.type.toStruct().setMembers((List<VariableT>)object);
                this.type.removeAttribute(Constants.ATT_DEFINED);
                this.type.seal();
            }
        }

        public void visitStructureTypeReference(GNode gNode) {
            if (this.hasType()) {
                this.multipleTypes();
            } else {
                String string = gNode.getString(1);
                String string2 = SymbolTable.toTagName(string);
                if (this.refIsDecl && CAnalyzer.this.table.current().isDefinedLocally(string2) || !this.refIsDecl && CAnalyzer.this.table.isDefined(string2)) {
                    Type type2 = (Type)CAnalyzer.this.table.lookup(string2);
                    if (!type2.isStruct()) {
                        CAnalyzer.this.runtime.error("'" + string + "' defined as wrong kind of tag", gNode);
                        CAnalyzer.this.reportPreviousTag(type2);
                        this.type = ErrorT.TYPE;
                    } else {
                        this.type = type2;
                        if (this.refIsDecl && null == this.type.toStruct().getMembers()) {
                            this.type.setLocation(gNode);
                            for (Attribute attribute : CAnalyzer.this.toAttributeList(gNode.getGeneric(0))) {
                                this.type.addAttribute(attribute);
                            }
                        }
                    }
                } else {
                    this.checkNotParameter(gNode, "struct");
                    this.type = new StructT(string).locate(gNode);
                    for (Attribute attribute : CAnalyzer.this.toAttributeList(gNode.getGeneric(0))) {
                        this.type.addAttribute(attribute);
                    }
                    CAnalyzer.this.table.current().define(string2, this.type);
                }
            }
        }

        public void visitUnionTypeDefinition(GNode gNode) {
            if (this.hasType()) {
                this.multipleTypes();
            } else {
                Object object;
                String string = gNode.getString(1);
                String string2 = null == string ? (string = CAnalyzer.this.table.freshName("tag")) : SymbolTable.toTagName(string);
                if (CAnalyzer.this.table.current().isDefinedLocally(string2)) {
                    object = (Type)CAnalyzer.this.table.current().lookupLocally(string2);
                    if (!((Type)object).isUnion()) {
                        CAnalyzer.this.runtime.error("'" + string + "' defined as wrong kind of tag", gNode);
                        CAnalyzer.this.reportPreviousTag((Type)object);
                        this.type = ErrorT.TYPE;
                        return;
                    }
                    if (null != ((Type)object).toTagged().getMembers()) {
                        CAnalyzer.this.runtime.error("redefinition of 'union " + string + "'", gNode);
                        CAnalyzer.this.reportPreviousTag((Type)object);
                        this.type = ErrorT.TYPE;
                        return;
                    }
                    if (((Type)object).hasAttribute(Constants.ATT_DEFINED)) {
                        CAnalyzer.this.runtime.error("nested redefinition of 'union " + string + "'", gNode);
                        this.type = ErrorT.TYPE;
                        return;
                    }
                    this.type = object;
                } else {
                    this.checkNotParameter(gNode, "union");
                    this.type = new UnionT(string);
                    CAnalyzer.this.table.current().define(string2, this.type);
                }
                this.type.setLocation(gNode);
                for (Attribute attribute : CAnalyzer.this.toAttributeList(gNode.getGeneric(0))) {
                    this.type.addAttribute(attribute);
                }
                for (Attribute attribute : CAnalyzer.this.toAttributeList(gNode.getGeneric(3))) {
                    this.type.addAttribute(attribute);
                }
                this.type.addAttribute(Constants.ATT_DEFINED);
                object = this.processMembers(gNode.getGeneric(2), false);
                this.type.toUnion().setMembers((List<VariableT>)object);
                this.type.removeAttribute(Constants.ATT_DEFINED);
                this.type.seal();
            }
        }

        public void visitUnionTypeReference(GNode gNode) {
            if (this.hasType()) {
                this.multipleTypes();
            } else {
                String string = gNode.getString(1);
                String string2 = SymbolTable.toTagName(string);
                if (this.refIsDecl && CAnalyzer.this.table.current().isDefinedLocally(string2) || !this.refIsDecl && CAnalyzer.this.table.isDefined(string2)) {
                    Type type2 = (Type)CAnalyzer.this.table.lookup(string2);
                    if (!type2.isUnion()) {
                        CAnalyzer.this.runtime.error("'" + string + "' defined as wrong kind of tag", gNode);
                        CAnalyzer.this.reportPreviousTag(type2);
                        this.type = ErrorT.TYPE;
                    } else {
                        this.type = type2;
                        if (this.refIsDecl && null == this.type.toUnion().getMembers()) {
                            this.type.setLocation(gNode);
                            for (Attribute attribute : CAnalyzer.this.toAttributeList(gNode.getGeneric(0))) {
                                this.type.addAttribute(attribute);
                            }
                        }
                    }
                } else {
                    this.checkNotParameter(gNode, "union");
                    this.type = new UnionT(string).locate(gNode);
                    for (Attribute attribute : CAnalyzer.this.toAttributeList(gNode.getGeneric(0))) {
                        this.type.addAttribute(attribute);
                    }
                    CAnalyzer.this.table.current().define(string2, this.type);
                }
            }
        }

        public void visitEnumerationTypeDefinition(GNode gNode) {
            if (this.hasType()) {
                this.multipleTypes();
            } else {
                Object object2;
                Object object322;
                Node node;
                String string = gNode.getString(1);
                String string2 = null == string ? (string = CAnalyzer.this.table.freshName("tag")) : SymbolTable.toTagName(string);
                if (CAnalyzer.this.table.current().isDefinedLocally(string2)) {
                    node = (Type)CAnalyzer.this.table.current().lookupLocally(string2);
                    if (!((Type)node).isEnum()) {
                        CAnalyzer.this.runtime.error("'" + string + "' defined as wrong kind of tag", gNode);
                        CAnalyzer.this.reportPreviousTag((Type)node);
                        this.type = ErrorT.TYPE;
                        return;
                    }
                    if (null != ((Type)node).toTagged().getMembers()) {
                        CAnalyzer.this.runtime.error("redefinition of 'enum " + string + "'", gNode);
                        CAnalyzer.this.reportPreviousTag((Type)node);
                        this.type = ErrorT.TYPE;
                        return;
                    }
                    this.type = node;
                } else {
                    this.checkNotParameter(gNode, "enum");
                    this.type = new EnumT(string);
                }
                node = gNode.getGeneric(2);
                ArrayList<EnumeratorT> arrayList = new ArrayList<EnumeratorT>(node.size());
                BigInteger bigInteger = BigInteger.ONE.negate();
                for (Object object322 : node) {
                    Type type2;
                    object2 = GNode.cast(object322);
                    String object4 = ((Node)object2).getString(0);
                    Node node2 = ((Node)object2).getNode(1);
                    BigInteger bigInteger2 = null;
                    if (null != node2 && !(type2 = CAnalyzer.this.processExpression(node2)).hasError()) {
                        if (!type2.hasConstant() || !CAnalyzer.this.c().isIntegral(type2)) {
                            CAnalyzer.this.runtime.error("enumerator value for '" + object4 + "' is not an integer constant", node2);
                        } else {
                            try {
                                bigInteger = bigInteger2 = type2.getConstant().bigIntValue();
                            }
                            catch (IllegalStateException illegalStateException) {
                                CAnalyzer.this.runtime.warning("can't compute value for '" + object4 + "'", node2);
                                bigInteger = bigInteger2 = bigInteger.add(BigInteger.ONE);
                            }
                        }
                    }
                    if (null == bigInteger2) {
                        bigInteger = bigInteger2 = bigInteger.add(BigInteger.ONE);
                    }
                    type2 = new EnumeratorT(CAnalyzer.this.c().fit(bigInteger2), object4, bigInteger2);
                    if (CAnalyzer.this.table.current().isDefinedLocally(object4)) {
                        CAnalyzer.this.runtime.error("redefinition of '" + object4 + "'", (Node)object2);
                    } else {
                        CAnalyzer.this.table.current().define(object4, type2);
                    }
                    arrayList.add((EnumeratorT)type2);
                }
                Object object5 = BigInteger.ZERO;
                object322 = BigInteger.ZERO;
                for (EnumeratorT enumeratorT : arrayList) {
                    BigInteger bigInteger3 = enumeratorT.getConstant().bigIntValue();
                    if (bigInteger3.compareTo((BigInteger)object5) < 0) {
                        object5 = bigInteger3;
                    }
                    if (bigInteger3.compareTo((BigInteger)object322) <= 0) continue;
                    object322 = bigInteger3;
                }
                if (Limits.fitsInt((BigInteger)object5) && Limits.fitsInt((BigInteger)object322)) {
                    object2 = NumberT.INT;
                } else if (Limits.fitsUnsignedInt((BigInteger)object5) && Limits.fitsUnsignedInt((BigInteger)object322)) {
                    object2 = NumberT.U_INT;
                } else if (Limits.fitsLong((BigInteger)object5) && Limits.fitsLong((BigInteger)object322)) {
                    object2 = NumberT.LONG;
                } else if (Limits.fitsUnsignedLong((BigInteger)object5) && Limits.fitsUnsignedLong((BigInteger)object322)) {
                    object2 = NumberT.U_LONG;
                } else if (Limits.fitsLongLong((BigInteger)object5) && Limits.fitsLongLong((BigInteger)object322)) {
                    object2 = NumberT.LONG_LONG;
                } else if (Limits.fitsUnsignedLongLong((BigInteger)object5) && Limits.fitsUnsignedLongLong((BigInteger)object322)) {
                    object2 = NumberT.U_LONG_LONG;
                } else {
                    CAnalyzer.this.runtime.error("enumeration values exceed range of largest integer", gNode);
                    object2 = ErrorT.TYPE;
                }
                ((EnumT)this.type).setMembers(arrayList);
                ((EnumT)this.type).setType((Type)object2);
                this.type.setLocation(gNode);
                for (Attribute attribute : CAnalyzer.this.toAttributeList(gNode.getGeneric(0))) {
                    this.type.addAttribute(attribute);
                }
                for (Attribute attribute : CAnalyzer.this.toAttributeList(gNode.getGeneric(3))) {
                    this.type.addAttribute(attribute);
                }
                this.type.seal();
                CAnalyzer.this.table.current().define(string2, this.type);
            }
        }

        public void visitEnumerationTypeReference(GNode gNode) {
            if (this.hasType()) {
                this.multipleTypes();
            } else {
                String string = gNode.getString(1);
                String string2 = SymbolTable.toTagName(string);
                if (CAnalyzer.this.table.isDefined(string2)) {
                    Type type2 = (Type)CAnalyzer.this.table.lookup(string2);
                    if (!type2.isEnum()) {
                        CAnalyzer.this.runtime.error("'" + string + "' defined as wrong kind of tag", gNode);
                        CAnalyzer.this.reportPreviousTag(type2);
                        this.type = ErrorT.TYPE;
                    } else {
                        this.type = type2;
                        if (null == this.type.toEnum().getMembers()) {
                            this.type.setLocation(gNode);
                            for (Attribute attribute : CAnalyzer.this.toAttributeList(gNode.getGeneric(0))) {
                                this.type.addAttribute(attribute);
                            }
                        }
                    }
                } else {
                    this.checkNotParameter(gNode, "enum");
                    this.type = new EnumT(string).locate(gNode);
                    for (Attribute attribute : CAnalyzer.this.toAttributeList(gNode.getGeneric(0))) {
                        this.type.addAttribute(attribute);
                    }
                    CAnalyzer.this.table.current().define(string2, this.type);
                }
            }
        }

        public void visitVoidTypeSpecifier(GNode gNode) {
            if (this.hasType()) {
                this.multipleTypes();
            } else {
                this.type = VoidT.TYPE;
            }
        }

        public void visitVarArgListSpecifier(GNode gNode) {
            if (this.hasType()) {
                this.multipleTypes();
            } else {
                this.type = InternalT.VA_LIST;
            }
        }

        public void visitTypedefName(GNode gNode) {
            if (this.hasType()) {
                this.multipleTypes();
            } else {
                String string = gNode.getString(0);
                Type type2 = (Type)CAnalyzer.this.table.current().lookup(string);
                if (null != type2 && type2.isAlias()) {
                    this.type = type2;
                } else {
                    CAnalyzer.this.runtime.error("typedef name '" + string + "' undefined", gNode);
                    this.type = ErrorT.TYPE;
                }
            }
        }

        public void visitAttributeSpecifier(GNode gNode) {
            List<Attribute> list = CAnalyzer.this.toAttributeList(gNode);
            if (!list.isEmpty()) {
                if (null == this.attributes) {
                    this.attributes = list;
                } else {
                    this.attributes.addAll(list);
                }
            }
        }
    }
}

