/*
 * Decompiled with CFR 0.152.
 */
package xtc.lang;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import xtc.lang.CAnalyzer;
import xtc.lang.CCounter;
import xtc.lang.CParser;
import xtc.lang.CPrinter;
import xtc.lang.CReader;
import xtc.parser.ParseException;
import xtc.parser.Result;
import xtc.tree.Formatting;
import xtc.tree.GNode;
import xtc.tree.Location;
import xtc.tree.Node;
import xtc.tree.ParseTreePrinter;
import xtc.tree.ParseTreeStripper;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.type.CFactory;
import xtc.type.TypePrinter;
import xtc.util.SymbolTable;
import xtc.util.Tool;

public class C
extends Tool {
    protected Method profile;
    protected Method dump;

    public String getName() {
        return "xtc C Tool";
    }

    public String getCopy() {
        return "(C) 2004-2008 Robert Grimm";
    }

    public void init() {
        super.init();
        this.runtime.bool("parsetree", "optionParseTree", false, "Generate a parse tree.").bool("noincr", "optionNoIncr", false, "Do not parse incrementally.").bool("memoProfile", "printMemoProfile", false, "Print profile of parser's memoization table.").bool("memoTable", "printMemoTable", false, "Print parser's memoization table.").bool("analyze", "optionAnalyze", false, "Analyze the program's AST.").bool("typical", "optionTypical", false, "Use the Typical-generated analyzer.").bool("pedantic", "optionPedantic", false, "Enforce strict C99 compliance.").bool("builtins", "optionBuiltIns", false, "Declare C built-ins before analysis.").bool("markAST", "optionMarkAST", false, "Mark AST nodes with types.").bool("printStats", "printASTStats", false, "Collect and print the program's AST statistics.").bool("printSymbolTable", "printSymbolTable", false, "Print the program's symbol table.").bool("strip", "optionStrip", false, "Strip any annotations before printing the AST.").bool("printAST", "printAST", false, "Print the program's AST in generic form.").bool("locateAST", "optionLocateAST", false, "Include location information when printing the AST in generic form.").bool("printSource", "printSource", false, "Print the program's AST in C source form.").bool("preserveLines", "preserveLines", false, "Preserve line spacing when printing C source.").bool("formatGNU", "formatGNU", false, "Use GNU source formatting guidelines.");
    }

    public void prepare() {
        String string;
        Class clazz;
        super.prepare();
        if (this.runtime.test("printMemoProfile")) {
            clazz = this.runtime.test("optionParseTree") ? CReader.class : CParser.class;
            string = this.runtime.test("optionParseTree") ? "C reader" : "C parser";
            try {
                this.profile = clazz.getMethod("profile", Printer.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.runtime.error(string + " generated without profile attribute");
            }
            catch (SecurityException securityException) {
                this.runtime.error("unable to access " + string + "'s profile() method");
            }
        }
        if (this.runtime.test("printMemoTable")) {
            clazz = this.runtime.test("optionParseTree") ? CReader.class : CParser.class;
            string = this.runtime.test("optionParseTree") ? "C reader" : "C parser";
            try {
                this.dump = clazz.getMethod("dump", Printer.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.runtime.error(string + " generated without dump attribute");
            }
            catch (SecurityException securityException) {
                this.runtime.error("unable to access " + string + "'s dump() method");
            }
        }
        if (this.runtime.test("optionTypical") && !this.runtime.test("optionAnalyze")) {
            this.runtime.error("typical option requires analyze option");
        }
        if (this.runtime.test("optionPedantic") && !this.runtime.test("optionAnalyze")) {
            this.runtime.error("pedantic option requires analyze option");
        }
        if (this.runtime.test("optionBuiltIns") && !this.runtime.test("optionAnalyze")) {
            this.runtime.error("builtins option requires analyze option");
        }
        if (this.runtime.test("optionMarkAST") && !this.runtime.test("optionAnalyze")) {
            this.runtime.error("markAST option requires analyze option");
        }
        if (this.runtime.test("printSymbolTable") && !this.runtime.test("optionAnalyze")) {
            this.runtime.error("printSymbolTable option requires analyze option");
        }
        if (this.runtime.test("optionLocateAST") && !this.runtime.test("printAST")) {
            this.runtime.error("locateAST option requires printAST option");
        }
        if (this.runtime.test("preserveLines") && !this.runtime.test("printSource")) {
            this.runtime.error("preserveLines option requires printSource option");
        }
        if (this.runtime.test("formatGNU") && !this.runtime.test("printSource")) {
            this.runtime.error("formatGNU option requires printSource option");
        }
    }

    public void diagnose() {
        this.runtime.console().pln();
        this.runtime.console().p("os        : ").pln("Mac OS X 10.5.1");
        this.runtime.console().p("arch      : ").pln("i386");
        this.runtime.console().p("compiler  : ").p("gcc").p(' ').pln("4.0.1 (Apple Inc. build 5465)");
        this.runtime.console().p("endian    : ");
        this.runtime.console().pln("little");
        this.runtime.console().p("size_t    : ").pln(xtc.type.C.SIZEOF.toString());
        this.runtime.console().p("ptrdiff_t : ").pln(xtc.type.C.PTR_DIFF.toString());
        this.runtime.console().p("wchar_t   : ").pln(xtc.type.C.WCHAR.toString());
        this.runtime.console().p("char      : ");
        this.runtime.console().pln("signed");
        this.runtime.console().p("literal   : ");
        this.runtime.console().pln("const char *");
        this.runtime.console().p("int       : ");
        this.runtime.console().pln("signed in bitfields");
        this.runtime.console().pln();
        this.runtime.console().pln("type      |  b |  c |  s |  i |  l | ll |  f |  d | ld |  p");
        this.runtime.console().pln("----------+----+----+----+----+----+----+----+----+----+----");
        this.runtime.console().p("size      | ").pad(1L, 2).p(" |  1 | ").pad(2L, 2).p(" | ").pad(4L, 2).p(" | ").pad(4L, 2).p(" | ").pad(8L, 2).p(" | ").pad(4L, 2).p(" | ").pad(8L, 2).p(" | ").pad(16L, 2).p(" | ").pad(4L, 2).pln();
        this.runtime.console().p("align     | ").pad(1L, 2).p(" |  1 | ").pad(2L, 2).p(" | ").pad(4L, 2).p(" | ").pad(4L, 2).p(" | ").pad(4L, 2).p(" | ").pad(4L, 2).p(" | ").pad(4L, 2).p(" | ").pad(16L, 2).p(" | ").pad(4L, 2).pln();
        this.runtime.console().p("nat align | ").pad(1L, 2).p(" |  1 | ").pad(2L, 2).p(" | ").pad(4L, 2).p(" | ").pad(4L, 2).p(" | ").pad(8L, 2).p(" | ").pad(4L, 2).p(" | ").pad(8L, 2).p(" | ").pad(16L, 2).p(" | ").pad(4L, 2).pln();
        this.runtime.console().pln().flush();
    }

    public File locate(String string) throws IOException {
        File file = super.locate(string);
        if (this.runtime.test("optionNoIncr") && Integer.MAX_VALUE < file.length()) {
            throw new IllegalArgumentException(file + ": file too large");
        }
        return file;
    }

    public Node parse(Reader reader, File file) throws IOException, ParseException {
        Result result2;
        if (this.runtime.test("optionParseTree")) {
            Result result3;
            if (this.runtime.test("optionNoIncr")) {
                CReader cReader = new CReader(reader, file.toString(), (int)file.length());
                Result result4 = cReader.pTranslationUnit(0);
                this.printMemoInfo(cReader, file);
                return (Node)cReader.value(result4);
            }
            CReader cReader = new CReader(reader, file.getName());
            GNode gNode = GNode.create("TranslationUnit");
            gNode.setLocation(new Location(file.toString(), 1, 0));
            Node node = gNode;
            boolean bl = true;
            while (!cReader.isEOF(0)) {
                result3 = bl ? cReader.pPrelude(0) : cReader.pExternalDeclaration(0);
                this.printMemoInfo(cReader, file);
                if (!result3.hasValue()) {
                    cReader.signal(result3.parseError());
                }
                if (bl) {
                    node = Formatting.before1(result3.semanticValue(), gNode);
                    bl = false;
                } else {
                    gNode.add(result3.semanticValue());
                }
                cReader.resetTo(result3.index);
            }
            result3 = cReader.pAnnotations(0);
            if (!result3.hasValue()) {
                cReader.signal(result3.parseError());
            }
            gNode.add(result3.semanticValue());
            return node;
        }
        if (this.runtime.test("optionNoIncr")) {
            CParser cParser = new CParser(reader, file.toString(), (int)file.length());
            Result result5 = cParser.pTranslationUnit(0);
            this.printMemoInfo(cParser, file);
            return (Node)cParser.value(result5);
        }
        CParser cParser = new CParser(reader, file.getName());
        GNode gNode = GNode.create("TranslationUnit");
        boolean bl = true;
        while (!cParser.isEOF(0)) {
            result2 = bl ? cParser.pPrelude(0) : cParser.pExternalDeclaration(0);
            this.printMemoInfo(cParser, file);
            if (!result2.hasValue()) {
                cParser.signal(result2.parseError());
            }
            if (bl) {
                bl = false;
            } else {
                gNode.add(result2.semanticValue());
            }
            cParser.resetTo(result2.index);
        }
        result2 = cParser.pAnnotations(0);
        if (!result2.hasValue()) {
            cParser.signal(result2.parseError());
        }
        gNode.add(result2.semanticValue());
        return gNode;
    }

    private void printMemoInfo(Object object, File file) {
        if (this.runtime.test("printMemoProfile")) {
            try {
                this.profile.invoke(object, this.runtime.console());
            }
            catch (Exception exception) {
                this.runtime.error(file + ": " + exception.getMessage());
            }
            this.runtime.console().pln().flush();
        }
        if (this.runtime.test("printMemoTable")) {
            try {
                this.dump.invoke(object, this.runtime.console());
            }
            catch (Exception exception) {
                this.runtime.error(file + ": " + exception.getMessage());
            }
            this.runtime.console().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Node node) {
        Object object;
        if (this.runtime.test("optionAnalyze")) {
            if (this.runtime.test("optionTypical")) {
                object = new xtc.lang.c.CAnalyzer(this.runtime).run(node);
            } else {
                object = new SymbolTable();
                if (this.runtime.test("optionBuiltIns")) {
                    new CFactory("__builtin_", ((SymbolTable)object).root()).declareBuiltIns(false);
                }
                new CAnalyzer(this.runtime).analyze(node, (SymbolTable)object);
            }
            if (this.runtime.test("printSymbolTable")) {
                Visitor visitor = this.runtime.console().visitor();
                new TypePrinter(this.runtime.console());
                try {
                    ((SymbolTable)object).root().dump(this.runtime.console());
                }
                finally {
                    this.runtime.console().register(visitor);
                }
                this.runtime.console().flush();
            }
        }
        if (this.runtime.test("printASTStats")) {
            object = new CCounter();
            ((Visitor)object).dispatch(node);
            ((CCounter)object).print(this.runtime.console());
            this.runtime.console().flush();
        }
        if (this.runtime.test("optionStrip")) {
            node = (Node)new ParseTreeStripper().dispatch(node);
        }
        if (this.runtime.test("printAST")) {
            this.runtime.console().format(node, this.runtime.test("optionLocateAST")).pln().flush();
        }
        if (this.runtime.test("printSource")) {
            if (this.runtime.test("optionParseTree") && !this.runtime.test("optionStrip")) {
                new ParseTreePrinter(this.runtime.console()).dispatch(node);
            } else {
                new CPrinter(this.runtime.console(), this.runtime.test("preserveLines"), this.runtime.test("formatGNU")).dispatch(node);
            }
            this.runtime.console().flush();
        }
    }

    public static void main(String[] stringArray) {
        new C().run(stringArray);
    }
}

