/*
 * Decompiled with CFR 0.152.
 */
package xtc.xform;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.xform.Function;
import xtc.xform.Item;
import xtc.xform.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine {
    final int FOCUS_ROOT = 0;
    final int FOCUS_ALL = 1;
    final int FOCUS_IMPLICIT = 3;
    final int FOCUS_LAST = 4;
    final int FOCUS_INSIDE_OUT = 5;
    int focus_flag;
    boolean modified_flag = false;
    boolean bad_breadth_flag = true;
    Sequence<?> bfs_sequence;
    Environment environment = null;
    GNode source_ast;
    Item item_tree;
    QueryVisitor visitor;
    HashMap<String, Function> function_table;
    String[] lib_funcs = new String[]{"CountFunction", "LinesFunction", "LastFunction", "EmptyFunction", "TestFunction", "IsNullFunction", "SubsequenceFunction", "ConcatFunction", "UpperCaseFunction", "LowerCaseFunction", "SubStringFunction"};

    public Engine() {
        this.visitor = new QueryVisitor();
        this.function_table = new HashMap();
        String string = "";
        for (int i = 0; i < this.lib_funcs.length; ++i) {
            Object object;
            string = this.lib_funcs[i];
            try {
                Class<?> clazz = Class.forName("xtc.xform." + string);
                object = clazz.newInstance();
                this.addFunction((Function)object);
                continue;
            }
            catch (Exception exception) {
                object = "Error: Unable to load class \"" + string + "\".";
                throw new RuntimeException((String)object);
            }
        }
    }

    protected void addFunction(Function function) {
        this.function_table.put(function.getName(), function);
    }

    protected Object callFunction(String string, ArrayList<Object> arrayList) throws IllegalArgumentException {
        Function function = this.function_table.get(string);
        if (null == function) {
            throw new IllegalArgumentException();
        }
        return function.apply(arrayList);
    }

    public List<Object> run(Query query, GNode gNode) {
        this.environment = new Environment();
        this.environment.pushScope();
        this.source_ast = gNode;
        this.item_tree = this.genItemTree(this.source_ast, null, 0);
        return this.createObjectList(this.castToSequenceOfItem(this.visitor.dispatch(query.ast)));
    }

    private List<Object> createObjectList(List<Item> list) {
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
        for (Item item : list) {
            if (item instanceof List) {
                ArrayList<Item> arrayList2 = new ArrayList<Item>();
                arrayList2.addAll(this.castToSequenceOfItem(item));
                arrayList.add(this.createObjectList(arrayList2));
                continue;
            }
            arrayList.add(item.object);
        }
        return arrayList;
    }

    public GNode getASTRoot() {
        return this.modified_flag ? (GNode)this.genFinalTree(this.item_tree) : this.source_ast;
    }

    private Item genItemTree(Object object, Item item, int n) {
        Item item2 = new Item(object, item, n);
        if (object instanceof GNode) {
            int n2 = 0;
            Iterator<Object> iterator = ((GNode)object).iterator();
            while (iterator.hasNext()) {
                item2.addChild(this.genItemTree(iterator.next(), item2, n2));
                ++n2;
            }
        }
        return item2;
    }

    private Object genFinalTree(Item item) {
        Object object = item.object;
        if (object instanceof GNode) {
            object = GNode.create(((GNode)object).getName());
            if (null != item.children) {
                Iterator<Item> iterator = item.children.iterator();
                while (iterator.hasNext()) {
                    ((GNode)object).add(this.genFinalTree(iterator.next()));
                }
            }
        }
        return object;
    }

    <T> List<Sequence<?>> castToListOfSequence(T t) {
        return (List)t;
    }

    <T> List<Object> castToListOfObject(T t) {
        return (List)t;
    }

    <T> Sequence<Item> castToSequenceOfItem(T t) {
        return (Sequence)t;
    }

    <T> Sequence<Object> castToSequenceOfObject(T t) {
        return (Sequence)t;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QueryVisitor
    extends Visitor {
        QueryVisitor() {
        }

        public List<?> visitXForm(GNode gNode) {
            if (0 == gNode.size()) {
                return new ArrayList();
            }
            GNode gNode2 = (GNode)gNode.get(0);
            if (null != gNode2) {
                this.dispatch(gNode2);
            }
            return (List)this.dispatch((GNode)gNode.get(1));
        }

        public void visitImportStatement(GNode gNode) {
            String string = "";
            Iterator<Object> iterator = gNode.iterator();
            while (iterator.hasNext()) {
                Object object;
                try {
                    GNode gNode2 = (GNode)iterator.next();
                    string = (String)((Item)this.dispatch((Node)gNode2)).object;
                    object = Class.forName(string);
                    Object t = ((Class)object).newInstance();
                    Engine.this.addFunction((Function)t);
                }
                catch (Exception exception) {
                    object = "Error: Unable to load class \"" + string + "\".";
                    throw new RuntimeException((String)object);
                }
            }
        }

        public Sequence<?> visitCompoundExpression(GNode gNode) {
            Sequence<Sequence> sequence = new Sequence<Sequence>();
            int n = 0;
            Iterator<Object> iterator = gNode.iterator();
            while (iterator.hasNext()) {
                Sequence sequence2 = (Sequence)this.dispatch((GNode)iterator.next());
                sequence.add(sequence2);
                Engine.this.environment.pushFocus(sequence2);
                ++n;
            }
            while (0 != n) {
                Engine.this.environment.popFocus();
                --n;
            }
            return sequence;
        }

        public Sequence<?> visitLetExpression(GNode gNode) {
            Engine.this.environment.pushScope();
            this.dispatch((GNode)gNode.get(0));
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(1));
            Engine.this.environment.popScope();
            return sequence;
        }

        public void visitLetBindingList(GNode gNode) {
            Iterator<Object> iterator = gNode.iterator();
            while (iterator.hasNext()) {
                this.dispatch((GNode)iterator.next());
            }
        }

        public void visitLetBinding(GNode gNode) {
            GNode gNode2 = (GNode)gNode.get(0);
            String string = (String)gNode2.get(0);
            Sequence<Variable> sequence = new Sequence<Variable>();
            List list = (List)this.dispatch((GNode)gNode.get(1));
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                sequence.add((Variable)iterator.next());
            }
            Engine.this.environment.setVariable(string, sequence);
        }

        public Sequence<?> visitForExpression(GNode gNode) {
            Iterator<Iterator<?>> iterator;
            int n;
            Engine.this.environment.pushScope();
            ArrayList arrayList = new ArrayList();
            arrayList.addAll((List)this.dispatch((GNode)gNode.get(0)));
            int n2 = arrayList.size();
            ArrayList arrayList2 = new ArrayList(n2);
            Sequence sequence = new Sequence();
            for (n = 0; n < n2; ++n) {
                iterator = ((Variable)arrayList.get((int)n)).value.flatIterator();
                arrayList2.add(iterator);
                if (!iterator.hasNext()) {
                    Engine.this.environment.popScope();
                    return sequence;
                }
                this.setVariable((Variable)arrayList.get(n), iterator.next());
            }
            block1: while (true) {
                sequence.addAll(Engine.this.castToListOfSequence(this.dispatch((GNode)gNode.get(1))));
                n = n2 - 1;
                while (true) {
                    if (n < 0) continue block1;
                    iterator = (Iterator<Iterator<?>>)arrayList2.get(n);
                    if (iterator.hasNext()) {
                        this.setVariable((Variable)arrayList.get(n), iterator.next());
                        continue block1;
                    }
                    if (n == 0) {
                        Engine.this.environment.popScope();
                        return sequence;
                    }
                    iterator = ((Variable)arrayList.get((int)n)).value.flatIterator();
                    arrayList2.set(n, iterator);
                    this.setVariable((Variable)arrayList.get(n), iterator.next());
                    --n;
                }
                break;
            }
        }

        private <T> void setVariable(Variable variable, T t) {
            Sequence<T> sequence = new Sequence<T>();
            sequence.add(t);
            Engine.this.environment.setVariable(variable.name, sequence);
        }

        public Sequence<?> visitCForExpression(GNode gNode) {
            Object object;
            int n;
            Engine.this.environment.pushScope();
            ArrayList arrayList = (ArrayList)this.dispatch((GNode)gNode.get(0));
            ArrayList arrayList2 = new ArrayList(arrayList.size());
            Sequence sequence = new Sequence();
            for (n = 0; n < arrayList.size(); ++n) {
                object = (Variable)arrayList.get(n);
                arrayList2.add(((Variable)object).value.flatIterator());
            }
            while (true) {
                for (n = 0; n < arrayList2.size(); ++n) {
                    object = (Iterator)arrayList2.get(n);
                    if (!object.hasNext()) {
                        Engine.this.environment.popScope();
                        return sequence;
                    }
                    Sequence sequence2 = new Sequence();
                    sequence2.add(object.next());
                    Variable variable = (Variable)arrayList.get(n);
                    Engine.this.environment.setVariable(variable.name, sequence2);
                }
                sequence.addAll(Engine.this.castToListOfSequence(this.dispatch((GNode)gNode.get(1))));
            }
        }

        public ArrayList<Object> visitIterativeBindingList(GNode gNode) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Iterator<Object> iterator = gNode.iterator();
            while (iterator.hasNext()) {
                arrayList.add(this.dispatch((GNode)iterator.next()));
            }
            return arrayList;
        }

        public Variable visitIterativeBinding(GNode gNode) {
            return new Variable((String)((GNode)gNode.get(0)).get(0), (Sequence)this.dispatch((GNode)gNode.get(1)));
        }

        public Sequence<?> visitRemoveExpression(GNode gNode) {
            Engine.this.modified_flag = true;
            Engine.this.bad_breadth_flag = true;
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(0));
            Iterator<Iterator<?>> iterator = sequence.flatIterator();
            while (iterator.hasNext()) {
                Item item = (Item)((Object)iterator.next());
                Item item2 = item.parent;
                if (null == item2) {
                    throw new RuntimeException("Error: can't remove tree root");
                }
                int n = item.index;
                item2.removeChild(n);
            }
            return sequence;
        }

        public Sequence<?> visitAddExpression(GNode gNode) {
            Engine.this.modified_flag = true;
            Engine.this.bad_breadth_flag = true;
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(1));
            if (sequence.isEmpty()) {
                return sequence;
            }
            Sequence<Item> sequence2 = new Sequence<Item>();
            Sequence sequence3 = (Sequence)this.dispatch((GNode)gNode.get(0));
            Iterator<Iterator<?>> iterator = sequence.flatIterator();
            while (iterator.hasNext()) {
                Item item = (Item)((Object)iterator.next());
                Iterator<Iterator<?>> iterator2 = sequence3.flatIterator();
                while (iterator2.hasNext()) {
                    Item item2 = (Item)((Object)iterator2.next());
                    item.addChild(item2);
                    sequence2.add(item);
                }
            }
            return sequence2;
        }

        public Sequence<Item> visitReplacementExpression(GNode gNode) {
            Sequence<Item> sequence = Engine.this.castToSequenceOfItem(this.dispatch((GNode)gNode.get(0)));
            if (sequence.isEmpty()) {
                return sequence;
            }
            Sequence<Item> sequence2 = Engine.this.castToSequenceOfItem(this.dispatch((GNode)gNode.get(1)));
            return this.replace(sequence, sequence2);
        }

        public Sequence<?> visitInsertBeforeExpression(GNode gNode) {
            return this.insert(gNode, true);
        }

        public Sequence<?> visitInsertAfterExpression(GNode gNode) {
            return this.insert(gNode, false);
        }

        private Sequence<Item> replace(Sequence<Item> sequence, Sequence<Item> sequence2) {
            Engine.this.modified_flag = true;
            Engine.this.bad_breadth_flag = true;
            Sequence<Item> sequence3 = new Sequence<Item>();
            Iterator<Iterator<?>> iterator = sequence.flatIterator();
            while (iterator.hasNext()) {
                Item item = (Item)((Object)iterator.next());
                Item item2 = item.parent;
                if (null == item2) {
                    if (1 < sequence2.size()) {
                        throw new RuntimeException("Error: Tree root can only be replaced by a single item.");
                    }
                    Engine.this.item_tree = (Item)sequence2.get(0);
                    sequence3.add(Engine.this.item_tree);
                    continue;
                }
                int n = item.index;
                if (1 == sequence2.size()) {
                    Item item3 = (Item)sequence2.get(0);
                    item2.replaceChild(n, item3);
                    sequence3.add(item3);
                    continue;
                }
                item2.replaceChild(n, sequence2);
                sequence3.addAll(sequence2);
            }
            return sequence2;
        }

        private Sequence<?> insert(GNode gNode, boolean bl) {
            Engine.this.modified_flag = true;
            Engine.this.bad_breadth_flag = true;
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(1));
            if (sequence.isEmpty()) {
                return sequence;
            }
            Sequence<Item> sequence2 = new Sequence<Item>();
            Iterator<Iterator<?>> iterator = sequence.flatIterator();
            while (iterator.hasNext()) {
                Item item = (Item)((Object)iterator.next());
                Item item2 = item.parent;
                if (null == item2) {
                    throw new RuntimeException("Error: Can't insert before tree root");
                }
                int n = item.index;
                if (bl) {
                    sequence2 = new Sequence();
                    sequence2.addAll(Engine.this.castToSequenceOfItem(this.dispatch((GNode)gNode.get(0))));
                    sequence2.add(item);
                    item2.replaceChild(n, sequence2);
                    continue;
                }
                sequence2 = new Sequence();
                sequence2.add(item);
                sequence2.addAll(Engine.this.castToSequenceOfItem(this.dispatch((GNode)gNode.get(0))));
                item2.replaceChild(n, sequence2);
            }
            return sequence2;
        }

        public Sequence<?> visitIfExpression(GNode gNode) {
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(0));
            if (!sequence.isEmpty()) {
                return (Sequence)this.dispatch((GNode)gNode.get(1));
            }
            return (Sequence)this.dispatch((GNode)gNode.get(2));
        }

        public Sequence<Item> visitNewItemExpression(GNode gNode) {
            Sequence<Item> sequence = new Sequence<Item>();
            sequence.add((Item)this.dispatch((GNode)gNode.get(0)));
            return sequence;
        }

        public Item visitNewNodeExpression(GNode gNode) {
            GNode gNode2 = GNode.create((String)this.dispatch((GNode)gNode.get(0)));
            Item item = new Item(gNode2, null, 0);
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(1));
            Iterator<Iterator<?>> iterator = sequence.flatIterator();
            while (iterator.hasNext()) {
                Item item2 = new Item((Item)((Object)iterator.next()));
                item.addChild(item2);
                gNode2.add(item2.getObject());
            }
            return item;
        }

        public Sequence<Object> visitChildren(GNode gNode) {
            Sequence<Object> sequence = new Sequence<Object>();
            for (GNode gNode2 : gNode) {
                if (gNode2.isEmpty()) continue;
                Object object = this.dispatch((GNode)gNode2.get(0));
                if (object instanceof List) {
                    sequence.addAll((List)object);
                    continue;
                }
                sequence.add(object);
            }
            return sequence;
        }

        public Item visitNull(GNode gNode) {
            return new Item(null, null, 0);
        }

        public Item visitStringLiteral(GNode gNode) {
            String string = gNode.getString(0).substring(1, gNode.getString(0).length() - 1);
            return new Item(string, null, 0);
        }

        public Sequence<?> visitPathExpression(GNode gNode) {
            if (1 == gNode.size()) {
                Engine.this.focus_flag = 3;
                return (Sequence)this.dispatch((GNode)gNode.get(0));
            }
            String string = (String)gNode.get(0);
            if (null != string && "/".equals(string)) {
                Engine.this.focus_flag = 0;
                return (Sequence)this.dispatch((GNode)gNode.get(1));
            }
            Engine.this.focus_flag = null == string ? 1 : 5;
            return (Sequence)this.dispatch((GNode)gNode.get(2));
        }

        public Sequence<?> visitRelativePathExpression(GNode gNode) {
            if (1 == gNode.size()) {
                return (Sequence)this.dispatch((GNode)gNode.get(0));
            }
            Sequence sequence = (Sequence)this.dispatch((GNode)gNode.get(0));
            Engine.this.environment.pushFocus(sequence);
            String string = (String)gNode.get(1);
            Engine.this.focus_flag = "/".equals(string) ? 4 : 1;
            Sequence sequence2 = (Sequence)this.dispatch((GNode)gNode.get(2));
            Engine.this.environment.popFocus();
            return sequence2;
        }

        public Sequence<?> visitStepExpression(GNode gNode) {
            GNode gNode2 = gNode.getGeneric(0);
            GNode gNode3 = null;
            if (2 == gNode.size()) {
                gNode3 = gNode.getGeneric(1);
            }
            Sequence sequence = this.collect(gNode2);
            if (null == gNode3) {
                return sequence;
            }
            Engine.this.environment.pushFocus(sequence);
            sequence = (Sequence)this.dispatch(gNode3);
            Engine.this.environment.popFocus();
            return sequence;
        }

        public Sequence<Item> visitPredicateList(GNode gNode) {
            Sequence<Item> sequence = Engine.this.castToSequenceOfItem(Engine.this.environment.peekFocus());
            Iterator<Object> iterator = gNode.iterator();
            while (iterator.hasNext() && !(sequence = this.intersection(sequence, Engine.this.castToSequenceOfItem(this.dispatch((GNode)iterator.next())))).isEmpty()) {
                Engine.this.environment.popFocus();
                Engine.this.environment.pushFocus(sequence);
            }
            return sequence;
        }

        public Sequence<?> visitPredicate(GNode gNode) {
            Object object = this.dispatch((GNode)gNode.get(0));
            if (object instanceof Sequence && !((Sequence)object).isEmpty() && ((Sequence)object).get(0) instanceof Integer) {
                object = ((Sequence)object).get(0);
            }
            if (object instanceof Integer) {
                int n = (Integer)object;
                Sequence<Item> sequence = Engine.this.castToSequenceOfItem(Engine.this.environment.peekFocus());
                if (1 <= n && n <= sequence.size()) {
                    Sequence sequence2 = new Sequence();
                    sequence2.add(sequence.get(n - 1));
                    return sequence2;
                }
                return new Sequence();
            }
            return (Sequence)object;
        }

        private Sequence<?> collect(GNode gNode) {
            Sequence<Object> sequence;
            String string = gNode.getName();
            Sequence<Object> sequence2 = null;
            if (Engine.this.focus_flag == 0 || Engine.this.focus_flag == 1) {
                sequence2 = new Sequence<Item>();
                sequence2.add(Engine.this.item_tree);
            } else if (Engine.this.focus_flag == 5) {
                if (!Engine.this.bad_breadth_flag) {
                    sequence2 = Engine.this.castToSequenceOfItem(Engine.this.bfs_sequence);
                } else {
                    Engine.this.bfs_sequence = this.reverse_bft(Engine.this.item_tree);
                    sequence2 = Engine.this.castToSequenceOfItem(Engine.this.bfs_sequence);
                    Engine.this.bad_breadth_flag = false;
                }
            } else if (3 == Engine.this.focus_flag && !"ContextItem".equals(string)) {
                sequence = null;
                if ("VariableReference".equals(string)) {
                    sequence = Engine.this.castToSequenceOfObject(Engine.this.environment.getVariable((String)gNode.get(0)));
                    if (null == sequence) {
                        String string2 = "Error, Line " + gNode.getLocation().line + ": Variable " + (String)gNode.get(0) + " not initialized.";
                        throw new RuntimeException(string2);
                    }
                    return sequence;
                }
                if ("ParenthesizedExpression".equals(string)) {
                    return (Sequence)this.dispatch(gNode);
                }
                if ("FunctionCall".equals(string)) {
                    sequence = new Sequence();
                    Object object = this.dispatch(gNode);
                    if (object instanceof Integer) {
                        sequence.add(object);
                    } else {
                        sequence.addAll((List)object);
                    }
                    return sequence;
                }
                if ("Identifier".equals(string)) {
                    String string3 = (String)gNode.get(0);
                    Sequence<?> sequence3 = Engine.this.environment.peekFocus();
                    Sequence<?> sequence4 = Engine.this.environment.popFocus();
                    Engine.this.environment.pushFocus(sequence3);
                    sequence = new Sequence();
                    Iterator<Iterator<?>> iterator = sequence4.flatIterator();
                    while (iterator.hasNext()) {
                        Item item = (Item)((Object)iterator.next());
                        List<Item> list = item.getChildren();
                        for (int i = 0; i < list.size(); ++i) {
                            String string4;
                            Item item2 = list.get(i);
                            Object object = item2.object;
                            if (!(object instanceof GNode) || !(string4 = ((GNode)object).getName()).equals(string3)) continue;
                            sequence.add(item);
                        }
                    }
                    return sequence;
                }
            } else {
                try {
                    sequence2 = Engine.this.castToSequenceOfItem(Engine.this.environment.peekFocus());
                }
                catch (NoSuchElementException noSuchElementException) {
                    String string5 = "Error, Line " + gNode.getLocation().line + ": Attempted to evaluate a path expression without focus.";
                    throw new RuntimeException(string5);
                }
            }
            sequence = new Sequence();
            if (1 == Engine.this.focus_flag) {
                return this.test(gNode, sequence2);
            }
            if ("ContextItem".equals(string)) {
                return sequence2;
            }
            if ("FunctionCall".equals(string)) {
                return (Sequence)this.dispatch(gNode);
            }
            if ("ReverseStep" == string) {
                Sequence<Item> sequence5 = new Sequence<Item>();
                Iterator<Iterator<?>> iterator = sequence2.flatIterator();
                while (iterator.hasNext()) {
                    Item item = ((Item)((Object)iterator.next())).parent;
                    if (null == item) {
                        String string6 = "Error, Line " + gNode.getLocation().line + ": Item has no parent.";
                        throw new RuntimeException(string6);
                    }
                    sequence5.add(item);
                }
                sequence.addAll(sequence5);
            } else {
                Sequence<Item> sequence6 = new Sequence<Item>();
                Iterator<Iterator<?>> iterator = sequence2.flatIterator();
                while (iterator.hasNext()) {
                    Item item = (Item)((Object)iterator.next());
                    if (null == item.object || !(item.object instanceof GNode) || null == item.children) continue;
                    for (Item item3 : item.children) {
                        sequence6 = Engine.this.castToSequenceOfItem(item3.addToList(Engine.this.castToListOfObject(sequence6)));
                    }
                }
                sequence = this.union(sequence, this.test(gNode, sequence6));
            }
            return sequence;
        }

        private Sequence<Item> test(GNode gNode, Sequence<Item> sequence) {
            Sequence<Item> sequence2;
            Object object;
            Sequence<Item> sequence3 = new Sequence();
            String string = gNode.getName();
            Iterator<Iterator<?>> iterator = null;
            if ("ReverseStep".equals(string)) {
                iterator = sequence.flatIterator();
                while (iterator.hasNext()) {
                    object = ((Item)((Object)iterator.next())).parent;
                    if (null == object) {
                        String string2 = "Error, Line " + gNode.getLocation().line + ": Item has no parent.";
                        throw new RuntimeException(string2);
                    }
                    sequence3 = Engine.this.castToSequenceOfItem(((Item)object).addToList(Engine.this.castToListOfObject(sequence3)));
                }
            } else if ("Wildcard".equals(string)) {
                sequence3 = sequence;
            } else if ("ContextItem".equals(string)) {
                sequence3 = sequence;
            } else if ("Identifier".equals(string)) {
                iterator = sequence.flatIterator();
                while (iterator.hasNext()) {
                    object = (Item)((Object)iterator.next());
                    if (null == ((Item)object).object || !(((Item)object).object instanceof GNode) || !((String)((Object)(sequence2 = ((GNode)((Item)object).object).getName()))).equals(gNode.get(0))) continue;
                    sequence3 = Engine.this.castToSequenceOfItem(((Item)object).addToList(Engine.this.castToListOfObject(sequence3)));
                }
            } else if ("StringLiteral".equals(string)) {
                object = (String)gNode.get(0);
                object = ((String)object).substring(1, ((String)object).length() - 1);
                iterator = sequence.flatIterator();
                while (iterator.hasNext()) {
                    sequence2 = (Item)((Object)iterator.next());
                    if (null == ((Item)((Object)sequence2)).object || !(((Item)((Object)sequence2)).object instanceof String) || !((String)object).equals(((Item)((Object)sequence2)).object)) continue;
                    sequence3 = Engine.this.castToSequenceOfItem(((Item)((Object)sequence2)).addToList(Engine.this.castToListOfObject(sequence3)));
                }
            } else if ("FunctionCall".equals(string)) {
                Engine.this.environment.pushFocus(sequence);
                sequence3 = Engine.this.castToSequenceOfItem(this.dispatch(gNode));
                Engine.this.environment.popFocus();
            } else {
                object = null;
                if ("VariableReference".equals(string)) {
                    sequence2 = Engine.this.castToSequenceOfItem(Engine.this.environment.getVariable((String)gNode.get(0)));
                    if (null == sequence2) {
                        String string3 = "Error, Line " + gNode.getLocation().line + ": Variable " + (String)gNode.get(0) + " not initialized.";
                        throw new RuntimeException(string3);
                    }
                    object = sequence2;
                } else {
                    object = Engine.this.castToSequenceOfItem(this.dispatch(gNode));
                }
                sequence3 = this.intersection(sequence, (Sequence<Item>)object);
            }
            if (1 == Engine.this.focus_flag) {
                object = new Sequence();
                iterator = sequence.flatIterator();
                while (iterator.hasNext()) {
                    sequence2 = (Item)((Object)iterator.next());
                    if (null == ((Item)((Object)sequence2)).object || !(((Item)((Object)sequence2)).object instanceof GNode) || null == ((Item)((Object)sequence2)).children) continue;
                    Iterator<Item> iterator2 = ((Item)((Object)sequence2)).children.iterator();
                    while (iterator2.hasNext()) {
                        ((Sequence)object).add(iterator2.next());
                    }
                }
                if (!((AbstractCollection)object).isEmpty()) {
                    sequence3 = this.union(sequence3, this.test(gNode, (Sequence<Item>)object));
                }
            }
            return sequence3;
        }

        public Sequence<Item> visitParenthesizedExpression(GNode gNode) {
            int n = Engine.this.focus_flag;
            Sequence sequence = Engine.this.castToSequenceOfItem(this.dispatch((GNode)gNode.get(0)));
            Engine.this.focus_flag = n;
            return sequence == null ? new Sequence() : sequence;
        }

        public Integer visitIntegerLiteral(GNode gNode) {
            return new Integer(Integer.parseInt((String)gNode.get(0), 10));
        }

        public String visitIdentifier(GNode gNode) {
            return (String)gNode.get(0);
        }

        public Object visitFunctionCall(GNode gNode) {
            String string = (String)this.dispatch((GNode)gNode.get(0));
            GNode gNode2 = (GNode)gNode.get(1);
            ArrayList arrayList = null;
            if (null != gNode2) {
                ArrayList arrayList2 = new ArrayList();
                arrayList2.addAll((List)this.dispatch((GNode)gNode.get(1)));
                arrayList = arrayList2;
            }
            try {
                return Engine.this.callFunction(string, arrayList);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = "Error, Line " + gNode.getLocation().line + ": External function " + string + " not found.";
                throw new IllegalArgumentException(string2);
            }
        }

        public ArrayList<Object> visitArgumentList(GNode gNode) {
            int n = gNode.size();
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            Iterator<Object> iterator = gNode.iterator();
            while (iterator.hasNext()) {
                arrayList.add(this.dispatch((GNode)iterator.next()));
            }
            return arrayList;
        }

        public Sequence<Item> visitIntersectionExpression(GNode gNode) {
            Sequence<Item> sequence = Engine.this.castToSequenceOfItem(this.dispatch((GNode)gNode.get(0)));
            Sequence<Item> sequence2 = Engine.this.castToSequenceOfItem(this.dispatch((GNode)gNode.get(1)));
            return this.intersection(sequence, sequence2);
        }

        public Sequence<Item> visitUnionExpression(GNode gNode) {
            Sequence<Item> sequence = Engine.this.castToSequenceOfItem(this.dispatch((GNode)gNode.get(0)));
            Sequence<Item> sequence2 = Engine.this.castToSequenceOfItem(this.dispatch((GNode)gNode.get(1)));
            return this.union(sequence, sequence2);
        }

        public Sequence<Item> visitDifferExpression(GNode gNode) {
            Sequence<Item> sequence = Engine.this.castToSequenceOfItem(this.dispatch((GNode)gNode.get(0)));
            Sequence<Item> sequence2 = Engine.this.castToSequenceOfItem(this.dispatch((GNode)gNode.get(1)));
            return this.difference(sequence, sequence2);
        }

        public Sequence<Item> visitOrExpression(GNode gNode) {
            Sequence<Item> sequence = null;
            Iterator<Object> iterator = gNode.iterator();
            while (iterator.hasNext()) {
                sequence = Engine.this.castToSequenceOfItem(this.dispatch((GNode)iterator.next()));
                if (sequence.isEmpty()) continue;
                return sequence;
            }
            return sequence;
        }

        public Sequence<Object> visitAndExpression(GNode gNode) {
            Sequence<Object> sequence = null;
            Sequence<Object> sequence2 = new Sequence<Object>();
            Iterator<Object> iterator = gNode.iterator();
            while (iterator.hasNext()) {
                sequence = Engine.this.castToSequenceOfObject(this.dispatch((GNode)iterator.next()));
                if (sequence.isEmpty()) {
                    return sequence;
                }
                sequence2.addAll(sequence);
            }
            return sequence2;
        }

        private Sequence<Item> union(Sequence<Item> sequence, Sequence<Item> sequence2) {
            Sequence<Item> sequence3 = new Sequence<Item>();
            if (null != sequence) {
                sequence3.addAll(sequence);
            }
            if (null != sequence2) {
                Iterator<Iterator<?>> iterator = sequence2.flatIterator();
                while (iterator.hasNext()) {
                    Item item = (Item)((Object)iterator.next());
                    sequence3 = Engine.this.castToSequenceOfItem(item.addToList(Engine.this.castToListOfObject(sequence3)));
                }
            }
            return sequence3;
        }

        private Sequence<Item> intersection(Sequence<Item> sequence, Sequence<Item> sequence2) {
            Sequence<Item> sequence3 = new Sequence<Item>();
            if (null != sequence && null != sequence2) {
                Iterator<Iterator<?>> iterator = sequence.flatIterator();
                while (iterator.hasNext()) {
                    Iterator<?> iterator2 = iterator.next();
                    if (!sequence2.contains(iterator2)) continue;
                    sequence3.add((Item)((Object)iterator2));
                }
            }
            return sequence3;
        }

        private Sequence<Item> difference(Sequence<Item> sequence, Sequence<Item> sequence2) {
            Sequence<Item> sequence3 = sequence;
            if (null != sequence && null != sequence2) {
                Iterator<Iterator<?>> iterator = sequence2.flatIterator();
                while (iterator.hasNext()) {
                    Iterator<?> iterator2 = iterator.next();
                    if (!sequence2.contains(iterator2)) continue;
                    sequence3.remove(iterator2);
                }
            }
            return sequence3;
        }

        private Sequence<Item> reverse_bft(Item item) {
            Sequence<Item> sequence = new Sequence<Item>();
            Sequence<Item> sequence2 = new Sequence<Item>();
            Item item2 = item;
            sequence.add(item2);
            while (!sequence.isEmpty()) {
                item2 = (Item)sequence.removeFirst();
                if (item.object instanceof GNode && null != item2.children) {
                    for (Item item3 : item2.children) {
                        sequence.addFirst(item3);
                    }
                }
                sequence2.addFirst(item2);
            }
            return sequence2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Variable {
        String name;
        Sequence<?> value;

        public Variable(String string, Sequence<?> sequence) {
            this.name = string;
            this.value = sequence;
        }

        public String toString() {
            return this.name + " : " + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Environment {
        private LinkedList<Frame> stack_frames = new LinkedList();
        private LinkedList<Sequence<?>> focus_stack = new LinkedList();

        public void pushScope() {
            this.stack_frames.add(new Frame());
        }

        public void popScope() {
            if (0 != this.stack_frames.size()) {
                this.stack_frames.removeLast();
            }
        }

        public Sequence<Variable> getVariable(String string) {
            Sequence<Variable> sequence = null;
            for (int i = this.stack_frames.size() - 1; i >= 0 && null == (sequence = this.stack_frames.get(i).getVariable(string)); --i) {
            }
            return sequence;
        }

        public void setVariable(String string, Sequence<?> sequence) {
            Sequence<?> sequence2 = sequence;
            if (0 == this.stack_frames.size()) {
                this.pushScope();
            }
            this.stack_frames.getLast().setVariable(string, sequence2);
        }

        public void pushFocus(Sequence<?> sequence) {
            this.focus_stack.add(sequence);
        }

        public Sequence<?> popFocus() throws NoSuchElementException {
            Sequence<?> sequence = this.focus_stack.getLast();
            this.focus_stack.removeLast();
            return sequence;
        }

        public Sequence<?> peekFocus() throws NoSuchElementException {
            return this.focus_stack.getLast();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class Frame {
            private HashMap<String, Sequence<Variable>> symbols = new HashMap();

            public void setVariable(String string, Sequence<?> sequence) {
                Sequence<?> sequence2 = sequence;
                this.symbols.put(string, sequence2);
            }

            public Sequence<Variable> getVariable(String string) {
                return this.symbols.get(string);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Sequence<T>
    extends LinkedList<T> {
        Sequence() {
        }

        @Override
        public boolean add(T t) {
            if (!(t instanceof List) || 0 != ((List)t).size()) {
                return super.add(t);
            }
            return false;
        }

        @Override
        public boolean contains(Object object) {
            for (Object e : this) {
                if (!object.equals(e)) continue;
                return true;
            }
            return false;
        }

        public Iterator<Iterator<?>> flatIterator() {
            return new FlatIterator(this.iterator());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class FlatIterator<K>
        implements Iterator<K> {
            private LinkedList<Iterator<K>> iterator_stack = new LinkedList();

            public FlatIterator(Iterator<K> iterator) {
                this.iterator_stack.add(iterator);
            }

            @Override
            public boolean hasNext() {
                boolean bl = this.iterator_stack.getLast().hasNext();
                while (!bl) {
                    this.iterator_stack.removeLast();
                    if (0 == this.iterator_stack.size()) break;
                    bl = this.iterator_stack.getLast().hasNext();
                }
                return bl;
            }

            @Override
            public K next() {
                Iterator<Object> iterator = this.iterator_stack.getLast();
                Object object = iterator.next();
                if (object instanceof List) {
                    iterator = ((List)object).iterator();
                    object = iterator.next();
                    this.iterator_stack.add(iterator);
                    return object;
                }
                return object;
            }

            @Override
            public void remove() {
                this.iterator_stack.getLast().remove();
            }
        }
    }
}

