/*
 * Decompiled with CFR 0.152.
 */
package xtc.xform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import xtc.lang.CParser;
import xtc.lang.CPrinter;
import xtc.lang.JavaParser;
import xtc.lang.JavaPrinter;
import xtc.parser.ParseException;
import xtc.parser.Result;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.util.Statistics;
import xtc.util.Tool;
import xtc.xform.Engine;
import xtc.xform.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Driver
extends Tool {
    @Override
    public void init() {
        super.init();
        this.runtime.bool("c", "optionC", false, "Parse source file using XTC's CParser").bool("java", "optionJava", false, "Parse source file using XTC's JavaParser").word("parser", "optionParser", false, "Parse source file with parser. Eg. \"xtc.lang.NewJavaParser\"").word("unit", "optionUnit", false, "Specify source file's program unit. Eg. \"compilationUnit\"").bool("printC", "optionCPrinter", false, "Print post-query source with XTC's CPrinter").bool("printJava", "optionJavaPrinter", false, "Print post-query source with XTC's JavaPrinter").word("printer", "optionPrinter", false, "Print post-query source with printer.").bool("preAST", "optionPreAST", false, "Print the AST of the pre-query source").bool("postAST", "optionPostAST", false, "Print the AST of the post-query source").bool("queryAST", "optionQueryAST", false, "Print the query's AST").bool("queryVal", "optionQueryValue", false, "Print the value of the query.").bool("debug", "optionDebug", false, "Print a stack trace if a runtime error occurs");
    }

    @Override
    public void run(String[] stringArray) {
        Statistics statistics;
        int n;
        this.init();
        this.runtime.console().p(this.getName()).p(", v. ").p(this.getVersion()).p(", ").pln().pln(this.getCopy()).flush();
        if (0 == stringArray.length) {
            this.runtime.console().pln().pln("Usage: <option>* <xform-file-name> <source-file-name>").pln().pln("Options are:");
            this.runtime.printOptions();
            String string = this.getExplanation();
            if (null != string) {
                this.runtime.console().pln().wrap(0, string).pln();
            }
            this.runtime.console().pln().flush();
            this.runtime.exit();
        }
        if ((n = this.runtime.process(stringArray)) >= stringArray.length) {
            this.runtime.error("no file names specified");
        }
        this.prepare();
        if (this.runtime.seenError()) {
            this.runtime.exit();
        }
        String string = stringArray[n++];
        Query query = this.parseXform(string);
        if (this.runtime.test("optionQueryAST")) {
            this.runtime.console().pln().format(query.ast).pln().flush();
        }
        boolean bl = this.runtime.test("optionPerformance");
        boolean bl2 = this.runtime.test("optionGC");
        int n2 = bl ? this.runtime.getInt("runsWarmUp") : 0;
        int n3 = bl ? this.runtime.getInt("runsTotal") : 1;
        Statistics statistics2 = bl ? new Statistics() : null;
        Statistics statistics3 = bl ? new Statistics() : null;
        Statistics statistics4 = statistics = bl ? new Statistics() : null;
        if (bl) {
            this.runtime.console().p("Legend: file, size, time (ave, med, stdev), ").pln().flush();
        }
        while (n < stringArray.length) {
            String string2 = stringArray[n++];
            if (this.runtime.test("optionVerbose")) {
                this.runtime.console().p("Parsing " + string2).pln();
            }
            Node node = null;
            BufferedReader bufferedReader = null;
            File file = null;
            try {
                file = this.locate(string2);
                bufferedReader = new BufferedReader(new FileReader(file));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.runtime.error(illegalArgumentException.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.runtime.error(fileNotFoundException.getMessage());
                this.runtime.exit();
            }
            catch (IOException iOException) {
                if (null == iOException.getMessage()) {
                    this.runtime.error(": I/O error");
                } else {
                    this.runtime.error(": " + iOException.getMessage());
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.runtime.error();
            }
            try {
                node = this.parse(bufferedReader, file);
            }
            catch (ParseException parseException) {
                this.runtime.error(parseException.getMessage());
            }
            catch (Throwable throwable) {
                this.runtime.error();
                throwable.printStackTrace();
            }
            if (this.runtime.test("optionPreAST")) {
                this.runtime.console().pln().format(node).pln().flush();
            }
            GNode gNode = null;
            List<Object> list = null;
            Engine engine = new Engine();
            if (this.runtime.test("optionVerbose")) {
                this.runtime.console().p("Performing query.").pln().flush();
            }
            if (bl) {
                statistics2.reset();
            }
            for (int i = 0; i < n3; ++i) {
                if (bl2) {
                    System.gc();
                }
                long l = 0L;
                if (bl) {
                    l = System.currentTimeMillis();
                }
                try {
                    list = engine.run(query, (GNode)node.strip());
                    gNode = engine.getASTRoot();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    while (null != throwable2.getCause()) {
                        throwable2 = throwable2.getCause();
                    }
                    if (this.runtime.test("optionDebug")) {
                        throwable2.printStackTrace();
                    }
                    return;
                }
                if (!bl) continue;
                long l2 = System.currentTimeMillis();
                if (i < n2) continue;
                statistics2.add(l2 - l);
            }
            if (bl) {
                long l = file.length();
                double d = statistics2.mean();
                statistics3.add((double)l / 1024.0);
                statistics.add(d);
                this.runtime.console().p(string2).p(' ').p(Statistics.round((double)l / 1024.0)).p(' ').p(Statistics.round(d)).p(' ').pln().flush();
            }
            if (this.runtime.test("optionQueryValue")) {
                this.printSequence(list);
                this.runtime.console().pln().flush();
            }
            this.process(gNode);
        }
        if (bl) {
            double d = 1000.0 / Statistics.fitSlope(statistics3, statistics);
            this.runtime.console().pln().p("Throughput      : ").p(Statistics.round(d)).pln().flush();
        }
    }

    public Query parseXform(String string) {
        if (this.runtime.test("optionVerbose")) {
            this.runtime.console().p("Parsing " + string).pln().flush();
        }
        BufferedReader bufferedReader = null;
        File file = null;
        try {
            file = this.locate(string);
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.runtime.error(illegalArgumentException.getMessage());
            this.runtime.exit();
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.runtime.error(fileNotFoundException.getMessage());
            this.runtime.exit();
        }
        catch (IOException iOException) {
            if (null == iOException.getMessage()) {
                this.runtime.error(": I/O error");
            } else {
                this.runtime.error(": " + iOException.getMessage());
            }
            this.runtime.exit();
        }
        catch (Throwable throwable) {
            this.runtime.error();
            if (this.runtime.test("optionDebug")) {
                throwable.printStackTrace();
            }
            this.runtime.exit();
        }
        Query query = null;
        try {
            query = new Query(bufferedReader);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.runtime.error("Error: XForm query is malformed.");
        }
        return query;
    }

    @Override
    public Node parse(Reader reader, File file) throws IOException, ParseException {
        if (this.runtime.test("optionJava")) {
            JavaParser javaParser = new JavaParser(reader, file.toString(), (int)file.length());
            return (GNode)javaParser.value(javaParser.pCompilationUnit(0));
        }
        if (this.runtime.test("optionC")) {
            CParser cParser = new CParser(reader, file.toString(), (int)file.length());
            return (GNode)cParser.value(cParser.pTranslationUnit(0));
        }
        if (null != this.runtime.getValue("optionParser")) {
            String string = (String)this.runtime.getValue("optionParser");
            String string2 = (String)this.runtime.getValue("optionUnit");
            if (null == string2) {
                this.runtime.error("-parser option requires -unit option");
            }
            string2 = "p" + string2;
            try {
                Result result2;
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(Reader.class, String.class, Integer.TYPE);
                Long l = new Long(file.length());
                Object obj = constructor.newInstance(reader, file.toString(), new Integer(l.intValue()));
                Method method = clazz.getMethod(string2, Integer.TYPE);
                if (null == method) {
                    this.runtime.error("unit does not match any in " + string);
                }
                if ((result2 = (Result)method.invoke(obj, new Integer(0))).hasValue()) {
                    return (GNode)result2.semanticValue();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.runtime.error("Unable to find class " + string);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                this.runtime.error("Unable to initialise " + string);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.runtime.error("Method " + string2 + " not found");
            }
            catch (InstantiationException instantiationException) {
                this.runtime.error("Unable to instantiate " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.runtime.error("Unable to access method" + string2);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.runtime.error("Invocation error on method " + string2);
            }
        }
        return null;
    }

    @Override
    public void process(Node node) {
        GNode gNode = (GNode)node;
        if (this.runtime.test("optionPostAST")) {
            this.runtime.console().pln().format(gNode).pln().flush();
        }
        if (this.runtime.test("optionJavaPrinter")) {
            new JavaPrinter(this.runtime.console()).dispatch(gNode);
            this.runtime.console().flush();
        } else if (this.runtime.test("optionCPrinter")) {
            new CPrinter(this.runtime.console()).dispatch(gNode);
            this.runtime.console().flush();
        } else if (null != this.runtime.getValue("optionPrinter")) {
            String string = (String)this.runtime.getValue("optionPrinter");
            try {
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(Printer.class);
                Object obj = constructor.newInstance(this.runtime.console());
                Method method = clazz.getMethod("dispatch", GNode.class);
                method.invoke(obj, gNode);
                this.runtime.console().flush();
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.runtime.error("Unable to find " + string);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                this.runtime.error("Unable to initialise " + string);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.runtime.error("Unable to locate method 'dispatch' in " + string);
            }
            catch (InstantiationException instantiationException) {
                this.runtime.error("Unable to instantiate " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.runtime.error("Unable to access method 'dispatch' in" + string);
            }
            catch (InvocationTargetException invocationTargetException) {
                this.runtime.error("Invocation failure on method 'dispatch");
            }
        }
    }

    @Override
    public String getName() {
        return "Xform AST Query and Transformation Language";
    }

    private void printSequence(List<?> list) {
        this.runtime.console().p("(");
        Iterator<?> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (obj instanceof GNode) {
                this.runtime.console().p(((GNode)obj).getName());
            } else if (obj instanceof String) {
                this.runtime.console().p((String)obj);
            } else if (obj instanceof List) {
                this.printSequence((List)obj);
            } else if (null == obj) {
                this.runtime.console().p("null");
            } else {
                String string = "Error: Unidentified object in sequence.";
                throw new RuntimeException(string);
            }
            if (!iterator.hasNext()) continue;
            this.runtime.console().p(",");
        }
        this.runtime.console().p(")");
    }

    public static void main(String[] stringArray) {
        new Driver().run(stringArray);
    }
}

