/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.Date;
import xtc.parser.ParseException;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.VisitingException;
import xtc.util.Runtime;
import xtc.util.Statistics;

public abstract class Tool {
    protected final Runtime runtime = new Runtime();

    public abstract String getName();

    public String getVersion() {
        return "1.14.1";
    }

    public String getCopy() {
        return "(C) 2004-2008 Robert Grimm and New York University";
    }

    public String getExplanation() {
        return null;
    }

    public void init() {
        this.runtime.bool("silent", "optionSilent", false, "Enable silent operation.").bool("verbose", "optionVerbose", false, "Enable verbose operation.").bool("no-exit", "optionNoExit", false, "Do not explicitly exit the Java virtual machine.").dir("in", "inputDirectory", true, "Add the specified directory to the file search path.").dir("out", "outputDirectory", false, "Use the specified directory for output.").word("enc-in", "inputEncoding", false, "Use the specified character encoding for input.").word("enc-out", "outputEncoding", false, "Use the specified character encoding for output.").bool("diagnostics", "optionDiagnostics", false, "Print diagnostics for internal tool state.").bool("performance", "optionPerformance", false, "Collect and print performance statistics.").bool("measureParser", "optionMeasureParser", false, "Measure parser performance only.").bool("measureProcess", "optionMeasureProcessing", false, "Measure processing performance only.").bool("gc", "optionGC", false, "Perform GC before each operation.").number("warmupRuns", "runsWarmUp", 2, "Perform the specified number of warm-up runs.  The default is 2.").number("totalRuns", "runsTotal", 12, "Perform the specified number of total runs.  The default is 12.");
    }

    public void prepare() {
        this.runtime.initDefaultValues();
        if (this.runtime.test("optionSilent") && this.runtime.test("optionVerbose")) {
            this.runtime.error("can't run in silent and verbose mode at the same time");
        }
        if (this.runtime.test("optionMeasureParser") && this.runtime.test("optionMeasureProcessing")) {
            this.runtime.error("can't measure just parsing and just processing at the same time");
        }
        if (this.runtime.test("optionMeasureParser") && !this.runtime.test("optionPerformance")) {
            this.runtime.setValue("optionPerformance", true);
        }
        if (this.runtime.test("optionMeasureProcessing") && !this.runtime.test("optionPerformance")) {
            this.runtime.setValue("optionPerformance", true);
        }
    }

    public void diagnose() {
    }

    public File locate(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException(string + ": not found");
        }
        return file;
    }

    public abstract Node parse(Reader var1, File var2) throws IOException, ParseException;

    public void process(Node node) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String string) throws IOException, ParseException {
        Node node;
        File file = this.locate(string);
        Reader reader = this.runtime.getReader(file);
        try {
            node = this.parse(reader, file);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        this.process(node);
    }

    public void printHeader(Printer printer) {
        printer.sep();
        printer.indent().pln("// This file has been generated by");
        printer.indent().p("// ").p(this.getName()).p(", version ").p(this.getVersion()).pln(',');
        printer.p("// ").p(this.getCopy()).pln(',');
        Date date = new Date();
        printer.indent().p("// on ").p(DateFormat.getDateInstance(0).format(date)).p(" at ").p(DateFormat.getTimeInstance(2).format(date)).pln('.');
        printer.indent().pln("// Edit at your own risk.");
        printer.sep();
        printer.pln();
    }

    public void wrapUp() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] stringArray) {
        Statistics statistics;
        boolean bl;
        this.init();
        if (0 == stringArray.length) {
            this.runtime.console().p(this.getName()).p(", v. ").p(this.getVersion()).p(", ").pln(this.getCopy());
            this.runtime.console().pln().pln("Usage: <option>* <file-name>+").pln().pln("Options are:");
            this.runtime.printOptions();
            String string = this.getExplanation();
            if (null != string) {
                this.runtime.console().pln().wrap(0, string).pln();
            }
            this.runtime.console().pln().flush();
            if (this.runtime.hasValue("optionNoExit") && this.runtime.test("optionNoExit")) {
                return;
            }
            this.runtime.exit();
        }
        int n = this.runtime.process(stringArray);
        if (!this.runtime.hasValue("optionSilent") || !this.runtime.test("optionSilent")) {
            this.runtime.console().p(this.getName()).p(", v. ").p(this.getVersion()).p(", ").pln(this.getCopy()).flush();
        }
        boolean bl2 = bl = this.runtime.hasValue("optionDiagnostics") && this.runtime.test("optionDiagnostics");
        if (n >= stringArray.length && !bl) {
            this.runtime.error("no file names specified");
        }
        this.prepare();
        if (bl) {
            this.diagnose();
        }
        if (this.runtime.seenError()) {
            if (this.runtime.test("optionNoExit")) {
                return;
            }
            this.runtime.exit();
        }
        boolean bl3 = this.runtime.test("optionSilent");
        boolean bl4 = this.runtime.test("optionGC");
        boolean bl5 = this.runtime.test("optionPerformance");
        boolean bl6 = this.runtime.test("optionMeasureParser");
        boolean bl7 = this.runtime.test("optionMeasureProcessing");
        int n2 = bl5 ? this.runtime.getInt("runsWarmUp") : 0;
        int n3 = bl5 ? this.runtime.getInt("runsTotal") : 1;
        Statistics statistics2 = bl5 ? new Statistics() : null;
        Statistics statistics3 = bl5 ? new Statistics() : null;
        Statistics statistics4 = bl5 ? new Statistics() : null;
        Statistics statistics5 = bl5 ? new Statistics() : null;
        Statistics statistics6 = statistics = bl5 ? new Statistics() : null;
        if (bl5) {
            this.runtime.console().p("Legend: file, size, time (ave, med, stdev), ").pln("memory (ave, med, stdev)").pln().flush();
        }
        while (n < stringArray.length) {
            if (!bl3 && !bl5) {
                this.runtime.console().p("Processing ").p(stringArray[n]).pln(" ...").flush();
            }
            File file = null;
            try {
                file = this.locate(stringArray[n]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.runtime.error(illegalArgumentException.getMessage());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.runtime.error(fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                if (null == iOException.getMessage()) {
                    this.runtime.error(stringArray[n] + ": I/O error");
                } else {
                    this.runtime.error(stringArray[n] + ": " + iOException.getMessage());
                }
            }
            catch (Throwable throwable) {
                this.runtime.error();
                throwable.printStackTrace();
            }
            if (null != file) {
                if (bl5) {
                    statistics2.reset();
                    statistics3.reset();
                }
                for (int i = 0; i < n3; ++i) {
                    Node node = null;
                    boolean bl8 = false;
                    if (bl4) {
                        System.gc();
                    }
                    long l = 0L;
                    long l2 = 0L;
                    if (bl5 && !bl7) {
                        l2 = java.lang.Runtime.getRuntime().freeMemory();
                        l = System.currentTimeMillis();
                    }
                    Reader reader = null;
                    try {
                        reader = this.runtime.getReader(file);
                        node = this.parse(reader, file);
                        bl8 = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.runtime.error(illegalArgumentException.getMessage());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.runtime.error(fileNotFoundException.getMessage());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this.runtime.error(unsupportedEncodingException.getMessage());
                    }
                    catch (IOException iOException) {
                        if (null == iOException.getMessage()) {
                            this.runtime.error(stringArray[n] + ": I/O error");
                        } else {
                            this.runtime.error(stringArray[n] + ": " + iOException.getMessage());
                        }
                    }
                    catch (ParseException parseException) {
                        this.runtime.error();
                        System.err.print(parseException.getMessage());
                    }
                    catch (Throwable throwable) {
                        this.runtime.error();
                        throwable.printStackTrace();
                    }
                    finally {
                        if (null != reader) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (bl8 && null != node && !bl6) {
                        if (bl5 && bl7) {
                            l2 = java.lang.Runtime.getRuntime().freeMemory();
                            l = System.currentTimeMillis();
                        }
                        try {
                            this.process(node);
                        }
                        catch (VisitingException visitingException) {
                            this.runtime.error();
                            visitingException.getCause().printStackTrace();
                        }
                        catch (Throwable throwable) {
                            this.runtime.error();
                            throwable.printStackTrace();
                        }
                    }
                    if (!bl5) continue;
                    long l3 = System.currentTimeMillis();
                    long l4 = java.lang.Runtime.getRuntime().freeMemory();
                    if (i < n2) continue;
                    statistics2.add(l3 - l);
                    statistics3.add(l2 - l4);
                }
                if (bl5) {
                    long l = file.length();
                    double d = statistics2.mean();
                    double d2 = statistics3.mean();
                    statistics4.add((double)l / 1024.0);
                    statistics5.add(d);
                    statistics.add(d2 / 1024.0);
                    this.runtime.console().p(stringArray[n]).p(' ').p(l).p(' ').p(Statistics.round(d)).p(' ').p(statistics2.median()).p(' ').p(Statistics.round(statistics2.stdev())).p(' ').p(Statistics.round(d2)).p(' ').p(statistics3.median()).p(' ').pln(Statistics.round(statistics3.stdev())).flush();
                }
            }
            ++n;
        }
        this.wrapUp();
        if (bl5) {
            double d = statistics5.sum();
            double d3 = statistics.sum();
            double d4 = 1000.0 / Statistics.fitSlope(statistics4, statistics5);
            double d5 = Statistics.fitSlope(statistics4, statistics);
            this.runtime.console().pln().p("Total time               : ").p(Statistics.round(d)).pln(" ms").p("Total memory             : ").p(Statistics.round(d3)).pln(" KB").p("Average throughput       : ").p(Statistics.round(d4)).pln(" KB/s").p("Average heap utilization : ").p(Statistics.round(d5)).pln(":1").flush();
        }
        if (!this.runtime.test("optionNoExit")) {
            this.runtime.exit();
        }
    }
}

