/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.util.EmptyIterator;
import xtc.util.Utilities;

public class SymbolTable {
    protected Scope root;
    protected Scope current;
    protected int freshNameCount;
    protected int freshIdCount;
    private static final String END_OPAQUE = Character.toString(')');

    public SymbolTable() {
        this("");
    }

    public SymbolTable(String string) {
        this.current = this.root = new Scope(string);
        this.freshNameCount = 0;
        this.freshIdCount = 0;
    }

    public void reset() {
        this.root.scopes = null;
        this.root.symbols = null;
        this.current = this.root;
        this.freshNameCount = 0;
        this.freshIdCount = 0;
    }

    public Scope root() {
        return this.root;
    }

    public Scope current() {
        return this.current;
    }

    public Scope getScope(String string) {
        Scope scope = this.current;
        if (string.startsWith(scope.qName) && string.lastIndexOf(46) == scope.qName.length()) {
            return scope.getNested(Utilities.getName(string));
        }
        String[] stringArray = Utilities.toComponents(string);
        scope = this.root.name.equals(stringArray[0]) ? this.root : null;
        for (int n = 1; null != scope && n < stringArray.length; scope = scope.getNested(stringArray[n]), ++n) {
        }
        return scope;
    }

    public void setScope(Scope scope) {
        Scope scope2 = scope;
        while (null != scope2.parent) {
            scope2 = scope2.parent;
        }
        if (scope2 != this.root) {
            throw new IllegalArgumentException("Scope " + scope.qName + " not " + "in this symbol table " + this);
        }
        this.current = scope;
    }

    public boolean isDefined(String string) {
        Scope scope = this.lookupScope(string);
        if (null == scope || null == scope.symbols) {
            return false;
        }
        return scope.symbols.containsKey(Utilities.unqualify(string));
    }

    public boolean isDefinedMultiply(String string) {
        Scope scope = this.lookupScope(string);
        if (null == scope || null == scope.symbols) {
            return false;
        }
        return scope.symbols.get(Utilities.unqualify(string)) instanceof List;
    }

    public Scope lookupScope(String string) {
        if (Utilities.isQualified(string)) {
            return this.getScope(Utilities.getQualifier(string));
        }
        return this.current.lookupScope(string);
    }

    public Object lookup(String string) {
        Scope scope = this.lookupScope(string);
        if (null == scope || null == scope.symbols) {
            return null;
        }
        return scope.symbols.get(Utilities.unqualify(string));
    }

    public void enter(String string) {
        Scope scope = this.current;
        Scope scope2 = scope.getNested(string);
        if (null == scope2) {
            scope2 = new Scope(string, scope);
        }
        this.current = scope2;
    }

    public void exit() {
        if (null == this.current.parent) {
            throw new IllegalStateException("Unable to exit root scope");
        }
        this.current = this.current.parent;
    }

    public void delete(String string) {
        if (null != this.current.scopes) {
            this.current.scopes.remove(string);
        }
    }

    public static boolean hasScope(Node node) {
        return node.hasProperty("xtc.Constants.Scope");
    }

    public void mark(Node node) {
        if (!node.hasProperty("xtc.Constants.Scope")) {
            node.setProperty("xtc.Constants.Scope", this.current.getQualifiedName());
        }
    }

    public void enter(Node node) {
        if (node.hasProperty("xtc.Constants.Scope")) {
            String string = node.getStringProperty("xtc.Constants.Scope");
            Scope scope = this.getScope(string);
            if (null == scope) {
                throw new IllegalStateException("Invalid scope " + string);
            }
            if (scope.getParent() != this.current) {
                throw new IllegalStateException("Scope " + string + " not nested in " + this.current.getQualifiedName());
            }
            this.current = scope;
        }
    }

    public void exit(Node node) {
        if (node.hasProperty("xtc.Constants.Scope")) {
            this.exit();
        }
    }

    public String freshName() {
        return this.freshName("anonymous");
    }

    public String freshName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append('(');
        stringBuilder.append(this.freshNameCount++);
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public String freshCId() {
        return this.freshCId("tmp");
    }

    public String freshCId(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("__");
        stringBuilder.append(string);
        stringBuilder.append('_');
        stringBuilder.append(this.freshIdCount++);
        return stringBuilder.toString();
    }

    public String freshJavaId() {
        return this.freshJavaId("tmp");
    }

    public String freshJavaId(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append('$');
        stringBuilder.append(this.freshIdCount++);
        return stringBuilder.toString();
    }

    public static String toNameSpace(String string, String string2) {
        return string2 + '(' + string + ')';
    }

    public static boolean isInNameSpace(String string, String string2) {
        try {
            return string.startsWith(string2) && '(' == string.charAt(string2.length()) && string.endsWith(END_OPAQUE);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    public static String fromNameSpace(String string) {
        int n = string.indexOf(40);
        int n2 = string.length() - 1;
        if (0 < n && ')' == string.charAt(n2)) {
            return string.substring(n + 1, n2);
        }
        throw new IllegalArgumentException("Not a mangled symbol '" + string + "'");
    }

    public static String toMacroScopeName(String string) {
        return SymbolTable.toNameSpace(string, "macro");
    }

    public static boolean isMacroScopeName(String string) {
        return SymbolTable.isInNameSpace(string, "macro");
    }

    public static String toFunctionScopeName(String string) {
        return SymbolTable.toNameSpace(string, "function");
    }

    public static boolean isFunctionScopeName(String string) {
        return SymbolTable.isInNameSpace(string, "function");
    }

    public static String toTagName(String string) {
        return SymbolTable.toNameSpace(string, "tag");
    }

    public static String toLabelName(String string) {
        return SymbolTable.toNameSpace(string, "label");
    }

    public static String toMethodName(String string) {
        return SymbolTable.toNameSpace(string, "method");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Scope {
        String name;
        String qName;
        Scope parent;
        Map<String, Scope> scopes;
        Map<String, Object> symbols;

        Scope(String string) {
            this.name = string;
            this.qName = string;
        }

        Scope(String string, Scope scope) {
            if (null != scope.scopes && scope.scopes.containsKey(string)) {
                throw new IllegalArgumentException("Scope " + scope.qName + " already contains scope " + string);
            }
            this.name = string;
            this.qName = Utilities.qualify(scope.qName, string);
            this.parent = scope;
            if (null == scope.scopes) {
                scope.scopes = new HashMap<String, Scope>();
            }
            scope.scopes.put(string, this);
        }

        public String getName() {
            return this.name;
        }

        public String getQualifiedName() {
            return this.qName;
        }

        void requalify() {
            this.qName = Utilities.qualify(this.parent.qName, this.name);
            if (null != this.scopes) {
                for (Scope scope : this.scopes.values()) {
                    scope.requalify();
                }
            }
        }

        public boolean isRoot() {
            return null == this.parent;
        }

        public Scope getParent() {
            return this.parent;
        }

        public boolean hasNested() {
            return null != this.scopes && 0 < this.scopes.size();
        }

        public Iterator<String> nested() {
            if (null == this.scopes) {
                return EmptyIterator.value();
            }
            return this.scopes.keySet().iterator();
        }

        public boolean hasNested(String string) {
            return null != this.getNested(string);
        }

        public Scope getNested(String string) {
            return null == this.scopes ? null : this.scopes.get(string);
        }

        public boolean isMergeable(String string) {
            Scope scope = this.getNested(string);
            if (null == scope) {
                throw new IllegalArgumentException("Scope " + this.qName + " does not " + " contain scope " + string);
            }
            if (null != scope.scopes) {
                for (String string2 : scope.scopes.keySet()) {
                    if (string2.equals(string) || !this.scopes.containsKey(string2)) continue;
                    return false;
                }
            }
            if (null != this.symbols && null != scope.symbols) {
                for (String string2 : scope.symbols.keySet()) {
                    if (!this.symbols.containsKey(string2)) continue;
                    return false;
                }
            }
            return true;
        }

        public void merge(String string) {
            Scope scope = this.getNested(string);
            if (!this.isMergeable(string)) {
                throw new IllegalArgumentException("Scope " + scope.qName + " cannot be merged into the parent");
            }
            this.scopes.remove(string);
            if (null != scope.scopes) {
                this.scopes.putAll(scope.scopes);
                for (Scope scope2 : scope.scopes.values()) {
                    scope2.parent = this;
                    scope2.requalify();
                }
            }
            if (null != scope.symbols) {
                if (null == this.symbols) {
                    this.symbols = scope.symbols;
                } else {
                    this.symbols.putAll(scope.symbols);
                }
            }
            scope.parent = null;
            scope.name = null;
            scope.qName = null;
            scope.scopes = null;
            scope.symbols = null;
        }

        public boolean hasSymbols() {
            return null != this.symbols && 0 < this.symbols.size();
        }

        public Iterator<String> symbols() {
            if (null == this.symbols) {
                return EmptyIterator.value();
            }
            return this.symbols.keySet().iterator();
        }

        public boolean isDefinedLocally(String string) {
            return null == this.symbols ? false : this.symbols.containsKey(string);
        }

        public boolean isDefined(String string) {
            return null != this.lookupScope(string);
        }

        public boolean isDefinedMultiply(String string) {
            Scope scope = this.lookupScope(string);
            return null == scope ? false : scope.symbols.get(string) instanceof List;
        }

        public Scope lookupScope(String string) {
            Scope scope = this;
            do {
                if (null == scope.symbols || !scope.symbols.containsKey(string)) continue;
                return scope;
            } while (null != (scope = scope.parent));
            return null;
        }

        public Object lookup(String string) {
            Scope scope = this.lookupScope(string);
            return null == scope ? null : scope.symbols.get(string);
        }

        public Scope lookupBoundScope(String string) {
            Scope scope = this.lookupScope(string);
            return null == scope ? null : scope.getNested(string);
        }

        public Object lookupLocally(String string) {
            return null == this.symbols ? null : this.symbols.get(string);
        }

        public void define(String string, Object object) {
            if (null == this.symbols) {
                this.symbols = new HashMap<String, Object>();
            }
            this.symbols.put(string, object);
        }

        public void addDefinition(String string, Object object) {
            if (null == this.symbols) {
                this.symbols = new HashMap<String, Object>();
            }
            if (this.symbols.containsKey(string)) {
                Object object2 = this.symbols.get(string);
                if (object2 instanceof List) {
                    ((List)object2).add(object);
                } else {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    arrayList.add(object2);
                    arrayList.add(object);
                    this.symbols.put(string, arrayList);
                }
            } else {
                this.symbols.put(string, object);
            }
        }

        public void undefine(String string) {
            if (null != this.symbols) {
                this.symbols.remove(string);
            }
        }

        public String qualify(String string) {
            return Utilities.qualify(this.qName, string);
        }

        public void dump(Printer printer) {
            boolean bl = null != printer.visitor();
            printer.indent().p('.').p(this.name).pln(" = {").incr();
            if (null != this.symbols) {
                for (Map.Entry<String, Object> object : this.symbols.entrySet()) {
                    String string = object.getKey();
                    Object object2 = object.getValue();
                    printer.indent().p(string).p(" = ");
                    if (null == object2) {
                        printer.p("null");
                    } else if (bl && object2 instanceof Node) {
                        printer.p((Node)object2);
                    } else if (object2 instanceof String) {
                        printer.p('\"').escape((String)object2, 8).p('\"');
                    } else {
                        try {
                            printer.p(object2.toString());
                        }
                        catch (Exception exception) {
                            printer.p(object2.getClass().getName() + "@?");
                        }
                    }
                    printer.pln(';');
                    Scope scope = this.getNested(string);
                    if (null == scope) continue;
                    scope.dump(printer);
                }
            }
            if (null != this.scopes) {
                for (Scope scope : this.scopes.values()) {
                    if (null != this.symbols && this.symbols.containsKey(scope.name)) continue;
                    scope.dump(printer);
                }
            }
            printer.decr().indent().pln("};");
        }
    }
}

