/*
 * Decompiled with CFR 0.152.
 */
package xtc.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Statistics {
    private List<Double> numbers = new ArrayList<Double>();

    public void reset() {
        this.numbers.clear();
    }

    public void add(double d) {
        this.numbers.add(d);
    }

    public int size() {
        return this.numbers.size();
    }

    public double get(int n) {
        return this.numbers.get(n);
    }

    public double sum() {
        double d = 0.0;
        int n = this.numbers.size();
        for (int i = 0; i < n; ++i) {
            d += this.numbers.get(i).doubleValue();
        }
        return d;
    }

    public double mean() {
        double d = 0.0;
        int n = this.numbers.size();
        for (int i = 0; i < n; ++i) {
            d += (this.numbers.get(i) - d) / (double)(i + 1);
        }
        return d;
    }

    public double median() {
        if (0 == this.size()) {
            return 0.0;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(this.numbers);
        Collections.sort(arrayList);
        return (Double)arrayList.get(this.size() / 2);
    }

    public double stdev() {
        double d = this.mean();
        double d2 = 0.0;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            double d3 = this.numbers.get(i) - d;
            d2 += (d3 * d3 - d2) / (double)(i + 1);
        }
        return Math.sqrt(d2);
    }

    public static double round(double d) {
        return Math.floor(d * 100.0 + 0.5) / 100.0;
    }

    public static double fitSlope(Statistics statistics, Statistics statistics2) {
        int n;
        if (statistics.size() != statistics2.size()) {
            throw new IllegalArgumentException("Inconsistent collection sizes");
        }
        if (0 == statistics.size()) {
            throw new IllegalArgumentException("Empty collections");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = statistics.size();
        for (n = 0; n < n2; ++n) {
            d += (statistics.get(n) - d) / (double)(n + 1);
            d2 += (statistics2.get(n) - d2) / (double)(n + 1);
        }
        for (n = 0; n < n2; ++n) {
            double d5 = statistics.get(n) - d;
            double d6 = statistics2.get(n) - d2;
            d3 += (d5 * d5 - d3) / (double)(n + 1);
            d4 += (d5 * d6 - d4) / (double)(n + 1);
        }
        return (d * d2 + d4) / (d * d + d3);
    }
}

