/*
 * Decompiled with CFR 0.152.
 */
package xtc.typical;

import java.util.ArrayList;
import java.util.Iterator;
import xtc.tree.Node;
import xtc.typical.Analyzer;
import xtc.util.Pair;
import xtc.util.Runtime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reduction {
    protected Runtime runtime;
    protected Node location;
    protected Pair<Node> target;
    protected ArrayList<Analyzer.NodeMatch[]> patterns;
    protected ArrayList<Object> results;
    protected Pair<Object> matches = Pair.empty();
    protected boolean sing = false;
    protected boolean req = false;
    protected boolean dup = false;
    protected boolean nodup = false;
    protected boolean set = false;
    protected boolean opt = false;
    protected boolean list = false;
    protected boolean error = false;
    protected String tag;

    public Reduction(Pair<Node> pair, Runtime runtime, Node node) {
        this.patterns = new ArrayList();
        this.results = new ArrayList();
        this.target = pair;
        this.location = node;
        this.runtime = runtime;
        this.nodup = true;
    }

    public void addPattern(Object object, Analyzer.NodeMatch ... nodeMatchArray) {
        this.results.add(object);
        this.patterns.add(nodeMatchArray);
    }

    public void setOpt() {
        this.opt = true;
    }

    public void setList() {
        this.list = true;
    }

    public void setSet() {
        this.set = true;
    }

    public void setSing() {
        this.sing = true;
    }

    public void setReq() {
        this.req = true;
    }

    public void setNodup() {
        this.nodup = true;
    }

    public void setDup() {
        this.dup = true;
    }

    public void setTag(String string) {
        this.tag = string;
    }

    public Object apply() {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = false;
        for (Node node : this.target) {
            node.setProperty("used", "no");
        }
        for (n = 0; n < this.patterns.size(); ++n) {
            boolean bl2;
            boolean bl3 = true;
            int n2 = 0;
            for (Analyzer.NodeMatch nodeMatch : this.patterns.get(n)) {
                bl2 = this.isMatch(nodeMatch);
                if (bl2) {
                    ++n2;
                }
                bl3 = bl3 && bl2;
            }
            if (bl3 && n2 == this.patterns.get(n).length) {
                arrayList.add(n);
                for (Node node : this.target) {
                    if (!"maybe".equals(node.getProperty("used"))) continue;
                    node.setProperty("used", "yes");
                }
                if (!this.nodup) continue;
                bl3 = true;
                n2 = 0;
                for (Analyzer.NodeMatch nodeMatch : this.patterns.get(n)) {
                    bl2 = this.isMatch(nodeMatch);
                    if (bl2) {
                        ++n2;
                    }
                    bl3 = bl3 && bl2;
                }
                if (!bl3 || n2 != this.patterns.get(n).length) continue;
                bl = true;
                continue;
            }
            for (Node node : this.target) {
                if (!"maybe".equals(node.getProperty("used"))) continue;
                node.setProperty("used", "no");
            }
        }
        n = arrayList.size();
        if (bl) {
            this.runtime.error("duplicate " + this.tag + "s defined");
            return null;
        }
        if (this.sing && n > 1) {
            this.runtime.error("multiple " + this.tag + "s defined", this.location);
            return null;
        }
        if (this.req && n == 0) {
            this.runtime.error("required " + this.tag, this.location);
            return null;
        }
        if (this.list) {
            Pair<Object> pair = Pair.EMPTY;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n3 = (Integer)iterator.next();
                pair = new Pair<Object>(this.results.get(n3), pair);
            }
            return pair.reverse();
        }
        if (arrayList.size() > 0) {
            return this.results.get((Integer)arrayList.get(0));
        }
        return null;
    }

    private boolean isMatch(Analyzer.NodeMatch nodeMatch) {
        for (Node node : this.target) {
            if (!"no".equals(node.getProperty("used")) || !((Boolean)nodeMatch.apply(node)).booleanValue()) continue;
            node.setProperty("used", "maybe");
            return true;
        }
        return false;
    }

    public Node getMatch(Analyzer.NodeMatch nodeMatch) {
        for (Node node : this.target) {
            if (!((Boolean)nodeMatch.apply(node)).booleanValue()) continue;
            return node;
        }
        return null;
    }
}

