/*
 * Decompiled with CFR 0.152.
 */
package xtc.typical;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import xtc.tree.Node;
import xtc.util.Function;
import xtc.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Primitives {
    private static final BigInteger INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final Function.F1<Boolean, Object> isBottom = new Function.F1<Boolean, Object>(){

        @Override
        public Boolean apply(Object object) {
            return null == object;
        }
    };
    public static final Function.F1<Boolean, Object> isNotBottom = new Function.F1<Boolean, Object>(){

        @Override
        public Boolean apply(Object object) {
            return null != object;
        }
    };
    public static final Function.F1<Boolean, Boolean> not = new Function.F1<Boolean, Boolean>(){

        @Override
        public Boolean apply(Boolean bl) {
            return null == bl ? null : Boolean.valueOf(bl == false);
        }
    };
    public static final Function.F2<Boolean, Boolean, Boolean> and = new Function.F2<Boolean, Boolean, Boolean>(){

        @Override
        public Boolean apply(Boolean bl, Boolean bl2) {
            return null == bl || null == bl2 ? null : Boolean.valueOf(bl != false && bl2 != false);
        }
    };
    public static final Function.F2<Boolean, Boolean, Boolean> or = new Function.F2<Boolean, Boolean, Boolean>(){

        @Override
        public Boolean apply(Boolean bl, Boolean bl2) {
            return null == bl || null == bl2 ? null : Boolean.valueOf(bl != false || bl2 != false);
        }
    };
    public static final Function.F2<Boolean, Object, Object> equal = new Function.F2<Boolean, Object, Object>(){

        @Override
        public Boolean apply(Object object, Object object2) {
            return null == object || null == object2 ? null : Boolean.valueOf(object.equals(object2));
        }
    };
    public static final Function.F2<Boolean, BigInteger, BigInteger> lessInt = new Function.F2<Boolean, BigInteger, BigInteger>(){

        @Override
        public Boolean apply(BigInteger bigInteger, BigInteger bigInteger2) {
            return null == bigInteger || null == bigInteger2 ? null : Boolean.valueOf(bigInteger.compareTo(bigInteger2) < 0);
        }
    };
    public static final Function.F2<Boolean, Double, Double> lessFloat64 = new Function.F2<Boolean, Double, Double>(){

        @Override
        public Boolean apply(Double d, Double d2) {
            return null == d || null == d2 ? null : Boolean.valueOf(d < d2);
        }
    };
    public static final Function.F2<Boolean, Float, Float> lessFloat32 = new Function.F2<Boolean, Float, Float>(){

        @Override
        public Boolean apply(Float f, Float f2) {
            return null == f || null == f2 ? null : Boolean.valueOf(f.floatValue() < f2.floatValue());
        }
    };
    public static final Function.F2<Boolean, BigInteger, BigInteger> lessEqualInt = new Function.F2<Boolean, BigInteger, BigInteger>(){

        @Override
        public Boolean apply(BigInteger bigInteger, BigInteger bigInteger2) {
            return null == bigInteger || null == bigInteger2 ? null : Boolean.valueOf(bigInteger.compareTo(bigInteger2) <= 0);
        }
    };
    public static final Function.F2<Boolean, Double, Double> lessEqualFloat64 = new Function.F2<Boolean, Double, Double>(){

        @Override
        public Boolean apply(Double d, Double d2) {
            return null == d || null == d2 ? null : Boolean.valueOf(d <= d2);
        }
    };
    public static final Function.F2<Boolean, Float, Float> lessEqualFloat32 = new Function.F2<Boolean, Float, Float>(){

        @Override
        public Boolean apply(Float f, Float f2) {
            return null == f || null == f2 ? null : Boolean.valueOf(f.floatValue() <= f2.floatValue());
        }
    };
    public static final Function.F2<Boolean, BigInteger, BigInteger> greaterInt = new Function.F2<Boolean, BigInteger, BigInteger>(){

        @Override
        public Boolean apply(BigInteger bigInteger, BigInteger bigInteger2) {
            return null == bigInteger || null == bigInteger2 ? null : Boolean.valueOf(bigInteger.compareTo(bigInteger2) > 0);
        }
    };
    public static final Function.F2<Boolean, Double, Double> greaterFloat64 = new Function.F2<Boolean, Double, Double>(){

        @Override
        public Boolean apply(Double d, Double d2) {
            return null == d || null == d2 ? null : Boolean.valueOf(d > d2);
        }
    };
    public static final Function.F2<Boolean, Float, Float> greaterFloat32 = new Function.F2<Boolean, Float, Float>(){

        @Override
        public Boolean apply(Float f, Float f2) {
            return null == f || null == f2 ? null : Boolean.valueOf(f.floatValue() > f2.floatValue());
        }
    };
    public static final Function.F2<Boolean, BigInteger, BigInteger> greaterEqualInt = new Function.F2<Boolean, BigInteger, BigInteger>(){

        @Override
        public Boolean apply(BigInteger bigInteger, BigInteger bigInteger2) {
            return null == bigInteger || null == bigInteger2 ? null : Boolean.valueOf(bigInteger.compareTo(bigInteger2) >= 0);
        }
    };
    public static final Function.F2<Boolean, Double, Double> greaterEqualFloat64 = new Function.F2<Boolean, Double, Double>(){

        @Override
        public Boolean apply(Double d, Double d2) {
            return null == d || null == d2 ? null : Boolean.valueOf(d >= d2);
        }
    };
    public static final Function.F2<Boolean, Float, Float> greaterEqualFloat32 = new Function.F2<Boolean, Float, Float>(){

        @Override
        public Boolean apply(Float f, Float f2) {
            return null == f || null == f2 ? null : Boolean.valueOf(f.floatValue() >= f2.floatValue());
        }
    };
    public static final Function.F1<BigInteger, BigInteger> negateInt = new Function.F1<BigInteger, BigInteger>(){

        @Override
        public BigInteger apply(BigInteger bigInteger) {
            return null == bigInteger ? null : bigInteger.negate();
        }
    };
    public static final Function.F1<Double, Double> negateFloat64 = new Function.F1<Double, Double>(){

        @Override
        public Double apply(Double d) {
            return null == d ? null : Double.valueOf(-d.doubleValue());
        }
    };
    public static final Function.F1<Float, Float> negateFloat32 = new Function.F1<Float, Float>(){

        @Override
        public Float apply(Float f) {
            return null == f ? null : Float.valueOf(-f.floatValue());
        }
    };
    public static final Function.F1<BigInteger, BigInteger> absInt = new Function.F1<BigInteger, BigInteger>(){

        @Override
        public BigInteger apply(BigInteger bigInteger) {
            return null == bigInteger ? null : bigInteger.abs();
        }
    };
    public static final Function.F1<Double, Double> absFloat64 = new Function.F1<Double, Double>(){

        @Override
        public Double apply(Double d) {
            return null == d ? null : Double.valueOf(d);
        }
    };
    public static final Function.F1<Float, Float> absFloat32 = new Function.F1<Float, Float>(){

        @Override
        public Float apply(Float f) {
            return null == f ? null : Float.valueOf(f.floatValue());
        }
    };
    public static final Function.F2<BigInteger, BigInteger, BigInteger> addInt = new Function.F2<BigInteger, BigInteger, BigInteger>(){

        @Override
        public BigInteger apply(BigInteger bigInteger, BigInteger bigInteger2) {
            return null == bigInteger || null == bigInteger2 ? null : bigInteger.add(bigInteger2);
        }
    };
    public static final Function.F2<Double, Double, Double> addFloat64 = new Function.F2<Double, Double, Double>(){

        @Override
        public Double apply(Double d, Double d2) {
            return null == d || null == d2 ? null : Double.valueOf(d + d2);
        }
    };
    public static final Function.F2<Float, Float, Float> addFloat32 = new Function.F2<Float, Float, Float>(){

        @Override
        public Float apply(Float f, Float f2) {
            return null == f || null == f2 ? null : Float.valueOf(f.floatValue() + f2.floatValue());
        }
    };
    public static final Function.F2<BigInteger, BigInteger, BigInteger> subtractInt = new Function.F2<BigInteger, BigInteger, BigInteger>(){

        @Override
        public BigInteger apply(BigInteger bigInteger, BigInteger bigInteger2) {
            return null == bigInteger || null == bigInteger2 ? null : bigInteger.subtract(bigInteger2);
        }
    };
    public static final Function.F2<Double, Double, Double> subtractFloat64 = new Function.F2<Double, Double, Double>(){

        @Override
        public Double apply(Double d, Double d2) {
            return null == d || null == d2 ? null : Double.valueOf(d - d2);
        }
    };
    public static final Function.F2<Float, Float, Float> subtractFloat32 = new Function.F2<Float, Float, Float>(){

        @Override
        public Float apply(Float f, Float f2) {
            return null == f || null == f2 ? null : Float.valueOf(f.floatValue() - f2.floatValue());
        }
    };
    public static final Function.F2<BigInteger, BigInteger, BigInteger> multiplyInt = new Function.F2<BigInteger, BigInteger, BigInteger>(){

        @Override
        public BigInteger apply(BigInteger bigInteger, BigInteger bigInteger2) {
            return null == bigInteger || null == bigInteger2 ? null : bigInteger.multiply(bigInteger2);
        }
    };
    public static final Function.F2<Double, Double, Double> multiplyFloat64 = new Function.F2<Double, Double, Double>(){

        @Override
        public Double apply(Double d, Double d2) {
            return null == d || null == d2 ? null : Double.valueOf(d * d2);
        }
    };
    public static final Function.F2<Float, Float, Float> multiplyFloat32 = new Function.F2<Float, Float, Float>(){

        @Override
        public Float apply(Float f, Float f2) {
            return null == f || null == f2 ? null : Float.valueOf(f.floatValue() * f2.floatValue());
        }
    };
    public static final Function.F2<BigInteger, BigInteger, BigInteger> divideInt = new Function.F2<BigInteger, BigInteger, BigInteger>(){

        @Override
        public BigInteger apply(BigInteger bigInteger, BigInteger bigInteger2) {
            return null == bigInteger || null == bigInteger2 ? null : bigInteger.divide(bigInteger2);
        }
    };
    public static final Function.F2<Double, Double, Double> divideFloat64 = new Function.F2<Double, Double, Double>(){

        @Override
        public Double apply(Double d, Double d2) {
            return null == d || null == d2 ? null : Double.valueOf(d / d2);
        }
    };
    public static final Function.F2<Float, Float, Float> divideFloat32 = new Function.F2<Float, Float, Float>(){

        @Override
        public Float apply(Float f, Float f2) {
            return null == f || null == f2 ? null : Float.valueOf(f.floatValue() / f2.floatValue());
        }
    };
    public static final Function.F2<BigInteger, BigInteger, BigInteger> modInt = new Function.F2<BigInteger, BigInteger, BigInteger>(){

        @Override
        public BigInteger apply(BigInteger bigInteger, BigInteger bigInteger2) {
            return null == bigInteger || null == bigInteger2 ? null : bigInteger.mod(bigInteger2);
        }
    };
    public static final Function.F2<Double, Double, Double> modFloat64 = new Function.F2<Double, Double, Double>(){

        @Override
        public Double apply(Double d, Double d2) {
            return null == d || null == d2 ? null : Double.valueOf(d % d2);
        }
    };
    public static final Function.F2<Float, Float, Float> modFloat32 = new Function.F2<Float, Float, Float>(){

        @Override
        public Float apply(Float f, Float f2) {
            return null == f || null == f2 ? null : Float.valueOf(f.floatValue() % f2.floatValue());
        }
    };
    public static final Function.F1<BigInteger, BigInteger> negateBits = new Function.F1<BigInteger, BigInteger>(){

        @Override
        public BigInteger apply(BigInteger bigInteger) {
            return null == bigInteger ? null : bigInteger.not();
        }
    };
    public static final Function.F2<BigInteger, BigInteger, BigInteger> andBits = new Function.F2<BigInteger, BigInteger, BigInteger>(){

        @Override
        public BigInteger apply(BigInteger bigInteger, BigInteger bigInteger2) {
            return null == bigInteger || null == bigInteger2 ? null : bigInteger.and(bigInteger2);
        }
    };
    public static final Function.F2<BigInteger, BigInteger, BigInteger> orBits = new Function.F2<BigInteger, BigInteger, BigInteger>(){

        @Override
        public BigInteger apply(BigInteger bigInteger, BigInteger bigInteger2) {
            return null == bigInteger || null == bigInteger2 ? null : bigInteger.or(bigInteger2);
        }
    };
    public static final Function.F2<BigInteger, BigInteger, BigInteger> xorBits = new Function.F2<BigInteger, BigInteger, BigInteger>(){

        @Override
        public BigInteger apply(BigInteger bigInteger, BigInteger bigInteger2) {
            return null == bigInteger || null == bigInteger2 ? null : bigInteger.xor(bigInteger2);
        }
    };
    public static final Function.F2<BigInteger, BigInteger, BigInteger> shiftLeft = new Function.F2<BigInteger, BigInteger, BigInteger>(){

        @Override
        public BigInteger apply(BigInteger bigInteger, BigInteger bigInteger2) {
            return null == bigInteger || null == bigInteger2 ? null : bigInteger.shiftLeft(Primitives.toInt(bigInteger2));
        }
    };
    public static final Function.F2<BigInteger, BigInteger, BigInteger> shiftRight = new Function.F2<BigInteger, BigInteger, BigInteger>(){

        @Override
        public BigInteger apply(BigInteger bigInteger, BigInteger bigInteger2) {
            return null == bigInteger || null == bigInteger2 ? null : bigInteger.shiftRight(Primitives.toInt(bigInteger2));
        }
    };
    public static final Function.F1<Double, BigInteger> itof = new Function.F1<Double, BigInteger>(){

        @Override
        public Double apply(BigInteger bigInteger) {
            return null == bigInteger ? null : Double.valueOf(bigInteger.doubleValue());
        }
    };
    public static final Function.F1<BigInteger, Double> ftoi = new Function.F1<BigInteger, Double>(){

        @Override
        public BigInteger apply(Double d) {
            return null == d ? null : new BigInteger(d.toString());
        }
    };
    public static final Function.F2<Pair, Object, Pair> cons = new Function.F2<Pair, Object, Pair>(){

        @Override
        public Pair apply(Object object, Pair pair) {
            return null == pair ? null : new Pair<Object>(object, pair);
        }
    };
    public static final Function.F1<Boolean, Pair<?>> isEmpty = new Function.F1<Boolean, Pair<?>>(){

        @Override
        public Boolean apply(Pair<?> pair) {
            return null == pair ? null : Boolean.valueOf(pair.isEmpty());
        }
    };
    public static final Function.F1<Object, Pair<?>> head = new Function.F1<Object, Pair<?>>(){

        @Override
        public Object apply(Pair<?> pair) {
            return null == pair || pair.isEmpty() ? null : pair.head();
        }
    };
    public static final Function.F1<Pair<?>, Pair<?>> tail = new Function.F1<Pair<?>, Pair<?>>(){

        @Override
        public Pair<?> apply(Pair<?> pair) {
            return null == pair || pair.isEmpty() ? null : pair.tail();
        }
    };
    public static final Function.F1<BigInteger, Pair<?>> length = new Function.F1<BigInteger, Pair<?>>(){

        @Override
        public BigInteger apply(Pair<?> pair) {
            return null == pair ? null : BigInteger.valueOf(pair.size());
        }
    };
    public static final Function.F2<Object, Pair<?>, BigInteger> nth = new Function.F2<Object, Pair<?>, BigInteger>(){

        @Override
        public Object apply(Pair<?> pair, BigInteger bigInteger) {
            return null == pair || null == bigInteger ? null : pair.get(Primitives.toInt(bigInteger));
        }
    };
    public static final Function.F2<Boolean, Object, Pair<?>> contains = new Function.F2<Boolean, Object, Pair<?>>(){

        @Override
        public Boolean apply(Object object, Pair<?> pair) {
            return null == object || null == pair ? null : Boolean.valueOf(pair.contains(object));
        }
    };
    public static final Function.F2<Boolean, Function.F1<Boolean, Object>, Pair> exists = new Function.F2<Boolean, Function.F1<Boolean, Object>, Pair>(){

        @Override
        public Boolean apply(Function.F1<Boolean, Object> f1, Pair pair) {
            return null == f1 || null == pair ? null : Boolean.valueOf(Function.matchesOne(f1, pair));
        }
    };
    public static final Function.F2<Object, Function.F1<Object, Object>, Pair> iter = new Function.F2<Object, Function.F1<Object, Object>, Pair>(){

        @Override
        public Object apply(Function.F1<Object, Object> f1, Pair pair) {
            if (null == f1 || null == pair) {
                return null;
            }
            Function.iterate(f1, pair);
            return null;
        }
    };
    public static final Function.F2<Pair, Function.F1<Object, Object>, Pair> map = new Function.F2<Pair, Function.F1<Object, Object>, Pair>(){

        @Override
        public Pair apply(Function.F1<Object, Object> f1, Pair pair) {
            return null == f1 || null == pair ? null : Function.map(f1, pair);
        }
    };
    public static final Function.F3<Object, Function.F2<Object, Object, Object>, Pair, Object> foldl = new Function.F3<Object, Function.F2<Object, Object, Object>, Pair, Object>(){

        @Override
        public Object apply(Function.F2<Object, Object, Object> f2, Pair pair, Object object) {
            return null == f2 || null == pair || null == object ? null : Function.foldl(f2, object, pair);
        }
    };
    public static final Function.F2<Pair, Pair, Pair> append = new Function.F2<Pair, Pair, Pair>(){

        @Override
        public Pair apply(Pair pair, Pair pair2) {
            return null == pair || null == pair2 ? null : pair.append(pair2);
        }
    };
    public static final Function.F2<Pair, Pair, Pair> union = new Function.F2<Pair, Pair, Pair>(){

        @Override
        public Pair apply(Pair pair, Pair pair2) {
            return null == pair || null == pair2 ? null : pair.combine(pair2);
        }
    };
    public static final Function.F2<Pair, Pair, Pair> intersection = new Function.F2<Pair, Pair, Pair>(){

        @Override
        public Pair apply(Pair pair, Pair pair2) {
            return null == pair || null == pair2 ? null : pair.intersect(pair2);
        }
    };
    public static final Function.F2<Pair, Pair, Pair> subtraction = new Function.F2<Pair, Pair, Pair>(){

        @Override
        public Pair apply(Pair pair, Pair pair2) {
            return null == pair || null == pair2 ? null : pair.subtract(pair2);
        }
    };
    public static final Function.F2<String, String, String> concat = new Function.F2<String, String, String>(){

        @Override
        public String apply(String string, String string2) {
            return null == string || null == string2 ? null : string + string2;
        }
    };
    public static final Function.F1<BigInteger, String> ssize = new Function.F1<BigInteger, String>(){

        @Override
        public BigInteger apply(String string) {
            return null == string ? null : BigInteger.valueOf(string.length());
        }
    };
    public static final Function.F2<BigInteger, String, BigInteger> stoi = new Function.F2<BigInteger, String, BigInteger>(){

        @Override
        public BigInteger apply(String string, BigInteger bigInteger) {
            return null == string ? null : new BigInteger(string, bigInteger.intValue());
        }
    };
    public static final Function.F2<Boolean, String, String> startsWith = new Function.F2<Boolean, String, String>(){

        @Override
        public Boolean apply(String string, String string2) {
            return null == string || null == string2 ? null : Boolean.valueOf(string.startsWith(string2));
        }
    };
    public static final Function.F2<Boolean, String, String> startsWithi = new Function.F2<Boolean, String, String>(){

        @Override
        public Boolean apply(String string, String string2) {
            return null == string || null == string2 ? null : Boolean.valueOf(string.toLowerCase().startsWith(string2.toLowerCase()));
        }
    };
    public static final Function.F2<Boolean, String, String> endsWith = new Function.F2<Boolean, String, String>(){

        @Override
        public Boolean apply(String string, String string2) {
            return null == string || null == string2 ? null : Boolean.valueOf(string.endsWith(string2));
        }
    };
    public static final Function.F2<Boolean, String, String> endsWithi = new Function.F2<Boolean, String, String>(){

        @Override
        public Boolean apply(String string, String string2) {
            return null == string || null == string2 ? null : Boolean.valueOf(string.toLowerCase().endsWith(string2.toLowerCase()));
        }
    };
    public static final Function.F1<String, Pair<String>> joinStrings = new Function.F1<String, Pair<String>>(){

        @Override
        public String apply(Pair<String> pair) {
            if (null == pair) {
                return null;
            }
            String string = "";
            Iterator<String> iterator = pair.iterator();
            while (iterator.hasNext()) {
                string = string + iterator.next();
            }
            return string.trim();
        }
    };
    public static final Function.F2<String, String, BigInteger> substring = new Function.F2<String, String, BigInteger>(){

        @Override
        public String apply(String string, BigInteger bigInteger) {
            return null == string || null == bigInteger ? null : string.substring(bigInteger.intValue());
        }
    };
    public static final Function.F3<String, String, BigInteger, BigInteger> substring2 = new Function.F3<String, String, BigInteger, BigInteger>(){

        @Override
        public String apply(String string, BigInteger bigInteger, BigInteger bigInteger2) {
            return null == string || null == bigInteger || null == bigInteger2 ? null : string.substring(bigInteger.intValue(), bigInteger2.intValue());
        }
    };
    public static final Function.F1<Double, String> stof = new Function.F1<Double, String>(){

        @Override
        public Double apply(String string) {
            return null == string ? null : Double.valueOf(string);
        }
    };
    public static final Function.F1<String, BigInteger> itos = new Function.F1<String, BigInteger>(){

        @Override
        public String apply(BigInteger bigInteger) {
            return null == bigInteger ? null : bigInteger.toString();
        }
    };
    public static final Function.F1<String, Double> ftos = new Function.F1<String, Double>(){

        @Override
        public String apply(Double d) {
            return null == d ? null : d.toString();
        }
    };
    protected static BigInteger nonceCounter = BigInteger.ZERO;
    public static final Function.F0<BigInteger> nonce = new Function.F0<BigInteger>(){

        @Override
        public BigInteger apply() {
            nonceCounter = nonceCounter.add(BigInteger.ONE);
            return nonceCounter;
        }
    };
    public static final Function.F1<Object, Object> trace = new Function.F1<Object, Object>(){

        @Override
        public Object apply(Object object) {
            Primitives.trace("", object);
            return object;
        }
    };
    public static final Function.F2<Object, String, Object> trace2 = new Function.F2<Object, String, Object>(){

        @Override
        public Object apply(String string, Object object) {
            Primitives.trace(string, object);
            return object;
        }
    };
    public static final Function.F3<Object, Node, String, Object> annotate = new Function.F3<Object, Node, String, Object>(){

        @Override
        public final Object apply(Node node, String string, Object object) {
            if (null == node || null == string || null == object) {
                return null;
            }
            node.setProperty(string, object);
            return object;
        }
    };
    public static final Function.F3<Object, Pair<Node>, String, Object> annotateList = new Function.F3<Object, Pair<Node>, String, Object>(){

        @Override
        public final Object apply(Pair<Node> pair, String string, Object object) {
            for (Node node : pair) {
                if (null == node) continue;
                node.setProperty(string, object);
            }
            return object;
        }
    };
    public static final Function.F2<Object, Node, String> getAnnotation = new Function.F2<Object, Node, String>(){

        @Override
        public final Object apply(Node node, String string) {
            if (null == node || null == string) {
                return null;
            }
            return node.hasProperty(string) ? node.getProperty(string) : null;
        }
    };
    public static final Function.F2<Boolean, Node, String> hasAnnotation = new Function.F2<Boolean, Node, String>(){

        @Override
        public final Boolean apply(Node node, String string) {
            return null == node || null == string ? null : Boolean.valueOf(node.hasProperty(string));
        }
    };
    public static final Function.F1<String, Object> node_name = new Function.F1<String, Object>(){

        @Override
        public final String apply(Object object) {
            if (null == object) {
                return "?";
            }
            if (!(object instanceof Node)) {
                throw new IllegalStateException("calling nodeName on non-node");
            }
            return ((Node)object).getName();
        }
    };
    public static final Function.F2<Object, Object, Hashtable<Object, Object>> get = new Function.F2<Object, Object, Hashtable<Object, Object>>(){

        @Override
        public final Object apply(Object object, Hashtable<Object, Object> hashtable) {
            return null == object ? null : hashtable.get(object);
        }
    };
    public static final Function.F3<Void, Object, Object, Hashtable<Object, Object>> put = new Function.F3<Void, Object, Object, Hashtable<Object, Object>>(){

        @Override
        public final Void apply(Object object, Object object2, Hashtable<Object, Object> hashtable) {
            if (null == object || null == object2) {
                return null;
            }
            hashtable.put(object, object2);
            return null;
        }
    };
    private static Set<String> PRIMITIVE_FUNCTIONS = new HashSet<String>();
    private static java.util.Map<String, String> PRIMITIVE_NAMES;
    private static Set<String> INTEGER_TYPES;

    private Primitives() {
    }

    public static final int toInt(BigInteger bigInteger) {
        if (bigInteger.compareTo(INT_MIN) < 0 || bigInteger.compareTo(INT_MAX) > 0) {
            throw new IllegalArgumentException("integer too large: " + bigInteger);
        }
        return bigInteger.intValue();
    }

    public static final void trace(String string, Object object) {
        System.out.print(string);
        if (null == object) {
            System.out.println("bottom");
        } else {
            System.out.println(object.toString());
        }
        System.out.flush();
    }

    public static final <T> Pair<T> wrapCons(T t, Pair<T> pair) {
        return cons.apply(t, pair);
    }

    public static final <T> T wrapHead(Pair<T> pair) {
        return (T)head.apply(pair);
    }

    public static final <T> Pair<T> wrapTail(Pair<T> pair) {
        return tail.apply(pair);
    }

    public static final <T> Pair<T> wrapAppend(Pair<T> pair, Pair<T> pair2) {
        return append.apply(pair, pair2);
    }

    public static final <T> T findInPair(Object object, Pair<T> pair) {
        if (null == object || null == pair) {
            return null;
        }
        for (T t : pair) {
            if (!object.equals(t)) continue;
            return t;
        }
        return null;
    }

    public static final <T, R> Pair<T> copyPair(Pair<R> pair) {
        if (null == pair) {
            return null;
        }
        Pair<R> pair2 = Pair.empty();
        Iterator<R> iterator = pair.iterator();
        while (iterator.hasNext()) {
            pair2 = pair2.append(new Pair<R>(iterator.next()));
        }
        return pair2;
    }

    public static final <T> Pair<T> removeFromPair(Object object, Pair<T> pair) {
        if (null == pair) {
            return null;
        }
        Pair<T> pair2 = Pair.empty();
        for (T t : pair) {
            if (object.equals(t)) continue;
            pair2 = pair2.append(new Pair<T>(t));
        }
        return pair2;
    }

    public static final <T> Pair<T> wrapUnion(Pair<T> pair, Pair<T> pair2) {
        return union.apply(pair, pair2);
    }

    public static final <T> Pair<T> getChildren(Node node, int n, int n2) {
        if (n2 > node.size()) {
            throw new RuntimeException("bad index for get children");
        }
        Pair<Object> pair = Pair.empty();
        if (node.size() > n) {
            pair = new Pair<Object>(node.get(n));
        }
        for (int i = n + 1; i < n2; ++i) {
            pair = pair.append(new Pair<Object>(node.get(i)));
        }
        return pair;
    }

    public static boolean isPrimitive(String string) {
        return PRIMITIVE_FUNCTIONS.contains(string);
    }

    public static String convertName(String string) {
        return PRIMITIVE_NAMES.containsKey(string) ? PRIMITIVE_NAMES.get(string) : string;
    }

    public static boolean hasIntegerType(String string) {
        return INTEGER_TYPES.contains(string);
    }

    static {
        PRIMITIVE_FUNCTIONS.add("nonce");
        PRIMITIVE_FUNCTIONS.add("isBottom");
        PRIMITIVE_FUNCTIONS.add("isNotBottom");
        PRIMITIVE_FUNCTIONS.add("negateInt");
        PRIMITIVE_FUNCTIONS.add("negateFloat64");
        PRIMITIVE_FUNCTIONS.add("negateBits");
        PRIMITIVE_FUNCTIONS.add("andBits");
        PRIMITIVE_FUNCTIONS.add("orBits");
        PRIMITIVE_FUNCTIONS.add("xorBits");
        PRIMITIVE_FUNCTIONS.add("shiftLeft");
        PRIMITIVE_FUNCTIONS.add("shiftRight");
        PRIMITIVE_FUNCTIONS.add("cons");
        PRIMITIVE_FUNCTIONS.add("isEmpty");
        PRIMITIVE_FUNCTIONS.add("head");
        PRIMITIVE_FUNCTIONS.add("tail");
        PRIMITIVE_FUNCTIONS.add("length");
        PRIMITIVE_FUNCTIONS.add("nth");
        PRIMITIVE_FUNCTIONS.add("containts");
        PRIMITIVE_FUNCTIONS.add("exists");
        PRIMITIVE_FUNCTIONS.add("append");
        PRIMITIVE_FUNCTIONS.add("union");
        PRIMITIVE_FUNCTIONS.add("intersection");
        PRIMITIVE_FUNCTIONS.add("subtraction");
        PRIMITIVE_FUNCTIONS.add("concat");
        PRIMITIVE_FUNCTIONS.add("stoi");
        PRIMITIVE_FUNCTIONS.add("stof");
        PRIMITIVE_FUNCTIONS.add("trace");
        PRIMITIVE_FUNCTIONS.add("trace2");
        PRIMITIVE_FUNCTIONS.add("ssize");
        PRIMITIVE_FUNCTIONS.add("ftoi");
        PRIMITIVE_FUNCTIONS.add("joinStrings");
        PRIMITIVE_FUNCTIONS.add("absInt");
        PRIMITIVE_FUNCTIONS.add("absFloat64");
        PRIMITIVE_FUNCTIONS.add("startsWith");
        PRIMITIVE_FUNCTIONS.add("startsWithi");
        PRIMITIVE_FUNCTIONS.add("endsWith");
        PRIMITIVE_FUNCTIONS.add("endsWithi");
        PRIMITIVE_FUNCTIONS.add("substring");
        PRIMITIVE_FUNCTIONS.add("substring2");
        PRIMITIVE_FUNCTIONS.add("iter");
        PRIMITIVE_FUNCTIONS.add("foldl");
        PRIMITIVE_FUNCTIONS.add("annotate");
        PRIMITIVE_FUNCTIONS.add("annotateList");
        PRIMITIVE_FUNCTIONS.add("node_name");
        PRIMITIVE_FUNCTIONS.add("getAnnotation");
        PRIMITIVE_FUNCTIONS.add("hasAnnotation");
        PRIMITIVE_FUNCTIONS.add("map");
        PRIMITIVE_NAMES = new HashMap<String, String>();
        PRIMITIVE_NAMES.put("is_bottom", "isBottom");
        PRIMITIVE_NAMES.put("is_not_bottom", "isNotBottom");
        PRIMITIVE_NAMES.put("negate_int", "negateInt");
        PRIMITIVE_NAMES.put("negate_float", "negateFloat64");
        PRIMITIVE_NAMES.put("negate_bits", "negateBits");
        PRIMITIVE_NAMES.put("and_bits", "andBits");
        PRIMITIVE_NAMES.put("or_bits", "orBits");
        PRIMITIVE_NAMES.put("xor_bits", "xorBits");
        PRIMITIVE_NAMES.put("shift_left", "shiftLeft");
        PRIMITIVE_NAMES.put("shift_right", "shiftRight");
        PRIMITIVE_NAMES.put("is_empty", "isEmpty");
        PRIMITIVE_NAMES.put("mem", "contains");
        PRIMITIVE_NAMES.put("not_bottom", "notBottom");
        PRIMITIVE_NAMES.put("is_defined", "isDefined");
        PRIMITIVE_NAMES.put("lookup_locally", "lookupLocally");
        PRIMITIVE_NAMES.put("is_defined_locally", "isDefinedLocally");
        PRIMITIVE_NAMES.put("lookup_node", "lookupNode");
        PRIMITIVE_NAMES.put("define_node", "defineNode");
        PRIMITIVE_NAMES.put("annotate_list", "annotateList");
        PRIMITIVE_NAMES.put("has_annotation", "hasAnnotation");
        PRIMITIVE_NAMES.put("get_annotation", "getAnnotation");
        PRIMITIVE_NAMES.put("fresh_name", "freshName");
        PRIMITIVE_NAMES.put("remove_last", "removeLast");
        PRIMITIVE_NAMES.put("abs_int", "absInt");
        PRIMITIVE_NAMES.put("abs_float", "absFloat64");
        PRIMITIVE_NAMES.put("join_strings", "joinStrings");
        PRIMITIVE_NAMES.put("starts_with", "startsWith");
        PRIMITIVE_NAMES.put("starts_withi", "startsWithi");
        PRIMITIVE_NAMES.put("ends_with", "endsWith");
        PRIMITIVE_NAMES.put("ends_withi", "endsWithi");
        PRIMITIVE_NAMES.put("node_type", "nodeType");
        PRIMITIVE_NAMES.put("is_big_endian", "IS_BIG_ENDIAN");
        PRIMITIVE_NAMES.put("void_size", "VOID_SIZE");
        PRIMITIVE_NAMES.put("bool_size", "BOOL_SIZE");
        PRIMITIVE_NAMES.put("pointer_size", "POINTER_SIZE");
        PRIMITIVE_NAMES.put("pointer_align", "POINTER_ALIGN");
        PRIMITIVE_NAMES.put("pointer_nat_align", "POINTER_NAT_ALIGN");
        PRIMITIVE_NAMES.put("ptrdiff_rank", "PTRDIFF_RANK");
        PRIMITIVE_NAMES.put("sizeof_rank", "SIZEOF_RANK");
        PRIMITIVE_NAMES.put("ptrdiff_size", "PTRDIFF_SIZE");
        PRIMITIVE_NAMES.put("sizeof_size", "SIZEOF_SIZE");
        PRIMITIVE_NAMES.put("array_max", "ARRAY_MAX");
        PRIMITIVE_NAMES.put("is_char_signed", "IS_CHAR_SIGNED");
        PRIMITIVE_NAMES.put("char_bits", "CHAR_BITS");
        PRIMITIVE_NAMES.put("char_min", "CHAR_MIN");
        PRIMITIVE_NAMES.put("char_max", "CHAR_MAX");
        PRIMITIVE_NAMES.put("char_mod", "CHAR_MOD");
        PRIMITIVE_NAMES.put("uchar_mac", "UCHAR_MAX");
        PRIMITIVE_NAMES.put("uchar_mod", "UCHAR_MOD");
        PRIMITIVE_NAMES.put("is_wchar_signed", "IS_WCHAR_SIGNED");
        PRIMITIVE_NAMES.put("wchar_rank", "WCHAR_RANK");
        PRIMITIVE_NAMES.put("wchar_size", "WCHAR_SIZE");
        PRIMITIVE_NAMES.put("void_align", "VOID_ALIGN");
        PRIMITIVE_NAMES.put("bool_align", "BOOL_ALIGN");
        PRIMITIVE_NAMES.put("bool_nat_align", "BOOL_NAT_ALIGN");
        PRIMITIVE_NAMES.put("short_size", "SHORT_SIZE");
        PRIMITIVE_NAMES.put("short_align", "SHORT_ALIGN");
        PRIMITIVE_NAMES.put("short_nat_align", "SHORT_NAT_ALIGN");
        PRIMITIVE_NAMES.put("short_bits", "SHORT_BITS");
        PRIMITIVE_NAMES.put("short_min", "SHORT_MIN");
        PRIMITIVE_NAMES.put("short_max", "SHORT_MAX");
        PRIMITIVE_NAMES.put("short_mod", "SHORT_MOD");
        PRIMITIVE_NAMES.put("ushort_max", "USHORT_MAX");
        PRIMITIVE_NAMES.put("ushort_mod", "USHORT_MOD");
        PRIMITIVE_NAMES.put("is_int_signed", "IS_INT_SIGNED");
        PRIMITIVE_NAMES.put("int_size", "INT_SIZE");
        PRIMITIVE_NAMES.put("int_align", "INT_ALIGN");
        PRIMITIVE_NAMES.put("int_nat_align", "INT_NAT_ALIGN");
        PRIMITIVE_NAMES.put("int_bits", "INT_BITS");
        PRIMITIVE_NAMES.put("int_min", "INT_MIN");
        PRIMITIVE_NAMES.put("int_max", "INT_MAX");
        PRIMITIVE_NAMES.put("int_mod", "INT_MOD");
        PRIMITIVE_NAMES.put("uint_max", "UINT_MAX");
        PRIMITIVE_NAMES.put("uint_mod", "UINT_MOD");
        PRIMITIVE_NAMES.put("long_size", "LONG_SIZE");
        PRIMITIVE_NAMES.put("long_align", "LONG_ALIGN");
        PRIMITIVE_NAMES.put("long_nat_align", "LONG_NAT_ALIGN");
        PRIMITIVE_NAMES.put("long_bits", "LONG_BITS");
        PRIMITIVE_NAMES.put("long_min", "LONG_MIN");
        PRIMITIVE_NAMES.put("long_max", "LONG_MAX");
        PRIMITIVE_NAMES.put("long_mod", "LONG_MOD");
        PRIMITIVE_NAMES.put("ulong_max", "ULONG_MAX");
        PRIMITIVE_NAMES.put("ulong_mod", "ULONG_MOD");
        PRIMITIVE_NAMES.put("long_long_size", "LONG_LONG_SIZE");
        PRIMITIVE_NAMES.put("long_long_align", "LONG_LONG_ALIGN");
        PRIMITIVE_NAMES.put("long_long_nat_align", "LONG_LONG_NAT_ALIGN");
        PRIMITIVE_NAMES.put("long_long_bits", "LONG_LONG_BITS");
        PRIMITIVE_NAMES.put("long_long_min", "LONG_LONG_MIN");
        PRIMITIVE_NAMES.put("long_long_max", "LONG_LONG_MAX");
        PRIMITIVE_NAMES.put("long_long_mod", "LONG_LONG_MOD");
        PRIMITIVE_NAMES.put("ulong_long_max", "ULONG_LONG_MAX");
        PRIMITIVE_NAMES.put("ulong_long_mod", "ULONG_LONG_MOD");
        PRIMITIVE_NAMES.put("float_size", "FLOAT_SIZE");
        PRIMITIVE_NAMES.put("float_align", "FLOAT_ALIGN");
        PRIMITIVE_NAMES.put("float_nat_align", "FLOAT_NAT_ALIGN");
        PRIMITIVE_NAMES.put("double_size", "DOUBLE_SIZE");
        PRIMITIVE_NAMES.put("double_align", "DOUBLE_ALIGN");
        PRIMITIVE_NAMES.put("double_nat_align", "DOUBLE_NAT_ALIGN");
        PRIMITIVE_NAMES.put("long_double_size", "LONG_DOUBLE_SIZE");
        PRIMITIVE_NAMES.put("long_double_align", "LONG_DOUBLE_ALIGN");
        PRIMITIVE_NAMES.put("long_double_nat_align", "LONG_DOUBLE_NAT_ALIGN");
        PRIMITIVE_NAMES.put("function_align", "FUNCTION_ALIGN");
        PRIMITIVE_NAMES.put("function_size", "FUNCTION_SIZE");
        INTEGER_TYPES = new HashSet<String>();
        INTEGER_TYPES.add("VOID_SIZE");
        INTEGER_TYPES.add("POINTER_SIZE");
        INTEGER_TYPES.add("POINTER_ALIGN");
        INTEGER_TYPES.add("POINTER_NAT_ALIGN");
        INTEGER_TYPES.add("PTRDIFF_RANK");
        INTEGER_TYPES.add("SIZEOF_RANK");
        INTEGER_TYPES.add("PTRDIFF_SIZE");
        INTEGER_TYPES.add("SIZEOF_SIZE");
        INTEGER_TYPES.add("BOOL_SIZE");
        INTEGER_TYPES.add("BOOL_ALIGN");
        INTEGER_TYPES.add("BOOL_NAT_ALIGN");
        INTEGER_TYPES.add("CHAR_BITS");
        INTEGER_TYPES.add("WCHAR_RANK");
        INTEGER_TYPES.add("WCHAR_SIZE");
        INTEGER_TYPES.add("SHORT_SIZE");
        INTEGER_TYPES.add("SHORT_ALIGN");
        INTEGER_TYPES.add("SHORT_NAT_ALIGN");
        INTEGER_TYPES.add("SHORT_BITS");
        INTEGER_TYPES.add("INT_SIZE");
        INTEGER_TYPES.add("INT_ALIGN");
        INTEGER_TYPES.add("INT_NAT_ALIGN");
        INTEGER_TYPES.add("INT_BITS");
        INTEGER_TYPES.add("LONG_SIZE");
        INTEGER_TYPES.add("LONG_ALIGN");
        INTEGER_TYPES.add("LONG_NAT_ALIGN");
        INTEGER_TYPES.add("LONG_BITS");
        INTEGER_TYPES.add("LONG_LONG_SIZE");
        INTEGER_TYPES.add("LONG_LONG_ALIGN");
        INTEGER_TYPES.add("LONG_LONG_NAT_ALIGN");
        INTEGER_TYPES.add("LONG_LONG_BITS");
        INTEGER_TYPES.add("FLOAT_SIZE");
        INTEGER_TYPES.add("FLOAT_ALIGN");
        INTEGER_TYPES.add("FLOAT_NAT_ALIGN");
        INTEGER_TYPES.add("DOUBLE_SIZE");
        INTEGER_TYPES.add("DOUBLE_ALIGN");
        INTEGER_TYPES.add("DOUBLE_NAT_ALIGN");
        INTEGER_TYPES.add("LONG_DOUBLE_SIZE");
        INTEGER_TYPES.add("LONG_DOUBLE_ALIGN");
        INTEGER_TYPES.add("LONG_DOUBLE_NAT_ALIGN");
        INTEGER_TYPES.add("FUNCTION_SIZE");
        INTEGER_TYPES.add("FUNCTION_ALIGN");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Trace2<T>
    implements Function.F2<T, String, T> {
        @Override
        public T apply(String string, T t) {
            Primitives.trace(string, t);
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Trace<T>
    implements Function.F1<T, T> {
        @Override
        public T apply(T t) {
            Primitives.trace("", t);
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Subtraction<T>
    implements Function.F2<Pair<T>, Pair<T>, Pair<T>> {
        @Override
        public Pair<T> apply(Pair<T> pair, Pair<T> pair2) {
            return null == pair || null == pair2 ? null : pair.subtract(pair2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Intersection<T>
    implements Function.F2<Pair<T>, Pair<T>, Pair<T>> {
        @Override
        public Pair<T> apply(Pair<T> pair, Pair<T> pair2) {
            return null == pair || null == pair2 ? null : pair.intersect(pair2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Union<T>
    implements Function.F2<Pair<T>, Pair<T>, Pair<T>> {
        @Override
        public Pair<T> apply(Pair<T> pair, Pair<T> pair2) {
            return null == pair || null == pair2 ? null : pair.combine(pair2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Append<T>
    implements Function.F2<Pair<T>, Pair<T>, Pair<T>> {
        @Override
        public Pair<T> apply(Pair<T> pair, Pair<T> pair2) {
            return null == pair || null == pair2 ? null : pair.append(pair2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FoldLeft<T, U>
    implements Function.F3<T, Function.F2<T, ? super U, T>, Pair<U>, T> {
        @Override
        public T apply(Function.F2<T, ? super U, T> f2, Pair<U> pair, T t) {
            return null == f2 || null == pair || null == t ? null : (T)Function.foldl(f2, t, pair);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Map<T, U>
    implements Function.F2<Pair<T>, Function.F1<T, ? super U>, Pair<U>> {
        @Override
        public Pair<T> apply(Function.F1<T, ? super U> f1, Pair<U> pair) {
            return null == f1 || null == pair ? null : Function.map(f1, pair);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Iter<T, U>
    implements Function.F2<T, Function.F1<T, ? super U>, Pair<U>> {
        @Override
        public T apply(Function.F1<T, ? super U> f1, Pair<U> pair) {
            if (null == f1 || null == pair) {
                return null;
            }
            Function.iterate(f1, pair);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Exists<T>
    implements Function.F2<Boolean, Function.F1<Boolean, ? super T>, Pair<T>> {
        @Override
        public Boolean apply(Function.F1<Boolean, ? super T> f1, Pair<T> pair) {
            return null == f1 || null == pair ? null : Boolean.valueOf(Function.matchesOne(f1, pair));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Nth<T>
    implements Function.F2<T, Pair<T>, BigInteger> {
        @Override
        public T apply(Pair<T> pair, BigInteger bigInteger) {
            return null == pair || null == bigInteger ? null : (T)pair.get(Primitives.toInt(bigInteger));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Tail<T>
    implements Function.F1<Pair<T>, Pair<T>> {
        @Override
        public Pair<T> apply(Pair<T> pair) {
            return null == pair || pair.isEmpty() ? null : pair.tail();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Head<T>
    implements Function.F1<T, Pair<T>> {
        @Override
        public T apply(Pair<T> pair) {
            return null == pair || pair.isEmpty() ? null : (T)pair.head();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Cons<T>
    implements Function.F2<Pair<T>, T, Pair<T>> {
        @Override
        public Pair<T> apply(T t, Pair<T> pair) {
            return null == pair ? null : new Pair<T>(t, pair);
        }
    }
}

