/*
 * Decompiled with CFR 0.152.
 */
package xtc.typical;

import java.util.HashSet;
import java.util.Set;
import xtc.tree.GNode;
import xtc.tree.Node;
import xtc.tree.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreeVariableCollector
extends Visitor {
    protected final Set<String> idlist;

    public FreeVariableCollector(GNode gNode) {
        this.idlist = new HashSet<String>();
        this.dispatch(gNode);
    }

    public FreeVariableCollector(GNode gNode, Set<String> set) {
        this.idlist = set;
        this.dispatch(gNode);
    }

    public Set<String> getIdentifiers() {
        return this.idlist;
    }

    public void visitGuardExpression(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
    }

    public void visitTupleLiteral(GNode gNode) {
        for (int i = 0; i < gNode.size(); ++i) {
            this.dispatch(gNode.getGeneric(i));
        }
    }

    public void visitLogicalOrExpression(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
        this.dispatch(gNode.getGeneric(2));
    }

    public void visitLogicalAndExpression(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
        this.dispatch(gNode.getGeneric(2));
    }

    public void visitEqualityExpression(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
        this.dispatch(gNode.getGeneric(2));
    }

    public void visitRelationalExpression(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
        this.dispatch(gNode.getGeneric(2));
    }

    public void visitAdditiveExpression(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
        this.dispatch(gNode.getGeneric(2));
    }

    public void visitConcatenationExpression(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
        this.dispatch(gNode.getGeneric(2));
    }

    public void visitMultiplicativeExpresion(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
        this.dispatch(gNode.getGeneric(2));
    }

    public void visitConsExpression(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
        this.dispatch(gNode.getGeneric(1));
    }

    public void visitFunctionApplication(GNode gNode) {
        int n = gNode.size();
        if (3 == n) {
            this.dispatch(gNode.getGeneric(2));
        } else {
            this.dispatch(gNode.getGeneric(0));
            this.dispatch(gNode.getGeneric(1));
        }
    }

    public void visitArguments(GNode gNode) {
        for (int i = 0; i < gNode.size(); ++i) {
            this.dispatch(gNode.getGeneric(i));
        }
    }

    public void visitPredicateExpression(GNode gNode) {
        this.dispatch(gNode.getGeneric(1));
    }

    public void visitFieldExpression(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
    }

    public void visitLogicalNegationExpression(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
    }

    public void visitLetExpression(GNode gNode) {
        Set<String> set = new FreeVariableCollector(gNode.getGeneric(1)).getIdentifiers();
        Set<String> set2 = new FreeVariableCollector(gNode.getGeneric(0), set).getIdentifiers();
        this.idlist.addAll(set2);
    }

    public void visitLetBindings(GNode gNode) {
        for (int i = 0; i < gNode.size(); ++i) {
            this.dispatch(gNode.getGeneric(i));
        }
    }

    public void visitLetBinding(GNode gNode) {
        GNode gNode2 = gNode.getGeneric(0);
        if ("Variable".equals(((Node)gNode2).getName())) {
            this.idlist.remove(gNode2.getString(0));
        }
    }

    public void visitFunctionExpression(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
    }

    public void visitMatchExpression(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
        GNode gNode2 = gNode.getGeneric(1);
        for (int i = 0; i < gNode2.size(); ++i) {
            GNode gNode3 = gNode2.getGeneric(i);
            Set<String> set = new FreeVariableCollector(gNode3.getGeneric(1)).getIdentifiers();
            Set<String> set2 = new FreeVariableCollector(gNode3.getGeneric(0), set).getIdentifiers();
            this.idlist.addAll(set2);
        }
    }

    public void visitPatterns(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
    }

    public void visitTuplePattern(GNode gNode) {
        for (int i = 0; i < gNode.size(); ++i) {
            this.dispatch(gNode.getGeneric(i));
        }
    }

    public void visitWhenPattern(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
    }

    public void visitAsPattern(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
        String string = gNode.getString(1);
        this.idlist.remove(string);
    }

    public void visitTypedPattern(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
    }

    public void visitConsPattern(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
        this.dispatch(gNode.getGeneric(1));
    }

    public void visitVariable(GNode gNode) {
        this.idlist.remove(gNode.getString(0));
    }

    public void visitTypeConstructorPattern(GNode gNode) {
        for (int i = 1; i < gNode.size(); ++i) {
            this.dispatch(gNode.getGeneric(i));
        }
    }

    public void visitPatternParameters(GNode gNode) {
        for (int i = 0; i < gNode.size(); ++i) {
            this.dispatch(gNode.getGeneric(i));
        }
    }

    public void visitListPattern(GNode gNode) {
        for (int i = 0; i < gNode.size(); ++i) {
            this.dispatch(gNode.getGeneric(i));
        }
    }

    public void visitRecordPattern(GNode gNode) {
        for (int i = 0; i < gNode.size(); ++i) {
            this.dispatch(gNode.getGeneric(i));
        }
    }

    public void visitFieldPattern(GNode gNode) {
        this.dispatch(gNode.getGeneric(1));
    }

    public void visitTupleConstructor(GNode gNode) {
        for (int i = 1; i < gNode.size(); ++i) {
            this.dispatch(gNode.getGeneric(i));
        }
    }

    public void visitRecordExpression(GNode gNode) {
        for (int i = 0; i < gNode.size(); ++i) {
            this.dispatch(gNode.getGeneric(i));
        }
    }

    public void visitWithExpression(GNode gNode) {
        this.dispatch(gNode.getGeneric(0));
    }

    public void visitFieldAssignment(GNode gNode) {
        this.dispatch(gNode.getGeneric(1));
    }

    public void visitListLiteral(GNode gNode) {
        for (int i = 0; i < gNode.size(); ++i) {
            this.dispatch(gNode.getGeneric(i));
        }
    }

    public void visitLowerID(GNode gNode) {
        this.idlist.add(gNode.getString(0));
    }

    public void visit(GNode gNode) {
    }
}

