/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import xtc.type.Type;
import xtc.type.WrappedT;

public class VariableT
extends WrappedT {
    private Kind kind;
    private String name;
    private int width;

    public VariableT(Type type2, Type type3, Kind kind, String string) {
        super(type2, type3);
        if (Kind.BITFIELD == kind) {
            throw new IllegalArgumentException("Invalid kind " + (Object)((Object)kind));
        }
        this.kind = kind;
        this.name = string;
        this.width = -1;
    }

    public VariableT(Type type2, Type type3, String string, int n) {
        super(type2, type3);
        if (0 > n) {
            throw new IllegalArgumentException("Negative width " + n);
        }
        this.kind = Kind.BITFIELD;
        this.name = string;
        this.width = n;
    }

    public VariableT copy() {
        return -1 == this.width ? new VariableT((Type)this, this.getType().copy(), this.kind, this.name) : new VariableT((Type)this, this.getType().copy(), this.name, this.width);
    }

    public Type.Tag wtag() {
        return Type.Tag.VARIABLE;
    }

    public boolean isVariable() {
        return true;
    }

    public boolean hasVariable() {
        return true;
    }

    public VariableT toVariable() {
        return this;
    }

    public boolean hasKind(Kind kind) {
        return kind == this.kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public boolean hasName() {
        return null != this.name;
    }

    public boolean hasName(String string) {
        return string.equals(this.name);
    }

    public String getName() {
        return this.name;
    }

    public boolean hasWidth() {
        return -1 != this.width;
    }

    public int getWidth() {
        return this.width;
    }

    public void write(Appendable appendable) throws IOException {
        switch (this.kind) {
            case GLOBAL: {
                appendable.append("global");
                break;
            }
            case LOCAL: {
                appendable.append("local");
                break;
            }
            case PARAMETER: {
                appendable.append("param");
                break;
            }
            case FIELD: {
                appendable.append("field");
                break;
            }
            case BITFIELD: {
                appendable.append("bitfield");
            }
        }
        appendable.append('(');
        this.getType().write(appendable);
        appendable.append(", ");
        if (null != this.name) {
            appendable.append(this.name);
        } else {
            appendable.append("<none>");
        }
        if (-1 != this.width) {
            appendable.append(", ");
            appendable.append(Integer.toString(this.width));
        }
        appendable.append(')');
    }

    public static VariableT newGlobal(Type type2, String string) {
        return new VariableT(null, type2, Kind.GLOBAL, string);
    }

    public static VariableT newLocal(Type type2, String string) {
        return new VariableT(null, type2, Kind.LOCAL, string);
    }

    public static VariableT newParam(Type type2, String string) {
        return new VariableT(null, type2, Kind.PARAMETER, string);
    }

    public static VariableT newField(Type type2, String string) {
        return new VariableT(null, type2, Kind.FIELD, string);
    }

    public static VariableT newBitfield(Type type2, String string, int n) {
        return new VariableT(null, type2, string, n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        GLOBAL,
        LOCAL,
        PARAMETER,
        FIELD,
        BITFIELD;

    }
}

