/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import xtc.tree.Attribute;
import xtc.tree.Locatable;
import xtc.tree.Location;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.type.AliasT;
import xtc.type.AnnotatedT;
import xtc.type.ArrayT;
import xtc.type.BooleanT;
import xtc.type.ClassT;
import xtc.type.Constant;
import xtc.type.DynamicReference;
import xtc.type.EnumT;
import xtc.type.EnumeratorT;
import xtc.type.FloatT;
import xtc.type.FunctionT;
import xtc.type.InstantiatedT;
import xtc.type.IntegerT;
import xtc.type.InterfaceT;
import xtc.type.InternalT;
import xtc.type.LabelT;
import xtc.type.Language;
import xtc.type.MethodT;
import xtc.type.NumberT;
import xtc.type.PackageT;
import xtc.type.Parameter;
import xtc.type.ParameterizedT;
import xtc.type.PointerT;
import xtc.type.Reference;
import xtc.type.StaticReference;
import xtc.type.StructOrUnionT;
import xtc.type.StructT;
import xtc.type.Tagged;
import xtc.type.TupleT;
import xtc.type.TypePrinter;
import xtc.type.UnionT;
import xtc.type.UnitT;
import xtc.type.VariableT;
import xtc.type.VariantT;
import xtc.type.VoidT;
import xtc.type.Wildcard;
import xtc.type.WrappedT;
import xtc.util.Runtime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Type
extends Node {
    boolean sealed;
    Language language;
    String scope;
    Constant constant;
    Reference shape;
    List<Attribute> attributes;

    public Type() {
    }

    public Type(Type type2) {
        if (null == type2) {
            return;
        }
        this.setLocation(type2);
        this.language = type2.language;
        this.scope = type2.scope;
        this.constant = type2.constant;
        this.shape = type2.shape;
        if (null != type2.attributes) {
            this.attributes = new ArrayList<Attribute>(type2.attributes);
        }
    }

    public abstract Type copy();

    public boolean isSealed() {
        return this.sealed;
    }

    public Type seal() {
        this.sealed = true;
        return this;
    }

    protected void checkNotSealed() {
        if (this.sealed) {
            throw new IllegalStateException("Type " + this + " is sealed");
        }
    }

    public Type annotate() {
        return this.isAnnotated() && !this.isSealed() ? this : new AnnotatedT(this);
    }

    public Type deannotate() {
        Type type2 = this;
        while (type2.isAnnotated()) {
            type2 = type2.toAnnotated().getType();
        }
        return type2;
    }

    @Override
    public Object setProperty(String string, Object object) {
        this.checkNotSealed();
        return super.setProperty(string, object);
    }

    @Override
    public Object removeProperty(String string) {
        this.checkNotSealed();
        return super.removeProperty(string);
    }

    @Override
    public Set<String> properties() {
        if (this.sealed) {
            return Collections.unmodifiableSet(super.properties());
        }
        return this.properties();
    }

    @Override
    public boolean hasLocation() {
        return this.hasLocation(true);
    }

    public boolean hasLocation(boolean bl) {
        return super.hasLocation();
    }

    @Override
    public Location getLocation() {
        return this.getLocation(true);
    }

    public Location getLocation(boolean bl) {
        return super.getLocation();
    }

    public Type locate(Location location) {
        this.setLocation(location);
        return this;
    }

    public Type locate(Locatable locatable) {
        this.setLocation(locatable);
        return this;
    }

    @Override
    public void setLocation(Location location) {
        this.checkNotSealed();
        super.setLocation(location);
    }

    @Override
    public void setLocation(Locatable locatable) {
        this.checkNotSealed();
        super.setLocation(locatable);
    }

    public boolean hasLanguage() {
        return this.hasLanguage(true);
    }

    public boolean hasLanguage(boolean bl) {
        return null != this.language;
    }

    public Language getLanguage() {
        return this.getLanguage(true);
    }

    public Language getLanguage(boolean bl) {
        return this.language;
    }

    public Type language(Language language) {
        this.checkNotSealed();
        this.language = language;
        return this;
    }

    public boolean hasScope() {
        return this.hasScope(true);
    }

    public boolean hasScope(boolean bl) {
        return null != this.scope;
    }

    public String getScope() {
        return this.getScope(true);
    }

    public String getScope(boolean bl) {
        return this.scope;
    }

    public Type scope(String string) {
        this.checkNotSealed();
        this.scope = string;
        return this;
    }

    public boolean hasConstant() {
        return this.hasConstant(true);
    }

    public boolean hasConstant(boolean bl) {
        return null != this.constant;
    }

    public Constant getConstant() {
        return this.getConstant(true);
    }

    public Constant getConstant(boolean bl) {
        return this.constant;
    }

    public Type constant(boolean bl) {
        return this.constant(bl ? BigInteger.ONE : BigInteger.ZERO);
    }

    public Type constant(Object object) {
        this.checkNotSealed();
        this.constant = new Constant(object);
        return this;
    }

    public boolean hasShape() {
        return this.hasShape(true);
    }

    public boolean hasShape(boolean bl) {
        return null != this.shape;
    }

    public Reference getShape() {
        return this.getShape(true);
    }

    public Reference getShape(boolean bl) {
        return this.shape;
    }

    public Type shape(boolean bl, String string) {
        if (bl) {
            return this.shape(new StaticReference(string, this.resolve()));
        }
        return this.shape(new DynamicReference(string, this.resolve()));
    }

    public Type shape(Reference reference) {
        this.checkNotSealed();
        this.shape = reference;
        return this;
    }

    public boolean hasAttributes() {
        return null != this.attributes && !this.attributes.isEmpty();
    }

    public List<Attribute> attributes() {
        if (null == this.attributes) {
            return Collections.emptyList();
        }
        if (this.sealed) {
            return Collections.unmodifiableList(this.attributes);
        }
        return this.attributes;
    }

    public boolean hasAttribute(Attribute attribute) {
        return this.hasAttribute(attribute, true);
    }

    public boolean hasAttribute(Attribute attribute, boolean bl) {
        return null != this.attributes && this.attributes.contains(attribute);
    }

    public boolean hasAttribute(String string) {
        return null != this.getAttribute(string);
    }

    public boolean hasAttribute(String string, boolean bl) {
        return null != this.getAttribute(string, bl);
    }

    public Attribute getAttribute(String string) {
        return this.getAttribute(string, true);
    }

    public Attribute getAttribute(String string, boolean bl) {
        return Attribute.get(string, this.attributes);
    }

    public void addAttribute(Attribute attribute) {
        this.checkNotSealed();
        if (null == this.attributes) {
            this.attributes = new ArrayList<Attribute>();
        }
        this.attributes.add(attribute);
    }

    public boolean removeAttribute(Attribute attribute) {
        this.checkNotSealed();
        return null != this.attributes ? this.attributes.remove(attribute) : false;
    }

    public Type attribute(Attribute attribute) {
        if (!this.hasAttribute(attribute)) {
            this.addAttribute(attribute);
        }
        return this;
    }

    public Type attribute(List<Attribute> list) {
        for (Attribute attribute : list) {
            if (this.hasAttribute(attribute)) continue;
            this.addAttribute(attribute);
        }
        return this;
    }

    public Type attribute(Type type2) {
        do {
            if (!type2.hasAttributes()) continue;
            for (Attribute attribute : type2.attributes()) {
                if (this.hasAttribute(attribute)) continue;
                this.addAttribute(attribute);
            }
        } while (null != (type2 = type2.isWrapped() ? type2.toWrapped().getType() : null));
        return this;
    }

    public void mark(Node node) {
        if (node.hasProperty("xtc.Constants.Type")) {
            throw new IllegalArgumentException("Node " + node + " already has type");
        }
        node.setProperty("xtc.Constants.Type", this);
    }

    public boolean hasTag(Tag tag) {
        return tag == this.tag();
    }

    public abstract Tag tag();

    public boolean hasWTag(Tag tag) {
        return tag == this.wtag();
    }

    public Tag wtag() {
        return this.tag();
    }

    public boolean isError() {
        return false;
    }

    public boolean hasError() {
        return Tag.ERROR == this.tag();
    }

    public boolean isParameter() {
        return false;
    }

    public Parameter toParameter() {
        throw new ClassCastException("Not a parameter " + this);
    }

    public boolean isWildcard() {
        return false;
    }

    public Wildcard toWildcard() {
        throw new ClassCastException("Not a wildcard " + this);
    }

    public boolean isVoid() {
        return false;
    }

    public VoidT toVoid() {
        throw new ClassCastException("Not a void " + this);
    }

    public boolean isUnit() {
        return false;
    }

    public UnitT toUnit() {
        throw new ClassCastException("Not a unit " + this);
    }

    public boolean isBoolean() {
        return false;
    }

    public BooleanT toBoolean() {
        throw new ClassCastException("Not a boolean " + this);
    }

    public boolean isNumber() {
        return false;
    }

    public NumberT toNumber() {
        throw new ClassCastException("Not a number " + this);
    }

    public boolean isInteger() {
        return false;
    }

    public IntegerT toInteger() {
        throw new ClassCastException("Not an integer " + this);
    }

    public boolean isFloat() {
        return false;
    }

    public FloatT toFloat() {
        throw new ClassCastException("Not a float " + this);
    }

    public boolean isInternal() {
        return false;
    }

    public InternalT toInternal() {
        throw new ClassCastException("Not an internal type " + this);
    }

    public boolean isLabel() {
        return false;
    }

    public LabelT toLabel() {
        throw new ClassCastException("Not a label " + this);
    }

    public boolean isPackage() {
        return false;
    }

    public PackageT toPackage() {
        throw new ClassCastException("Not a package " + this);
    }

    public boolean isDerived() {
        return false;
    }

    public boolean isPointer() {
        return false;
    }

    public PointerT toPointer() {
        throw new ClassCastException("Not a pointer " + this);
    }

    public boolean isArray() {
        return false;
    }

    public ArrayT toArray() {
        throw new ClassCastException("Not an array " + this);
    }

    public boolean hasStructOrUnion() {
        switch (this.tag()) {
            case STRUCT: 
            case UNION: {
                return true;
            }
        }
        return false;
    }

    public StructOrUnionT toStructOrUnion() {
        throw new ClassCastException("Not a struct or union " + this);
    }

    public boolean isStruct() {
        return false;
    }

    public StructT toStruct() {
        throw new ClassCastException("Not a struct " + this);
    }

    public boolean isUnion() {
        return false;
    }

    public UnionT toUnion() {
        throw new ClassCastException("Not a union " + this);
    }

    public boolean isFunction() {
        return false;
    }

    public FunctionT toFunction() {
        throw new ClassCastException("Not a function " + this);
    }

    public boolean isMethod() {
        return false;
    }

    public MethodT toMethod() {
        throw new ClassCastException("Not a method " + this);
    }

    public boolean isClass() {
        return false;
    }

    public ClassT toClass() {
        throw new ClassCastException("Not a class " + this);
    }

    public boolean isInterface() {
        return false;
    }

    public InterfaceT toInterface() {
        throw new ClassCastException("Not an interface " + this);
    }

    public boolean isTuple() {
        return false;
    }

    public TupleT toTuple() {
        throw new ClassCastException("Not an tuple " + this);
    }

    public boolean isVariant() {
        return false;
    }

    public VariantT toVariant() {
        throw new ClassCastException("Not an variant " + this);
    }

    public boolean isWrapped() {
        return false;
    }

    public WrappedT toWrapped() {
        throw new ClassCastException("Not a wrapped type " + this);
    }

    public boolean isAnnotated() {
        return false;
    }

    public boolean hasAnnotated() {
        return false;
    }

    public AnnotatedT toAnnotated() {
        throw new ClassCastException("Not an annotated type " + this);
    }

    public boolean isAlias() {
        return false;
    }

    public boolean hasAlias() {
        return false;
    }

    public AliasT toAlias() {
        throw new ClassCastException("Not an alias " + this);
    }

    public boolean isEnum() {
        return false;
    }

    public boolean hasEnum() {
        return false;
    }

    public EnumT toEnum() {
        throw new ClassCastException("Not an enum " + this);
    }

    public boolean isEnumerator() {
        return false;
    }

    public boolean hasEnumerator() {
        return false;
    }

    public EnumeratorT toEnumerator() {
        throw new ClassCastException("Not an enumerator " + this);
    }

    public boolean isInstantiated() {
        return false;
    }

    public boolean hasInstantiated() {
        return false;
    }

    public InstantiatedT toInstantiated() {
        throw new ClassCastException("Not an instantiated type " + this);
    }

    public boolean isParameterized() {
        return false;
    }

    public boolean hasParameterized() {
        return false;
    }

    public ParameterizedT toParameterized() {
        throw new ClassCastException("Not a parameterized type " + this);
    }

    public boolean isVariable() {
        return false;
    }

    @Override
    public boolean hasVariable() {
        return false;
    }

    public VariableT toVariable() {
        throw new ClassCastException("Not a variable " + this);
    }

    public boolean hasTagged() {
        return false;
    }

    public Tagged toTagged() {
        throw new ClassCastException("Not a tagged type " + this);
    }

    public boolean isConcrete() {
        return !this.hasParameterized() || this.hasInstantiated();
    }

    public Type resolve() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trace(Runtime runtime) {
        Visitor visitor = runtime.console().visitor();
        TypePrinter typePrinter = new TypePrinter(runtime.console());
        try {
            typePrinter.dispatch(this);
            runtime.console().pln();
        }
        finally {
            runtime.console().register(visitor);
        }
        runtime.console().flush();
    }

    public static Type cast(Object object) {
        return (Type)object;
    }

    public static Type resolve(Object object) {
        return ((Type)object).resolve();
    }

    public static <T extends Type> List<T> copy(List<T> list) {
        if (null == list) {
            return null;
        }
        ArrayList<Type> arrayList = new ArrayList<Type>(list.size());
        for (Type type2 : list) {
            arrayList.add(type2.copy());
        }
        return arrayList;
    }

    public static <T extends Type> List<T> seal(List<T> list) {
        if (null == list) {
            return null;
        }
        for (Type type2 : list) {
            type2.seal();
        }
        return Collections.unmodifiableList(list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tag {
        BOOLEAN,
        ARRAY,
        CLASS,
        INTERFACE,
        FUNCTION,
        METHOD,
        PARAMETER,
        WILDCARD,
        POINTER,
        STRUCT,
        TUPLE,
        UNION,
        VARIANT,
        ERROR,
        INTERNAL,
        LABEL,
        FLOAT,
        INTEGER,
        PACKAGE,
        UNIT,
        VOID,
        ALIAS,
        ANNOTATED,
        ENUMERATOR,
        ENUM,
        INSTANTIATED,
        PARAMETERIZED,
        VARIABLE;

    }
}

