/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.util.List;
import xtc.type.DerivedT;
import xtc.type.ErrorT;
import xtc.type.Tagged;
import xtc.type.Type;
import xtc.type.VariableT;
import xtc.util.Nonce;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StructOrUnionT
extends DerivedT
implements Tagged {
    protected final Nonce nonce;
    protected final String name;
    protected List<VariableT> members;

    public StructOrUnionT(Type type2, Nonce nonce, String string, List<VariableT> list) {
        super(type2);
        if (null == string) {
            throw new NullPointerException("Null name");
        }
        this.nonce = nonce;
        this.name = string;
        this.members = list;
    }

    @Override
    public Type seal() {
        if (null != this.members && !this.isSealed()) {
            super.seal();
            this.members = Type.seal(this.members);
        }
        return this;
    }

    @Override
    public StructOrUnionT toStructOrUnion() {
        return this;
    }

    @Override
    public boolean hasTagged() {
        return true;
    }

    @Override
    public Tagged toTagged() {
        return this;
    }

    @Override
    public Nonce getNonce() {
        return this.nonce;
    }

    @Override
    public boolean isUnnamed() {
        return this.name.startsWith("tag(");
    }

    @Override
    public boolean hasName(String string) {
        return string.equals(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type lookup(String string) {
        for (VariableT variableT : this.members) {
            Type type2;
            if (variableT.hasName(string)) {
                return variableT;
            }
            if (variableT.hasName() || variableT.hasWidth() || (type2 = ((StructOrUnionT)variableT.resolve()).lookup(string)).isError()) continue;
            return type2;
        }
        return ErrorT.TYPE;
    }

    @Override
    public int getMemberCount() {
        if (null == this.members) {
            return -1;
        }
        int n = 0;
        for (VariableT variableT : this.members) {
            if (!variableT.hasName() && variableT.hasWidth()) continue;
            ++n;
        }
        return n;
    }

    @Override
    public VariableT getMember(int n) {
        int n2 = -1;
        for (VariableT variableT : this.members) {
            if (!variableT.hasName() && variableT.hasWidth() || n != ++n2) continue;
            return variableT;
        }
        throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + (n2 + 1));
    }

    public List<VariableT> getMembers() {
        return this.members;
    }

    public void setMembers(List<VariableT> list) {
        this.checkNotSealed();
        this.members = list;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Type)) {
            return false;
        }
        Type type2 = (Type)object;
        return type2.hasTagged() && this.nonce == type2.toTagged().getNonce();
    }
}

