/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import xtc.type.Reference;
import xtc.type.Type;
import xtc.util.Utilities;

public class StringReference
extends Reference {
    private final String literal;

    public StringReference(String string, Type type2) {
        super(type2);
        this.literal = string;
    }

    public boolean isString() {
        return true;
    }

    public String getLiteral() {
        return this.literal;
    }

    public boolean isConstant() {
        return true;
    }

    public int hashCode() {
        return this.literal.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StringReference)) {
            return false;
        }
        StringReference stringReference = (StringReference)object;
        return this.type.equals(stringReference.type) && this.literal.equals(stringReference.literal);
    }

    public void write(Appendable appendable) throws IOException {
        if (this.type.hasTag(Type.Tag.INTEGER)) {
            switch (this.type.resolve().toInteger().getKind()) {
                default: {
                    appendable.append('L');
                }
                case CHAR: 
                case S_CHAR: 
                case U_CHAR: 
            }
        }
        appendable.append('\"');
        Utilities.escape(this.literal, appendable, 9);
        appendable.append('\"');
    }
}

