/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.math.BigInteger;
import xtc.type.C;
import xtc.type.IndexReference;
import xtc.type.IndirectReference;
import xtc.type.Type;

public abstract class Reference {
    protected final Type type;

    public Reference(Type type2) {
        type2 = type2.resolve();
        while (type2.isArray()) {
            type2 = type2.toArray().getType().resolve();
        }
        this.type = type2;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isNull() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isVariable() {
        return false;
    }

    public boolean isStatic() {
        return false;
    }

    public boolean isDynamic() {
        return false;
    }

    public boolean isPrefix() {
        return false;
    }

    public boolean isCast() {
        return false;
    }

    public boolean isIndirect() {
        return false;
    }

    public boolean hasBase() {
        return false;
    }

    public Reference getBase() {
        throw new IllegalStateException("not a relative reference");
    }

    public boolean hasIndex() {
        return false;
    }

    public BigInteger getIndex() {
        throw new IllegalStateException("not an index reference");
    }

    public boolean hasField() {
        return false;
    }

    public String getField() {
        throw new IllegalStateException("not a field reference");
    }

    public boolean hasLocation() {
        return false;
    }

    public BigInteger getLocation(C c) {
        throw new IllegalStateException();
    }

    public boolean isConstant() {
        return false;
    }

    public Reference indirect(Type type2) {
        Type type3 = type2.resolve();
        if (type3.isArray() || type3.isFunction()) {
            return this;
        }
        return new IndirectReference(this);
    }

    public Reference add(long l) {
        if (0L == l) {
            return this;
        }
        return this.add(BigInteger.valueOf(l));
    }

    public Reference add(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return this;
        }
        return new IndexReference(this, bigInteger);
    }

    public Reference subtract(long l) {
        if (0L == l) {
            return this;
        }
        return this.subtract(BigInteger.valueOf(l));
    }

    public Reference subtract(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return this;
        }
        return new IndexReference(this, bigInteger.negate());
    }

    public BigInteger difference(Reference reference) {
        if (this.hasIndex() && reference.hasIndex()) {
            IndexReference indexReference = (IndexReference)this;
            IndexReference indexReference2 = (IndexReference)reference;
            if (indexReference.base.equals(indexReference2.base)) {
                return indexReference.index.subtract(indexReference2.index);
            }
        } else if (this.hasIndex()) {
            IndexReference indexReference = (IndexReference)this;
            if (indexReference.base.equals(reference)) {
                return indexReference.index;
            }
        } else if (reference.hasIndex()) {
            IndexReference indexReference = (IndexReference)reference;
            if (this.equals(indexReference.base)) {
                return indexReference.index.negate();
            }
        }
        return null;
    }

    public abstract void write(Appendable var1) throws IOException;

    public String toString() {
        StringBuilder stringBuilder;
        block2: {
            stringBuilder = new StringBuilder();
            try {
                this.write(stringBuilder);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return stringBuilder.toString();
    }
}

