/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.math.BigInteger;
import xtc.type.C;
import xtc.type.Reference;
import xtc.type.RelativeReference;
import xtc.type.Type;

public class IndexReference
extends RelativeReference {
    final BigInteger index;
    private static final BigInteger MIN = BigInteger.valueOf(-255L);
    private static final BigInteger MAX = BigInteger.valueOf(255L);

    public IndexReference(Reference reference, BigInteger bigInteger) {
        super(reference.type, reference);
        this.index = bigInteger;
    }

    IndexReference(Type type2, Reference reference, BigInteger bigInteger) {
        super(type2, reference);
        this.index = bigInteger;
    }

    public boolean isNull() {
        return 0 == this.index.signum() ? this.base.isNull() : false;
    }

    public boolean hasIndex() {
        return true;
    }

    public BigInteger getIndex() {
        return this.index;
    }

    public boolean hasLocation() {
        return this.base.hasLocation();
    }

    public BigInteger getLocation(C c) {
        if (!this.base.hasLocation()) {
            throw new IllegalStateException();
        }
        return this.base.getLocation(c).add(this.index.multiply(BigInteger.valueOf(c.getSize(this.type))));
    }

    public Reference add(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return this;
        }
        return new IndexReference(this.type, this.base, this.index.add(bigInteger));
    }

    public Reference subtract(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return this;
        }
        return new IndexReference(this.type, this.base, this.index.subtract(bigInteger));
    }

    public int hashCode() {
        return this.index.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IndexReference)) {
            return false;
        }
        IndexReference indexReference = (IndexReference)object;
        return this.index.equals(indexReference.index) && this.base.equals(indexReference.base) && this.type.equals(indexReference.type);
    }

    public void write(Appendable appendable) throws IOException {
        if (this.base.isPrefix()) {
            appendable.append('(');
        }
        this.base.write(appendable);
        if (this.base.isPrefix()) {
            appendable.append(')');
        }
        appendable.append('[');
        if (MIN.compareTo(this.index) <= 0 && this.index.compareTo(MAX) <= 0) {
            appendable.append(this.index.toString());
        } else if (-1 == this.index.signum()) {
            appendable.append("-0x");
            appendable.append(this.index.negate().toString(16));
        } else {
            appendable.append("0x");
            appendable.append(this.index.toString(16));
        }
        appendable.append(']');
    }
}

