/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import xtc.type.DerivedT;
import xtc.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FunctionOrMethodT
extends DerivedT {
    protected Type result;
    protected String name;
    protected List<Type> parameters;
    protected boolean varargs;
    protected List<Type> exceptions;

    public FunctionOrMethodT(Type type2, Type type3, String string, List<Type> list, boolean bl, List<Type> list2) {
        super(type2);
        this.result = type3;
        this.name = string;
        this.parameters = list;
        this.varargs = bl;
        this.exceptions = list2;
    }

    @Override
    public Type seal() {
        if (!this.isSealed()) {
            super.seal();
            this.result.seal();
            this.parameters = Type.seal(this.parameters);
            this.exceptions = Type.seal(this.exceptions);
        }
        return this;
    }

    public Type getResult() {
        return this.result;
    }

    public void setResult(Type type2) {
        this.checkNotSealed();
        this.result = type2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<Type> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Type> list) {
        this.checkNotSealed();
        this.parameters = list;
    }

    public boolean isVarArgs() {
        return this.varargs;
    }

    public List<Type> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<Type> list) {
        this.checkNotSealed();
        this.exceptions = list;
    }

    public int hashCode() {
        return ((Object)this.parameters).hashCode() * 37 + this.result.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Type)) {
            return false;
        }
        Type type2 = FunctionOrMethodT.resolve(object);
        if (this == type2) {
            return true;
        }
        if (!this.getClass().equals(type2.getClass())) {
            return false;
        }
        FunctionOrMethodT functionOrMethodT = (FunctionOrMethodT)type2;
        if (this.varargs != functionOrMethodT.varargs) {
            return false;
        }
        if (!this.result.equals(functionOrMethodT.result)) {
            return false;
        }
        if (null == this.exceptions ? null != functionOrMethodT.exceptions : !((Object)this.exceptions).equals(functionOrMethodT.exceptions)) {
            return false;
        }
        return ((Object)this.parameters).equals(functionOrMethodT.parameters);
    }

    @Override
    public void write(Appendable appendable) throws IOException {
        appendable.append('(');
        Iterator<Type> iterator = this.parameters.iterator();
        while (iterator.hasNext()) {
            iterator.next().write(appendable);
            if (!iterator.hasNext() && !this.varargs) continue;
            appendable.append(", ");
        }
        if (this.varargs) {
            appendable.append("...");
        }
        appendable.append(") -> ");
        if (this.result.resolve().isFunction()) {
            appendable.append('(');
            this.result.write(appendable);
            appendable.append(')');
        } else {
            this.result.write(appendable);
        }
    }
}

