/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import java.math.BigInteger;
import xtc.type.C;
import xtc.type.Reference;
import xtc.type.RelativeReference;

public class FieldReference
extends RelativeReference {
    private final String name;

    public FieldReference(Reference reference, String string) {
        super(reference.type.toStructOrUnion().lookup(string), reference);
        this.name = string;
        if (this.type.isError()) {
            throw new IllegalArgumentException("struct/union without member '" + string + "'");
        }
    }

    public boolean hasField() {
        return true;
    }

    public String getField() {
        return this.name;
    }

    public boolean hasLocation() {
        return this.base.hasLocation();
    }

    public BigInteger getLocation(C c) {
        if (!this.base.hasLocation()) {
            throw new IllegalStateException();
        }
        return this.base.getLocation(c).add(BigInteger.valueOf(c.getOffset(this.base.type.toStructOrUnion(), this.name)));
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof FieldReference)) {
            return false;
        }
        FieldReference fieldReference = (FieldReference)object;
        return this.name.equals(fieldReference.name) && this.base.equals(fieldReference.base);
    }

    public void write(Appendable appendable) throws IOException {
        if (this.base.isPrefix()) {
            appendable.append('(');
        }
        this.base.write(appendable);
        if (this.base.isPrefix()) {
            appendable.append(')');
        }
        appendable.append('.');
        appendable.append(this.name);
    }
}

