/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.io.IOException;
import xtc.type.DerivedT;
import xtc.type.Type;

public class ArrayT
extends DerivedT {
    private Type type;
    private boolean varlength;
    private long length;

    public ArrayT(Type type2) {
        this(type2, -1L);
    }

    public ArrayT(Type type2, boolean bl) {
        this.type = type2;
        this.varlength = bl;
        this.length = -1L;
    }

    public ArrayT(Type type2, long l) {
        this.type = type2;
        this.varlength = false;
        this.length = l;
    }

    public ArrayT(Type type2, Type type3, boolean bl, long l) {
        super(type2);
        this.type = type3;
        this.varlength = bl;
        this.length = l;
    }

    public Type seal() {
        if (!this.isSealed()) {
            super.seal();
            this.type.seal();
        }
        return this;
    }

    public ArrayT copy() {
        return new ArrayT(this, this.type, this.varlength, this.length);
    }

    public Type.Tag tag() {
        return Type.Tag.ARRAY;
    }

    public boolean isArray() {
        return true;
    }

    public ArrayT toArray() {
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isVarLength() {
        return this.varlength;
    }

    public void setVarLength(boolean bl) {
        this.checkNotSealed();
        this.varlength = bl;
    }

    public boolean hasLength() {
        return -1L != this.length;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long l) {
        this.checkNotSealed();
        this.length = l;
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Type)) {
            return false;
        }
        Type type2 = ArrayT.resolve(object);
        if (this == type2) {
            return true;
        }
        if (!type2.isArray()) {
            return false;
        }
        ArrayT arrayT = (ArrayT)type2;
        if (this.varlength != arrayT.varlength) {
            return false;
        }
        if (this.length != arrayT.length) {
            return false;
        }
        return this.type.equals(arrayT.type);
    }

    public void write(Appendable appendable) throws IOException {
        appendable.append("array(");
        this.type.write(appendable);
        if (this.varlength) {
            appendable.append(", *");
        } else if (-1L != this.length) {
            appendable.append(", ");
            appendable.append(Long.toString(this.length));
        }
        appendable.append(')');
    }
}

