/*
 * Decompiled with CFR 0.152.
 */
package xtc.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.Constants;
import xtc.tree.Printer;
import xtc.type.ErrorT;
import xtc.type.InstantiatedT;
import xtc.type.InternalT;
import xtc.type.Parameter;
import xtc.type.ParameterizedT;
import xtc.type.TupleT;
import xtc.type.Type;
import xtc.type.UnitT;
import xtc.type.VariantT;
import xtc.type.VoidT;
import xtc.type.Wildcard;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AST {
    public static final Set<String> INTERNAL;
    public static final Type VOID;
    public static final Type ANY;
    public static final Type CHAR;
    public static final Type STRING;
    public static final Type TOKEN;
    public static final Type NODE;
    public static final Type NULL_NODE;
    public static final Type GENERIC;
    public static final Type FORMATTING;
    public static final Type LIST;
    public static final Type WILD_LIST;
    public static final Type ACTION;
    public static final Type WILD_ACTION;
    protected final Map<String, Type> externToIntern = new HashMap<String, Type>();
    protected final Map<String, String> internToExtern = new HashMap<String, String>();
    protected final List<String> importedModules = new ArrayList<String>();
    protected final Map<String, String> importedTypes = new HashMap<String, String>();
    protected final Map<String, VariantT> variants = new HashMap<String, VariantT>();
    protected final Map<String, Set<String>> variantNodes = new HashMap<String, Set<String>>();
    protected final Map<String, String> originalNames = new HashMap<String, String>();
    protected final Map<String, TupleT> tuples = new HashMap<String, TupleT>();
    protected final Map<String, List<VariantT>> tupleVariants = new HashMap<String, List<VariantT>>();

    public abstract void initialize(boolean var1, boolean var2, boolean var3, boolean var4);

    public void importModule(String string) {
        if (!this.importedModules.contains(string)) {
            this.importedModules.add(string);
        }
    }

    public void importType(String string, String string2) {
        if (this.importedTypes.containsKey(string2)) {
            assert (string.equals(this.importedTypes.get(string2)));
        } else {
            this.importedTypes.put(string2, string);
        }
    }

    public abstract boolean isVoid(String var1);

    public abstract boolean isGenericNode(String var1);

    public Type intern(String string) {
        Type type2 = this.externToIntern.get(string);
        if (null != type2) {
            return type2;
        }
        type2 = this.internList(string);
        if (!type2.isError()) {
            return type2;
        }
        type2 = this.internAction(string);
        if (!type2.isError()) {
            return type2;
        }
        return this.internUser(string);
    }

    protected abstract Type internList(String var1);

    protected abstract Type internAction(String var1);

    protected abstract Type internUser(String var1);

    public String extern(Type type2) {
        switch (type2.tag()) {
            case VARIANT: 
            case TUPLE: {
                if (type2.hasAttribute(Constants.ATT_NODE)) {
                    return this.internToExtern.get("node");
                }
                return this.externUser(type2);
            }
            case INTERNAL: {
                String string = type2.resolve().toInternal().getName();
                if ("list".equals(string)) {
                    return this.externList(type2);
                }
                if ("action".equals(string)) {
                    return this.externAction(type2);
                }
                if (INTERNAL.contains(string)) {
                    return this.internToExtern.get(string);
                }
                return this.externUser(type2);
            }
            case UNIT: {
                return type2.hasAttribute(Constants.ATT_NODE) ? this.internToExtern.get("node") : this.internToExtern.get("unit");
            }
            case VOID: {
                return this.internToExtern.get("void");
            }
            case WILDCARD: {
                return this.internToExtern.get(type2.resolve().toWildcard().getName());
            }
            case ERROR: {
                throw new AssertionError((Object)"Error type");
            }
        }
        return this.externUser(type2);
    }

    protected abstract String externList(Type var1);

    protected abstract String externAction(Type var1);

    protected abstract String externUser(Type var1);

    public Constants.FuzzyBoolean hasLocation(Type type2) {
        switch (type2.tag()) {
            case VARIANT: 
            case TUPLE: {
                if (type2.hasAttribute(Constants.ATT_NODE)) {
                    return Constants.FuzzyBoolean.TRUE;
                }
                return this.hasLocationUser(type2);
            }
            case INTERNAL: {
                if (type2.hasAttribute(Constants.ATT_NODE)) {
                    return Constants.FuzzyBoolean.TRUE;
                }
                String string = type2.resolve().toInternal().getName();
                if ("any".equals(string)) {
                    return Constants.FuzzyBoolean.MAYBE;
                }
                if (INTERNAL.contains(string)) {
                    return Constants.FuzzyBoolean.FALSE;
                }
                return this.hasLocationUser(type2);
            }
            case UNIT: {
                return type2.hasAttribute(Constants.ATT_NODE) ? Constants.FuzzyBoolean.TRUE : Constants.FuzzyBoolean.FALSE;
            }
            case VOID: {
                return Constants.FuzzyBoolean.FALSE;
            }
            case WILDCARD: 
            case PARAMETER: {
                return Constants.FuzzyBoolean.MAYBE;
            }
            case ERROR: {
                throw new AssertionError((Object)"Error type");
            }
        }
        return this.hasLocationUser(type2);
    }

    protected abstract Constants.FuzzyBoolean hasLocationUser(Type var1);

    public static boolean isOptional(Type type2) {
        return type2.hasAttribute(Constants.ATT_OPTIONAL);
    }

    public static boolean isVariable(Type type2) {
        return type2.hasAttribute(Constants.ATT_VARIABLE);
    }

    public static boolean isVoid(Type type2) {
        return type2.resolve().isVoid();
    }

    public static boolean isAny(Type type2) {
        Type type3 = type2.resolve();
        return type3.isInternal() && "any".equals(type3.toInternal().getName());
    }

    public static boolean isChar(Type type2) {
        Type type3 = type2.resolve();
        return type3.isInternal() && "char".equals(type3.toInternal().getName());
    }

    public static boolean isString(Type type2) {
        Type type3 = type2.resolve();
        return type3.isInternal() && "string".equals(type3.toInternal().getName());
    }

    public static boolean isToken(Type type2) {
        Type type3 = type2.resolve();
        return type3.isInternal() && "token".equals(type3.toInternal().getName());
    }

    public static boolean isNode(Type type2) {
        return type2.hasAttribute(Constants.ATT_NODE);
    }

    public static boolean isDynamicNode(Type type2) {
        Type type3 = type2.resolve();
        return type3.isInternal() && "node".equals(type3.toInternal().getName());
    }

    public static boolean isNullNode(Type type2) {
        return type2.hasAttribute(Constants.ATT_NODE) && type2.resolve().isUnit();
    }

    public static boolean isStaticNode(Type type2) {
        return type2.hasAttribute(Constants.ATT_NODE) && type2.resolve().isVariant();
    }

    public static boolean isGenericNode(Type type2) {
        return type2.hasAttribute(Constants.ATT_GENERIC) && type2.hasAttribute(Constants.ATT_NODE);
    }

    public static boolean isFormatting(Type type2) {
        Type type3 = type2.resolve();
        return type3.isInternal() && "formatting".equals(type3.toInternal().getName());
    }

    public static boolean isList(Type type2) {
        Type type3 = type2.resolve();
        return type3.isInternal() && "list".equals(type3.toInternal().getName());
    }

    public static boolean isAction(Type type2) {
        Type type3 = type2.resolve();
        return type3.isInternal() && "action".equals(type3.toInternal().getName());
    }

    public static Type getArgument(Type type2) {
        assert (type2.hasInstantiated());
        assert (1 == type2.toInstantiated().getArguments().size());
        return type2.toInstantiated().getArguments().get(0);
    }

    public static boolean isUser(Type type2) {
        switch (type2.tag()) {
            case VARIANT: 
            case TUPLE: {
                return !type2.hasAttribute(Constants.ATT_NODE);
            }
            case INTERNAL: {
                return !INTERNAL.contains(type2.resolve().toInternal().getName());
            }
            case UNIT: 
            case VOID: 
            case WILDCARD: 
            case ERROR: 
            case PARAMETER: {
                return false;
            }
        }
        return true;
    }

    public static Type markOptional(Type type2) {
        return type2.annotate().attribute(Constants.ATT_OPTIONAL);
    }

    public static Type markVariable(Type type2) {
        return type2.annotate().attribute(Constants.ATT_VARIABLE);
    }

    public String toVariantName(String string) {
        if (Utilities.isQualified(string)) {
            String string2 = Utilities.getQualifier(string);
            String string3 = Utilities.getName(string);
            return Utilities.qualify(string2, Utilities.split(string3, '_'));
        }
        return Utilities.split(string, '_');
    }

    public boolean hasVariant(String string) {
        return this.variants.containsKey(this.toVariantName(string));
    }

    public VariantT toVariant(String string, boolean bl) {
        VariantT variantT;
        String string2 = this.toVariantName(string);
        if (this.variants.containsKey(string2)) {
            variantT = this.variants.get(string2);
            assert (bl == variantT.isPolymorphic());
        } else {
            variantT = new VariantT(string2, bl, new ArrayList<TupleT>());
            variantT.addAttribute(Constants.ATT_NODE);
            this.variants.put(string2, variantT);
            this.variantNodes.put(string2, new HashSet());
            this.originalNames.put(string2, string);
        }
        return variantT;
    }

    public String toOriginal(VariantT variantT) {
        String string = variantT.getName();
        assert (null != string);
        assert (this.variants.containsKey(string));
        assert (variantT == this.variants.get(string));
        return this.originalNames.get(string);
    }

    public boolean hasTuple(String string) {
        return this.tuples.containsKey(string);
    }

    public boolean isMonomorphic(String string) {
        return this.tuples.containsKey(string) && 0 < this.tupleVariants.get(string).size() && !this.tupleVariants.get(string).get(0).isPolymorphic();
    }

    public TupleT toTuple(String string) {
        TupleT tupleT;
        if (this.tuples.containsKey(string)) {
            tupleT = this.tuples.get(string);
        } else {
            tupleT = new TupleT(string);
            this.tuples.put(string, tupleT);
            this.tupleVariants.put(string, new ArrayList());
        }
        return tupleT;
    }

    public void add(TupleT tupleT, VariantT variantT) {
        Type type2;
        String string = tupleT.getName();
        String string2 = variantT.getName();
        assert (this.tuples.containsKey(string));
        assert (tupleT == this.tuples.get(string));
        assert (this.tupleVariants.containsKey(string));
        if (null == string2) {
            assert (variantT.isPolymorphic());
        } else {
            assert (this.variants.containsKey(string2));
            assert (variantT == this.variants.get(string2));
        }
        if ((type2 = variantT.lookup(string)).isError()) {
            assert (variantT.isPolymorphic() || null != string2 && !this.variantNodes.get(string2).contains(tupleT.getSimpleName()));
            if (!variantT.isPolymorphic()) {
                this.variantNodes.get(string2).add(tupleT.getSimpleName());
            }
            if (null != string2) {
                this.tupleVariants.get(string).add(variantT);
            }
            variantT.getTuples().add(tupleT);
        } else assert (type2 == tupleT);
    }

    public List<VariantT> toVariants(TupleT tupleT) {
        String string = tupleT.getName();
        assert (this.tuples.containsKey(string));
        assert (tupleT == this.tuples.get(string));
        List<VariantT> list = this.tupleVariants.get(string);
        assert (null != list);
        return list;
    }

    public TupleT toTuple(VariantT variantT) {
        TupleT tupleT;
        String string;
        String string2 = variantT.getName();
        assert (!variantT.isPolymorphic());
        assert (this.variants.containsKey(string2));
        assert (variantT == this.variants.get(string2));
        String string3 = variantT.getQualifier();
        if (this.isMonomorphic(Utilities.qualify(string3, string = "Some" + Utilities.unqualify(this.originalNames.get(string2))))) {
            string = "Just" + string;
            while (this.isMonomorphic(Utilities.qualify(string3, string))) {
                string = string + "1";
            }
        }
        if (null == (tupleT = this.toTuple(Utilities.qualify(string3, string))).getTypes()) {
            tupleT.setTypes(new ArrayList<Type>(1));
            tupleT.getTypes().add(variantT);
        }
        return tupleT;
    }

    public boolean overlap(VariantT variantT, VariantT variantT2) {
        if (variantT.isPolymorphic()) {
            for (TupleT tupleT : variantT.getTuples()) {
                if (!this.overlap(tupleT.getTypes().get(0).toVariant(), variantT2)) continue;
                return true;
            }
        } else if (variantT2.isPolymorphic()) {
            for (TupleT tupleT : variantT2.getTuples()) {
                if (!this.overlap(variantT, tupleT.getTypes().get(0).toVariant())) continue;
                return true;
            }
        } else {
            String string = variantT.getName();
            String string2 = variantT2.getName();
            assert (this.variants.containsKey(string));
            assert (variantT == this.variants.get(string));
            assert (this.variants.containsKey(string2));
            assert (variantT2 == this.variants.get(string2));
            Set<String> set = this.variantNodes.get(variantT.getName());
            Set<String> set2 = this.variantNodes.get(variantT2.getName());
            for (String string3 : set) {
                if (!set2.contains(string3)) continue;
                return true;
            }
        }
        return false;
    }

    public MetaData getMetaData(VariantT variantT) {
        MetaData metaData = new MetaData();
        this.fillIn(variantT, metaData, new HashSet<String>());
        return metaData;
    }

    private void fillIn(Type type2, MetaData metaData, Set<String> set) {
        switch (type2.tag()) {
            case VARIANT: {
                VariantT variantT = type2.resolve().toVariant();
                String string = variantT.getName();
                String string2 = variantT.getSimpleName();
                List<TupleT> list = variantT.getTuples();
                if (null == string) {
                    for (TupleT tupleT : list) {
                        this.fillIn(tupleT, metaData, set);
                    }
                } else {
                    if (metaData.reachable.contains(string)) break;
                    metaData.reachable.add(string);
                    if (set.contains(string2)) {
                        metaData.modularize = true;
                    } else {
                        set.add(string2);
                    }
                    for (TupleT tupleT : list) {
                        this.fillIn(tupleT, metaData, set);
                    }
                }
                break;
            }
            case TUPLE: {
                List<Type> list = type2.resolve().toTuple().getTypes();
                if (null == list) break;
                for (Type type3 : list) {
                    this.fillIn(type3, metaData, set);
                }
                break;
            }
            case INTERNAL: {
                String string = type2.resolve().toInternal().getName();
                if (!"list".equals(string) && !"action".equals(string) || !type2.hasInstantiated()) break;
                this.fillIn(AST.getArgument(type2), metaData, set);
                break;
            }
        }
    }

    public static Type listOf(Type type2) {
        return new InstantiatedT(type2, LIST);
    }

    public static Type actionOf(Type type2) {
        return new InstantiatedT(type2, ACTION);
    }

    public Type unify(Type type2, Type type3, boolean bl) {
        if (type2 == type3) {
            return type2;
        }
        if (type2.hasError() || type3.hasError()) {
            return ErrorT.TYPE;
        }
        if (type2.resolve().isParameter()) {
            return type3;
        }
        if (type3.resolve().isParameter()) {
            return type2;
        }
        Type type4 = this.unify1(type2, type3, bl);
        if (type4.isError() && !bl) {
            type4 = ANY;
        }
        if (!type4.isError()) {
            if (AST.isVariable(type2) || AST.isVariable(type3)) {
                type4 = AST.markVariable(type4);
            } else if (AST.isOptional(type2) || AST.isOptional(type3)) {
                type4 = AST.markOptional(type4);
            }
        }
        return type4;
    }

    private Type unify1(Type type2, Type type3, boolean bl) {
        Type type4 = type2.resolve();
        Type type5 = type3.resolve();
        if (type2.hasInstantiated() && type3.hasInstantiated()) {
            InstantiatedT instantiatedT = type2.toInstantiated();
            InstantiatedT instantiatedT2 = type3.toInstantiated();
            List<Type> list = instantiatedT.getArguments();
            List<Type> list2 = instantiatedT2.getArguments();
            if (list.size() != list2.size()) {
                return ErrorT.TYPE;
            }
            Type type6 = this.unify(instantiatedT.getType(), instantiatedT2.getType(), true);
            if (type6.isError()) {
                return ErrorT.TYPE;
            }
            ArrayList<Type> arrayList = new ArrayList<Type>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                Type type7 = this.unify(list.get(i), list2.get(i), true);
                if (type7.isError()) {
                    return ErrorT.TYPE;
                }
                arrayList.add(type7);
            }
            return new InstantiatedT(arrayList, type6);
        }
        if (type2.hasInstantiated() || type3.hasInstantiated()) {
            return ErrorT.TYPE;
        }
        if (AST.isUser(type2) && AST.isUser(type3)) {
            return this.unifyUser(type2, type3, bl);
        }
        if (AST.isNode(type2) && AST.isNode(type3)) {
            if (AST.isNullNode(type2)) {
                return type5;
            }
            if (AST.isNullNode(type3)) {
                return type4;
            }
            if (AST.isToken(type2) && AST.isToken(type3)) {
                return TOKEN;
            }
            if ((AST.isToken(type2) || AST.isDynamicNode(type2) || AST.isFormatting(type2)) && (AST.isToken(type3) || AST.isDynamicNode(type3) || AST.isFormatting(type3))) {
                return NODE;
            }
            if (type4.isVariant() && type5.isVariant()) {
                return this.unify(type4.toVariant(), type5.toVariant());
            }
            if (bl) {
                return ErrorT.TYPE;
            }
            return NODE;
        }
        if (type4.isVoid() && type5.isVoid()) {
            return VoidT.TYPE;
        }
        if (type4.isUnit() && type5.isUnit()) {
            return UnitT.TYPE;
        }
        if (AST.isChar(type2) && AST.isChar(type3)) {
            return CHAR;
        }
        if (AST.isString(type2) && AST.isString(type3)) {
            return STRING;
        }
        if (AST.isList(type2) && AST.isList(type3)) {
            return LIST;
        }
        if (AST.isAction(type2) && AST.isAction(type3)) {
            return ACTION;
        }
        return ErrorT.TYPE;
    }

    protected Type unify(VariantT variantT, VariantT variantT2) {
        if (null != variantT.getName() && variantT.getName().equals(variantT2.getName())) {
            return variantT;
        }
        ArrayList<TupleT> arrayList = new ArrayList<TupleT>();
        VariantT variantT3 = new VariantT(null, true, arrayList);
        variantT3.addAttribute(Constants.ATT_NODE);
        if (variantT.isPolymorphic()) {
            arrayList.addAll(variantT.getTuples());
            if (variantT2.isPolymorphic()) {
                for (TupleT tupleT : variantT2.getTuples()) {
                    if (arrayList.contains(tupleT)) continue;
                    VariantT variantT4 = tupleT.getTypes().get(0).toVariant();
                    if (this.overlap(variantT, variantT4)) {
                        return ErrorT.TYPE;
                    }
                    arrayList.add(tupleT);
                }
            } else {
                TupleT tupleT = this.toTuple(variantT2);
                if (!arrayList.contains(tupleT)) {
                    if (this.overlap(variantT, variantT2)) {
                        return ErrorT.TYPE;
                    }
                    arrayList.add(tupleT);
                }
            }
        } else if (variantT2.isPolymorphic()) {
            arrayList.addAll(variantT2.getTuples());
            TupleT tupleT = this.toTuple(variantT);
            if (!arrayList.contains(tupleT)) {
                if (this.overlap(variantT, variantT2)) {
                    return ErrorT.TYPE;
                }
                arrayList.add(tupleT);
            }
        } else {
            if (this.overlap(variantT, variantT2)) {
                return ErrorT.TYPE;
            }
            arrayList.add(this.toTuple(variantT));
            arrayList.add(this.toTuple(variantT2));
        }
        return variantT3;
    }

    protected abstract Type unifyUser(Type var1, Type var2, boolean var3);

    public Type flatten(TupleT tupleT, boolean bl) {
        List<Type> list = tupleT.getTypes();
        int n = list.size();
        int n2 = -1;
        Type type2 = null;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            Type type3 = list.get(i);
            if (-1 == n2) {
                if (!AST.isList(type3)) continue;
                n2 = i;
                if (AST.isOptional(type3 = AST.getArgument(type3))) {
                    bl2 = true;
                }
                type2 = type3 = type3.deannotate();
                continue;
            }
            if (AST.isList(type3)) {
                type3 = AST.getArgument(type3);
            }
            if (AST.isOptional(type3)) {
                bl2 = true;
            }
            if (!(type2 = this.unify(type2, type3 = type3.deannotate(), bl)).isError()) continue;
            return ErrorT.TYPE;
        }
        if (-1 != n2) {
            if (bl2) {
                type2 = AST.markOptional(type2);
            }
            Type type4 = AST.listOf(type2);
            if (AST.isVariable(list.get(n2))) {
                type4 = AST.markVariable(type4);
            }
            list.subList(n2, n).clear();
            list.add(type4);
        }
        return tupleT;
    }

    public Type combine(TupleT tupleT, TupleT tupleT2, boolean bl, boolean bl2) {
        assert (tupleT.getName().equals(tupleT2.getName()));
        if (tupleT == tupleT2 || tupleT.equals(tupleT2)) {
            return tupleT;
        }
        List<Type> list = tupleT.getTypes();
        List<Type> list2 = tupleT2.getTypes();
        int n = list.size();
        int n2 = list2.size();
        int n3 = Integer.MAX_VALUE;
        Type type2 = Wildcard.TYPE;
        boolean bl3 = false;
        boolean bl4 = false;
        if (bl) {
            Type type3;
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                type3 = list.get(n4);
                if (!AST.isList(type3)) continue;
                n3 = n4;
                bl3 = AST.isVariable(type3);
                break;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                type3 = list2.get(n4);
                if (!AST.isList(type3)) continue;
                if (n4 >= n3) break;
                n3 = n4;
                bl3 = AST.isVariable(type3);
                break;
            }
            if (Integer.MAX_VALUE != n3) {
                for (n4 = n3; n4 < n; ++n4) {
                    type3 = list.get(n4);
                    if (AST.isList(type3)) {
                        type3 = AST.getArgument(type3);
                    }
                    if (AST.isOptional(type3)) {
                        bl4 = true;
                    }
                    if (!(type2 = this.unify(type2, type3 = type3.deannotate(), bl2)).isError()) continue;
                    return ErrorT.TYPE;
                }
                for (n4 = n3; n4 < n2; ++n4) {
                    type3 = list2.get(n4);
                    if (AST.isList(type3)) {
                        type3 = AST.getArgument(type3);
                    }
                    if (AST.isOptional(type3)) {
                        bl4 = true;
                    }
                    if (!(type2 = this.unify(type2, type3 = type3.deannotate(), bl2)).isError()) continue;
                    return ErrorT.TYPE;
                }
            }
        }
        ArrayList<Type> arrayList = new ArrayList<Type>(Math.max(n, n2));
        int n5 = Math.min(Math.max(n, n2), n3);
        for (int i = 0; i < n5; ++i) {
            Type type4;
            Type type5;
            Type type6 = i < n ? list.get(i) : null;
            Type type7 = type5 = i < n2 ? list2.get(i) : null;
            if (null == type6) {
                type4 = AST.markVariable(type5.deannotate());
            } else if (null == type5) {
                type4 = AST.markVariable(type6.deannotate());
            } else {
                type4 = this.unify(type6.deannotate(), type5.deannotate(), bl2);
                if (type4.isError()) {
                    return ErrorT.TYPE;
                }
                if (AST.isVariable(type6) || AST.isVariable(type5)) {
                    type4 = AST.markVariable(type4);
                } else if (AST.isOptional(type6) || AST.isOptional(type5)) {
                    type4 = AST.markOptional(type4);
                } else if ((type6.resolve().isWildcard() || type5.resolve().isWildcard()) && !type4.resolve().isWildcard()) {
                    type4 = AST.markOptional(type4);
                }
            }
            arrayList.add(type4);
        }
        if (Integer.MAX_VALUE != n3) {
            if (bl4) {
                type2 = AST.markOptional(type2);
            }
            Type type8 = AST.listOf(type2);
            if (bl3 || n3 > n || n3 > n2) {
                type8 = AST.markVariable(type8);
            }
            arrayList.add(type8);
        }
        return new TupleT(tupleT.getName(), arrayList);
    }

    public Type concretize(Type type2, Type type3) {
        Type type4;
        Type type5 = type2.resolve();
        Type type6 = null;
        if (type5.isWildcard()) {
            type6 = type3;
        } else if (type5.isTuple()) {
            TupleT tupleT = type5.toTuple();
            List<Type> list = tupleT.getTypes();
            boolean bl = false;
            for (int i = 0; i < list.size(); ++i) {
                Type type7 = this.concretize(list.get(i), type3);
                if (list.get(i) == type7) continue;
                if (!bl) {
                    list = new ArrayList<Type>(list);
                    bl = true;
                }
                list.set(i, type7);
            }
            if (bl) {
                type6 = new TupleT(tupleT.getName(), list);
            }
        } else if (AST.isList(type2)) {
            Type type8 = this.concretize(AST.getArgument(type2), type3);
            if (type8 != AST.getArgument(type2)) {
                type6 = AST.listOf(type8);
            }
        } else if (AST.isAction(type2) && (type4 = this.concretize(AST.getArgument(type2), type3)) != AST.getArgument(type2)) {
            type6 = AST.actionOf(type4);
        }
        if (null == type6) {
            return type2;
        }
        if (AST.isVariable(type2)) {
            type6 = AST.markVariable(type6);
        } else if (AST.isOptional(type2)) {
            type6 = AST.markOptional(type6);
        }
        return type6;
    }

    public void concretizeTuples(VariantT variantT, Type type2) {
        List<TupleT> list = variantT.getTuples();
        if (null != list) {
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, this.concretize(list.get(i), type2).toTuple());
            }
        }
    }

    public void print(Type type2, Printer printer, boolean bl, boolean bl2, String string) {
        switch (type2.tag()) {
            case VARIANT: {
                VariantT variantT = type2.resolve().toVariant();
                boolean bl3 = variantT.isPolymorphic();
                List<TupleT> list = variantT.getTuples();
                String string2 = !bl2 || null != string && string.equals(variantT.getQualifier()) ? variantT.getSimpleName() : variantT.getName();
                if (null == string2) {
                    printer.pln('[').incr().incr();
                    for (TupleT tupleT : list) {
                        printer.indent().p("| `");
                        this.print(tupleT, true, printer, bl2, string);
                        printer.pln();
                    }
                    printer.decr().decr().indentMore().p(']');
                    break;
                }
                if (!bl) {
                    printer.p(string2);
                    break;
                }
                if (bl3) {
                    printer.indent().p("mltype ").p(string2).pln(" = [").incr();
                    for (TupleT tupleT : list) {
                        printer.indent().p("| `");
                        this.print(tupleT, true, printer, bl2, string);
                        printer.pln();
                    }
                    printer.decr().indent().pln("];");
                    break;
                }
                if (1 == list.size()) {
                    printer.indent().p("mltype ").p(string2).p(" = ");
                    this.print(list.get(0), false, printer, bl2, string);
                    printer.pln(" ;");
                    break;
                }
                printer.indent().p("mltype ").p(string2).pln(" =").incr();
                Iterator<TupleT> iterator = list.iterator();
                while (iterator.hasNext()) {
                    printer.indent().p("| ");
                    this.print(iterator.next(), false, printer, bl2, string);
                    if (!iterator.hasNext()) continue;
                    printer.pln();
                }
                printer.pln(" ;").decr();
                break;
            }
            case TUPLE: {
                this.print(type2.resolve().toTuple(), false, printer, bl2, string);
                break;
            }
            case INTERNAL: {
                String string3 = type2.resolve().toInternal().getName();
                if ("list".equals(string3) || "action".equals(string3)) {
                    if (type2.hasInstantiated()) {
                        this.print(type2.toInstantiated().getArguments().get(0), printer, false, bl2, string);
                    } else {
                        this.print(type2.toParameterized().getParameters().get(0), printer, false, bl2, string);
                    }
                    printer.p(' ');
                }
                printer.p(string3);
                break;
            }
            case UNIT: 
            case VOID: {
                printer.p("bottom");
                break;
            }
            case WILDCARD: 
            case PARAMETER: {
                printer.p("'").p(type2.resolve().toParameter().getName());
                break;
            }
            case ERROR: {
                printer.p("<error>");
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid type " + type2));
            }
        }
        if (!bl) {
            if (type2.hasAttribute(Constants.ATT_VARIABLE)) {
                printer.p(" var");
            } else if (type2.hasAttribute(Constants.ATT_OPTIONAL)) {
                printer.p(" opt");
            }
        }
    }

    private void print(TupleT tupleT, boolean bl, Printer printer, boolean bl2, String string) {
        String string2 = tupleT.getName();
        if (!bl2 || !bl || null != string && string.equals(Utilities.getQualifier(string2))) {
            string2 = tupleT.getSimpleName();
        }
        printer.p(string2);
        List<Type> list = tupleT.getTypes();
        if (null != list && !list.isEmpty()) {
            printer.p(" of ");
            Iterator<Type> iterator = list.iterator();
            while (iterator.hasNext()) {
                Type type2 = iterator.next();
                if (type2.resolve().isVariant() && null == type2.resolve().toVariant().getName()) {
                    this.print(type2, printer, false, bl2, string);
                    if (!iterator.hasNext()) continue;
                    printer.p(" * ");
                    continue;
                }
                printer.buffer();
                this.print(type2, printer, false, bl2, string);
                if (iterator.hasNext()) {
                    printer.p(" * ");
                }
                printer.fitMore();
            }
        }
    }

    static {
        VOID = VoidT.TYPE;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("any");
        hashSet.add("char");
        hashSet.add("string");
        hashSet.add("token");
        hashSet.add("node");
        hashSet.add("formatting");
        hashSet.add("list");
        hashSet.add("action");
        INTERNAL = Collections.unmodifiableSet(hashSet);
        ANY = new InternalT("any");
        CHAR = new InternalT("char");
        STRING = new InternalT("string");
        TOKEN = new InternalT("token");
        TOKEN.addAttribute(Constants.ATT_NODE);
        NODE = new InternalT("node");
        NODE.addAttribute(Constants.ATT_NODE);
        NULL_NODE = new UnitT();
        NULL_NODE.addAttribute(Constants.ATT_NODE);
        GENERIC = new InternalT("node");
        GENERIC.addAttribute(Constants.ATT_NODE);
        GENERIC.addAttribute(Constants.ATT_GENERIC);
        FORMATTING = new InternalT("formatting");
        FORMATTING.addAttribute(Constants.ATT_NODE);
        LIST = new ParameterizedT(new Parameter("element"), (Type)new InternalT("list"));
        WILD_LIST = new InstantiatedT(Wildcard.TYPE, LIST);
        ACTION = new ParameterizedT(new Parameter("element"), (Type)new InternalT("action"));
        WILD_ACTION = new InstantiatedT(Wildcard.TYPE, ACTION);
        ANY.seal();
        CHAR.seal();
        STRING.seal();
        TOKEN.seal();
        NULL_NODE.seal();
        NODE.seal();
        GENERIC.seal();
        FORMATTING.seal();
        LIST.seal();
        WILD_LIST.seal();
        ACTION.seal();
        WILD_ACTION.seal();
    }

    public static class MetaData {
        public Set<String> reachable = new HashSet<String>();
        public boolean modularize = false;
    }
}

