/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.BreakIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import xtc.tree.Attribute;
import xtc.tree.Comment;
import xtc.tree.Locatable;
import xtc.tree.Location;
import xtc.tree.Node;
import xtc.tree.Utility;
import xtc.util.Pair;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Printer
extends Utility {
    protected BreakIterator breaks;
    protected PrintWriter out;
    protected PrintWriter directOut;
    protected StringWriter bufferedOut = null;
    protected int buffering = 0;
    protected int indent = 0;
    protected int column = 1;
    protected long line = 1L;
    private String formatFile;

    public Printer(OutputStream outputStream) {
        this(new PrintWriter(outputStream, false));
    }

    public Printer(Writer writer) {
        this(new PrintWriter(writer, false));
    }

    public Printer(PrintWriter printWriter) {
        this.out = printWriter;
        this.directOut = printWriter;
    }

    public Printer reset() {
        this.stopBuffering();
        this.indent = 0;
        this.column = 1;
        this.line = 1L;
        return this;
    }

    public int column() {
        return this.column;
    }

    public Printer column(int n) {
        this.column = n;
        return this;
    }

    public long line() {
        return this.line;
    }

    public Printer line(long l) {
        this.line = l;
        return this;
    }

    public Printer buffer() {
        if (0 == this.buffering) {
            this.bufferedOut = new StringWriter();
            this.out = new PrintWriter((Writer)this.bufferedOut, false);
        }
        ++this.buffering;
        return this;
    }

    protected String stopBuffering() {
        if (null != this.bufferedOut) {
            this.out.flush();
            String string = this.bufferedOut.toString();
            this.out = this.directOut;
            this.bufferedOut = null;
            this.buffering = 0;
            return string;
        }
        return "";
    }

    public Printer fit() {
        if (1 == this.buffering) {
            String string = this.stopBuffering();
            if (79 < this.column) {
                this.out.println();
                this.column = 1;
                ++this.line;
                this.indent().p(string);
            } else {
                this.out.print(string);
            }
        } else if (1 < this.buffering) {
            --this.buffering;
        }
        return this;
    }

    public Printer fit(int n) {
        if (1 == this.buffering) {
            String string = this.stopBuffering();
            if (79 < this.column) {
                this.out.println();
                this.column = 1;
                ++this.line;
                this.align(n).p(string);
            } else {
                this.out.print(string);
            }
        } else if (1 < this.buffering) {
            --this.buffering;
        }
        return this;
    }

    public Printer fit(String string) {
        if (1 == this.buffering) {
            String string2 = this.stopBuffering();
            if (79 < this.column) {
                this.out.println();
                this.column = 1;
                ++this.line;
                this.indent().p(string).p(string2);
            } else {
                this.out.print(string2);
            }
        } else if (1 < this.buffering) {
            --this.buffering;
        }
        return this;
    }

    public Printer fitMore() {
        if (1 == this.buffering) {
            String string = this.stopBuffering();
            if (79 < this.column) {
                this.out.println();
                this.column = 1;
                ++this.line;
                this.indentMore().p(string);
            } else {
                this.out.print(string);
            }
        } else if (1 < this.buffering) {
            --this.buffering;
        }
        return this;
    }

    public Printer unbuffer() {
        if (0 < this.buffering) {
            String string = this.stopBuffering();
            this.out.write(string);
        }
        return this;
    }

    public Printer align(int n) {
        int n2 = n - this.column;
        if (0 >= n2) {
            n2 = 1;
        }
        for (int i = 0; i < n2; ++i) {
            this.out.write(32);
        }
        this.column += n2;
        return this;
    }

    public int level() {
        return this.indent / 2;
    }

    public Printer setLevel(int n) {
        if (0 > n) {
            throw new IllegalArgumentException("Negative indentation level");
        }
        this.indent = n * 2;
        return this;
    }

    public Printer incr() {
        this.indent += 2;
        return this;
    }

    public Printer decr() {
        this.indent -= 2;
        return this;
    }

    public Printer indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.print(' ');
        }
        this.column += this.indent;
        return this;
    }

    public Printer indentLess() {
        int n = this.indent - 2;
        if (0 > n) {
            n = 0;
        }
        for (int i = 0; i < n; ++i) {
            this.out.print(' ');
        }
        this.column += n;
        return this;
    }

    public Printer indentMore() {
        int n = this.indent + 2;
        for (int i = 0; i < n; ++i) {
            this.out.print(' ');
        }
        this.column += n;
        return this;
    }

    public Printer p(char c) {
        this.out.print(c);
        ++this.column;
        return this;
    }

    public Printer p(int n) {
        return this.p(Integer.toString(n));
    }

    public Printer p(long l) {
        return this.p(Long.toString(l));
    }

    public Printer p(double d) {
        return this.p(Double.toString(d));
    }

    public Printer p(String string) {
        this.out.print(string);
        this.column += string.length();
        return this;
    }

    public Printer pln(char c) {
        this.unbuffer();
        this.out.println(c);
        this.column = 1;
        ++this.line;
        return this;
    }

    public Printer pln(int n) {
        return this.pln(Integer.toString(n));
    }

    public Printer pln(long l) {
        return this.pln(Long.toString(l));
    }

    public Printer pln(double d) {
        return this.pln(Double.toString(d));
    }

    public Printer pln(String string) {
        this.unbuffer();
        this.out.println(string);
        this.column = 1;
        ++this.line;
        return this;
    }

    public Printer pln() {
        this.unbuffer();
        this.out.println();
        this.column = 1;
        ++this.line;
        return this;
    }

    public Printer escape(char c) {
        return this.p(Utilities.escape(c, 9));
    }

    public Printer escape(char c, int n) {
        return this.p(Utilities.escape(c, n));
    }

    public Printer escape(String string) {
        return this.p(Utilities.escape(string, 9));
    }

    public Printer escape(String string, int n) {
        return this.p(Utilities.escape(string, n));
    }

    public Printer pad(long l, int n) {
        String string = Long.toString(l);
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            this.p(' ');
        }
        this.p(string);
        return this;
    }

    public Printer sep() {
        this.unbuffer();
        this.indent().p("// ");
        int n = 78 - this.indent - 3;
        for (int i = 0; i < n; ++i) {
            this.out.print('=');
        }
        this.out.println();
        this.column = 1;
        ++this.line;
        return this;
    }

    public Printer wrap(int n, String string) {
        if (null == this.breaks) {
            this.breaks = BreakIterator.getLineInstance(Locale.ENGLISH);
        }
        this.breaks.setText(string);
        int n2 = this.breaks.first();
        int n3 = this.breaks.next();
        boolean bl = true;
        while (-1 != n3) {
            String string2 = string.substring(n2, n3);
            if (!bl && 79 < this.column + string2.length()) {
                this.pln();
                if (1 != n) {
                    this.align(n);
                }
            }
            this.p(string2);
            n2 = n3;
            n3 = this.breaks.next();
            bl = false;
        }
        return this;
    }

    public Printer p(Node node) {
        this.visitor.dispatch(node);
        return this;
    }

    public Printer p(Attribute attribute) {
        this.p(attribute.name);
        if (null != attribute.value) {
            this.p('(');
            if (attribute.value instanceof List || attribute.value instanceof Pair) {
                boolean bl = true;
                for (Object t : (Iterable)attribute.value) {
                    if (bl) {
                        bl = false;
                    } else {
                        this.p(", ");
                    }
                    this.p(t.toString());
                }
            } else {
                this.p(attribute.value.toString());
            }
            this.p(')');
        }
        return this;
    }

    public Printer p(Comment comment) {
        if (0 == comment.text.size()) {
            return this;
        }
        if (Comment.Kind.SINGLE_LINE == comment.kind) {
            this.p("// ").pln(comment.text.get(0));
        } else {
            if (Comment.Kind.MULTIPLE_LINES == comment.kind) {
                this.p("/*");
            } else {
                this.p("/**");
            }
            if (1 == comment.text.size()) {
                this.p(' ').p(comment.text.get(0)).pln(" */");
            } else {
                this.pln();
                for (String string : comment.text) {
                    this.indent().p(" * ").pln(string);
                }
                this.indent().pln(" */");
            }
        }
        return this;
    }

    public Printer format(Node node) {
        return this.format1(node, false);
    }

    public Printer format(Node node, boolean bl) {
        this.formatFile = null;
        return this.format1(node, bl);
    }

    private Printer format1(Object object, boolean bl) {
        this.indent();
        if (null == object) {
            this.p("null");
        } else if (object instanceof Node) {
            Node node = (Node)object;
            this.p(node.getName());
            if (bl && node.hasLocation()) {
                Location location = node.getLocation();
                this.p('@');
                if (!location.file.equals(this.formatFile)) {
                    this.p(location.file).p(':');
                    this.formatFile = location.file;
                }
                this.p(location.line).p(':').p(location.column);
            }
            this.p('(');
            if (node.isEmpty()) {
                this.p(')');
            } else {
                this.pln().incr().formatElements(node, bl).decr().indent().p(')');
            }
        } else if (object instanceof Pair) {
            Pair pair = (Pair)object;
            if (pair.isEmpty()) {
                this.p("[]");
            } else {
                this.pln('[').incr().formatElements(pair, bl).decr().indent().p(']');
            }
        } else if (object instanceof String) {
            this.p('\"').escape(object.toString(), 9).p('\"');
        } else {
            this.p(object.toString());
        }
        return this;
    }

    private Printer formatElements(Iterable<?> iterable, boolean bl) {
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            this.format1(iterator.next(), bl);
            if (iterator.hasNext()) {
                this.p(',');
            }
            this.pln();
        }
        return this;
    }

    public Printer loc(Locatable locatable) {
        Object object;
        if (locatable instanceof Node && ((Node)(object = (Node)locatable)).hasProperty("xtc.Constants.Original")) {
            locatable = (Locatable)((Node)object).getProperty("xtc.Constants.Original");
        }
        if (locatable.hasLocation()) {
            object = locatable.getLocation();
            this.p(((Location)object).file).p(':').p(((Location)object).line).p(':').p(((Location)object).column);
        }
        return this;
    }

    public Printer lineUp(Locatable locatable) {
        return this.lineUp(locatable, 0);
    }

    public Printer lineUp(Locatable locatable, int n) {
        if (!locatable.hasLocation()) {
            throw new IllegalArgumentException("Locatable without location " + locatable);
        }
        Location location = locatable.getLocation();
        if (0 > location.column - n) {
            throw new IllegalArgumentException("Invalid character distance " + n);
        }
        if ((long)location.line > this.line) {
            int n2 = 0;
            while ((long)n2 < (long)location.line - this.line) {
                this.pln();
                ++n2;
            }
            for (n2 = 0; n2 < location.column - n; ++n2) {
                this.p(' ');
            }
        } else if ((long)location.line == this.line && location.column - n >= this.column) {
            for (int i = 0; i < location.column - n - this.column; ++i) {
                this.p(' ');
            }
        } else {
            this.p(' ');
        }
        return this;
    }

    public Printer flush() {
        this.out.flush();
        return this;
    }

    public void close() {
        this.stopBuffering();
        this.out.close();
    }
}

