/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import xtc.tree.Annotation;
import xtc.tree.GNode;
import xtc.tree.Locatable;
import xtc.tree.Location;
import xtc.tree.Token;
import xtc.util.Pair;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements Iterable<Object>,
Locatable {
    Map<String, Object> properties;
    Location location;

    public Node() {
    }

    public Node(Location location) {
        this.location = location;
    }

    public boolean isToken() {
        return false;
    }

    public Token toToken() {
        throw new ClassCastException("Not a token");
    }

    public String getTokenText() {
        throw new ClassCastException("Not a token");
    }

    public boolean isAnnotation() {
        return false;
    }

    public Annotation toAnnotation() {
        throw new ClassCastException("Not an annotation");
    }

    public boolean isGeneric() {
        return false;
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean hasName(String string) {
        return this.getClass().getName().equals(string);
    }

    public Object setProperty(String string, Object object) {
        if (null == this.properties) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties.put(string, object);
    }

    public boolean hasProperty(String string) {
        if (null == this.properties) {
            return false;
        }
        return this.properties.containsKey(string);
    }

    public Object getProperty(String string) {
        if (null == this.properties) {
            return null;
        }
        return this.properties.get(string);
    }

    public boolean getBooleanProperty(String string) {
        if (null == this.properties) {
            return false;
        }
        Object object = this.properties.get(string);
        if (null == object) {
            return false;
        }
        return (Boolean)object;
    }

    public String getStringProperty(String string) {
        if (null == this.properties) {
            return null;
        }
        return (String)this.properties.get(string);
    }

    public Object removeProperty(String string) {
        if (null == this.properties) {
            return null;
        }
        return this.properties.remove(string);
    }

    public Set<String> properties() {
        if (null == this.properties) {
            return Collections.emptySet();
        }
        return this.properties.keySet();
    }

    @Override
    public boolean hasLocation() {
        return null != this.location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public void setLocation(Locatable locatable) {
        if (locatable.hasLocation()) {
            this.location = locatable.getLocation();
        }
    }

    public boolean hasTraversal() {
        return false;
    }

    public boolean isEmpty() {
        return 0 == this.size();
    }

    @Override
    public Iterator<Object> iterator() {
        final int n = this.size();
        return new Iterator<Object>(){
            int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor < n;
            }

            @Override
            public Object next() {
                if (this.cursor < n) {
                    return Node.this.get(this.cursor++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Down with Iterator.remove()");
            }
        };
    }

    public int size() {
        throw new UnsupportedOperationException();
    }

    public Object get(int n) {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(int n) {
        return (Boolean)this.get(n);
    }

    public String getString(int n) {
        Object object = this.get(n);
        if (null == object) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        return ((Node)object).getTokenText();
    }

    public Node getNode(int n) {
        return (Node)this.get(n);
    }

    public GNode getGeneric(int n) {
        Object object = this.get(n);
        return null == object ? null : (GNode)((Node)object).strip();
    }

    public <T> Pair<T> getList(int n) {
        return (Pair)this.get(n);
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public int indexOf(Object object) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            Object object2 = this.get(i);
            if (!(null == object ? null == object2 : object.equals(object2))) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        for (int i = this.size() - 1; i >= 0; --i) {
            Object object2 = this.get(i);
            if (!(null == object ? null == object2 : object.equals(object2))) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(Object object) {
        return -1 != this.indexOf(object);
    }

    public void addAllTo(Collection<Object> collection) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            collection.add(this.get(i));
        }
    }

    public boolean hasVariable() {
        return false;
    }

    public Node add(Object object) {
        throw new UnsupportedOperationException();
    }

    public Node addNode(Node node) {
        return this.add(node);
    }

    public Node add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public Node addAll(Pair<?> pair) {
        while (Pair.empty() != pair) {
            this.add(pair.head());
            pair = pair.tail();
        }
        return this;
    }

    public Node addAll(int n, Pair<?> pair) {
        while (Pair.empty() != pair) {
            this.add(n++, pair.head());
            pair = pair.tail();
        }
        return this;
    }

    public Node addAll(Collection<?> collection) {
        for (Object obj : collection) {
            this.add(obj);
        }
        return this;
    }

    public Node addAll(int n, Collection<?> collection) {
        for (Object obj : collection) {
            this.add(n++, obj);
        }
        return this;
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    public Node strip() {
        return this;
    }

    public void write(Appendable appendable) throws IOException {
        if (!this.hasTraversal()) {
            appendable.append(super.toString());
        } else {
            appendable.append(this.getName());
            appendable.append('(');
            boolean bl = true;
            for (Object object : this) {
                if (bl) {
                    bl = false;
                } else {
                    appendable.append(", ");
                }
                if (null == object) {
                    appendable.append("null");
                    continue;
                }
                if (object instanceof String) {
                    appendable.append('\"');
                    Utilities.escape((String)object, appendable, 8);
                    appendable.append('\"');
                    continue;
                }
                if (object instanceof Node) {
                    ((Node)object).write(appendable);
                    continue;
                }
                appendable.append(object.toString());
            }
            appendable.append(')');
        }
    }

    public String toString() {
        StringBuilder stringBuilder;
        block2: {
            stringBuilder = new StringBuilder();
            try {
                this.write(stringBuilder);
            }
            catch (IOException iOException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return stringBuilder.toString();
    }

    public static final boolean isList(Object object) {
        if (!(object instanceof Pair)) {
            return false;
        }
        if (Pair.EMPTY == object) {
            return true;
        }
        return ((Pair)object).head() instanceof Node;
    }

    public static final Pair<Node> toList(Object object) {
        if (Node.isList(object)) {
            return (Pair)object;
        }
        throw new ClassCastException("Not a list of nodes " + object);
    }
}

