/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import xtc.lang.JavaPrinter;
import xtc.tree.Attribute;
import xtc.tree.Comment;
import xtc.tree.LineMarker;
import xtc.tree.Location;
import xtc.tree.Node;
import xtc.tree.Printer;

public class LineupPrinter
extends Printer {
    protected boolean blankLine = true;
    protected boolean currentNodeHasLocation = true;
    protected String lastFile = null;
    protected long lastLine = 0L;
    protected String markedFile = null;
    protected long markedLine = 0L;
    protected long markedPhysical = 0L;
    protected boolean showFilePaths = true;

    public LineupPrinter(OutputStream outputStream, boolean bl) {
        this(new PrintWriter(outputStream, false), bl);
    }

    public LineupPrinter(PrintWriter printWriter, boolean bl) {
        super(printWriter);
        this.showFilePaths = bl;
    }

    public LineupPrinter(Writer writer, boolean bl) {
        this(new PrintWriter(writer, false), bl);
    }

    public Printer align(int n) {
        if (this.blankLine) {
            this.indent = n;
            return this;
        }
        return super.align(n);
    }

    protected long effectiveLine() {
        return this.markedLine + this.line - this.markedPhysical;
    }

    protected void endBlank() {
        if (this.blankLine) {
            if (1 < this.column) {
                if (!this.currentNodeHasLocation && null != this.lastFile) {
                    this.printLineMarker(this.lastFile, this.lastLine);
                } else {
                    super.pln();
                }
            }
            this.blankLine = false;
            super.indent();
        }
    }

    protected void ensureLocation(Node node) {
        if (null == node || !node.hasLocation()) {
            return;
        }
        Location location = node.getLocation();
        int n = location.column + 1 - 1;
        if (null == this.markedFile || !this.markedFile.equals(location.file) || (long)location.line < this.effectiveLine() || this.effectiveLine() + 2L < (long)location.line || (long)location.line == this.effectiveLine() && n < this.column) {
            this.markedFile = location.file;
            this.markedLine = location.line;
            this.printLineMarker(this.markedFile, this.markedLine);
            this.markedPhysical = this.line();
            assert (this.effectiveLine() == (long)location.line);
        }
        assert (this.markedFile.equals(location.file) && this.effectiveLine() <= (long)location.line);
        while (this.effectiveLine() < (long)location.line) {
            super.pln();
        }
        if (this.blankLine) {
            if (1 == this.column) {
                this.indent = n;
            }
            this.blankLine = false;
        }
        assert (this.column <= n);
        while (this.column < n) {
            super.p(' ');
        }
        assert (this.effectiveLine() == (long)location.line && this.column == n);
    }

    public Printer indent() {
        if (this.indent < 0) {
            this.indent = 0;
        }
        return this;
    }

    public Printer indentLess() {
        if (this.indent < 2) {
            this.indent = 2;
        }
        return this;
    }

    public Printer indentMore() {
        if (this.indent < 0) {
            this.indent = 0;
        }
        return this;
    }

    public Printer p(Attribute attribute) {
        return this.printNode(attribute);
    }

    public Printer p(char c) {
        if (this.blankLine && ' ' == c) {
            ++this.indent;
            return this;
        }
        this.endBlank();
        return super.p(c);
    }

    public Printer p(Comment comment) {
        return this.printNode(comment);
    }

    public Printer p(double d) {
        this.endBlank();
        return super.p(d);
    }

    public Printer p(int n) {
        this.endBlank();
        return super.p(n);
    }

    public Printer p(long l) {
        this.endBlank();
        return super.p(l);
    }

    public Printer p(Node node) {
        return this.printNode(node);
    }

    public Printer p(String string) {
        this.endBlank();
        return super.p(string);
    }

    public Printer pln() {
        this.blankLine = true;
        return this;
    }

    public Printer pln(char c) {
        return this.p(c).pln();
    }

    public Printer pln(double d) {
        return this.p(d).pln();
    }

    public Printer pln(int n) {
        return this.p(n).pln();
    }

    public Printer pln(long l) {
        return this.p(l).pln();
    }

    public Printer pln(String string) {
        return this.p(string).pln();
    }

    public void printLineMarker(String string, long l) {
        boolean bl;
        if (1 < this.column) {
            super.pln();
        }
        super.p((bl = this.visitor instanceof JavaPrinter) ? "//#line " : "# ");
        int n = string.lastIndexOf(47);
        boolean bl2 = !bl || this.showFilePaths || -1 == n;
        String string2 = bl2 ? string : string.substring(n + 1);
        super.p(l + " \"" + string2 + "\"");
        super.pln();
        this.blankLine = true;
    }

    protected Printer printNode(Node node) {
        boolean bl = this.currentNodeHasLocation;
        boolean bl2 = this.currentNodeHasLocation = null != node && node.hasLocation();
        if (this.currentNodeHasLocation) {
            this.lastFile = node.getLocation().file;
            this.lastLine = node.getLocation().line;
        }
        if (node instanceof LineMarker) {
            LineMarker lineMarker = (LineMarker)node;
            assert (node.getLocation().file.equals(lineMarker.file) && node.getLocation().line == lineMarker.line - 1);
            if (1 < this.column) {
                super.pln();
            }
            this.indent = 0;
            this.markedFile = lineMarker.file;
            this.markedLine = lineMarker.line;
            this.markedPhysical = this.line + 2L;
        } else {
            this.ensureLocation(node);
        }
        super.p(node);
        this.currentNodeHasLocation = bl;
        return this;
    }

    public Printer reset() {
        this.blankLine = true;
        return super.reset();
    }

    public Printer sep() {
        this.blankLine = true;
        return super.sep();
    }
}

