/*
 * Decompiled with CFR 0.152.
 */
package xtc.tree;

import java.io.IOException;
import java.util.List;
import xtc.tree.Node;
import xtc.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Attribute
extends Node {
    final String name;
    final Object value;

    public Attribute(String string) {
        this(string, null);
    }

    public Attribute(String string, Object object) {
        this.name = string;
        this.value = object;
    }

    @Override
    public boolean hasTraversal() {
        return true;
    }

    @Override
    public int size() {
        return null == this.value ? 1 : 2;
    }

    @Override
    public Object get(int n) {
        if (0 == n) {
            return this.name;
        }
        if (null != this.value && 1 == n) {
            return this.value;
        }
        throw new IndexOutOfBoundsException("Index : " + n + ", Size: " + (null == this.value ? 1 : 2));
    }

    @Override
    public Object set(int n, Object object) {
        throw new IllegalStateException("Attributes are immutable");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        if (!this.name.equals(attribute.name)) {
            return false;
        }
        if (null == this.value) {
            return null == attribute.value;
        }
        return this.value.equals(attribute.value);
    }

    @Override
    public void write(Appendable appendable) throws IOException {
        appendable.append(this.name);
        if (null != this.value) {
            appendable.append('(');
            if (this.value instanceof List || this.value instanceof Pair) {
                boolean bl = true;
                for (Object t : (Iterable)this.value) {
                    if (bl) {
                        bl = false;
                    } else {
                        appendable.append(", ");
                    }
                    if (t instanceof Node) {
                        ((Node)t).write(appendable);
                        continue;
                    }
                    appendable.append(t.toString());
                }
            } else if (this.value instanceof Node) {
                ((Node)this.value).write(appendable);
            } else {
                appendable.append(this.value.toString());
            }
            appendable.append(')');
        }
    }

    public static Attribute get(String string, List<Attribute> list) {
        if (null == list) {
            return null;
        }
        for (Attribute attribute : list) {
            if (!string.equals(attribute.name)) continue;
            return attribute;
        }
        return null;
    }

    public static boolean areEquivalent(List<Attribute> list, List<Attribute> list2) {
        if (null == list) {
            return null == list2 || 0 == list2.size();
        }
        if (null == list2) {
            return 0 == list.size();
        }
        return list.containsAll(list2) && list2.containsAll(list);
    }
}

