/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.parser.Analyzer;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Module;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Sequence;
import xtc.tree.Visitor;
import xtc.util.Runtime;

public class ValueChecker
extends Visitor {
    protected Runtime runtime;
    protected Analyzer analyzer;
    protected List<Element> elements;

    public ValueChecker(Runtime runtime, Analyzer analyzer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.elements = new ArrayList<Element>();
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        this.elements.clear();
        for (Production production : module.productions) {
            this.dispatch(production);
        }
    }

    public void visit(FullProduction fullProduction) {
        this.dispatch(fullProduction.choice);
    }

    public void visit(OrderedChoice orderedChoice) {
        for (Sequence sequence : orderedChoice.alternatives) {
            this.dispatch(sequence);
        }
    }

    public void visit(Sequence sequence) {
        int n = this.elements.size();
        Iterator<Element> iterator = sequence.elements.iterator();
        while (iterator.hasNext()) {
            Element element = iterator.next();
            if (!iterator.hasNext() && element instanceof OrderedChoice) {
                this.dispatch(element);
                continue;
            }
            this.elements.add(element);
        }
        if (!sequence.hasTrailingChoice() && !Analyzer.setsValue(this.elements, false)) {
            int n2 = this.elements.size();
            if (0 == n2) {
                this.runtime.error("empty alternative without semantic value", sequence);
            } else if (this.elements.get(n2 - 1).hasLocation()) {
                this.runtime.error("last element in alternative without semantic value", this.elements.get(n2 - 1));
            } else {
                this.runtime.error("alternative without semantic value", sequence);
            }
        }
        if (0 == n) {
            this.elements.clear();
        } else {
            this.elements.subList(n, this.elements.size()).clear();
        }
    }
}

