/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.Element;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.UnaryOperator;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.TupleT;
import xtc.type.Type;
import xtc.type.UnitT;
import xtc.type.VariantT;
import xtc.util.Runtime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeTyper
extends Visitor {
    private static final boolean DEBUG = false;
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected boolean strict;
    protected boolean flatten;
    protected Sequence sequence;

    public TreeTyper(Runtime runtime, Analyzer analyzer, AST aST) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = aST;
    }

    /*
     * WARNING - void declaration
     */
    public void visit(Module module) {
        Node node22;
        this.analyzer.register(this);
        this.analyzer.init(module);
        this.strict = this.runtime.test("optionVariant");
        this.flatten = module.hasAttribute(Constants.ATT_FLATTEN);
        for (Node node22 : module.productions) {
            this.analyzer.process((Production)node22);
        }
        Printer printer = this.runtime.console();
        printer.sep();
        printer.indent().p("// Generated by Rats!, version ").p("1.14.1").p(", ").p("(C) 2004-2008 Robert Grimm").pln('.');
        printer.sep();
        printer.pln();
        printer.indent().p("/** AST structure for grammar ").p(module.name.name).pln(". */");
        if (!this.runtime.test("optionVariant")) {
            node22 = this.ast.toVariant("Node", false);
            this.ast.concretizeTuples((VariantT)node22, UnitT.TYPE);
            printer.indent().p("module ").p(module.name.name).p("Tree").pln(';');
            printer.pln();
            this.ast.print((Type)node22, printer, true, false, null);
            printer.pln();
        } else {
            Object object;
            node22 = this.analyzer.lookup((NonTerminal)((NonTerminal)module.getProperty((String)"root"))).type.resolve().toVariant();
            AST.MetaData metaData = this.ast.getMetaData((VariantT)node22);
            HashSet<String> hashSet = new HashSet<String>();
            for (Production object3 : module.productions) {
                String string;
                if (!AST.isStaticNode(object3.type) || !metaData.reachable.contains(string = ((VariantT)(object = object3.type.resolve().toVariant())).getName()) || hashSet.contains(string)) continue;
                hashSet.add(string);
                this.ast.concretizeTuples((VariantT)object, UnitT.TYPE);
            }
            hashSet.clear();
            if (!metaData.modularize) {
                printer.indent().p("module ").p(module.name.name).p("Tree").pln(';');
                printer.pln();
                for (Production production : module.productions) {
                    String string;
                    if (!AST.isStaticNode(production.type) || !metaData.reachable.contains(string = ((VariantT)(object = production.type.resolve().toVariant())).getName()) || hashSet.contains(string)) continue;
                    hashSet.add(string);
                    this.ast.print((Type)object, printer, true, false, null);
                    printer.pln();
                }
            } else {
                void var7_13;
                boolean bl = true;
                do {
                    Object var7_12 = null;
                    for (Production production : module.productions) {
                        VariantT variantT;
                        String string;
                        if (!AST.isStaticNode(production.type) || !metaData.reachable.contains(string = (variantT = production.type.resolve().toVariant()).getName()) || hashSet.contains(string)) continue;
                        String string2 = variantT.getQualifier();
                        if (null == var7_13) {
                            String string3 = string2;
                            if (bl) {
                                bl = false;
                            } else {
                                printer.sep().pln();
                            }
                            printer.indent().p("module ").p(string3).pln(';');
                            printer.pln();
                        } else if (!var7_13.equals(string2)) continue;
                        hashSet.add(string);
                        this.ast.print(variantT, printer, true, true, (String)var7_13);
                        printer.pln();
                    }
                } while (null != var7_13);
            }
        }
        printer.sep().flush();
    }

    public void visit(Production production) {
        this.dispatch(production.choice);
    }

    public void visit(OrderedChoice orderedChoice) {
        for (Sequence sequence : orderedChoice.alternatives) {
            this.dispatch(sequence);
        }
    }

    public void visit(Sequence sequence) {
        Sequence sequence2 = this.sequence;
        this.sequence = sequence;
        for (Element element : sequence.elements) {
            this.dispatch(element);
        }
        this.sequence = sequence2;
    }

    public void visit(UnaryOperator unaryOperator) {
        this.dispatch(unaryOperator.element);
    }

    public void visit(Element element) {
    }

    public void visit(GenericNodeValue genericNodeValue) {
        this.process(genericNodeValue.name, false, genericNodeValue.children);
    }

    public void visit(GenericActionValue genericActionValue) {
        this.process(genericActionValue.name, true, genericActionValue.children);
    }

    protected void process(String string, boolean bl, List<Binding> list) {
        boolean bl2;
        Node node;
        Object object;
        int n;
        if (this.flatten) {
            n = 0;
            block4: for (int i = 0; i < list.size() - 1; ++i) {
                object = list.get(i);
                if (!(((Binding)object).element instanceof NonTerminal)) continue;
                NonTerminal node22 = (NonTerminal)((Binding)object).element;
                Binding binding = list.get(i + 1);
                switch (binding.element.tag()) {
                    case REPETITION: {
                        node = (Repetition)binding.element;
                        Node node2 = Analyzer.getBinding(((Sequence)((Repetition)node).element).elements);
                        if (null == node2) {
                            throw new IllegalStateException("Malformed repetition " + node);
                        }
                        if (node22.equals(((Binding)node2).element)) break;
                        continue block4;
                    }
                    case NONTERMINAL: {
                        node = (NonTerminal)binding.element;
                        Node node2 = this.analyzer.lookup((NonTerminal)node);
                        if (node22.equals(node2.getProperty("repeated"))) break;
                        continue block4;
                    }
                    default: {
                        continue block4;
                    }
                }
                if (n == 0) {
                    list = new ArrayList<Binding>(list);
                    n = 1;
                }
                list.remove(i);
                if (-1 <= (i -= 2)) continue;
                i = -1;
            }
        }
        n = bl ? list.size() + 1 : list.size();
        ArrayList<Type> arrayList = new ArrayList<Type>(n);
        if (bl) {
            if (this.runtime.test("optionVariant")) {
                object = this.analyzer.current().type;
                if (AST.isList((Type)object)) {
                    object = AST.getArgument((Type)object);
                }
                if (AST.isAction((Type)object)) {
                    object = AST.getArgument((Type)object);
                }
                arrayList.add((Type)object);
            } else {
                arrayList.add(AST.NODE);
            }
        }
        for (Binding binding : list) {
            arrayList.add(this.analyzer.type(binding.element));
        }
        object = this.ast.toTuple(string);
        TupleT tupleT = new TupleT(string, arrayList);
        boolean bl3 = bl2 = null == ((TupleT)object).getTypes();
        if (bl2 && !this.runtime.test("optionVariant")) {
            this.ast.add((TupleT)object, this.ast.toVariant("Node", false));
        }
        if (!bl2) {
            node = this.ast.combine((TupleT)object, tupleT, this.flatten, this.strict);
            if (((Type)node).isError()) {
                this.runtime.error("unable to consistently type tuple '" + string + "'", this.sequence);
                this.runtime.errConsole().loc(this.sequence).p(": error: 1st type is '");
                this.ast.print((Type)object, this.runtime.errConsole(), false, true, null);
                this.runtime.errConsole().pln("'");
                this.runtime.errConsole().loc(this.sequence).p(": error: 2nd type is '");
                this.ast.print((Type)tupleT, this.runtime.errConsole(), false, true, null);
                this.runtime.errConsole().pln("'").flush();
            } else {
                ((TupleT)object).setTypes(((Type)node).toTuple().getTypes());
            }
        } else if (this.flatten) {
            node = this.ast.flatten(tupleT, this.strict);
            if (((Type)node).isError()) {
                this.runtime.error("unable to flatten tuple '" + string + "'", this.sequence);
                this.runtime.errConsole().loc(this.sequence).p(": error: type is '");
                this.ast.print((Type)tupleT, this.runtime.errConsole(), false, true, null);
                this.runtime.errConsole().pln("'").flush();
            } else {
                ((TupleT)object).setTypes(((Type)node).toTuple().getTypes());
            }
        } else {
            ((TupleT)object).setTypes(arrayList);
        }
    }
}

