/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.List;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.BindingValue;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FullProduction;
import xtc.parser.Generifier;
import xtc.parser.GrammarVisitor;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.NullValue;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.ProperListValue;
import xtc.parser.Quantification;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringValue;
import xtc.parser.TextTester;
import xtc.parser.TokenValue;
import xtc.parser.Tokenizer;
import xtc.parser.ValueElement;
import xtc.tree.Attribute;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.Type;
import xtc.type.Wildcard;
import xtc.util.Runtime;

public class Transformer
extends Visitor {
    public static final String ELEMENT_MARKER = "el";
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected boolean hasParseTree;
    protected FullProduction production;

    public Transformer(Runtime runtime, Analyzer analyzer, AST aST) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = aST;
    }

    protected void process(FullProduction fullProduction) {
        FullProduction fullProduction2 = this.production;
        this.production = fullProduction;
        new Deducer().dispatch(this.production);
        new Lifter().dispatch(this.production);
        new Desugarer().dispatch(this.production);
        new Typer().dispatch(fullProduction);
        this.production = fullProduction2;
    }

    protected boolean isMemoized() {
        return this.production.isMemoized();
    }

    protected boolean isVoid() {
        return AST.isVoid(this.production.type);
    }

    protected boolean isTextOnly() {
        return this.production.getBooleanProperty("textOnly");
    }

    protected boolean isToken() {
        return this.production.getBooleanProperty("token");
    }

    protected boolean isGeneric() {
        return Generifier.isGeneric(this.production);
    }

    protected boolean isList() {
        return AST.isList(this.production.type);
    }

    protected boolean isLeftRecursive() {
        return DirectLeftRecurser.isTransformable(this.production);
    }

    protected Production current() {
        return this.production;
    }

    protected boolean retainRepetitions() {
        return this.runtime.test("optimizeRepeated") && !this.isMemoized() || this.runtime.test("optionValued");
    }

    protected boolean retainOptions() {
        return this.runtime.test("optimizeOptional") || this.runtime.test("optionValued");
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        this.hasParseTree = module.hasAttribute(Constants.ATT_PARSE_TREE);
        for (int i = 0; i < module.productions.size(); ++i) {
            Production production = module.productions.get(i);
            this.analyzer.startAdding();
            this.analyzer.process(production);
            i += this.analyzer.addNewProductionsAt(i + 1);
        }
    }

    public void visit(FullProduction fullProduction) {
        this.process(fullProduction);
    }

    public class Typer
    extends Visitor {
        protected List<Element> elements;
        protected Type type;

        public void visit(Production production) {
            if (Analyzer.isSynthetic(production.name) && AST.isAny(production.type)) {
                this.elements = new ArrayList<Element>();
                this.type = Wildcard.TYPE;
                this.dispatch(production.choice);
                if (!this.type.isWildcard() && !AST.isAny(this.type)) {
                    if (Transformer.this.runtime.test("optionVerbose")) {
                        System.err.println("[Adjusting " + production.qName + "'s type to " + Transformer.this.ast.extern(this.type) + ']');
                    }
                    production.type = Transformer.this.ast.concretize(this.type, AST.ANY);
                }
            }
        }

        public void visit(OrderedChoice orderedChoice) {
            for (Sequence sequence : orderedChoice.alternatives) {
                this.dispatch(sequence);
            }
        }

        public void visit(Sequence sequence) {
            int n = this.elements.size();
            Object object = sequence.elements.iterator();
            while (object.hasNext()) {
                Element element = object.next();
                if (!object.hasNext() && element instanceof OrderedChoice) {
                    this.dispatch(element);
                    continue;
                }
                this.elements.add(element);
            }
            if (!sequence.hasTrailingChoice()) {
                object = Analyzer.getBinding(this.elements);
                if (null != object && ("yyValue".equals(((Binding)object).name) || 0 != sequence.size() && sequence.get(sequence.size() - 1) instanceof BindingValue && ((Binding)object).name.equals(((BindingValue)sequence.get((int)(sequence.size() - 1))).binding.name))) {
                    this.type = Transformer.this.ast.unify(this.type, Transformer.this.analyzer.type(((Binding)object).element), false);
                } else if (!Analyzer.setsNullValue(this.elements)) {
                    this.type = AST.ANY;
                }
            }
            if (0 == n) {
                this.elements.clear();
            } else {
                this.elements.subList(n, this.elements.size()).clear();
            }
        }
    }

    public class Desugarer
    extends Visitor {
        protected void process(Sequence sequence, NonTerminal nonTerminal) {
            if (sequence.hasTrailingChoice()) {
                OrderedChoice orderedChoice = (OrderedChoice)sequence.get(sequence.size() - 1);
                for (Sequence sequence2 : orderedChoice.alternatives) {
                    this.process(sequence2, nonTerminal);
                }
            } else {
                if (null != nonTerminal) {
                    sequence.add(nonTerminal);
                }
                if (Transformer.this.isVoid()) {
                    sequence.add(NullValue.VALUE);
                } else if (Transformer.this.isTextOnly()) {
                    sequence.add(StringValue.VALUE);
                } else if (Transformer.this.isToken()) {
                    sequence.add(TokenValue.VALUE);
                } else assert (false);
            }
        }

        public void visit(Production production) {
            Element element = Analyzer.strip(production.choice);
            if (element instanceof Repetition && !Transformer.this.retainRepetitions()) {
                Binding binding;
                Sequence sequence;
                if (Transformer.this.runtime.test("optionVerbose")) {
                    System.err.println("[Desugaring repetition in " + production.qName + ']');
                }
                if (!(sequence = (Sequence)((Repetition)element).element).hasTrailingChoice() && null != (binding = Analyzer.getBinding(sequence.elements)) && binding.element instanceof NonTerminal) {
                    production.setProperty("repeated", binding.element);
                }
                production.choice = (OrderedChoice)this.dispatch(element);
            } else if (element instanceof Option && !Transformer.this.retainOptions()) {
                if (Transformer.this.runtime.test("optionVerbose")) {
                    System.err.println("[Desugaring option in " + production.qName + ']');
                }
                production.choice = (OrderedChoice)this.dispatch(element);
                production.setProperty("option", Boolean.TRUE);
            }
        }

        /*
         * WARNING - void declaration
         */
        public Element visit(Repetition repetition) {
            Binding binding;
            List<Object> list;
            Sequence sequence = (Sequence)repetition.element;
            if (1 == sequence.size() && sequence.hasTrailingChoice()) {
                list = ((OrderedChoice)sequence.get((int)0)).alternatives;
            } else {
                list = new ArrayList<Sequence>(1);
                list.add(sequence);
            }
            ArrayList<Sequence> arrayList = new ArrayList<Sequence>(list.size() + (repetition.once ? list.size() : 1));
            Type type2 = Wildcard.TYPE;
            if (!(Transformer.this.isVoid() || Transformer.this.isTextOnly() || Transformer.this.isToken())) {
                for (Sequence sequence2 : list) {
                    binding = Analyzer.getBinding(sequence2.elements);
                    if (null == binding) {
                        Transformer.this.runtime.error("unable to bind repeated element", sequence2);
                        continue;
                    }
                    type2 = Transformer.this.ast.unify(type2, Transformer.this.analyzer.type(binding.element), false);
                }
                type2 = AST.listOf(Transformer.this.ast.concretize(type2, AST.ANY));
                if (Analyzer.isSynthetic(Transformer.this.current().name)) {
                    if (Transformer.this.runtime.test("optionVerbose")) {
                        System.err.println("[Adjusting " + Transformer.this.current().qName + "'s type to " + Transformer.this.ast.extern(type2) + ']');
                    }
                    Transformer.this.current().type = type2;
                }
            }
            for (Sequence sequence2 : list) {
                void var7_11;
                if (repetition.once) {
                    Sequence sequence3 = Transformer.this.analyzer.copy(sequence2);
                }
                if (Transformer.this.isVoid() || Transformer.this.isTextOnly() || Transformer.this.isToken()) {
                    this.process((Sequence)var7_11, Transformer.this.current().name);
                } else {
                    binding = Analyzer.getBinding(var7_11.elements);
                    Binding binding2 = new Binding(Transformer.this.analyzer.variable(), Transformer.this.current().name);
                    if (null != binding) {
                        var7_11.add(binding2).add(new ProperListValue(type2, binding, binding2));
                    }
                }
                arrayList.add((Sequence)var7_11);
            }
            if (repetition.once) {
                for (Sequence sequence4 : list) {
                    if (Transformer.this.isVoid() || Transformer.this.isTextOnly() || Transformer.this.isToken()) {
                        this.process(sequence4, null);
                    } else {
                        binding = Analyzer.getBinding(sequence4.elements);
                        if (null != binding) {
                            sequence4.add(new ProperListValue(type2, binding));
                        }
                    }
                    arrayList.add(sequence4);
                }
            } else {
                Sequence sequence3 = new Sequence();
                if (Transformer.this.isVoid()) {
                    sequence3.add(NullValue.VALUE);
                } else if (Transformer.this.isTextOnly()) {
                    sequence3.add(StringValue.VALUE);
                } else if (Transformer.this.isToken()) {
                    sequence3.add(TokenValue.VALUE);
                } else {
                    sequence3.add(EmptyListValue.VALUE);
                }
                arrayList.add(sequence3);
            }
            return new OrderedChoice(arrayList);
        }

        public Element visit(Option option) {
            List<Object> list;
            Sequence sequence = (Sequence)option.element;
            if (1 == sequence.size() && sequence.hasTrailingChoice()) {
                list = ((OrderedChoice)sequence.get((int)0)).alternatives;
            } else {
                list = new ArrayList<Sequence>(1);
                list.add(sequence);
            }
            ArrayList<Sequence> arrayList = new ArrayList<Sequence>(list.size() + 1);
            for (Sequence sequence2 : list) {
                if (Transformer.this.isVoid() || Transformer.this.isTextOnly() || Transformer.this.isToken()) {
                    this.process(sequence2, null);
                } else {
                    Binding binding = Analyzer.getBinding(sequence2.elements);
                    if (null != binding) {
                        binding.name = "yyValue";
                    }
                }
                arrayList.add(sequence2);
            }
            Sequence sequence3 = new Sequence();
            if (Transformer.this.isTextOnly()) {
                sequence3.add(StringValue.VALUE);
            } else if (Transformer.this.isToken()) {
                sequence3.add(TokenValue.VALUE);
            } else {
                sequence3.add(NullValue.VALUE);
            }
            arrayList.add(sequence3);
            return new OrderedChoice(arrayList);
        }
    }

    public class Lifter
    extends GrammarVisitor {
        public Lifter() {
            super(Transformer.this.runtime, Transformer.this.analyzer);
        }

        protected Binding bind(Element element) {
            return new Binding(this.analyzer.variable(Transformer.ELEMENT_MARKER), element);
        }

        protected Sequence process(Element element, boolean bl) {
            if (element instanceof OrderedChoice) {
                if (!Transformer.this.isTextOnly() && !Transformer.this.isToken() && (bl || Analyzer.setsValue(element, false))) {
                    return Sequence.ensure((Element)this.dispatch(this.bind(element)));
                }
                this.isLastElement = true;
                return Sequence.ensure((Element)this.dispatch(element));
            }
            Sequence sequence = Sequence.ensure(element);
            if (!Transformer.this.isTextOnly() && !Transformer.this.isToken() && Analyzer.setsValue(element, false)) {
                return Sequence.ensure((Element)this.dispatch(this.bind(new OrderedChoice(sequence))));
            }
            if (!Transformer.this.isTextOnly() && !Transformer.this.isToken() && bl && sequence.hasTrailingChoice()) {
                return Sequence.ensure((Element)this.dispatch(this.bind(new OrderedChoice(sequence))));
            }
            if (!Transformer.this.isTextOnly() && !Transformer.this.isToken() && bl) {
                Binding binding = this.analyzer.bind(sequence.elements, Transformer.ELEMENT_MARKER);
                if (null == binding) {
                    this.runtime.error("unable to deduce value", sequence);
                }
                return Sequence.ensure((Element)this.dispatch(sequence));
            }
            if (this.isPredicate && sequence.hasTrailingChoice()) {
                return Sequence.ensure((Element)this.dispatch(new OrderedChoice(sequence)));
            }
            this.isLastElement = true;
            return Sequence.ensure((Element)this.dispatch(sequence));
        }

        protected void lift(Type type2, NonTerminal nonTerminal, OrderedChoice orderedChoice) {
            FullProduction fullProduction = new FullProduction(new ArrayList<Attribute>(Transformer.this.current().attributes), type2, nonTerminal, nonTerminal.qualify(this.analyzer.module().name.name), orderedChoice);
            if (this.runtime.test("optionVerbose")) {
                System.err.println("[Lifting expression into new production " + fullProduction.qName + ']');
            }
            fullProduction.attributes.remove(Constants.ATT_STATEFUL);
            fullProduction.attributes.remove(Constants.ATT_RESETTING);
            if (Transformer.this.isTextOnly()) {
                TextTester.markTextOnly(fullProduction, this.runtime.test("optionVerbose"));
            } else if (Transformer.this.isToken()) {
                Tokenizer.markToken(fullProduction, this.runtime.test("optionVerbose"));
            }
            Transformer.this.process(fullProduction);
            this.analyzer.add(fullProduction);
        }

        public Element visit(OrderedChoice orderedChoice) {
            boolean bl = this.isTopLevel;
            this.isTopLevel = false;
            boolean bl2 = this.isVoided;
            this.isVoided = false;
            boolean bl3 = this.isBound;
            this.isBound = false;
            boolean bl4 = this.isLastElement;
            boolean bl5 = this.transformInPlace = bl && Analyzer.strip(orderedChoice) instanceof Quantification;
            if ((bl || bl4) && !this.isPredicate) {
                int n = orderedChoice.alternatives.size();
                for (int i = 0; i < n; ++i) {
                    this.isLastElement = bl || bl4;
                    orderedChoice.alternatives.set(i, (Sequence)this.dispatch(orderedChoice.alternatives.get(i)));
                }
                this.isLastElement = false;
                return orderedChoice;
            }
            NonTerminal nonTerminal = this.analyzer.choice();
            Type type2 = Transformer.this.isTextOnly() ? AST.STRING : (Transformer.this.isToken() ? AST.TOKEN : (bl3 || (Transformer.this.isGeneric() || Transformer.this.isList()) && !bl2 && !this.isPredicate ? AST.ANY : AST.VOID));
            this.lift(type2, nonTerminal, orderedChoice);
            this.isLastElement = false;
            return nonTerminal;
        }

        public Element visit(Repetition repetition) {
            NonTerminal nonTerminal;
            this.isTopLevel = false;
            boolean bl = this.isVoided;
            this.isVoided = false;
            boolean bl2 = this.isBound;
            this.isBound = false;
            this.isLastElement = false;
            boolean bl3 = this.transformInPlace;
            this.transformInPlace = false;
            if (Transformer.this.retainRepetitions() && (!bl2 || !Transformer.this.isTextOnly() && !Transformer.this.isToken()) || bl3 && (!Transformer.this.isGeneric() || Transformer.this.retainRepetitions())) {
                boolean bl4 = bl2 || Transformer.this.isGeneric() && !bl && !this.isPredicate || Transformer.this.isList() && !bl && !this.isPredicate || bl3 && !Transformer.this.isVoid();
                repetition.element = this.process(repetition.element, bl4);
                return repetition;
            }
            NonTerminal nonTerminal2 = nonTerminal = repetition.once ? this.analyzer.plus() : this.analyzer.star();
            Type type2 = Transformer.this.isTextOnly() ? AST.STRING : (Transformer.this.isToken() ? AST.TOKEN : (bl2 || (Transformer.this.isGeneric() || Transformer.this.isList()) && !bl && !this.isPredicate ? AST.WILD_LIST : AST.VOID));
            OrderedChoice orderedChoice = new OrderedChoice(repetition);
            orderedChoice.setLocation(repetition);
            this.lift(type2, nonTerminal, orderedChoice);
            return nonTerminal;
        }

        public Element visit(Option option) {
            this.isTopLevel = false;
            boolean bl = this.isVoided;
            this.isVoided = false;
            boolean bl2 = this.isBound;
            this.isBound = false;
            this.isLastElement = false;
            boolean bl3 = this.transformInPlace;
            this.transformInPlace = false;
            if (Transformer.this.retainOptions() && (!bl2 || !Transformer.this.isTextOnly() && !Transformer.this.isToken()) || bl3 && (!Transformer.this.isGeneric() || Transformer.this.retainOptions())) {
                boolean bl4 = bl2 || Transformer.this.isGeneric() && !bl && !this.isPredicate || Transformer.this.isList() && !bl && !this.isPredicate || bl3 && !Transformer.this.isVoid();
                option.element = this.process(option.element, bl4);
                return option;
            }
            NonTerminal nonTerminal = this.analyzer.option();
            Type type2 = Transformer.this.isTextOnly() ? AST.STRING : (Transformer.this.isToken() ? AST.TOKEN : (bl2 || (Transformer.this.isGeneric() || Transformer.this.isList()) && !bl && !this.isPredicate ? AST.ANY : AST.VOID));
            OrderedChoice orderedChoice = new OrderedChoice(option);
            orderedChoice.setLocation(option);
            this.lift(type2, nonTerminal, orderedChoice);
            return nonTerminal;
        }

        public Element visit(Predicate predicate) {
            this.isTopLevel = false;
            this.isVoided = false;
            this.isBound = false;
            this.isLastElement = false;
            boolean bl = this.isPredicate;
            this.isPredicate = true;
            predicate.element = this.process(predicate.element, false);
            this.isPredicate = bl;
            return predicate;
        }
    }

    public class Deducer
    extends Visitor {
        protected List<Element> elements;

        public void visit(Production production) {
            Element element = Analyzer.strip(production.choice);
            if (!(Transformer.this.isGeneric() || Transformer.this.isList() || Transformer.this.isLeftRecursive() || element instanceof Repetition && !Transformer.this.retainRepetitions() || element instanceof Option && !Transformer.this.retainOptions())) {
                if (Transformer.this.runtime.test("optionVerbose")) {
                    System.err.println("[Deducing semantic value for " + production.qName + "]");
                }
                this.elements = new ArrayList<Element>();
                this.dispatch(production.choice);
            }
        }

        public void visit(OrderedChoice orderedChoice) {
            for (Sequence sequence : orderedChoice.alternatives) {
                this.dispatch(sequence);
            }
        }

        public void visit(Sequence sequence) {
            int n = this.elements.size();
            Object object = sequence.elements.iterator();
            while (object.hasNext()) {
                Element element = object.next();
                if (!object.hasNext() && element instanceof OrderedChoice) {
                    this.dispatch(element);
                    continue;
                }
                this.elements.add(element);
            }
            if (!sequence.hasTrailingChoice()) {
                if (Transformer.this.isVoid()) {
                    sequence.add(NullValue.VALUE);
                } else if (Transformer.this.isTextOnly()) {
                    object = Transformer.this.analyzer.matchingText(new Sequence(this.elements));
                    if (null == object || !Transformer.this.runtime.test("optimizeTerminals")) {
                        sequence.add(StringValue.VALUE);
                    } else {
                        sequence.add(new StringValue((String)object));
                    }
                } else if (Transformer.this.isToken()) {
                    object = Transformer.this.analyzer.matchingText(new Sequence(this.elements));
                    if (null == object || !Transformer.this.runtime.test("optimizeTerminals")) {
                        sequence.add(TokenValue.VALUE);
                    } else {
                        sequence.add(new TokenValue((String)object));
                    }
                } else if (this.elements.isEmpty()) {
                    sequence.add(NullValue.VALUE);
                } else {
                    object = Transformer.this.analyzer.bind(this.elements);
                    if (null != object) {
                        if (Analyzer.isSynthetic(((Binding)object).name)) {
                            ((Binding)object).name = "yyValue";
                        } else if (!"yyValue".equals(((Binding)object).name)) {
                            sequence.add(new BindingValue((Binding)object));
                        }
                    }
                }
            }
            if (!(Transformer.this.isVoid() || Transformer.this.isTextOnly() || Transformer.this.isToken())) {
                int n2 = sequence.size();
                if (sequence.hasTrailingChoice() || 0 != n2 && sequence.get(n2 - 1) instanceof ValueElement) {
                    --n2;
                }
                for (int i = 0; i < n2; ++i) {
                    Element element = this.elements.get(n + i);
                    if (sequence.get(i) == element) continue;
                    sequence.elements.set(i, element);
                }
            }
            if (0 == n) {
                this.elements.clear();
            } else {
                this.elements.subList(n, this.elements.size()).clear();
            }
        }
    }
}

