/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GrammarVisitor;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NullLiteral;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.Terminal;
import xtc.parser.UnaryOperator;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.util.Runtime;

public class Tokenizer
extends GrammarVisitor {
    public Tokenizer(Runtime runtime, Analyzer analyzer) {
        super(runtime, analyzer);
    }

    public Object visit(Module module) {
        ArrayList<FullProduction> arrayList;
        new Tester(this.runtime, this.analyzer).dispatch(module);
        this.analyzer.register(this);
        this.analyzer.init(module);
        for (Production object : module.productions) {
            if (!object.getBooleanProperty("lexical") && !AST.isVoid(object.type)) continue;
            this.analyzer.notWorkingOnAny();
            this.analyzer.consumesInput(object.qName);
        }
        if (module.hasProperty("root")) {
            arrayList = new ArrayList<FullProduction>(1);
            arrayList.add(this.analyzer.lookup((NonTerminal)module.getProperty("root")));
        } else {
            arrayList = module.productions;
        }
        for (Production production : arrayList) {
            if (this.analyzer.isProcessed(production.qName) || !production.hasAttribute(Constants.ATT_PUBLIC)) continue;
            this.analyzer.processed(production.qName);
            if (production.getBooleanProperty("lexical")) {
                this.analyzer.notWorkingOnAny();
                if (!this.analyzer.consumesInput(production.qName)) continue;
                Tokenizer.markToken(production, this.runtime.test("optionVerbose"));
                continue;
            }
            this.analyzer.process(production);
        }
        return null;
    }

    public Element visit(NonTerminal nonTerminal) {
        FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
        if (!this.analyzer.isProcessed(fullProduction.qName)) {
            this.analyzer.processed(fullProduction.qName);
            if (fullProduction.getBooleanProperty("lexical")) {
                if (this.analyzer.consumesInput(nonTerminal)) {
                    Tokenizer.markToken(fullProduction, this.runtime.test("optionVerbose"));
                }
            } else {
                this.dispatch(fullProduction);
            }
        }
        return nonTerminal;
    }

    public static void markToken(Production production, boolean bl) {
        if (bl) {
            System.err.println("[Recognizing " + production.qName + " as token-level]");
        }
        production.setProperty("token", Boolean.TRUE);
        production.removeProperty("textOnly");
    }

    public static class Tester
    extends Visitor {
        protected final Runtime runtime;
        protected final Analyzer analyzer;
        protected boolean isLexical;

        public Tester(Runtime runtime, Analyzer analyzer) {
            this.runtime = runtime;
            this.analyzer = analyzer;
        }

        protected void mark(Production production) {
            if (this.runtime.test("optionVerbose")) {
                System.err.println("[Recognizing " + production.qName + " as lexical syntax]");
            }
            production.setProperty("lexical", Boolean.TRUE);
        }

        public void visit(Module module) {
            this.analyzer.register(this);
            this.analyzer.init(module);
            for (Production production : module.productions) {
                if (this.analyzer.isProcessed(production.qName)) continue;
                if (production.getBooleanProperty("textOnly")) {
                    this.mark(production);
                    this.analyzer.processed(production.qName);
                    continue;
                }
                if (!AST.isVoid(production.type)) {
                    this.analyzer.processed(production.qName);
                    continue;
                }
                this.isLexical = true;
                this.analyzer.process(production);
                if (this.isLexical) {
                    for (NonTerminal nonTerminal : this.analyzer.working()) {
                        FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
                        this.mark(fullProduction);
                        this.analyzer.processed(fullProduction.qName);
                    }
                    continue;
                }
                this.analyzer.processed(production.qName);
            }
        }

        public void visit(Production production) {
            Object object = this.analyzer.enter(production);
            this.analyzer.workingOn(production.qName);
            this.dispatch(production.choice);
            this.analyzer.exit(object);
        }

        public void visit(OrderedChoice orderedChoice) {
            for (Sequence sequence : orderedChoice.alternatives) {
                this.dispatch(sequence);
                if (this.isLexical) continue;
                return;
            }
        }

        public void visit(Sequence sequence) {
            for (Element element : sequence.elements) {
                this.dispatch(element);
                if (this.isLexical) continue;
                return;
            }
        }

        public void visit(SemanticPredicate semanticPredicate) {
        }

        public void visit(Binding binding) {
            if ("yyValue".equals(binding.name)) {
                this.isLexical = false;
            } else {
                this.dispatch(binding.element);
            }
        }

        public void visit(NonTerminal nonTerminal) {
            FullProduction fullProduction;
            try {
                fullProduction = this.analyzer.lookup(nonTerminal);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.isLexical = false;
                return;
            }
            if (null == fullProduction) {
                this.isLexical = false;
            } else if (this.analyzer.isProcessed(fullProduction.qName)) {
                if (!fullProduction.getBooleanProperty("lexical")) {
                    this.isLexical = false;
                }
            } else if (!this.analyzer.isBeingWorkedOn(fullProduction.qName) && !fullProduction.getBooleanProperty("textOnly")) {
                if (AST.isVoid(fullProduction.type)) {
                    this.dispatch(fullProduction);
                } else {
                    this.isLexical = false;
                }
            }
        }

        public void visit(CharCase charCase) {
            this.dispatch(charCase.element);
        }

        public void visit(CharSwitch charSwitch) {
            for (CharCase charCase : charSwitch.cases) {
                this.dispatch(charCase);
                if (this.isLexical) continue;
                return;
            }
            this.dispatch(charSwitch.base);
        }

        public void visit(Terminal terminal) {
        }

        public void visit(UnaryOperator unaryOperator) {
            this.dispatch(unaryOperator.element);
        }

        public void visit(NullLiteral nullLiteral) {
        }

        public void visit(NodeMarker nodeMarker) {
            this.isLexical = false;
        }

        public void visit(Action action) {
            if (action.setsValue()) {
                this.isLexical = false;
            }
        }

        public void visit(ParserAction parserAction) {
            this.isLexical = false;
        }

        public void visit(Element element) {
            this.isLexical = false;
        }
    }
}

