/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NullLiteral;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.Terminal;
import xtc.parser.UnaryOperator;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.util.Runtime;

public class TextTester
extends Visitor {
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected boolean isTextOnly;

    public TextTester(Runtime runtime, Analyzer analyzer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
    }

    public void visit(Grammar grammar) {
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        for (Module module : grammar.modules) {
            this.analyzer.process(module);
            for (Production production : module.productions) {
                if (!production.isFull() || this.analyzer.isProcessed(production.qName)) continue;
                if (!AST.isString(production.type)) {
                    this.analyzer.processed(production.qName);
                    continue;
                }
                this.isTextOnly = true;
                this.analyzer.process(production);
                if (this.isTextOnly) {
                    for (NonTerminal nonTerminal : this.analyzer.working()) {
                        FullProduction fullProduction = this.analyzer.lookupGlobally(nonTerminal);
                        TextTester.markTextOnly(fullProduction, this.runtime.test("optionVerbose"));
                        this.analyzer.processed(fullProduction.qName);
                    }
                    continue;
                }
                this.analyzer.processed(production.qName);
            }
        }
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        for (Production production : module.productions) {
            if (this.analyzer.isProcessed(production.qName)) continue;
            if (!AST.isString(production.type)) {
                this.analyzer.processed(production.qName);
                continue;
            }
            this.isTextOnly = true;
            this.analyzer.process(production);
            if (this.isTextOnly) {
                for (NonTerminal nonTerminal : this.analyzer.working()) {
                    FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
                    TextTester.markTextOnly(fullProduction, this.runtime.test("optionVerbose"));
                    this.analyzer.processed(fullProduction.qName);
                }
                continue;
            }
            this.analyzer.processed(production.qName);
        }
    }

    public void visit(Production production) {
        Object object = this.analyzer.enter(production);
        this.analyzer.workingOn(production.qName);
        this.dispatch(production.choice);
        this.analyzer.exit(object);
    }

    public void visit(OrderedChoice orderedChoice) {
        for (Sequence sequence : orderedChoice.alternatives) {
            this.dispatch(sequence);
            if (this.isTextOnly) continue;
            return;
        }
    }

    public void visit(Sequence sequence) {
        for (Element element : sequence.elements) {
            this.dispatch(element);
            if (this.isTextOnly) continue;
            return;
        }
    }

    public void visit(SemanticPredicate semanticPredicate) {
    }

    public void visit(Binding binding) {
        if ("yyValue".equals(binding.name)) {
            this.isTextOnly = false;
        } else {
            this.dispatch(binding.element);
        }
    }

    public void visit(NonTerminal nonTerminal) {
        FullProduction fullProduction;
        try {
            fullProduction = this.analyzer.lookup(nonTerminal);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.isTextOnly = false;
            return;
        }
        if (null == fullProduction) {
            this.isTextOnly = false;
        } else if (this.analyzer.isProcessed(fullProduction.qName)) {
            if (!fullProduction.getBooleanProperty("textOnly")) {
                this.isTextOnly = false;
            }
        } else if (!this.analyzer.isBeingWorkedOn(fullProduction.qName)) {
            if (AST.isString(fullProduction.type)) {
                this.dispatch(fullProduction);
            } else {
                this.isTextOnly = false;
            }
        }
    }

    public void visit(CharCase charCase) {
        this.dispatch(charCase.element);
    }

    public void visit(CharSwitch charSwitch) {
        for (CharCase charCase : charSwitch.cases) {
            this.dispatch(charCase);
            if (this.isTextOnly) continue;
            return;
        }
        this.dispatch(charSwitch.base);
    }

    public void visit(Terminal terminal) {
    }

    public void visit(UnaryOperator unaryOperator) {
        this.dispatch(unaryOperator.element);
    }

    public void visit(NullLiteral nullLiteral) {
    }

    public void visit(NodeMarker nodeMarker) {
        this.isTextOnly = false;
    }

    public void visit(Action action) {
        if (action.setsValue()) {
            this.isTextOnly = false;
        }
    }

    public void visit(ParserAction parserAction) {
        this.isTextOnly = false;
    }

    public void visit(Element element) {
        this.isTextOnly = false;
    }

    public static void markTextOnly(Production production, boolean bl) {
        if (bl) {
            System.err.println("[Recognizing " + production.qName + " as text-only]");
        }
        production.setProperty("textOnly", Boolean.TRUE);
    }
}

