/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import xtc.parser.Element;
import xtc.parser.OrderedChoice;
import xtc.parser.SequenceName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sequence
extends Element {
    public SequenceName name;
    public List<Element> elements;

    public Sequence() {
        this(null, new ArrayList<Element>());
    }

    public Sequence(int n) {
        this(null, new ArrayList<Element>(n));
    }

    public Sequence(List<Element> list) {
        this(null, list);
    }

    public Sequence(SequenceName sequenceName, List<Element> list) {
        this.name = sequenceName;
        this.elements = list;
    }

    public Sequence(Element element) {
        if (element instanceof Sequence) {
            Sequence sequence = (Sequence)element;
            this.elements = new ArrayList<Element>(sequence.elements);
            this.name = sequence.name;
        } else {
            this.elements = new ArrayList<Element>(1);
            this.elements.add(element);
        }
        this.setLocation(element);
    }

    @Override
    public Element.Tag tag() {
        return Element.Tag.SEQUENCE;
    }

    public Sequence clear() {
        this.elements.clear();
        return this;
    }

    public Sequence add(Element element) {
        this.elements.add(element);
        return this;
    }

    public Sequence addAll(List<Element> list) {
        this.elements.addAll(list);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Element get(int n) {
        return this.elements.get(n);
    }

    public boolean hasTrailingChoice() {
        int n = this.elements.size();
        return 0 < n && this.elements.get(n - 1) instanceof OrderedChoice;
    }

    public Sequence subSequence(int n) {
        return this.subSequence(n, this.elements.size());
    }

    public Sequence subSequence(int n, int n2) {
        Sequence sequence = new Sequence(new ArrayList<Element>(this.elements.subList(n, n2)));
        sequence.setLocation(this);
        return sequence;
    }

    public int hashCode() {
        return ((Object)this.elements).hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Sequence)) {
            return false;
        }
        return ((Object)this.elements).equals(((Sequence)object).elements);
    }

    @Override
    public void write(Appendable appendable) throws IOException {
        appendable.append('(');
        boolean bl = true;
        for (Element element : this.elements) {
            if (bl) {
                bl = false;
            } else {
                appendable.append(' ');
            }
            element.write(appendable);
        }
        appendable.append(')');
    }

    public static Sequence ensure(Element element) {
        if (element instanceof Sequence) {
            return (Sequence)element;
        }
        Sequence sequence = new Sequence(element);
        sequence.setLocation(element);
        return sequence;
    }
}

