/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.AlternativeAddition;
import xtc.parser.AlternativeRemoval;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CharClass;
import xtc.parser.CharRange;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.HtmlPrinter;
import xtc.parser.InternalElement;
import xtc.parser.LeftRecurser;
import xtc.parser.Module;
import xtc.parser.ModuleDependency;
import xtc.parser.ModuleImport;
import xtc.parser.ModuleMap;
import xtc.parser.ModuleModification;
import xtc.parser.ModuleName;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NullLiteral;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.PParser;
import xtc.parser.ParseException;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.PrettyPrinter;
import xtc.parser.Production;
import xtc.parser.ProductionOverride;
import xtc.parser.ReachabilityChecker;
import xtc.parser.Renamer;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.SequenceName;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.TextTester;
import xtc.parser.UnaryOperator;
import xtc.parser.VoidedElement;
import xtc.tree.Attribute;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.ErrorT;
import xtc.util.Runtime;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolver
extends Visitor {
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected int phase;
    protected Map<NonTerminal, NonTerminal> badNTs;
    protected boolean hasState;
    protected boolean isMofunctor;
    protected boolean isPredicate;
    protected Set<SequenceName> sequenceNames;
    private final Visitor checkRepetitionsVisitor = new Visitor(){

        public void visit(Repetition repetition) {
            this.dispatch(repetition.element);
            if (Resolver.this.analyzer.matchesEmpty(repetition.element) && !(Analyzer.strip(repetition.element) instanceof Action)) {
                Resolver.this.runtime.error("repeated element matches empty input", repetition);
            }
        }

        public void visit(Option option) {
            this.dispatch(option.element);
            if (!(Resolver.this.analyzer.restrictsInput(option.element) || Analyzer.strip(option.element) instanceof Action || Resolver.this.analyzer.grammar().modules.get(0).hasAttribute(Constants.ATT_NO_WARNINGS) || Resolver.this.analyzer.current().hasAttribute(Constants.ATT_NO_WARNINGS))) {
                Resolver.this.runtime.warning("optional element already matches empty input", option);
            }
        }

        public void visit(Production production) {
            this.dispatch(production.choice);
        }

        public void visit(OrderedChoice orderedChoice) {
            for (Sequence sequence : orderedChoice.alternatives) {
                this.dispatch(sequence);
            }
        }

        public void visit(Sequence sequence) {
            for (Element element : sequence.elements) {
                this.dispatch(element);
            }
        }

        public void visit(UnaryOperator unaryOperator) {
            this.dispatch(unaryOperator.element);
        }

        public void visit(Element element) {
        }
    };

    public Resolver(Runtime runtime, Analyzer analyzer, AST aST) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = aST;
        this.badNTs = new IdentityHashMap<NonTerminal, NonTerminal>();
        this.sequenceNames = new HashSet<SequenceName>();
    }

    protected void signature(Module module) {
        System.out.print("module ");
        System.out.print(module.name.name);
        if (module.name.hasProperty("xtc.Constants.Original") || null != module.parameters) {
            System.out.print(" = ");
            ModuleName moduleName = module.name.hasProperty("xtc.Constants.Original") ? (ModuleName)module.name.getProperty("xtc.Constants.Original") : module.name;
            System.out.print(moduleName.name);
            if (null == module.parameters) {
                System.out.print("()");
            } else {
                System.out.print(module.parameters.toString());
            }
        }
        if (null != module.dependencies) {
            for (ModuleDependency object : module.dependencies) {
                if (!object.isModification()) continue;
                System.out.println();
                System.out.print("       modifies ");
                System.out.print(object.visibleName().name);
                break;
            }
            boolean bl = true;
            for (ModuleDependency moduleDependency : module.dependencies) {
                if (!moduleDependency.isImport()) continue;
                if (bl) {
                    System.out.println();
                    System.out.print("       imports ");
                    bl = false;
                } else {
                    System.out.println(',');
                    System.out.print("               ");
                }
                System.out.print(moduleDependency.visibleName().name);
            }
        }
        System.out.println(';');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Module load(String string) throws IOException, ParseException {
        File file = this.runtime.locate(Utilities.toPath(string, "rats"));
        if (!file.exists()) {
            throw new FileNotFoundException(file + ": file not found");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(file + ": not a file");
        }
        if (Integer.MAX_VALUE < file.length()) {
            throw new IllegalArgumentException(file + ": file too large");
        }
        Reader reader = null;
        try {
            reader = this.runtime.getReader(file);
            PParser pParser = new PParser(reader, file.toString(), (int)file.length());
            Module module = (Module)pParser.value(pParser.pModule(0));
            return module;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void rename(Module module, ModuleMap moduleMap) {
        module.name = module.name.rename(moduleMap);
        if (null != module.parameters) {
            module.parameters.rename(moduleMap);
        }
        if (null != module.dependencies) {
            for (ModuleDependency object : module.dependencies) {
                object.rename(moduleMap);
            }
        }
        Renamer renamer = new Renamer(this.runtime, this.analyzer, moduleMap);
        for (Production production : module.productions) {
            if (null != production.qName) {
                production.qName = production.qName.rename(moduleMap);
            }
            renamer.dispatch(production);
        }
    }

    protected Production strip(Production production) {
        if (null != production && null != production.choice) {
            production.choice = Analyzer.stripChoices(production.choice);
        }
        return production;
    }

    protected void apply(AlternativeAddition alternativeAddition, FullProduction fullProduction) {
        int n = fullProduction.choice.alternatives.size();
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (!alternativeAddition.sequence.equals(fullProduction.choice.alternatives.get((int)i).name)) continue;
            n2 = i;
            break;
        }
        if (-1 == n2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("unable to add new alternative");
            if (1 != alternativeAddition.choice.alternatives.size()) {
                stringBuilder.append('s');
            }
            if (alternativeAddition.isBefore) {
                stringBuilder.append(" before ");
            } else {
                stringBuilder.append(" after ");
            }
            stringBuilder.append("non-existent alternative '");
            stringBuilder.append(alternativeAddition.sequence.name);
            stringBuilder.append("'");
            this.runtime.error(stringBuilder.toString(), alternativeAddition.sequence);
        } else {
            if (!alternativeAddition.isBefore) {
                ++n2;
            }
            fullProduction.choice.alternatives.addAll(n2, alternativeAddition.choice.alternatives);
        }
    }

    protected void apply(AlternativeRemoval alternativeRemoval, FullProduction fullProduction) {
        for (SequenceName sequenceName : alternativeRemoval.sequences) {
            boolean bl = false;
            Iterator<Sequence> iterator = fullProduction.choice.alternatives.iterator();
            while (iterator.hasNext()) {
                if (!sequenceName.equals(iterator.next().name)) continue;
                iterator.remove();
                bl = true;
                break;
            }
            if (bl) continue;
            this.runtime.error("unable to remove non-existent alternative '" + sequenceName + "'", sequenceName);
        }
    }

    protected void apply(ProductionOverride productionOverride, FullProduction fullProduction) {
        if (null != productionOverride.attributes) {
            fullProduction.attributes = productionOverride.attributes;
        }
        if (null != productionOverride.choice) {
            if (productionOverride.isComplete) {
                fullProduction.choice = productionOverride.choice;
            } else {
                for (Sequence sequence : productionOverride.choice.alternatives) {
                    if (null == sequence.name) {
                        this.runtime.error("overriding sequence without name", sequence);
                        continue;
                    }
                    int n = fullProduction.choice.alternatives.size();
                    boolean bl = false;
                    for (int i = 0; i < n; ++i) {
                        Sequence sequence2 = fullProduction.choice.alternatives.get(i);
                        if (!sequence.name.equals(sequence2.name)) continue;
                        fullProduction.choice.alternatives.set(i, sequence);
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    this.runtime.error("unable to override non-existent alternative '" + sequence.name + "'", sequence);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected Grammar load(Module module) {
        Object object;
        if (null != module.parameters && 0 < module.parameters.size()) {
            this.runtime.error("parameterized top-level module '" + module.name.name + "'", module.name);
            return null;
        }
        PrettyPrinter prettyPrinter = null;
        if (this.runtime.test("optionLoaded")) {
            prettyPrinter = new PrettyPrinter(this.runtime.console(), this.ast, true);
            prettyPrinter.dispatch(module);
            prettyPrinter.flush();
        }
        ArrayList<Module> arrayList = new ArrayList<Module>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<ModuleName, Object> hashMap2 = new HashMap<ModuleName, Object>();
        IdentityHashMap<ModuleDependency, Boolean> identityHashMap = new IdentityHashMap<ModuleDependency, Boolean>();
        arrayList.add(module);
        hashMap.put(module.name.name, module);
        hashMap2.put(module.name, new ModuleImport(module.name));
        ArrayList<ModuleDependency> arrayList2 = new ArrayList<ModuleDependency>();
        if (null != module.dependencies) {
            for (ModuleDependency object22 : module.dependencies) {
                if (object22.isModification()) {
                    boolean grammar = true;
                    if (null != module.modification) {
                        this.runtime.error("duplicate modifies declaration", object22);
                        grammar = false;
                    }
                    if (object22.visibleName().equals(module.name)) {
                        this.runtime.error("module '" + module.name + "' modifies itself", object22);
                        grammar = false;
                    }
                    if (!grammar) continue;
                    module.modification = (ModuleModification)object22;
                    arrayList2.add(object22);
                    continue;
                }
                arrayList2.add(object22);
            }
        }
        if (this.runtime.test("optionDependencies")) {
            this.signature(module);
        }
        while (!arrayList2.isEmpty()) {
            int n;
            int n2;
            void var9_16;
            object = (ModuleDependency)arrayList2.remove(0);
            if (hashMap2.containsKey(((ModuleDependency)object).visibleName())) {
                ModuleDependency moduleDependency = (ModuleDependency)hashMap2.get(((ModuleDependency)object).visibleName());
                if (((ModuleDependency)object).isConsistentWith(moduleDependency)) continue;
                if (!identityHashMap.containsKey(moduleDependency)) {
                    identityHashMap.put(moduleDependency, Boolean.TRUE);
                    this.runtime.error("inconsistent instantiation of module '" + moduleDependency.module + moduleDependency.arguments + "' as '" + moduleDependency.visibleName() + "'", moduleDependency);
                }
                this.runtime.error("inconsistent instantiation of module '" + ((ModuleDependency)object).module + ((ModuleDependency)object).arguments + "' as '" + ((ModuleDependency)object).visibleName() + "'", (Node)object);
                continue;
            }
            if (this.runtime.test("optionVerbose")) {
                String string = Utilities.toPath(((ModuleDependency)object).module.name, "rats");
                File file = null;
                try {
                    file = this.runtime.locate(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (null == file) {
                    System.err.println("[Loading module " + ((ModuleDependency)object).module + "]");
                } else {
                    System.err.println("[Loading module " + ((ModuleDependency)object).module + " from " + file + "]");
                }
            }
            Object var9_14 = null;
            try {
                Module module2 = this.load(((ModuleDependency)object).module.name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.runtime.error(illegalArgumentException.getMessage(), (Node)object);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.runtime.error(fileNotFoundException.getMessage(), (Node)object);
            }
            catch (IOException iOException) {
                if (null == iOException.getMessage()) {
                    this.runtime.error("I/O error while accessing corresponding file", (Node)object);
                } else {
                    this.runtime.error(iOException.getMessage(), (Node)object);
                }
            }
            catch (ParseException parseException) {
                System.err.print(parseException.getMessage());
                this.runtime.error();
            }
            hashMap2.put(((ModuleDependency)object).visibleName(), object);
            if (null == var9_16) continue;
            if (this.runtime.test("optionLoaded")) {
                prettyPrinter.dispatch((Node)var9_16);
                prettyPrinter.flush();
            }
            boolean bl = false;
            if (!((ModuleDependency)object).module.equals(var9_16.name)) {
                String string = Utilities.toPath(((ModuleDependency)object).module.name, "rats");
                File file = null;
                try {
                    file = this.runtime.locate(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (null == file) {
                    this.runtime.error("module name '" + var9_16.name + "' inconsistent with file name", var9_16.name);
                    bl = true;
                } else {
                    this.runtime.error("module name '" + var9_16.name + "' inconsistent with file name " + file, var9_16.name);
                    bl = true;
                }
            }
            if (null != var9_16.parameters) {
                int n3 = var9_16.parameters.size();
                block11: for (int i = 0; i < n3; ++i) {
                    ModuleName moduleName = var9_16.parameters.get(i);
                    if (var9_16.name.equals(moduleName)) {
                        this.runtime.error("module parameter '" + moduleName + "' same as module name", moduleName);
                        bl = true;
                    }
                    for (n2 = 0; n2 < i; ++n2) {
                        if (!moduleName.equals(var9_16.parameters.get(n2))) continue;
                        this.runtime.error("duplicate module parameter '" + moduleName + "'", moduleName);
                        bl = true;
                        continue block11;
                    }
                }
            }
            int n4 = ((ModuleDependency)object).arguments.size();
            int n5 = n = null != var9_16.parameters ? var9_16.parameters.size() : 0;
            if (n4 != n) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(n4);
                stringBuilder.append(" argument");
                if (1 != n4) {
                    stringBuilder.append('s');
                }
                stringBuilder.append(" for module '");
                stringBuilder.append(var9_16.name.name);
                stringBuilder.append("' with ");
                stringBuilder.append(n);
                stringBuilder.append(" parameter");
                if (1 != n) {
                    stringBuilder.append('s');
                }
                this.runtime.error(stringBuilder.toString(), (Node)object);
                bl = true;
            }
            if (bl) continue;
            if (0 != n4 || !((ModuleDependency)object).module.equals(((ModuleDependency)object).visibleName())) {
                void var13_45;
                if (this.runtime.test("optionVerbose")) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("[Instantiating module ");
                    stringBuilder.append(var9_16.name);
                    stringBuilder.append('(');
                    for (n2 = 0; n2 < n4; ++n2) {
                        stringBuilder.append(((ModuleDependency)object).arguments.get((int)n2).name);
                        stringBuilder.append('/');
                        stringBuilder.append(var9_16.parameters.get((int)n2).name);
                        if (n2 + 1 >= n4) continue;
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(") as ");
                    stringBuilder.append(((ModuleDependency)object).visibleName().name);
                    stringBuilder.append(']');
                    System.err.println(stringBuilder.toString());
                }
                if (0 != n4) {
                    ModuleMap moduleMap = new ModuleMap(var9_16.parameters, ((ModuleDependency)object).arguments);
                } else {
                    ModuleMap moduleMap = new ModuleMap();
                }
                if (!((ModuleDependency)object).module.equals(((ModuleDependency)object).visibleName())) {
                    var13_45.put(((ModuleDependency)object).module, ((ModuleDependency)object).visibleName());
                }
                this.rename((Module)var9_16, (ModuleMap)var13_45);
            }
            arrayList.add((Module)var9_16);
            hashMap.put(var9_16.name.name, var9_16);
            if (null != var9_16.dependencies) {
                for (ModuleDependency moduleDependency : var9_16.dependencies) {
                    if (moduleDependency.isModification()) {
                        boolean bl2 = true;
                        if (null != var9_16.modification) {
                            this.runtime.error("duplicate modifies declaration", moduleDependency);
                            bl2 = false;
                        }
                        if (moduleDependency.visibleName().equals(var9_16.name)) {
                            this.runtime.error("module '" + var9_16.name + "' modifies itself", moduleDependency);
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        var9_16.modification = (ModuleModification)moduleDependency;
                        arrayList2.add(moduleDependency);
                        continue;
                    }
                    arrayList2.add(moduleDependency);
                }
            }
            if (this.runtime.test("optionDependencies")) {
                this.signature((Module)var9_16);
            }
            if (null == var9_16.parameters) continue;
            var9_16.setProperty("xtc.Constants.Arguments", var9_16.parameters);
            var9_16.parameters = null;
        }
        object = new HashMap();
        HashSet<ModuleName> hashSet = new HashSet<ModuleName>();
        for (Module module3 : arrayList) {
            if (hashSet.contains(module3.name)) continue;
            object.clear();
            do {
                if (object.containsKey(module3.name)) {
                    boolean bl = (Boolean)object.get(module3.name);
                    if (bl) break;
                    object.put(module3.name, Boolean.TRUE);
                    continue;
                }
                object.put(module3.name, Boolean.FALSE);
            } while (null != module3.modification && null != (module3 = (Module)hashMap.get(module3.modification.visibleName().name)));
            for (Module module4 : arrayList) {
                if (!object.containsKey(module4.name)) continue;
                hashSet.add(module4.name);
                if (!((Boolean)object.get(module4.name)).booleanValue()) continue;
                this.runtime.error("circular modifies dependency", module4.modification);
            }
        }
        Grammar grammar = new Grammar(arrayList);
        if (this.runtime.test("optionInstantiated")) {
            if (this.runtime.test("optionHtml")) {
                new HtmlPrinter(this.runtime, this.analyzer, this.ast, false).dispatch(grammar);
            } else {
                prettyPrinter = new PrettyPrinter(this.runtime.console(), this.ast, true);
                prettyPrinter.dispatch(grammar);
                prettyPrinter.flush();
            }
        }
        return this.runtime.seenError() ? null : grammar;
    }

    protected List<Attribute> check(Grammar grammar) {
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        this.phase = 1;
        Module module = grammar.modules.get(0);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        String string = null;
        boolean bl = false;
        for (Module module2 : grammar.modules) {
            Iterator<Attribute> iterator;
            Object object;
            if (module2.hasAttribute(Constants.ATT_STATEFUL.getName()) && null != (object = ((Attribute)((Object)(iterator = Attribute.get(Constants.ATT_STATEFUL.getName(), module2.attributes)))).getValue()) && object instanceof String && !((String)object).startsWith("\"")) {
                if (null == string) {
                    arrayList.add((Attribute)((Object)iterator));
                    string = (String)((Attribute)((Object)iterator)).getValue();
                }
                if (!string.equals(((Attribute)((Object)iterator)).getValue())) {
                    bl = true;
                }
            }
            if (!module2.hasAttribute("setOfString") && !module2.hasAttribute("flag")) continue;
            iterator = module2.attributes.iterator();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                String string2 = attribute.getName();
                if (!"setOfString".equals(string2) && !"flag".equals(string2) || arrayList.contains(attribute)) continue;
                arrayList.add(attribute);
            }
        }
        HashSet hashSet = new HashSet();
        boolean bl2 = false;
        for (Module module2 : grammar.modules) {
            this.analyzer.process(module2);
            this.hasState = false;
            boolean bl3 = this.isMofunctor = null != module2.modification;
            if (null != module2.attributes) {
                int n = module2.attributes.size();
                for (int i = 0; i < n; ++i) {
                    Node node;
                    Attribute attribute = module2.attributes.get(i);
                    String string3 = attribute.getName();
                    Object object = attribute.getValue();
                    if (!(Constants.ATT_WITH_LOCATION.equals(attribute) || Constants.ATT_CONSTANT.equals(attribute) || Constants.ATT_RAW_TYPES.equals(attribute) || Constants.ATT_VERBOSE.equals(attribute) || Constants.ATT_NO_WARNINGS.equals(attribute) || Constants.ATT_IGNORING_CASE.equals(attribute) || Constants.ATT_STATEFUL.getName().equals(string3) || "parser".equals(string3) || "main".equals(string3) || "printer".equals(string3) || "visibility".equals(string3) || "setOfString".equals(string3) || "flag".equals(string3) || "factory".equals(string3) || Constants.ATT_FLATTEN.equals(attribute) || Constants.ATT_GENERIC_AS_VOID.equals(attribute) || Constants.ATT_PARSE_TREE.equals(attribute) || Constants.ATT_PROFILE.equals(attribute) || Constants.ATT_DUMP.equals(attribute))) {
                        this.runtime.error("unrecognized grammar-wide attribute '" + attribute + "'", attribute);
                    } else {
                        for (int j = 0; j < i; ++j) {
                            node = module2.attributes.get(j);
                            if (string3.equals("setOfString") || string3.equals("flag")) {
                                if (attribute.equals(node)) {
                                    this.runtime.error("duplicate attribute '" + attribute + "'", attribute);
                                    break;
                                }
                                if (null == object || !object.equals(((Attribute)node).getValue())) continue;
                                this.runtime.error("duplicate field name '" + attribute + "'", attribute);
                                continue;
                            }
                            if (!string3.equals(((Attribute)node).getName())) continue;
                            this.runtime.error("duplicate attribute '" + string3 + "'", attribute);
                            break;
                        }
                    }
                    if (Constants.ATT_STATEFUL.getName().equals(string3)) {
                        if (null == object) {
                            this.runtime.error("stateful attribute without class name", attribute);
                        } else if (!(object instanceof String)) {
                            this.runtime.error("stateful attribute with invalid value", attribute);
                        } else if (((String)object).startsWith("\"")) {
                            this.runtime.error("stateful attribute with invalid value", attribute);
                        } else if (bl) {
                            this.runtime.error("inconsistent state class across modules", attribute);
                        }
                        this.hasState = true;
                        continue;
                    }
                    if ("parser".equals(string3)) {
                        if (null == object) {
                            this.runtime.error("parser attribute without class name", attribute);
                            continue;
                        }
                        if (!(object instanceof String)) {
                            this.runtime.error("parser attribute with invalid value", attribute);
                            continue;
                        }
                        if (!((String)object).startsWith("\"")) continue;
                        this.runtime.error("parser attribute with invalid value", attribute);
                        continue;
                    }
                    if ("main".equals(string3)) {
                        if (this.runtime.test("optionLGPL")) {
                            this.runtime.error("main attribute incompatible with LGPL", attribute);
                            continue;
                        }
                        if (null == object) {
                            this.runtime.error("main attribute without nonterminal value", attribute);
                            continue;
                        }
                        if (!(object instanceof String)) {
                            this.runtime.error("main attribute with invalid value", attribute);
                            continue;
                        }
                        if (((String)object).startsWith("\"")) {
                            this.runtime.error("main attribute with invalid value", attribute);
                            continue;
                        }
                        NonTerminal nonTerminal = new NonTerminal((String)object);
                        node = null;
                        boolean bl4 = false;
                        try {
                            node = this.analyzer.lookup(nonTerminal);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.runtime.error("main attribute with ambiguous nonterminal '" + nonTerminal + "'", attribute);
                            bl4 = true;
                        }
                        if (bl4) continue;
                        if (null == node) {
                            this.runtime.error("main attribute with undefined nonterminal '" + nonTerminal + "'", attribute);
                            continue;
                        }
                        if (!this.analyzer.isDefined((Production)node, module2)) {
                            this.runtime.error("main attribute with another module's nonterminal '" + nonTerminal + "'", attribute);
                            continue;
                        }
                        if (((Production)node).hasAttribute(Constants.ATT_PUBLIC)) continue;
                        this.runtime.error("main attribute with non-public nonterminal '" + nonTerminal + "'", attribute);
                        continue;
                    }
                    if ("printer".equals(string3)) {
                        if (this.runtime.test("optionLGPL")) {
                            this.runtime.error("printer attribute incompatible with LGPL", attribute);
                        } else if (null == object) {
                            this.runtime.error("printer attribute without class name", attribute);
                        } else if (!(object instanceof String)) {
                            this.runtime.error("printer attribute with invalid value", attribute);
                        } else if (((String)object).startsWith("\"")) {
                            this.runtime.error("printer attribute with invalid value", attribute);
                        }
                        if (module2.hasAttribute("main")) continue;
                        this.runtime.error("printer attribute without main attribute", attribute);
                        continue;
                    }
                    if ("visibility".equals(string3)) {
                        if (null == object) {
                            this.runtime.error("visibility attribute without value", attribute);
                            continue;
                        }
                        if (Constants.ATT_PUBLIC.getValue().equals(object) || Constants.ATT_PACKAGE_PRIVATE.getValue().equals(object)) continue;
                        this.runtime.error("visibility attribute with invalid value", attribute);
                        continue;
                    }
                    if ("setOfString".equals(string3)) {
                        if (null == object) {
                            this.runtime.error("string set attribute without set value", attribute);
                            continue;
                        }
                        if (!(object instanceof String)) {
                            this.runtime.error("string set attribute with invalid value", attribute);
                            continue;
                        }
                        if (!((String)object).startsWith("\"")) continue;
                        this.runtime.error("string set attribute with invalid value", attribute);
                        continue;
                    }
                    if ("flag".equals(string3)) {
                        if (null == object) {
                            this.runtime.error("flag attribute without flag value", attribute);
                            continue;
                        }
                        if (!(object instanceof String)) {
                            this.runtime.error("flag attribute with invalid value", attribute);
                            continue;
                        }
                        if (!((String)object).startsWith("\"")) continue;
                        this.runtime.error("flag attribute with invalid value", attribute);
                        continue;
                    }
                    if ("factory".equals(string3)) {
                        if (null == object) {
                            this.runtime.error("factory attribute without class name", attribute);
                            continue;
                        }
                        if (!(object instanceof String)) {
                            this.runtime.error("factory attribute with invalid value", attribute);
                            continue;
                        }
                        if (!((String)object).startsWith("\"")) continue;
                        this.runtime.error("factory attribute with invalud value", attribute);
                        continue;
                    }
                    if (Constants.ATT_GENERIC_AS_VOID.equals(attribute)) {
                        if (!module2.hasAttribute(Constants.ATT_PARSE_TREE)) continue;
                        this.runtime.error("genericAsVoid attribute incompatible with withParseTree attribute", attribute);
                        continue;
                    }
                    if (Constants.ATT_DUMP.equals(attribute)) {
                        if (!this.runtime.test("optionLGPL")) continue;
                        this.runtime.error("dump attribute incompatible with LGPL", attribute);
                        continue;
                    }
                    if (!Constants.ATT_RAW_TYPES.equals(attribute)) continue;
                    this.runtime.warning("the rawTypes attribute has been deprecated", attribute);
                    this.runtime.errConsole().loc(attribute).pln(": warning: and will be removed in a future release").flush();
                }
            }
            if (!this.hasState) {
                this.hasState = this.analyzer.hasAttribute(module2, Constants.ATT_STATEFUL.getName(), hashSet);
                hashSet.clear();
            }
            for (Production production : module2.productions) {
                this.sequenceNames.clear();
                this.analyzer.process(production);
                try {
                    if (!production.isPartial() && production != this.analyzer.lookup(production.name)) {
                        this.runtime.error("duplicate definition for nonterminal '" + production.name + "'", production);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.runtime.error("duplicate definition for nonterminal '" + production.name + "'", production);
                }
                if (!production.hasAttribute(Constants.ATT_PUBLIC)) continue;
                if (this.analyzer.isDefined(production, module)) {
                    bl2 = true;
                    continue;
                }
                production.attributes.remove(Constants.ATT_PUBLIC);
            }
        }
        if (!bl2) {
            this.runtime.error("no public nonterminal", grammar.modules.get((int)0).productions.get(0));
        }
        return arrayList;
    }

    protected void applyModifications(Grammar grammar) {
        Module module;
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        this.phase = 2;
        Module module2 = grammar.modules.get(0);
        HashSet<ModuleName> hashSet = new HashSet<ModuleName>();
        HashMap<ModuleName, Boolean> hashMap = new HashMap<ModuleName, Boolean>();
        hashSet.add(module2.name);
        this.analyzer.trace(module2, hashSet, hashMap);
        Object object = grammar.modules.iterator();
        while (object.hasNext()) {
            module = object.next();
            if (hashSet.contains(module.name) || hashMap.containsKey(module.name)) continue;
            if (this.runtime.test("optionVerbose")) {
                System.err.println("[Unloading unused module " + module.name + "]");
            }
            this.analyzer.remove(module);
            object.remove();
        }
        if (0 != hashMap.size()) {
            object = new ArrayList();
            HashSet<Object> hashSet2 = new HashSet<Object>();
            HashSet<Object> hashSet3 = new HashSet<Object>();
            HashMap<NonTerminal, Production> hashMap2 = new HashMap<NonTerminal, Production>();
            HashMap<NonTerminal, Production> hashMap3 = new HashMap<NonTerminal, Production>();
            while (true) {
                object.clear();
                module = null;
                for (Module module3 : grammar.modules) {
                    if (null == module3.modification || hashSet2.contains(module3)) continue;
                    do {
                        object.add(module3);
                        module3 = this.analyzer.lookup(module3.modification.visibleName());
                    } while (null != module3.modification);
                    module = module3;
                    if (!hashSet2.contains(module)) break;
                    hashSet2.addAll((Collection<Object>)object);
                    module = null;
                    break;
                }
                if (null == module) break;
                Object object2 = module;
                for (int i = object.size() - 1; i >= 0; --i) {
                    Module module4 = (Module)object.get(i);
                    if (this.runtime.test("optionVerbose")) {
                        System.err.println("[Applying module " + module4.name + " to module " + ((Module)object2).name + "]");
                    }
                    if (((Boolean)hashMap.get(((Module)object2).name)).booleanValue() || hashMap.containsKey(((Module)object2).name) && hashSet.contains(((Module)object2).name)) {
                        if (this.runtime.test("optionVerbose")) {
                            System.err.println("[Copying modified module " + ((Module)object2).name + "]");
                        }
                        object2 = this.analyzer.copy((Module)object2);
                    } else {
                        if (this.runtime.test("optionVerbose")) {
                            System.err.println("[Removing modified module " + ((Module)object2).name + "]");
                        }
                        this.analyzer.remove((Module)object2);
                        grammar.remove((Module)object2);
                    }
                    if (this.runtime.test("optionVerbose")) {
                        System.err.println("[Removing modifying module " + module4.name + "]");
                    }
                    this.analyzer.remove(module4);
                    grammar.replace(module4, (Module)object2);
                    this.rename((Module)object2, new ModuleMap(((Module)object2).name, module4.name));
                    ((Module)object2).documentation = module4.documentation;
                    ((Module)object2).name = module4.name;
                    ((Node)object2).removeProperty("xtc.Constants.Arguments");
                    if (module4.hasProperty("xtc.Constants.Arguments")) {
                        ((Node)object2).setProperty("xtc.Constants.Arguments", module4.getProperty("xtc.Constants.Arguments"));
                    }
                    Iterator<ModuleDependency> object5 = module4.dependencies.iterator();
                    while (object5.hasNext()) {
                        if (!object5.next().isModification()) continue;
                        object5.remove();
                    }
                    if (null == ((Module)object2).dependencies) {
                        ((Module)object2).dependencies = module4.dependencies;
                    } else {
                        ((Module)object2).dependencies.addAll(module4.dependencies);
                    }
                    if (null != module4.header) {
                        if (null == ((Module)object2).header) {
                            ((Module)object2).header = module4.header;
                        } else {
                            ((Module)object2).header.add(module4.header);
                        }
                    }
                    if (null != module4.body) {
                        if (null == ((Module)object2).body) {
                            ((Module)object2).body = module4.body;
                        } else {
                            ((Module)object2).body.add(module4.body);
                        }
                    }
                    if (null != module4.footer) {
                        if (null == ((Module)object2).footer) {
                            ((Module)object2).footer = module4.footer;
                        } else {
                            ((Module)object2).footer.add(module4.footer);
                        }
                    }
                    if (null != ((Module)object2).attributes) {
                        if (((Module)object2).hasAttribute(Constants.ATT_STATEFUL.getName())) {
                            if (null == module4.attributes) {
                                module4.attributes = new ArrayList<Attribute>();
                            }
                            if (!module4.hasAttribute(Constants.ATT_STATEFUL.getName())) {
                                module4.attributes.add(Attribute.get(Constants.ATT_STATEFUL.getName(), ((Module)object2).attributes));
                            }
                        }
                        if (((Module)object2).hasAttribute("setOfString") || ((Module)object2).hasAttribute("flag")) {
                            if (null == module4.attributes) {
                                module4.attributes = new ArrayList<Attribute>();
                            }
                            for (Attribute attribute : ((Module)object2).attributes) {
                                String string = attribute.getName();
                                if (!"setOfString".equals(string) && !"flag".equals(string) || module4.attributes.contains(attribute)) continue;
                                module4.attributes.add(attribute);
                            }
                        }
                    }
                    ((Module)object2).attributes = module4.attributes;
                    hashMap2.clear();
                    hashMap3.clear();
                    for (Production production : ((Module)object2).productions) {
                        Production production2 = this.strip(production);
                        if (!production2.isFull() || hashMap3.containsKey(production2.name)) continue;
                        hashMap2.put(production2.name, production2);
                        hashMap3.put(production2.name, production2);
                    }
                    for (Production production : module4.productions) {
                        Production production3 = this.strip(production);
                        if (!production3.isFull() || hashMap3.containsKey(production3.name)) continue;
                        hashMap3.put(production3.name, production3);
                    }
                    int n = this.runtime.errorCount();
                    for (Production production : module4.productions) {
                        FullProduction fullProduction = (FullProduction)hashMap3.get(production.name);
                        if (production.isFull()) {
                            if (hashMap2.containsKey(production.name)) continue;
                            ((Module)object2).productions.add(production);
                            hashMap2.put(production.name, production);
                            continue;
                        }
                        if (null == fullProduction) continue;
                        if (production.isAddition()) {
                            this.apply((AlternativeAddition)production, fullProduction);
                            continue;
                        }
                        if (production.isRemoval()) {
                            this.apply((AlternativeRemoval)production, fullProduction);
                            continue;
                        }
                        if (production.isOverride()) {
                            this.apply((ProductionOverride)production, fullProduction);
                            continue;
                        }
                        throw new AssertionError((Object)("Unrecognized production " + production));
                    }
                    if (this.runtime.test("optionVerbose")) {
                        System.err.println("[Adding resulting module " + ((Module)object2).name + "]");
                    }
                    this.analyzer.add((Module)object2);
                    hashSet3.add(object2);
                    this.analyzer.process((Module)object2);
                    for (Production production : ((Module)object2).productions) {
                        this.sequenceNames.clear();
                        this.analyzer.process(production);
                    }
                    if (this.runtime.errorCount() == n) continue;
                    hashSet2.add(object2);
                    List list = object.subList(0, i);
                    hashSet2.addAll(list);
                    hashSet3.addAll(list);
                }
                module2 = grammar.modules.get(0);
                hashSet.clear();
                hashMap.clear();
                hashSet.add(module2.name);
                this.analyzer.trace(module2, hashSet, hashMap);
            }
            this.phase = 3;
            for (Module module3 : grammar.modules) {
                if (hashSet3.contains(module3)) continue;
                this.analyzer.process(module3);
                for (Production production : module3.productions) {
                    this.analyzer.process(production);
                }
            }
        }
        if (this.runtime.test("optionApplied")) {
            if (this.runtime.test("optionHtml")) {
                new HtmlPrinter(this.runtime, this.analyzer, this.ast, false).dispatch(grammar);
            } else {
                object = new PrettyPrinter(this.runtime.console(), this.ast, true);
                ((Visitor)object).dispatch(grammar);
                ((PrettyPrinter)object).flush();
            }
        }
    }

    protected void internTypes(Grammar grammar) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (grammar.modules.get(0).hasAttribute(Constants.ATT_PARSE_TREE)) {
            bl2 = true;
            bl3 = true;
        }
        for (Module module : grammar.modules) {
            for (Production production : module.productions) {
                if (!this.ast.isGenericNode(production.dType)) continue;
                bl = true;
                for (Sequence sequence : production.choice.alternatives) {
                    Element element;
                    Element element2 = element = sequence.isEmpty() ? null : Analyzer.stripAndUnbind(sequence.get(0));
                    if (!production.name.equals(element) && !production.qName.equals(element)) continue;
                    bl4 = true;
                }
            }
        }
        if (!grammar.modules.get(0).hasAttribute(Constants.ATT_GENERIC_AS_VOID)) {
            if (bl) {
                grammar.modules.get(0).setProperty("generic", Boolean.TRUE);
            }
            if (bl4) {
                grammar.modules.get(0).setProperty("recursive", Boolean.TRUE);
            }
        }
        this.ast.initialize(bl, bl2, bl3, bl4);
        for (Module module : grammar.modules) {
            for (Production production : module.productions) {
                Object object;
                try {
                    object = this.ast.intern(production.dType);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.runtime.error(illegalArgumentException.getMessage() + " for production '" + production.name + "'", production);
                    object = ErrorT.TYPE;
                }
                production.type = object;
            }
        }
        for (Module module : grammar.modules) {
            for (Production production : module.productions) {
                if (!production.hasAttribute(Constants.ATT_VARIANT)) continue;
                if (AST.isToken(production.type)) {
                    this.runtime.error("variant production for token type", production);
                    continue;
                }
                if (AST.isNode(production.type)) continue;
                this.runtime.error("variant production without node type", production);
            }
        }
    }

    protected void checkRecursions(Grammar grammar) {
        new TextTester(this.runtime, this.analyzer).dispatch(grammar);
        LeftRecurser leftRecurser = new LeftRecurser(this.runtime, this.analyzer);
        leftRecurser.dispatch(grammar);
        Set<NonTerminal> set = leftRecurser.recursive();
        for (Module module : grammar.modules) {
            for (Production production : module.productions) {
                if (!set.contains(production.qName)) continue;
                this.runtime.error("left-recursive definition for nonterminal '" + production.name + "'", production);
            }
        }
    }

    protected void checkRepetitions(Grammar grammar) {
        this.analyzer.register(this.checkRepetitionsVisitor);
        this.analyzer.init(grammar);
        for (Module module : grammar.modules) {
            this.analyzer.process(module);
            for (Production production : module.productions) {
                if (!production.isFull()) continue;
                this.analyzer.process(production);
            }
        }
    }

    protected Module combine(Grammar grammar, List<Attribute> list) {
        Module module = grammar.modules.get(0);
        module.dependencies = null;
        module.modification = null;
        if (0 < list.size()) {
            if (null == module.attributes) {
                module.attributes = list;
            } else {
                for (Attribute iterable2 : list) {
                    if (module.attributes.contains(iterable2)) continue;
                    module.attributes.add(iterable2);
                }
            }
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Action> arrayList2 = new ArrayList<Action>();
        ArrayList<Action> arrayList3 = new ArrayList<Action>();
        for (Module module2 : grammar.modules) {
            if (null != module2.header && !arrayList.contains(module2.header)) {
                arrayList.add(module2.header);
            }
            if (null != module2.body && !arrayList2.contains(module2.body)) {
                arrayList2.add(module2.body);
            }
            if (null == module2.footer || arrayList3.contains(module2.footer)) continue;
            arrayList3.add(module2.footer);
        }
        module.header = null;
        Iterator<Module> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Action action = (Action)((Object)iterator.next());
            if (null == module.header) {
                module.header = action;
                continue;
            }
            module.header.add(action);
        }
        module.body = null;
        for (Action action : arrayList2) {
            if (null == module.body) {
                module.body = action;
                continue;
            }
            module.body.add(action);
        }
        module.footer = null;
        for (Action action : arrayList3) {
            if (null == module.footer) {
                module.footer = action;
                continue;
            }
            module.footer.add(action);
        }
        for (Module module3 : grammar.modules) {
            if (module == module3) continue;
            module.productions.addAll(module3.productions);
        }
        return module;
    }

    public Object visit(Module module) {
        this.badNTs.clear();
        Grammar grammar = this.load(module);
        if (this.runtime.seenError() || this.runtime.test("optionLoaded") || this.runtime.test("optionDependencies") || this.runtime.test("optionInstantiated")) {
            return null;
        }
        List<Attribute> list = this.check(grammar);
        this.applyModifications(grammar);
        if (this.runtime.test("optionApplied")) {
            return null;
        }
        this.internTypes(grammar);
        this.checkRecursions(grammar);
        this.checkRepetitions(grammar);
        new ReachabilityChecker(this.runtime, this.analyzer).dispatch(grammar);
        if (this.runtime.seenError()) {
            return null;
        }
        this.analyzer.uniquify();
        return this.combine(grammar, list);
    }

    public void visit(Production production) {
        if (1 == this.phase) {
            if (Constants.ATT_PACKAGE_PRIVATE.getValue().equals(production.dType) || Constants.ATT_INLINE.getName().equals(production.dType)) {
                this.runtime.error("attribute '" + production.dType + "' as type for production '" + production.name + "'", production);
            } else if ((Constants.ATT_WITH_LOCATION.getName().equals(production.dType) || Constants.ATT_CONSTANT.getName().equals(production.dType) || Constants.ATT_NO_INLINE.getName().equals(production.dType) || Constants.ATT_MEMOIZED.getName().equals(production.dType) || Constants.ATT_VERBOSE.getName().equals(production.dType) || Constants.ATT_VARIANT.getName().equals(production.dType) || Constants.ATT_IGNORING_CASE.getName().equals(production.dType) || Constants.ATT_STATEFUL.getName().equals(production.dType) || Constants.ATT_RESETTING.getName().equals(production.dType)) && !production.isPartial() && !this.analyzer.grammar().modules.get(0).hasAttribute(Constants.ATT_NO_WARNINGS) && !production.hasAttribute(Constants.ATT_NO_WARNINGS)) {
                this.runtime.warning("attribute '" + production.dType + "' as type for production " + production.name + "'", production);
            }
            if (production.isPartial()) {
                if (!this.isMofunctor) {
                    this.runtime.error("production modification '" + production.name + "' without modifies declaration", production);
                } else {
                    FullProduction fullProduction = null;
                    try {
                        fullProduction = this.analyzer.lookup(production.name);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (null == fullProduction || !this.analyzer.isDefined(fullProduction, this.analyzer.currentModule())) {
                        this.runtime.error("production modification '" + production.name + "' without full production", production);
                    } else if (!production.dType.equals(fullProduction.dType)) {
                        this.runtime.error("type '" + production.dType + "' of production modification '" + production.name + "' does not match full production's type", production);
                    }
                }
            }
            if (null != production.attributes) {
                int n = production.attributes.size();
                block2: for (int i = 0; i < n; ++i) {
                    Attribute attribute = production.attributes.get(i);
                    if (!(Constants.ATT_PUBLIC.equals(attribute) || Constants.ATT_PROTECTED.equals(attribute) || Constants.ATT_PRIVATE.equals(attribute) || Constants.ATT_TRANSIENT.equals(attribute) || Constants.ATT_INLINE.equals(attribute) || Constants.ATT_NO_INLINE.equals(attribute) || Constants.ATT_MEMOIZED.equals(attribute) || Constants.ATT_WITH_LOCATION.equals(attribute) || Constants.ATT_CONSTANT.equals(attribute) || Constants.ATT_VARIANT.equals(attribute) || Constants.ATT_VERBOSE.equals(attribute) || Constants.ATT_NO_WARNINGS.equals(attribute) || Constants.ATT_IGNORING_CASE.equals(attribute) || Constants.ATT_STATEFUL.equals(attribute) || Constants.ATT_RESETTING.equals(attribute))) {
                        this.runtime.error("unrecognized per-production attribute '" + attribute + "'", attribute);
                        continue;
                    }
                    if (!this.hasState && Constants.ATT_STATEFUL.equals(attribute)) {
                        this.runtime.error("stateful attribute without grammar-wide stateful attribute", attribute);
                        continue;
                    }
                    if (!this.hasState && Constants.ATT_RESETTING.equals(attribute)) {
                        this.runtime.error("resetting attribute without grammar-wide stateful attribute", attribute);
                        continue;
                    }
                    for (int j = 0; j < i; ++j) {
                        if (!attribute.equals(production.attributes.get(j))) continue;
                        this.runtime.error("duplicate attribute '" + attribute.getName() + "'", attribute);
                        continue block2;
                    }
                }
                if (production.hasAttribute(Constants.ATT_MEMOIZED)) {
                    if (production.hasAttribute(Constants.ATT_TRANSIENT)) {
                        this.runtime.error("memozied attribute contradicts transient attribute", Attribute.get(Constants.ATT_MEMOIZED.getName(), production.attributes));
                    }
                    if (production.hasAttribute(Constants.ATT_INLINE)) {
                        this.runtime.error("memoized attribute contradicts inline attribute", Attribute.get(Constants.ATT_MEMOIZED.getName(), production.attributes));
                    }
                }
                if (production.hasAttribute(Constants.ATT_TRANSIENT) && production.hasAttribute(Constants.ATT_INLINE)) {
                    this.runtime.error("inline attribute subsumes transient attribute", Attribute.get(Constants.ATT_INLINE.getName(), production.attributes));
                }
                if (production.hasAttribute(Constants.ATT_INLINE) && production.hasAttribute(Constants.ATT_NO_INLINE)) {
                    this.runtime.error("inline attribute contradicts noinline attribute", Attribute.get(Constants.ATT_NO_INLINE.getName(), production.attributes));
                }
            }
        }
        this.dispatch(production.choice);
    }

    public void visit(OrderedChoice orderedChoice) {
        for (Sequence sequence : orderedChoice.alternatives) {
            this.dispatch(sequence);
        }
    }

    public void visit(Repetition repetition) {
        if (1 == this.phase && Analyzer.strip(repetition.element) instanceof Action) {
            this.runtime.error("repeated action", repetition);
        }
        this.dispatch(repetition.element);
    }

    public void visit(Option option) {
        if (1 == this.phase && Analyzer.strip(option.element) instanceof Action) {
            this.runtime.error("optional action", option);
        }
        this.dispatch(option.element);
    }

    public void visit(Sequence sequence) {
        if ((1 == this.phase || 2 == this.phase) && null != sequence.name) {
            if (this.sequenceNames.contains(sequence.name)) {
                this.runtime.error("duplicate sequence name '" + sequence.name + "'", sequence);
            } else {
                this.sequenceNames.add(sequence.name);
            }
        }
        for (Element element : sequence.elements) {
            this.dispatch(element);
        }
    }

    public void visit(Predicate predicate) {
        if (1 == this.phase && this.isPredicate) {
            this.runtime.error("syntactic predicate within syntactic predicate", predicate);
        }
        boolean bl = this.isPredicate;
        this.isPredicate = true;
        this.dispatch(predicate.element);
        this.isPredicate = bl;
    }

    public void visit(SemanticPredicate semanticPredicate) {
        if (1 == this.phase) {
            if (!(semanticPredicate.element instanceof Action)) {
                this.runtime.error("malformed semantic predicate", semanticPredicate);
            } else {
                Action action = (Action)semanticPredicate.element;
                if (null == action.code || 0 >= action.code.size()) {
                    this.runtime.error("empty test for semantic predicate", semanticPredicate);
                }
            }
        }
        this.dispatch(semanticPredicate.element);
    }

    public void visit(VoidedElement voidedElement) {
        if (1 == this.phase) {
            Element element = Analyzer.strip(voidedElement.element);
            switch (element.tag()) {
                case FOLLOWED_BY: 
                case NOT_FOLLOWED_BY: 
                case SEMANTIC_PREDICATE: {
                    this.runtime.error("voided predicate", voidedElement);
                    break;
                }
                case BINDING: {
                    this.runtime.error("voided binding", voidedElement);
                    break;
                }
                case ACTION: {
                    this.runtime.error("voided action", voidedElement);
                    break;
                }
                case PARSER_ACTION: {
                    this.runtime.error("voided parser action", voidedElement);
                    break;
                }
                case NULL: {
                    this.runtime.error("voided null literal", voidedElement);
                    break;
                }
                case NODE_MARKER: {
                    this.runtime.error("voided node marker", voidedElement);
                }
            }
        }
        this.dispatch(voidedElement.element);
    }

    public void visit(Binding binding) {
        if (1 == this.phase) {
            Element element = Analyzer.strip(binding.element);
            switch (element.tag()) {
                case FOLLOWED_BY: 
                case NOT_FOLLOWED_BY: 
                case SEMANTIC_PREDICATE: {
                    this.runtime.error("binding for predicate", binding);
                    break;
                }
                case VOIDED: {
                    this.runtime.error("binding for voided element", binding);
                    break;
                }
                case BINDING: {
                    this.runtime.error("binding for binding", binding);
                    break;
                }
                case NONTERMINAL: {
                    NonTerminal nonTerminal = (NonTerminal)element;
                    FullProduction fullProduction = null;
                    try {
                        fullProduction = this.analyzer.lookup(nonTerminal);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (null == fullProduction || !this.ast.isVoid(fullProduction.dType)) break;
                    this.runtime.error("binding for void nonterminal '" + nonTerminal + "'", binding);
                    break;
                }
                case ACTION: {
                    this.runtime.error("binding for action", binding);
                    break;
                }
                case PARSER_ACTION: {
                    this.runtime.error("binding for parser action", binding);
                    break;
                }
                case NODE_MARKER: {
                    this.runtime.error("binding for node marker", binding);
                }
            }
        }
        this.dispatch(binding.element);
    }

    public void visit(StringMatch stringMatch) {
        if (1 == this.phase) {
            Element element = Analyzer.strip(stringMatch.element);
            switch (element.tag()) {
                case FOLLOWED_BY: 
                case NOT_FOLLOWED_BY: 
                case SEMANTIC_PREDICATE: {
                    this.runtime.error("string match on predicate", stringMatch);
                    break;
                }
                case VOIDED: {
                    this.runtime.error("string match on voided element", stringMatch);
                    break;
                }
                case BINDING: {
                    this.runtime.error("string match on binding (try binding the match instead)", stringMatch);
                    break;
                }
                case STRING_MATCH: {
                    this.runtime.error("string match on another string match", stringMatch);
                    break;
                }
                case NONTERMINAL: {
                    NonTerminal nonTerminal = (NonTerminal)element;
                    FullProduction fullProduction = null;
                    try {
                        fullProduction = this.analyzer.lookup(nonTerminal);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (null == fullProduction || !this.ast.isVoid(fullProduction.dType)) break;
                    this.runtime.error("string match on void nonterminal '" + nonTerminal + "'", stringMatch);
                    break;
                }
                case ANY_CHAR: 
                case CHAR_CLASS: 
                case CHAR_LITERAL: 
                case CHAR_SWITCH: 
                case STRING_LITERAL: {
                    this.runtime.error("match for terminal", stringMatch);
                    break;
                }
                case ACTION: {
                    this.runtime.error("match for action", stringMatch);
                    break;
                }
                case PARSER_ACTION: {
                    this.runtime.error("match for parser action", stringMatch);
                    break;
                }
                case NODE_MARKER: {
                    this.runtime.error("match for node marker", stringMatch);
                }
            }
        }
        this.dispatch(stringMatch.element);
    }

    public void visit(NonTerminal nonTerminal) {
        FullProduction fullProduction = null;
        try {
            fullProduction = this.analyzer.lookup(nonTerminal);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (nonTerminal.hasProperty("xtc.Constants.Original")) {
                if (!this.badNTs.containsKey(nonTerminal)) {
                    this.runtime.error("ambiguous renamed nonterminal '" + nonTerminal + "'", nonTerminal);
                    this.badNTs.put(nonTerminal, nonTerminal);
                }
            } else if (!this.badNTs.containsKey(nonTerminal)) {
                this.runtime.error("ambiguous nonterminal '" + nonTerminal + "'", nonTerminal);
                this.badNTs.put(nonTerminal, nonTerminal);
            }
            return;
        }
        if (null == fullProduction) {
            if (nonTerminal.hasProperty("xtc.Constants.Original")) {
                if (!this.badNTs.containsKey(nonTerminal)) {
                    this.runtime.error("undefined renamed nonterminal '" + nonTerminal + "'", nonTerminal);
                    this.badNTs.put(nonTerminal, nonTerminal);
                }
            } else if (!this.badNTs.containsKey(nonTerminal)) {
                this.runtime.error("undefined nonterminal '" + nonTerminal + "'", nonTerminal);
                this.badNTs.put(nonTerminal, nonTerminal);
            }
        }
    }

    public void visit(Terminal terminal) {
    }

    public void visit(StringLiteral stringLiteral) {
        if (1 == this.phase && 0 == stringLiteral.text.length()) {
            this.runtime.error("empty string literal", stringLiteral);
        }
    }

    public void visit(CharClass charClass) {
        if (1 != this.phase) {
            return;
        }
        int n = charClass.ranges.size();
        if (0 >= n) {
            this.runtime.error("empty character class", charClass);
        } else {
            ArrayList<CharRange> arrayList = new ArrayList<CharRange>(charClass.ranges);
            Collections.sort(arrayList);
            for (int i = 0; i < n - 1; ++i) {
                boolean bl;
                CharRange charRange = arrayList.get(i);
                CharRange charRange2 = arrayList.get(i + 1);
                if (charRange.last < charRange2.first) continue;
                boolean bl2 = charRange.first == charRange.last;
                boolean bl3 = bl = charRange2.first == charRange2.last;
                if (bl2) {
                    if (bl) {
                        this.runtime.error("duplicate character '" + Utilities.escape(charRange.last, 12) + "' in character class", charClass);
                        continue;
                    }
                    this.runtime.error("character '" + Utilities.escape(charRange.last, 12) + "' already contained in range " + Utilities.escape(charRange2.first, 12) + "-" + Utilities.escape(charRange2.last, 12), charClass);
                    continue;
                }
                if (bl) {
                    this.runtime.error("character '" + Utilities.escape(charRange2.first, 12) + "' already contained in range " + Utilities.escape(charRange.first, 12) + "-" + Utilities.escape(charRange.last, 12), charClass);
                    continue;
                }
                this.runtime.error("ranges " + Utilities.escape(charRange.first, 12) + "-" + Utilities.escape(charRange.last, 12) + " and " + Utilities.escape(charRange2.first, 12) + "-" + Utilities.escape(charRange2.last, 12) + " overlap", charClass);
            }
        }
    }

    public void visit(NullLiteral nullLiteral) {
    }

    public void visit(NodeMarker nodeMarker) {
        if (!this.ast.isGenericNode(this.analyzer.current().dType)) {
            this.runtime.error("node marker in non-generic production", nodeMarker);
        } else if (this.isPredicate) {
            this.runtime.error("node marker in predicate", nodeMarker);
        }
    }

    public void visit(Action action) {
    }

    public void visit(ParserAction parserAction) {
        if (1 == this.phase) {
            if (!(parserAction.element instanceof Action)) {
                this.runtime.error("malformed parser action", parserAction);
            }
            if (this.isPredicate) {
                this.runtime.error("parser action within syntactic predicate", parserAction);
            }
        }
        this.dispatch(parserAction.element);
    }

    public void visit(InternalElement internalElement) {
        if (1 == this.phase) {
            this.runtime.error("internal element", (Element)((Object)internalElement));
        }
    }
}

