/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.parser.Analyzer;
import xtc.parser.CharCase;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Sequence;
import xtc.parser.UnaryOperator;
import xtc.tree.Visitor;
import xtc.util.Runtime;

public class ReachabilityChecker
extends Visitor {
    protected Runtime runtime;
    protected Analyzer analyzer;

    public ReachabilityChecker(Runtime runtime, Analyzer analyzer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
    }

    public void visit(Grammar grammar) {
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        for (Module module : grammar.modules) {
            this.analyzer.process(module);
            for (Production production : module.productions) {
                if (!production.isFull()) continue;
                this.analyzer.process(production);
            }
        }
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        for (Production production : module.productions) {
            this.analyzer.process(production);
        }
    }

    public void visit(FullProduction fullProduction) {
        this.dispatch(fullProduction.choice);
    }

    public void visit(OrderedChoice orderedChoice) {
        int n = orderedChoice.alternatives.size();
        for (int i = 0; i < n; ++i) {
            Sequence sequence = orderedChoice.alternatives.get(i);
            if (!this.analyzer.restrictsInput(sequence) && i < n - 1) {
                this.runtime.error("unreachable alternative", orderedChoice.alternatives.get(i + 1));
                break;
            }
            this.dispatch(sequence);
        }
    }

    public void visit(Sequence sequence) {
        for (Element element : sequence.elements) {
            this.dispatch(element);
        }
    }

    public void visit(UnaryOperator unaryOperator) {
        this.dispatch(unaryOperator.element);
    }

    public void visit(CharSwitch charSwitch) {
        for (CharCase charCase : charSwitch.cases) {
            this.dispatch(charCase.element);
        }
        this.dispatch(charSwitch.base);
    }

    public void visit(Element element) {
    }
}

