/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Annotator;
import xtc.parser.ChoiceExpander;
import xtc.parser.CodeGenerator;
import xtc.parser.DeadProductionEliminator;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.DuplicateProductionFolder;
import xtc.parser.ElementVoider;
import xtc.parser.GenericVoider;
import xtc.parser.Generifier;
import xtc.parser.HtmlPrinter;
import xtc.parser.Inliner;
import xtc.parser.ListMaker;
import xtc.parser.MetaDataCreator;
import xtc.parser.MetaDataSetter;
import xtc.parser.Module;
import xtc.parser.PParser;
import xtc.parser.ParseException;
import xtc.parser.PrefixFolder;
import xtc.parser.PrettyPrinter;
import xtc.parser.ProductionVoider;
import xtc.parser.ReachabilityChecker;
import xtc.parser.ReferenceCounter;
import xtc.parser.Resolver;
import xtc.parser.Result;
import xtc.parser.RootFinder;
import xtc.parser.Simplifier;
import xtc.parser.TerminalOptimizer;
import xtc.parser.Tokenizer;
import xtc.parser.Transformer;
import xtc.parser.TransientMarker;
import xtc.parser.TreeExtractor;
import xtc.parser.TreeTyper;
import xtc.parser.ValueChecker;
import xtc.parser.VariantSorter;
import xtc.tree.Attribute;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.type.JavaAST;
import xtc.util.Tool;
import xtc.util.Utilities;

public class Rats
extends Tool {
    public String getName() {
        return "Rats! Parser Generator";
    }

    public String getCopy() {
        return "(C) 2004-2008 Robert Grimm";
    }

    public String getExplanation() {
        return "By default, Rats! performs all optimizations besides the errors2 and left1 optimizations.  If one or more individual optimizations are specified as command line flags, all other optimizations are automatically disabled.  The choices2 optimization includes choices1, errors1 is complimentary to errors2, and left1 and left2 are mutually exclusive.";
    }

    public void init() {
        super.init();
        this.runtime.bool("loaded", "optionLoaded", false, "Print every module after loading, then stop.").bool("instantiated", "optionInstantiated", false, "Print all modules after loading and instantiating them, then stop.").bool("dependencies", "optionDependencies", false, "Print module dependencies after loading and instantiating, then stop.").bool("applied", "optionApplied", false, "Print all modules after applying modifications, then stop.").bool("valued", "optionValued", false, "Print grammar after reducing it to expressions that directly contribute to AST, then stop.").bool("processed", "optionProcessed", false, "Print full grammar before code generation, then stop.").bool("html", "optionHtml", false, "Create HTML for instantiated, applied, valued, or processed options.").bool("variant", "optionVariant", false, "Enforce variant types for productions having node values.").bool("ast", "optionASTDefinition", false, "Print a formal definition of the grammar's AST, then stop.").bool("lgpl", "optionLGPL", false, "Create an LGPL compliant parser.").att("option", "grammarOption", true, "Add the specified attribute to the grammar's options.").bool("Onone", "doNotOptimize", false, "Perform no optimizations.").bool("Ochunks", "optimizeChunks", true, "Break memoization table into chunks.").bool("Ogrammar", "optimizeGrammar", true, "Fold duplicate productions and eliminate dead productions.").bool("Oterminals", "optimizeTerminals", true, "Optimize the recognition of terminals, incl. by using switches.").bool("Ocost", "optimizeCost", true, "Perform cost-based inlining.").bool("Otransient", "optimizeTransient", true, "Do not memoize transient productions.").bool("Onontransient", "optimizeNonTransient", true, "Mark suitable productions as transient.").bool("Orepeated", "optimizeRepeated", true, "Do not desugar transient repetitions.").bool("Oleft1", "optimizeLeftRecursions", false, "Convert direct left-recursions into equivalent right-recursions.").bool("Oleft2", "optimizeLeftIterations", true, "Convert direct left-recursions into equivalent iterations.").bool("Ooptional", "optimizeOptional", true, "Do not desugar options.").bool("Ochoices1", "optimizeChoices1", true, "Inline transient void or text-only productions into choices.").bool("Ochoices2", "optimizeChoices2", true, "Inline productions with the inline attribute into choices.").bool("Oerrors1", "optimizeErrors1", true, "Avoid creating parse errors for individual terms.").bool("Oerrors2", "optimizeErrors2", false, "Avoid creating parse errors for transient productions.").bool("Oselect", "optimizeSelect", true, "Optimize the selection of parse errors.").bool("Ovalues", "optimizeValues", true, "Avoid creating duplicate semantic values.").bool("Omatches", "optimizeMatches", true, "Optimize the performance of string matches.").bool("Oprefixes", "optimizePrefixes", true, "Fold common prefixes in choices.").bool("Ognodes", "optimizeGenericNodes", true, "Optimize the creation of generic nodes.").bool("Olocation", "optimizeLocation", true, "Optimize the annotation of nodes with their source locations.");
    }

    public void prepare() {
        boolean bl;
        boolean bl2 = this.runtime.hasPrefixValue("optimize");
        boolean bl3 = bl = this.runtime.hasValue("doNotOptimize") && this.runtime.test("doNotOptimize");
        if (bl2 && bl) {
            this.runtime.error("no optimizations incompatible with explicitly specified optimizations");
        }
        if (this.runtime.hasValue("optimizeLeftRecursions") && this.runtime.test("optimizeLeftRecursions") && this.runtime.hasValue("optimizeLeftIterations") && this.runtime.test("optimizeLeftIterations")) {
            this.runtime.error("left1 option mutually exclusive with left2 option");
        }
        if (bl2 || bl) {
            this.runtime.initFlags("optimize", false);
        }
        this.runtime.initDefaultValues();
        if (this.runtime.test("optionSilent") && this.runtime.test("optionVerbose")) {
            this.runtime.error("can't run in silent and verbose mode at the same time");
        }
        if (this.runtime.test("optionLoaded")) {
            if (this.runtime.test("optionInstantiated")) {
                this.runtime.error("loaded option incompatible with instantiated option");
            }
            if (this.runtime.test("optionApplied")) {
                this.runtime.error("loaded option incompatible with applied option");
            }
            if (this.runtime.test("optionValued")) {
                this.runtime.error("loaded option incompatiable with valued option");
            }
            if (this.runtime.test("optionProcessed")) {
                this.runtime.error("loaded option incompatible with processed option");
            }
            if (this.runtime.test("optionASTDefinition")) {
                this.runtime.error("loaded option incompatible with ast option");
            }
        }
        if (this.runtime.test("optionInstantiated")) {
            if (this.runtime.test("optionApplied")) {
                this.runtime.error("instantiated option incompatible with applied option");
            }
            if (this.runtime.test("optionValued")) {
                this.runtime.error("instantiated option incompatible with valued option");
            }
            if (this.runtime.test("optionProcessed")) {
                this.runtime.error("instantiated option incompatible with processed option");
            }
            if (this.runtime.test("optionASTDefinition")) {
                this.runtime.error("instantiated option incompatible with ast option");
            }
        }
        if (this.runtime.test("optionApplied")) {
            if (this.runtime.test("optionValued")) {
                this.runtime.error("applied option incompatible with valued option");
            }
            if (this.runtime.test("optionProcessed")) {
                this.runtime.error("applied option incompatible with processed option");
            }
            if (this.runtime.test("optionASTDefinition")) {
                this.runtime.error("applied option incompatible with ast option");
            }
        }
        if (this.runtime.test("optionValued")) {
            if (this.runtime.test("optionProcessed")) {
                this.runtime.error("valued option incompatible with processed option");
            }
            if (this.runtime.test("optionASTDefinition")) {
                this.runtime.error("valued option incompatible with ast option");
            }
        }
        if (this.runtime.test("optionProcessed") && this.runtime.test("optionASTDefinition")) {
            this.runtime.error("processed option incompatible with ast option");
        }
        if (this.runtime.test("optionHtml")) {
            if (this.runtime.test("optionLoaded")) {
                this.runtime.error("loaded option incompatible with html option");
            } else if (!(this.runtime.test("optionInstantiated") || this.runtime.test("optionApplied") || this.runtime.test("optionValued") || this.runtime.test("optionProcessed"))) {
                this.runtime.error("html option requires instantiated, applied, valued or processed option");
            }
        }
    }

    public Node parse(Reader reader, File file) throws IOException, ParseException {
        long l = file.length();
        if (Integer.MAX_VALUE < l) {
            throw new IllegalArgumentException(file + ": file too large");
        }
        PParser pParser = new PParser(reader, file.toString(), (int)l);
        Result result2 = pParser.pModule(0);
        Module module = (Module)pParser.value(result2);
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (-1 != n) {
            string = string.substring(0, n);
        }
        if (!string.equals(Utilities.unqualify(module.name.name))) {
            this.runtime.error("module name '" + module.name.name + "' inconsistent with file name '" + file + "'", module.name);
        }
        return module;
    }

    public void process(Node node) {
        Printer printer;
        Module module = (Module)node;
        Analyzer analyzer = new Analyzer();
        JavaAST javaAST = new JavaAST();
        Simplifier simplifier = new Simplifier(this.runtime, analyzer);
        DeadProductionEliminator deadProductionEliminator = new DeadProductionEliminator(this.runtime, analyzer);
        DuplicateProductionFolder duplicateProductionFolder = new DuplicateProductionFolder(this.runtime, analyzer);
        PrefixFolder prefixFolder = new PrefixFolder(this.runtime, analyzer);
        MetaDataCreator metaDataCreator = new MetaDataCreator();
        ReferenceCounter referenceCounter = new ReferenceCounter(this.runtime, analyzer);
        TransientMarker transientMarker = new TransientMarker(this.runtime, analyzer);
        Inliner inliner = new Inliner(this.runtime, analyzer);
        if (null == module.attributes) {
            module.attributes = new ArrayList<Attribute>();
        }
        module.attributes.addAll(this.runtime.getAttributeList("grammarOption"));
        module = (Module)new Resolver(this.runtime, analyzer, javaAST).dispatch(module);
        if (this.runtime.test("optionLoaded") || this.runtime.test("optionApplied") || null == module) {
            return;
        }
        if (module.hasAttribute(Constants.ATT_GENERIC_AS_VOID)) {
            new GenericVoider(this.runtime, analyzer).dispatch(module);
        }
        new RootFinder(this.runtime, analyzer).dispatch(module);
        simplifier.dispatch(module);
        if (this.runtime.test("optimizeGrammar")) {
            deadProductionEliminator.dispatch(module);
        }
        new ElementVoider(this.runtime, analyzer).dispatch(module);
        if (this.runtime.test("optionVariant")) {
            new VariantSorter(this.runtime, analyzer, javaAST).dispatch(module);
            if (0 < this.runtime.errorCount()) {
                return;
            }
        }
        if (this.runtime.test("optimizeGrammar") && !this.runtime.test("optionASTDefinition")) {
            duplicateProductionFolder.dispatch(module);
        }
        if (this.runtime.test("optimizePrefixes")) {
            prefixFolder.dispatch(module);
        }
        boolean bl = false;
        do {
            if (bl = ((Boolean)inliner.dispatch(module)).booleanValue()) {
                simplifier.dispatch(module);
                if (this.runtime.test("optimizeGrammar")) {
                    deadProductionEliminator.dispatch(module);
                }
                if (this.runtime.test("optimizePrefixes")) {
                    prefixFolder.dispatch(module);
                }
            }
            if (!this.runtime.test("optimizeNonTransient")) continue;
            metaDataCreator.dispatch(module);
            referenceCounter.dispatch(module);
            transientMarker.dispatch(module);
        } while (bl);
        if (module.hasAttribute(Constants.ATT_PARSE_TREE)) {
            new Tokenizer(this.runtime, analyzer).dispatch(module);
            new Annotator(this.runtime, analyzer).dispatch(module);
        }
        new Transformer(this.runtime, analyzer, javaAST).dispatch(module);
        if (!this.runtime.test("optionValued")) {
            new ListMaker(this.runtime, analyzer, javaAST).dispatch(module);
            new DirectLeftRecurser(this.runtime, analyzer, javaAST).dispatch(module);
            new Generifier(this.runtime, analyzer).dispatch(module);
            new ValueChecker(this.runtime, analyzer).dispatch(module);
        }
        if (0 < this.runtime.errorCount()) {
            return;
        }
        if (this.runtime.test("optionValued")) {
            new TreeExtractor(this.runtime, analyzer, javaAST, false).dispatch(module);
            if (this.runtime.test("optionHtml")) {
                new HtmlPrinter(this.runtime, analyzer, javaAST, true).dispatch(module);
            } else {
                new PrettyPrinter(this.runtime.console(), javaAST, true).dispatch(module);
                this.runtime.console().flush();
            }
            return;
        }
        if (this.runtime.test("optimizeChoices1") || this.runtime.test("optimizeChoices2")) {
            metaDataCreator.dispatch(module);
            referenceCounter.dispatch(module);
            new ChoiceExpander(this.runtime, analyzer).dispatch(module);
        }
        if (this.runtime.test("optimizeTerminals")) {
            new ProductionVoider(this.runtime, analyzer).dispatch(module);
            new TerminalOptimizer(this.runtime, analyzer).dispatch(module);
        }
        if (this.runtime.test("optimizePrefixes")) {
            prefixFolder.dispatch(module);
        }
        if (this.runtime.test("optimizeGrammar")) {
            deadProductionEliminator.dispatch(module);
            if (!this.runtime.test("optionASTDefinition")) {
                duplicateProductionFolder.dispatch(module);
            }
        }
        if (this.runtime.test("optimizePrefixes")) {
            new ReachabilityChecker(this.runtime, analyzer).dispatch(module);
            if (0 < this.runtime.errorCount()) {
                return;
            }
        }
        metaDataCreator.dispatch(module);
        referenceCounter.dispatch(module);
        if (this.runtime.test("optimizeNonTransient")) {
            transientMarker.dispatch(module);
        }
        new MetaDataSetter(this.runtime, analyzer, javaAST).dispatch(module);
        if (0 < this.runtime.errorCount()) {
            return;
        }
        if (this.runtime.test("optionASTDefinition")) {
            new TreeTyper(this.runtime, analyzer, javaAST).dispatch(module);
            return;
        }
        if (this.runtime.test("optionProcessed")) {
            if (this.runtime.test("optionHtml")) {
                new HtmlPrinter(this.runtime, analyzer, javaAST, true).dispatch(module);
            } else {
                new PrettyPrinter(this.runtime.console(), javaAST, true).dispatch(module);
                this.runtime.console().flush();
            }
            return;
        }
        File file = new File(this.runtime.getOutputDirectory(), Utilities.getName(module.getClassName()) + ".java");
        try {
            printer = new Printer(new PrintWriter(this.runtime.getWriter(file)));
        }
        catch (IOException iOException) {
            if (null == iOException.getMessage()) {
                this.runtime.error(file.toString() + ": I/O error");
            } else {
                this.runtime.error(file.toString() + ": " + iOException.getMessage());
            }
            return;
        }
        this.printHeader(printer);
        new CodeGenerator(this.runtime, analyzer, javaAST, printer).dispatch(module);
        printer.flush().close();
    }

    public static void main(String[] stringArray) {
        new Rats().run(stringArray);
    }
}

