/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.HashSet;
import java.util.Set;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.UnaryOperator;
import xtc.parser.VoidedElement;
import xtc.tree.Visitor;
import xtc.util.Runtime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeftRecurser
extends Visitor {
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected boolean terminated;

    public LeftRecurser(Runtime runtime, Analyzer analyzer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
    }

    public Set<NonTerminal> recursive() {
        return new HashSet<NonTerminal>(this.analyzer.marked());
    }

    public void visit(Grammar grammar) {
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        for (Module module : grammar.modules) {
            this.analyzer.process(module);
            for (Production production : module.productions) {
                if (!production.isFull() || this.analyzer.isProcessed(production.qName)) continue;
                this.terminated = false;
                this.analyzer.process(production);
            }
        }
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        for (Production production : module.productions) {
            if (this.analyzer.isProcessed(production.qName)) continue;
            this.terminated = false;
            this.analyzer.process(production);
        }
    }

    public void visit(FullProduction fullProduction) {
        Object object = this.analyzer.enter(fullProduction);
        this.analyzer.workingOn(fullProduction.qName);
        if ((this.runtime.test("optimizeLeftRecursions") || this.runtime.test("optimizeLeftIterations")) && DirectLeftRecurser.isTransformable(fullProduction)) {
            for (Sequence sequence : fullProduction.choice.alternatives) {
                if (!DirectLeftRecurser.isBase(sequence, fullProduction)) continue;
                this.dispatch(sequence);
            }
        } else {
            this.dispatch(fullProduction.choice);
        }
        this.analyzer.notWorkingOn(fullProduction.qName);
        this.analyzer.exit(object);
        this.analyzer.processed(fullProduction.qName);
    }

    public void visit(OrderedChoice orderedChoice) {
        boolean bl = false;
        for (Sequence sequence : orderedChoice.alternatives) {
            this.terminated = false;
            this.dispatch(sequence);
            if (this.terminated) continue;
            bl = true;
        }
        if (bl) {
            this.terminated = false;
        }
    }

    public void visit(Repetition repetition) {
        this.dispatch(repetition.element);
        if (!repetition.once) {
            this.terminated = false;
        }
    }

    public void visit(Sequence sequence) {
        for (Element element : sequence.elements) {
            this.dispatch(element);
            if (!this.terminated) continue;
            break;
        }
    }

    public void visit(VoidedElement voidedElement) {
        this.dispatch(voidedElement.element);
    }

    public void visit(Binding binding) {
        this.dispatch(binding.element);
    }

    public void visit(StringMatch stringMatch) {
        this.dispatch(stringMatch.element);
    }

    public void visit(NonTerminal nonTerminal) {
        FullProduction fullProduction;
        try {
            fullProduction = this.analyzer.lookup(nonTerminal);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.terminated = true;
            return;
        }
        if (null != fullProduction) {
            if (this.analyzer.isBeingWorkedOn(fullProduction.qName)) {
                this.analyzer.mark(fullProduction.qName);
                fullProduction.setProperty("recursive", Boolean.TRUE);
                this.terminated = true;
            } else if (!this.analyzer.isProcessed(fullProduction.qName)) {
                this.dispatch(fullProduction);
            } else {
                this.terminated = true;
            }
        } else {
            this.terminated = true;
        }
    }

    public void visit(Terminal terminal) {
        this.terminated = true;
    }

    public void visit(UnaryOperator unaryOperator) {
        this.dispatch(unaryOperator.element);
        this.terminated = false;
    }

    public void visit(ParserAction parserAction) {
        this.dispatch(parserAction.element);
        this.terminated = true;
    }

    public void visit(Element element) {
    }
}

