/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.CostEstimator;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Generifier;
import xtc.parser.GrammarVisitor;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.Production;
import xtc.type.AST;
import xtc.util.Runtime;

public class Inliner
extends GrammarVisitor {
    public static final int MAX_COST = 1;
    public static final boolean INLINE_PERSISTENT = true;
    protected boolean attributeState;
    protected boolean inlined;

    public Inliner(Runtime runtime, Analyzer analyzer) {
        super(runtime, analyzer);
    }

    protected boolean isBasic(Production production) {
        return AST.isVoid(production.type) || production.getBooleanProperty("textOnly") || production.getBooleanProperty("token");
    }

    protected void inlined(Production production) {
        this.inlined = true;
        if (this.runtime.test("optionVerbose")) {
            System.err.println("[Inlining " + production.qName + " into " + this.analyzer.current().qName + "]");
        }
    }

    public Object visit(Module module) {
        CostEstimator costEstimator = null;
        boolean bl = false;
        if (this.runtime.test("optimizeCost")) {
            costEstimator = new CostEstimator(this.analyzer);
        }
        do {
            if (this.runtime.test("optimizeCost")) {
                costEstimator.dispatch(module);
            }
            this.analyzer.register(this);
            this.analyzer.init(module);
            this.attributeState = module.hasAttribute(Constants.ATT_STATEFUL.getName());
            this.inlined = false;
            for (Production production : module.productions) {
                this.analyzer.process(production);
            }
            if (!this.inlined) continue;
            bl = true;
        } while (this.inlined);
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Element visit(NonTerminal nonTerminal) {
        boolean bl = this.isBound;
        this.isBound = false;
        FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
        if (Generifier.isGeneric(fullProduction) || AST.isList(fullProduction.type) || this.attributeState && (fullProduction.hasAttribute(Constants.ATT_STATEFUL) || fullProduction.hasAttribute(Constants.ATT_RESETTING))) {
            return nonTerminal;
        }
        Element element = Analyzer.strip(fullProduction.choice);
        if (element instanceof NonTerminal) {
            if (!fullProduction.isMemoized() && !fullProduction.hasAttribute(Constants.ATT_NO_INLINE)) {
                this.inlined(fullProduction);
                NonTerminal nonTerminal2 = new NonTerminal((NonTerminal)element);
                nonTerminal2.setLocation(nonTerminal);
                return nonTerminal2;
            }
            return nonTerminal;
        }
        if (element instanceof Binding) {
            Binding binding = (Binding)element;
            Element element2 = Analyzer.strip(binding.element);
            if ("yyValue".equals(binding.name) && element2 instanceof NonTerminal) {
                if (!fullProduction.isMemoized() && !fullProduction.hasAttribute(Constants.ATT_NO_INLINE)) {
                    this.inlined(fullProduction);
                    NonTerminal nonTerminal3 = new NonTerminal((NonTerminal)element2);
                    nonTerminal3.setLocation(nonTerminal);
                    return nonTerminal3;
                }
                return nonTerminal;
            }
        }
        if (!this.isBasic(this.analyzer.current()) || bl) {
            return nonTerminal;
        }
        if (this.runtime.test("optimizeCost") && 1 >= (Integer)fullProduction.getProperty("cost") && !fullProduction.hasAttribute(Constants.ATT_NO_INLINE)) {
            this.inlined(fullProduction);
            return this.analyzer.copy(fullProduction.choice);
        }
        return nonTerminal;
    }
}

