/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.ModuleDependency;
import xtc.parser.ModuleName;
import xtc.parser.NonTerminal;
import xtc.parser.PrettyPrinter;
import xtc.parser.Production;
import xtc.parser.Properties;
import xtc.parser.SequenceName;
import xtc.parser.StringValue;
import xtc.parser.TokenValue;
import xtc.tree.Attribute;
import xtc.tree.Comment;
import xtc.tree.Node;
import xtc.tree.Printer;
import xtc.tree.VisitingException;
import xtc.type.AST;
import xtc.util.Runtime;

public class HtmlPrinter
extends PrettyPrinter {
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected boolean isGrammar;
    protected int pNumber = -1;

    public HtmlPrinter(Runtime runtime, Analyzer analyzer, AST aST, boolean bl) {
        super(aST, bl);
        this.runtime = runtime;
        this.analyzer = analyzer;
    }

    protected int stringEscapes() {
        return 24;
    }

    protected int regexEscapes() {
        return 28;
    }

    protected void open(String string) throws IOException {
        File file = new File(this.runtime.getOutputDirectory(), string);
        this.printer = new Printer(new PrintWriter(this.runtime.getWriter(file)));
    }

    protected void printDocumentation(Module module) {
        Comment comment = module.documentation;
        if (!this.verbose || null == comment || comment.text.isEmpty()) {
            return;
        }
        this.printer.indent().pln("<div class=\"module-documentation\">");
        ArrayList<String> arrayList = null;
        String string = null;
        for (String string2 : comment.text) {
            if (string2.startsWith("@")) {
                if (string2.startsWith("@author ")) {
                    if (null == arrayList) {
                        arrayList = new ArrayList<String>();
                    }
                    arrayList.add(string2.substring(8));
                    continue;
                }
                if (!string2.startsWith("@version ")) continue;
                string = string2.substring(9);
                continue;
            }
            this.printer.indent().pln(string2);
        }
        if (null != arrayList || null != string) {
            this.printer.indent().pln("<dl>");
            if (null != arrayList) {
                if (1 == arrayList.size()) {
                    this.printer.indent().pln("<dt>Author:</dt>").incr();
                } else {
                    this.printer.indent().pln("<dt>Authors:</dt>").incr();
                }
                this.printer.indent().p("<dd>");
                Iterator<String> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    this.printer.p(iterator.next());
                    if (!iterator.hasNext()) continue;
                    this.printer.p(", ");
                }
                this.printer.pln("</dd>").decr();
            }
            if (null != string) {
                this.printer.indent().pln("<dt>Version:</dt>").incr();
                this.printer.indent().p("<dd>").p(string).pln("</dd>").decr();
            }
            this.printer.indent().pln("</dl>");
        }
        this.printer.indent().pln("</div>");
    }

    protected void printOption(Module module) {
        if (null != module.attributes && 0 < module.attributes.size()) {
            this.printer.pln().indent().p("option ");
            boolean bl = true;
            Iterator<Attribute> iterator = module.attributes.iterator();
            while (iterator.hasNext()) {
                int n;
                boolean bl2;
                Attribute attribute = iterator.next();
                String string = attribute.getName();
                String string2 = attribute.toString();
                boolean bl3 = bl2 = this.analyzer.isTopLevel(module) || Constants.ATT_STATEFUL.getName().equals(string) || "setOfString".equals(string) || "flag".equals(string);
                if (bl) {
                    bl = false;
                } else if (this.printer.column() + string2.length() + 1 > 78) {
                    this.printer.pln().indentMore();
                }
                if (bl2) {
                    n = this.printer.column();
                    this.printer.p("<span class=\"highlight\">").column(n);
                }
                this.printer.p(string2);
                if (bl2) {
                    n = this.printer.column();
                    this.printer.p("</span>").column(n);
                }
                if (iterator.hasNext()) {
                    this.printer.p(", ");
                    continue;
                }
                this.printer.p(';');
            }
            this.printer.pln();
        }
    }

    protected void print(Module module) {
        this.printer.indent().pln("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"");
        this.printer.indent().p("                      ").pln("\"http://www.w3.org/TR/html4/strict.dtd\">");
        this.printer.indent().pln("<html>");
        this.printer.indent().pln("<head>");
        this.printer.indent().p("<!-- Generated by Rats!, version ").p("1.14.1").p(", ").p("(C) 2004-2008 Robert Grimm").pln(" -->");
        this.printer.indent().p("<title>Module ").p(module.name).pln("</title>");
        this.printer.indent().p("<link rel=\"stylesheet\" href=\"grammar.css\" ").pln("type=\"text/css\">");
        this.printer.indent().pln("</head>");
        this.printer.indent().pln("<body>");
        this.printDocumentation(module);
        this.printer.indent().pln("<pre class=\"module-header\">");
        this.printModule(module);
        if (null != module.dependencies && 0 < module.dependencies.size()) {
            this.printer.pln();
            for (ModuleDependency moduleDependency : module.dependencies) {
                this.printer.p(moduleDependency);
            }
        }
        this.printActions(module);
        this.printOption(module);
        this.printer.indent().pln("</pre>");
        int n = module.productions.size();
        for (int i = 0; i < n; ++i) {
            this.pNumber = i;
            this.printer.p(module.productions.get(i));
        }
        this.printer.indent().pln("</body>");
    }

    public void visit(Grammar grammar) {
        this.analyzer.register(this);
        this.analyzer.init(grammar);
        this.isGrammar = true;
        for (Module module : grammar.modules) {
            try {
                this.open(module.name + ".html");
            }
            catch (IOException iOException) {
                throw new VisitingException("Unable to access " + module.name + ".html", iOException);
            }
            this.printer.register(this);
            this.analyzer.process(module);
            this.print(module);
            this.printer.flush();
        }
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        this.isGrammar = false;
        try {
            this.open(module.name + ".html");
        }
        catch (IOException iOException) {
            throw new VisitingException("Unable to access " + module.name + ".html", iOException);
        }
        this.printer.register(this);
        this.print(module);
        this.printer.flush();
    }

    protected void print(ModuleName moduleName, boolean bl) {
        int n;
        if (bl) {
            n = this.printer.column();
            this.printer.p("<a href=\"").p(moduleName.name).p(".html\">").column(n).p(moduleName.name);
        } else {
            n = this.printer.column();
            this.printer.p("<a class=\"erroneous\" href=\"#\" title=\"Undefined module\">").column(n).p(moduleName.name);
        }
        n = this.printer.column();
        this.printer.p("</a>").column(n);
    }

    protected void print(ModuleDependency moduleDependency, String string) {
        Module module = this.analyzer.lookup(moduleDependency.visibleName());
        this.printer.indent().p(string).p(' ');
        if (!(null != moduleDependency.target || null == module && "instantiate".equals(string))) {
            this.print(moduleDependency.module, null != module);
        } else {
            this.printer.p(moduleDependency.module);
        }
        if (0 != moduleDependency.arguments.size()) {
            this.printer.p(moduleDependency.arguments);
        }
        if (!(null == moduleDependency.target || null == module && "instantiate".equals(string))) {
            this.print(moduleDependency.target, null != module);
        } else {
            this.printer.p(moduleDependency.target);
        }
        this.printer.pln(';');
    }

    /*
     * WARNING - void declaration
     */
    protected void enter(Production production) {
        Object object;
        if (this.verbose && production.hasProperty("duplicates")) {
            List<String> list = Properties.getDuplicates(production);
            this.printer.indent().pln("<div class=\"production-documentation\">");
            this.printer.indent().p("The following production is the result of ").p("folding duplicates ");
            Iterator<String> object22 = list.iterator();
            while (object22.hasNext()) {
                object = object22.next();
                this.printer.buffer();
                if (1 < list.size() && !object22.hasNext()) {
                    this.printer.p("and ");
                }
                this.printer.p((String)object);
                if (2 == list.size() && object22.hasNext()) {
                    this.printer.p(' ');
                } else if (object22.hasNext()) {
                    this.printer.p(", ");
                } else {
                    this.printer.p('.');
                }
                this.printer.fit();
            }
            this.printer.pln();
            this.printer.indent().pln("</div>");
        }
        this.printer.indent().pln("<pre class=\"production-body\">");
        this.printer.indent();
        if (production.isFull()) {
            this.printer.p("<a name=\"").p(production.name.name).p("\"></a>");
        } else {
            this.printer.p("<a name=\"").p(production.name.name).p('-').p(this.pNumber).p("\"></a>");
        }
        if (null != production.attributes && 0 < production.attributes.size()) {
            for (Attribute attribute : production.attributes) {
                this.printer.p((Node)attribute).p(' ');
            }
        }
        if (null != production.type) {
            if (AST.isVoid(production.type)) {
                this.printer.p("void ");
            } else if (AST.isGenericNode(production.type)) {
                this.printer.p("generic ");
            } else {
                this.printer.p(this.ast.extern(production.type)).p(' ');
            }
        } else if (null != production.dType) {
            this.printer.p(production.dType).p(' ');
        }
        if (production.isPartial()) {
            void var3_9;
            boolean bl = false;
            Object var3_7 = null;
            try {
                FullProduction fullProduction = this.analyzer.lookup(production.name.qualify(this.analyzer.currentModule().name.name));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = true;
            }
            if (null == var3_9) {
                this.printer.p("<a class=\"erroneous\" href=\"#\" title=\"");
                if (bl) {
                    this.printer.p("Ambiguous nonterminal");
                } else {
                    this.printer.p("Undefined nonterminal");
                }
            } else {
                object = this.analyzer.currentModule();
                String string = var3_9.qName.getQualifier();
                if (string.equals(((Module)object).name.name)) {
                    this.printer.p("<a href=\"#").p(production.name.name);
                } else {
                    this.printer.p("<a href=\"").p(string).p(".html#").p(production.name.name);
                }
            }
            this.printer.p("\">").p(production.name.name).p("</a>");
        } else {
            this.printer.p(production.name.name);
        }
        this.parenChoice = false;
        this.parenSequence = false;
    }

    protected void exit(Production production) {
        this.printer.indent().pln("</pre>");
    }

    public void visit(SequenceName sequenceName) {
        this.printer.p("&lt;").p(sequenceName.name).p("&gt;");
        this.printer.column(this.printer.column() - 6);
    }

    public void visit(NonTerminal nonTerminal) {
        if (this.newline) {
            this.printer.indent();
        }
        this.newline = false;
        this.printer.buffer();
        int n = this.printer.column();
        boolean bl = false;
        FullProduction fullProduction = null;
        try {
            fullProduction = this.analyzer.lookup(nonTerminal);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        if (null == fullProduction) {
            this.printer.p("<a class=\"erroneous\" href=\"#\" title=\"");
            if (bl) {
                this.printer.p("Ambiguous nonterminal");
            } else {
                this.printer.p("Undefined nonterminal");
            }
        } else if (this.isGrammar) {
            Module module = this.analyzer.currentModule();
            String string = fullProduction.qName.getQualifier();
            if (string.equals(module.name.name)) {
                this.printer.p("<a href=\"#").p(fullProduction.name.name);
            } else {
                this.printer.p("<a href=\"").p(string).p(".html#").p(fullProduction.name.name);
            }
        } else {
            this.printer.p("<a href=\"#").p(nonTerminal.name);
        }
        this.printer.p("\">").column(n).p(nonTerminal.name);
        n = this.printer.column();
        this.printer.p("</a>").column(n).fit();
    }

    protected void print(String string) {
        int n = this.printer.column();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                this.printer.p("&lt;");
                continue;
            }
            if ('>' == c) {
                this.printer.p("&gt;");
                continue;
            }
            this.printer.p(c);
        }
        this.printer.column(n + n2);
    }

    public void visit(StringValue stringValue) {
        if (null == stringValue.text) {
            if (this.newline) {
                this.printer.indent();
            }
            this.newline = false;
            this.printer.buffer().p("/* value = &lt;text&gt;; */").column(this.printer.column() - 6).fit();
        } else {
            this.format(false, stringValue.text);
        }
    }

    public void visit(TokenValue tokenValue) {
        if (null == tokenValue.text) {
            if (this.newline) {
                this.printer.indent();
            }
            this.newline = false;
            this.printer.buffer().p("/* value = Token(&lt;text&gt;); */").column(this.printer.column() - 6).fit();
        } else {
            this.format(true, tokenValue.text);
        }
    }
}

