/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.List;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GenericNodeValue;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NullLiteral;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParseTreeNode;
import xtc.parser.Production;
import xtc.parser.Properties;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.util.Runtime;
import xtc.util.Utilities;

public class Generifier
extends Visitor {
    public static final String MARKER = "g";
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected List<Binding> children;
    protected List<NodeMarker> markers;

    public Generifier(Runtime runtime, Analyzer analyzer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.children = new ArrayList<Binding>();
        this.markers = new ArrayList<NodeMarker>();
    }

    protected Binding bind(Element element) {
        Binding binding = new Binding(this.analyzer.variable(MARKER), element);
        this.children.add(binding);
        return binding;
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        for (Production production : module.productions) {
            if (!Generifier.isGenericNode((FullProduction)production)) continue;
            this.analyzer.process(production);
        }
    }

    public void visit(FullProduction fullProduction) {
        fullProduction.choice = (OrderedChoice)this.dispatch(fullProduction.choice);
        if (AST.isDynamicNode(fullProduction.type)) {
            fullProduction.type = AST.NODE;
        }
        Generifier.markGenericNode(fullProduction, this.runtime.test("optionVerbose"));
    }

    public Element visit(OrderedChoice orderedChoice) {
        int n = orderedChoice.alternatives.size();
        for (int i = 0; i < n; ++i) {
            Sequence sequence = orderedChoice.alternatives.get(i);
            if (Analyzer.setsValue(sequence, true)) continue;
            orderedChoice.alternatives.set(i, (Sequence)this.dispatch(sequence));
        }
        return orderedChoice;
    }

    public Element visit(Repetition repetition) {
        return this.bind(repetition);
    }

    public Element visit(Option option) {
        return this.bind(option);
    }

    public Element visit(Sequence sequence) {
        int n = this.children.size();
        int n2 = this.markers.size();
        int n3 = sequence.size();
        for (int i = 0; i < n3; ++i) {
            sequence.elements.set(i, (Element)this.dispatch(sequence.get(i)));
        }
        if (!sequence.hasTrailingChoice()) {
            String string = this.analyzer.current().qName.name;
            if (!this.markers.isEmpty()) {
                string = Utilities.qualify(Utilities.getQualifier(string), this.markers.get((int)(this.markers.size() - 1)).name);
            }
            List<Binding> list = sequence.hasProperty("formatting") ? Properties.getFormatting(sequence) : new ArrayList<Binding>(0);
            sequence.add(new GenericNodeValue(string, new ArrayList<Binding>(this.children), list));
        }
        if (0 == n) {
            this.children.clear();
        } else {
            this.children.subList(n, this.children.size()).clear();
        }
        if (0 == n2) {
            this.markers.clear();
        } else {
            this.markers.subList(n2, this.markers.size()).clear();
        }
        return sequence;
    }

    public Element visit(Binding binding) {
        this.children.add(binding);
        return binding;
    }

    public Element visit(StringMatch stringMatch) {
        return this.bind(stringMatch);
    }

    public Element visit(NonTerminal nonTerminal) {
        FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
        if (AST.isVoid(fullProduction.type)) {
            return nonTerminal;
        }
        return this.bind(nonTerminal);
    }

    public Element visit(StringLiteral stringLiteral) {
        return this.bind(stringLiteral);
    }

    public Element visit(ParseTreeNode parseTreeNode) {
        return this.bind(parseTreeNode);
    }

    public Element visit(NullLiteral nullLiteral) {
        return this.bind(nullLiteral);
    }

    public Element visit(NodeMarker nodeMarker) {
        this.markers.add(nodeMarker);
        return nodeMarker;
    }

    public Element visit(Element element) {
        return element;
    }

    public static void markGenericNode(FullProduction fullProduction, boolean bl) {
        if (bl) {
            System.err.println("[Recognizing " + fullProduction.qName + " as generic node]");
        }
        fullProduction.setProperty("generic", "node");
    }

    public static void markGenericRecursion(FullProduction fullProduction, boolean bl) {
        if (bl) {
            System.err.println("[Recognizing " + fullProduction.qName + " as generic recursion]");
        }
        fullProduction.setProperty("generic", "recursion");
    }

    public static boolean isGeneric(FullProduction fullProduction) {
        if (fullProduction.hasProperty("generic")) {
            Object object = fullProduction.getProperty("generic");
            return "node".equals(object) || "recursion".equals(object);
        }
        return AST.isGenericNode(fullProduction.type);
    }

    public static boolean isGenericNode(FullProduction fullProduction) {
        if (fullProduction.hasProperty("generic")) {
            return "node".equals(fullProduction.getProperty("generic"));
        }
        return AST.isGenericNode(fullProduction.type) && !DirectLeftRecurser.isTransformable(fullProduction);
    }

    public static boolean isGenericRecursion(FullProduction fullProduction) {
        if (fullProduction.hasProperty("generic")) {
            return "recursion".equals(fullProduction.getProperty("generic"));
        }
        return AST.isGenericNode(fullProduction.type) && DirectLeftRecurser.isTransformable(fullProduction);
    }
}

