/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.Quantification;
import xtc.parser.Sequence;
import xtc.parser.StringMatch;
import xtc.parser.VoidedElement;
import xtc.tree.Location;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.util.Runtime;

public class ElementVoider
extends Visitor {
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected boolean isTopLevel;
    protected boolean isLastElement;
    protected boolean suppressVoided;
    protected boolean hasValue;

    public ElementVoider(Runtime runtime, Analyzer analyzer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
    }

    protected Element wrap(Element element) {
        VoidedElement voidedElement = new VoidedElement(element);
        Location location = element.getLocation();
        voidedElement.setLocation(location);
        if (this.runtime.test("optionVerbose")) {
            System.err.println("[Voiding expression at " + location.line + ":" + location.column + " in " + this.analyzer.current().qName + "]");
        }
        return voidedElement;
    }

    public void visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        for (Production production : module.productions) {
            this.analyzer.process(production);
        }
    }

    public void visit(FullProduction fullProduction) {
        if (fullProduction.getBooleanProperty("textOnly") || fullProduction.getBooleanProperty("token")) {
            return;
        }
        this.isTopLevel = true;
        this.isLastElement = false;
        this.suppressVoided = AST.isVoid(fullProduction.type);
        this.hasValue = false;
        fullProduction.choice = (OrderedChoice)this.dispatch(fullProduction.choice);
    }

    public Element visit(OrderedChoice orderedChoice) {
        boolean bl = this.isTopLevel;
        this.isTopLevel = false;
        boolean bl2 = this.isLastElement;
        boolean bl3 = this.hasValue;
        if (!bl && !bl2) {
            this.hasValue = false;
        }
        int n = orderedChoice.alternatives.size();
        for (int i = 0; i < n; ++i) {
            this.isLastElement = bl || bl2;
            orderedChoice.alternatives.set(i, (Sequence)this.dispatch(orderedChoice.alternatives.get(i)));
        }
        this.isLastElement = false;
        Element element = orderedChoice;
        if (!bl && !bl2) {
            if (this.hasValue) {
                this.hasValue = true;
            } else {
                this.hasValue = bl3;
                if (!this.suppressVoided) {
                    element = this.wrap(element);
                }
            }
        }
        return element;
    }

    public Element visit(Quantification quantification) {
        this.isTopLevel = false;
        this.isLastElement = true;
        boolean bl = this.hasValue;
        this.hasValue = false;
        quantification.element = (Element)this.dispatch(quantification.element);
        this.isLastElement = false;
        Element element = quantification;
        if (this.hasValue) {
            this.hasValue = true;
        } else {
            this.hasValue = bl;
            if (!this.suppressVoided) {
                element = this.wrap(element);
            }
        }
        return element;
    }

    public Element visit(Sequence sequence) {
        this.isTopLevel = false;
        boolean bl = this.isLastElement;
        int n = sequence.size();
        for (int i = 0; i < n; ++i) {
            this.isLastElement = bl && i == n - 1;
            sequence.elements.set(i, (Element)this.dispatch(sequence.get(i)));
        }
        this.isLastElement = false;
        return sequence;
    }

    public Element visit(Predicate predicate) {
        this.isTopLevel = false;
        this.isLastElement = true;
        boolean bl = this.hasValue;
        this.hasValue = false;
        boolean bl2 = this.suppressVoided;
        this.suppressVoided = true;
        predicate.element = (Element)this.dispatch(predicate.element);
        this.isLastElement = false;
        this.hasValue = bl;
        this.suppressVoided = bl2;
        return predicate;
    }

    public VoidedElement visit(VoidedElement voidedElement) {
        this.isTopLevel = false;
        this.isLastElement = true;
        boolean bl = this.hasValue;
        this.hasValue = false;
        boolean bl2 = this.suppressVoided;
        this.suppressVoided = true;
        voidedElement.element = (Element)this.dispatch(voidedElement.element);
        this.isLastElement = false;
        this.hasValue = bl;
        this.suppressVoided = bl2;
        return voidedElement;
    }

    public Binding visit(Binding binding) {
        this.isTopLevel = false;
        this.isLastElement = true;
        this.hasValue = false;
        boolean bl = this.suppressVoided;
        this.suppressVoided = false;
        binding.element = (Element)this.dispatch(binding.element);
        if (binding.element instanceof VoidedElement) {
            this.runtime.error("binding for expression without value", binding);
        }
        this.isLastElement = false;
        this.hasValue = true;
        this.suppressVoided = bl;
        return binding;
    }

    public StringMatch visit(StringMatch stringMatch) {
        this.isTopLevel = false;
        this.isLastElement = true;
        this.hasValue = false;
        boolean bl = this.suppressVoided;
        this.suppressVoided = false;
        stringMatch.element = (Element)this.dispatch(stringMatch.element);
        if (stringMatch.element instanceof VoidedElement) {
            this.runtime.error("match for expression without value", stringMatch);
        }
        this.isLastElement = false;
        this.hasValue = true;
        this.suppressVoided = bl;
        return stringMatch;
    }

    public ParserAction visit(ParserAction parserAction) {
        this.isTopLevel = false;
        this.isLastElement = false;
        this.hasValue = true;
        return parserAction;
    }

    public Action visit(Action action) {
        this.isTopLevel = false;
        this.isLastElement = false;
        if (action.setsValue()) {
            this.hasValue = true;
        }
        return action;
    }

    public NonTerminal visit(NonTerminal nonTerminal) {
        this.isTopLevel = false;
        this.isLastElement = false;
        FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
        if (!AST.isVoid(fullProduction.type)) {
            this.hasValue = true;
        }
        return nonTerminal;
    }

    public Element visit(Element element) {
        this.isTopLevel = false;
        this.isLastElement = false;
        this.hasValue = true;
        return element;
    }
}

