/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.List;
import xtc.Constants;
import xtc.parser.ActionBaseValue;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FullProduction;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.Generifier;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NullLiteral;
import xtc.parser.NullValue;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParseTreeNode;
import xtc.parser.Properties;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.StringValue;
import xtc.parser.TokenValue;
import xtc.tree.Attribute;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.Type;
import xtc.util.Runtime;
import xtc.util.Utilities;

public class DirectLeftRecurser
extends Visitor {
    public static final int STATE_RECURSION = 1;
    public static final int STATE_BASE = 2;
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected boolean isVoid;
    protected boolean isTextOnly;
    protected boolean isToken;
    protected boolean isGeneric;
    protected boolean hasConstant;
    protected boolean hasParseTree;
    protected int state;
    protected boolean isTopLevel;
    protected boolean seenChoice;
    protected List<Binding> children;
    protected List<NodeMarker> markers;
    protected FullProduction pTail;
    protected Binding seed;
    protected String varAction;

    public DirectLeftRecurser(Runtime runtime, Analyzer analyzer, AST aST) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = aST;
        this.children = new ArrayList<Binding>();
        this.markers = new ArrayList<NodeMarker>();
    }

    protected Binding bind(Element element) {
        Binding binding = new Binding(this.analyzer.variable("g"), element);
        this.children.add(binding);
        return binding;
    }

    public void visit(Module module) {
        if (!this.runtime.test("optimizeLeftRecursions") && !this.runtime.test("optimizeLeftIterations")) {
            return;
        }
        this.analyzer.register(this);
        this.analyzer.init(module);
        this.hasConstant = module.hasAttribute(Constants.ATT_CONSTANT);
        this.hasParseTree = module.hasAttribute(Constants.ATT_PARSE_TREE);
        for (int i = 0; i < module.productions.size(); ++i) {
            FullProduction fullProduction = (FullProduction)module.productions.get(i);
            if (!DirectLeftRecurser.isTransformable(fullProduction)) continue;
            if (this.runtime.test("optionVerbose")) {
                System.err.println("[Transforming left-recursion in " + fullProduction.qName + "]");
            }
            this.analyzer.startAdding();
            this.analyzer.process(fullProduction);
            i += this.analyzer.addNewProductionsAt(i + 1);
            fullProduction.removeProperty("transformable");
        }
    }

    public void visit(FullProduction fullProduction) {
        this.isVoid = AST.isVoid(fullProduction.type);
        this.isTextOnly = fullProduction.getBooleanProperty("textOnly");
        this.isToken = fullProduction.getBooleanProperty("token");
        this.isGeneric = AST.isGenericNode(fullProduction.type);
        this.isTopLevel = true;
        this.seenChoice = false;
        this.children.clear();
        this.markers.clear();
        this.seed = null;
        this.varAction = null;
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(fullProduction.attributes);
        arrayList.remove(Constants.ATT_STATEFUL);
        arrayList.remove(Constants.ATT_RESETTING);
        if (this.isGeneric && !arrayList.contains(Constants.ATT_CONSTANT) && !this.hasConstant) {
            arrayList.add(Constants.ATT_CONSTANT);
        }
        if (this.runtime.test("optimizeLeftIterations") && !arrayList.contains(Constants.ATT_TRANSIENT)) {
            arrayList.add(Constants.ATT_TRANSIENT);
        }
        arrayList.remove(Constants.ATT_INLINE);
        Type type2 = null;
        type2 = this.isGeneric ? (this.runtime.test("optimizeLeftIterations") ? AST.actionOf(fullProduction.type) : AST.listOf(AST.actionOf(fullProduction.type))) : AST.VOID;
        this.pTail = new FullProduction(arrayList, type2, this.analyzer.tail(), null, new OrderedChoice());
        this.pTail.qName = this.pTail.name.qualify(this.analyzer.module().name.name);
        if (this.isGeneric) {
            this.varAction = this.analyzer.variable();
        }
        fullProduction.choice = (OrderedChoice)this.dispatch(fullProduction.choice);
        if (this.isGeneric && AST.isDynamicNode(fullProduction.type)) {
            fullProduction.type = AST.NODE;
        }
        if (!this.runtime.test("optimizeLeftIterations")) {
            Sequence sequence = new Sequence();
            if (this.isGeneric) {
                sequence.add(EmptyListValue.VALUE);
            } else {
                sequence.add(NullValue.VALUE);
            }
            this.pTail.choice.alternatives.add(sequence);
        }
        if (!this.runtime.test("optimizeLeftIterations") || !this.isVoid && !this.isTextOnly && !this.isToken) {
            this.analyzer.add(this.pTail);
        }
        if (this.isGeneric) {
            Generifier.markGenericRecursion((FullProduction)this.analyzer.current(), this.runtime.test("optionVerbose"));
        }
    }

    public Element visit(OrderedChoice orderedChoice) {
        boolean bl = this.isTopLevel;
        this.isTopLevel = false;
        for (int i = 0; i < orderedChoice.alternatives.size(); ++i) {
            Sequence sequence = orderedChoice.alternatives.get(i);
            if (bl) {
                Element element;
                if (DirectLeftRecurser.isRecursive(sequence, (FullProduction)this.analyzer.current())) {
                    this.state = 1;
                    sequence.elements.remove(0);
                    orderedChoice.alternatives.remove(i);
                    --i;
                    element = (Sequence)this.dispatch(sequence);
                    if (1 == ((Sequence)element).size() && ((Sequence)element).get(0) instanceof OrderedChoice) {
                        this.pTail.choice.alternatives.addAll(((OrderedChoice)((Sequence)element).get((int)0)).alternatives);
                        continue;
                    }
                    this.pTail.choice.alternatives.add((Sequence)element);
                    continue;
                }
                this.state = 2;
                if (this.isGeneric) {
                    element = Analyzer.getBinding(sequence.elements);
                    if (null == element && null == (element = this.analyzer.bind(sequence.elements, "g"))) {
                        this.runtime.error("unable to determine value of recursion's base case", sequence);
                        element = new Binding("v$dummy", sequence);
                    }
                    this.seed = element;
                    if (!"v$dummy".equals(((Binding)element).name)) {
                        Type type2 = this.analyzer.type(((Binding)element).element);
                        if (AST.isAny(type2)) {
                            if (!this.analyzer.module().hasAttribute(Constants.ATT_NO_WARNINGS) && !this.analyzer.current().hasAttribute(Constants.ATT_NO_WARNINGS)) {
                                this.runtime.error("value of recursion's base case may not be a node", ((Binding)element).element);
                            }
                        } else if (!type2.resolve().isWildcard() && !AST.isNode(type2)) {
                            this.runtime.error("value of recursion's base case not a node", ((Binding)element).element);
                        }
                    }
                }
                orderedChoice.alternatives.set(i, (Sequence)this.dispatch(sequence));
                continue;
            }
            orderedChoice.alternatives.set(i, (Sequence)this.dispatch(sequence));
        }
        this.seenChoice = true;
        return orderedChoice;
    }

    public Element visit(Repetition repetition) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(repetition);
        }
        return repetition;
    }

    public Element visit(Option option) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(option);
        }
        return option;
    }

    public Element visit(Sequence sequence) {
        this.isTopLevel = false;
        int n = this.children.size();
        int n2 = this.markers.size();
        int n3 = sequence.size();
        for (int i = 0; i < n3; ++i) {
            sequence.elements.set(i, (Element)this.dispatch(sequence.get(i)));
        }
        if (this.seenChoice) {
            this.seenChoice = false;
        } else if (1 == this.state) {
            if (this.runtime.test("optimizeLeftIterations")) {
                if (this.isGeneric) {
                    String string = this.analyzer.current().qName.name;
                    if (!this.markers.isEmpty()) {
                        string = Utilities.qualify(Utilities.getQualifier(string), this.markers.get((int)(this.markers.size() - 1)).name);
                    }
                    List<Binding> list = sequence.hasProperty("formatting") ? Properties.getFormatting(sequence) : new ArrayList<Binding>(0);
                    sequence.add(new GenericActionValue(string, this.varAction, new ArrayList<Binding>(this.children), list));
                }
            } else if (this.isGeneric) {
                Binding binding = new Binding(this.analyzer.variable(), this.pTail.name);
                sequence.add(binding);
                String string = this.analyzer.current().qName.name;
                if (!this.markers.isEmpty()) {
                    string = Utilities.qualify(Utilities.getQualifier(string), this.markers.get((int)(this.markers.size() - 1)).name);
                }
                List<Binding> list = sequence.hasProperty("formatting") ? Properties.getFormatting(sequence) : new ArrayList<Binding>(0);
                sequence.add(new GenericRecursionValue(string, this.varAction, new ArrayList<Binding>(this.children), list, binding));
            } else {
                sequence.add(this.pTail.name);
                sequence.add(NullValue.VALUE);
            }
        } else if (2 == this.state) {
            if (this.runtime.test("optimizeLeftIterations")) {
                if (this.isGeneric) {
                    Binding binding = new Binding(this.analyzer.variable(), this.pTail.name);
                    Repetition repetition = new Repetition(false, new Sequence(binding));
                    Binding binding2 = new Binding(this.analyzer.variable(), repetition);
                    sequence.add(binding2).add(new ActionBaseValue(binding2, this.seed));
                } else {
                    Element element = this.analyzer.copy(Analyzer.strip(this.pTail.choice));
                    sequence.add(new Repetition(false, Sequence.ensure(element)));
                    if (this.isTextOnly) {
                        sequence.add(StringValue.VALUE);
                    } else if (this.isToken) {
                        sequence.add(TokenValue.VALUE);
                    } else {
                        sequence.add(NullValue.VALUE);
                    }
                }
            } else if (this.isGeneric) {
                Binding binding = new Binding(this.analyzer.variable(), this.pTail.name);
                sequence.add(binding).add(new ActionBaseValue(binding, this.seed));
            } else if (this.isTextOnly) {
                sequence.add(this.pTail.name).add(StringValue.VALUE);
            } else if (this.isToken) {
                sequence.add(this.pTail.name).add(TokenValue.VALUE);
            } else {
                sequence.add(this.pTail.name).add(NullValue.VALUE);
            }
        } else {
            throw new IllegalStateException("Invalid state " + this.state);
        }
        if (this.isGeneric && 1 == this.state) {
            if (0 == n) {
                this.children.clear();
            } else {
                this.children.subList(n, this.children.size()).clear();
            }
            if (0 == n2) {
                this.markers.clear();
            } else {
                this.markers.subList(n2, this.markers.size()).clear();
            }
        }
        return sequence;
    }

    public Element visit(Binding binding) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            if ("yyValue".equals(binding.name)) {
                this.runtime.error("illegal binding to yyValue in left-recursive sequence", binding);
            }
            this.children.add(binding);
        }
        return binding;
    }

    public Element visit(StringMatch stringMatch) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(stringMatch);
        }
        return stringMatch;
    }

    public Element visit(NonTerminal nonTerminal) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
            if (AST.isVoid(fullProduction.type)) {
                return nonTerminal;
            }
            return this.bind(nonTerminal);
        }
        return nonTerminal;
    }

    public Element visit(StringLiteral stringLiteral) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(stringLiteral);
        }
        return stringLiteral;
    }

    public Element visit(ParseTreeNode parseTreeNode) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(parseTreeNode);
        }
        return parseTreeNode;
    }

    public Element visit(NullLiteral nullLiteral) {
        this.isTopLevel = false;
        if (this.isGeneric && 1 == this.state) {
            return this.bind(nullLiteral);
        }
        return nullLiteral;
    }

    public Element visit(NodeMarker nodeMarker) {
        this.isTopLevel = false;
        this.markers.add(nodeMarker);
        return nodeMarker;
    }

    public Element visit(Element element) {
        this.isTopLevel = false;
        return element;
    }

    public static boolean isTransformable(FullProduction fullProduction) {
        if (!(AST.isVoid(fullProduction.type) || fullProduction.getBooleanProperty("textOnly") || fullProduction.getBooleanProperty("token") || AST.isGenericNode(fullProduction.type))) {
            return false;
        }
        if (fullProduction.hasProperty("transformable")) {
            return fullProduction.getBooleanProperty("transformable");
        }
        boolean bl = false;
        boolean bl2 = false;
        for (Sequence sequence : fullProduction.choice.alternatives) {
            if (sequence.isEmpty()) {
                fullProduction.setProperty("transformable", Boolean.FALSE);
                return false;
            }
            Element element = Analyzer.stripAndUnbind(sequence.get(0));
            if (fullProduction.name.equals(element) || fullProduction.qName.equals(element)) {
                if (!bl || !bl2) {
                    bl = true;
                    continue;
                }
                fullProduction.setProperty("transformable", Boolean.FALSE);
                return false;
            }
            if (!bl) {
                fullProduction.setProperty("transformable", Boolean.FALSE);
                return false;
            }
            bl2 = true;
        }
        if (bl && bl2) {
            fullProduction.setProperty("transformable", Boolean.TRUE);
            return true;
        }
        fullProduction.setProperty("transformable", Boolean.FALSE);
        return false;
    }

    public static boolean isRecursive(Sequence sequence, FullProduction fullProduction) {
        if (sequence.isEmpty()) {
            return false;
        }
        Element element = Analyzer.stripAndUnbind(sequence.get(0));
        return fullProduction.name.equals(element) || fullProduction.qName.equals(element);
    }

    public static boolean isBase(Sequence sequence, FullProduction fullProduction) {
        return !DirectLeftRecurser.isRecursive(sequence, fullProduction);
    }
}

