/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.ActionBaseValue;
import xtc.parser.Analyzer;
import xtc.parser.AnyChar;
import xtc.parser.Binding;
import xtc.parser.BindingValue;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharLiteral;
import xtc.parser.CharRange;
import xtc.parser.CharSwitch;
import xtc.parser.Element;
import xtc.parser.EmptyListValue;
import xtc.parser.FollowedBy;
import xtc.parser.FullProduction;
import xtc.parser.GenericActionValue;
import xtc.parser.GenericNodeValue;
import xtc.parser.GenericRecursionValue;
import xtc.parser.MetaData;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.NotFollowedBy;
import xtc.parser.NullLiteral;
import xtc.parser.NullValue;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParseTreeNode;
import xtc.parser.ParserAction;
import xtc.parser.Production;
import xtc.parser.ProperListValue;
import xtc.parser.Properties;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.StringValue;
import xtc.parser.TokenValue;
import xtc.parser.VoidedElement;
import xtc.tree.Attribute;
import xtc.tree.Printer;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.InstantiatedT;
import xtc.type.Type;
import xtc.util.Runtime;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerator
extends Visitor {
    public static final int CHUNK_SIZE = 10;
    public static final String PREFIX_METHOD = "p";
    public static final String PREFIX_FIELD = "f";
    public static final String PREFIX_COUNT_FIELD = "c";
    public static final String PREFIX = "yy";
    public static final String PRINTER = "yyOut";
    public static final String STATE = "yyState";
    public static final String PARSE_CHAR = "character";
    public static final String ARG_INDEX = "yyStart";
    public static final String COLUMN = "yyColumn";
    public static final String CHAR = "yyC";
    public static final String INDEX = "yyIndex";
    public static final String RESULT = "yyResult";
    public static final String PRED_INDEX = "yyPredIndex";
    public static final String PRED_RESULT = "yyPredResult";
    public static final String PRED_MATCHED = "yyPredMatched";
    public static final String BASE_INDEX = "yyBase";
    public static final String NESTED_CHOICE = "yyChoice";
    public static final String REPETITION = "yyRepetition";
    public static final String OPTION = "yyOption";
    public static final String REPEATED = "yyRepeated";
    public static final String REP_VALUE = "yyRepValue";
    public static final String OP_VALUE = "yyOpValue";
    public static final String VALUE = "yyValue";
    public static final String PARSE_ERROR = "yyError";
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected final AST ast;
    protected final Printer printer;
    protected boolean attributeVerbose;
    protected boolean attributeWithLocation;
    protected boolean attributeConstant;
    protected boolean attributeFlatten;
    protected boolean attributeParseTree;
    protected boolean attributeRawTypes;
    protected boolean attributeIgnoringCase;
    protected boolean attributeNoMatchingErrors;
    protected boolean attributeStateful;
    protected boolean attributeStringSet;
    protected String stateClassName;
    protected String factoryClassName;
    protected boolean attributeMain;
    protected String mainMethodNonterminal = null;
    protected boolean attributePrinter;
    protected String printerClassName;
    protected boolean attributeProfile;
    protected boolean attributeDump;
    protected String className;
    protected boolean chunked;
    protected Map<NonTerminal, Integer> chunkMap;
    protected int chunkCount;
    protected boolean firstElement;
    protected boolean savedFirstElement;
    protected String baseIndex;
    protected boolean useBaseIndex;
    protected String savedBaseIndex;
    protected boolean savedUseBaseIndex;
    protected int indentLevel;
    protected int choiceLevel;
    protected int repetitionLevel;
    protected int savedRepetitionLevel;
    protected boolean repeatOnce;
    protected String repeatedElement;
    protected List<Type> repetitionTypes;
    protected int optionLevel;
    protected int savedOptionLevel;
    protected String optionalElement;
    protected List<Type> optionTypes;
    protected boolean createsNodeValue;
    protected boolean seenTest;
    protected boolean endsWithParseError;
    protected Iterator<Element> elementIter;
    protected String indexName;
    protected String resultName;
    protected String bindingName;
    protected Element bindingElement;
    protected Type bindingType;
    protected boolean predicate;
    protected boolean notFollowedBy;
    protected Iterator<Element> predicateIter;

    public CodeGenerator(Runtime runtime, Analyzer analyzer, AST aST, Printer printer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.ast = aST;
        this.printer = printer;
    }

    public String booleanT() {
        return "boolean";
    }

    public String charT() {
        return "char";
    }

    public String intT() {
        return "int";
    }

    public String indexT() {
        return "int";
    }

    public String extern(Type type2) {
        return null == type2 ? null : this.ast.extern(type2);
    }

    public String rawT(String string) {
        int n = string.indexOf(60);
        return -1 == n ? string : string.substring(0, n);
    }

    public String nullExpr() {
        return "null";
    }

    public String stringExpr(String string) {
        return '\"' + Utilities.escape(string, 8) + '\"';
    }

    public String emptyListExpr() {
        return this.attributeRawTypes ? "Pair.EMPTY" : "Pair.empty()";
    }

    public String fieldName(NonTerminal nonTerminal, String string) {
        if (this.chunked) {
            return "yyColumn.chunk" + this.chunkMap.get(nonTerminal) + "." + string + nonTerminal.toIdentifier();
        }
        return "yyColumn." + string + nonTerminal.toIdentifier();
    }

    public String methodName(NonTerminal nonTerminal) {
        return PREFIX_METHOD + nonTerminal.toIdentifier();
    }

    protected void verbose() {
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Trace entering the specified production.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param name The name.");
        this.printer.indent().pln(" * @param index The index.");
        this.printer.indent().pln(" */");
        this.printer.indent().pln("protected void traceEnter(String name, int index) {").incr();
        this.printer.indent().pln("if (! DEBUG) return;");
        this.printer.pln();
        this.printer.indent().p(PRINTER).p(".p(\"enter \").p(name).p(\" @ \").").pln("p(index);");
        this.printer.indent().p("if (PEEK) ").p(PRINTER).p(".p(\" : \\\"\").").pln("escape(peek(index)).p('\\\"');");
        this.printer.indent().p(PRINTER).pln(".pln().flush();");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Trace a successful exit from the specified ").pln("production.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param name The name.");
        this.printer.indent().pln(" * @param index The index.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("protected void traceSuccess(String name, ").pln("int index) {").incr();
        this.printer.indent().pln("if (! DEBUG) return;");
        this.printer.indent().p(PRINTER).p(".p(\"exit \").p(name).p(\" @ \").").pln("p(index).pln(\" with match\").flush();");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Trace a failed exit from the specified ").pln("production.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param name The name.");
        this.printer.indent().pln(" * @param index The index.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("protected void traceFailure(String name, ").pln("int index) {").incr();
        this.printer.indent().pln("if (! DEBUG) return;");
        this.printer.indent().p(PRINTER).p(".p(\"exit \").p(name).p(\" @ \").").pln("p(index).pln(\" with error\").flush();");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Trace a lookup in the memoization table for ").pln("the specified production.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param name The name.");
        this.printer.indent().pln(" * @param index The index.");
        this.printer.indent().pln(" * @param result The result.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("protected void traceLookup(String name, int index, ").pln("Result result) {").incr();
        this.printer.indent().pln("if (! DEBUG) return;");
        this.printer.pln();
        this.printer.indent().p(PRINTER).p(".p(\"lookup \").p(name).p(\" @ \").").pln("p(index);");
        this.printer.indent().p("if (PEEK) ").p(PRINTER).p(".p(\" : \\\"\").").pln("escape(peek(index)).p('\\\"');");
        this.printer.indent().p(PRINTER).pln(".p(\" -> \");");
        this.printer.indent().pln("if (result.hasValue()) {").incr();
        this.printer.indent().p(PRINTER).pln(".p(\"match\");");
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().p(PRINTER).pln(".p(\"error\");");
        this.printer.decr().indent().pln('}');
        this.printer.indent().p(PRINTER).pln(".pln().flush();");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
    }

    protected void profile() {
        String string;
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Print a profile of the memoization table.");
        this.printer.indent().pln(" *");
        this.printer.indent().p(" * @param printer The printer for writing the ").pln("profile.");
        this.printer.indent().pln(" */");
        this.printer.indent().pln("public void profile(Printer printer) {").incr();
        this.printer.indent().pln("// Initialize the profile.");
        if (this.attributeRawTypes) {
            this.printer.indent().p("HashMap maxima = new HashMap();");
        } else {
            this.printer.indent().p("HashMap<String, Integer> maxima = ").pln("new HashMap<String, Integer>();");
        }
        this.printer.pln();
        int n = 0;
        for (Production production : this.analyzer.module().productions) {
            if (this.runtime.test("optimizeTransient") && !production.isMemoized()) continue;
            string = production.name.toIdentifier();
            n = Math.max(n, string.length());
            if (this.attributeRawTypes) {
                this.printer.indent().p("maxima.put(\"").p(string).pln("\", Integer.valueOf(0));");
                continue;
            }
            this.printer.indent().p("maxima.put(\"").p(string).pln("\", 0);");
        }
        this.printer.pln();
        this.printer.indent().pln("// Process the memoization table.");
        this.printer.indent().pln("for (int i=0; i<yyCount; i++) {").incr();
        this.printer.indent().p(this.className).p("Column column = (").p(this.className).pln("Column)yyColumns[i];");
        this.printer.pln();
        this.printer.indent().pln("if (null != column) {").incr();
        if (0 == this.chunkCount) {
            for (Production production : this.analyzer.module().productions) {
                if (this.runtime.test("optimizeTransient") && !production.isMemoized()) continue;
                string = production.name.toIdentifier();
                this.printer.indent().p("profile(maxima, \"").p(string).p("\", ").buffer().p("column.").p(PREFIX_COUNT_FIELD).p(string).p(");").fit("        ").pln();
            }
        } else {
            int n2 = 0;
            int n3 = 10;
            boolean bl = true;
            for (Production production : this.analyzer.module().productions) {
                if (this.runtime.test("optimizeTransient") && !production.isMemoized()) continue;
                if (10 <= n3) {
                    ++n2;
                    n3 = 0;
                    if (bl) {
                        bl = false;
                    } else {
                        this.printer.decr().indent().pln('}');
                        this.printer.pln();
                    }
                    this.printer.indent().p("Chunk").p(n2).p(" chunk").p(n2).p(" = column.chunk").p(n2).pln(';');
                    this.printer.indent().p("if (null != chunk").p(n2).pln(") {").incr();
                }
                String string2 = production.name.toIdentifier();
                this.printer.indent().p("profile(maxima, \"").p(string2).p("\", ").buffer().p("chunk").p(n2).p('.').p(PREFIX_COUNT_FIELD).p(string2).p(");").fit("        ").pln();
                ++n3;
            }
            this.printer.decr().indent().pln('}');
        }
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("// Print the profile.");
        for (Production production : this.analyzer.module().productions) {
            if (this.runtime.test("optimizeTransient") && !production.isMemoized()) continue;
            this.printer.indent().p("print(printer, ").p(n).p(", maxima, ").buffer().p('\"').p(production.name.toIdentifier()).p("\");").fitMore().pln();
        }
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Update the profile for the specified production").pln(" and count.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param maxima The profile.");
        this.printer.indent().pln(" * @param name The production's name.");
        this.printer.indent().pln(" * @param count The access count.");
        this.printer.indent().pln(" */");
        if (this.attributeRawTypes) {
            this.printer.indent().p("private void profile(HashMap maxima, String name, ").pln("int count) {").incr();
            this.printer.indent().pln("int old = ((Integer)maxima.get(name)).intValue();");
            this.printer.indent().pln("int max = Math.max(old, count);");
            this.printer.indent().p("if (old < max) ").pln("maxima.put(name, Integer.valueOf(max));");
        } else {
            this.printer.indent().p("private void profile(HashMap<String, Integer> ").pln("maxima,");
            this.printer.indent().pln("                     String name, int count) {").incr();
            this.printer.indent().pln("int old = maxima.get(name);");
            this.printer.indent().pln("int max = Math.max(old, count);");
            this.printer.indent().pln("if (old < max) maxima.put(name, max);");
        }
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Print the profile for the specified production").pln(" and count.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param printer The printer.");
        this.printer.indent().pln(" * @param align The alignment.");
        this.printer.indent().pln(" * @param maxima The profile.");
        this.printer.indent().pln(" * @param name The production's name.");
        this.printer.indent().pln(" */");
        if (this.attributeRawTypes) {
            this.printer.indent().pln("private void print(Printer printer, int align,");
            this.printer.indent().pln("                   HashMap maxima, String name) {").incr();
            this.printer.indent().p("int count = ((Integer)maxima.get(name)).").pln("intValue();");
        } else {
            this.printer.indent().pln("private void print(Printer printer, int align,");
            this.printer.indent().p("                   HashMap<String, Integer> ").pln("maxima, String name) {").incr();
            this.printer.indent().pln("int count = maxima.get(name);");
        }
        this.printer.indent().pln("align    += 4;");
        this.printer.indent().pln("if (1 != count) {").incr();
        this.printer.indent().pln("printer.p(\"- \");");
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("printer.p(\"* \");");
        this.printer.decr().indent().pln('}');
        this.printer.indent().pln("printer.p(name).align(align).p(\" : \").pln(count);");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
    }

    protected void dump() {
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Dump the memoization table.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param printer The printer for writing the table.");
        this.printer.indent().pln(" */");
        this.printer.indent().pln("public void dump(Printer printer) {").incr();
        this.printer.indent().pln("for (int i=0; i<yyCount; i++) {").incr();
        this.printer.indent().p(this.className).p("Column column = (").p(this.className).pln("Column)yyColumns[i];");
        this.printer.indent().pln("printer.indent().p(i).p(\" = \");");
        this.printer.pln();
        this.printer.indent().pln("if (null == column) {").incr();
        this.printer.indent().pln("printer.pln(\"null;\");");
        this.printer.pln();
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("printer.pln('{').incr();");
        if (0 == this.chunkCount) {
            this.printer.pln();
            for (Production production : this.analyzer.module().productions) {
                if (this.runtime.test("optimizeTransient") && !production.isMemoized()) continue;
                String string = production.name.toIdentifier();
                this.printer.indent().p("dump(printer, \"").p(string).p("\", ").buffer().p("column.").p(PREFIX_FIELD).p(string).p(");").fit("     ").pln();
            }
        } else {
            int n = 0;
            int n2 = 10;
            boolean bl = true;
            for (Production production : this.analyzer.module().productions) {
                if (this.runtime.test("optimizeTransient") && !production.isMemoized()) continue;
                if (10 <= n2) {
                    ++n;
                    n2 = 0;
                    if (bl) {
                        bl = false;
                    } else {
                        this.printer.pln();
                        this.printer.indent().pln("printer.decr().indent().pln(\"};\");");
                        this.printer.decr().indent().pln('}');
                    }
                    this.printer.pln();
                    this.printer.indent().p("Chunk").p(n).p(" chunk").p(n).p(" = column.chunk").p(n).pln(';');
                    this.printer.indent().p("printer.indent().p(\"Chunk(").p(n).p(") = \");");
                    this.printer.pln();
                    this.printer.indent().p("if (null == chunk").p(n).pln(") {").incr();
                    this.printer.indent().pln("printer.pln(\"null;\");");
                    this.printer.pln();
                    this.printer.decr().indent().pln("} else {").incr();
                    this.printer.indent().pln("printer.pln('{').incr();");
                    this.printer.pln();
                }
                String string = production.name.toIdentifier();
                this.printer.indent().p("dump(printer, \"").p(string).p("\", ").buffer().p("chunk").p(n).p('.').p(PREFIX_FIELD).p(string).p(");").fit("     ").pln();
                ++n2;
            }
            this.printer.pln();
            this.printer.indent().pln("printer.decr().indent().pln(\"};\");");
            this.printer.decr().indent().pln('}');
        }
        this.printer.pln();
        this.printer.indent().pln("printer.decr().indent().pln(\"};\");");
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Dump a memoized result.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param printer The printer.");
        this.printer.indent().pln(" * @param name The name of the result.");
        this.printer.indent().pln(" * @param result The value of the result.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("private void dump(Printer printer, String name, ").pln("Result result) {").incr();
        this.printer.indent().pln("printer.indent().p(name).p(\" = \");");
        this.printer.pln();
        this.printer.indent().pln("if (null == result) {").incr();
        this.printer.indent().pln("printer.pln(\"null;\");");
        this.printer.decr().indent().pln("} else if (result.hasValue()) {").incr();
        this.printer.indent().pln("printer.p(\"Value(\").p(result.index).pln(\");\");");
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("printer.p(\"Error(\").p(result.index).pln(\");\");");
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.pln();
    }

    protected void mainMethod(String string) {
        int n = this.printer.level() * 2 + 8 + Math.max(6, this.className.length()) + 1 + 1;
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Parse the specified files.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param args The file names.");
        this.printer.indent().pln(" */");
        this.printer.indent().pln("public static void main(String[] args) {").incr();
        this.printer.indent().pln("if ((null == args) || (0 == args.length)) {").incr();
        this.printer.indent().pln("System.err.println(\"Usage: <file-name>+\");");
        this.printer.pln();
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("for (int i=0; i<args.length; i++) {").incr();
        this.printer.indent().p("System.err.println(\"Processing \" + args[i] + ").pln("\" ...\");");
        this.printer.pln();
        this.printer.indent().p("Reader").align(n).pln("in = null;");
        this.printer.indent().pln("try {").incr();
        this.printer.indent().p("in").align(n + 3).pln("= new BufferedReader(new FileReader(args[i]));");
        this.printer.indent().p(this.className).align(n).p("p  = ").buffer().p("new ").p(this.className).p("(in, args[i], (int)new File(args[i]).length());").fitMore().pln();
        this.printer.indent().p("Result").align(n).p("r  = p.p").p(string).pln("(0);");
        this.printer.pln();
        this.printer.indent().pln("if (r.hasValue()) {").incr();
        this.printer.indent().pln("SemanticValue v = (SemanticValue)r;");
        this.printer.pln();
        if (this.attributePrinter) {
            this.printer.indent().pln("if (v.value instanceof Node) {").incr();
            this.printer.indent().pln("Printer ptr = new");
            this.printer.indentMore().p("Printer(new BufferedWriter(new ").pln("OutputStreamWriter(System.out)));");
            this.printer.indent().p("new ").p(this.printerClassName).pln("(ptr).dispatch((Node)v.value);");
            this.printer.indent().pln("ptr.flush();").pln();
            this.printer.decr().indent().pln("} else {").incr();
            this.printer.indent().pln("System.out.println(v.value.toString());");
            this.printer.decr().indent().pln('}');
        } else {
            this.printer.indent().pln("if (v.value instanceof Node) {").incr();
            this.printer.indent().pln("Printer ptr = new");
            this.printer.indentMore().p("Printer(new BufferedWriter(new ").pln("OutputStreamWriter(System.out)));");
            this.printer.indent().pln("ptr.format((Node)v.value).pln().flush();");
            this.printer.decr().indent().pln("} else {").incr();
            this.printer.indent().pln("System.out.println(v.value.toString());");
            this.printer.decr().indent().pln('}');
        }
        this.printer.pln();
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().pln("ParseError err = (ParseError)r;");
        this.printer.indent().pln("if (-1 == err.index) {").incr();
        this.printer.indent().pln("System.err.println(\"  Parse error\");");
        this.printer.decr().indent().pln("} else {").incr();
        this.printer.indent().p("System.err.println(\"  \" + p.location(err.index) + ").pln("\": \" + err.msg);");
        this.printer.decr().indent().pln("}");
        this.printer.decr().indent().pln("}");
        this.printer.pln();
        this.printer.decr().indent().pln("} catch (Throwable x) {").incr();
        this.printer.indent().pln("while (null != x.getCause()) {").incr();
        this.printer.indent().pln("x = x.getCause();");
        this.printer.decr().indent().pln("}");
        this.printer.indent().pln("x.printStackTrace();");
        this.printer.decr().indent().pln("} finally {").incr();
        this.printer.indent().pln("try {").incr();
        this.printer.indent().pln("in.close();");
        this.printer.decr().indent().pln("} catch (Throwable x) {").incr();
        this.printer.indent().pln("/* Ignore. */");
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.printer.pln();
    }

    /*
     * WARNING - void declaration
     */
    public void visit(Module module) {
        boolean bl;
        int n;
        boolean bl2;
        this.analyzer.register(this);
        this.printer.register(this);
        this.analyzer.init(module);
        this.className = Utilities.getName(module.getClassName());
        if (null == module.attributes) {
            module.attributes = new ArrayList<Attribute>();
        }
        this.attributeVerbose = module.hasAttribute(Constants.ATT_VERBOSE);
        this.attributeWithLocation = module.hasAttribute(Constants.ATT_WITH_LOCATION);
        this.attributeConstant = module.hasAttribute(Constants.ATT_CONSTANT);
        this.attributeFlatten = module.hasAttribute(Constants.ATT_FLATTEN);
        this.attributeParseTree = module.hasAttribute(Constants.ATT_PARSE_TREE);
        this.attributeRawTypes = module.hasAttribute(Constants.ATT_RAW_TYPES);
        this.attributeIgnoringCase = module.hasAttribute(Constants.ATT_IGNORING_CASE);
        this.attributeStateful = module.hasAttribute(Constants.ATT_STATEFUL.getName());
        this.attributeStringSet = module.hasAttribute("setOfString");
        this.attributeMain = module.hasAttribute("main");
        this.attributePrinter = module.hasAttribute("printer");
        this.attributeProfile = module.hasAttribute(Constants.ATT_PROFILE);
        this.attributeDump = module.hasAttribute(Constants.ATT_DUMP);
        if (this.attributeStateful) {
            this.stateClassName = (String)module.getAttributeValue(Constants.ATT_STATEFUL.getName());
        }
        if (this.attributeMain) {
            this.mainMethodNonterminal = (String)module.getAttributeValue("main");
        }
        if (this.attributePrinter) {
            this.printerClassName = (String)module.getAttributeValue("printer");
        }
        if (module.hasAttribute("factory")) {
            this.factoryClassName = (String)module.getAttributeValue("factory");
        }
        if (!(bl2 = this.attributeVerbose)) {
            for (Production production : module.productions) {
                if (!production.hasAttribute(Constants.ATT_VERBOSE)) continue;
                bl2 = true;
                break;
            }
        }
        this.chunked = false;
        this.chunkMap = null;
        this.chunkCount = 0;
        String string = Utilities.getQualifier(module.getClassName());
        if (null != string) {
            this.printer.indent().p("package ").p(string).pln(';');
            this.printer.pln();
        }
        this.printer.indent().pln("import java.io.Reader;");
        if (this.attributeMain) {
            this.printer.indent().pln("import java.io.BufferedReader;");
            this.printer.indent().pln("import java.io.BufferedWriter;");
            this.printer.indent().pln("import java.io.File;");
            this.printer.indent().pln("import java.io.FileReader;");
            this.printer.indent().pln("import java.io.OutputStreamWriter;");
        }
        this.printer.indent().pln("import java.io.IOException;");
        this.printer.pln();
        if (this.attributeProfile) {
            this.printer.indent().pln("import java.util.HashMap;");
        }
        if (this.attributeStringSet) {
            this.printer.indent().pln("import java.util.HashSet;");
            this.printer.indent().pln("import java.util.Set;");
        }
        if (this.attributeProfile || this.attributeStringSet) {
            this.printer.pln();
        }
        if (module.getBooleanProperty("recursive")) {
            this.printer.indent().pln("import xtc.util.Action;");
        }
        this.printer.indent().pln("import xtc.util.Pair;");
        this.printer.pln();
        boolean bl3 = false;
        if (module.getBooleanProperty("locatable")) {
            this.printer.indent().pln("import xtc.tree.Locatable;");
            bl3 = true;
        }
        if (module.getBooleanProperty("generic") || this.attributeMain) {
            this.printer.indent().pln("import xtc.tree.Node;");
            bl3 = true;
        }
        if (module.getBooleanProperty("generic")) {
            if (null == this.factoryClassName) {
                this.printer.indent().pln("import xtc.tree.GNode;");
            } else if (Utilities.isQualified(this.factoryClassName)) {
                this.printer.indent().p("import ").p(this.factoryClassName).pln(';');
                this.factoryClassName = Utilities.getName(this.factoryClassName);
            }
            bl3 = true;
        }
        if (this.attributeParseTree) {
            this.printer.indent().pln("import xtc.tree.Token;");
            this.printer.indent().pln("import xtc.tree.Formatting;");
            bl3 = true;
        }
        if (bl2 || this.attributeMain || this.attributeProfile || this.attributeDump) {
            this.printer.indent().pln("import xtc.tree.Printer;");
            bl3 = true;
        }
        if (this.attributePrinter) {
            this.printer.indent().pln("import xtc.tree.Visitor;");
            bl3 = true;
        }
        if (bl3) {
            this.printer.pln();
        }
        this.printer.indent().pln("import xtc.parser.ParserBase;");
        this.printer.indent().pln("import xtc.parser.Column;");
        this.printer.indent().pln("import xtc.parser.Result;");
        this.printer.indent().pln("import xtc.parser.SemanticValue;");
        this.printer.indent().pln("import xtc.parser.ParseError;");
        this.printer.pln();
        if (null != module.header) {
            this.action(module.header);
            this.printer.pln();
        }
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Packrat parser for grammar <code>").p(module.name.name).pln("</code>.");
        this.printer.indent().pln(" *");
        this.printer.indent().p(" * <p />This class has been generated by the ").pln("<i>Rats!</i> parser");
        this.printer.indent().p(" * generator, version ").p("1.14.1").p(", ").p("(C) 2004-2008 Robert Grimm").pln('.');
        this.printer.indent().pln(" */");
        if (this.attributeRawTypes) {
            this.printer.indent().pln("@SuppressWarnings(\"unchecked\")");
        }
        this.printer.indent();
        if (module.hasAttribute("visibility")) {
            String string2 = (String)module.getAttributeValue("visibility");
            if (Constants.ATT_PUBLIC.getValue().equals(string2)) {
                this.printer.p("public ");
            }
        } else {
            this.printer.p("public ");
        }
        this.printer.p("final class ").p(this.className).pln(" extends ParserBase {").incr().pln();
        if (bl2) {
            this.printer.indent().p("/** Flag for whether to emit tracing information while ").pln("parsing. */");
            this.printer.indent().pln("public static final boolean DEBUG = true;");
            this.printer.pln();
            this.printer.indent().pln("/** Flag for whether to emit a peek into the input. */");
            this.printer.indent().pln("public static final boolean PEEK = true;");
            this.printer.pln();
        }
        if (module.hasAttribute("setOfString") || module.hasAttribute("flag")) {
            for (Attribute object2 : module.attributes) {
                if (object2.getName().equals("setOfString")) {
                    String string2 = (String)object2.getValue();
                    this.printer.indent().p("/** The ").p(string2).pln(" set. */");
                    if (this.attributeRawTypes) {
                        this.printer.indent().p("public static final Set ").p(string2).pln(" = new HashSet();");
                    } else {
                        this.printer.indent().p("public static final Set<String> ").p(string2).pln(" = new HashSet<String>();");
                    }
                    this.printer.pln();
                    continue;
                }
                if (!object2.getName().equals("flag")) continue;
                String string3 = (String)object2.getValue();
                this.printer.indent().p("/** The ").p(string3).pln(" flag. */");
                this.printer.indent().p("public static final boolean ").p(string3).pln(" = true;");
                this.printer.pln();
            }
        }
        int n2 = 0;
        for (Production production : module.productions) {
            if (this.runtime.test("optimizeTransient") && !production.isMemoized()) continue;
            ++n2;
        }
        if (this.runtime.test("optimizeChunks") && 10 <= n2) {
            this.chunked = true;
            this.chunkMap = new HashMap<NonTerminal, Integer>(n2 * 4 / 3);
            Object var6_10 = null;
            Object var7_23 = null;
            n = 10;
            bl = true;
            for (Production production : module.productions) {
                void var6_11;
                if (this.runtime.test("optimizeTransient") && !production.isMemoized()) continue;
                if (10 <= n) {
                    ++this.chunkCount;
                    Integer n3 = new Integer(this.chunkCount);
                    String string4 = Integer.toString(this.chunkCount);
                    n = 0;
                    if (bl) {
                        bl = false;
                        this.printer.sep();
                    } else {
                        this.printer.decr().indent().pln('}');
                    }
                    this.printer.pln();
                    this.printer.indent().p("/** Chunk ").p(string4).pln(" of memoized results. */");
                    this.printer.indent().p("static final class Chunk").p(string4).pln(" {").incr();
                }
                NonTerminal nonTerminal = production.name;
                this.chunkMap.put(nonTerminal, (Integer)var6_11);
                ++n;
                this.printer.indent().p("Result ").p(PREFIX_FIELD).p(nonTerminal.toIdentifier()).pln(';');
                if (!this.attributeProfile) continue;
                this.printer.indent().p("int    ").p(PREFIX_COUNT_FIELD).p(nonTerminal.toIdentifier()).pln(';');
            }
            this.printer.decr().indent().pln('}');
            this.printer.pln();
        }
        this.printer.sep().pln();
        this.printer.indent().pln("/** Memoization table column. */");
        this.printer.indent().p("static final class ").p(this.className).pln("Column extends Column {").incr();
        if (this.chunked) {
            void var6_15;
            boolean bl4 = true;
            while (var6_15 <= this.chunkCount) {
                this.printer.indent().p("Chunk").p((int)var6_15).p(' ').p("chunk").p((int)var6_15).pln(';');
                ++var6_15;
            }
        } else {
            for (Production production : module.productions) {
                if (this.runtime.test("optimizeTransient") && !production.isMemoized()) continue;
                this.printer.indent().p("Result ").p(PREFIX_FIELD).p(production.name.toIdentifier()).pln(';');
                if (!this.attributeProfile) continue;
                this.printer.indent().p("int    ").p(PREFIX_COUNT_FIELD).p(production.name.toIdentifier()).pln(';');
            }
        }
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        if (this.attributeStateful || bl2) {
            this.printer.sep().pln();
            if (this.attributeStateful) {
                this.printer.indent().pln("/** The global state object. */");
                this.printer.indent().p("protected final ").p(this.stateClassName).p(' ').p(STATE).pln(';');
                this.printer.pln();
            }
            if (bl2) {
                this.printer.indent().pln("/** The printer for tracing this parser. */");
                this.printer.indent().p("protected final Printer ").p(PRINTER).pln(';');
                this.printer.pln();
            }
        }
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Create a new packrat parser.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param reader The reader.");
        this.printer.indent().pln(" * @param file The file name.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("public ").p(this.className).pln("(final Reader reader, final String file) {").incr();
        this.printer.indent().pln("super(reader, file);");
        if (this.attributeStateful) {
            this.printer.indent().p(STATE).p(" = new ").p(this.stateClassName).pln("();");
        }
        if (bl2) {
            this.printer.indent().p(PRINTER).pln(" = new Printer(System.out);");
        }
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.indent().pln("/**");
        this.printer.indent().pln(" * Create a new packrat parser.");
        this.printer.indent().pln(" *");
        this.printer.indent().pln(" * @param reader The file reader.");
        this.printer.indent().pln(" * @param file The file name.");
        this.printer.indent().pln(" * @param size The file size.");
        this.printer.indent().pln(" */");
        this.printer.indent().p("public ").p(this.className).pln("(final Reader reader, final String file, final int size) {").incr();
        this.printer.indent().pln("super(reader, file, size);");
        if (this.attributeStateful) {
            this.printer.indent().p(STATE).p(" = new ").p(this.stateClassName).pln("();");
        }
        if (bl2) {
            this.printer.indent().p(PRINTER).pln(" = new Printer(System.out);");
        }
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        this.printer.sep().pln();
        this.printer.indent().pln("protected Column newColumn() {").incr();
        this.printer.indent().p("return new ").p(this.className).pln("Column();");
        this.printer.decr().indent().pln('}');
        this.printer.pln();
        for (Production production : module.productions) {
            n = this.attributeVerbose ? 1 : 0;
            bl = this.attributeWithLocation;
            boolean bl5 = this.attributeConstant;
            boolean bl6 = this.attributeIgnoringCase;
            if (n == 0 && production.hasAttribute(Constants.ATT_VERBOSE)) {
                this.attributeVerbose = true;
            }
            if (!bl && production.hasAttribute(Constants.ATT_WITH_LOCATION)) {
                this.attributeWithLocation = true;
            }
            if (!bl5 && production.hasAttribute(Constants.ATT_CONSTANT)) {
                this.attributeConstant = true;
            }
            if (!bl6 && production.hasAttribute(Constants.ATT_IGNORING_CASE)) {
                this.attributeIgnoringCase = true;
            }
            this.analyzer.process(production);
            this.attributeIgnoringCase = bl6;
            this.attributeConstant = bl5;
            this.attributeWithLocation = bl;
            this.attributeVerbose = n;
        }
        if (null != module.body) {
            this.printer.sep().pln();
            this.action(module.body);
            this.printer.pln();
        }
        if (module.getBooleanProperty("generic") || module.hasAttribute(Constants.ATT_GENERIC_AS_VOID)) {
            this.printer.sep().pln();
            if (this.attributeParseTree) {
                this.printer.indent().pln("/**");
                this.printer.indent().p(" * Get the text for the specified annotated ").pln("token.");
                this.printer.indent().pln(" *");
                this.printer.indent().pln(" * @param n The annotated token.");
                this.printer.indent().pln(" * @return The corresponding text.");
                this.printer.indent().pln(" */");
                this.printer.indent().pln("protected static final String toText(Node n) {").incr();
                this.printer.indent().pln("return n.getTokenText();");
                this.printer.decr().indent().pln('}');
            } else {
                this.printer.indent().pln("/**");
                this.printer.indent().pln(" * Get the specified text.");
                this.printer.indent().pln(" *");
                this.printer.indent().pln(" * @param s The text.");
                this.printer.indent().pln(" * @return The text.");
                this.printer.indent().pln(" */");
                this.printer.indent().pln("protected static final String toText(String s) {").incr();
                this.printer.indent().pln("return s;");
                this.printer.decr().indent().pln('}');
            }
            this.printer.pln();
        }
        if (this.attributeStringSet) {
            this.printer.sep().pln();
            this.printer.indent().pln("/**");
            this.printer.indent().pln(" * Add the specified values to the specified set.");
            this.printer.indent().pln(" *");
            this.printer.indent().pln(" * @param set The set.");
            this.printer.indent().pln(" * @param values The new values.");
            this.printer.indent().pln(" */");
            if (this.attributeRawTypes) {
                this.printer.indent().p("protected static final ").pln("void add(Set set, Object[] values) {").incr();
                this.printer.indent().pln("for (int i=0; i<values.length; i++) {").incr();
                this.printer.indent().pln("set.add(values[i]);");
                this.printer.decr().indent().pln('}');
                this.printer.decr().indent().pln('}');
            } else {
                this.printer.indent().p("protected static final ").pln("<T> void add(Set<T> set, T[] values) {").incr();
                this.printer.indent().pln("for (T v : values) set.add(v);");
                this.printer.decr().indent().pln('}');
            }
            this.printer.pln();
            this.printer.indent().pln("/**");
            this.printer.indent().pln(" * Check whether the specified set contains the specified value.");
            this.printer.indent().pln(" *");
            this.printer.indent().pln(" * @param set The set.");
            this.printer.indent().pln(" * @param value The value.");
            this.printer.indent().pln(" * @return <code>true</code> if the set contains the value.");
            this.printer.indent().pln(" */");
            if (this.attributeRawTypes) {
                this.printer.indent().p("protected static final ").pln("boolean contains(Set set, Object value) {").incr();
                this.printer.indent().pln("return set.contains(value);");
                this.printer.decr().indent().pln('}');
            } else {
                this.printer.indent().p("protected static final ").pln("<T> boolean contains(Set<T> set, T value) {").incr();
                this.printer.indent().pln("return set.contains(value);");
                this.printer.decr().indent().pln('}');
            }
            this.printer.pln();
        }
        if (this.attributeVerbose) {
            this.verbose();
        }
        if (this.attributeProfile) {
            this.profile();
        }
        if (this.attributeDump) {
            this.dump();
        }
        if (this.attributeMain) {
            this.mainMethod(this.mainMethodNonterminal);
        }
        this.printer.decr().indent().pln('}');
        if (null != module.footer) {
            this.printer.pln().sep().pln();
            this.action(module.footer);
        }
    }

    public void visit(FullProduction fullProduction) {
        int n;
        Object object;
        String string;
        MetaData metaData = (MetaData)fullProduction.getProperty("metaData");
        this.repetitionTypes = metaData.boundRepetitions;
        this.optionTypes = metaData.options;
        String string2 = this.fieldName(fullProduction.name, PREFIX_FIELD);
        String string3 = this.methodName(fullProduction.name);
        this.printer.sep().pln();
        this.printer.indent().pln("/**");
        this.printer.indent().p(" * Parse ");
        if (fullProduction.getBooleanProperty("xtc.Constants.Synthetic")) {
            this.printer.p("synthetic ");
        }
        this.printer.p("nonterminal ").buffer().p(fullProduction.qName.name).p('.').fit(" * ").pln();
        if (fullProduction.hasProperty("duplicates")) {
            this.printer.indent();
            this.printer.p(" * This nonterminal represents the duplicate productions ");
            List<String> list = Properties.getDuplicates(fullProduction);
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                string = iterator.next();
                this.printer.buffer();
                if (1 < list.size() && !iterator.hasNext()) {
                    this.printer.p("and ");
                }
                this.printer.p(string);
                if (2 == list.size() && iterator.hasNext()) {
                    this.printer.p(' ');
                } else if (iterator.hasNext()) {
                    this.printer.p(", ");
                } else {
                    this.printer.p('.');
                }
                this.printer.fit(" * ");
            }
            this.printer.pln();
        }
        this.printer.indent().pln(" *");
        this.printer.indent().p(" * @param ").p(ARG_INDEX).pln(" The index.");
        this.printer.indent().pln(" * @return The result.");
        this.printer.indent().pln(" * @throws IOException Signals an I/O error.");
        this.printer.indent().pln(" */");
        this.printer.indent();
        if (fullProduction.hasAttribute(Constants.ATT_PUBLIC)) {
            this.printer.p("public");
        } else {
            this.printer.p("private");
        }
        long l = this.printer.line();
        this.printer.p(" Result ").p(string3).p("(final ").p(this.indexT()).p(' ').p(ARG_INDEX).p(") ").buffer().p("throws IOException {").fitMore().pln().incr();
        if (l + 1L < this.printer.line()) {
            this.printer.pln();
        }
        if (!this.runtime.test("optimizeTransient") || fullProduction.isMemoized()) {
            this.printer.indent().p(this.className).p("Column ").p(COLUMN).p(" = (").p(this.className).p("Column)column(").p(ARG_INDEX).pln(");");
            if (this.chunked) {
                string = this.chunkMap.get(fullProduction.name).toString();
                this.printer.indent().p("if (").p(this.nullExpr()).p(" == ").p(COLUMN).p(".chunk").p(string).p(") ").p(COLUMN).p(".chunk").p(string).p(" = new Chunk").p(string).pln("();");
            }
            if (fullProduction.getBooleanProperty("recursive")) {
                this.printer.indent().p("if (").p(this.nullExpr()).p(" == ").p(string2).pln(") {").incr();
                this.printer.indent().pln("Result current = ParseError.DUMMY;");
                this.printer.indent().pln("Result previous;");
                this.printer.indent().pln("do {").incr();
                this.printer.indent().p(string2).pln(" = current;");
                this.printer.pln();
                this.printer.indent().pln("previous = current;");
                this.printer.indent().p("current  = ").p(string3).p("$1(").p(ARG_INDEX).pln(");");
                this.printer.decr().indent().p("} while (current.hasValue() && ").buffer().p("current.index > previous.index);").fit("         ").pln();
                this.printer.pln();
                this.printer.indent().p("if (ParseError.DUMMY == previous && ").buffer().p("current.index > previous.index) {").fit("    ").pln().incr();
                this.printer.indent().p(string2).pln(" = current;");
                this.printer.decr().indent().pln('}');
                this.printer.decr().indent().pln('}');
            } else {
                this.printer.indent().p("if (").p(this.nullExpr()).p(" == ").p(string2).p(") ").buffer().p(string2).p(" = ").p(string3).p("$1(").p(ARG_INDEX).p(");").fitMore().pln();
            }
            if (this.attributeProfile) {
                this.printer.indent().p(this.fieldName(fullProduction.name, PREFIX_COUNT_FIELD)).pln("++;");
            }
            if (this.attributeVerbose) {
                this.printer.indent().p("traceLookup(\"").p(fullProduction.name.toIdentifier()).p("\", ").p(ARG_INDEX).p(", ").buffer().p(string2).p(");").fitMore().pln();
            }
            this.printer.indent().p("return ").p(string2).pln(';');
            this.printer.decr().indent().pln('}');
            this.printer.pln();
            this.printer.indent().p("/** Actually parse ");
            this.printer.p(fullProduction.qName.name).pln(". */");
            l = this.printer.line();
            this.printer.indent().p("private Result ").p(string3).p("$1(final ").p(this.indexT()).p(' ').p(ARG_INDEX).p(") ").buffer().p("throws IOException {").fitMore().pln().incr();
            if (l + 1L < this.printer.line()) {
                this.printer.pln();
            }
        }
        string = this.extern(fullProduction.type);
        if (this.attributeRawTypes) {
            string = this.rawT(string);
        }
        int n2 = Math.max("ParseError".length(), string.length());
        if (!this.attributeRawTypes) {
            for (Type type2 : this.repetitionTypes) {
                if (null == type2) continue;
                n2 = Math.max(n2, this.extern(type2).length());
            }
        }
        for (Type type2 : this.optionTypes) {
            if (null == type2) continue;
            object = this.extern(type2);
            if (this.attributeRawTypes) {
                object = this.rawT((String)object);
            }
            n2 = Math.max(n2, ((String)object).length());
        }
        int n3 = this.printer.level() * 2 + n2 + 1 + 1;
        if (metaData.requiresChar) {
            this.printer.indent().p(this.intT()).align(n3).p(CHAR).pln(';');
        }
        if (metaData.requiresIndex) {
            this.printer.indent().p(this.indexT()).align(n3).p(INDEX).pln(';');
        }
        if (metaData.requiresResult) {
            this.printer.indent().p("Result").align(n3).p(RESULT).pln(';');
        }
        if (metaData.requiresPredIndex) {
            this.printer.indent().p(this.indexT()).align(n3).p(PRED_INDEX).pln(';');
        }
        if (metaData.requiresPredResult) {
            this.printer.indent().p("Result").align(n3).p(PRED_RESULT).pln(';');
        }
        if (metaData.requiresPredMatch) {
            this.printer.indent().p(this.booleanT()).align(n3).p(PRED_MATCHED).pln(';');
        }
        if (metaData.requiresBaseIndex) {
            this.printer.indent().p(this.indexT()).align(n3).p(BASE_INDEX).pln(';');
        }
        for (n = 0; n < metaData.repetitions.size(); ++n) {
            this.printer.indent().p(this.indexT()).align(n3).p(REPETITION).p(n + 1).pln(';');
            if (metaData.repetitions.get(n).booleanValue()) {
                this.printer.indent().p(this.booleanT()).align(n3).p(REPEATED).p(n + 1).pln(';');
            }
            if (null == this.repetitionTypes.get(n)) continue;
            this.printer.indent();
            if (this.attributeRawTypes) {
                this.printer.p(this.rawT(this.extern(new InstantiatedT(AST.ANY, AST.LIST))));
            } else {
                this.printer.p(this.extern(this.repetitionTypes.get(n)));
            }
            this.printer.align(n3).p(REP_VALUE).p(n + 1).pln(';');
        }
        for (n = 0; n < metaData.options.size(); ++n) {
            this.printer.indent().p(this.indexT()).align(n3).p(OPTION).p(n + 1).pln(';');
            object = metaData.options.get(n);
            if (null == object) continue;
            String string4 = this.extern((Type)object);
            if (this.attributeRawTypes) {
                string4 = this.rawT(string4);
            }
            this.printer.indent().p(string4).align(n3).p(OP_VALUE).p(n + 1).pln(';');
        }
        this.printer.indent().p(string).align(n3).p(VALUE).pln(';');
        this.printer.indent().p("ParseError").align(n3).p(PARSE_ERROR).pln(" = ParseError.DUMMY;");
        if (this.attributeVerbose) {
            this.printer.pln();
            this.printer.indent().p("traceEnter(\"").p(fullProduction.name.toIdentifier()).p("\", ").p(ARG_INDEX).pln(");");
        }
        if (this.attributeStateful) {
            if (fullProduction.hasAttribute(Constants.ATT_RESETTING)) {
                this.printer.pln();
                this.printer.indent().pln("// Reset the global state object.");
                this.printer.indent().p(STATE).p(".reset(column(").p(ARG_INDEX).pln(").file);");
            }
            if (fullProduction.hasAttribute(Constants.ATT_STATEFUL)) {
                this.printer.pln();
                this.printer.indent().pln("// Start a state modification.");
                this.printer.indent().p(STATE).pln(".start();");
            }
        }
        this.indexName = INDEX;
        this.resultName = RESULT;
        this.baseIndex = ARG_INDEX;
        this.useBaseIndex = true;
        this.indentLevel = 0;
        this.choiceLevel = -1;
        this.repetitionLevel = 0;
        this.savedRepetitionLevel = 0;
        this.repeatOnce = false;
        this.repeatedElement = null;
        this.optionLevel = 0;
        this.savedOptionLevel = 0;
        this.optionalElement = null;
        this.createsNodeValue = false;
        this.seenTest = false;
        this.endsWithParseError = false;
        this.dispatch(fullProduction.choice);
        if (this.seenTest) {
            if (this.attributeStateful && fullProduction.hasAttribute(Constants.ATT_STATEFUL)) {
                this.printer.pln();
                this.printer.indent().pln("// Abort the state modification.");
                this.printer.indent().p(STATE).pln(".abort();");
            }
            this.printer.pln();
            this.printer.indent().pln("// Done.");
            if (this.endsWithParseError && (fullProduction.isMemoized() || !this.runtime.test("optimizeErrors2"))) {
                this.parseError();
            }
            if (this.attributeVerbose) {
                this.printer.indent().p("traceFailure(\"").p(fullProduction.name.toIdentifier()).p("\", ").p(ARG_INDEX).pln(");");
            }
            this.printer.indent().p("return ").p(PARSE_ERROR).pln(';');
        }
        this.printer.decr().indent().pln('}');
        this.printer.pln();
    }

    protected void result(String string, boolean bl) {
        this.printer.pln();
        this.firstElement = false;
        String string2 = PARSE_CHAR.equals(string) ? CHAR : this.resultName;
        int n = string2.length();
        if (bl) {
            n = Math.max(n, BASE_INDEX.length());
        }
        if (!this.notFollowedBy() && !PARSE_CHAR.equals(string)) {
            n = Math.max(n, PARSE_ERROR.length());
        }
        n += this.printer.level() * 2 + 1 + 1;
        if (this.useBaseIndex) {
            if (bl) {
                this.printer.indent().p(BASE_INDEX).align(n).p("= ").buffer().p(this.baseIndex).p(';').fitMore().pln();
                this.printer.indent().p(string2).align(n).p("= ").buffer().p(string).p('(').p(BASE_INDEX).p(");").fitMore().pln();
            } else {
                this.printer.indent().p(string2).align(n).p("= ").buffer().p(string).p('(').p(this.baseIndex).p(");").fitMore().pln();
            }
            if (!this.notFollowedBy() && !PARSE_CHAR.equals(string)) {
                if (this.runtime.test("optimizeSelect")) {
                    this.printer.indent().p(PARSE_ERROR).align(n).p("= ").buffer().p(this.resultName).p(".select(").p(PARSE_ERROR).p(");").fitMore().pln();
                } else {
                    this.printer.indent().p(PARSE_ERROR).align(n).p("= ").buffer().p(PARSE_ERROR).p(".select(").p(this.resultName).p(".parseError());").fitMore().pln();
                }
            }
            this.useBaseIndex = false;
        } else {
            if (bl) {
                this.printer.indent().p(BASE_INDEX).align(n).p("= ").buffer().p(this.resultName).p(".index;").fitMore().pln();
                this.printer.indent().p(string2).align(n).p("= ").buffer().p(string).p('(').p(BASE_INDEX).p(");").fitMore().pln();
            } else {
                this.printer.indent().p(string2).align(n).p("= ").buffer().p(string).p('(').p(this.resultName).p(".index);").fitMore().pln();
            }
            if (!this.notFollowedBy() && !PARSE_CHAR.equals(string)) {
                if (this.runtime.test("optimizeSelect")) {
                    this.printer.indent().p(PARSE_ERROR).align(n).p("= ").buffer().p(this.resultName).p(".select(").p(PARSE_ERROR).p(");").fitMore().pln();
                } else {
                    this.printer.indent().p(PARSE_ERROR).align(n).p("= ").buffer().p(PARSE_ERROR).p(".select(").p(this.resultName).p(".parseError());").fitMore().pln();
                }
            }
        }
    }

    protected void valueTest() {
        this.printer.indent().p("if (").p(this.resultName).pln(".hasValue()) {").incr();
    }

    protected void charValueTest() {
        this.printer.indent().p("if (-1 != ").p(CHAR).pln(") {").incr();
    }

    protected void stringValueTest(String string, boolean bl) {
        if (this.attributeParseTree) {
            if (bl) {
                this.printer.indent().p("if (").p(this.resultName).pln(".hasValue() &&").indent().p("    ((Node)").p(this.resultName).p(".semanticValue()).getTokenText().equalsIgnoreCase(\"").escape(string, 8).pln("\")) {").incr();
            } else {
                this.printer.indent().p("if (").p(this.resultName).pln(".hasValue() &&").indent().p("    ((Node)").p(this.resultName).p(".semanticValue()).getTokenText().equals(\"").escape(string, 8).pln("\")) {").incr();
            }
        } else if (this.runtime.test("optimizeMatches")) {
            if (bl) {
                this.printer.indent().p("if (").p(this.resultName).p(".hasValueIgnoreCase(\"").escape(string, 8).pln("\")) {").incr();
            } else {
                this.printer.indent().p("if (").p(this.resultName).p(".hasValue(\"").escape(string, 8).pln("\")) {").incr();
            }
        } else if (bl) {
            this.printer.indent().p("if (").p(this.resultName).pln(".hasValue() &&").indent().p("   \"").escape(string, 8).p("\".equalsIgnoreCase(").p(this.resultName).pln(".semanticValue().toString())) {").incr();
        } else {
            this.printer.indent().p("if (").p(this.resultName).pln(".hasValue() &&").indent().p("   \"").escape(string, 8).p("\".equals(").p(this.resultName).pln(".semanticValue())) {").incr();
        }
    }

    protected void index(String string, boolean bl) {
        if (this.predicate && (this.predicateIter.hasNext() || !bl || this.savedRepetitionLevel < this.repetitionLevel || this.savedOptionLevel < this.optionLevel) || !this.predicate) {
            this.printer.indent().p(this.indexName).p(" = ").p(string).pln(" + 1;");
            this.useBaseIndex = true;
            this.baseIndex = this.indexName;
        }
    }

    protected void saveIndex(String string, String string2, String string3) {
        if (this.useBaseIndex) {
            if (!string.equals(string3)) {
                this.printer.indent().p(string).p(string2).p(" = ").p(string3).pln(';');
            }
            this.useBaseIndex = false;
        } else {
            this.printer.indent().p(string).p(string2).p(" = ").p(this.resultName).pln(".index;");
        }
    }

    protected void tested() {
        this.seenTest = true;
    }

    protected void nextElement() {
        if (this.predicate) {
            if (this.predicateIter.hasNext()) {
                this.dispatch(this.predicateIter.next());
                return;
            }
            if (this.savedRepetitionLevel < this.repetitionLevel) {
                this.printer.pln();
                this.saveIndex(REPETITION + this.repetitionLevel, "", this.baseIndex);
                if (this.repeatOnce) {
                    this.printer.indent().p(REPEATED).p(this.repetitionLevel).pln("   = true;");
                }
                if (null != this.repeatedElement) {
                    this.printer.indent().p(REP_VALUE).p(this.repetitionLevel).p("   = ").buffer();
                    if (this.attributeRawTypes) {
                        this.printer.p("new Pair(");
                    } else {
                        this.printer.p("new ").p(this.extern(this.repetitionTypes.get(this.repetitionLevel - 1))).p('(');
                    }
                    this.printer.p(this.repeatedElement).p(", ").p(REP_VALUE).p(this.repetitionLevel).p(");").fitMore().pln();
                }
                this.printer.indent().pln("continue;");
                return;
            }
            if (this.savedOptionLevel < this.optionLevel) {
                this.printer.pln();
                this.saveIndex(OPTION + this.optionLevel, " ", this.baseIndex);
                if (null != this.optionalElement) {
                    this.printer.indent().p(OP_VALUE).p(this.optionLevel).p(" = ").p(this.optionalElement).pln(';');
                }
                return;
            }
            if (this.notFollowedBy) {
                this.printer.pln();
                this.printer.indent().p(PRED_MATCHED).pln(" = true;");
                return;
            }
            this.predicate = false;
            this.firstElement = this.savedFirstElement;
            this.baseIndex = this.savedBaseIndex;
            this.useBaseIndex = this.savedUseBaseIndex;
            this.indexName = INDEX;
            this.resultName = RESULT;
        }
        if (this.elementIter.hasNext()) {
            this.dispatch(this.elementIter.next());
        } else if (0 < this.repetitionLevel) {
            this.printer.pln();
            this.saveIndex(REPETITION + this.repetitionLevel, "", this.baseIndex);
            if (this.repeatOnce) {
                this.printer.indent().p(REPEATED).p(this.repetitionLevel).pln("   = true;");
            }
            if (null != this.repeatedElement) {
                this.printer.indent().p(REP_VALUE).p(this.repetitionLevel).p("   = ").buffer();
                if (this.attributeRawTypes) {
                    this.printer.p("new Pair(");
                } else {
                    this.printer.p("new ").p(this.extern(this.repetitionTypes.get(this.repetitionLevel - 1))).p('(');
                }
                this.printer.p(this.repeatedElement).p(", ").p(REP_VALUE).p(this.repetitionLevel).p(");").fitMore().pln();
            }
            this.printer.indent().pln("continue;");
        } else if (0 < this.optionLevel) {
            this.printer.pln();
            this.saveIndex(OPTION + this.optionLevel, " ", this.baseIndex);
            if (null != this.optionalElement) {
                this.printer.indent().p(OP_VALUE).p(this.optionLevel).p(" = ").p(this.optionalElement).pln(';');
            }
        } else {
            this.returnValue();
        }
    }

    private void location() {
        if (!this.attributeWithLocation) {
            return;
        }
        if (this.runtime.test("optimizeLocation") && !this.createsNodeValue) {
            return;
        }
        Constants.FuzzyBoolean fuzzyBoolean = this.ast.hasLocation(this.analyzer.current().type);
        if (Constants.FuzzyBoolean.FALSE == fuzzyBoolean) {
            return;
        }
        if (Constants.FuzzyBoolean.MAYBE == fuzzyBoolean) {
            this.printer.indent().p("if (").p(VALUE).pln(" instanceof Locatable) {").incr();
            this.printer.indent().p("setLocation((Locatable)").p(VALUE).p(", ").p(ARG_INDEX).pln(");");
            this.printer.decr().indent().pln('}');
        } else {
            this.printer.indent().p("setLocation(").p(VALUE).p(", ").p(ARG_INDEX).pln(");");
        }
    }

    protected void returnValue() {
        this.printer.pln();
        if (this.attributeStateful && this.analyzer.current().hasAttribute(Constants.ATT_STATEFUL)) {
            this.printer.indent().pln("// Commit the state modification.");
            this.printer.indent().p(STATE).pln(".commit();");
            this.printer.pln();
        }
        this.location();
        if (this.attributeVerbose) {
            this.printer.indent().p("traceSuccess(\"").p(this.analyzer.current().name.toIdentifier()).p("\", ").p(ARG_INDEX).pln(");");
        }
        if (this.useBaseIndex) {
            this.printer.indent().p("return new SemanticValue(").p(VALUE).p(", ").p(this.baseIndex).p(", ").p(PARSE_ERROR).pln(");");
            this.useBaseIndex = false;
        } else if (this.runtime.test("optimizeValues")) {
            this.printer.indent().p("return ").p(RESULT).p(".createValue(").p(VALUE).p(", ").p(PARSE_ERROR).pln(");");
        } else {
            this.printer.indent().p("return new SemanticValue(").p(VALUE).p(", ").p(RESULT).p(".index, ").p(PARSE_ERROR).pln(");");
        }
    }

    protected void parseError() {
        this.printer.indent().p(PARSE_ERROR).p(" = ").p(PARSE_ERROR).p(".select(\"").p(Utilities.split(this.analyzer.current().name.unqualify().name, ' ')).p(" expected\", ").p(ARG_INDEX).pln(");");
    }

    protected void parseError(String string) {
        this.printer.indent().p(PARSE_ERROR).p(" = ").p(PARSE_ERROR).p(".select(\"\\\"").p(Utilities.escape(string, 10)).p("\\\" expected\", ").p(BASE_INDEX).pln(");");
    }

    protected String nestedChoice() {
        return NESTED_CHOICE + Integer.toString(this.choiceLevel);
    }

    public void visit(OrderedChoice orderedChoice) {
        boolean bl;
        String string = this.baseIndex;
        boolean bl2 = this.useBaseIndex;
        boolean bl3 = this.createsNodeValue;
        int n = this.indentLevel;
        this.indentLevel = this.printer.level();
        ++this.choiceLevel;
        boolean bl4 = bl = n == this.indentLevel;
        if (bl) {
            this.printer.indent().pln("{ // Start scope for nested choice.").incr();
        }
        if (0 != this.choiceLevel) {
            this.printer.pln();
            if (this.useBaseIndex) {
                this.printer.indent().p("final ").p(this.indexT()).p(' ').p(this.nestedChoice()).p(" = ").p(string).pln(';');
                this.useBaseIndex = false;
            } else {
                this.printer.indent().p("final ").p(this.indexT()).p(' ').p(this.nestedChoice()).p(" = ").buffer().p(this.resultName).p(".index;").fitMore().pln();
            }
        }
        int n2 = 0;
        for (Sequence sequence : orderedChoice.alternatives) {
            this.elementIter = sequence.elements.iterator();
            if (0 == this.choiceLevel) {
                this.firstElement = true;
            }
            this.baseIndex = 0 == this.choiceLevel ? ARG_INDEX : this.nestedChoice();
            this.useBaseIndex = true;
            this.createsNodeValue = bl3;
            this.seenTest = false;
            ++n2;
            this.printer.pln();
            if (0 == this.choiceLevel) {
                this.printer.indent().p("// Alternative ");
            } else {
                this.printer.indent().p("// Nested alternative ");
            }
            if (null == sequence.name) {
                this.printer.p(n2).pln('.');
            } else {
                this.printer.p('<').p(sequence.name.name).pln(">.");
            }
            this.nextElement();
        }
        if (bl) {
            this.printer.decr().indent().pln("} // End scope for nested choice.");
        }
        --this.choiceLevel;
        this.indentLevel = n;
        this.useBaseIndex = bl2;
        this.baseIndex = string;
    }

    public void visit(Repetition repetition) {
        Iterator<Element> iterator;
        Object object;
        assert (repetition.element instanceof Sequence);
        this.firstElement = false;
        String string = this.baseIndex;
        boolean bl = this.useBaseIndex;
        boolean bl2 = this.repeatOnce;
        this.repeatOnce = repetition.once;
        String string2 = this.repeatedElement;
        if (this.hasBinding()) {
            object = Analyzer.getBinding(((Sequence)repetition.element).elements);
            this.repeatedElement = ((Binding)object).name;
            this.bindingType = AST.listOf(this.ast.concretize(this.analyzer.type(((Binding)object).element), AST.ANY));
        } else {
            this.repeatedElement = null;
            this.bindingType = null;
        }
        object = this.bindingName;
        this.bindingName = null;
        Element element = this.bindingElement;
        this.bindingElement = null;
        Type type2 = this.bindingType;
        this.bindingType = null;
        ++this.repetitionLevel;
        this.printer.pln();
        this.saveIndex(REPETITION + this.repetitionLevel, "", string);
        if (this.repeatOnce) {
            this.printer.indent().p(REPEATED).p(this.repetitionLevel).pln("   = false;");
        }
        if (null != object) {
            this.printer.indent().p(REP_VALUE).p(this.repetitionLevel).p("   = ").p(this.emptyListExpr()).pln(';');
        }
        if (this.predicate) {
            iterator = this.predicateIter;
            this.predicateIter = ((Sequence)repetition.element).elements.iterator();
        } else {
            iterator = this.elementIter;
            this.elementIter = ((Sequence)repetition.element).elements.iterator();
        }
        this.printer.indent().pln("while (true) {").incr();
        this.baseIndex = REPETITION + this.repetitionLevel;
        this.useBaseIndex = true;
        this.nextElement();
        this.printer.indent().pln("break;");
        this.printer.decr().indent().pln('}');
        if (this.predicate) {
            this.predicateIter = iterator;
        } else {
            this.elementIter = iterator;
        }
        if (this.repeatOnce) {
            this.printer.pln();
            this.printer.indent().p("if (").p(REPEATED).p(this.repetitionLevel).pln(") {").incr();
        }
        --this.repetitionLevel;
        this.repeatOnce = bl2;
        this.repeatedElement = string2;
        this.bindingName = object;
        this.bindingElement = element;
        this.bindingType = type2;
        boolean bl3 = false;
        Object object2 = object;
        if (this.hasBinding()) {
            if (!repetition.once) {
                this.printer.indent().p("{ // Start scope for ").p((String)object2).pln('.').incr();
                bl3 = true;
            }
            this.binding();
            this.clearBinding();
        }
        this.baseIndex = REPETITION + Integer.toString(this.repetitionLevel + 1);
        this.useBaseIndex = true;
        if (!repetition.once) {
            this.seenTest = false;
        }
        this.nextElement();
        if (repetition.once) {
            this.printer.decr().indent().pln('}');
            this.tested();
        } else if (bl3) {
            this.printer.decr().indent().p("} // End scope for ").p((String)object2).pln('.');
        }
        this.baseIndex = string;
        this.useBaseIndex = bl;
    }

    public void visit(Option option) {
        Iterator<Element> iterator;
        Object object;
        assert (option.element instanceof Sequence);
        this.firstElement = false;
        String string = this.baseIndex;
        boolean bl = this.useBaseIndex;
        String string2 = this.optionalElement;
        if (this.hasBinding()) {
            object = Analyzer.getBinding(((Sequence)option.element).elements);
            this.optionalElement = ((Binding)object).name;
            this.bindingType = this.ast.concretize(this.analyzer.type(((Binding)object).element), AST.ANY);
        } else {
            this.optionalElement = null;
            this.bindingType = null;
        }
        object = this.bindingName;
        this.bindingName = null;
        Element element = this.bindingElement;
        this.bindingElement = null;
        Type type2 = this.bindingType;
        this.bindingType = null;
        ++this.optionLevel;
        this.printer.pln();
        this.saveIndex(OPTION + this.optionLevel, " ", string);
        if (null != object) {
            this.printer.indent().p(OP_VALUE).p(this.optionLevel).p(" = ").p(this.nullExpr()).pln(';');
        }
        if (this.predicate) {
            iterator = this.predicateIter;
            this.predicateIter = ((Sequence)option.element).elements.iterator();
        } else {
            iterator = this.elementIter;
            this.elementIter = ((Sequence)option.element).elements.iterator();
        }
        int n = this.repetitionLevel;
        this.repetitionLevel = 0;
        this.baseIndex = OPTION + this.optionLevel;
        this.useBaseIndex = true;
        this.nextElement();
        if (this.predicate) {
            this.predicateIter = iterator;
        } else {
            this.elementIter = iterator;
        }
        this.repetitionLevel = n;
        --this.optionLevel;
        this.optionalElement = string2;
        this.bindingName = object;
        this.bindingElement = element;
        this.bindingType = type2;
        boolean bl2 = false;
        Object object2 = object;
        if (this.hasBinding()) {
            this.printer.indent().p("{ // Start scope for ").p((String)object2).pln('.').incr();
            bl2 = true;
            this.binding();
            this.clearBinding();
        }
        this.baseIndex = OPTION + Integer.toString(this.optionLevel + 1);
        this.useBaseIndex = true;
        this.seenTest = false;
        this.nextElement();
        if (bl2) {
            this.printer.decr().indent().p("} // End scope for ").p((String)object2).pln('.');
        }
        this.baseIndex = string;
        this.useBaseIndex = bl;
    }

    public void visit(FollowedBy followedBy) {
        assert (!this.predicate);
        assert (followedBy.element instanceof Sequence);
        this.predicate = true;
        this.notFollowedBy = false;
        this.savedFirstElement = this.firstElement;
        this.savedBaseIndex = this.baseIndex;
        if (!this.useBaseIndex) {
            this.baseIndex = "yyResult.index";
        }
        this.savedUseBaseIndex = this.useBaseIndex;
        this.savedRepetitionLevel = this.repetitionLevel;
        this.savedOptionLevel = this.optionLevel;
        this.useBaseIndex = true;
        this.indexName = PRED_INDEX;
        this.resultName = PRED_RESULT;
        this.predicateIter = ((Sequence)followedBy.element).elements.iterator();
        this.nextElement();
        this.tested();
    }

    protected boolean notFollowedBy() {
        return this.predicate && this.notFollowedBy;
    }

    public void visit(NotFollowedBy notFollowedBy) {
        assert (!this.predicate);
        assert (notFollowedBy.element instanceof Sequence);
        this.predicate = true;
        this.notFollowedBy = true;
        this.savedFirstElement = this.firstElement;
        this.savedBaseIndex = this.baseIndex;
        if (!this.useBaseIndex) {
            this.baseIndex = "yyResult.index";
        }
        this.savedUseBaseIndex = this.useBaseIndex;
        this.useBaseIndex = true;
        this.savedRepetitionLevel = this.repetitionLevel;
        this.savedOptionLevel = this.optionLevel;
        this.indexName = PRED_INDEX;
        this.resultName = PRED_RESULT;
        this.predicateIter = ((Sequence)notFollowedBy.element).elements.iterator();
        this.printer.pln();
        this.printer.indent().p(PRED_MATCHED).pln(" = false;");
        this.nextElement();
        this.predicate = false;
        this.firstElement = this.savedFirstElement;
        this.baseIndex = this.savedBaseIndex;
        this.useBaseIndex = this.savedUseBaseIndex;
        this.indexName = INDEX;
        this.resultName = RESULT;
        this.printer.pln();
        this.printer.indent().p("if (! ").p(PRED_MATCHED).pln(") {").incr();
        this.nextElement();
        this.printer.decr().indent().pln("} else {").incr();
        this.parseError();
        this.printer.decr().indent().pln('}');
        this.tested();
    }

    public void visit(SemanticPredicate semanticPredicate) {
        this.printer.pln().indent().p("if (");
        Action action = (Action)semanticPredicate.element;
        if (1 == action.code.size()) {
            this.printer.p(action.code.get(0)).pln(") {").incr();
        } else {
            boolean bl = true;
            int n = this.printer.column();
            for (String string : action.code) {
                if (bl) {
                    this.printer.p(string);
                    bl = false;
                    continue;
                }
                this.printer.pln().align(n).p(string);
            }
            this.printer.pln(") {").incr();
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(VoidedElement voidedElement) {
        this.dispatch(voidedElement.element);
    }

    public void visit(Binding binding) {
        String string = this.bindingName;
        Element element = this.bindingElement;
        Type type2 = this.bindingType;
        this.bindingName = binding.name;
        this.bindingElement = binding.element;
        this.bindingType = null;
        this.dispatch(binding.element);
        this.bindingName = string;
        this.bindingElement = element;
        this.bindingType = type2;
    }

    protected boolean hasBinding() {
        return null != this.bindingName;
    }

    protected void binding() {
        switch (this.bindingElement.tag()) {
            case NONTERMINAL: {
                Type type2 = VALUE.equals(this.bindingName) ? this.analyzer.current().type : this.analyzer.lookup((NonTerminal)((NonTerminal)this.bindingElement)).type;
                Type type3 = this.attributeRawTypes && !AST.isAny(type2) ? type2 : null;
                this.binding1(this.extern(type2), this.bindingName, this.extern(type3), this.resultName + ".semanticValue()");
                break;
            }
            case ANY_CHAR: 
            case CHAR_CLASS: 
            case CHAR_LITERAL: 
            case CHAR_SWITCH: {
                if (VALUE.equals(this.bindingName)) {
                    this.binding1(this.extern(AST.CHAR), this.bindingName, null, "Character.valueOf((" + this.charT() + ")" + CHAR + ")");
                    break;
                }
                this.binding1(this.charT(), this.bindingName, null, "(" + this.charT() + ")" + CHAR);
                break;
            }
            case STRING_LITERAL: {
                String string = ((StringLiteral)this.bindingElement).text;
                this.binding1(this.extern(AST.STRING), this.bindingName, null, '\"' + Utilities.escape(string, 8) + '\"');
                break;
            }
            case STRING_MATCH: {
                if (this.attributeParseTree) {
                    String string = this.attributeRawTypes ? this.extern(AST.NODE) : null;
                    this.binding1(this.extern(AST.NODE), this.bindingName, string, this.resultName + ".semanticValue()");
                    break;
                }
                this.binding1(this.extern(AST.STRING), this.bindingName, null, "\"" + Utilities.escape(((StringMatch)this.bindingElement).text, 8) + "\"");
                break;
            }
            case REPETITION: {
                int n = this.repetitionLevel + 1;
                String string = REP_VALUE + n + ".reverse()";
                if (!this.attributeRawTypes && !this.repetitionTypes.get(this.repetitionLevel).equals(this.bindingType)) {
                    string = "cast(" + string + ')';
                }
                this.binding1(this.extern(this.bindingType), this.bindingName, null, string);
                break;
            }
            case OPTION: {
                int n = this.optionLevel + 1;
                String string = null;
                String string2 = OP_VALUE + n;
                if (!this.optionTypes.get(this.optionLevel).equals(this.bindingType)) {
                    if (this.attributeRawTypes) {
                        string = this.extern(this.bindingType);
                    } else {
                        string2 = "cast(" + string2 + ')';
                    }
                }
                this.binding1(this.extern(this.bindingType), this.bindingName, string, string2);
                break;
            }
            case NULL: {
                this.binding1(this.extern(AST.ANY), this.bindingName, null, this.nullExpr());
                break;
            }
            default: {
                throw new AssertionError((Object)("Unrecognized binding element " + this.bindingElement));
            }
        }
    }

    private void binding1(String string, String string2, String string3, String string4) {
        if (this.attributeRawTypes) {
            string = this.rawT(string);
            if (null != string3) {
                string3 = this.rawT(string3);
            }
        }
        this.printer.indent();
        if (VALUE.equals(string2)) {
            this.printer.p(VALUE);
        } else {
            if (this.attributeConstant) {
                this.printer.p("final ");
            }
            this.printer.p(string).p(' ').p(string2);
        }
        this.printer.p(" = ");
        if (null != string3) {
            this.printer.p('(').p(string3).p(')');
        }
        this.printer.p(string4).pln(';');
    }

    protected void clearBinding() {
        this.bindingName = null;
        this.bindingElement = null;
    }

    public void visit(StringMatch stringMatch) {
        boolean bl = this.firstElement;
        NonTerminal nonTerminal = (NonTerminal)stringMatch.element;
        this.result(this.methodName(nonTerminal), !this.notFollowedBy() && (!this.runtime.test("optimizeErrors1") || !bl));
        this.stringValueTest(stringMatch.text, this.attributeIgnoringCase);
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        if (this.notFollowedBy()) {
            this.printer.decr().indent().pln('}');
        } else if (this.runtime.test("optimizeErrors1") && bl) {
            this.printer.decr().indent().pln('}');
            this.endsWithParseError = true;
        } else {
            this.printer.decr().indent().pln("} else {").incr();
            this.parseError(stringMatch.text);
            this.printer.decr().indent().pln('}');
        }
        this.tested();
    }

    public void visit(NonTerminal nonTerminal) {
        this.result(this.methodName(nonTerminal), false);
        this.valueTest();
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        if (!this.notFollowedBy() && !this.analyzer.lookup(nonTerminal).isMemoized() && this.runtime.test("optimizeErrors2")) {
            this.endsWithParseError = true;
        }
        this.printer.decr().indent().pln('}');
        this.tested();
    }

    public void visit(AnyChar anyChar) {
        String string = this.useBaseIndex ? this.baseIndex : this.resultName + ".index";
        this.result(PARSE_CHAR, false);
        this.charValueTest();
        this.index(string, true);
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(CharLiteral charLiteral) {
        String string = this.useBaseIndex ? this.baseIndex : this.resultName + ".index";
        this.result(PARSE_CHAR, false);
        this.printer.indent().p("if ('").escape(charLiteral.c, 8).p("' == ").p(CHAR).pln(") {").incr();
        this.index(string, true);
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(CharClass charClass) {
        String string;
        String string2 = this.useBaseIndex ? this.baseIndex : this.resultName + ".index";
        this.result(PARSE_CHAR, false);
        this.charValueTest();
        this.index(string2, true);
        if (this.hasBinding()) {
            this.binding();
            string = this.bindingName;
            this.clearBinding();
            this.printer.pln();
        } else {
            string = CHAR;
        }
        int n = charClass.ranges.size();
        Iterator<CharRange> iterator = charClass.ranges.iterator();
        if (1 == n) {
            this.printer.indent().p("if ");
        } else {
            this.printer.indent().p("if (");
        }
        while (iterator.hasNext()) {
            CharRange charRange = iterator.next();
            if (charClass.exclusive) {
                if (charRange.first == charRange.last) {
                    this.printer.p("('").escape(charRange.first, 8).p("' != ").p(string).p(')');
                } else {
                    this.printer.p('(').p(string).p(" < '").escape(charRange.first, 8).p(") || ('").escape(charRange.last, 8).p("' < ").p(string).p("))");
                }
            } else if (charRange.first == charRange.last) {
                this.printer.p("('").escape(charRange.first, 8).p("' == ").p(string).p(')');
            } else {
                this.printer.p("(('").escape(charRange.first, 8).p("' <= ").p(string).p(") && (").p(string).p(" <= '").escape(charRange.last, 8).p("'))");
            }
            if (!iterator.hasNext()) continue;
            if (charClass.exclusive) {
                this.printer.pln(" &&");
            } else {
                this.printer.pln(" ||");
            }
            this.printer.indent().p("    ");
        }
        if (1 == n) {
            this.printer.pln(" {").incr();
        } else {
            this.printer.pln(") {").incr();
        }
        this.nextElement();
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        if (!this.notFollowedBy()) {
            this.endsWithParseError = true;
        }
        this.tested();
    }

    public void visit(StringLiteral stringLiteral) {
        int n;
        boolean bl = this.firstElement;
        int n2 = stringLiteral.text.length();
        for (n = 0; n < n2; ++n) {
            char c = stringLiteral.text.charAt(n);
            String string = this.useBaseIndex ? this.baseIndex : this.resultName + ".index";
            this.result(PARSE_CHAR, 0 == n && !this.notFollowedBy() && (!this.runtime.test("optimizeErrors1") || !bl));
            this.printer.indent().p("if ('").escape(c, 8).p("' == ").p(CHAR).pln(") {").incr();
            this.index(string, n == n2 - 1);
        }
        if (this.hasBinding()) {
            this.binding();
            this.clearBinding();
        }
        this.nextElement();
        for (n = 0; n < n2; ++n) {
            if (this.notFollowedBy()) {
                this.printer.decr().indent().pln('}');
                continue;
            }
            if (this.runtime.test("optimizeErrors1") && bl) {
                this.printer.decr().indent().pln('}');
                this.endsWithParseError = true;
                continue;
            }
            this.printer.decr().indent().pln("} else {").incr();
            this.parseError(stringLiteral.text);
            this.printer.decr().indent().pln('}');
        }
        this.tested();
    }

    public void visit(CharSwitch charSwitch) {
        String string;
        String string2 = this.useBaseIndex ? this.baseIndex : this.resultName + ".index";
        this.result(PARSE_CHAR, false);
        this.charValueTest();
        this.index(string2, true);
        this.printer.pln();
        String string3 = this.baseIndex;
        boolean bl = this.useBaseIndex;
        if (this.hasBinding()) {
            this.binding();
            string = this.bindingName;
            this.clearBinding();
            this.printer.pln();
        } else {
            string = CHAR;
        }
        this.printer.indent().p("switch (").p(string).pln(") {").incr();
        for (CharCase charCase : charSwitch.cases) {
            for (CharRange charRange : charCase.klass.ranges) {
                for (char c = charRange.first; c <= charRange.last; c = (char)(c + '\u0001')) {
                    this.printer.indentLess().p("case '").escape(c, 8).pln("':");
                }
            }
            if (null == charCase.element) {
                this.printer.indent().pln("/* No match. */");
                this.printer.indent().pln("break;");
            } else {
                this.printer.indent().p('{').incr();
                this.baseIndex = string3;
                this.useBaseIndex = bl;
                this.seenTest = false;
                if (charCase.element instanceof OrderedChoice) {
                    this.dispatch(charCase.element);
                } else {
                    this.elementIter = ((Sequence)charCase.element).elements.iterator();
                    this.nextElement();
                }
                this.printer.decr().indent().pln('}');
                if (this.seenTest) {
                    this.printer.indent().pln("break;");
                }
            }
            this.printer.pln();
        }
        if (null == charSwitch.base) {
            this.printer.indentLess().pln("default:");
            this.printer.indent().pln("/* No match. */");
        } else {
            this.printer.indentLess().pln("default:");
            this.printer.indent().p('{').incr();
            this.baseIndex = string3;
            this.useBaseIndex = bl;
            if (charSwitch.base instanceof OrderedChoice) {
                this.dispatch(charSwitch.base);
            } else {
                this.elementIter = ((Sequence)charSwitch.base).elements.iterator();
                this.nextElement();
            }
            this.printer.decr().indent().pln('}');
        }
        this.printer.decr().indent().pln('}');
        this.printer.decr().indent().pln('}');
        this.endsWithParseError = true;
        this.tested();
    }

    public void visit(NodeMarker nodeMarker) {
        this.nextElement();
    }

    protected void action(Action action) {
        int n = this.printer.level();
        int n2 = 0;
        Iterator<String> iterator = action.code.iterator();
        Iterator<Integer> iterator2 = action.indent.iterator();
        while (iterator.hasNext()) {
            int n3;
            int n4 = iterator2.next();
            int n5 = n4 - n2;
            n2 = n4;
            if (0 < n5) {
                for (n3 = 0; n3 < n5; ++n3) {
                    this.printer.incr();
                }
            } else {
                for (n3 = 0; n3 > n5; --n3) {
                    this.printer.decr();
                }
            }
            this.printer.indent().pln(iterator.next());
        }
        this.printer.setLevel(n);
    }

    public void visit(Action action) {
        if (action.setsValue()) {
            this.createsNodeValue = true;
        }
        this.printer.pln();
        this.action(action);
        this.nextElement();
    }

    public void visit(ParserAction parserAction) {
        this.createsNodeValue = true;
        this.printer.pln();
        this.saveIndex(BASE_INDEX, "", this.baseIndex);
        this.printer.pln();
        this.action((Action)parserAction.element);
        this.printer.pln();
        if (!this.notFollowedBy()) {
            if (this.runtime.test("optimizeSelect")) {
                this.printer.indent().p(PARSE_ERROR).p(" = ").buffer().p(this.resultName).p(".select(").p(PARSE_ERROR).p(");").fitMore().pln();
            } else {
                this.printer.indent().p(PARSE_ERROR).p(" = ").buffer().p(PARSE_ERROR).p(".select(").p(this.resultName).p(".parseError());").fitMore().pln();
            }
        }
        this.valueTest();
        this.printer.indent().p(VALUE).p(" = ");
        if (this.attributeRawTypes && !AST.isAny(this.analyzer.current().type)) {
            this.printer.p('(').p(this.rawT(this.extern(this.analyzer.current().type))).p(')');
        }
        this.printer.p(RESULT).p(".semanticValue();");
        this.nextElement();
        this.printer.decr().indent().pln('}');
        this.tested();
    }

    public void visit(ParseTreeNode parseTreeNode) {
        assert (this.hasBinding());
        this.printer.indent();
        if (VALUE.equals(this.bindingName)) {
            this.printer.p(VALUE);
        } else {
            if (this.attributeConstant) {
                this.printer.p("final ");
            }
            this.printer.p(this.extern(AST.NODE)).p(' ').p(this.bindingName);
        }
        String string = null == parseTreeNode.node ? this.nullExpr() : this.var(parseTreeNode.node);
        this.printer.p(" = Formatting.");
        if (1 == parseTreeNode.predecessors.size() && 0 == parseTreeNode.successors.size()) {
            this.printer.p("before1(").p(this.var(parseTreeNode.predecessors.get(0))).p(", ").p(string).p(')');
        } else if (1 == parseTreeNode.predecessors.size() && 1 == parseTreeNode.successors.size()) {
            this.printer.p("round1(").p(this.var(parseTreeNode.predecessors.get(0))).p(", ").p(string).p(", ").p(this.var(parseTreeNode.successors.get(0))).p(')');
        } else if (0 == parseTreeNode.predecessors.size() && 1 == parseTreeNode.successors.size()) {
            this.printer.p("after1(").p(string).p(", ").p(this.var(parseTreeNode.successors.get(0))).p(')');
        } else {
            this.printer.pln("variable().").indentMore();
            boolean bl = true;
            for (Binding binding : parseTreeNode.predecessors) {
                if (bl) {
                    bl = false;
                } else {
                    this.printer.p('.');
                }
                this.printer.p("add(").p(this.var(binding)).p(')');
            }
            if (null != parseTreeNode.node) {
                if (!bl) {
                    this.printer.p('.');
                }
                this.printer.p("addNode(").p(string).p(')');
                for (Binding binding : parseTreeNode.successors) {
                    this.printer.p(".add(").p(this.var(binding)).p(')');
                }
            }
        }
        this.printer.pln(';');
        this.clearBinding();
        this.nextElement();
    }

    public void visit(NullLiteral nullLiteral) {
        boolean bl = false;
        String string = null;
        if (this.hasBinding()) {
            if (!Analyzer.isSynthetic(this.bindingName)) {
                bl = true;
                string = this.bindingName;
                this.printer.indent().p("{ // Start scope for ").p(string).pln('.').incr();
                this.binding();
            }
            this.clearBinding();
        }
        this.nextElement();
        if (bl) {
            this.printer.decr().indent().p("} // End scope for ").p(string).pln('.');
        }
    }

    public void visit(NullValue nullValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = ").p(this.nullExpr()).pln(';');
        this.nextElement();
    }

    protected void emitDifference() {
        if (this.firstElement) {
            this.printer.p("\"\"");
        } else {
            this.printer.p("difference(").p(ARG_INDEX).p(", ");
            if (this.useBaseIndex) {
                this.printer.p(this.baseIndex);
            } else {
                this.printer.p(RESULT).p(".index");
            }
            this.printer.p(')');
        }
    }

    public void visit(StringValue stringValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = ");
        if (null == stringValue.text) {
            this.emitDifference();
        } else {
            this.printer.p('\"').escape(stringValue.text, 8).p('\"');
        }
        this.printer.pln(';');
        this.nextElement();
    }

    public void visit(TokenValue tokenValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = new Token(");
        if (null == tokenValue.text) {
            this.emitDifference();
        } else {
            this.printer.p('\"').escape(tokenValue.text, 8).p('\"');
        }
        this.printer.pln(");");
        Type type2 = this.analyzer.current().type;
        if (this.attributeWithLocation && this.runtime.test("optimizeLocation") && AST.isNode(type2)) {
            this.printer.indent().p(VALUE).p(".setLocation(location(").p(ARG_INDEX).pln("));");
        } else {
            this.createsNodeValue = true;
        }
        this.nextElement();
    }

    protected String var(Binding binding) {
        return Analyzer.isSynthetic(binding.name) && binding.element instanceof NullLiteral ? this.nullExpr() : binding.name;
    }

    public void visit(BindingValue bindingValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = ").p(this.var(bindingValue.binding)).pln(';');
        this.nextElement();
    }

    public void visit(EmptyListValue emptyListValue) {
        this.printer.pln().indent().p(VALUE).p(" = ").p(this.emptyListExpr()).pln(';');
        this.nextElement();
    }

    public void visit(ProperListValue properListValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = ");
        boolean bl = true;
        for (Binding binding : properListValue.elements) {
            if (bl) {
                bl = false;
            } else {
                this.printer.p(", ");
            }
            this.printer.p("new ");
            if (this.attributeRawTypes) {
                this.printer.p("Pair");
            } else {
                this.printer.p(this.extern(properListValue.type));
            }
            this.printer.p('(').p(this.var(binding));
        }
        if (null != properListValue.tail) {
            this.printer.p(", ").p(this.var(properListValue.tail));
        }
        for (int i = 0; i < properListValue.elements.size(); ++i) {
            this.printer.p(')');
        }
        this.printer.pln(';');
        this.nextElement();
    }

    public void visit(ActionBaseValue actionBaseValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = ");
        if (!AST.isAny(this.analyzer.current().type) && this.attributeRawTypes) {
            this.printer.p('(').p(this.rawT(this.extern(this.analyzer.current().type))).p(')');
        }
        this.printer.p("apply(").p(this.var(actionBaseValue.list)).p(", ").p(this.var(actionBaseValue.seed));
        if (this.attributeWithLocation && Constants.FuzzyBoolean.TRUE == this.ast.hasLocation(this.analyzer.current().type)) {
            this.printer.p(", ").p(ARG_INDEX);
        }
        this.printer.pln(");");
        this.nextElement();
    }

    protected int numberOfChildren(int n, List<Binding> list) {
        for (Binding binding : list) {
            if (this.attributeFlatten && AST.isList(this.analyzer.type(binding.element))) {
                if (this.analyzer.mayBeNull(binding.element)) {
                    return Integer.MIN_VALUE;
                }
                n = Integer.MAX_VALUE;
                continue;
            }
            if (n == Integer.MAX_VALUE) continue;
            ++n;
        }
        return n;
    }

    protected void emitNumberOfChildren(int n, List<Binding> list) {
        boolean bl = false;
        for (Binding binding : list) {
            if (this.attributeFlatten && AST.isList(this.analyzer.type(binding.element))) {
                if (bl) {
                    this.printer.p(" + ");
                } else {
                    bl = true;
                }
                boolean bl2 = this.analyzer.mayBeNull(binding.element);
                if (bl2) {
                    this.printer.pln().indentMore().p('(').p(this.nullExpr()).p(" == ").p(binding.name).p(" ? 0 : ");
                }
                this.printer.p(binding.name).p(".size()");
                if (!bl2) continue;
                this.printer.p(')');
                continue;
            }
            ++n;
        }
        if (!bl) {
            this.printer.p(n);
        } else if (0 != n) {
            this.printer.p(" + ").p(n);
        }
    }

    protected void emitChildren(String string, List<Binding> list) {
        this.printer.p(')');
        boolean bl = true;
        if (null != string) {
            if (bl) {
                this.printer.pln('.').indentMore();
                bl = false;
            } else {
                this.printer.p('.');
            }
            this.printer.p("add(").p(string).p(')');
        }
        boolean bl2 = false;
        for (Binding binding : list) {
            if (!this.attributeFlatten || !AST.isList(this.analyzer.type(binding.element))) {
                if (bl2) {
                    this.printer.pln(';').indent().p(VALUE).p('.');
                    bl2 = false;
                    bl = false;
                } else if (bl) {
                    this.printer.pln('.').indentMore();
                    bl = false;
                } else {
                    this.printer.p('.');
                }
                this.printer.p("add(");
            } else if (this.analyzer.mayBeNull(binding.element)) {
                this.printer.pln(';').indent().p("if (").p(this.nullExpr()).p(" != ").p(this.var(binding)).p(") ").p(VALUE).p(".addAll(");
                bl2 = true;
                bl = false;
            } else {
                if (bl2) {
                    this.printer.pln(';').indent().p(VALUE).p('.');
                    bl2 = false;
                    bl = false;
                } else if (bl) {
                    this.printer.pln('.').indentMore();
                    bl = false;
                } else {
                    this.printer.p('.');
                }
                this.printer.p("addAll(");
            }
            this.printer.p(this.var(binding)).p(')');
        }
    }

    protected void emitFactoryName() {
        if (null == this.factoryClassName) {
            this.printer.p("GNode");
        } else {
            this.printer.p(this.factoryClassName);
        }
    }

    protected void emitFormatting(List<Binding> list) {
        int n = list.size();
        if (0 == n) {
            return;
        }
        this.printer.indent().p(VALUE).p(" = Formatting.");
        if (1 == n) {
            this.printer.p("after1(").p(VALUE).p(", ").p(this.var(list.get(0))).p(')');
        } else {
            this.printer.p("variable().addNode(").p(VALUE).pln(").").indentMore();
            boolean bl = true;
            for (Binding binding : list) {
                if (bl) {
                    bl = false;
                } else {
                    this.printer.p('.');
                }
                this.printer.p("add(").p(this.var(binding)).p(')');
            }
        }
        this.printer.pln(';');
    }

    protected void emitAction(GenericActionValue genericActionValue) {
        boolean bl;
        if (this.attributeRawTypes) {
            this.printer.indent().p("public Object run(Object ").p(genericActionValue.first).pln(") {").incr();
        } else {
            this.printer.indent().p("public Node run(Node ").p(genericActionValue.first).pln(") {").incr();
        }
        String string = Utilities.unqualify(genericActionValue.name);
        int n = this.numberOfChildren(1, genericActionValue.children);
        boolean bl2 = bl = Integer.MIN_VALUE == n || 0 < genericActionValue.formatting.size();
        if (bl) {
            this.printer.indent().p("Node ").p(VALUE).p(" = ");
        } else {
            this.printer.indent().p("return ");
        }
        this.emitFactoryName();
        boolean bl3 = true;
        if (this.runtime.test("optimizeGenericNodes") && 0 <= n) {
            if (1 == n) {
                this.printer.p(".create(\"").p(string).p("\", ").p(genericActionValue.first).p(')');
                bl3 = false;
            } else if (8 >= n) {
                this.printer.p(".create(\"").p(string).p("\", ").p(genericActionValue.first).p(", ");
                Iterator iterator = genericActionValue.children.iterator();
                while (iterator.hasNext()) {
                    Binding binding = (Binding)iterator.next();
                    this.printer.p(this.var(binding));
                    if (iterator.hasNext()) {
                        this.printer.p(", ");
                        continue;
                    }
                    this.printer.p(')');
                }
                bl3 = false;
            } else if (1 == genericActionValue.children.size()) {
                Binding binding = (Binding)genericActionValue.children.get(0);
                this.printer.p(".createFromPair(\"").p(string).p("\", ").p(genericActionValue.first).p(", ").p(this.var(binding)).p(')');
                bl3 = false;
            }
        }
        if (bl3) {
            this.printer.p(".create(\"").p(string).p("\", ");
            this.emitNumberOfChildren(1, genericActionValue.children);
            this.emitChildren(genericActionValue.first, genericActionValue.children);
        }
        this.printer.pln(';');
        this.emitFormatting(genericActionValue.formatting);
        if (bl) {
            this.printer.indent().p("return ").p(VALUE).pln(';');
        }
        this.printer.decr().indent().p('}');
    }

    public void visit(GenericNodeValue genericNodeValue) {
        this.printer.pln();
        this.printer.indent().p(VALUE).p(" = ");
        this.emitFactoryName();
        String string = Utilities.unqualify(genericNodeValue.name);
        int n = this.numberOfChildren(0, genericNodeValue.children);
        boolean bl = true;
        if (this.runtime.test("optimizeGenericNodes") && 0 <= n) {
            if (0 == n) {
                this.printer.p(".create(\"").p(string).p("\", false)");
                bl = false;
            } else if (8 >= n) {
                this.printer.p(".create(\"").p(string).p("\", ");
                Iterator iterator = genericNodeValue.children.iterator();
                while (iterator.hasNext()) {
                    Binding binding = (Binding)iterator.next();
                    this.printer.p(this.var(binding));
                    if (iterator.hasNext()) {
                        this.printer.p(", ");
                        continue;
                    }
                    this.printer.p(')');
                }
                bl = false;
            } else if (1 == genericNodeValue.children.size()) {
                Binding binding = (Binding)genericNodeValue.children.get(0);
                this.printer.p(".createFromPair(\"").p(string).p("\", ").p(this.var(binding)).p(')');
                bl = false;
            } else if (2 == genericNodeValue.children.size()) {
                Binding binding = (Binding)genericNodeValue.children.get(0);
                Binding binding2 = (Binding)genericNodeValue.children.get(1);
                if (!AST.isList(this.analyzer.type(binding.element)) && AST.isList(this.analyzer.type(binding2.element))) {
                    this.printer.p(".createFromPair(\"").p(string).p("\", ").p(this.var(binding)).p(", ").p(this.var(binding2)).p(')');
                    bl = false;
                }
            }
        }
        if (bl) {
            this.printer.p(".create(\"").p(string).p("\", ");
            this.emitNumberOfChildren(0, genericNodeValue.children);
            this.emitChildren(null, genericNodeValue.children);
        }
        this.printer.pln(';');
        if (this.attributeWithLocation && this.runtime.test("optimizeLocation") && AST.isNode(this.analyzer.current().type)) {
            this.printer.indent().p(VALUE).p(".setLocation(location(").p(ARG_INDEX).pln("));");
        } else {
            this.createsNodeValue = true;
        }
        this.emitFormatting(genericNodeValue.formatting);
        this.nextElement();
    }

    public void visit(GenericActionValue genericActionValue) {
        this.printer.pln();
        if (this.attributeRawTypes) {
            this.printer.indent().p(VALUE).pln(" = new Action() {").incr();
        } else {
            this.printer.indent().p(VALUE).pln(" = new Action<Node>() {").incr();
        }
        this.emitAction(genericActionValue);
        this.printer.pln("};").decr();
        this.nextElement();
    }

    public void visit(GenericRecursionValue genericRecursionValue) {
        this.printer.pln();
        if (this.attributeRawTypes) {
            this.printer.indent().p(VALUE).pln(" = new Pair(new Action() {").incr();
        } else {
            this.printer.indent().p(VALUE).pln(" = new Pair<Action<Node>>(new Action<Node>() {").incr();
        }
        this.emitAction(genericRecursionValue);
        this.printer.p("}, ").p(this.var(genericRecursionValue.list)).pln(");").decr();
        this.nextElement();
    }
}

