/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import xtc.Constants;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.GrammarVisitor;
import xtc.parser.MetaData;
import xtc.parser.Module;
import xtc.parser.NonTerminal;
import xtc.parser.NullValue;
import xtc.parser.OrderedChoice;
import xtc.parser.Production;
import xtc.parser.Sequence;
import xtc.parser.StringValue;
import xtc.parser.TokenValue;
import xtc.parser.ValueElement;
import xtc.type.AST;
import xtc.util.Runtime;

public class ChoiceExpander
extends GrammarVisitor {
    protected boolean hasState;
    protected Mode mode;

    public ChoiceExpander(Runtime runtime, Analyzer analyzer) {
        super(runtime, analyzer);
    }

    protected NonTerminal candidate(Sequence sequence, boolean bl) {
        Element element = Analyzer.strip(sequence);
        if (element instanceof Binding) {
            Binding binding = (Binding)element;
            if (bl && "yyValue".equals(binding.name) && binding.element instanceof NonTerminal) {
                return (NonTerminal)binding.element;
            }
        } else if (AST.isVoid(this.analyzer.current().type) || this.analyzer.current().getBooleanProperty("textOnly") || this.analyzer.current().getBooleanProperty("token")) {
            Sequence sequence2;
            if (element instanceof NonTerminal) {
                return (NonTerminal)element;
            }
            if (element instanceof Sequence && 2 == (sequence2 = (Sequence)element).size() && sequence2.get(0) instanceof NonTerminal && sequence2.get(1) instanceof ValueElement) {
                return (NonTerminal)sequence2.get(0);
            }
        }
        return null;
    }

    protected void inlined(Production production) {
        if (this.runtime.test("optionVerbose")) {
            System.err.println("[Inlining " + production.qName + " into " + this.analyzer.current().qName + "]");
        }
    }

    public Object visit(Module module) {
        this.analyzer.register(this);
        this.analyzer.init(module);
        this.hasState = module.hasAttribute(Constants.ATT_STATEFUL.getName());
        for (Production production : module.productions) {
            this.mode = Mode.INLINE;
            if (!this.runtime.test("optimizeChoices2") && !AST.isVoid(production.type) && !production.getBooleanProperty("textOnly") && !production.getBooleanProperty("token")) continue;
            this.analyzer.process(production);
        }
        return null;
    }

    public Element visit(OrderedChoice orderedChoice) {
        boolean bl = this.isTopLevel;
        this.isTopLevel = false;
        boolean bl2 = this.isLastElement;
        this.isLastElement = false;
        for (int i = 0; i < orderedChoice.alternatives.size(); ++i) {
            NonTerminal nonTerminal;
            Sequence sequence = orderedChoice.alternatives.get(i);
            if (Mode.INLINE == this.mode && null != (nonTerminal = this.candidate(sequence, bl))) {
                FullProduction fullProduction = this.analyzer.lookup(nonTerminal);
                MetaData metaData = (MetaData)fullProduction.getProperty("metaData");
                if ((!fullProduction.isMemoized() && !fullProduction.hasAttribute(Constants.ATT_NO_INLINE) && (AST.isVoid(fullProduction.type) || fullProduction.getBooleanProperty("textOnly") || fullProduction.getBooleanProperty("token")) || fullProduction.hasAttribute(Constants.ATT_INLINE) && this.runtime.test("optimizeChoices2")) && 0 == metaData.selfCount && (!this.hasState || !fullProduction.hasAttribute(Constants.ATT_STATEFUL) && !fullProduction.hasAttribute(Constants.ATT_RESETTING))) {
                    OrderedChoice orderedChoice2 = this.analyzer.copy(fullProduction.choice);
                    if (1 == orderedChoice2.alternatives.size()) {
                        orderedChoice2.alternatives.get(0).setLocation(sequence);
                    }
                    if (!bl && !bl2) {
                        this.mode = Mode.RM_VALUES;
                        orderedChoice2 = (OrderedChoice)this.dispatch(orderedChoice2);
                        this.mode = Mode.INLINE;
                    } else if (AST.isVoid(this.analyzer.current().type)) {
                        this.mode = Mode.VOID_VALUES;
                        orderedChoice2 = (OrderedChoice)this.dispatch(orderedChoice2);
                        this.mode = Mode.INLINE;
                    } else if (this.analyzer.current().getBooleanProperty("textOnly") && !bl) {
                        this.mode = Mode.TEXT_VALUES;
                        orderedChoice2 = (OrderedChoice)this.dispatch(orderedChoice2);
                        this.mode = Mode.INLINE;
                    } else if (this.analyzer.current().getBooleanProperty("token")) {
                        this.mode = Mode.TOKEN_VALUES;
                        orderedChoice2 = (OrderedChoice)this.dispatch(orderedChoice2);
                        this.mode = Mode.INLINE;
                    }
                    orderedChoice.alternatives.remove(i);
                    orderedChoice.alternatives.addAll(i, orderedChoice2.alternatives);
                    this.inlined(fullProduction);
                    --i;
                    continue;
                }
            }
            if (bl || bl2) {
                this.isLastElement = true;
            }
            orderedChoice.alternatives.set(i, (Sequence)this.dispatch(sequence));
        }
        return orderedChoice;
    }

    public Element visit(Sequence sequence) {
        this.isTopLevel = false;
        boolean bl = this.isLastElement;
        int n = sequence.size();
        if (Mode.RM_VALUES == this.mode && sequence.get(n - 1) instanceof ValueElement) {
            sequence.elements.remove(n - 1);
            --n;
        }
        for (int i = 0; i < n; ++i) {
            this.isLastElement = bl && i == n - 1;
            sequence.elements.set(i, (Element)this.dispatch(sequence.get(i)));
        }
        this.isLastElement = false;
        return sequence;
    }

    public Element visit(ValueElement valueElement) {
        this.isTopLevel = false;
        this.isLastElement = false;
        if (Mode.VOID_VALUES == this.mode) {
            return NullValue.VALUE;
        }
        if (Mode.TEXT_VALUES == this.mode) {
            return StringValue.VALUE;
        }
        if (Mode.TOKEN_VALUES == this.mode) {
            return TokenValue.VALUE;
        }
        return valueElement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        INLINE,
        RM_VALUES,
        VOID_VALUES,
        TEXT_VALUES,
        TOKEN_VALUES;

    }
}

