/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.Analyzer;
import xtc.parser.Binding;
import xtc.parser.DirectLeftRecurser;
import xtc.parser.Element;
import xtc.parser.FullProduction;
import xtc.parser.Generifier;
import xtc.parser.Module;
import xtc.parser.NodeMarker;
import xtc.parser.NonTerminal;
import xtc.parser.OrderedChoice;
import xtc.parser.ParseTreeNode;
import xtc.parser.Production;
import xtc.parser.Repetition;
import xtc.parser.Sequence;
import xtc.parser.UnaryOperator;
import xtc.parser.VoidedElement;
import xtc.tree.Attribute;
import xtc.tree.Node;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.Type;
import xtc.util.Runtime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotator
extends Visitor {
    public static final String MARKER = "pt";
    protected final Runtime runtime;
    protected final Analyzer analyzer;
    protected boolean isGeneric;
    protected boolean isList;
    protected boolean isRecursive;
    protected boolean isTopLevel;
    protected int toProcessIdx;
    protected List<Sequence> sequences;
    protected List<List<Binding>> before;
    protected List<Index> sequenceIdx;
    protected List<Index> elementIdx;
    protected List<List<Binding>> after;

    public Annotator(Runtime runtime, Analyzer analyzer) {
        this.runtime = runtime;
        this.analyzer = analyzer;
        this.toProcessIdx = 0;
        this.sequences = new ArrayList<Sequence>();
        this.before = new ArrayList<List<Binding>>();
        this.sequenceIdx = new ArrayList<Index>();
        this.elementIdx = new ArrayList<Index>();
        this.after = new ArrayList<List<Binding>>();
    }

    protected void push() {
        assert (this.before.size() == this.sequenceIdx.size());
        assert (this.before.size() == this.elementIdx.size());
        assert (this.before.size() == this.after.size());
        if (0 == this.before.size()) {
            this.before.add(new ArrayList());
            this.sequenceIdx.add(new Index());
            this.elementIdx.add(new Index());
            this.after.add(new ArrayList());
        } else {
            this.before.add(new ArrayList(this.before.get(this.before.size() - 1)));
            this.sequenceIdx.add(new Index(this.sequenceIdx.get(this.sequenceIdx.size() - 1)));
            this.elementIdx.add(new Index(this.elementIdx.get(this.elementIdx.size() - 1)));
            this.after.add(new ArrayList(this.after.get(this.after.size() - 1)));
        }
    }

    protected void pop() {
        assert (this.before.size() == this.sequenceIdx.size());
        assert (this.before.size() == this.elementIdx.size());
        assert (this.before.size() == this.after.size());
        this.before.remove(this.before.size() - 1);
        this.sequenceIdx.remove(this.sequenceIdx.size() - 1);
        this.elementIdx.remove(this.elementIdx.size() - 1);
        this.after.remove(this.after.size() - 1);
    }

    protected void reset() {
        this.before.set(this.before.size() - 1, new ArrayList());
        this.sequenceIndex().index = -1;
        this.elementIndex().index = -1;
        this.after.set(this.after.size() - 1, new ArrayList());
    }

    protected List<Binding> before() {
        return this.before.get(this.before.size() - 1);
    }

    protected Index sequenceIndex() {
        return this.sequenceIdx.get(this.sequenceIdx.size() - 1);
    }

    protected Index elementIndex() {
        return this.elementIdx.get(this.elementIdx.size() - 1);
    }

    protected List<Binding> after() {
        return this.after.get(this.after.size() - 1);
    }

    protected boolean isValuable(Element element) {
        switch (element.tag()) {
            case VOIDED: {
                assert (this.isValuable(((VoidedElement)element).element));
                return true;
            }
            case NONTERMINAL: {
                return Annotator.isValuable(this.analyzer.lookup((NonTerminal)element));
            }
            case CHOICE: 
            case OPTION: 
            case REPETITION: 
            case ANY_CHAR: 
            case CHAR_CLASS: 
            case CHAR_LITERAL: 
            case STRING_LITERAL: 
            case STRING_MATCH: 
            case PARSE_TREE_NODE: 
            case BINDING: {
                return true;
            }
        }
        return false;
    }

    protected boolean isParseTreeNode(Element element) {
        switch (element.tag()) {
            case VOIDED: 
            case BINDING: {
                return this.isParseTreeNode(((UnaryOperator)element).element);
            }
            case PARSE_TREE_NODE: {
                return true;
            }
        }
        return false;
    }

    protected boolean hasBindable() {
        return -1 != this.sequenceIndex().index;
    }

    protected boolean hasValuable() {
        return 0 < this.before().size() || 0 < this.after().size();
    }

    protected boolean isBoundAndVoided(Element element) {
        return element instanceof VoidedElement && ((VoidedElement)element).element instanceof Binding;
    }

    protected VoidedElement bindAndVoid(Element element) {
        UnaryOperator unaryOperator;
        Element element2 = element;
        if (element2 instanceof VoidedElement) {
            element2 = ((VoidedElement)element2).element;
        }
        if (element2 instanceof Binding) {
            unaryOperator = (Binding)element2;
            if ("yyValue".equals(((Binding)unaryOperator).name)) {
                ((Binding)unaryOperator).name = this.analyzer.variable(MARKER);
            }
            assert (!this.isParseTreeNode(((Binding)unaryOperator).element));
        } else {
            assert (!this.isParseTreeNode(element2));
            element2 = new Binding(this.analyzer.variable(MARKER), element2);
            element2.setLocation(element);
        }
        unaryOperator = new VoidedElement(element2);
        unaryOperator.setLocation(element);
        return unaryOperator;
    }

    protected Binding bindAndVoid() {
        Sequence sequence = this.sequences.get(this.sequenceIndex().index);
        VoidedElement voidedElement = this.bindAndVoid(sequence.get(this.elementIndex().index));
        sequence.elements.set(this.elementIndex().index, voidedElement);
        return (Binding)voidedElement.element;
    }

    protected void annotate() {
        Element element;
        int n;
        int n2;
        Sequence sequence;
        int n3;
        for (Sequence sequence2 : this.sequences) {
            for (Element element2 : sequence2.elements) {
                if (!(element2 instanceof Action) || !((Action)element2).setsValue()) continue;
                ++this.toProcessIdx;
                this.push();
                assert (this.toProcessIdx == this.before.size());
                return;
            }
        }
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        int n6 = this.sequences.size();
        for (n3 = 0; n3 < n6; ++n3) {
            sequence = this.sequences.get(n3);
            n2 = sequence.hasTrailingChoice() ? sequence.size() - 1 : sequence.size();
            for (n = 0; n < n2; ++n) {
                if (this.isRecursive && 0 == n3 && 0 == n) continue;
                element = sequence.get(n);
                if (element instanceof Binding && "yyValue".equals(((Binding)element).name)) {
                    n4 = n3;
                    n5 = n;
                    continue;
                }
                if (!this.isValuable(element)) continue;
                bl = true;
            }
        }
        if (-1 != n4) {
            if (!bl) {
                ++this.toProcessIdx;
                this.push();
                assert (this.toProcessIdx == this.before.size());
                return;
            }
            if (bl) {
                Binding binding = null;
                this.before.clear();
                this.sequenceIdx.clear();
                this.elementIdx.clear();
                this.after.clear();
                for (int i = 0; i < n6; ++i) {
                    Sequence sequence3 = this.sequences.get(i);
                    this.push();
                    n = sequence3.hasTrailingChoice() ? sequence3.size() - 1 : sequence3.size();
                    for (int j = 0; j < n; ++j) {
                        if (this.isRecursive && 0 == i && 0 == j) continue;
                        Element element3 = sequence3.get(j);
                        if (i < this.toProcessIdx) {
                            if (i == n4 && j == n5) {
                                binding = (Binding)((VoidedElement)element3).element;
                                continue;
                            }
                            if (this.isBoundAndVoided(element3)) {
                                if (null == binding) {
                                    this.before().add((Binding)((VoidedElement)element3).element);
                                    continue;
                                }
                                this.after().add((Binding)((VoidedElement)element3).element);
                                continue;
                            }
                            if (!this.analyzer.isBindable(element3) || this.isParseTreeNode(element3)) continue;
                            if (!(element3 instanceof Binding)) {
                                element3 = new Binding(this.analyzer.variable(MARKER), element3);
                                sequence3.elements.set(j, element3);
                            }
                            if (null == binding) {
                                this.before().add((Binding)element3);
                                continue;
                            }
                            this.after().add((Binding)element3);
                            continue;
                        }
                        if (!this.isValuable(element3)) continue;
                        VoidedElement voidedElement = this.bindAndVoid(element3);
                        sequence3.elements.set(j, voidedElement);
                        if (i == n4 && j == n5) {
                            binding = (Binding)voidedElement.element;
                            continue;
                        }
                        if (null == binding) {
                            this.before().add((Binding)voidedElement.element);
                            continue;
                        }
                        this.after().add((Binding)voidedElement.element);
                    }
                }
                assert (null != binding);
                ParseTreeNode parseTreeNode = new ParseTreeNode(this.before(), binding, this.after());
                Binding binding2 = new Binding("yyValue", parseTreeNode);
                this.sequences.get(this.sequences.size() - 1).add(binding2);
                this.toProcessIdx = this.sequences.size();
                assert (this.toProcessIdx == this.before.size());
                return;
            }
        }
        for (n3 = this.toProcessIdx; n3 < n6; ++n3) {
            sequence = this.sequences.get(n3);
            this.push();
            for (n2 = 0; n2 < (sequence.hasTrailingChoice() ? sequence.size() - 1 : sequence.size()); ++n2) {
                if (this.isRecursive && 0 == n3 && 0 == n2) continue;
                Element element4 = sequence.get(n2);
                if (this.analyzer.isBindable(element4)) {
                    if ((this.isGeneric || this.isList) && AST.isList(this.analyzer.type(element4))) {
                        if (this.hasValuable()) {
                            element = this.hasBindable() ? this.bindAndVoid() : null;
                            sequence.elements.add(n2, new ParseTreeNode(this.before(), (Binding)element, this.after()));
                            ++n2;
                        }
                        this.reset();
                        continue;
                    }
                    if (!this.hasBindable() || !this.hasValuable()) {
                        this.sequenceIndex().index = n3;
                        this.elementIndex().index = n2;
                        continue;
                    }
                    sequence.elements.add(n2, new ParseTreeNode(this.before(), this.bindAndVoid(), this.after()));
                    this.reset();
                    continue;
                }
                if (!this.isValuable(element4)) continue;
                element = this.bindAndVoid(element4);
                sequence.elements.set(n2, element);
                if (!this.hasBindable()) {
                    this.before().add((Binding)((VoidedElement)element).element);
                    continue;
                }
                this.after().add((Binding)((VoidedElement)element).element);
            }
            if (n3 >= n6 - 1 || !this.hasBindable()) continue;
            if (this.hasValuable()) {
                sequence.elements.add(sequence.size() - 1, new ParseTreeNode(this.before(), this.bindAndVoid(), this.after()));
            }
            this.reset();
        }
        if (this.hasValuable()) {
            if (this.isGeneric && !this.hasBindable()) {
                this.sequences.get(this.sequences.size() - 1).setProperty("formatting", this.before());
            } else {
                Binding binding = this.hasBindable() ? this.bindAndVoid() : null;
                this.sequences.get(this.sequences.size() - 1).add(new ParseTreeNode(this.before(), binding, this.after()));
            }
        }
        this.toProcessIdx = this.sequences.size();
        assert (this.toProcessIdx == this.before.size());
    }

    protected void recurse(Element element) {
        switch (element.tag()) {
            case VOIDED: 
            case OPTION: 
            case REPETITION: 
            case STRING_MATCH: 
            case BINDING: {
                this.recurse(((UnaryOperator)element).element);
                break;
            }
            case CHOICE: 
            case SEQUENCE: {
                boolean bl = this.isGeneric;
                boolean bl2 = this.isList;
                boolean bl3 = this.isRecursive;
                boolean bl4 = this.isTopLevel;
                int n = this.toProcessIdx;
                List<Sequence> list = this.sequences;
                List<List<Binding>> list2 = this.before;
                List<Index> list3 = this.sequenceIdx;
                List<Index> list4 = this.elementIdx;
                List<List<Binding>> list5 = this.after;
                this.isGeneric = false;
                this.isList = false;
                this.isRecursive = false;
                this.isTopLevel = false;
                this.toProcessIdx = 0;
                this.sequences = new ArrayList<Sequence>();
                this.before = new ArrayList<List<Binding>>();
                this.sequenceIdx = new ArrayList<Index>();
                this.elementIdx = new ArrayList<Index>();
                this.after = new ArrayList<List<Binding>>();
                this.dispatch(element);
                this.isGeneric = bl;
                this.isList = bl2;
                this.isRecursive = bl3;
                this.isTopLevel = bl4;
                this.toProcessIdx = n;
                this.sequences = list;
                this.before = list2;
                this.sequenceIdx = list3;
                this.elementIdx = list4;
                this.after = list5;
                break;
            }
        }
    }

    public void visit(Module module) {
        new Detector().dispatch(module);
        new Rewriter().dispatch(module);
        this.analyzer.register(this);
        this.analyzer.init(module);
        for (Production production : module.productions) {
            Object object;
            if (production.getBooleanProperty("lexical") || AST.isVoid(production.type) && !production.getBooleanProperty("consumer")) continue;
            boolean bl = false;
            if (Annotator.isSingleRepetition((FullProduction)production)) {
                object = production.choice.alternatives.iterator();
                while (object.hasNext()) {
                    Sequence sequence = object.next();
                    this.recurse(sequence.get(0));
                }
                bl = true;
            } else if (AST.isVoid(production.type) || AST.isString(production.type) || AST.isNode(production.type) || AST.isAny(production.type)) {
                this.analyzer.process(production);
                bl = true;
            } else if (AST.isList(production.type) && (AST.isString((Type)(object = AST.getArgument(production.type))) || AST.isNode((Type)object) || AST.isAny((Type)object))) {
                this.analyzer.process(production);
                bl = true;
            }
            if (bl || module.hasAttribute(Constants.ATT_NO_WARNINGS) || production.hasAttribute(Constants.ATT_NO_WARNINGS)) continue;
            this.runtime.warning("unable to add parse tree annotations", production);
        }
        for (Production production : module.productions) {
            Type type2;
            if (!production.getBooleanProperty("token") && (production.getBooleanProperty("lexical") || AST.isVoid(production.type) && !production.getBooleanProperty("consumer"))) continue;
            if (production.getBooleanProperty("token")) {
                production.type = AST.TOKEN;
                continue;
            }
            if (AST.isVoid(production.type)) {
                production.type = AST.GENERIC;
                continue;
            }
            if (AST.isString(production.type) || AST.isToken(production.type)) {
                production.type = AST.NODE;
                continue;
            }
            if (!AST.isList(production.type) || !AST.isString(type2 = AST.getArgument(production.type)) && !AST.isToken(type2)) continue;
            production.type = AST.listOf(AST.NODE);
        }
    }

    public void visit(FullProduction fullProduction) {
        this.isGeneric = Annotator.isGeneric(fullProduction);
        this.isList = AST.isList(fullProduction.type);
        this.isRecursive = DirectLeftRecurser.isTransformable(fullProduction);
        this.isTopLevel = true;
        this.dispatch(fullProduction.choice);
    }

    public void visit(OrderedChoice orderedChoice) {
        boolean bl = this.isRecursive;
        boolean bl2 = this.isTopLevel;
        this.isTopLevel = false;
        for (Sequence sequence : orderedChoice.alternatives) {
            if (bl2) {
                this.isRecursive = bl ? DirectLeftRecurser.isRecursive(sequence, (FullProduction)this.analyzer.current()) : false;
            }
            this.dispatch(sequence);
        }
    }

    public void visit(Sequence sequence) {
        this.sequences.add(sequence);
        int n = sequence.elements.size();
        for (int i = 0; i < n; ++i) {
            Element element = sequence.get(i);
            if (n - 1 == i && element instanceof OrderedChoice) {
                this.dispatch(element);
                continue;
            }
            this.recurse(element);
        }
        if (!sequence.hasTrailingChoice()) {
            this.annotate();
        }
        this.sequences.remove(this.sequences.size() - 1);
        --this.toProcessIdx;
        this.pop();
        assert (this.toProcessIdx == this.before.size());
    }

    public static boolean isGeneric(FullProduction fullProduction) {
        return Generifier.isGeneric(fullProduction) || AST.isVoid(fullProduction.type) && !fullProduction.getBooleanProperty("lexical") && fullProduction.getBooleanProperty("consumer");
    }

    public static boolean isValuable(FullProduction fullProduction) {
        return !AST.isVoid(fullProduction.type) || fullProduction.getBooleanProperty("consumer");
    }

    public static boolean isList(Type type2) {
        if (!AST.isList(type2)) {
            return false;
        }
        Type type3 = AST.getArgument(type2);
        return AST.isAny(type3) || AST.isNode(type3) || AST.isString(type3);
    }

    public static boolean isSingleRepetition(FullProduction fullProduction) {
        if (!Annotator.isList(fullProduction.type)) {
            return false;
        }
        for (Sequence sequence : fullProduction.choice.alternatives) {
            if (1 != sequence.size()) {
                return false;
            }
            Element element = sequence.get(0);
            if (element instanceof Repetition || element instanceof Binding && ((Binding)element).element instanceof Repetition) continue;
            return false;
        }
        return true;
    }

    public class Rewriter
    extends Visitor {
        protected List<Element> elements = new ArrayList<Element>();
        protected boolean isTopLevel;
        protected Sequence alternative;
        protected List<Sequence> replacements;

        public void visit(Module module) {
            Annotator.this.analyzer.register(this);
            Annotator.this.analyzer.init(module);
            for (int i = 0; i < module.productions.size(); ++i) {
                FullProduction fullProduction = (FullProduction)module.productions.get(i);
                if (!fullProduction.getBooleanProperty("split")) continue;
                Annotator.this.analyzer.startAdding();
                Annotator.this.analyzer.process(fullProduction);
                i += Annotator.this.analyzer.addNewProductionsAt(i + 1);
            }
        }

        public void visit(FullProduction fullProduction) {
            this.isTopLevel = true;
            this.dispatch(fullProduction.choice);
        }

        public void visit(OrderedChoice orderedChoice) {
            boolean bl = this.isTopLevel;
            this.isTopLevel = false;
            if (bl) {
                this.replacements = new ArrayList<Sequence>(orderedChoice.alternatives.size());
            }
            for (Sequence sequence : orderedChoice.alternatives) {
                if (bl) {
                    this.alternative = sequence;
                }
                this.dispatch(sequence);
            }
            if (bl) {
                orderedChoice.alternatives = this.replacements;
            }
        }

        public void visit(Sequence sequence) {
            Node node;
            int n = this.elements.size();
            Object object = sequence.elements.iterator();
            while (object.hasNext()) {
                node = object.next();
                if (!object.hasNext() && node instanceof OrderedChoice) {
                    this.dispatch(node);
                    continue;
                }
                this.elements.add((Element)node);
            }
            if (!sequence.hasTrailingChoice()) {
                object = (IndexPair)sequence.getProperty("split");
                if (null == object) {
                    node = new Sequence(new ArrayList<Element>(this.elements));
                    ((Sequence)node).name = this.alternative.name;
                    node.setLocation(this.alternative);
                    this.replacements.add((Sequence)node);
                } else {
                    Sequence sequence2;
                    Element element2;
                    node = Annotator.this.analyzer.current();
                    NodeMarker nodeMarker = null;
                    for (Element element2 : this.elements) {
                        if (!(element2 instanceof NodeMarker)) continue;
                        nodeMarker = (NodeMarker)element2;
                    }
                    if (null == nodeMarker) {
                        nodeMarker = new NodeMarker(((Production)node).name.name);
                    }
                    NonTerminal nonTerminal = Annotator.this.analyzer.split();
                    if (-1 == ((IndexPair)object).index2) {
                        element2 = new Sequence(this.elements.size() - ((IndexPair)object).index1 + 1);
                        ((Sequence)element2).addAll(this.elements.subList(((IndexPair)object).index1, this.elements.size()));
                        ((Sequence)element2).add(nodeMarker);
                    } else if (-1 == ((IndexPair)object).index1) {
                        element2 = new Sequence(((IndexPair)object).index2 + 2);
                        ((Sequence)element2).addAll(this.elements.subList(0, ((IndexPair)object).index2 + 1));
                        ((Sequence)element2).add(nodeMarker);
                    } else {
                        element2 = new Sequence(((IndexPair)object).index2 - ((IndexPair)object).index1 + 2);
                        ((Sequence)element2).addAll(this.elements.subList(((IndexPair)object).index1, ((IndexPair)object).index2 + 1));
                        ((Sequence)element2).add(nodeMarker);
                    }
                    ((Sequence)element2).name = this.alternative.name;
                    element2.setLocation(this.alternative);
                    FullProduction fullProduction = new FullProduction(new ArrayList<Attribute>(((Production)node).attributes), AST.GENERIC, nonTerminal, nonTerminal.qualify(Annotator.this.analyzer.module().name.name), new OrderedChoice(element2));
                    fullProduction.attributes.remove(Constants.ATT_STATEFUL);
                    fullProduction.attributes.remove(Constants.ATT_RESETTING);
                    if (!fullProduction.hasAttribute(Constants.ATT_TRANSIENT) && !fullProduction.hasAttribute(Constants.ATT_INLINE)) {
                        fullProduction.attributes.add(Constants.ATT_TRANSIENT);
                    }
                    if (Annotator.this.runtime.test("optionVerbose")) {
                        System.err.println("[Lifting split sequence into new production " + fullProduction.qName + ']');
                    }
                    Annotator.this.analyzer.add(fullProduction);
                    if (-1 == ((IndexPair)object).index2) {
                        sequence2 = new Sequence(((IndexPair)object).index1 + 1);
                        sequence2.addAll(this.elements.subList(0, ((IndexPair)object).index1));
                        sequence2.add(new Binding("yyValue", nonTerminal));
                    } else if (-1 == ((IndexPair)object).index1) {
                        sequence2 = new Sequence(this.elements.size() - ((IndexPair)object).index2);
                        sequence2.add(new Binding("yyValue", nonTerminal));
                        sequence2.addAll(this.elements.subList(((IndexPair)object).index2 + 1, this.elements.size()));
                    } else {
                        sequence2 = new Sequence(((IndexPair)object).index1 + this.elements.size() - ((IndexPair)object).index2);
                        sequence2.addAll(this.elements.subList(0, ((IndexPair)object).index1));
                        sequence2.add(new Binding("yyValue", nonTerminal));
                        sequence2.addAll(this.elements.subList(((IndexPair)object).index2 + 1, this.elements.size()));
                    }
                    sequence2.name = this.alternative.name;
                    sequence2.setLocation(this.alternative);
                    this.replacements.add(sequence2);
                }
            }
            if (0 == n) {
                this.elements.clear();
            } else {
                this.elements.subList(n, this.elements.size()).clear();
            }
        }
    }

    public class Detector
    extends Visitor {
        protected boolean needToSplit;
        protected List<Element> elements = new ArrayList<Element>();

        public void visit(Module module) {
            Annotator.this.analyzer.register(this);
            Annotator.this.analyzer.init(module);
            for (Production production : module.productions) {
                if (!Generifier.isGeneric((FullProduction)production) && !Annotator.isList(production.type) || DirectLeftRecurser.isTransformable((FullProduction)production)) continue;
                this.needToSplit = false;
                Annotator.this.analyzer.process(production);
                if (!this.needToSplit) continue;
                production.setProperty("split", Boolean.TRUE);
            }
        }

        public void visit(FullProduction fullProduction) {
            this.dispatch(fullProduction.choice);
        }

        public void visit(OrderedChoice orderedChoice) {
            for (Sequence sequence : orderedChoice.alternatives) {
                this.dispatch(sequence);
            }
        }

        public void visit(Sequence sequence) {
            int n = this.elements.size();
            Iterator<Element> iterator = sequence.elements.iterator();
            while (iterator.hasNext()) {
                Element element = iterator.next();
                if (!iterator.hasNext() && element instanceof OrderedChoice) {
                    this.dispatch(element);
                    continue;
                }
                this.elements.add(element);
            }
            if (!sequence.hasTrailingChoice()) {
                boolean bl = false;
                boolean bl2 = false;
                int n2 = -1;
                int n3 = -1;
                boolean bl3 = false;
                int n4 = this.elements.size();
                for (int i = 0; i < n4; ++i) {
                    Element element = this.elements.get(i);
                    if (Annotator.this.analyzer.isBindable(element)) {
                        if (AST.isList(Annotator.this.analyzer.type(element))) {
                            if (!bl && bl2) {
                                n2 = i;
                            }
                            n3 = i;
                        } else {
                            n3 = -1;
                        }
                        bl3 = false;
                        bl = true;
                        continue;
                    }
                    if (!Annotator.this.isValuable(element)) continue;
                    if (-1 != n3) {
                        bl3 = true;
                    }
                    bl2 = true;
                }
                if (-1 != n2 || bl3) {
                    IndexPair indexPair = new IndexPair();
                    if (-1 != n2) {
                        indexPair.index1 = n2;
                    }
                    if (bl3) {
                        indexPair.index2 = n3;
                    }
                    this.needToSplit = true;
                    sequence.setProperty("split", indexPair);
                }
            }
            if (0 == n) {
                this.elements.clear();
            } else {
                this.elements.subList(n, this.elements.size()).clear();
            }
        }
    }

    public static class IndexPair {
        public int index1 = -1;
        public int index2 = -1;
    }

    public static class Index {
        public int index;

        public Index() {
            this.index = -1;
        }

        public Index(Index index) {
            this.index = index.index;
        }
    }
}

