/*
 * Decompiled with CFR 0.152.
 */
package xtc.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import xtc.Constants;
import xtc.parser.Action;
import xtc.parser.Binding;
import xtc.parser.CharCase;
import xtc.parser.CharClass;
import xtc.parser.CharLiteral;
import xtc.parser.CharRange;
import xtc.parser.CharSwitch;
import xtc.parser.Copier;
import xtc.parser.Element;
import xtc.parser.FollowedBy;
import xtc.parser.FullProduction;
import xtc.parser.Grammar;
import xtc.parser.Module;
import xtc.parser.ModuleDependency;
import xtc.parser.ModuleName;
import xtc.parser.NonTerminal;
import xtc.parser.NotFollowedBy;
import xtc.parser.NullValue;
import xtc.parser.Option;
import xtc.parser.OrderedChoice;
import xtc.parser.ParserAction;
import xtc.parser.Predicate;
import xtc.parser.Production;
import xtc.parser.Renamer;
import xtc.parser.Repetition;
import xtc.parser.SemanticPredicate;
import xtc.parser.Sequence;
import xtc.parser.StringLiteral;
import xtc.parser.StringMatch;
import xtc.parser.Terminal;
import xtc.parser.UnaryOperator;
import xtc.parser.ValueElement;
import xtc.parser.VoidedElement;
import xtc.tree.Utility;
import xtc.tree.Visitor;
import xtc.type.AST;
import xtc.type.Type;
import xtc.type.VoidT;
import xtc.type.Wildcard;
import xtc.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analyzer
extends Utility {
    public static final String SEPARATOR = "$$";
    public static final String SHARED = "$$Shared";
    public static final String VARIABLE = "v$";
    public static final String DUMMY = "v$dummy";
    public static final String SPLIT = "$$Split";
    public static final String CHOICE = "$$Choice";
    public static final String STAR = "$$Star";
    public static final String PLUS = "$$Plus";
    public static final String OPTION = "$$Option";
    public static final String TAIL = "$$Tail";
    public static final int MAX_COUNT = 22;
    protected final Copier xerox;
    protected boolean isGrammarMode = false;
    protected Grammar grammar;
    protected Map<String, Module> moduleMap;
    protected Map<NonTerminal, Object> grammarPMap;
    protected Module mCurrent;
    protected Module module;
    protected Map<NonTerminal, FullProduction> pMap;
    protected Production pCurrent;
    protected Set<NonTerminal> pWorking;
    protected Set<NonTerminal> pMarked;
    protected Set<NonTerminal> pProcessed;
    protected List<Production> pNew;
    protected int varCount;
    protected int splitCount;
    protected int choiceCount;
    protected int starCount;
    protected int plusCount;
    protected int optionCount;
    protected int tailCount;
    protected int sharedCount = 1;
    private final Visitor restrictsInputVisitor = new Visitor(){

        public Boolean visit(FullProduction fullProduction) {
            assert (!Analyzer.this.isBeingWorkedOn(fullProduction.qName));
            assert (!fullProduction.hasProperty("restrict"));
            Object object = Analyzer.this.enter(fullProduction);
            Analyzer.this.workingOn(fullProduction.qName);
            Boolean bl = (Boolean)this.dispatch(fullProduction.choice);
            fullProduction.setProperty("restrict", bl);
            Analyzer.this.notWorkingOn(fullProduction.qName);
            Analyzer.this.exit(object);
            return bl;
        }

        public Boolean visit(OrderedChoice orderedChoice) {
            for (Sequence sequence : orderedChoice.alternatives) {
                if (((Boolean)this.dispatch(sequence)).booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean visit(Repetition repetition) {
            return repetition.once;
        }

        public Boolean visit(Option option) {
            return Boolean.FALSE;
        }

        public Boolean visit(Sequence sequence) {
            for (Element element : sequence.elements) {
                if (!((Boolean)this.dispatch(element)).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visit(Predicate predicate) {
            return Boolean.TRUE;
        }

        public Boolean visit(NonTerminal nonTerminal) {
            FullProduction fullProduction;
            try {
                fullProduction = Analyzer.this.lookup(nonTerminal);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Boolean.TRUE;
            }
            if (null != fullProduction) {
                if (fullProduction.hasProperty("restrict")) {
                    return (Boolean)fullProduction.getProperty("restrict");
                }
                if (Analyzer.this.isBeingWorkedOn(fullProduction.qName)) {
                    return Boolean.TRUE;
                }
                return (Boolean)this.dispatch(fullProduction);
            }
            return Boolean.TRUE;
        }

        public Boolean visit(Terminal terminal) {
            return Boolean.TRUE;
        }

        public Boolean visit(UnaryOperator unaryOperator) {
            return (Boolean)this.dispatch(unaryOperator.element);
        }

        public Boolean visit(ParserAction parserAction) {
            return Boolean.TRUE;
        }

        public Boolean visit(Element element) {
            return Boolean.FALSE;
        }
    };
    private final Visitor consumesInputVisitor = new Visitor(){

        public Boolean visit(FullProduction fullProduction) {
            assert (!Analyzer.this.isBeingWorkedOn(fullProduction.qName));
            assert (!fullProduction.hasProperty("consumer"));
            Object object = Analyzer.this.enter(fullProduction);
            Analyzer.this.workingOn(fullProduction.qName);
            Boolean bl = (Boolean)this.dispatch(fullProduction.choice);
            fullProduction.setProperty("consumer", bl);
            Analyzer.this.notWorkingOn(fullProduction.qName);
            Analyzer.this.exit(object);
            return bl;
        }

        public Boolean visit(OrderedChoice orderedChoice) {
            for (Sequence sequence : orderedChoice.alternatives) {
                if (!((Boolean)this.dispatch(sequence)).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visit(Sequence sequence) {
            for (Element element : sequence.elements) {
                if (!((Boolean)this.dispatch(element)).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visit(Predicate predicate) {
            return Boolean.FALSE;
        }

        public Boolean visit(NonTerminal nonTerminal) {
            FullProduction fullProduction;
            try {
                fullProduction = Analyzer.this.lookup(nonTerminal);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Boolean.TRUE;
            }
            if (null != fullProduction) {
                if (fullProduction.hasProperty("consumer")) {
                    return (Boolean)fullProduction.getProperty("consumer");
                }
                if (Analyzer.this.isBeingWorkedOn(fullProduction.qName)) {
                    return Boolean.TRUE;
                }
                return (Boolean)this.dispatch(fullProduction);
            }
            return Boolean.TRUE;
        }

        public Boolean visit(Terminal terminal) {
            return Boolean.TRUE;
        }

        public Boolean visit(UnaryOperator unaryOperator) {
            return (Boolean)this.dispatch(unaryOperator.element);
        }

        public Boolean visit(ParserAction parserAction) {
            return Boolean.TRUE;
        }

        public Boolean visit(Element element) {
            return Boolean.FALSE;
        }
    };
    private final Visitor matchesEmptyVisitor = new Visitor(){

        public Boolean visit(FullProduction fullProduction) {
            assert (!Analyzer.this.isBeingWorkedOn(fullProduction.qName));
            assert (!fullProduction.hasProperty("empty"));
            Object object = Analyzer.this.enter(fullProduction);
            Analyzer.this.workingOn(fullProduction.qName);
            Boolean bl = (Boolean)this.dispatch(fullProduction.choice);
            fullProduction.setProperty("empty", bl);
            Analyzer.this.notWorkingOn(fullProduction.qName);
            Analyzer.this.exit(object);
            return bl;
        }

        public Boolean visit(OrderedChoice orderedChoice) {
            for (Sequence sequence : orderedChoice.alternatives) {
                if (!((Boolean)this.dispatch(sequence)).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean visit(Repetition repetition) {
            return !repetition.once;
        }

        public Boolean visit(Option option) {
            return Boolean.TRUE;
        }

        public Boolean visit(Sequence sequence) {
            for (Element element : sequence.elements) {
                if (((Boolean)this.dispatch(element)).booleanValue()) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Boolean visit(FollowedBy followedBy) {
            return (Boolean)this.dispatch(followedBy.element);
        }

        public Boolean visit(NotFollowedBy notFollowedBy) {
            return (Boolean)this.dispatch(notFollowedBy.element) == false;
        }

        public Boolean visit(SemanticPredicate semanticPredicate) {
            return Boolean.FALSE;
        }

        public Boolean visit(NonTerminal nonTerminal) {
            FullProduction fullProduction;
            try {
                fullProduction = Analyzer.this.lookup(nonTerminal);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Boolean.FALSE;
            }
            if (null != fullProduction) {
                if (fullProduction.hasProperty("empty")) {
                    return (Boolean)fullProduction.getProperty("empty");
                }
                if (Analyzer.this.isBeingWorkedOn(fullProduction.qName)) {
                    return Boolean.FALSE;
                }
                return (Boolean)this.dispatch(fullProduction);
            }
            return Boolean.FALSE;
        }

        public Boolean visit(Terminal terminal) {
            return Boolean.FALSE;
        }

        public Boolean visit(UnaryOperator unaryOperator) {
            return (Boolean)this.dispatch(unaryOperator.element);
        }

        public Boolean visit(ParserAction parserAction) {
            return Boolean.FALSE;
        }

        public Boolean visit(Element element) {
            return Boolean.TRUE;
        }
    };

    public Analyzer() {
        this.xerox = new Copier();
        this.moduleMap = new HashMap<String, Module>();
        this.grammarPMap = new HashMap<NonTerminal, Object>();
        this.pMap = new HashMap<NonTerminal, FullProduction>();
        this.pWorking = new HashSet<NonTerminal>();
        this.pMarked = new HashSet<NonTerminal>();
        this.pProcessed = new HashSet<NonTerminal>();
        this.pNew = new ArrayList<Production>();
    }

    public void reset() {
        this.isGrammarMode = false;
        this.grammar = null;
        this.moduleMap.clear();
        this.grammarPMap.clear();
        this.mCurrent = null;
        this.module = null;
        this.pCurrent = null;
        this.pMap.clear();
        this.pWorking.clear();
        this.pMarked.clear();
        this.pProcessed.clear();
        this.pNew.clear();
        this.varCount = 1;
        this.splitCount = 1;
        this.choiceCount = 1;
        this.starCount = 1;
        this.plusCount = 1;
        this.optionCount = 1;
        this.tailCount = 1;
        this.sharedCount = 1;
    }

    public void init(Grammar grammar) {
        if (this.grammar != grammar) {
            this.grammar = grammar;
            this.moduleMap.clear();
            this.grammarPMap.clear();
            for (Module module : grammar.modules) {
                this.moduleMap.put(module.name.name, module);
                for (Production production : module.productions) {
                    if (null == production.qName) {
                        production.qName = production.name.qualify(module.name.name);
                        production.qName.setLocation(production.name);
                    }
                    if (!production.isFull()) continue;
                    this.addToGrammarMap((FullProduction)production);
                }
            }
        }
        this.pMarked.clear();
        this.pProcessed.clear();
        this.pCurrent = null;
        this.mCurrent = null;
        this.isGrammarMode = true;
    }

    public boolean isImported(String string, Module module) {
        while (null != module) {
            if (null != module.dependencies) {
                for (ModuleDependency moduleDependency : module.dependencies) {
                    if (!moduleDependency.isImport() || !moduleDependency.visibleName().name.equals(string)) continue;
                    return true;
                }
                if (null != module.modification) {
                    module = this.lookup(module.modification.visibleName());
                    continue;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void trace(Module module, Set<ModuleName> set, Map<ModuleName, Boolean> map) {
        if (null != module.modification) {
            if (map.containsKey(module.modification.visibleName())) {
                map.put(module.modification.visibleName(), Boolean.TRUE);
            } else {
                map.put(module.modification.visibleName(), Boolean.FALSE);
                Module module2 = this.lookup(module.modification.visibleName());
                if (null != module2) {
                    this.trace(module2, set, map);
                }
            }
        }
        if (null != module.dependencies) {
            for (ModuleDependency moduleDependency : module.dependencies) {
                if (!moduleDependency.isImport() || set.contains(moduleDependency.visibleName())) continue;
                set.add(moduleDependency.visibleName());
                Module module3 = this.lookup(moduleDependency.visibleName());
                if (null == module3) continue;
                this.trace(module3, set, map);
            }
        }
    }

    public boolean hasAttribute(Module module, String string, Set<ModuleName> set) {
        if (!set.contains(module.name)) {
            set.add(module.name);
            if (module.hasAttribute(string)) {
                return true;
            }
            if (null != module.dependencies) {
                for (ModuleDependency moduleDependency : module.dependencies) {
                    Module module2;
                    if (!moduleDependency.isImport() && !moduleDependency.isModification() || null == (module2 = this.lookup(moduleDependency.visibleName())) || !this.hasAttribute(module2, string, set)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void add(Module module) {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        if (!this.moduleMap.containsKey(module.name.name)) {
            this.moduleMap.put(module.name.name, module);
            for (Production production : module.productions) {
                if (!production.isFull()) continue;
                this.addToGrammarMap((FullProduction)production);
            }
        }
    }

    public void remove(Module module) {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        this.moduleMap.remove(module.name.name);
        for (Production production : module.productions) {
            if (!production.isFull()) continue;
            this.removeFromGrammarMap((FullProduction)production);
        }
    }

    private List<FullProduction> toFullProductionList(Object object) {
        return (List)object;
    }

    private void addToGrammarMap(FullProduction fullProduction) {
        if (!this.grammarPMap.containsKey(fullProduction.qName)) {
            this.grammarPMap.put(fullProduction.qName, fullProduction);
            if (this.grammarPMap.containsKey(fullProduction.name)) {
                Object object = this.grammarPMap.get(fullProduction.name);
                if (object instanceof FullProduction) {
                    ArrayList<FullProduction> arrayList = new ArrayList<FullProduction>();
                    arrayList.add((FullProduction)object);
                    arrayList.add(fullProduction);
                    this.grammarPMap.put(fullProduction.name, arrayList);
                } else {
                    List<FullProduction> list = this.toFullProductionList(object);
                    list.add(fullProduction);
                }
            } else {
                this.grammarPMap.put(fullProduction.name, fullProduction);
            }
        }
    }

    private void removeFromGrammarMap(FullProduction fullProduction) {
        this.grammarPMap.remove(fullProduction.qName);
        Object object = this.grammarPMap.get(fullProduction.name);
        if (object instanceof FullProduction) {
            if (fullProduction.qName.equals(((FullProduction)object).qName)) {
                this.grammarPMap.remove(fullProduction.name);
            }
        } else {
            List<FullProduction> list = this.toFullProductionList(object);
            Iterator<FullProduction> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!fullProduction.qName.equals(iterator.next().qName)) continue;
                iterator.remove();
                break;
            }
            if (1 == list.size()) {
                object = list.get(0);
                this.grammarPMap.put(fullProduction.name, object);
            }
        }
    }

    public Grammar grammar() {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        return this.grammar;
    }

    public boolean isTopLevel(Module module) {
        return this.isGrammarMode ? module == this.grammar.modules.get(0) : module == this.module;
    }

    public Module topLevel() {
        return this.isGrammarMode ? this.grammar.modules.get(0) : this.module;
    }

    public void init(Module module) {
        if (this.module != module) {
            this.module = module;
            this.pMap.clear();
            for (Production production : module.productions) {
                if (!production.isFull()) continue;
                this.pMap.put(production.name, (FullProduction)production);
                this.pMap.put(production.qName, (FullProduction)production);
            }
        }
        this.pMarked.clear();
        this.pProcessed.clear();
        this.pCurrent = null;
        this.mCurrent = null;
        this.isGrammarMode = false;
    }

    public Module module() {
        if (this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with module");
        }
        return this.module;
    }

    public Module lookup(String string) {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        return this.moduleMap.get(string);
    }

    public Module lookup(ModuleName moduleName) {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        return this.moduleMap.get(moduleName.name);
    }

    public FullProduction lookupGlobally(NonTerminal nonTerminal) {
        if (this.isGrammarMode) {
            return nonTerminal.isQualified() ? (FullProduction)this.grammarPMap.get(nonTerminal) : null;
        }
        return this.pMap.get(nonTerminal);
    }

    public FullProduction lookup(NonTerminal nonTerminal, Module module) {
        Object object;
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        if (nonTerminal.isQualified()) {
            if (nonTerminal.getQualifier().equals(module.name.name)) {
                if (this.grammarPMap.containsKey(nonTerminal)) {
                    return (FullProduction)this.grammarPMap.get(nonTerminal);
                }
                nonTerminal = nonTerminal.unqualify();
            } else {
                return null;
            }
        }
        if (null == (object = this.grammarPMap.get(nonTerminal))) {
            return null;
        }
        if (object instanceof FullProduction) {
            FullProduction fullProduction = (FullProduction)object;
            return this.isDefined(fullProduction, module) ? fullProduction : null;
        }
        FullProduction fullProduction = null;
        for (FullProduction fullProduction2 : this.toFullProductionList(object)) {
            if (!this.isDefined(fullProduction2, module)) continue;
            if (null == fullProduction) {
                fullProduction = fullProduction2;
                continue;
            }
            throw new IllegalArgumentException("Multiple definitions for " + nonTerminal);
        }
        return fullProduction;
    }

    public FullProduction lookup(NonTerminal nonTerminal) {
        if (this.isGrammarMode) {
            if (nonTerminal.isQualified()) {
                String string = nonTerminal.getQualifier();
                if (string.equals(this.mCurrent.name.name)) {
                    return this.lookup(nonTerminal, this.mCurrent);
                }
                if (this.isImported(string, this.mCurrent)) {
                    Module module = this.lookup(string);
                    return null != module ? this.lookup(nonTerminal, module) : null;
                }
                return null;
            }
            Object object = this.grammarPMap.get(nonTerminal);
            if (null == object) {
                return null;
            }
            if (object instanceof FullProduction) {
                FullProduction fullProduction = (FullProduction)object;
                return this.isDefined(fullProduction, this.mCurrent) || this.isImported(fullProduction, this.mCurrent) ? fullProduction : null;
            }
            FullProduction fullProduction = null;
            List<FullProduction> list = this.toFullProductionList(object);
            for (FullProduction fullProduction2 : list) {
                if (!this.isDefined(fullProduction2, this.mCurrent)) continue;
                if (null == fullProduction) {
                    fullProduction = fullProduction2;
                    continue;
                }
                throw new IllegalArgumentException("Multiple definitions for " + nonTerminal);
            }
            if (null != fullProduction) {
                return fullProduction;
            }
            for (FullProduction fullProduction2 : list) {
                if (!this.isImported(fullProduction2, this.mCurrent)) continue;
                if (null == fullProduction) {
                    fullProduction = fullProduction2;
                    continue;
                }
                throw new IllegalArgumentException("Multiple imported definitions for " + nonTerminal);
            }
            return fullProduction;
        }
        return this.pMap.get(nonTerminal);
    }

    public boolean isDefined(Production production, Module module) {
        String string = production.qName.getQualifier();
        if (module.name.name.equals(string)) {
            return true;
        }
        while (null != module.modification && null != (module = this.moduleMap.get(module.modification.visibleName().name))) {
            if (!module.name.name.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isImported(Production production, Module module) {
        if (this.isImported1(production, module)) {
            return !production.hasAttribute(Constants.ATT_PRIVATE);
        }
        while (null != module.modification && null != (module = this.moduleMap.get(module.modification.visibleName().name))) {
            if (!this.isImported1(production, module)) continue;
            return !production.hasAttribute(Constants.ATT_PRIVATE);
        }
        return false;
    }

    private boolean isImported1(Production production, Module module) {
        if (null != module.dependencies) {
            for (ModuleDependency moduleDependency : module.dependencies) {
                if (!moduleDependency.isImport() || null == (module = this.moduleMap.get(moduleDependency.visibleName().name)) || !this.isDefined(production, module)) continue;
                return true;
            }
        }
        return false;
    }

    public void uniquify() {
        if (!this.isGrammarMode) {
            throw new IllegalStateException("Not initialized with grammar");
        }
        HashSet<NonTerminal> hashSet = new HashSet<NonTerminal>();
        HashSet<NonTerminal> hashSet2 = new HashSet<NonTerminal>();
        for (Module node : this.grammar.modules) {
            for (FullProduction fullProduction : node.productions) {
                Object object;
                if (hashSet.contains(fullProduction.qName)) continue;
                Object object2 = this.grammarPMap.get(fullProduction.name);
                if (object2 instanceof FullProduction) {
                    hashSet.add(fullProduction.qName);
                    continue;
                }
                List<FullProduction> list = this.toFullProductionList(object2);
                hashSet2.add(fullProduction.name);
                ArrayList<NonTerminal> arrayList = new ArrayList<NonTerminal>();
                for (FullProduction fullProduction2 : list) {
                    object = fullProduction2.qName.getQualifier();
                    if (Utilities.isQualified((String)object)) {
                        arrayList.add(fullProduction2.name.qualify(Utilities.getName((String)object)));
                        continue;
                    }
                    arrayList.add(fullProduction2.qName);
                }
                if (arrayList.size() == new HashSet(arrayList).size()) {
                    Iterator<FullProduction> iterator = list.iterator();
                    Iterator iterator2 = arrayList.iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        ((FullProduction)object).name = (NonTerminal)iterator2.next();
                        hashSet.add(((FullProduction)object).qName);
                    }
                    continue;
                }
                for (FullProduction fullProduction3 : list) {
                    fullProduction3.name = fullProduction3.qName;
                    hashSet.add(fullProduction3.qName);
                }
            }
        }
        new Renamer(null, this, new Renamer.Translation(){

            public NonTerminal map(NonTerminal nonTerminal, Analyzer analyzer) {
                NonTerminal nonTerminal2 = analyzer.lookup((NonTerminal)nonTerminal).name;
                if (nonTerminal.equals(nonTerminal2)) {
                    nonTerminal2 = nonTerminal;
                } else {
                    nonTerminal2 = new NonTerminal(nonTerminal2.name);
                    nonTerminal2.setLocation(nonTerminal);
                }
                return nonTerminal2;
            }
        }).dispatch(this.grammar);
        for (NonTerminal nonTerminal : hashSet2) {
            this.grammarPMap.remove(nonTerminal);
        }
    }

    public void process(Module module) {
        if (this.isGrammarMode) {
            this.mCurrent = module;
        } else if (module != this.module) {
            throw new IllegalArgumentException("Invalid module " + module);
        }
    }

    public Module currentModule() {
        return this.isGrammarMode ? this.mCurrent : this.module;
    }

    public Object enter(Production production) {
        if (this.isGrammarMode) {
            Module module = this.mCurrent;
            this.mCurrent = this.lookup(production.qName.getQualifier());
            return module;
        }
        return null;
    }

    public void exit(Object object) {
        if (this.isGrammarMode) {
            this.mCurrent = (Module)object;
        }
    }

    public void process(Production production) {
        this.pWorking.clear();
        this.varCount = 1;
        this.splitCount = 1;
        this.choiceCount = 1;
        this.starCount = 1;
        this.plusCount = 1;
        this.optionCount = 1;
        this.tailCount = 1;
        this.pCurrent = production;
        this.visitor().dispatch(production);
    }

    public Production current() {
        return this.pCurrent;
    }

    public void workingOn(NonTerminal nonTerminal) {
        this.pWorking.add(nonTerminal);
    }

    public void notWorkingOn(NonTerminal nonTerminal) {
        this.pWorking.remove(nonTerminal);
    }

    public void notWorkingOnAny() {
        this.pWorking.clear();
    }

    public boolean isBeingWorkedOn(NonTerminal nonTerminal) {
        return this.pWorking.contains(nonTerminal);
    }

    public Set<NonTerminal> working() {
        return this.pWorking;
    }

    public void mark(NonTerminal nonTerminal) {
        this.pMarked.add(nonTerminal);
    }

    public void mark(Collection<NonTerminal> collection) {
        this.pMarked.addAll(collection);
    }

    public void markAll() {
        for (Production production : this.module.productions) {
            this.pMarked.add(production.qName);
        }
    }

    public void unmark(NonTerminal nonTerminal) {
        this.pMarked.remove(nonTerminal);
    }

    public void unmarkAll() {
        this.pMarked.clear();
    }

    public boolean hasMarked() {
        return !this.pMarked.isEmpty();
    }

    public boolean isMarked(NonTerminal nonTerminal) {
        return this.pMarked.contains(nonTerminal);
    }

    public Set<NonTerminal> marked() {
        return this.pMarked;
    }

    public void clearProcessed() {
        this.pProcessed.clear();
    }

    public void processed(NonTerminal nonTerminal) {
        this.pProcessed.add(nonTerminal);
    }

    public boolean isProcessed(NonTerminal nonTerminal) {
        return this.pProcessed.contains(nonTerminal);
    }

    public void startAdding() {
        this.pNew.clear();
    }

    public void add(FullProduction fullProduction) {
        fullProduction.setProperty("xtc.Constants.Synthetic", Boolean.TRUE);
        this.pNew.add(fullProduction);
        this.pMap.put(fullProduction.name, fullProduction);
        this.pMap.put(fullProduction.qName, fullProduction);
    }

    public int addNewProductionsAt(int n) {
        int n2 = this.pNew.size();
        if (0 != n2) {
            this.module.productions.addAll(n, this.pNew);
        }
        return n2;
    }

    public void remove(FullProduction fullProduction) {
        this.pMap.remove(fullProduction.name);
        this.pMap.remove(fullProduction.qName);
    }

    public void resetVarCount() {
        this.varCount = 1;
    }

    public int getVarCount() {
        return this.varCount;
    }

    public void setVarCount(int n) {
        this.varCount = n;
    }

    public String variable() {
        return VARIABLE + Integer.toString(this.varCount++);
    }

    public String variable(String string) {
        return VARIABLE + string + "$" + Integer.toString(this.varCount++);
    }

    public static boolean isSynthetic(String string) {
        return string.startsWith(VARIABLE);
    }

    public NonTerminal split() {
        return new NonTerminal(this.pCurrent.name + SPLIT + Integer.toString(this.splitCount++));
    }

    public NonTerminal choice() {
        return new NonTerminal(this.pCurrent.name + CHOICE + Integer.toString(this.choiceCount++));
    }

    public NonTerminal star() {
        return new NonTerminal(this.pCurrent.name + STAR + Integer.toString(this.starCount++));
    }

    public NonTerminal plus() {
        return new NonTerminal(this.pCurrent.name + PLUS + Integer.toString(this.plusCount++));
    }

    public NonTerminal option() {
        return new NonTerminal(this.pCurrent.name + OPTION + Integer.toString(this.optionCount++));
    }

    public NonTerminal tail() {
        return new NonTerminal(this.pCurrent.name + TAIL + Integer.toString(this.tailCount++));
    }

    public NonTerminal shared() {
        return new NonTerminal(SHARED + Integer.toString(this.sharedCount++));
    }

    public static boolean isSynthetic(NonTerminal nonTerminal) {
        return -1 != nonTerminal.name.indexOf(SEPARATOR);
    }

    public static Element strip(Element element) {
        Sequence sequence;
        if (element instanceof OrderedChoice) {
            OrderedChoice orderedChoice = (OrderedChoice)element;
            if (1 == orderedChoice.alternatives.size()) {
                element = Analyzer.strip(orderedChoice.alternatives.get(0));
            }
        } else if (element instanceof Sequence && 1 == (sequence = (Sequence)element).size()) {
            element = Analyzer.strip(sequence.get(0));
        }
        return element;
    }

    public static OrderedChoice stripChoices(OrderedChoice orderedChoice) {
        boolean bl = false;
        do {
            Sequence sequence;
            if (1 != orderedChoice.alternatives.size()) continue;
            Element element = orderedChoice.alternatives.get(0);
            if (element instanceof OrderedChoice) {
                orderedChoice = (OrderedChoice)element;
                bl = true;
                continue;
            }
            if (!(element instanceof Sequence) || 1 != (sequence = (Sequence)element).size() || !(sequence.get(0) instanceof OrderedChoice)) continue;
            orderedChoice = (OrderedChoice)sequence.get(0);
            bl = true;
        } while (bl);
        return orderedChoice;
    }

    public Module copy(Module module) {
        return (Module)this.xerox.dispatch(module);
    }

    public <T extends Element> T copy(T t) {
        return this.xerox.copy(t);
    }

    public boolean hasTerminalPrefix(Sequence sequence) {
        Element element;
        return 1 <= sequence.size() && ((element = sequence.get(0)) instanceof CharLiteral || element instanceof StringLiteral || element instanceof CharClass && ((CharClass)element).count() <= 22);
    }

    private int normalLength(Sequence sequence) {
        int n = sequence.size();
        boolean bl = true;
        int n2 = 0;
        block5: for (int i = 0; i < n; ++i) {
            Element element = sequence.get(i);
            switch (element.tag()) {
                case CHAR_LITERAL: {
                    bl = false;
                    ++n2;
                    continue block5;
                }
                case STRING_LITERAL: {
                    bl = false;
                    n2 += ((StringLiteral)element).text.length();
                    continue block5;
                }
                case CHAR_CLASS: {
                    ++n2;
                    continue block5;
                }
                default: {
                    n2 += n - i;
                    break block5;
                }
            }
        }
        return bl ? -1 : n2;
    }

    public Sequence normalizeTerminals(Sequence sequence) {
        int n = this.normalLength(sequence);
        if (-1 == n) {
            return sequence;
        }
        int n2 = sequence.size();
        Sequence sequence2 = new Sequence(new ArrayList<Element>(n));
        sequence2.setLocation(sequence);
        block5: for (int i = 0; i < n2; ++i) {
            Element element = sequence.get(i);
            switch (element.tag()) {
                case CHAR_LITERAL: {
                    sequence2.add(new CharClass(((CharLiteral)element).c));
                    continue block5;
                }
                case STRING_LITERAL: {
                    StringLiteral stringLiteral = (StringLiteral)element;
                    for (int j = 0; j < stringLiteral.text.length(); ++j) {
                        sequence2.add(new CharClass(stringLiteral.text.charAt(j)));
                    }
                    continue block5;
                }
                case CHAR_CLASS: {
                    sequence2.add(element);
                    continue block5;
                }
                default: {
                    sequence2.addAll(sequence.elements.subList(i, n2));
                    break block5;
                }
            }
        }
        return sequence2;
    }

    public Element joinTerminals(Sequence sequence, Element element) {
        Element element2;
        Element element3;
        if (null == element) {
            return sequence;
        }
        if (element instanceof Sequence && 1 == ((Sequence)(element3 = (Sequence)element)).size() && (element2 = ((Sequence)element3).get(0)) instanceof OrderedChoice) {
            element = element2;
        }
        if (element instanceof Sequence) {
            Element element4;
            Element element5;
            element3 = (Sequence)element;
            element2 = ((Sequence)element3).isEmpty() ? null : ((Sequence)element3).get(0);
            Element element6 = element5 = sequence.isEmpty() ? null : sequence.get(0);
            if (element5 instanceof CharClass && element2 instanceof CharClass && element5.equals(element2)) {
                Sequence sequence2 = new Sequence(this.joinTerminals(sequence.subSequence(1), ((Sequence)element3).subSequence(1)));
                sequence2.setLocation(sequence);
                sequence2.elements.add(0, element5);
                return sequence2;
            }
            if (element5 instanceof CharClass && ((CharClass)element5).count() <= 22) {
                element4 = (CharClass)element5;
                if (element2 instanceof CharClass) {
                    CharClass charClass = (CharClass)element2;
                    if (charClass.count() <= 22) {
                        return this.joinTerminals(sequence, new Sequence(new CharSwitch(charClass, (Element)((Sequence)element3).subSequence(1))));
                    }
                } else if (element2 instanceof CharSwitch) {
                    CharSwitch charSwitch = (CharSwitch)element2;
                    CharClass charClass = new CharClass(((CharClass)element4).ranges);
                    CharCase charCase = charSwitch.hasCase(charClass);
                    if (((CharClass)element4).exclusive) {
                        if (null != charCase && 1 == charSwitch.cases.size()) {
                            charSwitch.base = this.joinTerminals(sequence.subSequence(1), charSwitch.base);
                            return element;
                        }
                    } else {
                        if (null != charCase) {
                            charCase.element = this.joinTerminals(sequence.subSequence(1), charCase.element);
                            return element;
                        }
                        if (!charSwitch.overlaps(charClass) && null == charSwitch.base) {
                            charSwitch.cases.add(new CharCase(charClass, (Element)sequence.subSequence(1)));
                            return element;
                        }
                    }
                }
            }
            element4 = new OrderedChoice();
            element4.alternatives.add(Sequence.ensure(element));
            element4.alternatives.add(sequence);
            return element4;
        }
        if (element instanceof OrderedChoice) {
            element3 = (OrderedChoice)element;
            int n = ((OrderedChoice)element3).alternatives.size();
            Element element7 = this.joinTerminals(sequence, ((OrderedChoice)element3).alternatives.get(n - 1));
            if (element7 instanceof OrderedChoice) {
                ((OrderedChoice)element3).alternatives.remove(n - 1);
                ((OrderedChoice)element3).alternatives.addAll(((OrderedChoice)element7).alternatives);
            } else {
                ((OrderedChoice)element3).alternatives.set(n - 1, Sequence.ensure(element7));
            }
            return element3;
        }
        return this.joinTerminals(sequence, new Sequence(element));
    }

    public boolean haveCommonPrefix(Sequence sequence, Sequence sequence2) {
        Element element;
        Element element2 = sequence.isEmpty() ? null : sequence.get(0);
        Element element3 = element = sequence2.isEmpty() ? null : sequence2.get(0);
        if (element2 instanceof Binding) {
            return element2.equals(element);
        }
        if (null != element2) {
            return element2.equals(element);
        }
        return false;
    }

    public Sequence normalizePrefix(Sequence sequence, Sequence sequence2) {
        return sequence2;
    }

    public Element joinPrefixes(Sequence sequence, Element element) {
        Element element2;
        Element element3;
        if (null == element) {
            return sequence;
        }
        if (element instanceof Sequence && 1 == ((Sequence)(element3 = (Sequence)element)).size() && (element2 = ((Sequence)element3).get(0)) instanceof OrderedChoice) {
            element = element2;
        }
        if (element instanceof Sequence) {
            Element element4;
            element3 = (Sequence)element;
            if (sequence.equals(element3)) {
                return sequence;
            }
            element2 = ((Sequence)element3).isEmpty() ? null : ((Sequence)element3).get(0);
            Element element5 = element4 = sequence.isEmpty() ? null : sequence.get(0);
            if (null != element4 && element4.equals(element2)) {
                Sequence sequence2 = new Sequence(this.joinPrefixes(sequence.subSequence(1), ((Sequence)element3).subSequence(1)));
                sequence2.setLocation(sequence);
                sequence2.elements.add(0, element4);
                return sequence2;
            }
            OrderedChoice orderedChoice = new OrderedChoice();
            orderedChoice.alternatives.add(Sequence.ensure(element));
            orderedChoice.alternatives.add(sequence);
            return orderedChoice;
        }
        if (element instanceof OrderedChoice) {
            element3 = (OrderedChoice)element;
            int n = ((OrderedChoice)element3).alternatives.size();
            Element element6 = this.joinPrefixes(sequence, ((OrderedChoice)element3).alternatives.get(n - 1));
            if (element6 instanceof OrderedChoice) {
                ((OrderedChoice)element3).alternatives.remove(n - 1);
                ((OrderedChoice)element3).alternatives.addAll(((OrderedChoice)element6).alternatives);
            } else {
                ((OrderedChoice)element3).alternatives.set(n - 1, Sequence.ensure(element6));
            }
            return element3;
        }
        return this.joinPrefixes(sequence, new Sequence(element));
    }

    public String matchingText(Element element) {
        StringBuilder stringBuilder = new StringBuilder();
        return this.matchingText(element, stringBuilder) ? stringBuilder.toString() : null;
    }

    private boolean matchingText(Element element, StringBuilder stringBuilder) {
        switch (element.tag()) {
            case CHOICE: {
                OrderedChoice orderedChoice = (OrderedChoice)element;
                if (1 == orderedChoice.alternatives.size()) {
                    return this.matchingText(orderedChoice.alternatives.get(0), stringBuilder);
                }
                return false;
            }
            case SEQUENCE: {
                for (Element element2 : ((Sequence)element).elements) {
                    if (this.matchingText(element2, stringBuilder)) continue;
                    return false;
                }
                return true;
            }
            case FOLLOWED_BY: 
            case NOT_FOLLOWED_BY: 
            case SEMANTIC_PREDICATE: 
            case ACTION: 
            case NODE_MARKER: 
            case NULL: {
                return true;
            }
            case BINDING: 
            case STRING_MATCH: {
                return this.matchingText(((UnaryOperator)element).element, stringBuilder);
            }
            case NONTERMINAL: {
                return this.matchingText(this.lookup((NonTerminal)((NonTerminal)element)).choice, stringBuilder);
            }
            case STRING_LITERAL: {
                stringBuilder.append(((StringLiteral)element).text);
                return true;
            }
            case CHAR_LITERAL: {
                stringBuilder.append(((CharLiteral)element).c);
                return true;
            }
            case CHAR_CLASS: {
                CharClass charClass = (CharClass)element;
                if (1 == charClass.ranges.size()) {
                    CharRange charRange = charClass.ranges.get(0);
                    if (charRange.first == charRange.last) {
                        stringBuilder.append(charRange.first);
                        return true;
                    }
                }
                return false;
            }
        }
        return element instanceof ValueElement;
    }

    public boolean restrictsInput(Element element) {
        return (Boolean)this.restrictsInputVisitor.dispatch(element);
    }

    public boolean consumesInput(Element element) {
        return (Boolean)this.consumesInputVisitor.dispatch(element);
    }

    public boolean matchesEmpty(Element element) {
        return (Boolean)this.matchesEmptyVisitor.dispatch(element);
    }

    public boolean isBindable(Element element) {
        switch (element.tag()) {
            case NONTERMINAL: {
                return !AST.isVoid(this.lookup((NonTerminal)((NonTerminal)element)).type);
            }
            case CHAR_LITERAL: 
            case STRING_LITERAL: 
            case CHAR_CLASS: 
            case CHOICE: 
            case NULL: 
            case BINDING: 
            case STRING_MATCH: 
            case OPTION: 
            case REPETITION: 
            case ANY_CHAR: 
            case PARSE_TREE_NODE: {
                return true;
            }
        }
        return false;
    }

    public Binding bind(List<Element> list) {
        return this.bind(list, null);
    }

    public Binding bind(List<Element> list, String string) {
        Binding binding = null;
        Element element = null;
        int n = -1;
        int n2 = list.size();
        block7: for (int i = 0; i < n2; ++i) {
            Element element2 = list.get(i);
            switch (element2.tag()) {
                case NONTERMINAL: {
                    if (AST.isVoid(this.lookup((NonTerminal)((NonTerminal)element2)).type)) continue block7;
                }
                case CHAR_LITERAL: 
                case STRING_LITERAL: 
                case CHAR_CLASS: 
                case CHOICE: 
                case NULL: 
                case STRING_MATCH: 
                case OPTION: 
                case REPETITION: 
                case ANY_CHAR: 
                case PARSE_TREE_NODE: {
                    if (-1 == n) {
                        element = element2;
                        n = i;
                        continue block7;
                    }
                    binding = null;
                    n = -1;
                    break block7;
                }
                case BINDING: {
                    if (-1 == n) {
                        binding = (Binding)element2;
                        n = i;
                        continue block7;
                    }
                    binding = null;
                    n = -1;
                    break block7;
                }
                case FOLLOWED_BY: 
                case NOT_FOLLOWED_BY: 
                case SEMANTIC_PREDICATE: 
                case NODE_MARKER: 
                case VOIDED: {
                    continue block7;
                }
                case ACTION: {
                    if (!((Action)element2).setsValue()) continue block7;
                }
                default: {
                    binding = null;
                    n = -1;
                    break block7;
                }
            }
        }
        if (null != binding) {
            return binding;
        }
        if (-1 == n) {
            return null;
        }
        binding = null == string ? new Binding(this.variable(), element) : new Binding(this.variable(string), element);
        list.set(n, binding);
        return binding;
    }

    public static Binding getBinding(List<Element> list) {
        Binding binding = null;
        for (Element element : list) {
            if (!(element instanceof Binding)) continue;
            if (null == binding) {
                binding = (Binding)element;
                continue;
            }
            return null;
        }
        return binding;
    }

    public static Element unbind(Element element) {
        return element instanceof Binding ? ((Binding)element).element : element;
    }

    public static Element stripAndUnbind(Element element) {
        return Analyzer.strip(Analyzer.unbind(Analyzer.strip(element)));
    }

    public Element getValue(List<Element> list, boolean bl) {
        Element object = null;
        block10: for (Element object2 : list) {
            Element element;
            switch (object2.tag()) {
                case BINDING: {
                    element = (Binding)object2;
                    if (!"yyValue".equals(((Binding)element).name)) continue block10;
                    object = element;
                    break;
                }
                case ACTION: {
                    element = (Action)object2;
                    if (bl || !((Action)element).setsValue()) continue block10;
                    object = element;
                    break;
                }
                case PARSER_ACTION: {
                    if (bl) break;
                    object = object2;
                    break;
                }
                case ACTION_BASE_VALUE: 
                case BINDING_VALUE: 
                case GENERIC_ACTION_VALUE: 
                case GENERIC_RECURSION_VALUE: 
                case GENERIC_NODE_VALUE: 
                case EMPTY_LIST_VALUE: 
                case PROPER_LIST_VALUE: 
                case NULL_VALUE: 
                case STRING_VALUE: 
                case TOKEN_VALUE: {
                    object = object2;
                }
            }
        }
        if (null != object) {
            return object;
        }
        boolean bl2 = false;
        for (Element element : list) {
            switch (element.tag()) {
                case NONTERMINAL: {
                    if (AST.isVoid(this.lookup((NonTerminal)((NonTerminal)element)).type)) break;
                }
                case CHAR_LITERAL: 
                case STRING_LITERAL: 
                case CHAR_CLASS: 
                case CHOICE: 
                case NULL: 
                case BINDING: 
                case STRING_MATCH: 
                case OPTION: 
                case REPETITION: 
                case ANY_CHAR: 
                case PARSE_TREE_NODE: {
                    if (bl2) break;
                    if (null == object) {
                        object = element;
                        break;
                    }
                    bl2 = true;
                    object = null;
                    break;
                }
            }
        }
        return object;
    }

    public static boolean setsValue(List<Element> list, boolean bl) {
        return Analyzer.setsValue(new Sequence(list), bl);
    }

    public static boolean setsValue(Element element, final boolean bl) {
        return (Boolean)new Visitor(){
            private boolean isLast = true;

            public Boolean visit(OrderedChoice orderedChoice) {
                if (!this.isLast) {
                    return Boolean.FALSE;
                }
                for (Sequence sequence : orderedChoice.alternatives) {
                    if (bl) {
                        if (((Boolean)this.dispatch(sequence)).booleanValue()) continue;
                        return Boolean.FALSE;
                    }
                    if (!((Boolean)this.dispatch(sequence)).booleanValue()) continue;
                    return Boolean.TRUE;
                }
                return bl;
            }

            public Boolean visit(Sequence sequence) {
                if (!this.isLast) {
                    return Boolean.FALSE;
                }
                Iterator<Element> iterator = sequence.elements.iterator();
                while (iterator.hasNext()) {
                    boolean bl2 = this.isLast = !iterator.hasNext();
                    if (!((Boolean)this.dispatch(iterator.next())).booleanValue()) continue;
                    this.isLast = true;
                    return Boolean.TRUE;
                }
                this.isLast = true;
                return Boolean.FALSE;
            }

            public Boolean visit(VoidedElement voidedElement) {
                return (Boolean)this.dispatch(voidedElement.element);
            }

            public Boolean visit(Binding binding) {
                return "yyValue".equals(binding.name);
            }

            public Boolean visit(StringMatch stringMatch) {
                return (Boolean)this.dispatch(stringMatch.element);
            }

            public Boolean visit(Action action) {
                return action.setsValue();
            }

            public Boolean visit(ParserAction parserAction) {
                return Boolean.TRUE;
            }

            public Boolean visit(ValueElement valueElement) {
                return Boolean.TRUE;
            }

            public Boolean visit(Element element) {
                return Boolean.FALSE;
            }
        }.dispatch(element);
    }

    public static boolean setsNullValue(List<Element> list) {
        boolean bl = false;
        for (Element element : list) {
            if (element instanceof Binding) {
                if (!"yyValue".equals(((Binding)element).name)) continue;
                return false;
            }
            if (element instanceof Action) {
                if (!((Action)element).setsValue()) continue;
                return false;
            }
            if (element instanceof NullValue) {
                bl = true;
                continue;
            }
            if (!(element instanceof ValueElement)) continue;
            return false;
        }
        return bl;
    }

    public boolean mayBeNull(Element element) {
        NonTerminal nonTerminal;
        FullProduction fullProduction;
        if (element instanceof Option) {
            return true;
        }
        return element instanceof NonTerminal && (fullProduction = this.lookup(nonTerminal = (NonTerminal)element)).getBooleanProperty("option");
    }

    public Type type(Element element) {
        switch (element.tag()) {
            case CHOICE: 
            case SEQUENCE: {
                return AST.ANY;
            }
            case REPETITION: {
                Binding binding = Analyzer.getBinding(Sequence.ensure((Element)((Repetition)element).element).elements);
                return AST.listOf(null == binding ? AST.ANY : this.type(binding.element));
            }
            case OPTION: {
                Binding binding = Analyzer.getBinding(Sequence.ensure((Element)((Option)element).element).elements);
                return null == binding ? AST.ANY : AST.markOptional(this.type(binding.element));
            }
            case VOIDED: {
                return VoidT.TYPE;
            }
            case BINDING: {
                return this.type(((Binding)element).element);
            }
            case NONTERMINAL: {
                return this.lookup((NonTerminal)((NonTerminal)element)).type.deannotate();
            }
            case CHAR_LITERAL: 
            case CHAR_CLASS: 
            case ANY_CHAR: 
            case CHAR_SWITCH: {
                return AST.CHAR;
            }
            case STRING_LITERAL: {
                return AST.STRING;
            }
            case STRING_MATCH: {
                return this.module.hasAttribute(Constants.ATT_PARSE_TREE) ? AST.NODE : AST.STRING;
            }
            case PARSE_TREE_NODE: {
                return AST.NODE;
            }
            case NULL: {
                return Wildcard.TYPE;
            }
        }
        throw new IllegalArgumentException("Unable to type " + element);
    }
}

